# coding=UTF-8
import os
from haufe.sharepoint import ConnectorLists
from haufe.sharepoint import ConnectorCopy
""" All tests are using NTLM. If you need NTLM support, please add the NTLM """
""" flag in the connector. These tests are for both Lists.asmx and Copy.asmx and """
""" will give you a rough idea of how to use this library """

""" NOTE: these tests rely on properties: Title, Description. If your list does not have these """
""" please set them in order to conduct these tests. """



""" you can put a _vti_bin url here. It will """
""" recognize Lists.asmx """
""" so: https://example.com/s/Me/_vti_bin/ OR  https://example.com/s/Me/_vti_bin/Lists.asmx """
url = ''
username = ''
password = ''
list_id = ''

if username == '' or password == '':
	print "Please set your username, password and list ids to use tests, exiting.."
	exit(1)

service = ConnectorLists(url, username, password, list_id, NTLM=False)

print "Testing for Sharepoint Lists.asmx"
print "Connecting to: {0}".format(list_id)

print "Primary key is: " + service.primary_key

title = "My Item"
description  = "Description"

title = "My Item"
desc = "Description"
## creating an item
result = service.addItems(dict(Title=title, MLOT=desc))

## reading an item
## the last item on the list
result = service.query('exact', Title=title)
last = result[0]
print "Last item created was: " + last.Title
assert(title == last.Title)


## updating an item
##
new_title = "Changed title"
res = service.updateItems(dict(ID=last.ID, Title=new_title))

print "Title updated to: " + new_title
## read the item 
## and check if the title has changed

result = service.query('exact',Title=new_title)
item = result[0]

## is the new title there?
assert(item.Title == new_title)

## adds an attachment
## to a given list item
## this time we 'attach' a JSON file

filename = 'example-attachment.json'
file = os.path.abspath("./unit/files/{0}".format(filename))

print "Testing attachment with: {0} (No overwrite)".format(file)

attachment = service.addAttachment(dict(listItemID=last.ID, fileName="A File", file=file))

print "Attachment uploaded: {0}".format(attachment.ok)

## deleting an item
##
result = service.deleteItems(last.ID)

print "Item has been deleted: " + repr(result.ok)

## lastly check if the item is still there
## just in case
result = service.query('exact', ID=last.ID)
assert(len(result) == 0)

## Copy.asmx.
## this will test file uploading to documents
## also check for overwrites

url = 'https://wss.apan.org/s/PSP/_vti_bin/'
list_id = 'Reports'

print "Testing for Sharepoint Copy.asmx"
print "Connecting to library: {0}".format(list_id)

## example of 
## a document based instance
## using copy.asmx in place of Lists.asmx
## connecting to Reports
## we need a new service to this.
## if you use a different username/password
## for this list make sure to update
## username, password and list_id


service1 = ConnectorCopy(url, username, password, list_id, NTLM=False)

## uploads a document 
## fields are the meta
## data passed
## destination can either be relative
## or absolute
## in this case we know the list id, so 
## we're going relative
## absolute would be: https://wss.apan.org/s/PSP/Reports/te_1__s1t1.jpg,
## relative: test_1.jpg

filename = 'example-document.png'
file = os.path.abspath("./unit/files/{0}".format(filename))
print "Testing file upload with file: {0} (With overwrite)".format(file)

document = service1.upload(dict(
    destinationUrl=filename,
    fields=dict(
		Name='A Document Title',
     ),
	overwrite=True,
    file=file	
))

## what happened?
## if it was good, we
## will get 'Success'
print "Item was uploaded with status: {0}, url: {1}".format(document.ok, document.url)

print "Tests are complete."