from haufe.sharepoint import Connector
import unittest
import sys
import os

class TestLists(unittest.TestCase):
	def pre(self):
		self.url = sys.argv[1] 
		self.username = sys.argv[2] 
		self.password = sys.argv[3] 
		self.list = sys.argv[4] 
		self.file = "./files/example-document.png" 
		self.title = "Test #1"
		self.description = "Description"

		self.service = Connector(self.url, self.username, self.password, self.list, NTLM=False)

	def PrimaryKey(self):
		key = self.service.primary_key
		self.assertTrue(key != None) 

	def AddItems(self):

		self.title = "Test #1"
		self.description = "Description"

		result = self.service.addItems(dict(Title=self.title, MLOT=self.description))	

		self.assertTrue(result.ok)

	def QueryItems(self):
		results = self.service.query('exact', Title=self.title)
		self.last = results[0]
		self.assertEquals(self.last.Title, self.title)

	def UpdateItems(self):
		new_title = "Test #2"

		self.service.updateItems(dict(ID=self.last.ID, Title=new_title))

		results = self.service.query('exact', ID=self.last.ID)
		result = results[0]

		self.assertEquals(result.Title, new_title)
	
	
	def DeleteItems(self):
		result = self.service.deleteItems(self.last.ID)

		self.assertEquals(result.ok, True)

	def AddAttachments(self):
		self.service.addAttachment(dict(listItemID=self.last.ID, fileName="file1", file=self.file, overwrite=True))

	def GetAttachments(self):
		self.attachments = self.service.getAttachments(self.last.ID)
		self.attachments_len = len(self.attachments.results)
		
		self.assertTrue(len(results.results) > 0)

	def DeleteAttachments(self):
		self.service.deleteAttachment(self.attachments.results[0])

		self.service.getAttachments(self.last.ID)

		self.assertTrue(len(results.results) == (self.attachments_len) - 1)

	def DeleteAttachments(self):
		self.service.deleteAttachments(self.attachments)

		self.assertTrue(len(results.results) == 0)

	def runTest(self):
		self.pre()
		fns = ['PrimaryKey', 'AddItems', 'QueryItems', 'UpdateItems', 'DeleteItems', 'AddAttachments', 'GetAttachments', 'DeleteAttachments']
		for i in fns:
			getattr(self, i)()
		
if __name__ == '__main__':
	TestLists.runTest()	
