################################################################
# haufe.testrunner
#
# (C) 2007, Haufe Mediengruppe
################################################################

"""
The database model
"""

import os
import datetime

from sqlalchemy import *
from z3c.sqlalchemy import Model
from z3c.sqlalchemy.mapper import MappedClassBase


# The model is described as an ordered dictionary.
# The entries are (tablename, some_dict) where 'some_dict'
# is a dictionary containing a key 'table' referencing a Table()
# instance and an optional key 'relationships' referencing a sequence
# of related table names. An optional mapper class can be specified through
# the 'class' key (otherwise a default mapper class will be autogenerated).


def getModel(metadata):

    model = Model()

    model.add(name='testrunner', 
              table= Table('testrunner',
                           metadata,
                           Column('id', Integer, Sequence('testrunner_id_seq'), primary_key=True),
                           Column('name', Unicode(256), index=True ),
                           Column('last_run', DateTime()),
                           ),
              relations=('run',),
              cascade='all, delete-orphan',
             )

    model.add(name='run', 
              table= Table('run',
                           metadata,
                           Column('id', Integer, Sequence('runs_id_seq'), primary_key=True),
                           Column('testrunner_id', Integer, ForeignKey('testrunner.id'), index=True),
                           Column('created', DateTime(), index=True),
                           Column('creator', String(32)),
                           Column('hostname', String(32)),
                           Column('ipaddress', String(16)),
                           Column('results_cumulated', String(32)),
                           Column('link', String(256)),
                           Column('description', TEXT),
                           Column('run_ok', Boolean, default=False),
                           ),
              relations=('result',),
              cascade='all, delete-orphan',
             )

    model.add(name='result', 
              table= Table('result',
                           metadata,
                           Column('id', Integer, Sequence('result_id_seq'), primary_key=True),
                           Column('run_id', Integer, ForeignKey('run.id'), index=True),
                           Column('module', Unicode(512), index=True),
                           Column('logfile', Unicode(512)),
                           Column('logdata', Text),
                           Column('tests_ok', Boolean, default=False, index=True),
                           Column('tests_total', Integer, default=0),
                           Column('tests_passed', Integer, default=0),
                           ),
              cascade='all, delete-orphan',
             ),

    return model
