# -*- coding: UTF-8 -*-
# vim: fileencoding=UTF-8 filetype=python ff=unix et ts=4 sw=4 sts=4 tw=120
#
# Copyright (c) 2010, Christer Sjöholm -- hcs AT furuvik DOT net
#
# Permission to use, copy, modify, and/or distribute this software for any
# purpose with or without fee is hereby granted, provided that the above
# copyright notice and this permission notice appear in all copies.
#
# THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
# WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
# MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
# ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
# WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
# ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
# OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

class ListBuilder(object):
    '''

        Add items to a list by calling the listbuilder.

        The original use was as a kind of logger.

        >>> o = ListBuilder()
        >>> o.list
        []
        >>> o(1)
        >>> o.list
        [1]
        >>> o('a')
        >>> o.list
        [1, 'a']

        >>> l = []
        >>> o = ListBuilder(l)
        >>> o('b')
        >>> l
        ['b']
        >>> l == o.list
        True
    '''
    def __init__(self, target_list=None):
        if target_list == None:
            self.list = []
        else:
            self.list = target_list

    def __call__(self, new_element):
        self.list.append(new_element)
