
from collections import namedtuple
from math import sqrt
class bfs10227(object):
  def __init__(self, bfs10231=0, bfs10232=0, width=0, height=0):
    self.bfs10231 = bfs10231
    self.bfs10232 = bfs10232
    self.bfs10234 = (bfs10231 + width)
    self.bfs10233 = (bfs10232 + height)

  @classmethod
  def bfs10237(bfs10235, width, height):
    return bfs10235(0, 0, width, height)

  @classmethod
  def bfs10240(bfs10235, bfs10236=None):
    if (bfs10236 is None):
      bfs10236 = (0, 0, 0, 0)

    return bfs10235(*bfs10236)

  @classmethod
  def bfs10243(bfs10242, bfs10241):
    return bfs10242.bfs10237(*bfs10241)

  @classmethod
  def bfs10246(bfs10244, struct):
    return bfs10244.bfs10245(struct.bfs10231, struct.bfs10232, struct.bfs10234, struct.bfs10233)

  @classmethod
  def bfs10245(bfs10235, bfs10250, bfs10247, bfs10251, bfs10253):
    return bfs10235(bfs10250, bfs10247, (bfs10251 - bfs10250), (bfs10253 - bfs10247))

  @property
  def width(self):
    return (self.bfs10234 - self.bfs10231)

  @property
  def height(self):
    return (self.bfs10233 - self.bfs10232)

  @property
  def center(self):
    return Point((self.bfs10231 + (self.width / 2)), (self.bfs10232 + (self.height / 2)))

  @property
  def bfs10254(self):
    return self.bfs10252(Point((self.bfs10234 - 1), self.center.y))

  @property
  def bfs10255(self):
    return Point(self.bfs10231, self.center.y)

  @property
  def bfs10256(self):
    return Point(self.center.x, self.bfs10232)

  @property
  def bfs10257(self):
    return self.bfs10252(Point(self.center.x, (self.bfs10233 - 1)))

  @property
  def bfs10261(self):
    return Point(self.bfs10254.x, self.bfs10256.y)

  @property
  def bfs10260(self):
    return Point(self.bfs10254.x, self.bfs10257.y)

  @property
  def bfs10262(self):
    return Point(self.bfs10255.x, self.bfs10257.y)

  @property
  def bfs10263(self):
    return Point(self.bfs10255.x, self.bfs10256.y)

  @property
  def bfs10264(self):
    if (not self):
      return 0

    return (self.width * self.height)

  def __contains__(self, bfs10266):
    return ((self.bfs10231 <= bfs10266.x < self.bfs10234) and (self.bfs10232 <= bfs10266.y < self.bfs10233))

  def translate(self, bfs10265, bfs10267):
    self.bfs10231 += bfs10265
    self.bfs10234 += bfs10265
    self.bfs10232 += bfs10267
    self.bfs10233 += bfs10267
    return self

  def bfs10252(self, bfs10270):
    return Point(min(max(bfs10270[0], self.bfs10231), max(self.bfs10231, (self.bfs10234 - 1))), min(max(bfs10270[1], self.bfs10232), max(self.bfs10232, (self.bfs10233 - 1))))

  def bfs10271(self, bfs10272):
    bfs10231 = max(self.bfs10231, bfs10272.bfs10231)
    bfs10232 = max(self.bfs10232, bfs10272.bfs10232)
    bfs10234 = min(self.bfs10234, bfs10272.bfs10234)
    bfs10233 = min(self.bfs10233, bfs10272.bfs10233)
    return (self.bfs10245(bfs10231, bfs10232, bfs10234, bfs10233) or bfs10227())

  def bfs10274(self, bfs10273):
    return bool(self.bfs10271(bfs10273))

  def bfs10275(self):
    return (slice(self.bfs10232, self.bfs10233), slice(self.bfs10231, self.bfs10234))

  def is_to_left_of(self, bfs10277):
    bfs10276 = (self.bfs10231 < bfs10277.bfs10231)
    bfs10300 = (self.bfs10232 <= bfs10277.bfs10232 < self.bfs10233)
    bfs10301 = (bfs10277.bfs10232 <= self.bfs10232 < bfs10277.bfs10233)
    return (bfs10276 and (bfs10300 or bfs10301))

  def is_to_right_of(self, bfs10303):
    return bfs10303.is_to_left_of(self)

  def is_above(self, bfs10302):
    bfs10304 = (self.bfs10232 < bfs10302.bfs10232)
    bfs10306 = (self.bfs10231 <= bfs10302.bfs10231 < self.bfs10234)
    bfs10305 = (bfs10302.bfs10231 <= self.bfs10231 < bfs10302.bfs10234)
    return (bfs10304 and (bfs10306 or bfs10305))

  def is_below(self, bfs10307):
    return bfs10307.is_above(self)

  def bfs10312(self, bfs10311, bfs10310):
    return getattr(self, ('is_' + bfs10311))(bfs10310)

  def bfs10323(self, bfs10314):
    bfs10313 = (self if (self.bfs10231 < bfs10314.bfs10231) else bfs10314)

    bfs10315 = (self if (bfs10313 == bfs10314) else bfs10314)

    bfs10317 = max(0, (bfs10315.bfs10231 - bfs10313.bfs10234))
    bfs10316 = (self if (self.bfs10232 < bfs10314.bfs10232) else bfs10314)

    bfs10320 = (self if (bfs10316 == bfs10314) else bfs10314)

    bfs10321 = max(0, (bfs10320.bfs10232 - bfs10316.bfs10233))
    return sqrt(((bfs10317 ** 2) + (bfs10321 ** 2)))

  def __eq__(self, bfs10322):
    if (not isinstance(bfs10322, bfs10227)):
      return False

    return ((self.bfs10231 == bfs10322.bfs10231) and (self.bfs10232 == bfs10322.bfs10232) and (self.bfs10234 == bfs10322.bfs10234) and (self.bfs10233 == bfs10322.bfs10233))

  def __ne__(self, bfs10324):
    return (not self.__eq__(bfs10324))

  def __bool__(self):
    return bool(((self.width > 0) and (self.height > 0)))

  def __repr__(self):
    return (type(self).__name__ + ('(left=%d, top=%d, width=%d, height=%d)' % (self.bfs10231, self.bfs10232, self.width, self.height)))

  def __hash__(self):
    return (((self.bfs10231 + (7 * self.bfs10232)) + (11 * self.bfs10234)) + (13 * self.bfs10233))


class Point(namedtuple('Point', ['x', 'y'])):
  def __new__(bfs10325, x=0, y=0):
    return bfs10325.__bases__[0].__new__(bfs10325, x, y)

  def __init__(self, x=0, y=0):
    pass

  @classmethod
  def bfs10326(bfs10235, bfs10327):
    return bfs10235(*bfs10327)

  def __eq__(self, bfs10330):
    return ((self.x, self.y) == bfs10330)

  def __ne__(self, bfs10332):
    return (not (self == bfs10332))

  def __add__(self, bfs10331):
    (bfs10333, bfs10334) = bfs10331
    return Point((self.x + bfs10333), (self.y + bfs10334))

  def __radd__(self, bfs10335):
    return self.__add__(bfs10335)

  def __sub__(self, bfs10337):
    (bfs10336, bfs10340) = bfs10337
    return Point((self.x - bfs10336), (self.y - bfs10340))

  def __rsub__(self, bfs10342):
    (x, y) = bfs10342
    (bfs10341, bfs10343) = self
    return Point((x - bfs10341), (y - bfs10343))

  def __mul__(self, bfs10345):
    if isinstance(bfs10345, int):
      return Point((self.x * bfs10345), (self.y * bfs10345))
    else:
      raise ValueError('Invalid argument')


  def __rmul__(self, bfs10344):
    return self.__mul__(bfs10344)

  def __div__(self, bfs10346):
    if isinstance(bfs10346, int):
      return Point((self.x / bfs10346), (self.y / bfs10346))
    else:
      raise ValueError('Invalid argument')


  def __bool__(self):
    return (bool(self.x) or bool(self.y))


class bfs10347(object):
  def __init__(self, bfs10351):
    self.bfs10351 = bfs10351

  def bfs10354(self, bfs10350, bfs10352):
    for offset in bfs10352:
      yield (bfs10350 + (offset * self.bfs10351))


  def bfs10353(self):
    return bool(self.bfs10351.x)

  def bfs10355(self):
    return (not self.bfs10353())

  @property
  def bfs10357(self):
    return Point((-self.bfs10351[1]), self.bfs10351[0])

  def __eq__(self, bfs10356):
    return (self.bfs10351 == bfs10356.bfs10351)

  def __repr__(self):
    for bfs10360 in dir(self.__module__):
      if (self == getattr(self.__module__, bfs10360)):
        return bfs10360




bfs10361 = bfs10347(Point(0, (-1)))
bfs10362 = bfs10347(Point(1, 0))
bfs10364 = bfs10347(Point(0, 1))
bfs10363 = bfs10347(Point((-1), 0))
