from helium.bfs10052 import bfs10055
from logging import getLogger, Formatter
from logging.handlers import RotatingFileHandler
from os.path import join, basename, dirname, exists
import sys
if (sys.version_info >= (2, 7)):
  from logging import NullHandler
else:
  from logging import Handler
  class NullHandler(Handler):
    def emit(self, bfs10066):
      pass



bfs10067 = '%(asctime)s [%(name)s] [%(levelname)s] - %(message)s'
def bfs10016():
  bfs10071 = getLogger('helium')
  try:
    bfs10070 = RotatingFileHandler(bfs10072(), maxBytes=((10 * 1024) * 1024), backupCount=3)
  except IOError:
    bfs10070 = NullHandler()

  bfs10070.setFormatter(Formatter(bfs10067))
  bfs10071.addHandler(bfs10070)
  bfs10073 = getLogger('bfs')
  bfs10073.addHandler(bfs10070)

def bfs10072():
  bfs10075 = dirname(__file__)
  bfs10074 = join(bfs10075, 'data')
  if (bfs10055() or (not exists(bfs10074))):
    bfs10074 = bfs10075

  return join(bfs10074, 'helium.log')

def bfs10076():
  return basename(bfs10072())

