from hashlib import md5
from uuid import getnode
from platform import node as bfs11175, machine, system as bfs11177
from getpass import getuser
from _socket import gethostname
from ctypes import c_ulonglong, byref
import os, platform, ctypes, sys
if hasattr(os, 'statvfs'):
  def bfs11200(path):
    bfs11176 = os.statvfs(path)
    return (bfs11176.f_blocks * bfs11176.f_frsize)

elif (os.name == 'nt'):
  def bfs11200(path):
    (bfs11202, bfs11201, bfs11203) = (c_ulonglong(), c_ulonglong(), c_ulonglong())
    if ((sys.version_info >= (3,)) or isinstance(path, str)):
      bfs11205 = ctypes.windll.kernel32.GetDiskFreeSpaceExW
    else:
      bfs11205 = ctypes.windll.kernel32.GetDiskFreeSpaceExA

    bfs11204 = bfs11205(path, byref(bfs11202), byref(bfs11201), byref(bfs11203))
    if (bfs11204 == 0):
      raise ctypes.WinError()

    return bfs11201.value


class bfs11206(object):
  def __init__(self):
    self.bfs11210 = None

  def bfs10212(self):
    if (self.bfs11210 is None):
      self.bfs11210 = self.bfs11207()

    return self.bfs11210

  def bfs11211(self):
    return (bfs11175() or gethostname() or 'unknown')

  def bfs11207(self):
    bfs11212 = (str(getnode()) + bfs11175())
    return md5(bfs11212.encode('ASCII')).hexdigest()

  def bfs11213(self):
    return self.bfs10212()

  def bfs11214(self):
    return self.bfs10212()

  def bfs11215(self):
    return self.bfs10212()

  def bfs10215(self):
    os = bfs11177().lower()
    if (('darwin' in os) or ('mac' in os)):
      return 'OSX'

    if ('nux' in os):
      return 'Linux'

    if (('win' in os) or ('cygwin' in os)):
      return 'Windows'

    return 'Unknown'

  def bfs10214(self):
    if (self.bfs10215() == 'OSX'):
      return platform.mac_ver()[0]

    return platform.release()

  def bfs10216(self):
    bfs11217 = ('C:\\' if (os.name == 'nt') else '/')

    return bfs11200(bfs11217)

  def bfs10220(self):
    return str('{:x}'.format(getnode()))

  def bfs10217(self):
    return bfs11175()

  def bfs10221(self):
    return machine()

  def bfs10222(self):
    return getuser()


