from helium.bfs10050 import bfs10053
from logging import getLogger, Formatter
from logging.handlers import RotatingFileHandler
from os.path import join, basename, dirname, exists
import sys
if (sys.version_info >= (2, 7)):
  from logging import NullHandler
else:
  from logging import Handler
  class NullHandler(Handler):
    def emit(self, bfs10064):
      pass



bfs10066 = '%(asctime)s [%(name)s] [%(levelname)s] - %(message)s'
def bfs10014():
  bfs10067 = getLogger('helium')
  try:
    bfs10071 = RotatingFileHandler(bfs10070(), maxBytes=((10 * 1024) * 1024), backupCount=3)
  except IOError:
    bfs10071 = NullHandler()

  bfs10071.setFormatter(Formatter(bfs10066))
  bfs10067.addHandler(bfs10071)
  bfs10072 = getLogger('bfs')
  bfs10072.addHandler(bfs10071)

def bfs10070():
  bfs10073 = dirname(__file__)
  bfs10075 = join(bfs10073, 'data')
  if (bfs10053() or (not exists(bfs10075))):
    bfs10075 = bfs10073

  return join(bfs10075, 'helium.log')

def bfs10074():
  return basename(bfs10070())

