
from collections import namedtuple
from math import sqrt
class bfs10235(object):
  def __init__(self, bfs10237=0, bfs10236=0, width=0, height=0):
    self.bfs10237 = bfs10237
    self.bfs10236 = bfs10236
    self.bfs10240 = (bfs10237 + width)
    self.bfs10242 = (bfs10236 + height)

  @classmethod
  def bfs10243(bfs10241, width, height):
    return bfs10241(0, 0, width, height)

  @classmethod
  def bfs10245(bfs10241, bfs10244=None):
    if (bfs10244 is None):
      bfs10244 = (0, 0, 0, 0)

    return bfs10241(*bfs10244)

  @classmethod
  def bfs10247(bfs10246, bfs10250):
    return bfs10246.bfs10243(*bfs10250)

  @classmethod
  def bfs10252(bfs10251, struct):
    return bfs10251.bfs10253(struct.bfs10237, struct.bfs10236, struct.bfs10240, struct.bfs10242)

  @classmethod
  def bfs10253(bfs10241, bfs10254, bfs10255, bfs10256, bfs10257):
    return bfs10241(bfs10254, bfs10255, (bfs10256 - bfs10254), (bfs10257 - bfs10255))

  @property
  def width(self):
    return (self.bfs10240 - self.bfs10237)

  @property
  def height(self):
    return (self.bfs10242 - self.bfs10236)

  @property
  def center(self):
    return Point((self.bfs10237 + (self.width / 2)), (self.bfs10236 + (self.height / 2)))

  @property
  def bfs10260(self):
    return self.bfs10261(Point((self.bfs10240 - 1), self.center.y))

  @property
  def bfs10262(self):
    return Point(self.bfs10237, self.center.y)

  @property
  def bfs10263(self):
    return Point(self.center.x, self.bfs10236)

  @property
  def bfs10264(self):
    return self.bfs10261(Point(self.center.x, (self.bfs10242 - 1)))

  @property
  def bfs10266(self):
    return Point(self.bfs10260.x, self.bfs10263.y)

  @property
  def bfs10265(self):
    return Point(self.bfs10260.x, self.bfs10264.y)

  @property
  def bfs10267(self):
    return Point(self.bfs10262.x, self.bfs10264.y)

  @property
  def bfs10270(self):
    return Point(self.bfs10262.x, self.bfs10263.y)

  @property
  def bfs10272(self):
    if (not self):
      return 0

    return (self.width * self.height)

  def __contains__(self, bfs10271):
    return ((self.bfs10237 <= bfs10271.x < self.bfs10240) and (self.bfs10236 <= bfs10271.y < self.bfs10242))

  def translate(self, bfs10273, bfs10274):
    self.bfs10237 += bfs10273
    self.bfs10240 += bfs10273
    self.bfs10236 += bfs10274
    self.bfs10242 += bfs10274
    return self

  def bfs10261(self, bfs10275):
    return Point(min(max(bfs10275[0], self.bfs10237), max(self.bfs10237, (self.bfs10240 - 1))), min(max(bfs10275[1], self.bfs10236), max(self.bfs10236, (self.bfs10242 - 1))))

  def bfs10276(self, bfs10277):
    bfs10237 = max(self.bfs10237, bfs10277.bfs10237)
    bfs10236 = max(self.bfs10236, bfs10277.bfs10236)
    bfs10240 = min(self.bfs10240, bfs10277.bfs10240)
    bfs10242 = min(self.bfs10242, bfs10277.bfs10242)
    return (self.bfs10253(bfs10237, bfs10236, bfs10240, bfs10242) or bfs10235())

  def bfs10301(self, bfs10300):
    return bool(self.bfs10276(bfs10300))

  def bfs10303(self):
    return (slice(self.bfs10236, self.bfs10242), slice(self.bfs10237, self.bfs10240))

  def is_to_left_of(self, bfs10302):
    bfs10304 = (self.bfs10237 < bfs10302.bfs10237)
    bfs10306 = (self.bfs10236 <= bfs10302.bfs10236 < self.bfs10242)
    bfs10305 = (bfs10302.bfs10236 <= self.bfs10236 < bfs10302.bfs10242)
    return (bfs10304 and (bfs10306 or bfs10305))

  def is_to_right_of(self, bfs10307):
    return bfs10307.is_to_left_of(self)

  def is_above(self, bfs10311):
    bfs10310 = (self.bfs10236 < bfs10311.bfs10236)
    bfs10312 = (self.bfs10237 <= bfs10311.bfs10237 < self.bfs10240)
    bfs10314 = (bfs10311.bfs10237 <= self.bfs10237 < bfs10311.bfs10240)
    return (bfs10310 and (bfs10312 or bfs10314))

  def is_below(self, bfs10313):
    return bfs10313.is_above(self)

  def bfs10316(self, bfs10315, bfs10317):
    return getattr(self, ('is_' + bfs10315))(bfs10317)

  def bfs10326(self, bfs10320):
    bfs10321 = (self if (self.bfs10237 < bfs10320.bfs10237) else bfs10320)

    bfs10323 = (self if (bfs10321 == bfs10320) else bfs10320)

    bfs10322 = max(0, (bfs10323.bfs10237 - bfs10321.bfs10240))
    bfs10324 = (self if (self.bfs10236 < bfs10320.bfs10236) else bfs10320)

    bfs10325 = (self if (bfs10324 == bfs10320) else bfs10320)

    bfs10327 = max(0, (bfs10325.bfs10236 - bfs10324.bfs10242))
    return sqrt(((bfs10322 ** 2) + (bfs10327 ** 2)))

  def __eq__(self, bfs10330):
    if (not isinstance(bfs10330, bfs10235)):
      return False

    return ((self.bfs10237 == bfs10330.bfs10237) and (self.bfs10236 == bfs10330.bfs10236) and (self.bfs10240 == bfs10330.bfs10240) and (self.bfs10242 == bfs10330.bfs10242))

  def __ne__(self, bfs10332):
    return (not self.__eq__(bfs10332))

  def __bool__(self):
    return bool(((self.width > 0) and (self.height > 0)))

  def __repr__(self):
    return (type(self).__name__ + ('(left=%d, top=%d, width=%d, height=%d)' % (self.bfs10237, self.bfs10236, self.width, self.height)))

  def __hash__(self):
    return (((self.bfs10237 + (7 * self.bfs10236)) + (11 * self.bfs10240)) + (13 * self.bfs10242))


class Point(namedtuple('Point', ['x', 'y'])):
  def __new__(bfs10331, x=0, y=0):
    return bfs10331.__bases__[0].__new__(bfs10331, x, y)

  def __init__(self, x=0, y=0):
    pass

  @classmethod
  def bfs10334(bfs10241, bfs10333):
    return bfs10241(*bfs10333)

  def __eq__(self, bfs10335):
    return ((self.x, self.y) == bfs10335)

  def __ne__(self, bfs10337):
    return (not (self == bfs10337))

  def __add__(self, bfs10336):
    (bfs10340, bfs10342) = bfs10336
    return Point((self.x + bfs10340), (self.y + bfs10342))

  def __radd__(self, bfs10341):
    return self.__add__(bfs10341)

  def __sub__(self, bfs10343):
    (bfs10345, bfs10344) = bfs10343
    return Point((self.x - bfs10345), (self.y - bfs10344))

  def __rsub__(self, bfs10346):
    (x, y) = bfs10346
    (bfs10347, bfs10351) = self
    return Point((x - bfs10347), (y - bfs10351))

  def __mul__(self, bfs10350):
    if isinstance(bfs10350, int):
      return Point((self.x * bfs10350), (self.y * bfs10350))
    else:
      raise ValueError('Invalid argument')


  def __rmul__(self, bfs10352):
    return self.__mul__(bfs10352)

  def __div__(self, bfs10354):
    if isinstance(bfs10354, int):
      return Point((self.x / bfs10354), (self.y / bfs10354))
    else:
      raise ValueError('Invalid argument')


  def __bool__(self):
    return (bool(self.x) or bool(self.y))


class bfs10353(object):
  def __init__(self, bfs10355):
    self.bfs10355 = bfs10355

  def bfs10360(self, bfs10357, bfs10356):
    for offset in bfs10356:
      yield (bfs10357 + (offset * self.bfs10355))


  def bfs10361(self):
    return bool(self.bfs10355.x)

  def bfs10362(self):
    return (not self.bfs10361())

  @property
  def bfs10364(self):
    return Point((-self.bfs10355[1]), self.bfs10355[0])

  def __eq__(self, bfs10363):
    return (self.bfs10355 == bfs10363.bfs10355)

  def __repr__(self):
    for bfs10365 in dir(self.__module__):
      if (self == getattr(self.__module__, bfs10365)):
        return bfs10365




bfs10367 = bfs10353(Point(0, (-1)))
bfs10366 = bfs10353(Point(1, 0))
bfs10370 = bfs10353(Point(0, 1))
bfs10371 = bfs10353(Point((-1), 0))
