from hashlib import md5
from uuid import getnode
from platform import node as bfs11177, machine, system as bfs11176
from getpass import getuser
from _socket import gethostname
from ctypes import c_ulonglong, byref
import os, platform, ctypes, sys
if hasattr(os, 'statvfs'):
  def bfs11202(path):
    bfs11200 = os.statvfs(path)
    return (bfs11200.f_blocks * bfs11200.f_frsize)

elif (os.name == 'nt'):
  def bfs11202(path):
    (bfs11201, bfs11203, bfs11205) = (c_ulonglong(), c_ulonglong(), c_ulonglong())
    if ((sys.version_info >= (3,)) or isinstance(path, unicode)):
      bfs11204 = ctypes.windll.kernel32.GetDiskFreeSpaceExW
    else:
      bfs11204 = ctypes.windll.kernel32.GetDiskFreeSpaceExA

    bfs11206 = bfs11204(path, byref(bfs11201), byref(bfs11203), byref(bfs11205))
    if (bfs11206 == 0):
      raise ctypes.WinError()

    return bfs11203.value


class bfs11210(object):
  def __init__(self):
    self.bfs11207 = None

  def bfs10212(self):
    if (self.bfs11207 is None):
      self.bfs11207 = self.bfs11211()

    return self.bfs11207

  def bfs11212(self):
    return (bfs11177() or gethostname() or 'unknown')

  def bfs11211(self):
    bfs11213 = (str(getnode()) + bfs11177())
    return md5(bfs11213.encode('ASCII')).hexdigest()

  def bfs11214(self):
    return self.bfs10212()

  def bfs11215(self):
    return self.bfs10212()

  def bfs11217(self):
    return self.bfs10212()

  def bfs10215(self):
    os = bfs11176().lower()
    if (('darwin' in os) or ('mac' in os)):
      return 'OSX'

    if ('nux' in os):
      return 'Linux'

    if (('win' in os) or ('cygwin' in os)):
      return 'Windows'

    return 'Unknown'

  def bfs10214(self):
    if (self.bfs10215() == 'OSX'):
      return platform.mac_ver()[0]

    return platform.release()

  def bfs10216(self):
    bfs11216 = ('C:\\' if (os.name == 'nt') else '/')

    return bfs11202(bfs11216)

  def bfs10220(self):
    return str('{:x}'.format(getnode()))

  def bfs10217(self):
    return bfs11177()

  def bfs10221(self):
    return machine()

  def bfs10222(self):
    return getuser()


