from __future__ import absolute_import
from collections import namedtuple
from math import sqrt
class bfs10177(object):
  def __init__(self, bfs10201=0, bfs10202=0, width=0, height=0):
    self.bfs10201 = bfs10201
    self.bfs10202 = bfs10202
    self.bfs10204 = (bfs10201 + width)
    self.bfs10203 = (bfs10202 + height)

  @classmethod
  def bfs10205(bfs10056, width, height):
    return bfs10056(0, 0, width, height)

  @classmethod
  def bfs10207(bfs10056, bfs10206=None):
    if (bfs10206 is None):
      bfs10206 = (0, 0, 0, 0)

    return bfs10056(*bfs10206)

  @classmethod
  def bfs10212(bfs10056, bfs10210):
    return bfs10056.bfs10205(*bfs10210)

  @classmethod
  def bfs10213(bfs10056, struct):
    return bfs10056.bfs10211(struct.bfs10201, struct.bfs10202, struct.bfs10204, struct.bfs10203)

  @classmethod
  def bfs10211(bfs10056, bfs10201, bfs10202, bfs10204, bfs10203):
    return bfs10056(bfs10201, bfs10202, (bfs10204 - bfs10201), (bfs10203 - bfs10202))

  @property
  def width(self):
    return (self.bfs10204 - self.bfs10201)

  @property
  def height(self):
    return (self.bfs10203 - self.bfs10202)

  @property
  def center(self):
    return Point((self.bfs10201 + (self.width / 2)), (self.bfs10202 + (self.height / 2)))

  @property
  def bfs10214(self):
    return self.bfs10215(Point((self.bfs10204 - 1), self.center.y))

  @property
  def bfs10216(self):
    return Point(self.bfs10201, self.center.y)

  @property
  def bfs10220(self):
    return Point(self.center.x, self.bfs10202)

  @property
  def bfs10217(self):
    return self.bfs10215(Point(self.center.x, (self.bfs10203 - 1)))

  @property
  def bfs10221(self):
    return Point(self.bfs10214.x, self.bfs10220.y)

  @property
  def bfs10222(self):
    return Point(self.bfs10214.x, self.bfs10217.y)

  @property
  def bfs10223(self):
    return Point(self.bfs10216.x, self.bfs10217.y)

  @property
  def bfs10225(self):
    return Point(self.bfs10216.x, self.bfs10220.y)

  @property
  def bfs10224(self):
    if (not self):
      return 0

    return (self.width * self.height)

  def __contains__(self, bfs10226):
    return ((self.bfs10201 <= bfs10226.x < self.bfs10204) and (self.bfs10202 <= bfs10226.y < self.bfs10203))

  def translate(self, bfs10230, bfs10227):
    self.bfs10201 += bfs10230
    self.bfs10204 += bfs10230
    self.bfs10202 += bfs10227
    self.bfs10203 += bfs10227
    return self

  def bfs10215(self, bfs10226):
    return Point(min(max(bfs10226[0], self.bfs10201), max(self.bfs10201, (self.bfs10204 - 1))), min(max(bfs10226[1], self.bfs10202), max(self.bfs10202, (self.bfs10203 - 1))))

  def bfs10232(self, bfs10231):
    bfs10201 = max(self.bfs10201, bfs10231.bfs10201)
    bfs10202 = max(self.bfs10202, bfs10231.bfs10202)
    bfs10204 = min(self.bfs10204, bfs10231.bfs10204)
    bfs10203 = min(self.bfs10203, bfs10231.bfs10203)
    return (self.bfs10211(bfs10201, bfs10202, bfs10204, bfs10203) or bfs10177())

  def bfs10234(self, bfs10231):
    return bool(self.bfs10232(bfs10231))

  def bfs10233(self):
    return (slice(self.bfs10202, self.bfs10203), slice(self.bfs10201, self.bfs10204))

  def is_to_left_of(self, bfs10235):
    bfs10237 = (self.bfs10201 < bfs10235.bfs10201)
    bfs10236 = (self.bfs10202 <= bfs10235.bfs10202 < self.bfs10203)
    bfs10240 = (bfs10235.bfs10202 <= self.bfs10202 < bfs10235.bfs10203)
    return (bfs10237 and (bfs10236 or bfs10240))

  def is_to_right_of(self, bfs10235):
    return bfs10235.is_to_left_of(self)

  def is_above(self, bfs10235):
    bfs10242 = (self.bfs10202 < bfs10235.bfs10202)
    bfs10241 = (self.bfs10201 <= bfs10235.bfs10201 < self.bfs10204)
    bfs10243 = (bfs10235.bfs10201 <= self.bfs10201 < bfs10235.bfs10204)
    return (bfs10242 and (bfs10241 or bfs10243))

  def is_below(self, bfs10235):
    return bfs10235.is_above(self)

  def bfs10246(self, bfs10244, bfs10245):
    return getattr(self, ('is_' + bfs10244))(bfs10245)

  def bfs10255(self, bfs10235):
    bfs10250 = (self if (self.bfs10201 < bfs10235.bfs10201) else bfs10235)

    bfs10247 = (self if (bfs10250 == bfs10235) else bfs10235)

    bfs10251 = max(0, (bfs10247.bfs10201 - bfs10250.bfs10204))
    bfs10253 = (self if (self.bfs10202 < bfs10235.bfs10202) else bfs10235)

    bfs10252 = (self if (bfs10253 == bfs10235) else bfs10235)

    bfs10254 = max(0, (bfs10252.bfs10202 - bfs10253.bfs10203))
    return sqrt(((bfs10251 ** 2) + (bfs10254 ** 2)))

  def __eq__(self, bfs10235):
    if (not isinstance(bfs10235, bfs10177)):
      return False

    return ((self.bfs10201 == bfs10235.bfs10201) and (self.bfs10202 == bfs10235.bfs10202) and (self.bfs10204 == bfs10235.bfs10204) and (self.bfs10203 == bfs10235.bfs10203))

  def __ne__(self, bfs10235):
    return (not self.__eq__(bfs10235))

  def __nonzero__(self):
    return bool(((self.width > 0) and (self.height > 0)))

  def __repr__(self):
    return (type(self).__name__ + ('(left=%d, top=%d, width=%d, height=%d)' % (self.bfs10201, self.bfs10202, self.width, self.height)))

  def __hash__(self):
    return (((self.bfs10201 + (7 * self.bfs10202)) + (11 * self.bfs10204)) + (13 * self.bfs10203))


class Point(namedtuple('Point', ['x', 'y'])):
  def __new__(bfs10056, x=0, y=0):
    return bfs10056.__bases__[0].__new__(bfs10056, x, y)

  def __init__(self, x=0, y=0):
    pass

  @classmethod
  def bfs10257(bfs10056, bfs10256):
    return bfs10056(*bfs10256)

  def __eq__(self, bfs10235):
    return ((self.x, self.y) == bfs10235)

  def __ne__(self, bfs10235):
    return (not (self == bfs10235))

  def __add__(self, bfs10235):
    (bfs10230, bfs10227) = bfs10235
    return Point((self.x + bfs10230), (self.y + bfs10227))

  def __radd__(self, bfs10235):
    return self.__add__(bfs10235)

  def __sub__(self, bfs10235):
    (bfs10230, bfs10227) = bfs10235
    return Point((self.x - bfs10230), (self.y - bfs10227))

  def __rsub__(self, bfs10235):
    (x, y) = bfs10235
    (bfs10230, bfs10227) = self
    return Point((x - bfs10230), (y - bfs10227))

  def __mul__(self, bfs10261):
    if isinstance(bfs10261, int):
      return Point((self.x * bfs10261), (self.y * bfs10261))
    else:
      raise ValueError('Invalid argument')


  def __rmul__(self, bfs10261):
    return self.__mul__(bfs10261)

  def __div__(self, bfs10261):
    if isinstance(bfs10261, int):
      return Point((self.x / bfs10261), (self.y / bfs10261))
    else:
      raise ValueError('Invalid argument')


  def __nonzero__(self):
    return (bool(self.x) or bool(self.y))


class bfs10260(object):
  def __init__(self, bfs10262):
    self.bfs10262 = bfs10262

  def bfs10264(self, bfs10226, bfs10263):
    for offset in bfs10263:
      yield (bfs10226 + (offset * self.bfs10262))


  def bfs10266(self):
    return bool(self.bfs10262.x)

  def bfs10265(self):
    return (not self.bfs10266())

  @property
  def bfs10267(self):
    return Point((-self.bfs10262[1]), self.bfs10262[0])

  def __eq__(self, bfs10235):
    return (self.bfs10262 == bfs10235.bfs10262)

  def __repr__(self):
    for bfs10270 in dir(self.__module__):
      if (self == getattr(self.__module__, bfs10270)):
        return bfs10270




bfs10272 = bfs10260(Point(0, (-1)))
bfs10271 = bfs10260(Point(1, 0))
bfs10273 = bfs10260(Point(0, 1))
bfs10274 = bfs10260(Point((-1), 0))
