from base64 import b64decode
from bfs.bfs10101.bfs10102 import bfs10106
from bfs.bfs10060.bfs10643 import bfs10653, bfs10646
from datetime import date, datetime
from math import ceil, log
from os import path
from pkcs1 import rsaes_oaep
from pkcs1.keys import RsaPrivateKey
bfs10652 = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz-/'
class bfs10654(object):
  bfs10656 = 32
  def __init__(self, bfs10156, code, bfs10655=None, encrypted_node_identifier='', bfs10154=True, is_online=True, bfs10657=False, bfs10660=None, bfs10661=None):
    self.bfs10156 = bfs10156
    self.code = code
    self.bfs10655 = bfs10655
    self.encrypted_node_identifier = encrypted_node_identifier
    self.bfs10154 = bfs10154
    self.is_online = is_online
    self.bfs10657 = bfs10657
    self.bfs10660 = bfs10660
    self.bfs10661 = bfs10661

  @property
  def bfs10662(self):
    if (not self.encrypted_node_identifier):
      return self.encrypted_node_identifier

    return self.decrypt(self.encrypted_node_identifier)

  @classmethod
  def decrypt(bfs10056, bfs10663):
    n = 126552595132100767496431298900695851144633929478317947845463894147101930730111564183119259440078050133900835449855213073742144369102834189244736695982848189036861833523332376016102290780726072320885243610990871511351145548702602510026707584848724238826408910261032648966390926399187028038467973734166869523139
    d = 47620634886441811911279006701406234418386824768677219155850665937740218712105852942916277172463872230223057250543653350192334441406304742984336354420144630234029397102707344769401491936717749314553261859131919096126529291266317948550850549782633820140042213874431692820120174629881124487475541748108487115593
    bfs10665 = RsaPrivateKey(n, d)
    return rsaes_oaep.decrypt(bfs10665, b64decode(bfs10663))

  def bfs10666(self, bfs10664=None):
    if (not self.bfs10657):
      return False

    return (self.bfs10660 < (date.today() if (bfs10664 is None) else bfs10664)
)

  def bfs10670(self):
    return bool(self.encrypted_node_identifier)

  def bfs10667(self, encrypted_node_identifier):
    try:
      self.decrypt(encrypted_node_identifier)
    except:
      raise ValueError(('Not a valid encrypted node identifier: %s' % encrypted_node_identifier))

    if self.bfs10154:
      self.encrypted_node_identifier = encrypted_node_identifier



class bfs10671(object):
  def __init__(self, file_path, bfs10672=None):
    if (bfs10672 is None):
      bfs10672 = []

    self.file_path = file_path
    self.bfs10672 = bfs10672

  def read(self):
    (bfs10156, key) = self.bfs10674()
    bfs10673 = bfs10675(self.bfs10672)
    bfs10063 = bfs10673.parse(bfs10156, key)
    bfs10063.bfs10655 = self.bfs10655
    return bfs10063

  def bfs10674(self):
    with open(self.file_path, 'r') as bfs10677:
      bfs10156 = bfs10677.readline().rstrip()
      key = bfs10677.readline().rstrip()
      if ((not bfs10156) or (not key)):
        raise bfs10106()

      return (bfs10156, key)


  def write(self, bfs10150):
    with open(self.file_path, 'w') as bfs10677:
      bfs10677.write((bfs10150.bfs10156 + '\n'))
      key = bfs10150.code
      if bfs10150.bfs10154:
        key += bfs10150.encrypted_node_identifier

      bfs10677.write((key + '\n'))


  def exists(self):
    return path.exists(self.file_path)

  @property
  def bfs10655(self):
    return datetime.fromtimestamp(path.getmtime(self.file_path))


class bfs10675(object):
  def __init__(self, bfs10672=None):
    if (bfs10672 is None):
      bfs10672 = []

    self.bfs10672 = bfs10672

  def parse(self, bfs10156, key):
    code = key[:bfs10654.bfs10656]
    bfs10676 = key[bfs10654.bfs10656:]
    try:
      if (code in self.bfs10672):
        return self.bfs10700(bfs10156, code, bfs10676)
      else:
        return self.bfs10702(bfs10156, code, bfs10676)

    except ValueError:
      return bfs10654(bfs10156, code, encrypted_node_identifier=bfs10676)


  def bfs10700(self, bfs10156, code, encrypted_node_identifier):
    bfs10154 = True
    is_online = True
    bfs10657 = False
    bfs10660 = None
    try:
      bfs10661 = int(code[:1])
    except ValueError:
      bfs10661 = None

    return bfs10654(bfs10156, code, None, encrypted_node_identifier, bfs10154, is_online, bfs10657, bfs10660, bfs10661)

  def bfs10702(self, bfs10156, code, encrypted_node_identifier):
    bfs10701 = bfs10703(code)
    bfs10154 = bfs10701.bfs10154
    is_online = bfs10701.is_online
    bfs10657 = bfs10701.bfs10657
    bfs10660 = bfs10701.bfs10660
    bfs10661 = bfs10701.bfs10661
    return bfs10654(bfs10156, code, None, encrypted_node_identifier, bfs10154, is_online, bfs10657, bfs10660, bfs10661)


class bfs10705:
  bfs10704 = 0
  bfs10706 = 1
  bfs10707 = 2
  bfs10711 = 3
  bfs10710 = 4
  bfs10712 = 5
  bfs10714 = 6

class bfs10703(object):
  bfs10713 = [(bfs10705.bfs10704, 5), (bfs10705.bfs10706, 1), (bfs10705.bfs10707, 1), (bfs10705.bfs10711, 1), (bfs10705.bfs10710, 7), (bfs10705.bfs10712, 4), (bfs10705.bfs10714, 5)]
  def __init__(self, code):
    self.code = code
    bfs10715 = self.bfs10717(self.code)
    self.bfs10661 = self.bfs10716(bfs10715, bfs10705.bfs10704)
    self.is_online = (self.bfs10716(bfs10715, bfs10705.bfs10706) > 0)
    self.bfs10154 = (self.bfs10716(bfs10715, bfs10705.bfs10707) > 0)
    self.bfs10657 = (self.bfs10716(bfs10715, bfs10705.bfs10711) > 0)
    bfs10660 = None
    if self.bfs10657:
      bfs10720 = (2000 + self.bfs10716(bfs10715, bfs10705.bfs10710))
      bfs10722 = self.bfs10716(bfs10715, bfs10705.bfs10712)
      bfs10721 = self.bfs10716(bfs10715, bfs10705.bfs10714)
      bfs10660 = date(bfs10720, bfs10722, bfs10721)

    self.bfs10660 = bfs10660

  def bfs10717(self, text):
    bfs10723 = 6
    assert (len(bfs10652) == (2 ** bfs10723))
    bfs10724 = ''
    for bfs10725 in text:
      bfs10727 = bfs10646(bfs10653(bfs10725, bfs10652), '01')
      while (len(bfs10727) < bfs10723):
        bfs10727 = ('0' + bfs10727)

      bfs10724 += bfs10727

    bfs10726 = (len(text) * bfs10723)
    bfs10730 = int(ceil((log(bfs10726) / log(2))))
    bfs10731 = bfs10724[:bfs10730]
    bfs10733 = bfs10653(bfs10731, '01')
    return bfs10724[bfs10730:(bfs10730 + bfs10733)]

  def bfs10716(self, bfs10732, bfs10734):
    offset = 0
    (bfs10735, bfs10736) = list(zip(*self.bfs10713))
    bfs10740 = bfs10735.index(bfs10734)
    for index in range(0, bfs10740):
      offset += bfs10736[index]

    if (len(bfs10732) <= offset):
      return (-1)

    return bfs10653(bfs10732[offset:(offset + bfs10736[bfs10735.index(bfs10734)])], '01')


