from hashlib import md5
from uuid import getnode
from platform import node as bfs10737, machine, system as bfs10741
from getpass import getuser
from _socket import gethostname
from ctypes import c_ulonglong, byref
import os, platform, ctypes, sys
if hasattr(os, 'statvfs'):
  def bfs10744(path):
    bfs10742 = os.statvfs(path)
    return (bfs10742.f_blocks * bfs10742.f_frsize)

elif (os.name == 'nt'):
  def bfs10744(path):
    (bfs10070, bfs10743, bfs10745) = (c_ulonglong(), c_ulonglong(), c_ulonglong())
    if ((sys.version_info >= (3,)) or isinstance(path, unicode)):
      bfs10746 = ctypes.windll.kernel32.GetDiskFreeSpaceExW
    else:
      bfs10746 = ctypes.windll.kernel32.GetDiskFreeSpaceExA

    bfs10750 = bfs10746(path, byref(bfs10070), byref(bfs10743), byref(bfs10745))
    if (bfs10750 == 0):
      raise ctypes.WinError()

    return bfs10743.value


class bfs10747(object):
  def __init__(self):
    self.bfs10751 = None

  def bfs10151(self):
    if (self.bfs10751 is None):
      self.bfs10751 = self.bfs10752()

    return self.bfs10751

  def bfs10754(self):
    return (bfs10737() or gethostname() or 'unknown')

  def bfs10752(self):
    bfs10753 = (str(getnode()) + bfs10737())
    return md5(bfs10753.encode('ASCII')).hexdigest()

  def bfs10755(self):
    return self.bfs10151()

  def bfs10756(self):
    return self.bfs10151()

  def bfs10757(self):
    return self.bfs10151()

  def bfs10155(self):
    os = bfs10741().lower()
    if (('darwin' in os) or ('mac' in os)):
      return 'OSX'

    if ('nux' in os):
      return 'Linux'

    if (('win' in os) or ('cygwin' in os)):
      return 'Windows'

    return 'Unknown'

  def bfs10157(self):
    if (self.bfs10155() == 'OSX'):
      return platform.mac_ver()[0]

    return platform.release()

  def bfs10156(self):
    bfs10760 = ('C:\\' if (os.name == 'nt') else '/')

    return bfs10744(bfs10760)

  def bfs10160(self):
    return str('{:x}'.format(getnode()))

  def bfs10161(self):
    return bfs10737()

  def bfs10163(self):
    return machine()

  def bfs10162(self):
    return getuser()


