from __future__ import absolute_import
from collections import namedtuple
from math import sqrt
class bfs10175(object):
  def __init__(self, bfs10176=0, bfs10200=0, width=0, height=0):
    self.bfs10176 = bfs10176
    self.bfs10200 = bfs10200
    self.bfs10177 = (bfs10176 + width)
    self.bfs10201 = (bfs10200 + height)

  @classmethod
  def bfs10202(bfs10056, width, height):
    return bfs10056(0, 0, width, height)

  @classmethod
  def bfs10203(bfs10056, bfs10204=None):
    if (bfs10204 is None):
      bfs10204 = (0, 0, 0, 0)

    return bfs10056(*bfs10204)

  @classmethod
  def bfs10206(bfs10056, bfs10205):
    return bfs10056.bfs10202(*bfs10205)

  @classmethod
  def bfs10210(bfs10056, struct):
    return bfs10056.bfs10207(struct.bfs10176, struct.bfs10200, struct.bfs10177, struct.bfs10201)

  @classmethod
  def bfs10207(bfs10056, bfs10176, bfs10200, bfs10177, bfs10201):
    return bfs10056(bfs10176, bfs10200, (bfs10177 - bfs10176), (bfs10201 - bfs10200))

  @property
  def width(self):
    return (self.bfs10177 - self.bfs10176)

  @property
  def height(self):
    return (self.bfs10201 - self.bfs10200)

  @property
  def center(self):
    return Point((self.bfs10176 + (self.width / 2)), (self.bfs10200 + (self.height / 2)))

  @property
  def bfs10211(self):
    return self.bfs10212(Point((self.bfs10177 - 1), self.center.y))

  @property
  def bfs10213(self):
    return Point(self.bfs10176, self.center.y)

  @property
  def bfs10215(self):
    return Point(self.center.x, self.bfs10200)

  @property
  def bfs10214(self):
    return self.bfs10212(Point(self.center.x, (self.bfs10201 - 1)))

  @property
  def bfs10216(self):
    return Point(self.bfs10211.x, self.bfs10215.y)

  @property
  def bfs10220(self):
    return Point(self.bfs10211.x, self.bfs10214.y)

  @property
  def bfs10217(self):
    return Point(self.bfs10213.x, self.bfs10214.y)

  @property
  def bfs10221(self):
    return Point(self.bfs10213.x, self.bfs10215.y)

  @property
  def bfs10222(self):
    if (not self):
      return 0

    return (self.width * self.height)

  def __contains__(self, bfs10223):
    return ((self.bfs10176 <= bfs10223.x < self.bfs10177) and (self.bfs10200 <= bfs10223.y < self.bfs10201))

  def translate(self, bfs10225, bfs10224):
    self.bfs10176 += bfs10225
    self.bfs10177 += bfs10225
    self.bfs10200 += bfs10224
    self.bfs10201 += bfs10224
    return self

  def bfs10212(self, bfs10223):
    return Point(min(max(bfs10223[0], self.bfs10176), max(self.bfs10176, (self.bfs10177 - 1))), min(max(bfs10223[1], self.bfs10200), max(self.bfs10200, (self.bfs10201 - 1))))

  def bfs10230(self, bfs10226):
    bfs10176 = max(self.bfs10176, bfs10226.bfs10176)
    bfs10200 = max(self.bfs10200, bfs10226.bfs10200)
    bfs10177 = min(self.bfs10177, bfs10226.bfs10177)
    bfs10201 = min(self.bfs10201, bfs10226.bfs10201)
    return (self.bfs10207(bfs10176, bfs10200, bfs10177, bfs10201) or bfs10175())

  def bfs10227(self, bfs10226):
    return bool(self.bfs10230(bfs10226))

  def bfs10231(self):
    return (slice(self.bfs10200, self.bfs10201), slice(self.bfs10176, self.bfs10177))

  def is_to_left_of(self, bfs10232):
    bfs10234 = (self.bfs10176 < bfs10232.bfs10176)
    bfs10233 = (self.bfs10200 <= bfs10232.bfs10200 < self.bfs10201)
    bfs10235 = (bfs10232.bfs10200 <= self.bfs10200 < bfs10232.bfs10201)
    return (bfs10234 and (bfs10233 or bfs10235))

  def is_to_right_of(self, bfs10232):
    return bfs10232.is_to_left_of(self)

  def is_above(self, bfs10232):
    bfs10237 = (self.bfs10200 < bfs10232.bfs10200)
    bfs10236 = (self.bfs10176 <= bfs10232.bfs10176 < self.bfs10177)
    bfs10240 = (bfs10232.bfs10176 <= self.bfs10176 < bfs10232.bfs10177)
    return (bfs10237 and (bfs10236 or bfs10240))

  def is_below(self, bfs10232):
    return bfs10232.is_above(self)

  def bfs10243(self, bfs10242, bfs10241):
    return getattr(self, ('is_' + bfs10242))(bfs10241)

  def bfs10253(self, bfs10232):
    bfs10244 = (self if (self.bfs10176 < bfs10232.bfs10176) else bfs10232)

    bfs10245 = (self if (bfs10244 == bfs10232) else bfs10232)

    bfs10246 = max(0, (bfs10245.bfs10176 - bfs10244.bfs10177))
    bfs10250 = (self if (self.bfs10200 < bfs10232.bfs10200) else bfs10232)

    bfs10247 = (self if (bfs10250 == bfs10232) else bfs10232)

    bfs10251 = max(0, (bfs10247.bfs10200 - bfs10250.bfs10201))
    return sqrt(((bfs10246 ** 2) + (bfs10251 ** 2)))

  def __eq__(self, bfs10232):
    if (not isinstance(bfs10232, bfs10175)):
      return False

    return ((self.bfs10176 == bfs10232.bfs10176) and (self.bfs10200 == bfs10232.bfs10200) and (self.bfs10177 == bfs10232.bfs10177) and (self.bfs10201 == bfs10232.bfs10201))

  def __ne__(self, bfs10232):
    return (not self.__eq__(bfs10232))

  def __nonzero__(self):
    return bool(((self.width > 0) and (self.height > 0)))

  def __repr__(self):
    return (type(self).__name__ + ('(left=%d, top=%d, width=%d, height=%d)' % (self.bfs10176, self.bfs10200, self.width, self.height)))

  def __hash__(self):
    return (((self.bfs10176 + (7 * self.bfs10200)) + (11 * self.bfs10177)) + (13 * self.bfs10201))


class Point(namedtuple('Point', ['x', 'y'])):
  def __new__(bfs10056, x=0, y=0):
    return bfs10056.__bases__[0].__new__(bfs10056, x, y)

  def __init__(self, x=0, y=0):
    pass

  @classmethod
  def bfs10254(bfs10056, bfs10252):
    return bfs10056(*bfs10252)

  def __eq__(self, bfs10232):
    return ((self.x, self.y) == bfs10232)

  def __ne__(self, bfs10232):
    return (not (self == bfs10232))

  def __add__(self, bfs10232):
    (bfs10225, bfs10224) = bfs10232
    return Point((self.x + bfs10225), (self.y + bfs10224))

  def __radd__(self, bfs10232):
    return self.__add__(bfs10232)

  def __sub__(self, bfs10232):
    (bfs10225, bfs10224) = bfs10232
    return Point((self.x - bfs10225), (self.y - bfs10224))

  def __rsub__(self, bfs10232):
    (x, y) = bfs10232
    (bfs10225, bfs10224) = self
    return Point((x - bfs10225), (y - bfs10224))

  def __mul__(self, bfs10255):
    if isinstance(bfs10255, int):
      return Point((self.x * bfs10255), (self.y * bfs10255))
    else:
      raise ValueError('Invalid argument')


  def __rmul__(self, bfs10255):
    return self.__mul__(bfs10255)

  def __div__(self, bfs10255):
    if isinstance(bfs10255, int):
      return Point((self.x / bfs10255), (self.y / bfs10255))
    else:
      raise ValueError('Invalid argument')


  def __nonzero__(self):
    return (bool(self.x) or bool(self.y))


class bfs10256(object):
  def __init__(self, bfs10257):
    self.bfs10257 = bfs10257

  def bfs10260(self, bfs10223, bfs10261):
    for offset in bfs10261:
      yield (bfs10223 + (offset * self.bfs10257))


  def bfs10262(self):
    return bool(self.bfs10257.x)

  def bfs10263(self):
    return (not self.bfs10262())

  @property
  def bfs10264(self):
    return Point((-self.bfs10257[1]), self.bfs10257[0])

  def __eq__(self, bfs10232):
    return (self.bfs10257 == bfs10232.bfs10257)

  def __repr__(self):
    for bfs10266 in dir(self.__module__):
      if (self == getattr(self.__module__, bfs10266)):
        return bfs10266




bfs10265 = bfs10256(Point(0, (-1)))
bfs10267 = bfs10256(Point(1, 0))
bfs10270 = bfs10256(Point(0, 1))
bfs10272 = bfs10256(Point((-1), 0))
