from base64 import b64decode
from bfs.bfs10143.bfs10147 import InvalidLicenseFile
from bfs.bfs10063.bfs11134 import bfs11144, bfs11137
from datetime import date, datetime
from math import ceil, log
from os import path
from pkcs1 import rsaes_oaep
from pkcs1.keys import RsaPrivateKey
bfs11146 = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz-/'
class bfs11145(object):
  bfs11147 = 32
  def __init__(self, bfs10233, code, bfs11150=None, encrypted_node_identifier='', bfs10231=True, bfs11151=True, bfs11152=False, bfs11154=None, bfs11153=None):
    self.bfs10233 = bfs10233
    self.code = code
    self.bfs11150 = bfs11150
    self.encrypted_node_identifier = encrypted_node_identifier
    self.bfs10231 = bfs10231
    self.bfs11151 = bfs11151
    self.bfs11152 = bfs11152
    self.bfs11154 = bfs11154
    self.bfs11153 = bfs11153

  @property
  def bfs11155(self):
    if (not self.encrypted_node_identifier):
      return self.encrypted_node_identifier

    return self.decrypt(self.encrypted_node_identifier)

  @classmethod
  def decrypt(bfs11156, bfs11157):
    n = 126552595132100767496431298900695851144633929478317947845463894147101930730111564183119259440078050133900835449855213073742144369102834189244736695982848189036861833523332376016102290780726072320885243610990871511351145548702602510026707584848724238826408910261032648966390926399187028038467973734166869523139
    d = 47620634886441811911279006701406234418386824768677219155850665937740218712105852942916277172463872230223057250543653350192334441406304742984336354420144630234029397102707344769401491936717749314553261859131919096126529291266317948550850549782633820140042213874431692820120174629881124487475541748108487115593
    bfs11161 = RsaPrivateKey(n, d)
    return rsaes_oaep.decrypt(bfs11161, b64decode(bfs11157)).decode('ascii')

  def bfs11162(self, bfs11160=None):
    if (not self.bfs11152):
      return False

    return (self.bfs11154 < (date.today() if (bfs11160 is None) else bfs11160))

  def bfs11163(self):
    return bool(self.encrypted_node_identifier)

  def bfs11165(self, encrypted_node_identifier):
    try:
      self.decrypt(encrypted_node_identifier)
    except:
      raise ValueError(('Not a valid encrypted node identifier: %s' % encrypted_node_identifier))

    if self.bfs10231:
      self.encrypted_node_identifier = encrypted_node_identifier



class bfs11164(object):
  def __init__(self, file_path, bfs11166=None):
    if (bfs11166 is None):
      bfs11166 = []

    self.file_path = file_path
    self.bfs11166 = bfs11166

  def read(self):
    (bfs11170, key) = self.bfs11167()
    bfs11171 = bfs11173(self.bfs11166)
    bfs11172 = bfs11171.parse(bfs11170, key)
    bfs11172.bfs11150 = self.bfs11150
    return bfs11172

  def bfs11167(self):
    with open(self.file_path, 'r') as bfs11174:
      bfs11175 = bfs11174.readline().rstrip()
      key = bfs11174.readline().rstrip()
      if ((not bfs11175) or (not key)):
        raise InvalidLicenseFile()

      return (bfs11175, key)


  def write(self, bfs11177):
    with open(self.file_path, 'w') as bfs11176:
      bfs11176.write((bfs11177.bfs10233 + '\n'))
      key = bfs11177.code
      if bfs11177.bfs10231:
        key += bfs11177.encrypted_node_identifier

      bfs11176.write((key + '\n'))


  def exists(self):
    return path.exists(self.file_path)

  @property
  def bfs11150(self):
    return datetime.fromtimestamp(path.getmtime(self.file_path))


class bfs11173(object):
  def __init__(self, bfs11166=None):
    if (bfs11166 is None):
      bfs11166 = []

    self.bfs11166 = bfs11166

  def parse(self, bfs11200, key):
    code = key[:bfs11145.bfs11147]
    bfs11202 = key[bfs11145.bfs11147:]
    try:
      if (code in self.bfs11166):
        return self.bfs11201(bfs11200, code, bfs11202)
      else:
        return self.bfs11203(bfs11200, code, bfs11202)

    except ValueError:
      return bfs11145(bfs11200, code, encrypted_node_identifier=bfs11202)


  def bfs11201(self, bfs11205, code, encrypted_node_identifier):
    bfs11204 = True
    bfs11206 = True
    bfs11210 = False
    bfs11207 = None
    try:
      bfs11211 = int(code[:1])
    except ValueError:
      bfs11211 = None

    return bfs11145(bfs11205, code, None, encrypted_node_identifier, bfs11204, bfs11206, bfs11210, bfs11207, bfs11211)

  def bfs11203(self, bfs11212, code, encrypted_node_identifier):
    bfs11213 = bfs11214(code)
    bfs10231 = bfs11213.bfs10231
    bfs11151 = bfs11213.bfs11151
    bfs11152 = bfs11213.bfs11152
    bfs11154 = bfs11213.bfs11154
    bfs11153 = bfs11213.bfs11153
    return bfs11145(bfs11212, code, None, encrypted_node_identifier, bfs10231, bfs11151, bfs11152, bfs11154, bfs11153)


class bfs11215:
  bfs11217 = 0
  bfs11216 = 1
  bfs11220 = 2
  bfs11222 = 3
  bfs11221 = 4
  bfs11223 = 5
  bfs11224 = 6

class bfs11214(object):
  bfs11226 = [(bfs11215.bfs11217, 5), (bfs11215.bfs11216, 1), (bfs11215.bfs11220, 1), (bfs11215.bfs11222, 1), (bfs11215.bfs11221, 7), (bfs11215.bfs11223, 4), (bfs11215.bfs11224, 5)]
  def __init__(self, code):
    self.code = code
    bfs11225 = self.bfs11227(self.code)
    self.bfs11153 = self.bfs11231(bfs11225, bfs11215.bfs11217)
    self.bfs11151 = (self.bfs11231(bfs11225, bfs11215.bfs11216) > 0)
    self.bfs10231 = (self.bfs11231(bfs11225, bfs11215.bfs11220) > 0)
    self.bfs11152 = (self.bfs11231(bfs11225, bfs11215.bfs11222) > 0)
    bfs11154 = None
    if self.bfs11152:
      bfs11230 = (2000 + self.bfs11231(bfs11225, bfs11215.bfs11221))
      bfs11232 = self.bfs11231(bfs11225, bfs11215.bfs11223)
      bfs11234 = self.bfs11231(bfs11225, bfs11215.bfs11224)
      bfs11154 = date(bfs11230, bfs11232, bfs11234)

    self.bfs11154 = bfs11154

  def bfs11227(self, text):
    bfs11233 = 6
    assert (len(bfs11146) == (2 ** bfs11233))
    bfs11235 = ''
    for bfs11236 in text:
      bfs11237 = bfs11137(bfs11144(bfs11236, bfs11146), '01')
      while (len(bfs11237) < bfs11233):
        bfs11237 = ('0' + bfs11237)

      bfs11235 += bfs11237

    bfs11241 = (len(text) * bfs11233)
    bfs11240 = int(ceil((log(bfs11241) / log(2))))
    bfs11242 = bfs11235[:bfs11240]
    bfs11243 = bfs11144(bfs11242, '01')
    return bfs11235[bfs11240:(bfs11240 + bfs11243)]

  def bfs11231(self, bfs11244, bfs11246):
    offset = 0
    (bfs11245, bfs11247) = list(zip(*self.bfs11226))
    bfs11250 = bfs11245.index(bfs11246)
    for index in range(0, bfs11250):
      offset += bfs11247[index]

    if (len(bfs11244) <= offset):
      return (-1)

    return bfs11144(bfs11244[offset:(offset + bfs11247[bfs11245.index(bfs11246)])], '01')


