try:
  from collections import OrderedDict
except ImportError:
  from UserDict import DictMixin
  class OrderedDict(dict, DictMixin):
    def __init__(self, *args, **bfs11436):
      if (len(args) > 1):
        raise TypeError(('expected at most 1 arguments, got %d' % len(args)))

      try:
        self.bfs11440
      except AttributeError:
        self.clear()

      self.update(*args, **bfs11436)

    def clear(self):
      self.bfs11440 = end = []
      end += [None, end, end]
      self.bfs11437 = {}
      dict.clear(self)

    def __setitem__(self, key, value):
      if (key not in self):
        end = self.bfs11440
        bfs11441 = end[1]
        bfs11441[2] = end[1] = self.bfs11437[key] = [key, bfs11441, end]

      dict.__setitem__(self, key, value)

    def __delitem__(self, key):
      dict.__delitem__(self, key)
      (key, bfs11442, next) = self.bfs11437.pop(key)
      bfs11442[2] = next
      next[1] = bfs11442

    def __iter__(self):
      end = self.bfs11440
      bfs11444 = end[2]
      while (bfs11444 is not end):
        yield bfs11444[0]
        bfs11444 = bfs11444[2]


    def __reversed__(self):
      end = self.bfs11440
      bfs11443 = end[1]
      while (bfs11443 is not end):
        yield bfs11443[0]
        bfs11443 = bfs11443[1]


    def popitem(self, bfs11445=True):
      if (not self):
        raise KeyError('dictionary is empty')

      if bfs11445:
        key = reversed(self).next()
      else:
        key = iter(self).next()

      value = self.pop(key)
      return (key, value)

    def __reduce__(self):
      items = [[k, self[k]] for k in self]
      bfs11447 = (self.bfs11437, self.bfs11440)
      del self.bfs11437
      del self.bfs11440
      bfs11446 = vars(self).copy()
      (self.bfs11437, self.bfs11440) = bfs11447
      if bfs11446:
        return (self.__class__, (items,), bfs11446)

      return (self.__class__, (items,))

    def keys(self):
      return list(self)

    setdefault = DictMixin.setdefault
    update = DictMixin.update
    pop = DictMixin.pop
    values = DictMixin.values
    items = DictMixin.items
    iterkeys = DictMixin.iterkeys
    itervalues = DictMixin.itervalues
    iteritems = DictMixin.iteritems
    def __repr__(self):
      if (not self):
        return ('%s()' % (self.__class__.__name__,))

      return ('%s(%r)' % (self.__class__.__name__, self.items()))

    def copy(self):
      return self.__class__(self)

    @classmethod
    def fromkeys(bfs10263, bfs11450, value=None):
      d = bfs10263()
      for key in bfs11450:
        d[key] = value

      return d

    def __eq__(self, bfs11452):
      if isinstance(bfs11452, OrderedDict):
        if (len(self) != len(bfs11452)):
          return False

        for (p, bfs11451) in zip(self.items(), bfs11452.items()):
          if (p != bfs11451):
            return False


        return True

      return dict.__eq__(self, bfs11452)

    def __ne__(self, bfs11453):
      return (not (self == bfs11453))



