from __future__ import absolute_import
from collections import namedtuple
from math import sqrt
class bfs10210(object):
  def __init__(self, bfs10212=0, bfs10211=0, width=0, height=0):
    self.bfs10212 = bfs10212
    self.bfs10211 = bfs10211
    self.bfs10213 = (bfs10212 + width)
    self.bfs10215 = (bfs10211 + height)

  @classmethod
  def bfs10216(bfs10214, width, height):
    return bfs10214(0, 0, width, height)

  @classmethod
  def bfs10217(bfs10214, bfs10220=None):
    if (bfs10220 is None):
      bfs10220 = (0, 0, 0, 0)

    return bfs10214(*bfs10220)

  @classmethod
  def bfs10223(bfs10221, bfs10222):
    return bfs10221.bfs10216(*bfs10222)

  @classmethod
  def bfs10226(bfs10225, struct):
    return bfs10225.bfs10224(struct.bfs10212, struct.bfs10211, struct.bfs10213, struct.bfs10215)

  @classmethod
  def bfs10224(bfs10214, bfs10230, bfs10227, bfs10231, bfs10232):
    return bfs10214(bfs10230, bfs10227, (bfs10231 - bfs10230), (bfs10232 - bfs10227))

  @property
  def width(self):
    return (self.bfs10213 - self.bfs10212)

  @property
  def height(self):
    return (self.bfs10215 - self.bfs10211)

  @property
  def center(self):
    return Point((self.bfs10212 + (self.width / 2)), (self.bfs10211 + (self.height / 2)))

  @property
  def bfs10233(self):
    return self.bfs10234(Point((self.bfs10213 - 1), self.center.y))

  @property
  def bfs10235(self):
    return Point(self.bfs10212, self.center.y)

  @property
  def bfs10237(self):
    return Point(self.center.x, self.bfs10211)

  @property
  def bfs10236(self):
    return self.bfs10234(Point(self.center.x, (self.bfs10215 - 1)))

  @property
  def bfs10240(self):
    return Point(self.bfs10233.x, self.bfs10237.y)

  @property
  def bfs10242(self):
    return Point(self.bfs10233.x, self.bfs10236.y)

  @property
  def bfs10241(self):
    return Point(self.bfs10235.x, self.bfs10236.y)

  @property
  def bfs10243(self):
    return Point(self.bfs10235.x, self.bfs10237.y)

  @property
  def bfs10244(self):
    if (not self):
      return 0

    return (self.width * self.height)

  def __contains__(self, bfs10245):
    return ((self.bfs10212 <= bfs10245.x < self.bfs10213) and (self.bfs10211 <= bfs10245.y < self.bfs10215))

  def translate(self, bfs10246, bfs10250):
    self.bfs10212 += bfs10246
    self.bfs10213 += bfs10246
    self.bfs10211 += bfs10250
    self.bfs10215 += bfs10250
    return self

  def bfs10234(self, bfs10247):
    return Point(min(max(bfs10247[0], self.bfs10212), max(self.bfs10212, (self.bfs10213 - 1))), min(max(bfs10247[1], self.bfs10211), max(self.bfs10211, (self.bfs10215 - 1))))

  def bfs10253(self, bfs10251):
    bfs10212 = max(self.bfs10212, bfs10251.bfs10212)
    bfs10211 = max(self.bfs10211, bfs10251.bfs10211)
    bfs10213 = min(self.bfs10213, bfs10251.bfs10213)
    bfs10215 = min(self.bfs10215, bfs10251.bfs10215)
    return (self.bfs10224(bfs10212, bfs10211, bfs10213, bfs10215) or bfs10210())

  def bfs10254(self, bfs10252):
    return bool(self.bfs10253(bfs10252))

  def bfs10255(self):
    return (slice(self.bfs10211, self.bfs10215), slice(self.bfs10212, self.bfs10213))

  def is_to_left_of(self, bfs10256):
    bfs10257 = (self.bfs10212 < bfs10256.bfs10212)
    bfs10261 = (self.bfs10211 <= bfs10256.bfs10211 < self.bfs10215)
    bfs10260 = (bfs10256.bfs10211 <= self.bfs10211 < bfs10256.bfs10215)
    return (bfs10257 and (bfs10261 or bfs10260))

  def is_to_right_of(self, bfs10262):
    return bfs10262.is_to_left_of(self)

  def is_above(self, bfs10263):
    bfs10264 = (self.bfs10211 < bfs10263.bfs10211)
    bfs10266 = (self.bfs10212 <= bfs10263.bfs10212 < self.bfs10213)
    bfs10265 = (bfs10263.bfs10212 <= self.bfs10212 < bfs10263.bfs10213)
    return (bfs10264 and (bfs10266 or bfs10265))

  def is_below(self, bfs10267):
    return bfs10267.is_above(self)

  def bfs10271(self, bfs10270, bfs10272):
    return getattr(self, ('is_' + bfs10270))(bfs10272)

  def bfs10303(self, bfs10273):
    bfs10274 = (self if (self.bfs10212 < bfs10273.bfs10212) else bfs10273)
    bfs10275 = (self if (bfs10274 == bfs10273) else bfs10273)
    bfs10277 = max(0, (bfs10275.bfs10212 - bfs10274.bfs10213))
    bfs10276 = (self if (self.bfs10211 < bfs10273.bfs10211) else bfs10273)
    bfs10300 = (self if (bfs10276 == bfs10273) else bfs10273)
    bfs10301 = max(0, (bfs10300.bfs10211 - bfs10276.bfs10215))
    return sqrt(((bfs10277 ** 2) + (bfs10301 ** 2)))

  def __eq__(self, bfs10302):
    if (not isinstance(bfs10302, bfs10210)):
      return False

    return ((self.bfs10212 == bfs10302.bfs10212) and (self.bfs10211 == bfs10302.bfs10211) and (self.bfs10213 == bfs10302.bfs10213) and (self.bfs10215 == bfs10302.bfs10215))

  def __ne__(self, bfs10304):
    return (not self.__eq__(bfs10304))

  def __nonzero__(self):
    return bool(((self.width > 0) and (self.height > 0)))

  def __repr__(self):
    return (type(self).__name__ + ('(left=%d, top=%d, width=%d, height=%d)' % (self.bfs10212, self.bfs10211, self.width, self.height)))

  def __hash__(self):
    return (((self.bfs10212 + (7 * self.bfs10211)) + (11 * self.bfs10213)) + (13 * self.bfs10215))


class Point(namedtuple('Point', ['x', 'y'])):
  def __new__(bfs10306, x=0, y=0):
    return bfs10306.__bases__[0].__new__(bfs10306, x, y)

  def __init__(self, x=0, y=0):
    pass

  @classmethod
  def bfs10307(bfs10214, bfs10305):
    return bfs10214(*bfs10305)

  def __eq__(self, bfs10311):
    return ((self.x, self.y) == bfs10311)

  def __ne__(self, bfs10310):
    return (not (self == bfs10310))

  def __add__(self, bfs10312):
    (bfs10314, bfs10313) = bfs10312
    return Point((self.x + bfs10314), (self.y + bfs10313))

  def __radd__(self, bfs10315):
    return self.__add__(bfs10315)

  def __sub__(self, bfs10317):
    (bfs10316, bfs10320) = bfs10317
    return Point((self.x - bfs10316), (self.y - bfs10320))

  def __rsub__(self, bfs10321):
    (x, y) = bfs10321
    (bfs10323, bfs10322) = self
    return Point((x - bfs10323), (y - bfs10322))

  def __mul__(self, bfs10324):
    if isinstance(bfs10324, int):
      return Point((self.x * bfs10324), (self.y * bfs10324))
    else:
      raise ValueError('Invalid argument')


  def __rmul__(self, bfs10325):
    return self.__mul__(bfs10325)

  def __div__(self, bfs10327):
    if isinstance(bfs10327, int):
      return Point((self.x / bfs10327), (self.y / bfs10327))
    else:
      raise ValueError('Invalid argument')


  def __nonzero__(self):
    return (bool(self.x) or bool(self.y))


class bfs10326(object):
  def __init__(self, bfs10330):
    self.bfs10330 = bfs10330

  def bfs10333(self, bfs10332, bfs10331):
    for offset in bfs10331:
      yield (bfs10332 + (offset * self.bfs10330))


  def bfs10334(self):
    return bool(self.bfs10330.x)

  def bfs10335(self):
    return (not self.bfs10334())

  @property
  def bfs10337(self):
    return Point((-self.bfs10330[1]), self.bfs10330[0])

  def __eq__(self, bfs10336):
    return (self.bfs10330 == bfs10336.bfs10330)

  def __repr__(self):
    for bfs10340 in dir(self.__module__):
      if (self == getattr(self.__module__, bfs10340)):
        return bfs10340




bfs10342 = bfs10326(Point(0, (-1)))
bfs10341 = bfs10326(Point(1, 0))
bfs10343 = bfs10326(Point(0, 1))
bfs10345 = bfs10326(Point((-1), 0))
