from hashlib import md5
from uuid import getnode
from platform import node as bfs11162, machine, system as bfs11163
from getpass import getuser
from _socket import gethostname
from ctypes import c_ulonglong, byref
import os, platform, ctypes, sys
if hasattr(os, 'statvfs'):
  def bfs11164(path):
    bfs11165 = os.statvfs(path)
    return (bfs11165.f_blocks * bfs11165.f_frsize)

elif (os.name == 'nt'):
  def bfs11164(path):
    (bfs11166, bfs11170, bfs11167) = (c_ulonglong(), c_ulonglong(), c_ulonglong())
    if ((sys.version_info >= (3,)) or isinstance(path, unicode)):
      bfs11171 = ctypes.windll.kernel32.GetDiskFreeSpaceExW
    else:
      bfs11171 = ctypes.windll.kernel32.GetDiskFreeSpaceExA

    bfs11173 = bfs11171(path, byref(bfs11166), byref(bfs11170), byref(bfs11167))
    if (bfs11173 == 0):
      raise ctypes.WinError()

    return bfs11170.value


class bfs11172(object):
  def __init__(self):
    self.bfs11174 = None

  def bfs10164(self):
    if (self.bfs11174 is None):
      self.bfs11174 = self.bfs11175()

    return self.bfs11174

  def bfs11177(self):
    return (bfs11162() or gethostname() or 'unknown')

  def bfs11175(self):
    bfs11176 = (str(getnode()) + bfs11162())
    return md5(bfs11176.encode('ASCII')).hexdigest()

  def bfs11200(self):
    return self.bfs10164()

  def bfs11202(self):
    return self.bfs10164()

  def bfs11201(self):
    return self.bfs10164()

  def bfs10170(self):
    os = bfs11163().lower()
    if (('darwin' in os) or ('mac' in os)):
      return 'OSX'

    if ('nux' in os):
      return 'Linux'

    if (('win' in os) or ('cygwin' in os)):
      return 'Windows'

    return 'Unknown'

  def bfs10167(self):
    if (self.bfs10170() == 'OSX'):
      return platform.mac_ver()[0]

    return platform.release()

  def bfs10171(self):
    bfs11203 = ('C:\\' if (os.name == 'nt') else '/')
    return bfs11164(bfs11203)

  def bfs10172(self):
    return str('{:x}'.format(getnode()))

  def bfs10174(self):
    return bfs11162()

  def bfs10173(self):
    return machine()

  def bfs10175(self):
    return getuser()


