from hashlib import md5
from uuid import getnode
from platform import node as bfs11236, machine, system as bfs11237
from getpass import getuser
from _socket import gethostname
from ctypes import c_ulonglong, byref
import os, platform, ctypes, sys
if hasattr(os, 'statvfs'):
  def bfs11240(path):
    bfs11241 = os.statvfs(path)
    return (bfs11241.f_blocks * bfs11241.f_frsize)

elif (os.name == 'nt'):
  def bfs11240(path):
    (bfs11242, bfs11243, bfs11244) = (c_ulonglong(), c_ulonglong(), c_ulonglong())
    if ((sys.version_info >= (3,)) or isinstance(path, str)):
      bfs11246 = ctypes.windll.kernel32.GetDiskFreeSpaceExW
    else:
      bfs11246 = ctypes.windll.kernel32.GetDiskFreeSpaceExA

    bfs11245 = bfs11246(path, byref(bfs11242), byref(bfs11243), byref(bfs11244))
    if (bfs11245 == 0):
      raise ctypes.WinError()

    return bfs11243.value


class bfs11247(object):
  def __init__(self):
    self.bfs11250 = None

  def bfs10232(self):
    if (self.bfs11250 is None):
      self.bfs11250 = self.bfs11251()

    return self.bfs11250

  def bfs11253(self):
    return (bfs11236() or gethostname() or 'unknown')

  def bfs11251(self):
    bfs11252 = (str(getnode()) + bfs11236())
    return md5(bfs11252.encode('ASCII')).hexdigest()

  def bfs11254(self):
    return self.bfs10232()

  def bfs11256(self):
    return self.bfs10232()

  def bfs11255(self):
    return self.bfs10232()

  def bfs10235(self):
    os = bfs11237().lower()
    if (('darwin' in os) or ('mac' in os)):
      return 'OSX'

    if ('nux' in os):
      return 'Linux'

    if (('win' in os) or ('cygwin' in os)):
      return 'Windows'

    return 'Unknown'

  def bfs10237(self):
    if (self.bfs10235() == 'OSX'):
      return platform.mac_ver()[0]

    return platform.release()

  def bfs10236(self):
    bfs11257 = ('C:\\' if (os.name == 'nt') else '/')
    return bfs11240(bfs11257)

  def bfs10240(self):
    return str('{:x}'.format(getnode()))

  def bfs10242(self):
    return bfs11236()

  def bfs10241(self):
    return machine()

  def bfs10243(self):
    return getuser()


