from base64 import b64decode
from bfs.bfs10143.bfs10147 import InvalidLicenseFile
from bfs.bfs10063.bfs11121 import bfs11131, bfs11124
from datetime import date, datetime
from math import ceil, log
from os import path
from pkcs1 import rsaes_oaep
from pkcs1.keys import RsaPrivateKey
bfs11134 = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz-/'
class bfs11133(object):
  bfs11135 = 32
  def __init__(self, bfs10233, code, bfs11137=None, encrypted_node_identifier='', bfs10231=True, is_online=True, bfs11136=False, bfs11140=None, bfs11141=None):
    self.bfs10233 = bfs10233
    self.code = code
    self.bfs11137 = bfs11137
    self.encrypted_node_identifier = encrypted_node_identifier
    self.bfs10231 = bfs10231
    self.is_online = is_online
    self.bfs11136 = bfs11136
    self.bfs11140 = bfs11140
    self.bfs11141 = bfs11141

  @property
  def bfs11142(self):
    if (not self.encrypted_node_identifier):
      return self.encrypted_node_identifier

    return self.decrypt(self.encrypted_node_identifier)

  @classmethod
  def decrypt(bfs11143, bfs11144):
    n = 126552595132100767496431298900695851144633929478317947845463894147101930730111564183119259440078050133900835449855213073742144369102834189244736695982848189036861833523332376016102290780726072320885243610990871511351145548702602510026707584848724238826408910261032648966390926399187028038467973734166869523139L
    d = 47620634886441811911279006701406234418386824768677219155850665937740218712105852942916277172463872230223057250543653350192334441406304742984336354420144630234029397102707344769401491936717749314553261859131919096126529291266317948550850549782633820140042213874431692820120174629881124487475541748108487115593L
    bfs11146 = RsaPrivateKey(n, d)
    return rsaes_oaep.decrypt(bfs11146, b64decode(bfs11144))

  def bfs11147(self, bfs11145=None):
    if (not self.bfs11136):
      return False

    return (self.bfs11140 < (date.today() if (bfs11145 is None) else bfs11145))

  def bfs11150(self):
    return bool(self.encrypted_node_identifier)

  def bfs11151(self, encrypted_node_identifier):
    try:
      self.decrypt(encrypted_node_identifier)
    except:
      raise ValueError(('Not a valid encrypted node identifier: %s' % encrypted_node_identifier))

    if self.bfs10231:
      self.encrypted_node_identifier = encrypted_node_identifier



class bfs11152(object):
  def __init__(self, file_path, bfs11154=None):
    if (bfs11154 is None):
      bfs11154 = []

    self.file_path = file_path
    self.bfs11154 = bfs11154

  def read(self):
    (bfs11153, key) = self.bfs11155()
    bfs11156 = bfs11157(self.bfs11154)
    bfs11161 = bfs11156.parse(bfs11153, key)
    bfs11161.bfs11137 = self.bfs11137
    return bfs11161

  def bfs11155(self):
    with open(self.file_path, 'r') as bfs11160:
      bfs11162 = bfs11160.readline().rstrip()
      key = bfs11160.readline().rstrip()
      if ((not bfs11162) or (not key)):
        raise InvalidLicenseFile()

      return (bfs11162, key)


  def write(self, bfs11163):
    with open(self.file_path, 'w') as bfs11165:
      bfs11165.write((bfs11163.bfs10233 + '\n'))
      key = bfs11163.code
      if bfs11163.bfs10231:
        key += bfs11163.encrypted_node_identifier

      bfs11165.write((key + '\n'))


  def exists(self):
    return path.exists(self.file_path)

  @property
  def bfs11137(self):
    return datetime.fromtimestamp(path.getmtime(self.file_path))


class bfs11157(object):
  def __init__(self, bfs11154=None):
    if (bfs11154 is None):
      bfs11154 = []

    self.bfs11154 = bfs11154

  def parse(self, bfs11164, key):
    code = key[:bfs11133.bfs11135]
    bfs11166 = key[bfs11133.bfs11135:]
    try:
      if (code in self.bfs11154):
        return self.bfs11170(bfs11164, code, bfs11166)
      else:
        return self.bfs11167(bfs11164, code, bfs11166)

    except ValueError:
      return bfs11133(bfs11164, code, encrypted_node_identifier=bfs11166)


  def bfs11170(self, bfs11171, code, encrypted_node_identifier):
    bfs11173 = True
    is_online = True
    bfs11172 = False
    bfs11174 = None
    try:
      bfs11175 = int(code[:1])
    except ValueError:
      bfs11175 = None

    return bfs11133(bfs11171, code, None, encrypted_node_identifier, bfs11173, is_online, bfs11172, bfs11174, bfs11175)

  def bfs11167(self, bfs11177, code, encrypted_node_identifier):
    bfs11176 = bfs11200(code)
    bfs10231 = bfs11176.bfs10231
    is_online = bfs11176.is_online
    bfs11136 = bfs11176.bfs11136
    bfs11140 = bfs11176.bfs11140
    bfs11141 = bfs11176.bfs11141
    return bfs11133(bfs11177, code, None, encrypted_node_identifier, bfs10231, is_online, bfs11136, bfs11140, bfs11141)


class bfs11202:
  bfs11201 = 0
  bfs11203 = 1
  bfs11205 = 2
  bfs11204 = 3
  bfs11206 = 4
  bfs11210 = 5
  bfs11207 = 6

class bfs11200(object):
  bfs11211 = [(bfs11202.bfs11201, 5), (bfs11202.bfs11203, 1), (bfs11202.bfs11205, 1), (bfs11202.bfs11204, 1), (bfs11202.bfs11206, 7), (bfs11202.bfs11210, 4), (bfs11202.bfs11207, 5)]
  def __init__(self, code):
    self.code = code
    bfs11212 = self.bfs11213(self.code)
    self.bfs11141 = self.bfs11214(bfs11212, bfs11202.bfs11201)
    self.is_online = (self.bfs11214(bfs11212, bfs11202.bfs11203) > 0)
    self.bfs10231 = (self.bfs11214(bfs11212, bfs11202.bfs11205) > 0)
    self.bfs11136 = (self.bfs11214(bfs11212, bfs11202.bfs11204) > 0)
    bfs11140 = None
    if self.bfs11136:
      bfs11215 = (2000 + self.bfs11214(bfs11212, bfs11202.bfs11206))
      bfs11217 = self.bfs11214(bfs11212, bfs11202.bfs11210)
      bfs11216 = self.bfs11214(bfs11212, bfs11202.bfs11207)
      bfs11140 = date(bfs11215, bfs11217, bfs11216)

    self.bfs11140 = bfs11140

  def bfs11213(self, text):
    bfs11220 = 6
    assert (len(bfs11134) == (2 ** bfs11220))
    bfs11222 = ''
    for bfs11221 in text:
      bfs11223 = bfs11124(bfs11131(bfs11221, bfs11134), '01')
      while (len(bfs11223) < bfs11220):
        bfs11223 = ('0' + bfs11223)

      bfs11222 += bfs11223

    bfs11224 = (len(text) * bfs11220)
    bfs11226 = int(ceil((log(bfs11224) / log(2))))
    bfs11225 = bfs11222[:bfs11226]
    bfs11227 = bfs11131(bfs11225, '01')
    return bfs11222[bfs11226:(bfs11226 + bfs11227)]

  def bfs11214(self, bfs11231, bfs11230):
    offset = 0
    (bfs11232, bfs11234) = zip(*self.bfs11211)
    bfs11233 = bfs11232.index(bfs11230)
    for index in range(0, bfs11233):
      offset += bfs11234[index]

    if (len(bfs11231) <= offset):
      return (-1)

    return bfs11131(bfs11231[offset:(offset + bfs11234[bfs11232.index(bfs11230)])], '01')


