try:
  from collections import OrderedDict
except ImportError:
  from UserDict import DictMixin
  class OrderedDict(dict, DictMixin):
    def __init__(self, *args, **bfs11421):
      if (len(args) > 1):
        raise TypeError(('expected at most 1 arguments, got %d' % len(args)))

      try:
        self.bfs11423
      except AttributeError:
        self.clear()

      self.update(*args, **bfs11421)

    def clear(self):
      self.bfs11423 = end = []
      end += [None, end, end]
      self.bfs11422 = {}
      dict.clear(self)

    def __setitem__(self, key, value):
      if (key not in self):
        end = self.bfs11423
        bfs11424 = end[1]
        bfs11424[2] = end[1] = self.bfs11422[key] = [key, bfs11424, end]

      dict.__setitem__(self, key, value)

    def __delitem__(self, key):
      dict.__delitem__(self, key)
      (key, bfs11426, next) = self.bfs11422.pop(key)
      bfs11426[2] = next
      next[1] = bfs11426

    def __iter__(self):
      end = self.bfs11423
      bfs11425 = end[2]
      while (bfs11425 is not end):
        yield bfs11425[0]
        bfs11425 = bfs11425[2]


    def __reversed__(self):
      end = self.bfs11423
      bfs11427 = end[1]
      while (bfs11427 is not end):
        yield bfs11427[0]
        bfs11427 = bfs11427[1]


    def popitem(self, bfs11430=True):
      if (not self):
        raise KeyError('dictionary is empty')

      if bfs11430:
        key = reversed(self).next()
      else:
        key = iter(self).next()

      value = self.pop(key)
      return (key, value)

    def __reduce__(self):
      items = [[k, self[k]] for k in self]
      bfs11431 = (self.bfs11422, self.bfs11423)
      del self.bfs11422
      del self.bfs11423
      bfs11432 = vars(self).copy()
      (self.bfs11422, self.bfs11423) = bfs11431
      if bfs11432:
        return (self.__class__, (items,), bfs11432)

      return (self.__class__, (items,))

    def keys(self):
      return list(self)

    setdefault = DictMixin.setdefault
    update = DictMixin.update
    pop = DictMixin.pop
    values = DictMixin.values
    items = DictMixin.items
    iterkeys = DictMixin.iterkeys
    itervalues = DictMixin.itervalues
    iteritems = DictMixin.iteritems
    def __repr__(self):
      if (not self):
        return ('%s()' % (self.__class__.__name__,))

      return ('%s(%r)' % (self.__class__.__name__, self.items()))

    def copy(self):
      return self.__class__(self)

    @classmethod
    def fromkeys(bfs10263, bfs11433, value=None):
      d = bfs10263()
      for key in bfs11433:
        d[key] = value

      return d

    def __eq__(self, bfs11435):
      if isinstance(bfs11435, OrderedDict):
        if (len(self) != len(bfs11435)):
          return False

        for (p, bfs11434) in zip(self.items(), bfs11435.items()):
          if (p != bfs11434):
            return False


        return True

      return dict.__eq__(self, bfs11435)

    def __ne__(self, bfs11436):
      return (not (self == bfs11436))



