try:
  from collections import OrderedDict
except ImportError:
  from UserDict import DictMixin
  class OrderedDict(dict, DictMixin):
    def __init__(self, *args, **bfs11427):
      if (len(args) > 1):
        raise TypeError(('expected at most 1 arguments, got %d' % len(args)))

      try:
        self.bfs11430
      except AttributeError:
        self.clear()

      self.update(*args, **bfs11427)

    def clear(self):
      self.bfs11430 = end = []
      end += [None, end, end]
      self.bfs11431 = {}
      dict.clear(self)

    def __setitem__(self, key, value):
      if (key not in self):
        end = self.bfs11430
        bfs11432 = end[1]
        bfs11432[2] = end[1] = self.bfs11431[key] = [key, bfs11432, end]

      dict.__setitem__(self, key, value)

    def __delitem__(self, key):
      dict.__delitem__(self, key)
      (key, bfs11433, next) = self.bfs11431.pop(key)
      bfs11433[2] = next
      next[1] = bfs11433

    def __iter__(self):
      end = self.bfs11430
      bfs11435 = end[2]
      while (bfs11435 is not end):
        yield bfs11435[0]
        bfs11435 = bfs11435[2]


    def __reversed__(self):
      end = self.bfs11430
      bfs11434 = end[1]
      while (bfs11434 is not end):
        yield bfs11434[0]
        bfs11434 = bfs11434[1]


    def popitem(self, bfs11436=True):
      if (not self):
        raise KeyError('dictionary is empty')

      if bfs11436:
        key = next(reversed(self))
      else:
        key = next(iter(self))

      value = self.pop(key)
      return (key, value)

    def __reduce__(self):
      items = [[k, self[k]] for k in self]
      bfs11440 = (self.bfs11431, self.bfs11430)
      del self.bfs11431
      del self.bfs11430
      bfs11437 = vars(self).copy()
      (self.bfs11431, self.bfs11430) = bfs11440
      if bfs11437:
        return (self.__class__, (items,), bfs11437)

      return (self.__class__, (items,))

    def keys(self):
      return list(self)

    setdefault = DictMixin.setdefault
    update = DictMixin.update
    pop = DictMixin.pop
    values = DictMixin.values
    items = DictMixin.items
    iterkeys = DictMixin.iterkeys
    itervalues = DictMixin.itervalues
    iteritems = DictMixin.iteritems
    def __repr__(self):
      if (not self):
        return ('%s()' % (self.__class__.__name__,))

      return ('%s(%r)' % (self.__class__.__name__, list(self.items())))

    def copy(self):
      return self.__class__(self)

    @classmethod
    def fromkeys(bfs10263, bfs11441, value=None):
      d = bfs10263()
      for key in bfs11441:
        d[key] = value

      return d

    def __eq__(self, bfs11442):
      if isinstance(bfs11442, OrderedDict):
        if (len(self) != len(bfs11442)):
          return False

        for (p, bfs11444) in zip(list(self.items()), list(bfs11442.items())):
          if (p != bfs11444):
            return False


        return True

      return dict.__eq__(self, bfs11442)

    def __ne__(self, bfs11443):
      return (not (self == bfs11443))



