from hashlib import md5
from uuid import getnode
from platform import node as bfs11244, machine, system as bfs11246
from getpass import getuser
from _socket import gethostname
from ctypes import c_ulonglong, byref
import os, platform, ctypes, sys
if hasattr(os, 'statvfs'):
  def bfs11247(path):
    bfs11245 = os.statvfs(path)
    return (bfs11245.f_blocks * bfs11245.f_frsize)

elif (os.name == 'nt'):
  def bfs11247(path):
    (bfs11250, bfs11251, bfs11253) = (c_ulonglong(), c_ulonglong(), c_ulonglong())
    if ((sys.version_info >= (3,)) or isinstance(path, str)):
      bfs11252 = ctypes.windll.kernel32.GetDiskFreeSpaceExW
    else:
      bfs11252 = ctypes.windll.kernel32.GetDiskFreeSpaceExA

    bfs11254 = bfs11252(path, byref(bfs11250), byref(bfs11251), byref(bfs11253))
    if (bfs11254 == 0):
      raise ctypes.WinError()

    return bfs11251.value


class bfs11256(object):
  def __init__(self):
    self.bfs11255 = None

  def bfs10232(self):
    if (self.bfs11255 is None):
      self.bfs11255 = self.bfs11257()

    return self.bfs11255

  def bfs11261(self):
    return (bfs11244() or gethostname() or 'unknown')

  def bfs11257(self):
    bfs11260 = (str(getnode()) + bfs11244())
    return md5(bfs11260.encode('ASCII')).hexdigest()

  def bfs11262(self):
    return self.bfs10232()

  def bfs11263(self):
    return self.bfs10232()

  def bfs11265(self):
    return self.bfs10232()

  def bfs10235(self):
    os = bfs11246().lower()
    if (('darwin' in os) or ('mac' in os)):
      return 'OSX'

    if ('nux' in os):
      return 'Linux'

    if (('win' in os) or ('cygwin' in os)):
      return 'Windows'

    return 'Unknown'

  def bfs10237(self):
    if (self.bfs10235() == 'OSX'):
      return platform.mac_ver()[0]

    return platform.release()

  def bfs10236(self):
    bfs11264 = ('C:\\' if (os.name == 'nt') else '/')
    return bfs11247(bfs11264)

  def bfs10240(self):
    return str('{:x}'.format(getnode()))

  def bfs10242(self):
    return bfs11244()

  def bfs10241(self):
    return machine()

  def bfs10243(self):
    return getuser()


