from base64 import b64decode
from bfs.bfs10143.bfs10147 import InvalidLicenseFile
from bfs.bfs10063.bfs11127 import bfs11136, bfs11131
from datetime import date, datetime
from math import ceil, log
from os import path
from pkcs1 import rsaes_oaep
from pkcs1.keys import RsaPrivateKey
bfs11141 = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz-/'
class bfs11142(object):
  bfs11143 = 32
  def __init__(self, bfs10233, code, bfs11144=None, encrypted_node_identifier='', bfs10231=True, is_online=True, bfs11146=False, bfs11145=None, bfs11147=None):
    self.bfs10233 = bfs10233
    self.code = code
    self.bfs11144 = bfs11144
    self.encrypted_node_identifier = encrypted_node_identifier
    self.bfs10231 = bfs10231
    self.is_online = is_online
    self.bfs11146 = bfs11146
    self.bfs11145 = bfs11145
    self.bfs11147 = bfs11147

  @property
  def bfs11150(self):
    if (not self.encrypted_node_identifier):
      return self.encrypted_node_identifier

    return self.decrypt(self.encrypted_node_identifier)

  @classmethod
  def decrypt(bfs11151, bfs11152):
    n = 126552595132100767496431298900695851144633929478317947845463894147101930730111564183119259440078050133900835449855213073742144369102834189244736695982848189036861833523332376016102290780726072320885243610990871511351145548702602510026707584848724238826408910261032648966390926399187028038467973734166869523139
    d = 47620634886441811911279006701406234418386824768677219155850665937740218712105852942916277172463872230223057250543653350192334441406304742984336354420144630234029397102707344769401491936717749314553261859131919096126529291266317948550850549782633820140042213874431692820120174629881124487475541748108487115593
    bfs11154 = RsaPrivateKey(n, d)
    return rsaes_oaep.decrypt(bfs11154, b64decode(bfs11152))

  def bfs11155(self, bfs11153=None):
    if (not self.bfs11146):
      return False

    return (self.bfs11145 < (date.today() if (bfs11153 is None) else bfs11153))

  def bfs11156(self):
    return bool(self.encrypted_node_identifier)

  def bfs11157(self, encrypted_node_identifier):
    try:
      self.decrypt(encrypted_node_identifier)
    except:
      raise ValueError(('Not a valid encrypted node identifier: %s' % encrypted_node_identifier))

    if self.bfs10231:
      self.encrypted_node_identifier = encrypted_node_identifier



class bfs11161(object):
  def __init__(self, file_path, bfs11160=None):
    if (bfs11160 is None):
      bfs11160 = []

    self.file_path = file_path
    self.bfs11160 = bfs11160

  def read(self):
    (bfs11162, key) = self.bfs11163()
    bfs11165 = bfs11164(self.bfs11160)
    bfs11166 = bfs11165.parse(bfs11162, key)
    bfs11166.bfs11144 = self.bfs11144
    return bfs11166

  def bfs11163(self):
    with open(self.file_path, 'r') as bfs11170:
      bfs11167 = bfs11170.readline().rstrip()
      key = bfs11170.readline().rstrip()
      if ((not bfs11167) or (not key)):
        raise InvalidLicenseFile()

      return (bfs11167, key)


  def write(self, bfs11171):
    with open(self.file_path, 'w') as bfs11173:
      bfs11173.write((bfs11171.bfs10233 + '\n'))
      key = bfs11171.code
      if bfs11171.bfs10231:
        key += bfs11171.encrypted_node_identifier

      bfs11173.write((key + '\n'))


  def exists(self):
    return path.exists(self.file_path)

  @property
  def bfs11144(self):
    return datetime.fromtimestamp(path.getmtime(self.file_path))


class bfs11164(object):
  def __init__(self, bfs11160=None):
    if (bfs11160 is None):
      bfs11160 = []

    self.bfs11160 = bfs11160

  def parse(self, bfs11172, key):
    code = key[:bfs11142.bfs11143]
    bfs11174 = key[bfs11142.bfs11143:]
    try:
      if (code in self.bfs11160):
        return self.bfs11175(bfs11172, code, bfs11174)
      else:
        return self.bfs11177(bfs11172, code, bfs11174)

    except ValueError:
      return bfs11142(bfs11172, code, encrypted_node_identifier=bfs11174)


  def bfs11175(self, bfs11176, code, encrypted_node_identifier):
    bfs11200 = True
    is_online = True
    bfs11202 = False
    bfs11201 = None
    try:
      bfs11203 = int(code[:1])
    except ValueError:
      bfs11203 = None

    return bfs11142(bfs11176, code, None, encrypted_node_identifier, bfs11200, is_online, bfs11202, bfs11201, bfs11203)

  def bfs11177(self, bfs11205, code, encrypted_node_identifier):
    bfs11204 = bfs11206(code)
    bfs10231 = bfs11204.bfs10231
    is_online = bfs11204.is_online
    bfs11146 = bfs11204.bfs11146
    bfs11145 = bfs11204.bfs11145
    bfs11147 = bfs11204.bfs11147
    return bfs11142(bfs11205, code, None, encrypted_node_identifier, bfs10231, is_online, bfs11146, bfs11145, bfs11147)


class bfs11210:
  bfs11207 = 0
  bfs11211 = 1
  bfs11212 = 2
  bfs11213 = 3
  bfs11214 = 4
  bfs11215 = 5
  bfs11217 = 6

class bfs11206(object):
  bfs11216 = [(bfs11210.bfs11207, 5), (bfs11210.bfs11211, 1), (bfs11210.bfs11212, 1), (bfs11210.bfs11213, 1), (bfs11210.bfs11214, 7), (bfs11210.bfs11215, 4), (bfs11210.bfs11217, 5)]
  def __init__(self, code):
    self.code = code
    bfs11220 = self.bfs11222(self.code)
    self.bfs11147 = self.bfs11221(bfs11220, bfs11210.bfs11207)
    self.is_online = (self.bfs11221(bfs11220, bfs11210.bfs11211) > 0)
    self.bfs10231 = (self.bfs11221(bfs11220, bfs11210.bfs11212) > 0)
    self.bfs11146 = (self.bfs11221(bfs11220, bfs11210.bfs11213) > 0)
    bfs11145 = None
    if self.bfs11146:
      bfs11223 = (2000 + self.bfs11221(bfs11220, bfs11210.bfs11214))
      bfs11224 = self.bfs11221(bfs11220, bfs11210.bfs11215)
      bfs11226 = self.bfs11221(bfs11220, bfs11210.bfs11217)
      bfs11145 = date(bfs11223, bfs11224, bfs11226)

    self.bfs11145 = bfs11145

  def bfs11222(self, text):
    bfs11225 = 6
    assert (len(bfs11141) == (2 ** bfs11225))
    bfs11227 = ''
    for bfs11231 in text:
      bfs11230 = bfs11131(bfs11136(bfs11231, bfs11141), '01')
      while (len(bfs11230) < bfs11225):
        bfs11230 = ('0' + bfs11230)

      bfs11227 += bfs11230

    bfs11232 = (len(text) * bfs11225)
    bfs11234 = int(ceil((log(bfs11232) / log(2))))
    bfs11233 = bfs11227[:bfs11234]
    bfs11235 = bfs11136(bfs11233, '01')
    return bfs11227[bfs11234:(bfs11234 + bfs11235)]

  def bfs11221(self, bfs11236, bfs11237):
    offset = 0
    (bfs11241, bfs11240) = list(zip(*self.bfs11216))
    bfs11242 = bfs11241.index(bfs11237)
    for index in range(0, bfs11242):
      offset += bfs11240[index]

    if (len(bfs11236) <= offset):
      return (-1)

    return bfs11136(bfs11236[offset:(offset + bfs11240[bfs11241.index(bfs11237)])], '01')


