from hashlib import md5
from uuid import getnode
from platform import node as bfs11251, machine, system as bfs11253
from getpass import getuser
from _socket import gethostname
from ctypes import c_ulonglong, byref
import os, platform, ctypes, sys
if hasattr(os, 'statvfs'):
  def bfs11254(path):
    bfs11252 = os.statvfs(path)
    return (bfs11252.f_blocks * bfs11252.f_frsize)

elif (os.name == 'nt'):
  def bfs11254(path):
    (bfs11256, bfs11255, bfs11257) = (c_ulonglong(), c_ulonglong(), c_ulonglong())
    if ((sys.version_info >= (3,)) or isinstance(path, str)):
      bfs11261 = ctypes.windll.kernel32.GetDiskFreeSpaceExW
    else:
      bfs11261 = ctypes.windll.kernel32.GetDiskFreeSpaceExA

    bfs11260 = bfs11261(path, byref(bfs11256), byref(bfs11255), byref(bfs11257))
    if (bfs11260 == 0):
      raise ctypes.WinError()

    return bfs11255.value


class bfs11262(object):
  def __init__(self):
    self.bfs11263 = None

  def bfs10232(self):
    if (self.bfs11263 is None):
      self.bfs11263 = self.bfs11265()

    return self.bfs11263

  def bfs11264(self):
    return (bfs11251() or gethostname() or 'unknown')

  def bfs11265(self):
    bfs11266 = (str(getnode()) + bfs11251())
    return md5(bfs11266.encode('ASCII')).hexdigest()

  def bfs11267(self):
    return self.bfs10232()

  def bfs11270(self):
    return self.bfs10232()

  def bfs11271(self):
    return self.bfs10232()

  def bfs10235(self):
    os = bfs11253().lower()
    if (('darwin' in os) or ('mac' in os)):
      return 'OSX'

    if ('nux' in os):
      return 'Linux'

    if (('win' in os) or ('cygwin' in os)):
      return 'Windows'

    return 'Unknown'

  def bfs10237(self):
    if (self.bfs10235() == 'OSX'):
      return platform.mac_ver()[0]

    return platform.release()

  def bfs10236(self):
    bfs11273 = ('C:\\' if (os.name == 'nt') else '/')
    return bfs11254(bfs11273)

  def bfs10240(self):
    return str('{:x}'.format(getnode()))

  def bfs10242(self):
    return bfs11251()

  def bfs10241(self):
    return machine()

  def bfs10243(self):
    return getuser()


