from hashlib import md5
from uuid import getnode
from platform import node as bfs11253, machine, system as bfs11252
from getpass import getuser
from _socket import gethostname
from ctypes import c_ulonglong, byref
import os, platform, ctypes, sys
if hasattr(os, 'statvfs'):
  def bfs11256(path):
    bfs11254 = os.statvfs(path)
    return (bfs11254.f_blocks * bfs11254.f_frsize)

elif (os.name == 'nt'):
  def bfs11256(path):
    (bfs11255, bfs11257, bfs11261) = (c_ulonglong(), c_ulonglong(), c_ulonglong())
    if ((sys.version_info >= (3,)) or isinstance(path, unicode)):
      bfs11260 = ctypes.windll.kernel32.GetDiskFreeSpaceExW
    else:
      bfs11260 = ctypes.windll.kernel32.GetDiskFreeSpaceExA

    bfs11262 = bfs11260(path, byref(bfs11255), byref(bfs11257), byref(bfs11261))
    if (bfs11262 == 0):
      raise ctypes.WinError()

    return bfs11257.value


class bfs11263(object):
  def __init__(self):
    self.bfs11265 = None

  def bfs10232(self):
    if (self.bfs11265 is None):
      self.bfs11265 = self.bfs11264()

    return self.bfs11265

  def bfs11266(self):
    return (bfs11253() or gethostname() or 'unknown')

  def bfs11264(self):
    bfs11267 = (str(getnode()) + bfs11253())
    return md5(bfs11267.encode('ASCII')).hexdigest()

  def bfs11270(self):
    return self.bfs10232()

  def bfs11271(self):
    return self.bfs10232()

  def bfs11273(self):
    return self.bfs10232()

  def bfs10235(self):
    os = bfs11252().lower()
    if (('darwin' in os) or ('mac' in os)):
      return 'OSX'

    if ('nux' in os):
      return 'Linux'

    if (('win' in os) or ('cygwin' in os)):
      return 'Windows'

    return 'Unknown'

  def bfs10237(self):
    if (self.bfs10235() == 'OSX'):
      return platform.mac_ver()[0]

    return platform.release()

  def bfs10236(self):
    bfs11272 = ('C:\\' if (os.name == 'nt') else '/')
    return bfs11256(bfs11272)

  def bfs10240(self):
    return str('{0:x}'.format(getnode()))

  def bfs10242(self):
    return bfs11253()

  def bfs10241(self):
    return machine()

  def bfs10243(self):
    return getuser()


