from base64 import b64decode
from bfs.bfs10143.bfs10147 import InvalidLicenseFile
from bfs.bfs10063.bfs11137 import bfs11147, bfs11141
from datetime import date, datetime
from math import ceil, log
from os import path
from pkcs1 import rsaes_oaep
from pkcs1.keys import RsaPrivateKey
bfs11150 = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz-/'
class bfs11151(object):
  bfs11152 = 32
  def __init__(self, bfs10233, code, bfs11154=None, encrypted_node_identifier='', bfs10231=True, is_online=True, bfs11153=False, bfs11155=None, bfs11156=None):
    self.bfs10233 = bfs10233
    self.code = code
    self.bfs11154 = bfs11154
    self.encrypted_node_identifier = encrypted_node_identifier
    self.bfs10231 = bfs10231
    self.is_online = is_online
    self.bfs11153 = bfs11153
    self.bfs11155 = bfs11155
    self.bfs11156 = bfs11156

  @property
  def bfs11157(self):
    if (not self.encrypted_node_identifier):
      return self.encrypted_node_identifier

    return self.decrypt(self.encrypted_node_identifier)

  @classmethod
  def decrypt(bfs11161, bfs11160):
    n = 126552595132100767496431298900695851144633929478317947845463894147101930730111564183119259440078050133900835449855213073742144369102834189244736695982848189036861833523332376016102290780726072320885243610990871511351145548702602510026707584848724238826408910261032648966390926399187028038467973734166869523139
    d = 47620634886441811911279006701406234418386824768677219155850665937740218712105852942916277172463872230223057250543653350192334441406304742984336354420144630234029397102707344769401491936717749314553261859131919096126529291266317948550850549782633820140042213874431692820120174629881124487475541748108487115593
    bfs11162 = RsaPrivateKey(n, d)
    return rsaes_oaep.decrypt(bfs11162, b64decode(bfs11160))

  def bfs11165(self, bfs11163=None):
    if (not self.bfs11153):
      return False

    return (self.bfs11155 < (date.today() if (bfs11163 is None) else bfs11163))

  def bfs11164(self):
    return bool(self.encrypted_node_identifier)

  def bfs11166(self, encrypted_node_identifier):
    try:
      self.decrypt(encrypted_node_identifier)
    except:
      raise ValueError(('Not a valid encrypted node identifier: %s' % encrypted_node_identifier))

    if self.bfs10231:
      self.encrypted_node_identifier = encrypted_node_identifier



class bfs11170(object):
  def __init__(self, file_path, bfs11167=None):
    if (bfs11167 is None):
      bfs11167 = []

    self.file_path = file_path
    self.bfs11167 = bfs11167

  def read(self):
    (bfs11171, key) = self.bfs11173()
    bfs11172 = bfs11174(self.bfs11167)
    bfs11175 = bfs11172.parse(bfs11171, key)
    bfs11175.bfs11154 = self.bfs11154
    return bfs11175

  def bfs11173(self):
    with open(self.file_path, 'r') as bfs11177:
      bfs11176 = bfs11177.readline().rstrip()
      key = bfs11177.readline().rstrip()
      if ((not bfs11176) or (not key)):
        raise InvalidLicenseFile()

      return (bfs11176, key)


  def write(self, bfs11200):
    with open(self.file_path, 'w') as bfs11202:
      bfs11202.write((bfs11200.bfs10233 + '\n'))
      key = bfs11200.code
      if bfs11200.bfs10231:
        key += bfs11200.encrypted_node_identifier

      bfs11202.write((key + '\n'))


  def exists(self):
    return path.exists(self.file_path)

  @property
  def bfs11154(self):
    return datetime.fromtimestamp(path.getmtime(self.file_path))


class bfs11174(object):
  def __init__(self, bfs11167=None):
    if (bfs11167 is None):
      bfs11167 = []

    self.bfs11167 = bfs11167

  def parse(self, bfs11201, key):
    code = key[:bfs11151.bfs11152]
    bfs11203 = key[bfs11151.bfs11152:]
    try:
      if (code in self.bfs11167):
        return self.bfs11205(bfs11201, code, bfs11203)
      else:
        return self.bfs11204(bfs11201, code, bfs11203)

    except ValueError:
      return bfs11151(bfs11201, code, encrypted_node_identifier=bfs11203)


  def bfs11205(self, bfs11206, code, encrypted_node_identifier):
    bfs11210 = True
    is_online = True
    bfs11207 = False
    bfs11211 = None
    try:
      bfs11212 = int(code[:1])
    except ValueError:
      bfs11212 = None

    return bfs11151(bfs11206, code, None, encrypted_node_identifier, bfs11210, is_online, bfs11207, bfs11211, bfs11212)

  def bfs11204(self, bfs11213, code, encrypted_node_identifier):
    bfs11214 = bfs11215(code)
    bfs10231 = bfs11214.bfs10231
    is_online = bfs11214.is_online
    bfs11153 = bfs11214.bfs11153
    bfs11155 = bfs11214.bfs11155
    bfs11156 = bfs11214.bfs11156
    return bfs11151(bfs11213, code, None, encrypted_node_identifier, bfs10231, is_online, bfs11153, bfs11155, bfs11156)


class bfs11217:
  bfs11216 = 0
  bfs11220 = 1
  bfs11222 = 2
  bfs11221 = 3
  bfs11223 = 4
  bfs11224 = 5
  bfs11226 = 6

class bfs11215(object):
  bfs11225 = [(bfs11217.bfs11216, 5), (bfs11217.bfs11220, 1), (bfs11217.bfs11222, 1), (bfs11217.bfs11221, 1), (bfs11217.bfs11223, 7), (bfs11217.bfs11224, 4), (bfs11217.bfs11226, 5)]
  def __init__(self, code):
    self.code = code
    bfs11227 = self.bfs11231(self.code)
    self.bfs11156 = self.bfs11230(bfs11227, bfs11217.bfs11216)
    self.is_online = (self.bfs11230(bfs11227, bfs11217.bfs11220) > 0)
    self.bfs10231 = (self.bfs11230(bfs11227, bfs11217.bfs11222) > 0)
    self.bfs11153 = (self.bfs11230(bfs11227, bfs11217.bfs11221) > 0)
    bfs11155 = None
    if self.bfs11153:
      bfs11232 = (2000 + self.bfs11230(bfs11227, bfs11217.bfs11223))
      bfs11234 = self.bfs11230(bfs11227, bfs11217.bfs11224)
      bfs11233 = self.bfs11230(bfs11227, bfs11217.bfs11226)
      bfs11155 = date(bfs11232, bfs11234, bfs11233)

    self.bfs11155 = bfs11155

  def bfs11231(self, text):
    bfs11235 = 6
    assert (len(bfs11150) == (2 ** bfs11235))
    bfs11236 = ''
    for bfs11237 in text:
      bfs11241 = bfs11141(bfs11147(bfs11237, bfs11150), '01')
      while (len(bfs11241) < bfs11235):
        bfs11241 = ('0' + bfs11241)

      bfs11236 += bfs11241

    bfs11240 = (len(text) * bfs11235)
    bfs11242 = int(ceil((log(bfs11240) / log(2))))
    bfs11243 = bfs11236[:bfs11242]
    bfs11244 = bfs11147(bfs11243, '01')
    return bfs11236[bfs11242:(bfs11242 + bfs11244)]

  def bfs11230(self, bfs11246, bfs11245):
    offset = 0
    (bfs11247, bfs11250) = list(zip(*self.bfs11225))
    bfs11251 = bfs11247.index(bfs11245)
    for index in range(0, bfs11251):
      offset += bfs11250[index]

    if (len(bfs11246) <= offset):
      return (-1)

    return bfs11147(bfs11246[offset:(offset + bfs11250[bfs11247.index(bfs11245)])], '01')


