
from collections import namedtuple
from math import sqrt
class bfs10256(object):
  def __init__(self, bfs10257=0, bfs10261=0, width=0, height=0):
    self.bfs10257 = bfs10257
    self.bfs10261 = bfs10261
    self.bfs10260 = (bfs10257 + width)
    self.bfs10262 = (bfs10261 + height)

  @classmethod
  def bfs10264(bfs10263, width, height):
    return bfs10263(0, 0, width, height)

  @classmethod
  def bfs10265(bfs10263, bfs10266=None):
    if (bfs10266 is None):
      bfs10266 = (0, 0, 0, 0)

    return bfs10263(*bfs10266)

  @classmethod
  def bfs10272(bfs10267, bfs10270):
    return bfs10267.bfs10264(*bfs10270)

  @classmethod
  def bfs10274(bfs10271, struct):
    return bfs10271.bfs10273(struct.bfs10257, struct.bfs10261, struct.bfs10260, struct.bfs10262)

  @classmethod
  def bfs10273(bfs10263, bfs10275, bfs10277, bfs10276, bfs10300):
    return bfs10263(bfs10275, bfs10277, (bfs10276 - bfs10275), (bfs10300 - bfs10277))

  @property
  def width(self):
    return (self.bfs10260 - self.bfs10257)

  @property
  def height(self):
    return (self.bfs10262 - self.bfs10261)

  @property
  def center(self):
    return Point((self.bfs10257 + (self.width / 2)), (self.bfs10261 + (self.height / 2)))

  @property
  def bfs10303(self):
    return self.bfs10301(Point((self.bfs10260 - 1), self.center.y))

  @property
  def bfs10302(self):
    return Point(self.bfs10257, self.center.y)

  @property
  def bfs10304(self):
    return Point(self.center.x, self.bfs10261)

  @property
  def bfs10306(self):
    return self.bfs10301(Point(self.center.x, (self.bfs10262 - 1)))

  @property
  def bfs10305(self):
    return Point(self.bfs10303.x, self.bfs10304.y)

  @property
  def bfs10307(self):
    return Point(self.bfs10303.x, self.bfs10306.y)

  @property
  def bfs10311(self):
    return Point(self.bfs10302.x, self.bfs10306.y)

  @property
  def bfs10310(self):
    return Point(self.bfs10302.x, self.bfs10304.y)

  @property
  def bfs10312(self):
    if (not self):
      return 0

    return (self.width * self.height)

  def __contains__(self, bfs10314):
    return ((self.bfs10257 <= bfs10314.x < self.bfs10260) and (self.bfs10261 <= bfs10314.y < self.bfs10262))

  def translate(self, bfs10313, bfs10315):
    self.bfs10257 += bfs10313
    self.bfs10260 += bfs10313
    self.bfs10261 += bfs10315
    self.bfs10262 += bfs10315
    return self

  def bfs10301(self, bfs10317):
    return Point(min(max(bfs10317[0], self.bfs10257), max(self.bfs10257, (self.bfs10260 - 1))), min(max(bfs10317[1], self.bfs10261), max(self.bfs10261, (self.bfs10262 - 1))))

  def bfs10320(self, bfs10316):
    bfs10257 = max(self.bfs10257, bfs10316.bfs10257)
    bfs10261 = max(self.bfs10261, bfs10316.bfs10261)
    bfs10260 = min(self.bfs10260, bfs10316.bfs10260)
    bfs10262 = min(self.bfs10262, bfs10316.bfs10262)
    return (self.bfs10273(bfs10257, bfs10261, bfs10260, bfs10262) or bfs10256())

  def bfs10323(self, bfs10321):
    return bool(self.bfs10320(bfs10321))

  def bfs10322(self):
    return (slice(self.bfs10261, self.bfs10262), slice(self.bfs10257, self.bfs10260))

  def is_to_left_of(self, bfs10324):
    bfs10325 = (self.bfs10257 < bfs10324.bfs10257)
    bfs10327 = (self.bfs10261 <= bfs10324.bfs10261 < self.bfs10262)
    bfs10326 = (bfs10324.bfs10261 <= self.bfs10261 < bfs10324.bfs10262)
    return (bfs10325 and (bfs10327 or bfs10326))

  def is_to_right_of(self, bfs10330):
    return bfs10330.is_to_left_of(self)

  def is_above(self, bfs10332):
    bfs10331 = (self.bfs10261 < bfs10332.bfs10261)
    bfs10333 = (self.bfs10257 <= bfs10332.bfs10257 < self.bfs10260)
    bfs10334 = (bfs10332.bfs10257 <= self.bfs10257 < bfs10332.bfs10260)
    return (bfs10331 and (bfs10333 or bfs10334))

  def is_below(self, bfs10335):
    return bfs10335.is_above(self)

  def bfs10340(self, bfs10337, bfs10336):
    return getattr(self, ('is_' + bfs10337))(bfs10336)

  def bfs10351(self, bfs10342):
    bfs10341 = (self if (self.bfs10257 < bfs10342.bfs10257) else bfs10342)
    bfs10343 = (self if (bfs10341 == bfs10342) else bfs10342)
    bfs10345 = max(0, (bfs10343.bfs10257 - bfs10341.bfs10260))
    bfs10344 = (self if (self.bfs10261 < bfs10342.bfs10261) else bfs10342)
    bfs10346 = (self if (bfs10344 == bfs10342) else bfs10342)
    bfs10347 = max(0, (bfs10346.bfs10261 - bfs10344.bfs10262))
    return sqrt(((bfs10345 ** 2) + (bfs10347 ** 2)))

  def __eq__(self, bfs10350):
    if (not isinstance(bfs10350, bfs10256)):
      return False

    return ((self.bfs10257 == bfs10350.bfs10257) and (self.bfs10261 == bfs10350.bfs10261) and (self.bfs10260 == bfs10350.bfs10260) and (self.bfs10262 == bfs10350.bfs10262))

  def __ne__(self, bfs10352):
    return (not self.__eq__(bfs10352))

  def __bool__(self):
    return bool(((self.width > 0) and (self.height > 0)))

  def __repr__(self):
    return (type(self).__name__ + ('(left=%d, top=%d, width=%d, height=%d)' % (self.bfs10257, self.bfs10261, self.width, self.height)))

  def __hash__(self):
    return (((self.bfs10257 + (7 * self.bfs10261)) + (11 * self.bfs10260)) + (13 * self.bfs10262))


class Point(namedtuple('Point', ['x', 'y'])):
  def __new__(bfs10354, x=0, y=0):
    return bfs10354.__bases__[0].__new__(bfs10354, x, y)

  def __init__(self, x=0, y=0):
    pass

  @classmethod
  def bfs10355(bfs10263, bfs10353):
    return bfs10263(*bfs10353)

  def __eq__(self, bfs10357):
    return ((self.x, self.y) == bfs10357)

  def __ne__(self, bfs10356):
    return (not (self == bfs10356))

  def __add__(self, bfs10360):
    (bfs10361, bfs10362) = bfs10360
    return Point((self.x + bfs10361), (self.y + bfs10362))

  def __radd__(self, bfs10364):
    return self.__add__(bfs10364)

  def __sub__(self, bfs10363):
    (bfs10365, bfs10367) = bfs10363
    return Point((self.x - bfs10365), (self.y - bfs10367))

  def __rsub__(self, bfs10366):
    (x, y) = bfs10366
    (bfs10370, bfs10371) = self
    return Point((x - bfs10370), (y - bfs10371))

  def __mul__(self, bfs10372):
    if isinstance(bfs10372, int):
      return Point((self.x * bfs10372), (self.y * bfs10372))
    else:
      raise ValueError('Invalid argument')


  def __rmul__(self, bfs10373):
    return self.__mul__(bfs10373)

  def __div__(self, bfs10374):
    if isinstance(bfs10374, int):
      return Point((self.x / bfs10374), (self.y / bfs10374))
    else:
      raise ValueError('Invalid argument')


  def __bool__(self):
    return (bool(self.x) or bool(self.y))


class bfs10376(object):
  def __init__(self, bfs10375):
    self.bfs10375 = bfs10375

  def bfs10401(self, bfs10377, bfs10400):
    for offset in bfs10400:
      yield (bfs10377 + (offset * self.bfs10375))


  def bfs10402(self):
    return bool(self.bfs10375.x)

  def bfs10404(self):
    return (not self.bfs10402())

  @property
  def bfs10403(self):
    return Point((-self.bfs10375[1]), self.bfs10375[0])

  def __eq__(self, bfs10405):
    return (self.bfs10375 == bfs10405.bfs10375)

  def __repr__(self):
    for bfs10406 in dir(self.__module__):
      if (self == getattr(self.__module__, bfs10406)):
        return bfs10406




bfs10407 = bfs10376(Point(0, (-1)))
bfs10411 = bfs10376(Point(1, 0))
bfs10410 = bfs10376(Point(0, 1))
bfs10412 = bfs10376(Point((-1), 0))
