from base64 import b64decode
from bfs.bfs10143.bfs10147 import InvalidLicenseFile
from bfs.bfs10063.bfs11134 import bfs11144, bfs11137
from datetime import date, datetime
from math import ceil, log
from os import path
from pkcs1 import rsaes_oaep
from pkcs1.keys import RsaPrivateKey
bfs11146 = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz-/'
class bfs11145(object):
  bfs11147 = 32
  def __init__(self, bfs10233, code, bfs11150=None, encrypted_node_identifier='', bfs10231=True, is_online=True, bfs11151=False, bfs11152=None, bfs11154=None):
    self.bfs10233 = bfs10233
    self.code = code
    self.bfs11150 = bfs11150
    self.encrypted_node_identifier = encrypted_node_identifier
    self.bfs10231 = bfs10231
    self.is_online = is_online
    self.bfs11151 = bfs11151
    self.bfs11152 = bfs11152
    self.bfs11154 = bfs11154

  @property
  def bfs11153(self):
    if (not self.encrypted_node_identifier):
      return self.encrypted_node_identifier

    return self.decrypt(self.encrypted_node_identifier)

  @classmethod
  def decrypt(bfs11155, bfs11156):
    n = 126552595132100767496431298900695851144633929478317947845463894147101930730111564183119259440078050133900835449855213073742144369102834189244736695982848189036861833523332376016102290780726072320885243610990871511351145548702602510026707584848724238826408910261032648966390926399187028038467973734166869523139
    d = 47620634886441811911279006701406234418386824768677219155850665937740218712105852942916277172463872230223057250543653350192334441406304742984336354420144630234029397102707344769401491936717749314553261859131919096126529291266317948550850549782633820140042213874431692820120174629881124487475541748108487115593
    bfs11157 = RsaPrivateKey(n, d)
    return rsaes_oaep.decrypt(bfs11157, b64decode(bfs11156))

  def bfs11160(self, bfs11161=None):
    if (not self.bfs11151):
      return False

    return (self.bfs11152 < (date.today() if (bfs11161 is None) else bfs11161))

  def bfs11162(self):
    return bool(self.encrypted_node_identifier)

  def bfs11163(self, encrypted_node_identifier):
    try:
      self.decrypt(encrypted_node_identifier)
    except:
      raise ValueError(('Not a valid encrypted node identifier: %s' % encrypted_node_identifier))

    if self.bfs10231:
      self.encrypted_node_identifier = encrypted_node_identifier



class bfs11165(object):
  def __init__(self, file_path, bfs11164=None):
    if (bfs11164 is None):
      bfs11164 = []

    self.file_path = file_path
    self.bfs11164 = bfs11164

  def read(self):
    (bfs11166, key) = self.bfs11170()
    bfs11167 = bfs11171(self.bfs11164)
    bfs11173 = bfs11167.parse(bfs11166, key)
    bfs11173.bfs11150 = self.bfs11150
    return bfs11173

  def bfs11170(self):
    with open(self.file_path, 'r') as bfs11172:
      bfs11174 = bfs11172.readline().rstrip()
      key = bfs11172.readline().rstrip()
      if ((not bfs11174) or (not key)):
        raise InvalidLicenseFile()

      return (bfs11174, key)


  def write(self, bfs11175):
    with open(self.file_path, 'w') as bfs11177:
      bfs11177.write((bfs11175.bfs10233 + '\n'))
      key = bfs11175.code
      if bfs11175.bfs10231:
        key += bfs11175.encrypted_node_identifier

      bfs11177.write((key + '\n'))


  def exists(self):
    return path.exists(self.file_path)

  @property
  def bfs11150(self):
    return datetime.fromtimestamp(path.getmtime(self.file_path))


class bfs11171(object):
  def __init__(self, bfs11164=None):
    if (bfs11164 is None):
      bfs11164 = []

    self.bfs11164 = bfs11164

  def parse(self, bfs11176, key):
    code = key[:bfs11145.bfs11147]
    bfs11200 = key[bfs11145.bfs11147:]
    try:
      if (code in self.bfs11164):
        return self.bfs11202(bfs11176, code, bfs11200)
      else:
        return self.bfs11201(bfs11176, code, bfs11200)

    except ValueError:
      return bfs11145(bfs11176, code, encrypted_node_identifier=bfs11200)


  def bfs11202(self, bfs11203, code, encrypted_node_identifier):
    bfs11205 = True
    is_online = True
    bfs11204 = False
    bfs11206 = None
    try:
      bfs11210 = int(code[:1])
    except ValueError:
      bfs11210 = None

    return bfs11145(bfs11203, code, None, encrypted_node_identifier, bfs11205, is_online, bfs11204, bfs11206, bfs11210)

  def bfs11201(self, bfs11207, code, encrypted_node_identifier):
    bfs11211 = bfs11212(code)
    bfs10231 = bfs11211.bfs10231
    is_online = bfs11211.is_online
    bfs11151 = bfs11211.bfs11151
    bfs11152 = bfs11211.bfs11152
    bfs11154 = bfs11211.bfs11154
    return bfs11145(bfs11207, code, None, encrypted_node_identifier, bfs10231, is_online, bfs11151, bfs11152, bfs11154)


class bfs11213:
  bfs11214 = 0
  bfs11215 = 1
  bfs11217 = 2
  bfs11216 = 3
  bfs11220 = 4
  bfs11222 = 5
  bfs11221 = 6

class bfs11212(object):
  bfs11223 = [(bfs11213.bfs11214, 5), (bfs11213.bfs11215, 1), (bfs11213.bfs11217, 1), (bfs11213.bfs11216, 1), (bfs11213.bfs11220, 7), (bfs11213.bfs11222, 4), (bfs11213.bfs11221, 5)]
  def __init__(self, code):
    self.code = code
    bfs11224 = self.bfs11226(self.code)
    self.bfs11154 = self.bfs11225(bfs11224, bfs11213.bfs11214)
    self.is_online = (self.bfs11225(bfs11224, bfs11213.bfs11215) > 0)
    self.bfs10231 = (self.bfs11225(bfs11224, bfs11213.bfs11217) > 0)
    self.bfs11151 = (self.bfs11225(bfs11224, bfs11213.bfs11216) > 0)
    bfs11152 = None
    if self.bfs11151:
      bfs11227 = (2000 + self.bfs11225(bfs11224, bfs11213.bfs11220))
      bfs11231 = self.bfs11225(bfs11224, bfs11213.bfs11222)
      bfs11230 = self.bfs11225(bfs11224, bfs11213.bfs11221)
      bfs11152 = date(bfs11227, bfs11231, bfs11230)

    self.bfs11152 = bfs11152

  def bfs11226(self, text):
    bfs11232 = 6
    assert (len(bfs11146) == (2 ** bfs11232))
    bfs11234 = ''
    for bfs11233 in text:
      bfs11235 = bfs11137(bfs11144(bfs11233, bfs11146), '01')
      while (len(bfs11235) < bfs11232):
        bfs11235 = ('0' + bfs11235)

      bfs11234 += bfs11235

    bfs11236 = (len(text) * bfs11232)
    bfs11237 = int(ceil((log(bfs11236) / log(2))))
    bfs11241 = bfs11234[:bfs11237]
    bfs11240 = bfs11144(bfs11241, '01')
    return bfs11234[bfs11237:(bfs11237 + bfs11240)]

  def bfs11225(self, bfs11242, bfs11243):
    offset = 0
    (bfs11244, bfs11246) = list(zip(*self.bfs11223))
    bfs11245 = bfs11244.index(bfs11243)
    for index in range(0, bfs11245):
      offset += bfs11246[index]

    if (len(bfs11242) <= offset):
      return (-1)

    return bfs11144(bfs11242[offset:(offset + bfs11246[bfs11244.index(bfs11243)])], '01')


