try:
  from collections import OrderedDict
except ImportError:
  from UserDict import DictMixin
  class OrderedDict(dict, DictMixin):
    def __init__(self, *args, **bfs11435):
      if (len(args) > 1):
        raise TypeError(('expected at most 1 arguments, got %d' % len(args)))

      try:
        self.bfs11434
      except AttributeError:
        self.clear()

      self.update(*args, **bfs11435)

    def clear(self):
      self.bfs11434 = end = []
      end += [None, end, end]
      self.bfs11436 = {}
      dict.clear(self)

    def __setitem__(self, key, value):
      if (key not in self):
        end = self.bfs11434
        bfs11440 = end[1]
        bfs11440[2] = end[1] = self.bfs11436[key] = [key, bfs11440, end]

      dict.__setitem__(self, key, value)

    def __delitem__(self, key):
      dict.__delitem__(self, key)
      (key, bfs11437, next) = self.bfs11436.pop(key)
      bfs11437[2] = next
      next[1] = bfs11437

    def __iter__(self):
      end = self.bfs11434
      bfs11441 = end[2]
      while (bfs11441 is not end):
        yield bfs11441[0]
        bfs11441 = bfs11441[2]


    def __reversed__(self):
      end = self.bfs11434
      bfs11442 = end[1]
      while (bfs11442 is not end):
        yield bfs11442[0]
        bfs11442 = bfs11442[1]


    def popitem(self, bfs11444=True):
      if (not self):
        raise KeyError('dictionary is empty')

      if bfs11444:
        key = next(reversed(self))
      else:
        key = next(iter(self))

      value = self.pop(key)
      return (key, value)

    def __reduce__(self):
      items = [[k, self[k]] for k in self]
      bfs11443 = (self.bfs11436, self.bfs11434)
      del self.bfs11436
      del self.bfs11434
      bfs11445 = vars(self).copy()
      (self.bfs11436, self.bfs11434) = bfs11443
      if bfs11445:
        return (self.__class__, (items,), bfs11445)

      return (self.__class__, (items,))

    def keys(self):
      return list(self)

    setdefault = DictMixin.setdefault
    update = DictMixin.update
    pop = DictMixin.pop
    values = DictMixin.values
    items = DictMixin.items
    iterkeys = DictMixin.iterkeys
    itervalues = DictMixin.itervalues
    iteritems = DictMixin.iteritems
    def __repr__(self):
      if (not self):
        return ('%s()' % (self.__class__.__name__,))

      return ('%s(%r)' % (self.__class__.__name__, list(self.items())))

    def copy(self):
      return self.__class__(self)

    @classmethod
    def fromkeys(bfs10263, bfs11447, value=None):
      d = bfs10263()
      for key in bfs11447:
        d[key] = value

      return d

    def __eq__(self, bfs11446):
      if isinstance(bfs11446, OrderedDict):
        if (len(self) != len(bfs11446)):
          return False

        for (p, bfs11450) in zip(list(self.items()), list(bfs11446.items())):
          if (p != bfs11450):
            return False


        return True

      return dict.__eq__(self, bfs11446)

    def __ne__(self, bfs11452):
      return (not (self == bfs11452))



