from hashlib import md5
from uuid import getnode
from platform import node as bfs11247, machine, system as bfs11250
from getpass import getuser
from _socket import gethostname
from ctypes import c_ulonglong, byref
import os, platform, ctypes, sys
if hasattr(os, 'statvfs'):
  def bfs11253(path):
    bfs11251 = os.statvfs(path)
    return (bfs11251.f_blocks * bfs11251.f_frsize)

elif (os.name == 'nt'):
  def bfs11253(path):
    (bfs11252, bfs11254, bfs11256) = (c_ulonglong(), c_ulonglong(), c_ulonglong())
    if ((sys.version_info >= (3,)) or isinstance(path, unicode)):
      bfs11255 = ctypes.windll.kernel32.GetDiskFreeSpaceExW
    else:
      bfs11255 = ctypes.windll.kernel32.GetDiskFreeSpaceExA

    bfs11257 = bfs11255(path, byref(bfs11252), byref(bfs11254), byref(bfs11256))
    if (bfs11257 == 0):
      raise ctypes.WinError()

    return bfs11254.value


class bfs11261(object):
  def __init__(self):
    self.bfs11260 = None

  def bfs10232(self):
    if (self.bfs11260 is None):
      self.bfs11260 = self.bfs11262()

    return self.bfs11260

  def bfs11263(self):
    return (bfs11247() or gethostname() or 'unknown')

  def bfs11262(self):
    bfs11265 = (str(getnode()) + bfs11247())
    return md5(bfs11265.encode('ASCII')).hexdigest()

  def bfs11264(self):
    return self.bfs10232()

  def bfs11266(self):
    return self.bfs10232()

  def bfs11267(self):
    return self.bfs10232()

  def bfs10235(self):
    os = bfs11250().lower()
    if (('darwin' in os) or ('mac' in os)):
      return 'OSX'

    if ('nux' in os):
      return 'Linux'

    if (('win' in os) or ('cygwin' in os)):
      return 'Windows'

    return 'Unknown'

  def bfs10237(self):
    if (self.bfs10235() == 'OSX'):
      return platform.mac_ver()[0]

    return platform.release()

  def bfs10236(self):
    bfs11270 = ('C:\\' if (os.name == 'nt') else '/')
    return bfs11253(bfs11270)

  def bfs10240(self):
    return str('{0:x}'.format(getnode()))

  def bfs10242(self):
    return bfs11247()

  def bfs10241(self):
    return machine()

  def bfs10243(self):
    return getuser()


