from base64 import b64decode
from bfs.bfs10143.bfs10147 import InvalidLicenseFile
from bfs.bfs10063.bfs11141 import bfs11152, bfs11144
from datetime import date, datetime
from math import ceil, log
from os import path
from pkcs1 import rsaes_oaep
from pkcs1.keys import RsaPrivateKey
bfs11154 = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz-/'
class bfs11153(object):
  bfs11155 = 32
  def __init__(self, bfs10233, code, bfs11156=None, encrypted_node_identifier='', bfs10231=True, bfs11157=True, bfs11161=False, bfs11160=None, bfs11162=None):
    self.bfs10233 = bfs10233
    self.code = code
    self.bfs11156 = bfs11156
    self.encrypted_node_identifier = encrypted_node_identifier
    self.bfs10231 = bfs10231
    self.bfs11157 = bfs11157
    self.bfs11161 = bfs11161
    self.bfs11160 = bfs11160
    self.bfs11162 = bfs11162

  @property
  def bfs11163(self):
    if (not self.encrypted_node_identifier):
      return self.encrypted_node_identifier

    return self.decrypt(self.encrypted_node_identifier)

  @classmethod
  def decrypt(bfs11165, bfs11164):
    n = 126552595132100767496431298900695851144633929478317947845463894147101930730111564183119259440078050133900835449855213073742144369102834189244736695982848189036861833523332376016102290780726072320885243610990871511351145548702602510026707584848724238826408910261032648966390926399187028038467973734166869523139
    d = 47620634886441811911279006701406234418386824768677219155850665937740218712105852942916277172463872230223057250543653350192334441406304742984336354420144630234029397102707344769401491936717749314553261859131919096126529291266317948550850549782633820140042213874431692820120174629881124487475541748108487115593
    bfs11166 = RsaPrivateKey(n, d)
    return rsaes_oaep.decrypt(bfs11166, b64decode(bfs11164)).decode('ascii')

  def bfs11167(self, bfs11170=None):
    if (not self.bfs11161):
      return False

    return (self.bfs11160 < (date.today() if (bfs11170 is None) else bfs11170))

  def bfs11171(self):
    return bool(self.encrypted_node_identifier)

  def bfs11173(self, encrypted_node_identifier):
    try:
      self.decrypt(encrypted_node_identifier)
    except:
      raise ValueError(('Not a valid encrypted node identifier: %s' % encrypted_node_identifier))

    if self.bfs10231:
      self.encrypted_node_identifier = encrypted_node_identifier



class bfs11172(object):
  def __init__(self, file_path, bfs11174=None):
    if (bfs11174 is None):
      bfs11174 = []

    self.file_path = file_path
    self.bfs11174 = bfs11174

  def read(self):
    (bfs11175, key) = self.bfs11177()
    bfs11176 = bfs11200(self.bfs11174)
    bfs11202 = bfs11176.parse(bfs11175, key)
    bfs11202.bfs11156 = self.bfs11156
    return bfs11202

  def bfs11177(self):
    with open(self.file_path, 'r') as bfs11201:
      bfs11203 = bfs11201.readline().rstrip()
      key = bfs11201.readline().rstrip()
      if ((not bfs11203) or (not key)):
        raise InvalidLicenseFile()

      return (bfs11203, key)


  def write(self, bfs11205):
    with open(self.file_path, 'w') as bfs11204:
      bfs11204.write((bfs11205.bfs10233 + '\n'))
      key = bfs11205.code
      if bfs11205.bfs10231:
        key += bfs11205.encrypted_node_identifier

      bfs11204.write((key + '\n'))


  def exists(self):
    return path.exists(self.file_path)

  @property
  def bfs11156(self):
    return datetime.fromtimestamp(path.getmtime(self.file_path))


class bfs11200(object):
  def __init__(self, bfs11174=None):
    if (bfs11174 is None):
      bfs11174 = []

    self.bfs11174 = bfs11174

  def parse(self, bfs11206, key):
    code = key[:bfs11153.bfs11155]
    bfs11210 = key[bfs11153.bfs11155:]
    try:
      if (code in self.bfs11174):
        return self.bfs11207(bfs11206, code, bfs11210)
      else:
        return self.bfs11211(bfs11206, code, bfs11210)

    except ValueError:
      return bfs11153(bfs11206, code, encrypted_node_identifier=bfs11210)


  def bfs11207(self, bfs11212, code, encrypted_node_identifier):
    bfs11213 = True
    bfs11214 = True
    bfs11215 = False
    bfs11217 = None
    try:
      bfs11216 = int(code[:1])
    except ValueError:
      bfs11216 = None

    return bfs11153(bfs11212, code, None, encrypted_node_identifier, bfs11213, bfs11214, bfs11215, bfs11217, bfs11216)

  def bfs11211(self, bfs11220, code, encrypted_node_identifier):
    bfs11222 = bfs11221(code)
    bfs10231 = bfs11222.bfs10231
    bfs11157 = bfs11222.bfs11157
    bfs11161 = bfs11222.bfs11161
    bfs11160 = bfs11222.bfs11160
    bfs11162 = bfs11222.bfs11162
    return bfs11153(bfs11220, code, None, encrypted_node_identifier, bfs10231, bfs11157, bfs11161, bfs11160, bfs11162)


class bfs11223:
  bfs11224 = 0
  bfs11226 = 1
  bfs11225 = 2
  bfs11227 = 3
  bfs11231 = 4
  bfs11230 = 5
  bfs11232 = 6

class bfs11221(object):
  bfs11234 = [(bfs11223.bfs11224, 5), (bfs11223.bfs11226, 1), (bfs11223.bfs11225, 1), (bfs11223.bfs11227, 1), (bfs11223.bfs11231, 7), (bfs11223.bfs11230, 4), (bfs11223.bfs11232, 5)]
  def __init__(self, code):
    self.code = code
    bfs11233 = self.bfs11235(self.code)
    self.bfs11162 = self.bfs11236(bfs11233, bfs11223.bfs11224)
    self.bfs11157 = (self.bfs11236(bfs11233, bfs11223.bfs11226) > 0)
    self.bfs10231 = (self.bfs11236(bfs11233, bfs11223.bfs11225) > 0)
    self.bfs11161 = (self.bfs11236(bfs11233, bfs11223.bfs11227) > 0)
    bfs11160 = None
    if self.bfs11161:
      bfs11237 = (2000 + self.bfs11236(bfs11233, bfs11223.bfs11231))
      bfs11241 = self.bfs11236(bfs11233, bfs11223.bfs11230)
      bfs11240 = self.bfs11236(bfs11233, bfs11223.bfs11232)
      bfs11160 = date(bfs11237, bfs11241, bfs11240)

    self.bfs11160 = bfs11160

  def bfs11235(self, text):
    bfs11242 = 6
    assert (len(bfs11154) == (2 ** bfs11242))
    bfs11243 = ''
    for bfs11244 in text:
      bfs11246 = bfs11144(bfs11152(bfs11244, bfs11154), '01')
      while (len(bfs11246) < bfs11242):
        bfs11246 = ('0' + bfs11246)

      bfs11243 += bfs11246

    bfs11245 = (len(text) * bfs11242)
    bfs11247 = int(ceil((log(bfs11245) / log(2))))
    bfs11250 = bfs11243[:bfs11247]
    bfs11251 = bfs11152(bfs11250, '01')
    return bfs11243[bfs11247:(bfs11247 + bfs11251)]

  def bfs11236(self, bfs11253, bfs11252):
    offset = 0
    (bfs11254, bfs11256) = list(zip(*self.bfs11234))
    bfs11255 = bfs11254.index(bfs11252)
    for index in range(0, bfs11255):
      offset += bfs11256[index]

    if (len(bfs11253) <= offset):
      return (-1)

    return bfs11152(bfs11253[offset:(offset + bfs11256[bfs11254.index(bfs11252)])], '01')


