from hashlib import md5
from uuid import getnode
from platform import node as bfs11257, machine, system as bfs11261
from getpass import getuser
from _socket import gethostname
from ctypes import c_ulonglong, byref
import os, platform, ctypes, sys
if hasattr(os, 'statvfs'):
  def bfs11262(path):
    bfs11260 = os.statvfs(path)
    return (bfs11260.f_blocks * bfs11260.f_frsize)

elif (os.name == 'nt'):
  def bfs11262(path):
    (bfs11263, bfs11265, bfs11264) = (c_ulonglong(), c_ulonglong(), c_ulonglong())
    if ((sys.version_info >= (3,)) or isinstance(path, str)):
      bfs11266 = ctypes.windll.kernel32.GetDiskFreeSpaceExW
    else:
      bfs11266 = ctypes.windll.kernel32.GetDiskFreeSpaceExA

    bfs11267 = bfs11266(path, byref(bfs11263), byref(bfs11265), byref(bfs11264))
    if (bfs11267 == 0):
      raise ctypes.WinError()

    return bfs11265.value


class bfs11270(object):
  def __init__(self):
    self.bfs11271 = None

  def bfs10232(self):
    if (self.bfs11271 is None):
      self.bfs11271 = self.bfs11273()

    return self.bfs11271

  def bfs11272(self):
    return (bfs11257() or gethostname() or 'unknown')

  def bfs11273(self):
    bfs11274 = (str(getnode()) + bfs11257())
    return md5(bfs11274.encode('ASCII')).hexdigest()

  def bfs11275(self):
    return self.bfs10232()

  def bfs11277(self):
    return self.bfs10232()

  def bfs11276(self):
    return self.bfs10232()

  def bfs10235(self):
    os = bfs11261().lower()
    if (('darwin' in os) or ('mac' in os)):
      return 'OSX'

    if ('nux' in os):
      return 'Linux'

    if (('win' in os) or ('cygwin' in os)):
      return 'Windows'

    return 'Unknown'

  def bfs10237(self):
    if (self.bfs10235() == 'OSX'):
      return platform.mac_ver()[0]

    return platform.release()

  def bfs10236(self):
    bfs11300 = ('C:\\' if (os.name == 'nt') else '/')
    return bfs11262(bfs11300)

  def bfs10240(self):
    return str('{0:x}'.format(getnode()))

  def bfs10242(self):
    return bfs11257()

  def bfs10241(self):
    return machine()

  def bfs10243(self):
    return getuser()


