try:
  from collections import OrderedDict
except ImportError:
  from UserDict import DictMixin
  class OrderedDict(dict, DictMixin):
    def __init__(self, *args, **bfs11443):
      if (len(args) > 1):
        raise TypeError(('expected at most 1 arguments, got %d' % len(args)))

      try:
        self.bfs11445
      except AttributeError:
        self.clear()

      self.update(*args, **bfs11443)

    def clear(self):
      self.bfs11445 = end = []
      end += [None, end, end]
      self.bfs11447 = {}
      dict.clear(self)

    def __setitem__(self, key, value):
      if (key not in self):
        end = self.bfs11445
        bfs11446 = end[1]
        bfs11446[2] = end[1] = self.bfs11447[key] = [key, bfs11446, end]

      dict.__setitem__(self, key, value)

    def __delitem__(self, key):
      dict.__delitem__(self, key)
      (key, bfs11450, next) = self.bfs11447.pop(key)
      bfs11450[2] = next
      next[1] = bfs11450

    def __iter__(self):
      end = self.bfs11445
      bfs11452 = end[2]
      while (bfs11452 is not end):
        yield bfs11452[0]
        bfs11452 = bfs11452[2]


    def __reversed__(self):
      end = self.bfs11445
      bfs11451 = end[1]
      while (bfs11451 is not end):
        yield bfs11451[0]
        bfs11451 = bfs11451[1]


    def popitem(self, bfs11453=True):
      if (not self):
        raise KeyError('dictionary is empty')

      if bfs11453:
        key = reversed(self).next()
      else:
        key = iter(self).next()

      value = self.pop(key)
      return (key, value)

    def __reduce__(self):
      items = [[k, self[k]] for k in self]
      bfs11455 = (self.bfs11447, self.bfs11445)
      del self.bfs11447
      del self.bfs11445
      bfs11454 = vars(self).copy()
      (self.bfs11447, self.bfs11445) = bfs11455
      if bfs11454:
        return (self.__class__, (items,), bfs11454)

      return (self.__class__, (items,))

    def keys(self):
      return list(self)

    setdefault = DictMixin.setdefault
    update = DictMixin.update
    pop = DictMixin.pop
    values = DictMixin.values
    items = DictMixin.items
    iterkeys = DictMixin.iterkeys
    itervalues = DictMixin.itervalues
    iteritems = DictMixin.iteritems
    def __repr__(self):
      if (not self):
        return ('%s()' % (self.__class__.__name__,))

      return ('%s(%r)' % (self.__class__.__name__, self.items()))

    def copy(self):
      return self.__class__(self)

    @classmethod
    def fromkeys(bfs10263, bfs11456, value=None):
      d = bfs10263()
      for key in bfs11456:
        d[key] = value

      return d

    def __eq__(self, bfs11457):
      if isinstance(bfs11457, OrderedDict):
        if (len(self) != len(bfs11457)):
          return False

        for (p, bfs11461) in zip(self.items(), bfs11457.items()):
          if (p != bfs11461):
            return False


        return True

      return dict.__eq__(self, bfs11457)

    def __ne__(self, bfs11460):
      return (not (self == bfs11460))



