from tornado import web
from tornado import httpclient

import hens


class RequestHandler(web.RequestHandler):
    request_class = hens.Request
    response_class = hens.Response

    def initialize(self, acceptor_class):
        self.acceptor_class = acceptor_class

    @web.asynchronous
    def post(self):
        raw_request = self.request.body

        acceptor = self.acceptor_class(**self.settings)
        request = None

        def _executed(result=None):
            response = self.response_class(request=request, result=result)
            raw_response = response.as_raw()

            self.write(raw_response)
            self.finish()

        try:
            request = self.request_class.get_from_raw(raw_request)
            request.execute(acceptor, _executed)

        except hens.Error as error:
            _executed(error)


class Client(hens.Client):
    def init(self, url, **kwargs):
        self.url = url
        self.http_client = httpclient.HTTPClient()

    def _fetch_call(self, raw_request):
        http_request = httpclient.HTTPRequest(
            self.url, method="POST",
            body=raw_request)

        http_response = self.http_client.fetch(http_request)
        raw_response = http_response.body

        return raw_response


class JSONRequestHandler(RequestHandler):
    request_class = hens.JSONRequest
    response_class = hens.JSONResponse


class JSONClient(hens.JSONClient, Client):
    pass


class cPickleRequestHandler(RequestHandler):
    request_class = hens.cPickleRequest
    response_class = hens.cPickleResponse


class cPickleClient(hens.cPickleClient, Client):
    pass
