from setuptools import find_packages, setup

setup(
      name='hgcp',
      version='0.11',
      namespace_packages=['codeviking', 'codeviking.hg'],
      url='http://hg.codeviking.com/hgcp/',
      author='Dan Bullok',
      author_email='opensource@codeviking.com',
      description='Mercurial cross-reposititory copy and move.',
      classifiers=[
            'Development Status :: 4 - Beta',
            'Environment :: Console',
            'Intended Audience :: Developers',
            'License :: OSI Approved :: GNU General Public License (GPL)',
            'Natural Language :: English',
            'Operating System :: OS Independent',
            'Programming Language :: Python',
            'Topic :: Software Development :: Version Control'
            ],
      platforms='any',
      packages=find_packages(),
      entry_points={
            'console_scripts': [
                    'hgcp = codeviking.hg.hgcp.commands:cmd_copy',
                    'hgmv = codeviking.hg.hgcp.commands:cmd_move',
                    ]
            },
      install_requires=['distribute']
      )

