'''
Created on Mar 30, 2012

@author: dan
'''
import json, os, shutil, tempfile, unittest, xml.etree.ElementTree
from os.path import join
from StringIO import StringIO
import pprint, subprocess
from nose.tools import nottest

# cross_repo_copy must raise exceptions:
# InvalidRepositoryError
# FileExistsError
# InvalidFileError

from codeviking.hg.hgcp.commands import (rep_cmd, hg_log, cross_repo_copy,
InvalidRepositoryError, DestinationFileExists, NonExistentFile)
from subprocess import CalledProcessError

import pprint


class Test(unittest.TestCase):

    def get_path(self, repo_num, path):
        return join(self.get_repo(repo_num), path)

#    @nottest
    def test_copy__basic_new(self):
        sp = self.get_path(0, 'a0/b0/c0.0')
        dp = self.get_path(2, '')
        cross_repo_copy([sp], dp)
        self.assert_files_equal((0, 'a0/b0/c0.0'), (2, 'a0/b0/c0.0'))
        rep_cmd(self.get_repo(0), 'commit', '-m', 'copy from rep 0')
        #open('bn.log', 'w').write(pprint.pformat(hg_log(self.get_repo(2))))

    def test_copy__basic_existing(self):
        sp = self.get_path(0, 'a0/b0/c0.0')
        dp = self.get_path(1, '')
        cross_repo_copy([sp], dp)
        self.assert_files_equal((0, 'a0/b0/c0.0'), (1, 'a0/b0/c0.0'))
        rep_cmd(self.get_repo(1), 'commit', '-m', 'copy from rep 1')
        #open('be.log', 'w').write(pprint.pformat(hg_log(self.get_repo(1))))

    def test_copy__bad_src(self):
        sp = self.get_path(0, 'a0/b0/c0')
        dp = self.get_path(1, '')
        self.assertRaises(NonExistentFile, cross_repo_copy, [sp], dp)

    def test_copy__bad_src_multi(self):
        sp0 = self.get_path(0, 'a0/b0/c0')
        sp1 = self.get_path(0, 'a0/b0/d0')
        dp = self.get_path(1, '')
        self.assertRaises(NonExistentFile, cross_repo_copy, [sp0, sp1], dp)

    def test_copy__bad_src_repos(self):
        fd, sp = tempfile.mkstemp(prefix='nonrepo.')
        os.write(fd, 'test')
        os.close(fd)
        dp = self.get_path(1, '')
        self.assertRaises(InvalidRepositoryError, cross_repo_copy, [sp], dp)
        os.remove(sp)

    def test_copy__exclude(self):
        sp = self.get_path(0, 'a0/b0/c0.0')
        dp = self.get_path(1, '')
        cross_repo_copy([sp], dp, ['a0/b0'])
        self.assert_files_equal((0, 'a0/b0/c0.0'), (1, 'c0.0'))
        rep_cmd(self.get_repo(0), 'commit', '-m', 'copy from rep 0')

    def assert_files_equal(self, f0, f1):
        self.assertEqual(self.get_file_content(*f0),
                         self.get_file_content(*f1))

    def get_file_content(self, repo_num, path):
        rp = self.get_repo(repo_num)
        return open(join(rp, path), 'r').read()


    INIT0 = (('init', 0),
             ('create', 0, 'a0/b0/c0'),
             ('create', 0, 'a0/b0/c1'),
             ('create', 0, 'a0/b0/c2'),
             ('create', 0, 'a0/b1/c0'),
             ('create', 0, 'a0/b1/c1'),
             ('move', 0, 'a0/b0/c0', 'a0/b0/c0.0'),
             ('modify', 0, 'a0/b0/c0.0'),
             ('copy', 0, 'a0/b0/c0.0', 'a0/b0/c0.1')
             )

    INIT1 = (('init', 1),
             ('create', 1, 'a0/b0/c0'),
             ('create', 1, 'a1/b0/c0'),
             ('create', 1, 'a1/b0/c1'),
             ('create', 1, 'a1/b0/c2'),
             ('create', 1, 'a1/b1/c0'),
             ('create', 1, 'a1/b1/c1'),
             )

    INIT2 = (('init', 2),
             )

    def get_repo(self, repo_num):
        assert repo_num in (0, 1, 2)
        return getattr(self, 'repo%d' % repo_num)

    def init(self, repo):
        rp = self.get_repo(repo)
        rep_cmd(rp, 'init')

    def create(self, repo, path):
        rp = self.get_repo(repo)
        fp = join(rp, path)
        dp = os.path.dirname(fp)
        if not os.path.exists(dp):
            os.makedirs(dp)
        assert os.path.isdir(dp)
        open(fp, 'w').write(os.path.basename(path))
        rep_cmd(rp, 'add', path)
        rep_cmd(rp, 'commit', '-m', 'added %s' % path)

    def remove(self, repo, path):
        rp = self.get_repo(repo)
        rep_cmd(rp, 'remove', path)
        rep_cmd(rp, 'commit', '-m', 'removed %s' % path)

    def copy(self, repo, src_path, dest_path):
        rp = self.get_repo(repo)
        rep_cmd(rp, 'copy', src_path, dest_path)
        rep_cmd(rp, 'commit',
                '-m', 'copied %s -> %s' % (src_path, dest_path))

    def move(self, repo, src_path, dest_path):
        rp = self.get_repo(repo)
        rep_cmd(rp, 'move', src_path, dest_path)
        rep_cmd(rp, 'commit',
                '-m', 'moved %s -> %s' % (src_path, dest_path))

    def merge(self, repo):
        rp = self.get_repo(repo)
        rep_cmd(rp, 'merge')

    def modify(self, repo, path):
        rp = self.get_repo(repo)
        fp = join(rp, path)
        assert os.path.isfile(fp)
        open(fp, 'a').write('modified: ' + os.path.basename(path))
        rep_cmd(rp, 'commit', '-m', 'modified %s' % path)

    def playback(self, seq):
        for args in seq:
            c = args[0]
            args = args[1:]
            f = getattr(self, c)
            f(*args)

    def setUp(self):
        self.repo0 = tempfile.mkdtemp(prefix='repo0.')
        self.repo1 = tempfile.mkdtemp(prefix='repo1.')
        self.repo2 = tempfile.mkdtemp(prefix='repo2.')
        for S in [self.INIT0, self.INIT1, self.INIT2]:
            self.playback(S)

    def tearDown(self):
        shutil.rmtree(self.repo0)
        shutil.rmtree(self.repo1)
        shutil.rmtree(self.repo2)

    # modify 1:a
    # 1: commit -m 'modified a'
    # 1: mv a -> a.new
    # 1: commit -m 'moved a to a.new'
    # hgcp 1:a.new -> 2:a.new
    # 2: commit -m 'copied 2:a.new from 1'
    # does 2:a.new have records back to beginning?





if __name__ == "__main__":
    #import sys;sys.argv = ['', 'Test.testName']
    unittest.main()
