# -*- coding: utf-8 -*-
# Pigs need libraries too

import autfunc
import re
import os

class ChangeSet:
    def __init__(self):
        self.parents = []
        self.label = ""
        self.rev = ""
        self.node = ""
        self.summary = ""

template = """NEW_CHANGESET
changeset:{rev}
node:{node}
users:{author}
date:{date|date}
summary:{desc|firstline}"""
        
# Check for outgoing things
def parse_log_output(output,strip_merge=True):
    lines = map(lambda x: x.strip(), output.split("\n"))
    changesets = []
    for l in lines:
        if l[:10] == "changeset:":
            changesets.append(ChangeSet())
        if l[:10] == "changeset:":
            changesets[-1].label = l[13:]
            changesets[-1].rev = l[13:].split(':')[0]
            changesets[-1].node = l[13:].split(':')[1]
        if l[:7] == "parent:":
            changesets[-1].parents.append(l[13:])
        if l[:8] == "summary:":
            changesets[-1].summary = l[13:]

    if strip_merge:
        return [c for c in changesets if len(c.parents) <= 1]
    else:
        return changesets

def is_repo(repo):
    if os.path.exists(repo):
        hog_box = os.path.join( repo, ".hg" )
        if os.path.exists( hog_box ):
            return True
    return False

def find_outgoing( repo, strip_merge = False ):
    assert is_repo(repo), "The path %s does not contain a hg clone." % repo

    output={}
    autfunc.run2("hg", "-R \"%s\" outgoing" % (repo,), output=output)
    return parse_log_output(output["StdOut"], strip_merge)

def special_dir_files(repo, name, add_exclusions=None):
    assert is_repo(repo), "The path {0} does not contain a hg clone.".format(repo)

    exclusions = '.hgignore .hg'.split(' ')
    if add_exclusions is not None:
        exclusions += list(add_exclusions)

    spec_dir = os.path.join(repo, ".hg", name)
    if os.path.exists(spec_dir):
        l = [f for f in os.listdir(spec_dir) if not os.path.isdir(f)]
        return filter(lambda x: x not in exclusions, l)
    else:
        return []

def mq_files(repo):
    """
    Patch files generated by the mq extension.
    """
    return special_dir_files(repo, "patches", add_exclusions=['status', 'series'])

def shelf_files(repo):
    """
    Patch files generated by the tortoisehg shelf tool
    """
    return special_dir_files(repo, "shelves")

def attic_files(repo):
    """
    Patch files generated by the attic extension.  See
    http://mercurial.selenic.com/wiki/AtticExtension 
    """
    return special_dir_files(repo, "attic")

special_dir_searches = [
        ('>M', mq_files, 'MQ queued patches'),
        ('>S', shelf_files, 'TortoiseHg shelf patches'),
        ('>A', attic_files, 'Attic extension archived patches')]

def stat_parse(status_output, include_unknown=False):
    lines = status_output.split('\n')
    lines = [(l[0], l[2:].strip('\r\n')) for l in lines if l.strip('\r\n ') != ""]
    return [l for l in lines if (include_unknown or l[0] != "?")]

def local_uncommitted(repo):
    assert is_repo(repo), "The path %s does not contain a hg clone." % repo

    output={}
    autfunc.run2("hg", "-R \"%s\" status" % (repo,), output=output)

    lines = output["StdOut"].split('\n')[:-1]
    lines = [(l[0], l[2:].strip('\r\n')) for l in lines]
    return [l for l in lines if l[0] != "?"]

def default_push(repo):
    lines = open( os.path.join( repo, ".hg", "hgrc" ), "r" ).readlines()
    lines = [l.strip('\r\n') for l in lines if l.strip('\r\n') != ""]
    if lines[0] == '[paths]':
        match = re.match("default *= *(.*)",lines[1])
        if match:
            return match.group(1)
    return None

# this is not technically correct
# you can specify different pull & push locations and so the functions should return the correct ones ... we'll get to that when we need it.
default_pull = default_push

def recent_logs(repo,max_entries=45):
    assert is_repo(repo), "The path %s does not contain a hg clone." % repo

    output={}
    autfunc.run2("hg", "-R \"%s\" log -l %i" % (repo,max_entries), output=output)
    return parse_log_output(output["StdOut"])
