# -*- coding: utf-8 -*-
"""Setup the hiringpond application"""

import logging
import transaction
from tg import config

def setup_schema(command, conf, vars):
    """Place any commands to setup hiringpond here"""
    # Load the models

    # <websetup.websetup.schema.before.model.import>
    from hiringpond import model
    # <websetup.websetup.schema.after.model.import>

    
    # <websetup.websetup.schema.before.metadata.create_all>
    print "Creating tables"
    model.metadata.create_all(bind=config['pylons.app_globals'].sa_engine)
    # <websetup.websetup.schema.after.metadata.create_all>
    transaction.commit()
    from migrate.versioning.shell import main
    main(argv=['version_control'], url=config['sqlalchemy.url'], repository='migration', name='migration')
