from setuptools import setup, find_packages


setup(name='hisparc-sapphire',
      version='0.9.4',
      packages=find_packages(),
      url='http://github.com/hisparc/sapphire/',
      license='GPLv3',
      author='David Fokkema',
      author_email='davidf@nikhef.nl',
      description='A framework for the HiSPARC experiment',
      long_description=open('README.rst').read(),
      keywords=['HiSPARC', 'Nikhef', 'cosmic rays'],
      classifiers=['Intended Audience :: Science/Research',
                   'Intended Audience :: Education',
                   'Operating System :: OS Independent',
                   'Programming Language :: Python',
                   'Programming Language :: Python :: 2.7',
                   'Topic :: Scientific/Engineering',
                   'Topic :: Education',
                   'License :: OSI Approved :: GNU General Public License v3 (GPLv3)'],
      package_data={'sapphire': ['simulations/qsub.sh',
                                 'corsika/LICENSE']},
      install_requires=['numpy', 'scipy', 'tables', 'matplotlib',
                        'progressbar', 'mock'])
