
Hiveary Agent
=============

About
-----

Hiveary Agent by Hiveary, Inc. <info@hiveary.com>
<https://github.com/hiveary/hiveary-agent>
Version 1.4.0

Hiveary is an intelligent server monitoring solution that automatically finds anomalies.


Installation
--------------------------

Download the source code and run `python setup.py install`.


Configuration (Linux and OSX)
--------------------------

1. First ensure you have signed up for an account at [https://hiveary.com](hiveary.com).
2. Grab your existing access token or generate a new one at [https://hiveary.com/tokens](hiveary.com/tokens.)
3. Set up _/etc/hiveary.conf_ with a json object containing your username, access_token, and the enabled monitors. You can copy _/etc/hiveary.conf.example_ as a template.
4. And thats it! All setup.


Configuration (Windows)
--------------------------

The recommended way to run on Windows is to use a prebuilt installer, available
from [https://hiveary.com/agent/install](hiveary.com/agent/install.) Otherwise follow these instructions to install from source.

1. Install [http://sourceforge.net/projects/pywin32/files/pywin32/](pywin32.)
2. Ensure you have signed up for an account at hiveary.com.
3. Grab your existing access token or generate a new one at [https://hiveary.com/tokens](hiveary.com/tokens.)
4. Create a Hiveary subfolder in the CommonAppDataFolder. On XP this should be _C:\Documents and Settings\All Users\Application Data\Hiveary_, and on Vista or higher it is _C:\ProgramData\Hiveary_.
4. Set up _hiveary.conf_ in the new subfolder with a json object containing your username, access_token, and the enabled monitors. You can copy _/etc/hiveary.conf.example_ as a template.
5. And thats it! All setup.


Running
---------

The agent is designed to run in the background as a daemon; however, running it
with no arguments will cause it to run in the foreground.
There are a number of flags to overide default behavior.

    usage: hiveary-agent [-h] [-t ACCESS_TOKEN] [-s SERVER] [-c CONFIG_FILE] [-u]
                         [-d] [--disable_ssl_verify] [--amqp_server AMQP_SERVER]
                         [--ca_bundle CA_BUNDLE] [--username USERNAME]
                         [{start,stop,restart,status}]

    positional arguments:
      {start,stop,restart,status}

    optional arguments:
      -h, --help            show this help message and exit
      -t ACCESS_TOKEN, --access_token ACCESS_TOKEN
                            OAuth access token generated by the server.
      -s SERVER, --server SERVER
      -c CONFIG_FILE, --config_file CONFIG_FILE
                            Location of config file. (default: config.json)
      -u, --update          Store the passed values in the configuration file
      -d, --debug           Enable debug mode
      --disable_ssl_verify  Disable SSL certificate verification
      --amqp_server AMQP_SERVER
                            Address of the AMQP server. Defaults to the subdomain
                            "amqp" of the server address (ie amqp.hiveary.com).
      --ca_bundle CA_BUNDLE
                            Location of the CA bundle for SSL verification. Has no
                            effect when combined with --disable_ssl_verify.
      --username USERNAME


Logs
--------------------------
On Windows, the agent logs are located under the CommonAppDataFolder. For XP, the folder is _C:\Documents and Settings\All Users\Application Data\Hiveary\logs_, For Vista and higher, the folder is _C:\ProgramData\Hiveary\logs_
On OS X and Linux, the agent logs are located in _/var/log/hiveary_.
