# -*- coding: utf-8 -*-
#
# Copyright (c) 2012-2013, CRS4
#
# Permission is hereby granted, free of charge, to any person obtaining a copy of
# this software and associated documentation files (the "Software"), to deal in
# the Software without restriction, including without limitation the rights to
# use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
# the Software, and to permit persons to whom the Software is furnished to do so,
# subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
# FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
# COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
# IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
# CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

FIELDS = {'ACC_1': ('leaf', 'TS', 'ACCIDENT_DATE_TIME', None),
 'ACC_2': ('leaf', 'ID', 'ACCIDENT_CODE', None),
 'ACC_3': ('leaf', 'ST', 'ACCIDENT_LOCATION', None),
 'ADD_1': ('leaf', 'ST', 'ADDENDUM_CONTINUATION_POINTER', None),
 'AL1_1': ('leaf', 'SI', 'SET_ID_ALLERGY', None),
 'AL1_2': ('leaf', 'ID', 'ALLERGY_TYPE', None),
 'AL1_3': ('leaf', 'CE', 'ALLERGY_CODE_MNEMONIC_DESCRIPTION', None),
 'AL1_4': ('leaf', 'ID', 'ALLERGY_SEVERITY', None),
 'AL1_5': ('leaf', 'ST', 'ALLERGY_REACTION', None),
 'AL1_6': ('leaf', 'DT', 'IDENTIFICATION_DATE', None),
 'BHS_1': ('leaf', 'ST', 'BATCH_FIELD_SEPARATOR', None),
 'BHS_10': ('leaf', 'ST', 'BATCH_COMMENT', None),
 'BHS_11': ('leaf', 'ST', 'BATCH_CONTROL_ID', None),
 'BHS_12': ('leaf', 'ST', 'REFERENCE_BATCH_CONTROL_ID', None),
 'BHS_2': ('leaf', 'ST', 'BATCH_ENCODING_CHARACTERS', None),
 'BHS_3': ('leaf', 'ST', 'BATCH_SENDING_APPLICATION', None),
 'BHS_4': ('leaf', 'ST', 'BATCH_SENDING_FACILITY', None),
 'BHS_5': ('leaf', 'ST', 'BATCH_RECEIVING_APPLICATION', None),
 'BHS_6': ('leaf', 'ST', 'BATCH_RECEIVING_FACILITY', None),
 'BHS_7': ('leaf', 'TS', 'BATCH_CREATION_DATE_TIME', None),
 'BHS_8': ('leaf', 'ST', 'BATCH_SECURITY', None),
 'BHS_9': ('leaf', 'ST', 'BATCH_NAME_ID_TYPE', None),
 'BLG_1': ('leaf', 'CCD', 'WHEN_TO_CHARGE', None),
 'BLG_2': ('leaf', 'ID', 'CHARGE_TYPE', None),
 'BLG_3': ('leaf', 'ACCOUNTNO', 'ACCOUNT_ID', None),
 'BTS_1': ('leaf', 'ST', 'BATCH_MESSAGE_COUNT', None),
 'BTS_2': ('leaf', 'ST', 'BATCH_COMMENT', None),
 'BTS_3': ('leaf', 'BATCHTOTAL', 'BATCH_TOTALS', None),
 'DG1_1': ('leaf', 'SI', 'SET_ID_DIAGNOSIS', None),
 'DG1_10': ('leaf', 'ID', 'DRG_GROUPER_REVIEW_CODE', None),
 'DG1_11': ('leaf', 'ID', 'OUTLIER_TYPE', None),
 'DG1_12': ('leaf', 'NM', 'OUTLIER_DAYS', None),
 'DG1_13': ('leaf', 'NM', 'OUTLIER_COST', None),
 'DG1_14': ('leaf', 'ST', 'GROUPER_VERSION_AND_TYPE', None),
 'DG1_15': ('leaf', 'NM', 'DIAGNOSIS_DRG_PRIORITY', None),
 'DG1_16': ('leaf', 'PERSON', 'DIAGNOSING_CLINICIAN', None),
 'DG1_2': ('leaf', 'ID', 'DIAGNOSIS_CODING_METHOD', None),
 'DG1_3': ('leaf', 'ID', 'DIAGNOSIS_CODE', None),
 'DG1_4': ('leaf', 'ST', 'DIAGNOSIS_DESCRIPTION', None),
 'DG1_5': ('leaf', 'TS', 'DIAGNOSIS_DATE_TIME', None),
 'DG1_6': ('leaf', 'ID', 'DIAGNOSIS_DRG_TYPE', None),
 'DG1_7': ('leaf', 'CE', 'MAJOR_DIAGNOSTIC_CATEGORY', None),
 'DG1_8': ('leaf', 'ID', 'DIAGNOSTIC_RELATED_GROUP', None),
 'DG1_9': ('leaf', 'ID', 'DRG_APPROVAL_INDICATOR', None),
 'DSC_1': ('leaf', 'ST', 'CONTINUATION_POINTER', None),
 'DSP_1': ('leaf', 'SI', 'SET_ID_DISPLAY_DATA', None),
 'DSP_2': ('leaf', 'SI', 'DISPLAY_LEVEL', None),
 'DSP_3': ('leaf', 'TX', 'DATA_LINE', None),
 'DSP_4': ('leaf', 'ST', 'LOGICAL_BREAK_POINT', None),
 'DSP_5': ('leaf', 'TX', 'RESULT_ID', None),
 'ERR_1': ('leaf', 'ELD', 'ERROR_CODE_AND_LOCATION', None),
 'EVN_1': ('leaf', 'ID', 'EVENT_TYPE_CODE', None),
 'EVN_2': ('leaf', 'TS', 'DATE_TIME_OF_EVENT', None),
 'EVN_3': ('leaf', 'TS', 'DATE_TIME_PLANNED_EVENT', None),
 'EVN_4': ('leaf', 'ID', 'EVENT_REASON_CODE', None),
 'EVN_5': ('leaf', 'ID', 'OPERATOR_ID', None),
 'FHS_1': ('leaf', 'ST', 'FILE_FIELD_SEPARATOR', None),
 'FHS_10': ('leaf', 'ST', 'FILE_HEADER_COMMENT', None),
 'FHS_11': ('leaf', 'ST', 'FILE_CONTROL_ID', None),
 'FHS_12': ('leaf', 'ST', 'REFERENCE_FILE_CONTROL_ID', None),
 'FHS_2': ('leaf', 'ST', 'FILE_ENCODING_CHARACTERS', None),
 'FHS_3': ('leaf', 'ST', 'FILE_SENDING_APPLICATION', None),
 'FHS_4': ('leaf', 'ST', 'FILE_SENDING_FACILITY', None),
 'FHS_5': ('leaf', 'ST', 'FILE_RECEIVING_APPLICATION', None),
 'FHS_6': ('leaf', 'ST', 'FILE_RECEIVING_FACILITY', None),
 'FHS_7': ('leaf', 'TS', 'FILE_CREATION_DATE_TIME', None),
 'FHS_8': ('leaf', 'ST', 'FILE_SECURITY', None),
 'FHS_9': ('leaf', 'ST', 'FILE_NAME_ID', None),
 'FT1_1': ('leaf', 'SI', 'SET_ID_FINANCIAL_TRANSACTION', None),
 'FT1_10': ('leaf', 'NM', 'TRANSACTION_QUANTITY', None),
 'FT1_11': ('leaf', 'NM', 'TRANSACTION_AMOUNT_EXTENDED', None),
 'FT1_12': ('leaf', 'NM', 'TRANSACTION_AMOUNT_UNIT', None),
 'FT1_13': ('leaf', 'CE', 'DEPARTMENT_CODE', None),
 'FT1_14': ('leaf', 'ID', 'INSURANCE_PLAN_ID', None),
 'FT1_15': ('leaf', 'NM', 'INSURANCE_AMOUNT', None),
 'FT1_16': ('leaf', 'INTERNALLOCATION', 'ASSIGNED_PATIENT_LOCATION', None),
 'FT1_17': ('leaf', 'ID', 'FEE_SCHEDULE', None),
 'FT1_18': ('leaf', 'ID', 'PATIENT_TYPE', None),
 'FT1_19': ('leaf', 'CE', 'DIAGNOSIS_CODE', None),
 'FT1_2': ('leaf', 'ST', 'TRANSACTION_ID', None),
 'FT1_20': ('leaf', 'PERSON', 'PERFORMED_BY_CODE', None),
 'FT1_21': ('leaf', 'PERSON', 'ORDERED_BY_CODE', None),
 'FT1_22': ('leaf', 'NM', 'UNIT_COST', None),
 'FT1_23': ('leaf', 'FILLER', 'FILLER_ORDER_NUMBER', None),
 'FT1_3': ('leaf', 'ST', 'TRANSACTION_BATCH_ID', None),
 'FT1_4': ('leaf', 'DT', 'TRANSACTION_DATE', None),
 'FT1_5': ('leaf', 'DT', 'TRANSACTION_POSTING_DATE', None),
 'FT1_6': ('leaf', 'ID', 'TRANSACTION_TYPE', None),
 'FT1_7': ('leaf', 'CE', 'TRANSACTION_CODE', None),
 'FT1_8': ('leaf', 'ST', 'TRANSACTION_DESCRIPTION', None),
 'FT1_9': ('leaf', 'ST', 'TRANSACTION_DESCRIPTION_ALTERNATE', None),
 'FTS_1': ('leaf', 'NM', 'FILE_BATCH_COUNT', None),
 'FTS_2': ('leaf', 'ST', 'FILE_TRAILER_COMMENT', None),
 'GT1_1': ('leaf', 'SI', 'SET_ID_GUARANTOR', None),
 'GT1_10': ('leaf', 'ID', 'GUARANTOR_TYPE', None),
 'GT1_11': ('leaf', 'ID', 'GUARANTOR_RELATIONSHIP', None),
 'GT1_12': ('leaf', 'ST', 'GUARANTOR_SOCIAL_SECURITY_NUMBER', None),
 'GT1_13': ('leaf', 'DT', 'GUARANTOR_DATE_BEGIN', None),
 'GT1_14': ('leaf', 'DT', 'GUARANTOR_DATE_END', None),
 'GT1_15': ('leaf', 'NM', 'GUARANTOR_PRIORITY', None),
 'GT1_16': ('leaf', 'ST', 'GUARANTOR_EMPLOYER_NAME', None),
 'GT1_17': ('leaf', 'AD', 'GUARANTOR_EMPLOYER_ADDRESS', None),
 'GT1_18': ('leaf', 'TN', 'GUARANTOR_EMPLOY_PHONE_NUMBER', None),
 'GT1_19': ('leaf', 'ST', 'GUARANTOR_EMPLOYEE_ID_NUMBER', None),
 'GT1_2': ('leaf', 'CK', 'GUARANTOR_NUMBER', None),
 'GT1_20': ('leaf', 'ID', 'GUARANTOR_EMPLOYMENT_STATUS', None),
 'GT1_21': ('leaf', 'ST', 'GUARANTOR_ORGANIZATION', None),
 'GT1_3': ('leaf', 'PN', 'GUARANTOR_NAME', None),
 'GT1_4': ('leaf', 'PN', 'GUARANTOR_SPOUSE_NAME', None),
 'GT1_5': ('leaf', 'AD', 'GUARANTOR_ADDRESS', None),
 'GT1_6': ('leaf', 'TN', 'GUARANTOR_PHONE_NUMBER_HOME', None),
 'GT1_7': ('leaf', 'TN', 'GUARANTOR_PHONE_NUMBER_BUSINESS', None),
 'GT1_8': ('leaf', 'DT', 'GUARANTOR_DATE_OF_BIRTH', None),
 'GT1_9': ('leaf', 'ID', 'GUARANTOR_SEX', None),
 'IN1_1': ('leaf', 'SI', 'SET_ID_INSURANCE', None),
 'IN1_10': ('leaf', 'ST', 'INSURED_S_GROUP_EMPLOYER_ID', None),
 'IN1_11': ('leaf', 'ST', 'INSURED_S_GROUP_EMPLOYER_NAME', None),
 'IN1_12': ('leaf', 'DT', 'PLAN_EFFECTIVE_DATE', None),
 'IN1_13': ('leaf', 'DT', 'PLAN_EXPIRATION_DATE', None),
 'IN1_14': ('leaf', 'AUI', 'AUTHORIZATION_INFORMATION', None),
 'IN1_15': ('leaf', 'ID', 'PLAN_TYPE', None),
 'IN1_16': ('leaf', 'PN', 'NAME_OF_INSURED', None),
 'IN1_17': ('leaf', 'ID', 'INSURED_S_RELATIONSHIP_TO_PATIENT', None),
 'IN1_18': ('leaf', 'DT', 'INSURED_S_DATE_OF_BIRTH', None),
 'IN1_19': ('leaf', 'AD', 'INSURED_S_ADDRESS', None),
 'IN1_2': ('leaf', 'ID', 'INSURANCE_PLAN_ID', None),
 'IN1_20': ('leaf', 'ID', 'ASSIGNMENT_OF_BENEFITS', None),
 'IN1_21': ('leaf', 'ID', 'COORDINATION_OF_BENEFITS', None),
 'IN1_22': ('leaf', 'ST', 'COORDINATION_OF_BENEFITS_PRIORITY', None),
 'IN1_23': ('leaf', 'ID', 'NOTICE_OF_ADMISSION_CODE', None),
 'IN1_24': ('leaf', 'DT', 'NOTICE_OF_ADMISSION_DATE', None),
 'IN1_25': ('leaf', 'ID', 'REPORT_OF_ELIGIBILITY_CODE', None),
 'IN1_26': ('leaf', 'DT', 'REPORT_OF_ELIGIBILITY_DATE', None),
 'IN1_27': ('leaf', 'ID', 'RELEASE_INFORMATION_CODE', None),
 'IN1_28': ('leaf', 'ST', 'PRE_ADMIT_CERTIFICATION_PAC_', None),
 'IN1_29': ('leaf', 'TS', 'VERIFICATION_DATE_TIME', None),
 'IN1_3': ('leaf', 'ST', 'INSURANCE_COMPANY_ID', None),
 'IN1_30': ('leaf', 'PERSON', 'VERIFICATION_BY', None),
 'IN1_31': ('leaf', 'ID', 'TYPE_OF_AGREEMENT_CODE', None),
 'IN1_32': ('leaf', 'ID', 'BILLING_STATUS', None),
 'IN1_33': ('leaf', 'NM', 'LIFETIME_RESERVE_DAYS', None),
 'IN1_34': ('leaf', 'NM', 'DELAY_BEFORE_LIFETIME_RESERVE_DAYS', None),
 'IN1_35': ('leaf', 'ID', 'COMPANY_PLAN_CODE', None),
 'IN1_36': ('leaf', 'ST', 'POLICY_NUMBER', None),
 'IN1_37': ('leaf', 'NM', 'POLICY_DEDUCTIBLE', None),
 'IN1_38': ('leaf', 'NM', 'POLICY_LIMIT_AMOUNT', None),
 'IN1_39': ('leaf', 'NM', 'POLICY_LIMIT_DAYS', None),
 'IN1_4': ('leaf', 'ST', 'INSURANCE_COMPANY_NAME', None),
 'IN1_40': ('leaf', 'NM', 'ROOM_RATE_SEMI_PRIVATE', None),
 'IN1_41': ('leaf', 'NM', 'ROOM_RATE_PRIVATE', None),
 'IN1_42': ('leaf', 'CE', 'INSURED_S_EMPLOYMENT_STATUS', None),
 'IN1_43': ('leaf', 'ID', 'INSURED_S_SEX', None),
 'IN1_44': ('leaf', 'AD', 'INSURED_S_EMPLOYER_ADDRESS', None),
 'IN1_45': ('leaf', 'ST', 'VERIFICATION_STATUS', None),
 'IN1_46': ('leaf', 'ID', 'PRIOR_INSURANCE_PLAN_ID', None),
 'IN1_5': ('leaf', 'AD', 'INSURANCE_COMPANY_ADDRESS', None),
 'IN1_6': ('leaf', 'PN', 'INSURANCE_COMPANY_CONTACT_PERS', None),
 'IN1_7': ('leaf', 'TN', 'INSURANCE_COMPANY_PHONE_NUMBER', None),
 'IN1_8': ('leaf', 'ST', 'GROUP_NUMBER', None),
 'IN1_9': ('leaf', 'ST', 'GROUP_NAME', None),
 'IN2_1': ('leaf', 'ST', 'INSURED_S_EMPLOYEE_ID', None),
 'IN2_10': ('leaf', 'NM', 'CHAMPUS_ID_NUMBER', None),
 'IN2_11': ('leaf', 'ID', 'DEPENDENT_OF_CHAMPUS_RECIPIENT', None),
 'IN2_12': ('leaf', 'ST', 'CHAMPUS_ORGANIZATION', None),
 'IN2_13': ('leaf', 'ST', 'CHAMPUS_STATION', None),
 'IN2_14': ('leaf', 'ID', 'CHAMPUS_SERVICE', None),
 'IN2_15': ('leaf', 'ID', 'CHAMPUS_RANK_GRADE', None),
 'IN2_16': ('leaf', 'ID', 'CHAMPUS_STATUS', None),
 'IN2_17': ('leaf', 'DT', 'CHAMPUS_RETIRE_DATE', None),
 'IN2_18': ('leaf',
            'ID',
            'CHAMPUS_NON_AVAILABILITY_CERTIFICATION_ON_FILE',
            None),
 'IN2_19': ('leaf', 'ID', 'BABY_COVERAGE', None),
 'IN2_2': ('leaf', 'ST', 'INSURED_S_SOCIAL_SECURITY_NUMBER', None),
 'IN2_20': ('leaf', 'ID', 'COMBINE_BABY_BILL', None),
 'IN2_21': ('leaf', 'NM', 'BLOOD_DEDUCTIBLE', None),
 'IN2_22': ('leaf', 'PN', 'SPECIAL_COVERAGE_APPROVAL_NAME', None),
 'IN2_23': ('leaf', 'ST', 'SPECIAL_COVERAGE_APPROVAL_TITLE', None),
 'IN2_24': ('leaf', 'ID', 'NON_COVERED_INSURANCE_CODE', None),
 'IN2_25': ('leaf', 'ST', 'PAYOR_ID', None),
 'IN2_26': ('leaf', 'ST', 'PAYOR_SUBSCRIBER_ID', None),
 'IN2_27': ('leaf', 'ID', 'ELIGIBILITY_SOURCE', None),
 'IN2_28': ('leaf', 'RMC', 'ROOM_COVERAGE_TYPE_AMOUNT', None),
 'IN2_29': ('leaf', 'PTA', 'POLICY_TYPE_AMOUNT', None),
 'IN2_3': ('leaf', 'PERSON', 'INSURED_S_EMPLOYER_NAME', None),
 'IN2_30': ('leaf', 'DDI', 'DAILY_DEDUCTIBLE', None),
 'IN2_4': ('leaf', 'ID', 'EMPLOYER_INFORMATION_DATA', None),
 'IN2_5': ('leaf', 'ID', 'MAIL_CLAIM_PARTY', None),
 'IN2_6': ('leaf', 'NM', 'MEDICARE_HEALTH_INSURANCE_CARD_NUMBER', None),
 'IN2_7': ('leaf', 'PN', 'MEDICAID_CASE_NAME', None),
 'IN2_8': ('leaf', 'NM', 'MEDICAID_CASE_NUMBER', None),
 'IN2_9': ('leaf', 'PN', 'CHAMPUS_SPONSOR_NAME', None),
 'IN3_1': ('leaf', 'SI', 'SET_ID_INSURANCE_CERTIFICATION', None),
 'IN3_10': ('leaf', 'DT', 'CERTIFICATION_END_DATE', None),
 'IN3_11': ('leaf', 'DTN', 'DAYS', None),
 'IN3_12': ('leaf', 'CE', 'NON_CONCUR_CODE_DESCRIPTION', None),
 'IN3_13': ('leaf', 'TS', 'NON_CONCUR_EFFECTIVE_DATE_TIME', None),
 'IN3_14': ('leaf', 'PERSON', 'PHYSICIAN_REVIEWER', None),
 'IN3_15': ('leaf', 'ST', 'CERTIFICATION_CONTACT', None),
 'IN3_16': ('leaf', 'TN', 'CERTIFICATION_CONTACT_PHONE_NUMBER', None),
 'IN3_17': ('leaf', 'CE', 'APPEAL_REASON', None),
 'IN3_18': ('leaf', 'CE', 'CERTIFICATION_AGENCY', None),
 'IN3_19': ('leaf', 'TN', 'CERTIFICATION_AGENCY_PHONE_NUMBER', None),
 'IN3_2': ('leaf', 'ST', 'CERTIFICATION_NUMBER', None),
 'IN3_20': ('leaf', 'PCF', 'PRE_CERTIFICATION_REQUIRED_WINDOW', None),
 'IN3_21': ('leaf', 'ST', 'CASE_MANAGER', None),
 'IN3_22': ('leaf', 'DT', 'SECOND_OPINION_DATE', None),
 'IN3_23': ('leaf', 'ID', 'SECOND_OPINION_STATUS', None),
 'IN3_24': ('leaf', 'ID', 'SECOND_OPINION_DOCUMENTATION_RECEIVED', None),
 'IN3_25': ('leaf', 'PERSON', 'SECOND_OPINION_PRACTITIONER', None),
 'IN3_3': ('leaf', 'PERSON', 'CERTIFIED_BY', None),
 'IN3_4': ('leaf', 'ID', 'CERTIFICATION_REQUIRED', None),
 'IN3_5': ('leaf', 'PEN', 'PENALTY', None),
 'IN3_6': ('leaf', 'TS', 'CERTIFICATION_DATE_TIME', None),
 'IN3_7': ('leaf', 'TS', 'CERTIFICATION_MODIFY_DATE_TIME', None),
 'IN3_8': ('leaf', 'PERSON', 'OPERATOR', None),
 'IN3_9': ('leaf', 'DT', 'CERTIFICATION_BEGIN_DATE', None),
 'MFA_1': ('leaf', 'ID', 'RECORD_LEVEL_EVENT_CODE', None),
 'MFA_2': ('leaf', 'ST', 'MFN_CONTROL_ID', None),
 'MFA_3': ('leaf', 'TS', 'EVENT_COMPLETION_DATE_TIME', None),
 'MFA_4': ('leaf', 'CE', 'ERROR_RETURN_CODE_AND_OR_TEXT', None),
 'MFA_5': ('leaf', 'CE', 'PRIMARY_KEY_VALUE', None),
 'MFE_1': ('leaf', 'ID', 'RECORD_LEVEL_EVENT_CODE', None),
 'MFE_2': ('leaf', 'ST', 'MFN_CONTROL_ID', None),
 'MFE_3': ('leaf', 'TS', 'EFFECTIVE_DATE_TIME', None),
 'MFE_4': ('leaf', 'CE', 'PRIMARY_KEY_VALUE', None),
 'MFI_1': ('leaf', 'CE', 'MASTER_FILE_IDENTIFIER', None),
 'MFI_2': ('leaf', 'ID', 'MASTER_FILE_APPLICATION_IDENTIFIER', None),
 'MFI_3': ('leaf', 'ID', 'FILE_LEVEL_EVENT_CODE', None),
 'MFI_4': ('leaf', 'TS', 'ENTERED_DATE_TIME', None),
 'MFI_5': ('leaf', 'TS', 'EFFECTIVE_DATE_TIME', None),
 'MFI_6': ('leaf', 'ID', 'RESPONSE_LEVEL_CODE', None),
 'MRG_1': ('leaf', 'PATID', 'PRIOR_PATIENT_ID_INTERNAL', None),
 'MRG_2': ('leaf', 'PATID', 'PRIOR_ALTERNATE_PATIENT_ID', None),
 'MRG_3': ('leaf', 'ACCOUNTNO', 'PRIOR_PATIENT_ACCOUNT_NUMBER', None),
 'MRG_4': ('leaf', 'PATID', 'PRIOR_PATIENT_ID_EXTERNAL', None),
 'MSA_1': ('leaf', 'ID', 'ACKNOWLEDGEMENT_CODE', None),
 'MSA_2': ('leaf', 'ST', 'MESSAGE_CONTROL_ID', None),
 'MSA_3': ('leaf', 'ST', 'TEXT_MESSAGE', None),
 'MSA_4': ('leaf', 'NM', 'EXPECTED_SEQUENCE_NUMBER', None),
 'MSA_5': ('leaf', 'ID', 'DELAYED_ACKNOWLEDGEMENT_TYPE', None),
 'MSA_6': ('leaf', 'CE', 'ERROR_CONDITION', None),
 'MSH_1': ('leaf', 'ST', 'FIELD_SEPARATOR', None),
 'MSH_10': ('leaf', 'ST', 'MESSAGE_CONTROL_ID', None),
 'MSH_11': ('leaf', 'ID', 'PROCESSING_ID', None),
 'MSH_12': ('leaf', 'ID', 'VERSION_ID', None),
 'MSH_13': ('leaf', 'NM', 'SEQUENCE_NUMBER', None),
 'MSH_14': ('leaf', 'ST', 'CONTINUATION_POINTER', None),
 'MSH_15': ('leaf', 'ID', 'ACCEPT_ACKNOWLEDGEMENT_TYPE', None),
 'MSH_16': ('leaf', 'ID', 'APPLICATION_ACKNOWLEDGEMENT_TYPE', None),
 'MSH_17': ('leaf', 'ID', 'COUNTRY_CODE', None),
 'MSH_2': ('leaf', 'ST', 'ENCODING_CHARACTERS', None),
 'MSH_3': ('leaf', 'ST', 'SENDING_APPLICATION', None),
 'MSH_4': ('leaf', 'ST', 'SENDING_FACILITY', None),
 'MSH_5': ('leaf', 'ST', 'RECEIVING_APPLICATION', None),
 'MSH_6': ('leaf', 'ST', 'RECEIVING_FACILITY', None),
 'MSH_7': ('leaf', 'TS', 'DATE_TIME_OF_MESSAGE', None),
 'MSH_8': ('leaf', 'ST', 'SECURITY', None),
 'MSH_9': ('leaf', 'MSG', 'MESSAGE_TYPE', None),
 'NCK_1': ('leaf', 'TS', 'SYSTEM_DATE_TIME', None),
 'NK1_1': ('leaf', 'SI', 'SET_ID_NEXT_OF_KIN', None),
 'NK1_10': ('leaf', 'ST', 'NEXT_OF_KIN', None),
 'NK1_11': ('leaf', 'JOBCODE', 'NEXT_OF_KIN_JOB_CODE_CLASS', None),
 'NK1_12': ('leaf', 'ST', 'NEXT_OF_KIN_EMPLOYEE_NUMBER', None),
 'NK1_13': ('leaf', 'ST', 'ORGANIZATION_NAME', None),
 'NK1_2': ('leaf', 'PN', 'NAME', None),
 'NK1_3': ('leaf', 'CE', 'RELATIONSHIP', None),
 'NK1_4': ('leaf', 'AD', 'ADDRESS', None),
 'NK1_5': ('leaf', 'TN', 'PHONE_NUMBER', None),
 'NK1_6': ('leaf', 'TN', 'BUSINESS_PHONE_NUMBER', None),
 'NK1_7': ('leaf', 'CE', 'CONTACT_ROLE', None),
 'NK1_8': ('leaf', 'DT', 'START_DATE', None),
 'NK1_9': ('leaf', 'DT', 'END_DATE', None),
 'NPU_1': ('leaf', 'INTERNALLOCATION', 'BED_LOCATION', None),
 'NPU_2': ('leaf', 'ID', 'BED_STATUS', None),
 'NSC_1': ('leaf', 'ID', 'NETWORK_CHANGE_TYPE', None),
 'NSC_2': ('leaf', 'ST', 'CURRENT_CPU', None),
 'NSC_3': ('leaf', 'ST', 'CURRENT_FILESERVER', None),
 'NSC_4': ('leaf', 'ST', 'CURRENT_APPLICATION', None),
 'NSC_5': ('leaf', 'ST', 'CURRENT_FACILITY', None),
 'NSC_6': ('leaf', 'ST', 'NEW_CPU', None),
 'NSC_7': ('leaf', 'ST', 'NEW_FILESERVER', None),
 'NSC_8': ('leaf', 'ST', 'NEW_APPLICATION', None),
 'NSC_9': ('leaf', 'ST', 'NEW_FACILITY', None),
 'NST_1': ('leaf', 'ID', 'STATISTICS_AVAILABLE', None),
 'NST_10': ('leaf', 'NM', 'CHECKSUM_ERRORS_RECEIVED', None),
 'NST_11': ('leaf', 'NM', 'LENGTH_ERRORS_RECEIVED', None),
 'NST_12': ('leaf', 'NM', 'OTHER_ERRORS_RECEIVED', None),
 'NST_13': ('leaf', 'NM', 'CONNECT_TIMEOUTS', None),
 'NST_14': ('leaf', 'NM', 'RECEIVE_TIMEOUTS', None),
 'NST_15': ('leaf', 'NM', 'NETWORK_ERRORS', None),
 'NST_2': ('leaf', 'ST', 'SOURCE_IDENTIFIER', None),
 'NST_3': ('leaf', 'ID', 'SOURCE_TYPE', None),
 'NST_4': ('leaf', 'TS', 'STATISTICS_START', None),
 'NST_5': ('leaf', 'TS', 'STATISTICS_END', None),
 'NST_6': ('leaf', 'NM', 'RECEIVE_CHARACTER_COUNT', None),
 'NST_7': ('leaf', 'NM', 'SEND_CHARACTER_COUNT', None),
 'NST_8': ('leaf', 'NM', 'MESSAGE_RECEIVED', None),
 'NST_9': ('leaf', 'NM', 'MESSAGE_SENT', None),
 'NTE_1': ('leaf', 'SI', 'SET_ID_NOTES_AND_COMMENTS', None),
 'NTE_2': ('leaf', 'ID', 'SOURCE_OF_COMMENT', None),
 'NTE_3': ('leaf', 'FT', 'COMMENT', None),
 'OBR_1': ('leaf', 'SI', 'SET_ID_OBSERVATION_REQUEST', None),
 'OBR_10': ('leaf', 'PERSON', 'COLLECTOR_IDENTIFIER', None),
 'OBR_11': ('leaf', 'ID', 'SPECIMEN_ACTION_CODE', None),
 'OBR_12': ('leaf', 'CE', 'DANGER_CODE', None),
 'OBR_13': ('leaf', 'ST', 'RELEVANT_CLINICAL_INFORMATION', None),
 'OBR_14': ('leaf', 'TS', 'SPECIMEN_RECEIVED_DATE_TIME', None),
 'OBR_15': ('leaf', 'SPS', 'SPECIMEN_SOURCE', None),
 'OBR_16': ('leaf', 'PERSON', 'ORDERING_PROVIDER', None),
 'OBR_17': ('leaf', 'TN', 'ORDER_CALLBACK_PHONE_NUMBER', None),
 'OBR_18': ('leaf', 'ST', 'PLACER_FIELD_1', None),
 'OBR_19': ('leaf', 'ST', 'PLACER_FIELD_2', None),
 'OBR_2': ('leaf', 'PLACER', 'PLACER_ORDER_NUMBER', None),
 'OBR_20': ('leaf', 'ST', 'FILLER_FIELD_1', None),
 'OBR_21': ('leaf', 'ST', 'FILLER_FIELD_2', None),
 'OBR_22': ('leaf', 'TS', 'RESULTS_REPORT_STATUS_CHANGE_DATE_TIME', None),
 'OBR_23': ('leaf', 'MOC', 'CHARGE_TO_PRACTICE', None),
 'OBR_24': ('leaf', 'ID', 'DIAGNOSTIC_SERVICE_SECTION_ID', None),
 'OBR_25': ('leaf', 'ID', 'RESULT_STATUS', None),
 'OBR_26': ('leaf', 'CM', 'PARENT_RESULT', None),
 'OBR_27': ('leaf', 'TQ', 'QUANTITY_TIMING', None),
 'OBR_28': ('leaf', 'PERSON', 'RESULT_COPIES_TO', None),
 'OBR_29': ('leaf', 'EIP', 'PARENT_NUMBER', None),
 'OBR_3': ('leaf', 'FILLER', 'FILLER_ORDER_NUMBER', None),
 'OBR_30': ('leaf', 'ID', 'TRANSPORTATION_MODE', None),
 'OBR_31': ('leaf', 'CE', 'REASON_FOR_STUDY', None),
 'OBR_32': ('leaf', 'NDL', 'PRINCIPAL_RESULT_INTERPRETER', None),
 'OBR_33': ('leaf', 'NDL', 'ASSISTANT_RESULT_INTERPRETER', None),
 'OBR_34': ('leaf', 'NDL', 'TECHNICIAN', None),
 'OBR_35': ('leaf', 'NDL', 'TRANSCRIPTIONIST', None),
 'OBR_36': ('leaf', 'TS', 'SCHEDULED_DATE_TIME', None),
 'OBR_4': ('leaf', 'CE', 'UNIVERSAL_SERVICE_ID', None),
 'OBR_5': ('leaf', 'ID', 'PRIORITY_NOT_USED_', None),
 'OBR_6': ('leaf', 'TS', 'REQUESTED_DATE_TIME_NOT_USED_', None),
 'OBR_7': ('leaf', 'TS', 'OBSERVATION_DATE_TIME', None),
 'OBR_8': ('leaf', 'TS', 'OBSERVATION_END_DATE_TIME', None),
 'OBR_9': ('leaf', 'QUANTITY', 'COLLECTION_VOLUME', None),
 'OBX_1': ('leaf', 'SI', 'SET_ID_OBSERVATIONAL_SIMPLE', None),
 'OBX_10': ('leaf', 'ID', 'NATURE_OF_ABNORMAL_TEST', None),
 'OBX_11': ('leaf', 'ID', 'OBSERVATION_RESULT_STATUS', None),
 'OBX_12': ('leaf',
            'TS',
            'EFFECTIVE_DATE_LAST_OBSERVATION_NORMAL_VALUES',
            None),
 'OBX_13': ('leaf', 'ST', 'USER_DEFINED_ACCESS_CHECKS', None),
 'OBX_14': ('leaf', 'TS', 'DATE_TIME_OF_THE_OBSERVATION', None),
 'OBX_15': ('leaf', 'CE', 'PRODUCER_S_ID', None),
 'OBX_16': ('leaf', 'PHYSICIAN', 'RESPONSIBLE_OBSERVER', None),
 'OBX_2': ('leaf', 'ID', 'VALUE_TYPE', None),
 'OBX_3': ('leaf', 'CE', 'OBSERVATION_IDENTIFIER', None),
 'OBX_4': ('leaf', 'ST', 'OBSERVATION_SUB_ID', None),
 'OBX_5': ('leaf', 'varies', 'OBSERVATION_VALUE', None),
 'OBX_6': ('leaf', 'CE', 'UNITS', None),
 'OBX_7': ('leaf', 'ST', 'REFERENCES_RANGE', None),
 'OBX_8': ('leaf', 'ID', 'ABNORMAL_FLAGS', None),
 'OBX_9': ('leaf', 'NM', 'PROBABILITY', None),
 'ODS_1': ('leaf', 'ID', 'TYPE', None),
 'ODS_2': ('leaf', 'CE', 'SERVICE_PERIOD', None),
 'ODS_3': ('leaf', 'CE', 'DIET_SUPPLEMENT_OR_PREFERENCE_CODE', None),
 'ODS_4': ('leaf', 'ST', 'TEXT_INSTRUCTION', None),
 'ODT_1': ('leaf', 'CE', 'TRAY_TYPE', None),
 'ODT_2': ('leaf', 'CE', 'SERVICE_PERIOD', None),
 'ODT_3': ('leaf', 'ST', 'TEXT_INSTRUCTION', None),
 'OM1_1': ('leaf', 'ST', 'SEGMENT_TYPE_ID', None),
 'OM1_10': ('leaf', 'ST', 'PREFERRED_REPORT_NAME_FOR_THE_OBSERVATION', None),
 'OM1_11': ('leaf',
            'ST',
            'PREFERRED_SHORT_NAME_OR_MNEMONIC_FOR_OBSERVATION',
            None),
 'OM1_12': ('leaf', 'ST', 'PREFERRED_LONG_NAME_FOR_THE_OBSERVATION', None),
 'OM1_13': ('leaf', 'ID', 'ORDERABILITY', None),
 'OM1_14': ('leaf',
            'CE',
            'IDENTITY_OF_INSTRUMENT_USED_TO_PERFORM_THIS_STUDY',
            None),
 'OM1_15': ('leaf', 'CE', 'CODED_REPRESENTATION_OF_METHOD', None),
 'OM1_16': ('leaf', 'ID', 'PORTABLE', None),
 'OM1_17': ('leaf', 'ID', 'OBSERVATION_PRODUCING_DEPARTMENT_SECTION', None),
 'OM1_18': ('leaf', 'TN', 'TELEPHONE_NUMBER_OF_SECTION', None),
 'OM1_19': ('leaf', 'ID', 'NATURE_OF_TEST_OBSERVATION', None),
 'OM1_2': ('leaf', 'NM', 'SEQUENCE_NUMBER_TEST_OBSERVATION_MASTER_FILE', None),
 'OM1_20': ('leaf', 'CE', 'REPORT_SUBHEADER', None),
 'OM1_21': ('leaf', 'ST', 'REPORT_DISPLAY_ORDER', None),
 'OM1_22': ('leaf',
            'TS',
            'DATE_TIME_STAMP_FOR_ANY_CHANGE_IN_DEFINITION_FOR_OBS',
            None),
 'OM1_23': ('leaf', 'TS', 'EFFECTIVE_DATE_TIME_OF_CHANGE', None),
 'OM1_24': ('leaf', 'NM', 'TYPICAL_TURN_AROUND_TIME', None),
 'OM1_25': ('leaf', 'NM', 'PROCESSING_TIME', None),
 'OM1_26': ('leaf', 'ID', 'PROCESSING_PRIORITY', None),
 'OM1_27': ('leaf', 'ID', 'REPORTING_PRIORITY', None),
 'OM1_28': ('leaf',
            'CE',
            'OUTSIDE_SITE_S_WHERE_OBSERVATION_MAY_BE_PERFORMED',
            None),
 'OM1_29': ('leaf', 'AD', 'ADDRESS_OF_OUTSIDE_SITE_S_', None),
 'OM1_3': ('leaf', 'CE', 'PRODUCER_S_TEST_OBSERVATION_ID', None),
 'OM1_30': ('leaf', 'TN', 'PHONE_NUMBER_OF_OUTSIDE_SITE', None),
 'OM1_31': ('leaf', 'ID', 'CONFIDENTIALITY_CODE', None),
 'OM1_32': ('leaf',
            'CE',
            'OBSERVATIONS_REQUIRED_TO_INTERPRET_THE_OBSERVATION',
            None),
 'OM1_33': ('leaf', 'TX', 'INTERPRETATION_OF_OBSERVATIONS', None),
 'OM1_34': ('leaf', 'CE', 'CONTRAINDICATIONS_TO_OBSERVATIONS', None),
 'OM1_35': ('leaf', 'CE', 'REFLEX_TESTS_OBSERVATIONS', None),
 'OM1_36': ('leaf', 'ST', 'RULES_THAT_TRIGGER_REFLEX_TESTING', None),
 'OM1_37': ('leaf', 'CE', 'FIXED_CANNED_MESSAGE', None),
 'OM1_38': ('leaf', 'TX', 'PATIENT_PREPARATION', None),
 'OM1_39': ('leaf', 'CE', 'PROCEDURE_MEDICATION', None),
 'OM1_4': ('leaf', 'ID', 'PERMITTED_DATA_TYPES', None),
 'OM1_40': ('leaf', 'TX', 'FACTORS_THAT_MAY_AFFECT_THE_OBSERVATION', None),
 'OM1_41': ('leaf', 'ST', 'TEST_OBSERVATION_PERFORMANCE_SCHEDULE', None),
 'OM1_42': ('leaf', 'TX', 'DESCRIPTION_OF_TEST_METHODS', None),
 'OM1_5': ('leaf', 'ID', 'SPECIMEN_REQUIRED', None),
 'OM1_6': ('leaf', 'CE', 'PRODUCER_ID', None),
 'OM1_7': ('leaf', 'TX', 'OBSERVATION_DESCRIPTION', None),
 'OM1_8': ('leaf',
           'CE',
           'OTHER_TEST_OBSERVATION_IDS_FOR_THE_OBSERVATION',
           None),
 'OM1_9': ('leaf', 'ST', 'OTHER_NAMES', None),
 'OM2_1': ('leaf', 'ST', 'SEGMENT_TYPE_ID', None),
 'OM2_10': ('leaf', 'DLT', 'DELTA_CHECK_CRITERIA', None),
 'OM2_11': ('leaf', 'NM', 'MINIMUM_MEANINGFUL_INCREMENTS', None),
 'OM2_2': ('leaf', 'NM', 'SEQUENCE_NUMBER_TEST_OBSERVATION_MASTER_FILE', None),
 'OM2_3': ('leaf', 'CE', 'UNITS_OF_MEASURE', None),
 'OM2_4': ('leaf', 'NM', 'RANGE_OF_DECIMAL_PRECISION', None),
 'OM2_5': ('leaf', 'CE', 'CORRESPONDING_SI_UNITS_OF_MEASURE', None),
 'OM2_6': ('leaf', 'TX', 'SI_CONVERSION_FACTOR', None),
 'OM2_7': ('leaf',
           'RFR',
           'REFERENCE_NORMAL_RANGE_ORDINAL_CONTINUOUS_OBSERVATIONS',
           None),
 'OM2_8': ('leaf',
           'RANGE',
           'CRITICAL_RANGE_FOR_ORDINAL_AND_CONTINUOUS_OBSERVATIONS',
           None),
 'OM2_9': ('leaf',
           'ABSRANGE',
           'ABSOLUTE_RANGE_FOR_ORDINAL_AND_CONTINUOUS_OBSERVATIONS',
           None),
 'OM3_1': ('leaf', 'ST', 'SEGMENT_TYPE_ID', None),
 'OM3_2': ('leaf', 'NM', 'SEQUENCE_NUMBER_TEST_OBSERVATION_MASTER_FILE', None),
 'OM3_3': ('leaf', 'ID', 'PREFERRED_CODING_SYSTEM', None),
 'OM3_4': ('leaf', 'CE', 'VALID_CODED_ANSWERS', None),
 'OM3_5': ('leaf',
           'CE',
           'NORMAL_TEST_CODES_FOR_CATEGORICAL_OBSERVATIONS',
           None),
 'OM3_6': ('leaf',
           'CE',
           'ABNORMAL_TEST_CODES_FOR_CATEGORICAL_OBSERVATIONS',
           None),
 'OM3_7': ('leaf',
           'CE',
           'CRITICAL_TEST_CODES_FOR_CATEGORICAL_OBSERVATIONS',
           None),
 'OM3_8': ('leaf', 'ID', 'DATA_TYPE', None),
 'OM4_1': ('leaf', 'ST', 'SEGMENT_TYPE_ID', None),
 'OM4_10': ('leaf', 'TX', 'SPECIAL_HANDLING_REQUIREMENTS', None),
 'OM4_11': ('leaf', 'QUANTITY', 'NORMAL_COLLECTION_VOLUME', None),
 'OM4_12': ('leaf', 'CQ', 'MINIMUM_COLLECTION_VOLUME', None),
 'OM4_13': ('leaf', 'TX', 'SPECIMEN_REQUIREMENTS', None),
 'OM4_14': ('leaf', 'ID', 'SPECIMEN_PRIORITIES', None),
 'OM4_15': ('leaf', 'CQ', 'SPECIMEN_RETENTION_TIME', None),
 'OM4_2': ('leaf', 'NM', 'SEQUENCE_NUMBER_TEST_OBSERVATION_MASTER_FILE', None),
 'OM4_3': ('leaf', 'ID', 'DERIVED_SPECIMEN', None),
 'OM4_4': ('leaf', 'TX', 'CONTAINER_DESCRIPTION', None),
 'OM4_5': ('leaf', 'NM', 'CONTAINER_VOLUME', None),
 'OM4_6': ('leaf', 'CE', 'CONTAINER_UNITS', None),
 'OM4_7': ('leaf', 'CE', 'SPECIMEN', None),
 'OM4_8': ('leaf', 'CE', 'ADDITIVE', None),
 'OM4_9': ('leaf', 'TX', 'PREPARATION', None),
 'OM5_1': ('leaf', 'ST', 'SEGMENT_TYPE_ID', None),
 'OM5_2': ('leaf', 'NM', 'SEQUENCE_NUMBER_TEST_OBSERVATION_MASTER_FILE', None),
 'OM5_3': ('leaf',
           'CE',
           'TESTS_OBSERVATIONS_INCLUDED_WITHIN_AN_ORDERED_TEST_BATTERY',
           None),
 'OM5_4': ('leaf', 'ST', 'OBSERVATION_ID_SUFFIXES', None),
 'OM6_1': ('leaf', 'ST', 'SEGMENT_TYPE_ID', None),
 'OM6_2': ('leaf', 'NM', 'SEQUENCE_NUMBER_TEST_OBSERVATION_MASTER_FILE', None),
 'OM6_3': ('leaf', 'TX', 'DERIVATION_RULE', None),
 'ORC_1': ('leaf', 'ID', 'ORDER_CONTROL', None),
 'ORC_10': ('leaf', 'PERSON', 'ENTERED_BY', None),
 'ORC_11': ('leaf', 'PERSON', 'VERIFIED_BY', None),
 'ORC_12': ('leaf', 'PERSON', 'ORDERING_PROVIDER', None),
 'ORC_13': ('leaf', 'CM', 'ENTERER_S_LOCATION', None),
 'ORC_14': ('leaf', 'TN', 'CALL_BACK_PHONE_NUMBER', None),
 'ORC_15': ('leaf', 'TS', 'ORDER_EFFECTIVE_DATE_TIME', None),
 'ORC_16': ('leaf', 'CE', 'ORDER_CONTROL_CODE_REASON', None),
 'ORC_17': ('leaf', 'CE', 'ENTERING_ORGANIZATION', None),
 'ORC_18': ('leaf', 'CE', 'ENTERING_DEVICE', None),
 'ORC_19': ('leaf', 'PERSON', 'ACTION_BY', None),
 'ORC_2': ('leaf', 'PLACER', 'PLACER_ORDER_NUMBER', None),
 'ORC_3': ('leaf', 'FILLER', 'FILLER_ORDER_NUMBER', None),
 'ORC_4': ('leaf', 'GROUPID', 'PLACER_GROUP_NUMBER', None),
 'ORC_5': ('leaf', 'ID', 'ORDER_STATUS', None),
 'ORC_6': ('leaf', 'ID', 'RESPONSE_FLAG', None),
 'ORC_7': ('leaf', 'TQ', 'QUANTITY_TIMING', None),
 'ORC_8': ('leaf', 'EIP', 'PARENT', None),
 'ORC_9': ('leaf', 'TS', 'DATE_TIME_OF_TRANSACTION', None),
 'PID_1': ('leaf', 'SI', 'SET_ID_PATIENT_ID', None),
 'PID_10': ('leaf', 'ID', 'RACE', None),
 'PID_11': ('leaf', 'AD', 'PATIENT_ADDRESS', None),
 'PID_12': ('leaf', 'ID', 'COUNTY_CODE', None),
 'PID_13': ('leaf', 'TN', 'PHONE_NUMBER_HOME', None),
 'PID_14': ('leaf', 'TN', 'PHONE_NUMBER_BUSINESS', None),
 'PID_15': ('leaf', 'ST', 'LANGUAGE_PATIENT', None),
 'PID_16': ('leaf', 'ID', 'MARITAL_STATUS', None),
 'PID_17': ('leaf', 'ID', 'RELIGION', None),
 'PID_18': ('leaf', 'PATID', 'PATIENT_ACCOUNT_NUMBER', None),
 'PID_19': ('leaf', 'ST', 'SOCIAL_SECURITY_NUMBER_PATIENT', None),
 'PID_2': ('leaf', 'PATID', 'PATIENT_ID_EXTERNAL_ID_', None),
 'PID_20': ('leaf', 'LICENSENO', 'DRIVER_S_LICENSE_NUMBER_PATIENT', None),
 'PID_21': ('leaf', 'PATID', 'MOTHER_S_IDENTIFIER', None),
 'PID_22': ('leaf', 'ID', 'ETHNIC_GROUP', None),
 'PID_23': ('leaf', 'ST', 'BIRTH_PLACE', None),
 'PID_24': ('leaf', 'ID', 'MULTIPLE_BIRTH_INDICATOR', None),
 'PID_25': ('leaf', 'NM', 'BIRTH_ORDER', None),
 'PID_26': ('leaf', 'ID', 'CITIZENSHIP', None),
 'PID_27': ('leaf', 'ST', 'VETERANS_MILITARY_STATUS', None),
 'PID_3': ('leaf', 'PATID', 'PATIENT_ID_INTERNAL_ID_', None),
 'PID_4': ('leaf', 'ST', 'ALTERNATE_PATIENT_ID', None),
 'PID_5': ('leaf', 'PN', 'PATIENT_NAME', None),
 'PID_6': ('leaf', 'ST', 'MOTHER_S_MAIDEN_NAME', None),
 'PID_7': ('leaf', 'TS', 'DATE_OF_BIRTH', None),
 'PID_8': ('leaf', 'ID', 'SEX', None),
 'PID_9': ('leaf', 'PN', 'PATIENT_ALIAS', None),
 'PR1_1': ('leaf', 'SI', 'SET_ID_PROCEDURE', None),
 'PR1_10': ('leaf', 'NM', 'ANESTHESIA_MINUTES', None),
 'PR1_11': ('leaf', 'PERSON', 'SURGEON', None),
 'PR1_12': ('leaf', 'PRACTITIONER', 'PROCEDURE_PRACTITIONER', None),
 'PR1_13': ('leaf', 'ID', 'CONSENT_CODE', None),
 'PR1_14': ('leaf', 'NM', 'PROCEDURE_PRIORITY', None),
 'PR1_2': ('leaf', 'ID', 'PROCEDURE_CODING_METHOD', None),
 'PR1_3': ('leaf', 'ID', 'PROCEDURE_CODE', None),
 'PR1_4': ('leaf', 'ST', 'PROCEDURE_DESCRIPTION', None),
 'PR1_5': ('leaf', 'TS', 'PROCEDURE_DATE_TIME', None),
 'PR1_6': ('leaf', 'ID', 'PROCEDURE_TYPE', None),
 'PR1_7': ('leaf', 'NM', 'PROCEDURE_MINUTES', None),
 'PR1_8': ('leaf', 'PERSON', 'ANESTHESIOLOGIST', None),
 'PR1_9': ('leaf', 'ID', 'ANESTHESIA_CODE', None),
 'PRA_1': ('leaf', 'ST', 'PRA_PRIMARY_KEY_VALUE', None),
 'PRA_2': ('leaf', 'CE', 'PRACTITIONER_GROUP', None),
 'PRA_3': ('leaf', 'ID', 'PRACTITIONER_CATEGORY', None),
 'PRA_4': ('leaf', 'ID', 'PROVIDER_BILLING', None),
 'PRA_5': ('leaf', 'SPD', 'SPECIALTY', None),
 'PRA_6': ('leaf', 'PLN', 'PRACTITIONER_ID_NUMBERS', None),
 'PRA_7': ('leaf', 'PIP', 'PRIVILEGES', None),
 'PV1_1': ('leaf', 'SI', 'SET_ID_PATIENT_VISIT', None),
 'PV1_10': ('leaf', 'ID', 'HOSPITAL_SERVICE', None),
 'PV1_11': ('leaf', 'INTERNALLOCATION', 'TEMPORARY_LOCATION', None),
 'PV1_12': ('leaf', 'ID', 'PREADMIT_TEST_INDICATOR', None),
 'PV1_13': ('leaf', 'ID', 'READMISSION_INDICATOR', None),
 'PV1_14': ('leaf', 'ID', 'ADMIT_SOURCE', None),
 'PV1_15': ('leaf', 'ID', 'AMBULATORY_STATUS', None),
 'PV1_16': ('leaf', 'ID', 'VIP_INDICATOR', None),
 'PV1_17': ('leaf', 'PHYSICIAN', 'ADMITTING_DOCTOR', None),
 'PV1_18': ('leaf', 'ID', 'PATIENT_TYPE', None),
 'PV1_19': ('leaf', 'PATID', 'VISIT_NUMBER', None),
 'PV1_2': ('leaf', 'ID', 'PATIENT_CLASS', None),
 'PV1_20': ('leaf', 'FINANCE', 'FINANCIAL_CLASS', None),
 'PV1_21': ('leaf', 'ID', 'CHARGE_PRICE_INDICATOR', None),
 'PV1_22': ('leaf', 'ID', 'COURTESY_CODE', None),
 'PV1_23': ('leaf', 'ID', 'CREDIT_RATING', None),
 'PV1_24': ('leaf', 'ID', 'CONTRACT_CODE', None),
 'PV1_25': ('leaf', 'DT', 'CONTRACT_EFFECTIVE_DATE', None),
 'PV1_26': ('leaf', 'NM', 'CONTRACT_AMOUNT', None),
 'PV1_27': ('leaf', 'NM', 'CONTRACT_PERIOD', None),
 'PV1_28': ('leaf', 'ID', 'INTEREST_CODE', None),
 'PV1_29': ('leaf', 'ID', 'TRANSFER_TO_BAD_DEBT_CODE', None),
 'PV1_3': ('leaf', 'INTERNALLOCATION', 'ASSIGNED_PATIENT_LOCATION', None),
 'PV1_30': ('leaf', 'DT', 'TRANSFER_TO_BAD_DEBT_DATE', None),
 'PV1_31': ('leaf', 'ID', 'BAD_DEBT_AGENCY_CODE', None),
 'PV1_32': ('leaf', 'NM', 'BAD_DEBT_TRANSFER_AMOUNT', None),
 'PV1_33': ('leaf', 'NM', 'BAD_DEBT_RECOVERY_AMOUNT', None),
 'PV1_34': ('leaf', 'ID', 'DELETE_ACCOUNT_INDICATOR', None),
 'PV1_35': ('leaf', 'DT', 'DELETE_ACCOUNT_DATE', None),
 'PV1_36': ('leaf', 'ID', 'DISCHARGE_DISPOSITION', None),
 'PV1_37': ('leaf', 'DLD', 'DISCHARGED_TO_LOCATION', None),
 'PV1_38': ('leaf', 'ID', 'DIET_TYPE', None),
 'PV1_39': ('leaf', 'ID', 'SERVICING_FACILITY', None),
 'PV1_4': ('leaf', 'ID', 'ADMISSION_TYPE', None),
 'PV1_40': ('leaf', 'ID', 'BED_STATUS', None),
 'PV1_41': ('leaf', 'ID', 'ACCOUNT_STATUS', None),
 'PV1_42': ('leaf', 'INTERNALLOCATION', 'PENDING_LOCATION', None),
 'PV1_43': ('leaf', 'INTERNALLOCATION', 'PRIOR_TEMPORARY_LOCATION', None),
 'PV1_44': ('leaf', 'TS', 'ADMIT_DATE_TIME', None),
 'PV1_45': ('leaf', 'TS', 'DISCHARGE_DATE_TIME', None),
 'PV1_46': ('leaf', 'NM', 'CURRENT_PATIENT_BALANCE', None),
 'PV1_47': ('leaf', 'NM', 'TOTAL_CHARGES', None),
 'PV1_48': ('leaf', 'NM', 'TOTAL_ADJUSTMENTS', None),
 'PV1_49': ('leaf', 'NM', 'TOTAL_PAYMENTS', None),
 'PV1_5': ('leaf', 'ST', 'PREADMIT_NUMBER', None),
 'PV1_50': ('leaf', 'PATID_0192', 'ALTERNATE_VISIT_ID', None),
 'PV1_6': ('leaf', 'INTERNALLOCATION', 'PRIOR_PATIENT_LOCATION', None),
 'PV1_7': ('leaf', 'PHYSICIAN', 'ATTENDING_DOCTOR', None),
 'PV1_8': ('leaf', 'PHYSICIAN', 'REFERRING_DOCTOR', None),
 'PV1_9': ('leaf', 'PHYSICIAN', 'CONSULTING_DOCTOR', None),
 'PV2_1': ('leaf', 'INTERNALLOCATION', 'PRIOR_PENDING_LOCATION', None),
 'PV2_2': ('leaf', 'CE', 'ACCOMMODATION_CODE', None),
 'PV2_3': ('leaf', 'CE', 'ADMIT_REASON', None),
 'PV2_4': ('leaf', 'CE', 'TRANSFER_REASON', None),
 'PV2_5': ('leaf', 'ST', 'PATIENT_VALUABLES', None),
 'PV2_6': ('leaf', 'ST', 'PATIENT_VALUABLES_LOCATION', None),
 'PV2_7': ('leaf', 'ID', 'VISIT_USER_CODE', None),
 'PV2_8': ('leaf', 'DT', 'EXPECTED_ADMIT_DATE', None),
 'PV2_9': ('leaf', 'DT', 'EXPECTED_DISCHARGE_DATE', None),
 'QRD_1': ('leaf', 'TS', 'QUERY_DATE_TIME', None),
 'QRD_10': ('leaf', 'ST', 'WHAT_DEPARTMENT_DATA_CODE', None),
 'QRD_11': ('leaf', 'VR', 'WHAT_DATA_CODE_VALUE_QUALIFIER', None),
 'QRD_12': ('leaf', 'ID', 'QUERY_RESULTS_LEVEL', None),
 'QRD_2': ('leaf', 'ID', 'QUERY_FORMAT_CODE', None),
 'QRD_3': ('leaf', 'ID', 'QUERY_PRIORITY', None),
 'QRD_4': ('leaf', 'ST', 'QUERY_ID', None),
 'QRD_5': ('leaf', 'ID', 'DEFERRED_RESPONSE_TYPE', None),
 'QRD_6': ('leaf', 'TS', 'DEFERRED_RESPONSE_DATE_TIME', None),
 'QRD_7': ('leaf', 'CQ', 'QUANTITY_LIMITED_REQUEST', None),
 'QRD_8': ('leaf', 'ST', 'WHO_SUBJECT_FILTER', None),
 'QRD_9': ('leaf', 'ID', 'WHAT_SUBJECT_FILTER', None),
 'QRF_1': ('leaf', 'ST', 'WHERE_SUBJECT_FILTER', None),
 'QRF_2': ('leaf', 'TS', 'WHEN_DATA_START_DATE_TIME', None),
 'QRF_3': ('leaf', 'TS', 'WHEN_DATA_END_DATE_TIME', None),
 'QRF_4': ('leaf', 'ST', 'WHAT_USER_QUALIFIER', None),
 'QRF_5': ('leaf', 'ST', 'OTHER_QRY_SUBJECT_FILTER', None),
 'QRF_6': ('leaf', 'ID', 'WHICH_DATE_TIME_QUALIFIER', None),
 'QRF_7': ('leaf', 'ID', 'WHICH_DATE_TIME_STATUS_QUALIFIER', None),
 'QRF_8': ('leaf', 'ID', 'DATE_TIME_SELECTION_QUALIFIER', None),
 'RQ1_1': ('leaf', 'SI', 'ANTICIPATED_PRICE', None),
 'RQ1_2': ('leaf', 'CE', 'MANUFACTURER_ID', None),
 'RQ1_3': ('leaf', 'ST', 'MANUFACTURER_S_CATALOG', None),
 'RQ1_4': ('leaf', 'CE', 'VENDOR_ID', None),
 'RQ1_5': ('leaf', 'ST', 'VENDOR_CATALOG', None),
 'RQ1_6': ('leaf', 'ID', 'TAXABLE', None),
 'RQ1_7': ('leaf', 'ID', 'SUBSTITUTE_ALLOWED', None),
 'RQD_1': ('leaf', 'SI', 'REQUISITION_LINE_NUMBER', None),
 'RQD_10': ('leaf', 'DT', 'DATE_NEEDED', None),
 'RQD_2': ('leaf', 'CE', 'ITEM_CODE_INTERNAL', None),
 'RQD_3': ('leaf', 'CE', 'ITEM_CODE_EXTERNAL', None),
 'RQD_4': ('leaf', 'CE', 'HOSPITAL_ITEM_CODE', None),
 'RQD_5': ('leaf', 'NM', 'REQUISITION_QUANTITY', None),
 'RQD_6': ('leaf', 'CE', 'REQUISITION_UNIT_OF_MEASURE', None),
 'RQD_7': ('leaf', 'ID', 'DEPARTMENT_COST_CENTER', None),
 'RQD_8': ('leaf', 'ID', 'ITEM_NATURAL_ACCOUNT_CODE', None),
 'RQD_9': ('leaf', 'CE', 'DELIVER_TO_ID', None),
 'RXA_1': ('leaf', 'NM', 'GIVE_SUB_ID_COUNTER', None),
 'RXA_10': ('leaf', 'PERSON', 'ADMINISTERING_PROVIDER', None),
 'RXA_11': ('leaf', 'LA1', 'ADMINISTERED_AT_LOCATION', None),
 'RXA_12': ('leaf', 'ST', 'ADMINISTERED_PER_TIME_UNIT_', None),
 'RXA_2': ('leaf', 'NM', 'ADMINISTRATION_SUB_ID_COUNTER', None),
 'RXA_3': ('leaf', 'TS', 'DATE_TIME_START_OF_ADMINISTRATION', None),
 'RXA_4': ('leaf', 'TS', 'DATE_TIME_END_OF_ADMINISTRATION', None),
 'RXA_5': ('leaf', 'CE', 'ADMINISTERED_CODE', None),
 'RXA_6': ('leaf', 'NM', 'ADMINISTERED_AMOUNT', None),
 'RXA_7': ('leaf', 'CE', 'ADMINISTERED_UNITS', None),
 'RXA_8': ('leaf', 'CE', 'ADMINISTERED_DOSAGE_FORM', None),
 'RXA_9': ('leaf', 'ST', 'ADMINISTRATION_NOTES', None),
 'RXC_1': ('leaf', 'ID', 'RX_COMPONENT_TYPE', None),
 'RXC_2': ('leaf', 'CE', 'COMPONENT_CODE', None),
 'RXC_3': ('leaf', 'NM', 'COMPONENT_AMOUNT', None),
 'RXC_4': ('leaf', 'CE', 'COMPONENT_UNITS', None),
 'RXD_1': ('leaf', 'NM', 'DISPENSE_SUB_ID_COUNTER', None),
 'RXD_10': ('leaf', 'PERSON', 'DISPENSING_PROVIDER', None),
 'RXD_11': ('leaf', 'ID', 'SUBSTITUTION_STATUS', None),
 'RXD_12': ('leaf', 'QUANTITY', 'TOTAL_DAILY_DOSE', None),
 'RXD_13': ('leaf', 'LA1', 'DELIVER_TO_LOCATION', None),
 'RXD_14': ('leaf', 'ID', 'NEEDS_HUMAN_REVIEW', None),
 'RXD_15': ('leaf', 'CE', 'PHARMACY_SPECIAL_DISPENSING_INSTRUCTIONS', None),
 'RXD_2': ('leaf', 'CE', 'DISPENSE_GIVE_CODE', None),
 'RXD_3': ('leaf', 'TS', 'DATE_TIME_DISPENSED', None),
 'RXD_4': ('leaf', 'NM', 'ACTUAL_DISPENSE_AMOUNT', None),
 'RXD_5': ('leaf', 'CE', 'ACTUAL_DISPENSE_UNITS', None),
 'RXD_6': ('leaf', 'CE', 'ACTUAL_DOSAGE_FORM', None),
 'RXD_7': ('leaf', 'ST', 'PRESCRIPTION_NUMBER', None),
 'RXD_8': ('leaf', 'NM', 'NUMBER_OF_REFILLS_REMAINING', None),
 'RXD_9': ('leaf', 'ST', 'DISPENSE_NOTES', None),
 'RXE_1': ('leaf', 'TQ', 'QUANTITY_TIMING', None),
 'RXE_10': ('leaf', 'NM', 'DISPENSE_AMOUNT', None),
 'RXE_11': ('leaf', 'CE', 'DISPENSE_UNITS', None),
 'RXE_12': ('leaf', 'NM', 'NUMBER_OF_REFILLS', None),
 'RXE_13': ('leaf', 'PERSON', 'ORDERING_PROVIDER_S_DEA_NUMBER', None),
 'RXE_14': ('leaf', 'PERSON', 'PHARMACIST_VERIFIER_ID', None),
 'RXE_15': ('leaf', 'ST', 'PRESCRIPTION_NUMBER', None),
 'RXE_16': ('leaf', 'NM', 'NUMBER_OF_REFILLS_REMAINING', None),
 'RXE_17': ('leaf', 'NM', 'NUMBER_OF_REFILLS_DOSES_DISPENSED', None),
 'RXE_18': ('leaf',
            'TS',
            'DATE_TIME_OF_MOST_RECENT_REFILL_OR_DOSE_DISPENSED',
            None),
 'RXE_19': ('leaf', 'QUANTITY', 'TOTAL_DAILY_DOSE', None),
 'RXE_2': ('leaf', 'CE', 'GIVE_CODE', None),
 'RXE_20': ('leaf', 'ID', 'NEEDS_HUMAN_REVIEW', None),
 'RXE_21': ('leaf', 'CE', 'PHARMACY_SPECIAL_DISPENSING_INSTRUCTIONS', None),
 'RXE_22': ('leaf', 'ST', 'GIVE_PER_TIME_UNIT_', None),
 'RXE_23': ('leaf', 'CE', 'GIVE_RATE_AMOUNT', None),
 'RXE_24': ('leaf', 'CE', 'GIVE_RATE_UNITS', None),
 'RXE_3': ('leaf', 'NM', 'GIVE_AMOUNT_MINIMUM', None),
 'RXE_4': ('leaf', 'NM', 'GIVE_AMOUNT_MAXIMUM', None),
 'RXE_5': ('leaf', 'CE', 'GIVE_UNITS', None),
 'RXE_6': ('leaf', 'CE', 'GIVE_DOSAGE_FORM', None),
 'RXE_7': ('leaf', 'CE', 'PROVIDER_S_ADMINISTRATION_INSTRUCTIONS', None),
 'RXE_8': ('leaf', 'LA1', 'DELIVER_TO_LOCATION', None),
 'RXE_9': ('leaf', 'ID', 'SUBSTITUTION_STATUS', None),
 'RXG_1': ('leaf', 'NM', 'GIVE_SUB_ID_COUNTER', None),
 'RXG_10': ('leaf', 'ID', 'SUBSTITUTION_STATUS', None),
 'RXG_11': ('leaf', 'LA1', 'DELIVER_TO_LOCATION', None),
 'RXG_12': ('leaf', 'ID', 'NEEDS_HUMAN_REVIEW', None),
 'RXG_13': ('leaf',
            'CE',
            'PHARMACY_SPECIAL_ADMINISTRATION_INSTRUCTIONS',
            None),
 'RXG_14': ('leaf', 'ST', 'GIVE_PER_TIME_UNIT_', None),
 'RXG_15': ('leaf', 'CE', 'GIVE_RATE_AMOUNT', None),
 'RXG_16': ('leaf', 'CE', 'GIVE_RATE_UNITS', None),
 'RXG_2': ('leaf', 'NM', 'DISPENSE_SUB_ID_COUNTER', None),
 'RXG_3': ('leaf', 'TQ', 'QUANTITY_TIMING', None),
 'RXG_4': ('leaf', 'CE', 'GIVE_CODE', None),
 'RXG_5': ('leaf', 'NM', 'GIVE_AMOUNT_MINIMUM', None),
 'RXG_6': ('leaf', 'NM', 'GIVE_AMOUNT_MAXIMUM', None),
 'RXG_7': ('leaf', 'CE', 'GIVE_UNITS', None),
 'RXG_8': ('leaf', 'CE', 'GIVE_DOSAGE_FORM', None),
 'RXG_9': ('leaf', 'ST', 'ADMINISTRATION_NOTES', None),
 'RXO_1': ('leaf', 'CE', 'REQUESTED_GIVE_CODE', None),
 'RXO_10': ('leaf', 'CE', 'REQUESTED_DISPENSE_CODE', None),
 'RXO_11': ('leaf', 'NM', 'REQUESTED_DISPENSE_AMOUNT', None),
 'RXO_12': ('leaf', 'CE', 'REQUESTED_DISPENSE_UNITS', None),
 'RXO_13': ('leaf', 'NM', 'NUMBER_OF_REFILLS', None),
 'RXO_14': ('leaf', 'PERSON', 'ORDERING_PROVIDER_S_DEA_NUMBER', None),
 'RXO_15': ('leaf', 'PERSON', 'PHARMACIST_VERIFIER_ID', None),
 'RXO_16': ('leaf', 'ID', 'NEEDS_HUMAN_REVIEW', None),
 'RXO_17': ('leaf', 'ST', 'REQUESTED_GIVE_PER_TIME_UNIT_', None),
 'RXO_2': ('leaf', 'NM', 'REQUESTED_GIVE_AMOUNT_MINIMUM', None),
 'RXO_3': ('leaf', 'NM', 'REQUESTED_GIVE_AMOUNT_MAXIMUM', None),
 'RXO_4': ('leaf', 'CE', 'REQUESTED_GIVE_UNITS', None),
 'RXO_5': ('leaf', 'CE', 'REQUESTED_DOSAGE_FORM', None),
 'RXO_6': ('leaf', 'CE', 'PROVIDER_S_PHARMACY_INSTRUCTIONS', None),
 'RXO_7': ('leaf', 'CE', 'PROVIDER_S_ADMINISTRATION_INSTRUCTIONS', None),
 'RXO_8': ('leaf', 'LA1', 'DELIVER_TO_LOCATION', None),
 'RXO_9': ('leaf', 'ID', 'ALLOW_SUBSTITUTIONS', None),
 'RXR_1': ('leaf', 'CE', 'ROUTE', None),
 'RXR_2': ('leaf', 'CE', 'SITE', None),
 'RXR_3': ('leaf', 'CE', 'ADMINISTRATION_DEVICE', None),
 'RXR_4': ('leaf', 'CE', 'ADMINISTRATION_METHOD', None),
 'STF_1': ('leaf', 'CE', 'STF_PRIMARY_KEY_VALUE', None),
 'STF_10': ('leaf', 'TN', 'PHONE', None),
 'STF_11': ('leaf', 'AD', 'OFFICE_HOME_ADDRESS', None),
 'STF_12': ('leaf', 'DIN', 'ACTIVATION_DATE', None),
 'STF_13': ('leaf', 'DIN', 'INACTIVATION_DATE', None),
 'STF_14': ('leaf', 'CE', 'BACKUP_PERSON_ID', None),
 'STF_15': ('leaf', 'ST', 'E_MAIL_ADDRESS', None),
 'STF_16': ('leaf', 'ID', 'PREFERRED_METHOD_OF_CONTACT', None),
 'STF_2': ('leaf', 'CE', 'STAFF_ID_CODE', None),
 'STF_3': ('leaf', 'PN', 'STAFF_NAME', None),
 'STF_4': ('leaf', 'ID', 'STAFF_TYPE', None),
 'STF_5': ('leaf', 'ID', 'SEX', None),
 'STF_6': ('leaf', 'TS', 'DATE_OF_BIRTH', None),
 'STF_7': ('leaf', 'ID', 'ACTIVE_INACTIVE', None),
 'STF_8': ('leaf', 'CE', 'DEPARTMENT', None),
 'STF_9': ('leaf', 'CE', 'SERVICE', None),
 'UB1_1': ('leaf', 'SI', 'SET_ID_UB82', None),
 'UB1_10': ('leaf', 'UVC', 'VALUE_AMOUNT_AND_CODE_46_49_', None),
 'UB1_11': ('leaf', 'NM', 'NUMBER_OF_GRACE_DAYS_90_', None),
 'UB1_12': ('leaf', 'ID', 'SPECIAL_PROGRAM_INDICATOR_44_', None),
 'UB1_13': ('leaf', 'ID', 'PSRO_UR_APPROVAL_INDICATOR_87_', None),
 'UB1_14': ('leaf', 'DT', 'PSRO_UR_APPROVED_STAY_FROM_88_', None),
 'UB1_15': ('leaf', 'DT', 'PSRO_UR_APPROVED_STAY_TO_89_', None),
 'UB1_16': ('leaf', 'OCD', 'OCCURRENCE_28_32_', None),
 'UB1_17': ('leaf', 'ID', 'OCCURRENCE_SPAN_33_', None),
 'UB1_18': ('leaf', 'DT', 'OCCURRENCE_SPAN_START_DATE_33_', None),
 'UB1_19': ('leaf', 'DT', 'OCCURRENCE_SPAN_END_DATE_33_', None),
 'UB1_2': ('leaf', 'NM', 'BLOOD_DEDUCTIBLE_43_', None),
 'UB1_20': ('leaf', 'ST', 'UB_82_LOCATOR_2', None),
 'UB1_21': ('leaf', 'ST', 'UB_82_LOCATOR_9', None),
 'UB1_22': ('leaf', 'ST', 'UB_82_LOCATOR_27', None),
 'UB1_23': ('leaf', 'ST', 'UB_82_LOCATOR_45', None),
 'UB1_3': ('leaf', 'NM', 'BLOOD_FURNISHED_PINTS_OF_40_', None),
 'UB1_4': ('leaf', 'NM', 'BLOOD_REPLACED_PINTS_41_', None),
 'UB1_5': ('leaf', 'NM', 'BLOOD_NOT_REPLACED_PINTS_42_', None),
 'UB1_6': ('leaf', 'NM', 'CO_INSURANCE_DAYS_25_', None),
 'UB1_7': ('leaf', 'ID', 'CONDITION_CODE_35_39_', None),
 'UB1_8': ('leaf', 'NM', 'COVERED_DAYS_23_', None),
 'UB1_9': ('leaf', 'NM', 'NON_COVERED_DAYS_24_', None),
 'UB2_1': ('leaf', 'SI', 'SET_ID_UB92', None),
 'UB2_10': ('leaf', 'ST', 'UB92_LOCATOR_11_STATE_', None),
 'UB2_11': ('leaf', 'ST', 'UB92_LOCATOR_31_NATIONAL_', None),
 'UB2_12': ('leaf', 'ST', 'DOCUMENT_CONTROL_NUMBER_37_', None),
 'UB2_13': ('leaf', 'ST', 'UB92_LOCATOR_49_NATIONAL_', None),
 'UB2_14': ('leaf', 'ST', 'UB92_LOCATOR_56_STATE_', None),
 'UB2_15': ('leaf', 'ST', 'UB92_LOCATOR_57_NATIONAL_', None),
 'UB2_16': ('leaf', 'ST', 'UB92_LOCATOR_78_STATE_', None),
 'UB2_2': ('leaf', 'ST', 'CO_INSURANCE_DAYS_9_', None),
 'UB2_3': ('leaf', 'ID', 'CONDITION_CODE_24_30_', None),
 'UB2_4': ('leaf', 'ST', 'COVERED_DAYS_7_', None),
 'UB2_5': ('leaf', 'ST', 'NON_COVERED_DAYS_8_', None),
 'UB2_6': ('leaf', 'UVC', 'VALUE_AMOUNT_AND_CODE_39_41_', None),
 'UB2_7': ('leaf', 'OCD', 'OCCURRENCE_CODE_AND_DATE_32_35_', None),
 'UB2_8': ('leaf', 'OSP', 'OCCURRENCE_SPAN_CODE_DATES_36_', None),
 'UB2_9': ('leaf', 'ST', 'UB92_LOCATOR_2_STATE_', None),
 'URD_1': ('leaf', 'TS', 'R_U_DATE_TIME', None),
 'URD_2': ('leaf', 'ID', 'REPORT_PRIORITY', None),
 'URD_3': ('leaf', 'ST', 'R_U_WHO_SUBJECT_DEFINITION', None),
 'URD_4': ('leaf', 'ID', 'R_U_WHAT_SUBJECT_DEFINITION', None),
 'URD_5': ('leaf', 'ST', 'R_U_WHAT_DEPARTMENT_CODE', None),
 'URD_6': ('leaf', 'ST', 'R_U_DISPLAY_PRINT_LOCATIONS', None),
 'URD_7': ('leaf', 'ID', 'R_U_RESULTS_LEVEL', None),
 'URS_1': ('leaf', 'ST', 'R_U_WHERE_SUBJECT_DEFINITION', None),
 'URS_2': ('leaf', 'TS', 'R_U_WHEN_DATA_START_DATE_TIME', None),
 'URS_3': ('leaf', 'TS', 'R_U_WHEN_DATA_END_DATE_TIME', None),
 'URS_4': ('leaf', 'ST', 'R_U_WHAT_USER_QUALIFIER', None),
 'URS_5': ('leaf', 'ST', 'R_U_OTHER_RESULTS_SUBJECT_DEFINITION', None),
 'URS_6': ('leaf', 'ID', 'R_U_WHICH_DATE_TIME_QUALIFIER', None),
 'URS_7': ('leaf', 'ID', 'R_U_WHICH_DATE_TIME_STATUS_QUALIFIER', None),
 'URS_8': ('leaf', 'ID', 'R_U_DATE_TIME_SELECTION_QUALIFIER', None)}
