# -*- coding: utf-8 -*-
#
# Copyright (c) 2012-2013, CRS4
#
# Permission is hereby granted, free of charge, to any person obtaining a copy of
# this software and associated documentation files (the "Software"), to deal in
# the Software without restriction, including without limitation the rights to
# use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
# the Software, and to permit persons to whom the Software is furnished to do so,
# subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
# FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
# COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
# IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
# CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

GROUPS = {'ADR_A19_INSURANCE': ('sequence',
                       (('IN1', (1, 1)),
                        ('IN2', (0, 1)),
                        ('IN3', (0, -1)),
                        ('ROL', (0, -1)))),
 'ADR_A19_PROCEDURE': ('sequence', (('PR1', (1, 1)), ('ROL', (0, -1)))),
 'ADR_A19_QUERY_RESPONSE': ('sequence',
                            (('EVN', (0, 1)),
                             ('PID', (1, 1)),
                             ('PD1', (0, 1)),
                             ('ROL', (0, -1)),
                             ('NK1', (0, -1)),
                             ('PV1', (1, 1)),
                             ('PV2', (0, 1)),
                             ('ROL', (0, -1)),
                             ('DB1', (0, -1)),
                             ('OBX', (0, -1)),
                             ('AL1', (0, -1)),
                             ('DG1', (0, -1)),
                             ('DRG', (0, 1)),
                             ('ADR_A19_PROCEDURE', (0, -1)),
                             ('GT1', (0, -1)),
                             ('ADR_A19_INSURANCE', (0, -1)),
                             ('ACC', (0, 1)),
                             ('UB1', (0, 1)),
                             ('UB2', (0, 1)))),
 'ADT_A01_INSURANCE': ('sequence',
                       (('IN1', (1, 1)),
                        ('IN2', (0, 1)),
                        ('IN3', (0, -1)),
                        ('ROL', (0, -1)))),
 'ADT_A01_PROCEDURE': ('sequence', (('PR1', (1, 1)), ('ROL', (0, -1)))),
 'ADT_A03_PROCEDURE': ('sequence', (('PR1', (1, 1)), ('ROL', (0, -1)))),
 'ADT_A05_INSURANCE': ('sequence',
                       (('IN1', (1, 1)),
                        ('IN2', (0, 1)),
                        ('IN3', (0, -1)),
                        ('ROL', (0, -1)))),
 'ADT_A05_PROCEDURE': ('sequence', (('PR1', (1, 1)), ('ROL', (0, -1)))),
 'ADT_A06_INSURANCE': ('sequence',
                       (('IN1', (1, 1)),
                        ('IN2', (0, 1)),
                        ('IN3', (0, -1)),
                        ('ROL', (0, -1)))),
 'ADT_A06_PROCEDURE': ('sequence', (('PR1', (1, 1)), ('ROL', (0, -1)))),
 'ADT_A39_PATIENT': ('sequence',
                     (('PID', (1, 1)),
                      ('PD1', (0, 1)),
                      ('MRG', (1, 1)),
                      ('PV1', (0, 1)))),
 'ADT_A43_PATIENT': ('sequence',
                     (('PID', (1, 1)), ('PD1', (0, 1)), ('MRG', (1, 1)))),
 'ADT_A45_MERGE_INFO': ('sequence', (('MRG', (1, 1)), ('PV1', (1, 1)))),
 'BAR_P01_INSURANCE': ('sequence',
                       (('IN1', (1, 1)),
                        ('IN2', (0, 1)),
                        ('IN3', (0, -1)),
                        ('ROL', (0, -1)))),
 'BAR_P01_PROCEDURE': ('sequence', (('PR1', (1, 1)), ('ROL', (0, -1)))),
 'BAR_P01_VISIT': ('sequence',
                   (('PV1', (0, 1)),
                    ('PV2', (0, 1)),
                    ('ROL', (0, -1)),
                    ('DB1', (0, -1)),
                    ('OBX', (0, -1)),
                    ('AL1', (0, -1)),
                    ('DG1', (0, -1)),
                    ('DRG', (0, 1)),
                    ('BAR_P01_PROCEDURE', (0, -1)),
                    ('GT1', (0, -1)),
                    ('NK1', (0, -1)),
                    ('BAR_P01_INSURANCE', (0, -1)),
                    ('ACC', (0, 1)),
                    ('UB1', (0, 1)),
                    ('UB2', (0, 1)))),
 'BAR_P02_PATIENT': ('sequence',
                     (('PID', (1, 1)),
                      ('PD1', (0, 1)),
                      ('PV1', (0, 1)),
                      ('DB1', (0, -1)))),
 'BAR_P05_INSURANCE': ('sequence',
                       (('IN1', (1, 1)),
                        ('IN2', (0, 1)),
                        ('IN3', (0, -1)),
                        ('ROL', (0, -1)))),
 'BAR_P05_PROCEDURE': ('sequence', (('PR1', (1, 1)), ('ROL', (0, -1)))),
 'BAR_P05_VISIT': ('sequence',
                   (('PV1', (0, 1)),
                    ('PV2', (0, 1)),
                    ('ROL', (0, -1)),
                    ('DB1', (0, -1)),
                    ('OBX', (0, -1)),
                    ('AL1', (0, -1)),
                    ('DG1', (0, -1)),
                    ('DRG', (0, 1)),
                    ('BAR_P05_PROCEDURE', (0, -1)),
                    ('GT1', (0, -1)),
                    ('NK1', (0, -1)),
                    ('BAR_P05_INSURANCE', (0, -1)),
                    ('ACC', (0, 1)),
                    ('UB1', (0, 1)),
                    ('UB2', (0, 1)),
                    ('ABS', (0, 1)),
                    ('BLC', (0, -1)),
                    ('RMI', (0, 1)))),
 'BAR_P06_PATIENT': ('sequence', (('PID', (1, 1)), ('PV1', (0, 1)))),
 'BAR_P10_PROCEDURE': ('sequence', (('PR1', (1, 1)), ('GP2', (0, 1)))),
 'CRM_C01_PATIENT': ('sequence',
                     (('PID', (1, 1)),
                      ('PV1', (0, 1)),
                      ('CSR', (1, 1)),
                      ('CSP', (0, -1)))),
 'CSU_C09_PATIENT': ('sequence',
                     (('PID', (1, 1)),
                      ('PD1', (0, 1)),
                      ('NTE', (0, -1)),
                      ('CSU_C09_VISIT', (0, 1)),
                      ('CSR', (1, 1)),
                      ('CSU_C09_STUDY_PHASE', (1, -1)))),
 'CSU_C09_RX_ADMIN': ('sequence', (('RXA', (1, 1)), ('RXR', (1, 1)))),
 'CSU_C09_STUDY_OBSERVATION': ('sequence',
                               (('ORC', (0, 1)),
                                ('OBR', (1, 1)),
                                ('OBX', (1, -1)))),
 'CSU_C09_STUDY_PHARM': ('sequence',
                         (('ORC', (0, 1)), ('CSU_C09_RX_ADMIN', (1, -1)))),
 'CSU_C09_STUDY_PHASE': ('sequence',
                         (('CSP', (0, -1)),
                          ('CSU_C09_STUDY_SCHEDULE', (1, -1)))),
 'CSU_C09_STUDY_SCHEDULE': ('sequence',
                            (('CSS', (0, 1)),
                             ('CSU_C09_STUDY_OBSERVATION', (1, -1)),
                             ('CSU_C09_STUDY_PHARM', (1, -1)))),
 'CSU_C09_VISIT': ('sequence', (('PV1', (1, 1)), ('PV2', (0, 1)))),
 'DFT_P03_COMMON_ORDER': ('sequence',
                          (('ORC', (0, 1)),
                           ('DFT_P03_ORDER', (0, 1)),
                           ('DFT_P03_OBSERVATION', (0, -1)))),
 'DFT_P03_FINANCIAL': ('sequence',
                       (('FT1', (1, 1)),
                        ('DFT_P03_FINANCIAL_PROCEDURE', (0, -1)),
                        ('DFT_P03_FINANCIAL_COMMON_ORDER', (0, -1)))),
 'DFT_P03_FINANCIAL_COMMON_ORDER': ('sequence',
                                    (('ORC', (0, 1)),
                                     ('DFT_P03_FINANCIAL_ORDER', (0, 1)),
                                     ('DFT_P03_FINANCIAL_OBSERVATION',
                                      (0, -1)))),
 'DFT_P03_FINANCIAL_OBSERVATION': ('sequence',
                                   (('OBX', (1, 1)), ('NTE', (0, -1)))),
 'DFT_P03_FINANCIAL_ORDER': ('sequence', (('OBR', (1, 1)), ('NTE', (0, -1)))),
 'DFT_P03_FINANCIAL_PROCEDURE': ('sequence',
                                 (('PR1', (1, 1)), ('ROL', (0, -1)))),
 'DFT_P03_INSURANCE': ('sequence',
                       (('IN1', (1, 1)),
                        ('IN2', (0, 1)),
                        ('IN3', (0, -1)),
                        ('ROL', (0, -1)))),
 'DFT_P03_OBSERVATION': ('sequence', (('OBX', (1, 1)), ('NTE', (0, -1)))),
 'DFT_P03_ORDER': ('sequence', (('OBR', (1, 1)), ('NTE', (0, -1)))),
 'DFT_P11_COMMON_ORDER': ('sequence',
                          (('ORC', (0, 1)),
                           ('DFT_P11_ORDER', (0, 1)),
                           ('DFT_P11_OBSERVATION', (0, -1)))),
 'DFT_P11_FINANCIAL': ('sequence',
                       (('FT1', (1, 1)),
                        ('DFT_P11_FINANCIAL_PROCEDURE', (0, -1)),
                        ('DFT_P11_FINANCIAL_COMMON_ORDER', (0, -1)),
                        ('DG1', (0, -1)),
                        ('DRG', (0, 1)),
                        ('GT1', (0, -1)),
                        ('DFT_P11_FINANCIAL_INSURANCE', (0, -1)))),
 'DFT_P11_FINANCIAL_COMMON_ORDER': ('sequence',
                                    (('ORC', (0, 1)),
                                     ('DFT_P11_FINANCIAL_ORDER', (0, 1)),
                                     ('DFT_P11_FINANCIAL_OBSERVATION',
                                      (0, -1)))),
 'DFT_P11_FINANCIAL_INSURANCE': ('sequence',
                                 (('IN1', (1, 1)),
                                  ('IN2', (0, 1)),
                                  ('IN3', (0, -1)),
                                  ('ROL', (0, -1)))),
 'DFT_P11_FINANCIAL_OBSERVATION': ('sequence',
                                   (('OBX', (1, 1)), ('NTE', (0, -1)))),
 'DFT_P11_FINANCIAL_ORDER': ('sequence', (('OBR', (1, 1)), ('NTE', (0, -1)))),
 'DFT_P11_FINANCIAL_PROCEDURE': ('sequence',
                                 (('PR1', (1, 1)), ('ROL', (0, -1)))),
 'DFT_P11_INSURANCE': ('sequence',
                       (('IN1', (1, 1)),
                        ('IN2', (0, 1)),
                        ('IN3', (0, -1)),
                        ('ROL', (0, -1)))),
 'DFT_P11_OBSERVATION': ('sequence', (('OBX', (1, 1)), ('NTE', (0, -1)))),
 'DFT_P11_ORDER': ('sequence', (('OBR', (1, 1)), ('NTE', (0, -1)))),
 'DOC_T12_RESULT': ('sequence',
                    (('EVN', (0, 1)),
                     ('PID', (1, 1)),
                     ('PV1', (1, 1)),
                     ('TXA', (1, 1)),
                     ('OBX', (0, -1)))),
 'EAN_U09_NOTIFICATION': ('sequence', (('NDS', (1, 1)), ('NTE', (0, 1)))),
 'EAR_U08_COMMAND_RESPONSE': ('sequence',
                              (('ECD', (1, 1)),
                               ('SAC', (0, 1)),
                               ('ECR', (1, 1)))),
 'MFN_M01_MF': ('sequence', (('MFE', (1, 1)), ('ANYZSEGMENT', (0, 1)))),
 'MFN_M02_MF_STAFF': ('sequence',
                      (('MFE', (1, 1)),
                       ('STF', (1, 1)),
                       ('PRA', (0, 1)),
                       ('ORG', (0, 1)))),
 'MFN_M03_MF_TEST': ('sequence',
                     (('MFE', (1, 1)),
                      ('OM1', (1, 1)),
                      ('ANYHL7SEGMENT', (1, 1)))),
 'MFN_M04_MF_CDM': ('sequence',
                    (('MFE', (1, 1)), ('CDM', (1, 1)), ('PRC', (0, -1)))),
 'MFN_M05_MF_LOCATION': ('sequence',
                         (('MFE', (1, 1)),
                          ('LOC', (1, 1)),
                          ('LCH', (0, -1)),
                          ('LRL', (0, -1)),
                          ('MFN_M05_MF_LOC_DEPT', (1, -1)))),
 'MFN_M05_MF_LOC_DEPT': ('sequence',
                         (('LDP', (1, 1)),
                          ('LCH', (0, -1)),
                          ('LCC', (0, -1)))),
 'MFN_M06_MF_CLIN_STUDY': ('sequence',
                           (('MFE', (1, 1)),
                            ('CM0', (1, 1)),
                            ('MFN_M06_MF_PHASE_SCHED_DETAIL', (0, -1)))),
 'MFN_M06_MF_PHASE_SCHED_DETAIL': ('sequence',
                                   (('CM1', (1, 1)), ('CM2', (0, -1)))),
 'MFN_M07_MF_CLIN_STUDY_SCHED': ('sequence',
                                 (('MFE', (1, 1)),
                                  ('CM0', (1, 1)),
                                  ('CM2', (0, -1)))),
 'MFN_M08_MF_TEST_NUMERIC': ('sequence',
                             (('MFE', (1, 1)),
                              ('OM1', (1, 1)),
                              ('OM2', (0, 1)),
                              ('OM3', (0, 1)),
                              ('OM4', (0, 1)))),
 'MFN_M09_MF_TEST_CATEGORICAL': ('sequence',
                                 (('MFE', (1, 1)),
                                  ('OM1', (1, 1)),
                                  ('MFN_M09_MF_TEST_CAT_DETAIL', (0, 1)))),
 'MFN_M09_MF_TEST_CAT_DETAIL': ('sequence',
                                (('OM3', (1, 1)), ('OM4', (0, -1)))),
 'MFN_M10_MF_TEST_BATTERIES': ('sequence',
                               (('MFE', (1, 1)),
                                ('OM1', (1, 1)),
                                ('MFN_M10_MF_TEST_BATT_DETAIL', (0, 1)))),
 'MFN_M10_MF_TEST_BATT_DETAIL': ('sequence',
                                 (('OM5', (1, 1)), ('OM4', (0, -1)))),
 'MFN_M11_MF_TEST_CALCULATED': ('sequence',
                                (('MFE', (1, 1)),
                                 ('OM1', (1, 1)),
                                 ('MFN_M11_MF_TEST_CALC_DETAIL', (0, 1)))),
 'MFN_M11_MF_TEST_CALC_DETAIL': ('sequence',
                                 (('OM6', (1, 1)), ('OM2', (1, 1)))),
 'MFN_M12_MF_OBS_ATTRIBUTES': ('sequence',
                               (('MFE', (1, 1)),
                                ('OM1', (1, 1)),
                                ('OM7', (0, 1)))),
 'MFR_M01_MF_QUERY': ('sequence', (('MFE', (1, 1)), ('ANYZSEGMENT', (0, 1)))),
 'NMD_N02_APP_STATS': ('sequence', (('NST', (1, 1)), ('NTE', (0, -1)))),
 'NMD_N02_APP_STATUS': ('sequence', (('NSC', (1, 1)), ('NTE', (0, -1)))),
 'NMD_N02_CLOCK': ('sequence', (('NCK', (1, 1)), ('NTE', (0, -1)))),
 'NMD_N02_CLOCK_AND_STATS_WITH_NOTES': ('sequence',
                                        (('NMD_N02_CLOCK', (0, 1)),
                                         ('NMD_N02_APP_STATS', (0, 1)),
                                         ('NMD_N02_APP_STATUS', (0, 1)))),
 'NMQ_N01_CLOCK_AND_STATISTICS': ('sequence',
                                  (('NCK', (0, 1)),
                                   ('NST', (0, 1)),
                                   ('NSC', (0, 1)))),
 'NMQ_N01_QRY_WITH_DETAIL': ('sequence', (('QRD', (1, 1)), ('QRF', (0, 1)))),
 'NMR_N01_CLOCK_AND_STATS_WITH_NOTES_ALT': ('sequence',
                                            (('NCK', (0, 1)),
                                             ('NTE', (0, -1)),
                                             ('NST', (0, 1)),
                                             ('NTE', (0, -1)),
                                             ('NSC', (0, 1)),
                                             ('NTE', (0, -1)))),
 'OMD_O03_DIET': ('sequence',
                  (('ODS', (1, -1)),
                   ('NTE', (0, -1)),
                   ('OMD_O03_OBSERVATION', (0, -1)))),
 'OMD_O03_INSURANCE': ('sequence',
                       (('IN1', (1, 1)), ('IN2', (0, 1)), ('IN3', (0, 1)))),
 'OMD_O03_OBSERVATION': ('sequence', (('OBX', (1, 1)), ('NTE', (0, -1)))),
 'OMD_O03_ORDER_DIET': ('sequence',
                        (('ORC', (1, 1)), ('OMD_O03_DIET', (0, 1)))),
 'OMD_O03_ORDER_TRAY': ('sequence',
                        (('ORC', (1, 1)), ('ODT', (1, -1)), ('NTE', (0, -1)))),
 'OMD_O03_PATIENT': ('sequence',
                     (('PID', (1, 1)),
                      ('PD1', (0, 1)),
                      ('NTE', (0, -1)),
                      ('OMD_O03_PATIENT_VISIT', (0, 1)),
                      ('OMD_O03_INSURANCE', (0, -1)),
                      ('GT1', (0, 1)),
                      ('AL1', (0, -1)))),
 'OMD_O03_PATIENT_VISIT': ('sequence', (('PV1', (1, 1)), ('PV2', (0, 1)))),
 'OMG_O19_INSURANCE': ('sequence',
                       (('IN1', (1, 1)), ('IN2', (0, 1)), ('IN3', (0, 1)))),
 'OMG_O19_OBSERVATION': ('sequence', (('OBX', (1, 1)), ('NTE', (0, -1)))),
 'OMG_O19_OBSERVATION_PRIOR': ('sequence',
                               (('OBX', (1, 1)), ('NTE', (0, -1)))),
 'OMG_O19_ORDER': ('sequence',
                   (('ORC', (1, 1)),
                    ('OBR', (1, 1)),
                    ('NTE', (0, -1)),
                    ('CTD', (0, 1)),
                    ('DG1', (0, -1)),
                    ('OMG_O19_OBSERVATION', (0, -1)),
                    ('OMG_O19_PRIOR_RESULT', (0, -1)),
                    ('FT1', (0, -1)),
                    ('CTI', (0, -1)),
                    ('BLG', (0, 1)))),
 'OMG_O19_ORDER_PRIOR': ('sequence',
                         (('ORC', (0, 1)),
                          ('OBR', (1, 1)),
                          ('NTE', (0, -1)),
                          ('CTD', (0, 1)),
                          ('OMG_O19_OBSERVATION_PRIOR', (1, -1)))),
 'OMG_O19_PATIENT': ('sequence',
                     (('PID', (1, 1)),
                      ('PD1', (0, 1)),
                      ('NTE', (0, -1)),
                      ('OMG_O19_PATIENT_VISIT', (0, 1)),
                      ('OMG_O19_INSURANCE', (0, -1)),
                      ('GT1', (0, 1)),
                      ('AL1', (0, -1)))),
 'OMG_O19_PATIENT_PRIOR': ('sequence', (('PID', (1, 1)), ('PD1', (0, 1)))),
 'OMG_O19_PATIENT_VISIT': ('sequence', (('PV1', (1, 1)), ('PV2', (0, 1)))),
 'OMG_O19_PATIENT_VISIT_PRIOR': ('sequence',
                                 (('PV1', (1, 1)), ('PV2', (0, 1)))),
 'OMG_O19_PRIOR_RESULT': ('sequence',
                          (('OMG_O19_PATIENT_PRIOR', (0, 1)),
                           ('OMG_O19_PATIENT_VISIT_PRIOR', (0, 1)),
                           ('AL1', (0, -1)),
                           ('OMG_O19_ORDER_PRIOR', (1, -1)))),
 'OML_O21_CONTAINER_1': ('sequence', (('SAC', (1, 1)), ('OBX', (0, -1)))),
 'OML_O21_CONTAINER_2': ('sequence', (('SAC', (1, 1)), ('OBX', (0, -1)))),
 'OML_O21_INSURANCE': ('sequence',
                       (('IN1', (1, 1)), ('IN2', (0, 1)), ('IN3', (0, 1)))),
 'OML_O21_OBSERVATION': ('sequence',
                         (('OBX', (1, 1)), ('TCD', (0, 1)), ('NTE', (0, -1)))),
 'OML_O21_OBSERVATION_PRIOR': ('sequence',
                               (('OBX', (1, 1)), ('NTE', (0, -1)))),
 'OML_O21_OBSERVATION_REQUEST': ('sequence',
                                 (('OBR', (1, 1)),
                                  ('OML_O21_CONTAINER_2', (0, -1)),
                                  ('TCD', (0, 1)),
                                  ('NTE', (0, -1)),
                                  ('DG1', (0, -1)),
                                  ('OML_O21_OBSERVATION', (0, -1)),
                                  ('OML_O21_PRIOR_RESULT', (0, -1)))),
 'OML_O21_ORDER': ('sequence',
                   (('ORC', (1, 1)),
                    ('OML_O21_OBSERVATION_REQUEST', (0, 1)),
                    ('FT1', (0, -1)),
                    ('CTI', (0, -1)),
                    ('BLG', (0, 1)))),
 'OML_O21_ORDER_GENERAL': ('sequence',
                           (('OML_O21_CONTAINER_1', (0, 1)),
                            ('OML_O21_ORDER', (1, -1)))),
 'OML_O21_ORDER_PRIOR': ('sequence',
                         (('ORC', (0, 1)),
                          ('OBR', (1, 1)),
                          ('NTE', (0, -1)),
                          ('OML_O21_OBSERVATION_PRIOR', (1, -1)))),
 'OML_O21_PATIENT': ('sequence',
                     (('PID', (1, 1)),
                      ('PD1', (0, 1)),
                      ('NTE', (0, -1)),
                      ('OML_O21_PATIENT_VISIT', (0, 1)),
                      ('OML_O21_INSURANCE', (0, -1)),
                      ('GT1', (0, 1)),
                      ('AL1', (0, -1)))),
 'OML_O21_PATIENT_PRIOR': ('sequence', (('PID', (1, 1)), ('PD1', (0, 1)))),
 'OML_O21_PATIENT_VISIT': ('sequence', (('PV1', (1, 1)), ('PV2', (0, 1)))),
 'OML_O21_PATIENT_VISIT_PRIOR': ('sequence',
                                 (('PV1', (1, 1)), ('PV2', (0, 1)))),
 'OML_O21_PRIOR_RESULT': ('sequence',
                          (('OML_O21_PATIENT_PRIOR', (0, 1)),
                           ('OML_O21_PATIENT_VISIT_PRIOR', (0, 1)),
                           ('AL1', (0, -1)),
                           ('OML_O21_ORDER_PRIOR', (1, -1)))),
 'OMN_O07_INSURANCE': ('sequence',
                       (('IN1', (1, 1)), ('IN2', (0, 1)), ('IN3', (0, 1)))),
 'OMN_O07_OBSERVATION': ('sequence', (('OBX', (1, 1)), ('NTE', (0, -1)))),
 'OMN_O07_ORDER': ('sequence',
                   (('ORC', (1, 1)),
                    ('RQD', (1, 1)),
                    ('RQ1', (0, 1)),
                    ('NTE', (0, -1)),
                    ('OMN_O07_OBSERVATION', (0, -1)),
                    ('BLG', (0, 1)))),
 'OMN_O07_PATIENT': ('sequence',
                     (('PID', (1, 1)),
                      ('PD1', (0, 1)),
                      ('NTE', (0, -1)),
                      ('OMN_O07_PATIENT_VISIT', (0, 1)),
                      ('OMN_O07_INSURANCE', (0, -1)),
                      ('GT1', (0, 1)),
                      ('AL1', (0, -1)))),
 'OMN_O07_PATIENT_VISIT': ('sequence', (('PV1', (1, 1)), ('PV2', (0, 1)))),
 'OMP_O09_COMPONENT': ('sequence', (('RXC', (1, -1)), ('NTE', (0, -1)))),
 'OMP_O09_INSURANCE': ('sequence',
                       (('IN1', (1, 1)), ('IN2', (0, 1)), ('IN3', (0, 1)))),
 'OMP_O09_OBSERVATION': ('sequence', (('OBX', (1, 1)), ('NTE', (0, -1)))),
 'OMP_O09_ORDER': ('sequence',
                   (('ORC', (1, 1)),
                    ('RXO', (1, 1)),
                    ('NTE', (0, -1)),
                    ('RXR', (1, -1)),
                    ('OMP_O09_COMPONENT', (0, 1)),
                    ('OMP_O09_OBSERVATION', (0, -1)),
                    ('FT1', (0, -1)),
                    ('BLG', (0, 1)))),
 'OMP_O09_PATIENT': ('sequence',
                     (('PID', (1, 1)),
                      ('PD1', (0, 1)),
                      ('NTE', (0, -1)),
                      ('OMP_O09_PATIENT_VISIT', (0, 1)),
                      ('OMP_O09_INSURANCE', (0, -1)),
                      ('GT1', (0, 1)),
                      ('AL1', (0, -1)))),
 'OMP_O09_PATIENT_VISIT': ('sequence', (('PV1', (1, 1)), ('PV2', (0, 1)))),
 'OMS_O05_INSURANCE': ('sequence',
                       (('IN1', (1, 1)), ('IN2', (0, 1)), ('IN3', (0, 1)))),
 'OMS_O05_OBSERVATION': ('sequence', (('OBX', (1, 1)), ('NTE', (0, -1)))),
 'OMS_O05_ORDER': ('sequence',
                   (('ORC', (1, 1)),
                    ('RQD', (1, 1)),
                    ('RQ1', (0, 1)),
                    ('NTE', (0, -1)),
                    ('OMS_O05_OBSERVATION', (0, -1)),
                    ('BLG', (0, 1)))),
 'OMS_O05_PATIENT': ('sequence',
                     (('PID', (1, 1)),
                      ('PD1', (0, 1)),
                      ('NTE', (0, -1)),
                      ('OMS_O05_PATIENT_VISIT', (0, 1)),
                      ('OMS_O05_INSURANCE', (0, -1)),
                      ('GT1', (0, 1)),
                      ('AL1', (0, -1)))),
 'OMS_O05_PATIENT_VISIT': ('sequence', (('PV1', (1, 1)), ('PV2', (0, 1)))),
 'ORD_O04_ORDER_DIET': ('sequence',
                        (('ORC', (1, 1)), ('ODS', (0, -1)), ('NTE', (0, -1)))),
 'ORD_O04_ORDER_TRAY': ('sequence',
                        (('ORC', (1, 1)), ('ODT', (0, -1)), ('NTE', (0, -1)))),
 'ORD_O04_PATIENT': ('sequence', (('PID', (1, 1)), ('NTE', (0, -1)))),
 'ORD_O04_RESPONSE': ('sequence',
                      (('ORD_O04_PATIENT', (0, 1)),
                       ('ORD_O04_ORDER_DIET', (1, -1)),
                       ('ORD_O04_ORDER_TRAY', (0, -1)))),
 'ORF_R04_OBSERVATION': ('sequence', (('OBX', (0, 1)), ('NTE', (0, -1)))),
 'ORF_R04_ORDER': ('sequence',
                   (('ORC', (0, 1)),
                    ('OBR', (1, 1)),
                    ('NTE', (0, -1)),
                    ('CTD', (0, 1)),
                    ('ORF_R04_OBSERVATION', (1, -1)),
                    ('CTI', (0, -1)))),
 'ORF_R04_PATIENT': ('sequence', (('PID', (1, 1)), ('NTE', (0, -1)))),
 'ORF_R04_RESPONSE': ('sequence',
                      (('ORF_R04_PATIENT', (0, 1)),
                       ('ORF_R04_ORDER', (1, -1)))),
 'ORG_O20_ORDER': ('sequence',
                   (('ORC', (1, 1)),
                    ('OBR', (0, 1)),
                    ('NTE', (0, -1)),
                    ('CTI', (0, -1)))),
 'ORG_O20_PATIENT': ('sequence', (('PID', (1, 1)), ('NTE', (0, -1)))),
 'ORG_O20_RESPONSE': ('sequence',
                      (('ORG_O20_PATIENT', (0, 1)),
                       ('ORG_O20_ORDER', (1, -1)))),
 'ORL_O22_CONTAINER': ('sequence', (('SAC', (1, 1)), ('OBX', (0, -1)))),
 'ORL_O22_GENERAL_ORDER': ('sequence',
                           (('ORL_O22_CONTAINER', (0, 1)),
                            ('ORL_O22_ORDER', (0, -1)))),
 'ORL_O22_OBSERVATION_REQUEST': ('sequence',
                                 (('OBR', (1, 1)), ('SAC', (0, -1)))),
 'ORL_O22_ORDER': ('sequence',
                   (('ORC', (1, 1)), ('ORL_O22_OBSERVATION_REQUEST', (0, 1)))),
 'ORL_O22_PATIENT': ('sequence',
                     (('PID', (1, 1)), ('ORL_O22_GENERAL_ORDER', (1, -1)))),
 'ORL_O22_RESPONSE': ('sequence', (('ORL_O22_PATIENT', (0, 1)),)),
 'ORM_O01_CHOICE': ('choice',
                    (('OBR', (1, 1)),
                     ('RQD', (1, 1)),
                     ('RQ1', (1, 1)),
                     ('RXO', (1, 1)),
                     ('ODS', (1, 1)),
                     ('ODT', (1, 1)))),
 'ORM_O01_INSURANCE': ('sequence',
                       (('IN1', (1, 1)), ('IN2', (0, 1)), ('IN3', (0, 1)))),
 'ORM_O01_OBSERVATION': ('sequence', (('OBX', (1, 1)), ('NTE', (0, -1)))),
 'ORM_O01_ORDER': ('sequence',
                   (('ORC', (1, 1)),
                    ('ORM_O01_ORDER_DETAIL', (0, 1)),
                    ('FT1', (0, -1)),
                    ('CTI', (0, -1)),
                    ('BLG', (0, 1)))),
 'ORM_O01_ORDER_DETAIL': ('sequence',
                          (('ORM_O01_CHOICE', (1, 1)),
                           ('NTE', (0, -1)),
                           ('CTD', (0, 1)),
                           ('DG1', (0, -1)),
                           ('ORM_O01_OBSERVATION', (0, -1)))),
 'ORM_O01_PATIENT': ('sequence',
                     (('PID', (1, 1)),
                      ('PD1', (0, 1)),
                      ('NTE', (0, -1)),
                      ('ORM_O01_PATIENT_VISIT', (0, 1)),
                      ('ORM_O01_INSURANCE', (0, -1)),
                      ('GT1', (0, 1)),
                      ('AL1', (0, -1)))),
 'ORM_O01_PATIENT_VISIT': ('sequence', (('PV1', (1, 1)), ('PV2', (0, 1)))),
 'ORN_O08_ORDER': ('sequence',
                   (('ORC', (1, 1)),
                    ('RQD', (1, 1)),
                    ('RQ1', (0, 1)),
                    ('NTE', (0, -1)))),
 'ORN_O08_PATIENT': ('sequence', (('PID', (1, 1)), ('NTE', (0, -1)))),
 'ORN_O08_RESPONSE': ('sequence',
                      (('ORN_O08_PATIENT', (0, 1)),
                       ('ORN_O08_ORDER', (1, -1)))),
 'ORP_O10_ORDER': ('sequence',
                   (('ORC', (1, 1)), ('ORP_O10_ORDER_DETAIL', (0, 1)))),
 'ORP_O10_ORDER_DETAIL': ('sequence',
                          (('RXO', (1, 1)),
                           ('NTE', (0, -1)),
                           ('RXR', (1, -1)),
                           ('RXC', (0, -1)),
                           ('NTE', (0, -1)))),
 'ORP_O10_PATIENT': ('sequence', (('PID', (1, 1)), ('NTE', (0, -1)))),
 'ORP_O10_RESPONSE': ('sequence',
                      (('ORP_O10_PATIENT', (0, 1)),
                       ('ORP_O10_ORDER', (1, -1)))),
 'ORR_O02_ORDER': ('sequence',
                   (('ORC', (1, 1)),
                    ('ORR_O02_ORDER_DETAIL', (1, 1)),
                    ('NTE', (0, -1)),
                    ('CTI', (0, -1)))),
 'ORR_O02_ORDER_DETAIL': ('choice',
                          (('OBR', (1, 1)),
                           ('RQD', (1, 1)),
                           ('RQ1', (1, 1)),
                           ('RXO', (1, 1)),
                           ('ODS', (1, 1)),
                           ('ODT', (1, 1)))),
 'ORR_O02_PATIENT': ('sequence', (('PID', (1, 1)), ('NTE', (0, -1)))),
 'ORR_O02_RESPONSE': ('sequence',
                      (('ORR_O02_PATIENT', (0, 1)),
                       ('ORR_O02_ORDER', (1, -1)))),
 'ORS_O06_ORDER': ('sequence',
                   (('ORC', (1, 1)),
                    ('RQD', (1, 1)),
                    ('RQ1', (0, 1)),
                    ('NTE', (0, -1)))),
 'ORS_O06_PATIENT': ('sequence', (('PID', (1, 1)), ('NTE', (0, -1)))),
 'ORS_O06_RSPONSE': ('sequence',
                     (('ORS_O06_PATIENT', (0, 1)),
                      ('ORS_O06_ORDER', (1, -1)))),
 'ORU_R01_OBSERVATION': ('sequence', (('OBX', (0, 1)), ('NTE', (0, -1)))),
 'ORU_R01_ORDER_OBSERVATION': ('sequence',
                               (('ORC', (0, 1)),
                                ('OBR', (1, 1)),
                                ('NTE', (0, -1)),
                                ('CTD', (0, 1)),
                                ('ORU_R01_OBSERVATION', (1, -1)),
                                ('FT1', (0, -1)),
                                ('CTI', (0, -1)))),
 'ORU_R01_PATIENT': ('sequence',
                     (('PID', (1, 1)),
                      ('PD1', (0, 1)),
                      ('NK1', (0, -1)),
                      ('NTE', (0, -1)),
                      ('ORU_R01_VISIT', (0, 1)))),
 'ORU_R01_PATIENT_RESULT': ('sequence',
                            (('ORU_R01_PATIENT', (0, 1)),
                             ('ORU_R01_ORDER_OBSERVATION', (1, -1)))),
 'ORU_R01_VISIT': ('sequence', (('PV1', (1, 1)), ('PV2', (0, 1)))),
 'OSR_Q06_CHOICE': ('choice',
                    (('OBR', (1, 1)),
                     ('RQD', (1, 1)),
                     ('RQ1', (1, 1)),
                     ('RXO', (1, 1)),
                     ('ODS', (1, 1)),
                     ('ODT', (1, 1)))),
 'OSR_Q06_ORDER': ('sequence',
                   (('ORC', (1, 1)),
                    ('OSR_Q06_CHOICE', (1, 1)),
                    ('NTE', (0, -1)),
                    ('CTI', (0, -1)))),
 'OSR_Q06_PATIENT': ('sequence', (('PID', (1, 1)), ('NTE', (0, -1)))),
 'OSR_Q06_RESPONSE': ('sequence',
                      (('OSR_Q06_PATIENT', (0, 1)),
                       ('OSR_Q06_ORDER', (1, -1)))),
 'OUL_R21_CONTAINER': ('sequence',
                       (('SAC', (1, 1)), ('SID', (0, 1)), ('OBX', (0, -1)))),
 'OUL_R21_OBSERVATION': ('sequence',
                         (('OBX', (0, 1)),
                          ('TCD', (0, 1)),
                          ('SID', (0, -1)),
                          ('NTE', (0, -1)))),
 'OUL_R21_ORDER_OBSERVATION': ('sequence',
                               (('OUL_R21_CONTAINER', (0, 1)),
                                ('ORC', (0, 1)),
                                ('OBR', (1, 1)),
                                ('NTE', (0, -1)),
                                ('OUL_R21_OBSERVATION', (1, -1)),
                                ('CTI', (0, -1)))),
 'OUL_R21_PATIENT': ('sequence',
                     (('PID', (1, 1)), ('PD1', (0, 1)), ('NTE', (0, -1)))),
 'OUL_R21_VISIT': ('sequence', (('PV1', (1, 1)), ('PV2', (0, 1)))),
 'PEX_P07_ASSOCIATED_PERSON': ('sequence',
                               (('NK1', (1, 1)),
                                ('PEX_P07_ASSOCIATED_RX_ORDER', (0, 1)),
                                ('PEX_P07_ASSOCIATED_RX_ADMIN', (0, -1)),
                                ('PRB', (0, -1)),
                                ('OBX', (0, -1)))),
 'PEX_P07_ASSOCIATED_RX_ADMIN': ('sequence',
                                 (('RXA', (1, 1)), ('RXR', (0, 1)))),
 'PEX_P07_ASSOCIATED_RX_ORDER': ('sequence',
                                 (('RXE', (1, 1)), ('RXR', (0, -1)))),
 'PEX_P07_EXPERIENCE': ('sequence',
                        (('PES', (1, 1)),
                         ('PEX_P07_PEX_OBSERVATION', (1, -1)))),
 'PEX_P07_PEX_CAUSE': ('sequence',
                       (('PCR', (1, 1)),
                        ('PEX_P07_RX_ORDER', (0, 1)),
                        ('PEX_P07_RX_ADMINISTRATION', (0, -1)),
                        ('PRB', (0, -1)),
                        ('OBX', (0, -1)),
                        ('NTE', (0, -1)),
                        ('PEX_P07_ASSOCIATED_PERSON', (0, 1)),
                        ('PEX_P07_STUDY', (0, -1)))),
 'PEX_P07_PEX_OBSERVATION': ('sequence',
                             (('PEO', (1, 1)),
                              ('PEX_P07_PEX_CAUSE', (1, -1)))),
 'PEX_P07_RX_ADMINISTRATION': ('sequence', (('RXA', (1, 1)), ('RXR', (0, 1)))),
 'PEX_P07_RX_ORDER': ('sequence', (('RXE', (1, 1)), ('RXR', (0, -1)))),
 'PEX_P07_STUDY': ('sequence', (('CSR', (1, 1)), ('CSP', (0, -1)))),
 'PEX_P07_VISIT': ('sequence', (('PV1', (1, 1)), ('PV2', (0, 1)))),
 'PGL_PC6_GOAL': ('sequence',
                  (('GOL', (1, 1)),
                   ('NTE', (0, -1)),
                   ('VAR', (0, -1)),
                   ('PGL_PC6_GOAL_ROLE', (0, -1)),
                   ('PGL_PC6_PATHWAY', (0, -1)),
                   ('PGL_PC6_OBSERVATION', (0, -1)),
                   ('PGL_PC6_PROBLEM', (0, -1)),
                   ('PGL_PC6_ORDER', (0, -1)))),
 'PGL_PC6_GOAL_ROLE': ('sequence', (('ROL', (1, 1)), ('VAR', (0, -1)))),
 'PGL_PC6_OBRRXO_SUPPGRP': ('choice', (('OBR', (1, 1)), ('RXO', (1, 1)))),
 'PGL_PC6_OBSERVATION': ('sequence', (('OBX', (1, 1)), ('NTE', (0, -1)))),
 'PGL_PC6_ORDER': ('sequence',
                   (('ORC', (1, 1)), ('PGL_PC6_ORDER_DETAIL', (0, 1)))),
 'PGL_PC6_ORDER_DETAIL': ('sequence',
                          (('PGL_PC6_OBRRXO_SUPPGRP', (1, 1)),
                           ('NTE', (0, -1)),
                           ('VAR', (0, -1)),
                           ('PGL_PC6_ORDER_OBSERVATION', (0, -1)))),
 'PGL_PC6_ORDER_OBSERVATION': ('sequence',
                               (('OBX', (1, 1)),
                                ('NTE', (0, -1)),
                                ('VAR', (0, -1)))),
 'PGL_PC6_PATHWAY': ('sequence', (('PTH', (1, 1)), ('VAR', (0, -1)))),
 'PGL_PC6_PATIENT_VISIT': ('sequence', (('PV1', (1, 1)), ('PV2', (0, 1)))),
 'PGL_PC6_PROBLEM': ('sequence',
                     (('PRB', (1, 1)),
                      ('NTE', (0, -1)),
                      ('VAR', (0, -1)),
                      ('PGL_PC6_PROBLEM_ROLE', (0, -1)),
                      ('PGL_PC6_PROBLEM_OBSERVATION', (0, -1)))),
 'PGL_PC6_PROBLEM_OBSERVATION': ('sequence',
                                 (('OBX', (1, 1)), ('NTE', (0, -1)))),
 'PGL_PC6_PROBLEM_ROLE': ('sequence', (('ROL', (1, 1)), ('VAR', (0, -1)))),
 'PPG_PCG_GOAL': ('sequence',
                  (('GOL', (1, 1)),
                   ('NTE', (0, -1)),
                   ('VAR', (0, -1)),
                   ('PPG_PCG_GOAL_ROLE', (0, -1)),
                   ('PPG_PCG_GOAL_OBSERVATION', (0, -1)),
                   ('PPG_PCG_PROBLEM', (0, -1)),
                   ('PPG_PCG_ORDER', (0, -1)))),
 'PPG_PCG_GOAL_OBSERVATION': ('sequence', (('OBX', (1, 1)), ('NTE', (0, -1)))),
 'PPG_PCG_GOAL_ROLE': ('sequence', (('ROL', (1, 1)), ('VAR', (0, -1)))),
 'PPG_PCG_OBRRXO_SUPPGRP': ('choice', (('OBR', (1, 1)), ('RXO', (1, 1)))),
 'PPG_PCG_ORDER': ('sequence',
                   (('ORC', (1, 1)), ('PPG_PCG_ORDER_DETAIL', (0, 1)))),
 'PPG_PCG_ORDER_DETAIL': ('sequence',
                          (('PPG_PCG_OBRRXO_SUPPGRP', (1, 1)),
                           ('NTE', (0, -1)),
                           ('VAR', (0, -1)),
                           ('PPG_PCG_ORDER_OBSERVATION', (0, -1)))),
 'PPG_PCG_ORDER_OBSERVATION': ('sequence',
                               (('OBX', (1, 1)),
                                ('NTE', (0, -1)),
                                ('VAR', (0, -1)))),
 'PPG_PCG_PATHWAY': ('sequence',
                     (('PTH', (1, 1)),
                      ('NTE', (0, -1)),
                      ('VAR', (0, -1)),
                      ('PPG_PCG_PATHWAY_ROLE', (0, -1)),
                      ('PPG_PCG_GOAL', (0, -1)))),
 'PPG_PCG_PATHWAY_ROLE': ('sequence', (('ROL', (1, 1)), ('VAR', (0, -1)))),
 'PPG_PCG_PATIENT_VISIT': ('sequence', (('PV1', (1, 1)), ('PV2', (0, 1)))),
 'PPG_PCG_PROBLEM': ('sequence',
                     (('PRB', (1, 1)),
                      ('NTE', (0, -1)),
                      ('VAR', (0, -1)),
                      ('PPG_PCG_PROBLEM_ROLE', (0, -1)),
                      ('PPG_PCG_PROBLEM_OBSERVATION', (0, -1)))),
 'PPG_PCG_PROBLEM_OBSERVATION': ('sequence',
                                 (('OBX', (1, 1)), ('NTE', (0, -1)))),
 'PPG_PCG_PROBLEM_ROLE': ('sequence', (('ROL', (1, 1)), ('VAR', (0, -1)))),
 'PPP_PCB_CHOICE': ('choice', (('OBR', (1, 1)), ('RXO', (1, 1)))),
 'PPP_PCB_GOAL': ('sequence',
                  (('GOL', (1, 1)),
                   ('NTE', (0, -1)),
                   ('VAR', (0, -1)),
                   ('PPP_PCB_GOAL_ROLE', (0, -1)),
                   ('PPP_PCB_GOAL_OBSERVATION', (0, -1)))),
 'PPP_PCB_GOAL_OBSERVATION': ('sequence', (('OBX', (1, 1)), ('NTE', (0, -1)))),
 'PPP_PCB_GOAL_ROLE': ('sequence', (('ROL', (1, 1)), ('VAR', (0, -1)))),
 'PPP_PCB_ORDER': ('sequence',
                   (('ORC', (1, 1)), ('PPP_PCB_ORDER_DETAIL', (0, 1)))),
 'PPP_PCB_ORDER_DETAIL': ('sequence',
                          (('PPP_PCB_CHOICE', (1, 1)),
                           ('NTE', (0, -1)),
                           ('VAR', (0, -1)),
                           ('PPP_PCB_ORDER_OBSERVATION', (0, -1)))),
 'PPP_PCB_ORDER_OBSERVATION': ('sequence',
                               (('OBX', (1, 1)),
                                ('NTE', (0, -1)),
                                ('VAR', (0, -1)))),
 'PPP_PCB_PATHWAY': ('sequence',
                     (('PTH', (1, 1)),
                      ('NTE', (0, -1)),
                      ('VAR', (0, -1)),
                      ('PPP_PCB_PATHWAY_ROLE', (0, -1)),
                      ('PPP_PCB_PROBLEM', (0, -1)))),
 'PPP_PCB_PATHWAY_ROLE': ('sequence', (('ROL', (1, 1)), ('VAR', (0, -1)))),
 'PPP_PCB_PATIENT_VISIT': ('sequence', (('PV1', (1, 1)), ('PV2', (0, 1)))),
 'PPP_PCB_PROBLEM': ('sequence',
                     (('PRB', (1, 1)),
                      ('NTE', (0, -1)),
                      ('VAR', (0, -1)),
                      ('PPP_PCB_PROBLEM_ROLE', (0, -1)),
                      ('PPP_PCB_PROBLEM_OBSERVATION', (0, -1)),
                      ('PPP_PCB_GOAL', (0, -1)),
                      ('PPP_PCB_ORDER', (0, -1)))),
 'PPP_PCB_PROBLEM_OBSERVATION': ('sequence',
                                 (('OBX', (1, 1)), ('NTE', (0, -1)))),
 'PPP_PCB_PROBLEM_ROLE': ('sequence', (('ROL', (1, 1)), ('VAR', (0, -1)))),
 'PPR_PC1_CHOICE': ('choice', (('OBR', (1, 1)), ('RXO', (1, 1)))),
 'PPR_PC1_GOAL': ('sequence',
                  (('GOL', (1, 1)),
                   ('NTE', (0, -1)),
                   ('VAR', (0, -1)),
                   ('PPR_PC1_GOAL_ROLE', (0, -1)),
                   ('PPR_PC1_GOAL_OBSERVATION', (0, -1)))),
 'PPR_PC1_GOAL_OBSERVATION': ('sequence', (('OBX', (1, 1)), ('NTE', (0, -1)))),
 'PPR_PC1_GOAL_ROLE': ('sequence', (('ROL', (1, 1)), ('VAR', (0, -1)))),
 'PPR_PC1_ORDER': ('sequence',
                   (('ORC', (1, 1)), ('PPR_PC1_ORDER_DETAIL', (0, 1)))),
 'PPR_PC1_ORDER_DETAIL': ('sequence',
                          (('PPR_PC1_CHOICE', (1, 1)),
                           ('NTE', (0, -1)),
                           ('VAR', (0, -1)),
                           ('PPR_PC1_ORDER_OBSERVATION', (0, -1)))),
 'PPR_PC1_ORDER_OBSERVATION': ('sequence',
                               (('OBX', (1, 1)),
                                ('NTE', (0, -1)),
                                ('VAR', (0, -1)))),
 'PPR_PC1_PATHWAY': ('sequence', (('PTH', (1, 1)), ('VAR', (0, -1)))),
 'PPR_PC1_PATIENT_VISIT': ('sequence', (('PV1', (1, 1)), ('PV2', (0, 1)))),
 'PPR_PC1_PROBLEM': ('sequence',
                     (('PRB', (1, 1)),
                      ('NTE', (0, -1)),
                      ('VAR', (0, -1)),
                      ('PPR_PC1_PROBLEM_ROLE', (0, -1)),
                      ('PPR_PC1_PATHWAY', (0, -1)),
                      ('PPR_PC1_PROBLEM_OBSERVATION', (0, -1)),
                      ('PPR_PC1_GOAL', (0, -1)),
                      ('PPR_PC1_ORDER', (0, -1)))),
 'PPR_PC1_PROBLEM_OBSERVATION': ('sequence',
                                 (('OBX', (1, 1)), ('NTE', (0, -1)))),
 'PPR_PC1_PROBLEM_ROLE': ('sequence', (('ROL', (1, 1)), ('VAR', (0, -1)))),
 'PPT_PCL_CHOICE': ('choice', (('OBR', (1, 1)), ('RXO', (1, 1)))),
 'PPT_PCL_GOAL': ('sequence',
                  (('GOL', (1, 1)),
                   ('NTE', (0, -1)),
                   ('VAR', (0, -1)),
                   ('PPT_PCL_GOAL_ROLE', (0, -1)),
                   ('PPT_PCL_GOAL_OBSERVATION', (0, -1)),
                   ('PPT_PCL_PROBLEM', (0, -1)),
                   ('PPT_PCL_ORDER', (0, -1)))),
 'PPT_PCL_GOAL_OBSERVATION': ('sequence', (('OBX', (1, 1)), ('NTE', (0, -1)))),
 'PPT_PCL_GOAL_ROLE': ('sequence', (('ROL', (1, 1)), ('VAR', (0, -1)))),
 'PPT_PCL_ORDER': ('sequence',
                   (('ORC', (1, 1)), ('PPT_PCL_ORDER_DETAIL', (0, 1)))),
 'PPT_PCL_ORDER_DETAIL': ('sequence',
                          (('PPT_PCL_CHOICE', (1, 1)),
                           ('NTE', (0, -1)),
                           ('VAR', (0, -1)),
                           ('PPT_PCL_ORDER_OBSERVATION', (0, -1)))),
 'PPT_PCL_ORDER_OBSERVATION': ('sequence',
                               (('OBX', (1, 1)),
                                ('NTE', (0, -1)),
                                ('VAR', (0, -1)))),
 'PPT_PCL_PATHWAY': ('sequence',
                     (('PTH', (1, 1)),
                      ('NTE', (0, -1)),
                      ('VAR', (0, -1)),
                      ('PPT_PCL_PATHWAY_ROLE', (0, -1)),
                      ('PPT_PCL_GOAL', (0, -1)))),
 'PPT_PCL_PATHWAY_ROLE': ('sequence', (('ROL', (1, 1)), ('VAR', (0, -1)))),
 'PPT_PCL_PATIENT': ('sequence',
                     (('PID', (1, 1)),
                      ('PPT_PCL_PATIENT_VISIT', (0, 1)),
                      ('PPT_PCL_PATHWAY', (1, -1)))),
 'PPT_PCL_PATIENT_VISIT': ('sequence', (('PV1', (1, 1)), ('PV2', (0, 1)))),
 'PPT_PCL_PROBLEM': ('sequence',
                     (('PRB', (1, 1)),
                      ('NTE', (0, -1)),
                      ('VAR', (0, -1)),
                      ('PPT_PCL_PROBLEM_ROLE', (0, -1)),
                      ('PPT_PCL_PROBLEM_OBSERVATION', (0, -1)))),
 'PPT_PCL_PROBLEM_OBSERVATION': ('sequence',
                                 (('OBX', (1, 1)), ('NTE', (0, -1)))),
 'PPT_PCL_PROBLEM_ROLE': ('sequence', (('ROL', (1, 1)), ('VAR', (0, -1)))),
 'PPV_PCA_CHOICE': ('choice', (('OBR', (1, 1)), ('RXO', (1, 1)))),
 'PPV_PCA_GOAL': ('sequence',
                  (('GOL', (1, 1)),
                   ('NTE', (0, -1)),
                   ('VAR', (0, -1)),
                   ('PPV_PCA_GOAL_ROLE', (0, -1)),
                   ('PPV_PCA_GOAL_PATHWAY', (0, -1)),
                   ('PPV_PCA_GOAL_OBSERVATION', (0, -1)),
                   ('PPV_PCA_PROBLEM', (0, -1)),
                   ('PPV_PCA_ORDER', (0, -1)))),
 'PPV_PCA_GOAL_OBSERVATION': ('sequence', (('OBX', (1, 1)), ('NTE', (0, -1)))),
 'PPV_PCA_GOAL_PATHWAY': ('sequence', (('PTH', (1, 1)), ('VAR', (0, -1)))),
 'PPV_PCA_GOAL_ROLE': ('sequence', (('ROL', (1, 1)), ('VAR', (0, -1)))),
 'PPV_PCA_ORDER': ('sequence',
                   (('ORC', (1, 1)), ('PPV_PCA_ORDER_DETAIL', (0, 1)))),
 'PPV_PCA_ORDER_DETAIL': ('sequence',
                          (('PPV_PCA_CHOICE', (1, 1)),
                           ('NTE', (0, -1)),
                           ('VAR', (0, -1)),
                           ('PPV_PCA_ORDER_OBSERVATION', (0, -1)))),
 'PPV_PCA_ORDER_OBSERVATION': ('sequence',
                               (('OBX', (1, 1)),
                                ('NTE', (0, -1)),
                                ('VAR', (0, -1)))),
 'PPV_PCA_PATIENT': ('sequence',
                     (('PID', (1, 1)),
                      ('PPV_PCA_PATIENT_VISIT', (0, 1)),
                      ('PPV_PCA_GOAL', (1, -1)))),
 'PPV_PCA_PATIENT_VISIT': ('sequence', (('PV1', (1, 1)), ('PV2', (0, 1)))),
 'PPV_PCA_PROBLEM': ('sequence',
                     (('PRB', (1, 1)),
                      ('NTE', (0, -1)),
                      ('VAR', (0, -1)),
                      ('PPV_PCA_PROBLEM_ROLE', (0, -1)),
                      ('PPV_PCA_PROBLEM_OBSERVATION', (0, -1)))),
 'PPV_PCA_PROBLEM_OBSERVATION': ('sequence',
                                 (('OBX', (1, 1)), ('NTE', (0, -1)))),
 'PPV_PCA_PROBLEM_ROLE': ('sequence', (('ROL', (1, 1)), ('VAR', (0, -1)))),
 'PRR_PC5_CHOICE': ('choice', (('OBR', (1, 1)), ('RXO', (1, 1)))),
 'PRR_PC5_GOAL': ('sequence',
                  (('GOL', (1, 1)),
                   ('NTE', (0, -1)),
                   ('VAR', (0, -1)),
                   ('PRR_PC5_GOAL_ROLE', (0, -1)),
                   ('PRR_PC5_GOAL_OBSERVATION', (0, -1)))),
 'PRR_PC5_GOAL_OBSERVATION': ('sequence', (('OBX', (1, 1)), ('NTE', (0, -1)))),
 'PRR_PC5_GOAL_ROLE': ('sequence', (('ROL', (1, 1)), ('VAR', (0, -1)))),
 'PRR_PC5_ORDER': ('sequence',
                   (('ORC', (1, 1)), ('PRR_PC5_ORDER_DETAIL', (0, 1)))),
 'PRR_PC5_ORDER_DETAIL': ('sequence',
                          (('PRR_PC5_CHOICE', (1, 1)),
                           ('NTE', (0, -1)),
                           ('VAR', (0, -1)),
                           ('PRR_PC5_ORDER_OBSERVATION', (0, -1)))),
 'PRR_PC5_ORDER_OBSERVATION': ('sequence',
                               (('OBX', (1, 1)),
                                ('NTE', (0, -1)),
                                ('VAR', (0, -1)))),
 'PRR_PC5_PATIENT': ('sequence',
                     (('PID', (1, 1)),
                      ('PRR_PC5_PATIENT_VISIT', (0, 1)),
                      ('PRR_PC5_PROBLEM', (1, -1)))),
 'PRR_PC5_PATIENT_VISIT': ('sequence', (('PV1', (1, 1)), ('PV2', (0, 1)))),
 'PRR_PC5_PROBLEM': ('sequence',
                     (('PRB', (1, 1)),
                      ('NTE', (0, -1)),
                      ('VAR', (0, -1)),
                      ('PRR_PC5_PROBLEM_ROLE', (0, -1)),
                      ('PRR_PC5_PROBLEM_PATHWAY', (0, -1)),
                      ('PRR_PC5_PROBLEM_OBSERVATION', (0, -1)),
                      ('PRR_PC5_GOAL', (0, -1)),
                      ('PRR_PC5_ORDER', (0, -1)))),
 'PRR_PC5_PROBLEM_OBSERVATION': ('sequence',
                                 (('OBX', (1, 1)), ('NTE', (0, -1)))),
 'PRR_PC5_PROBLEM_PATHWAY': ('sequence', (('PTH', (1, 1)), ('VAR', (0, -1)))),
 'PRR_PC5_PROBLEM_ROLE': ('sequence', (('ROL', (1, 1)), ('VAR', (0, -1)))),
 'PTR_PCF_CHOICE': ('choice', (('OBR', (1, 1)), ('RXO', (1, 1)))),
 'PTR_PCF_GOAL': ('sequence',
                  (('GOL', (1, 1)),
                   ('NTE', (0, -1)),
                   ('VAR', (0, -1)),
                   ('PTR_PCF_GOAL_ROLE', (0, -1)),
                   ('PTR_PCF_GOAL_OBSERVATION', (0, -1)))),
 'PTR_PCF_GOAL_OBSERVATION': ('sequence', (('OBX', (1, 1)), ('NTE', (0, -1)))),
 'PTR_PCF_GOAL_ROLE': ('sequence', (('ROL', (1, 1)), ('VAR', (0, -1)))),
 'PTR_PCF_ORDER': ('sequence',
                   (('ORC', (1, 1)), ('PTR_PCF_ORDER_DETAIL', (0, 1)))),
 'PTR_PCF_ORDER_DETAIL': ('sequence',
                          (('PTR_PCF_CHOICE', (1, 1)),
                           ('NTE', (0, -1)),
                           ('VAR', (0, -1)),
                           ('PTR_PCF_ORDER_OBSERVATION', (0, -1)))),
 'PTR_PCF_ORDER_OBSERVATION': ('sequence',
                               (('OBX', (1, 1)),
                                ('NTE', (0, -1)),
                                ('VAR', (0, -1)))),
 'PTR_PCF_PATHWAY': ('sequence',
                     (('PTH', (1, 1)),
                      ('NTE', (0, -1)),
                      ('VAR', (0, -1)),
                      ('PTR_PCF_PATHWAY_ROLE', (0, -1)),
                      ('PTR_PCF_PROBLEM', (0, -1)))),
 'PTR_PCF_PATHWAY_ROLE': ('sequence', (('ROL', (1, 1)), ('VAR', (0, -1)))),
 'PTR_PCF_PATIENT': ('sequence',
                     (('PID', (1, 1)),
                      ('PTR_PCF_PATIENT_VISIT', (0, 1)),
                      ('PTR_PCF_PATHWAY', (1, -1)))),
 'PTR_PCF_PATIENT_VISIT': ('sequence', (('PV1', (1, 1)), ('PV2', (0, 1)))),
 'PTR_PCF_PROBLEM': ('sequence',
                     (('PRB', (1, 1)),
                      ('NTE', (0, -1)),
                      ('VAR', (0, -1)),
                      ('PTR_PCF_PROBLEM_ROLE', (0, -1)),
                      ('PTR_PCF_PROBLEM_OBSERVATION', (0, -1)),
                      ('PTR_PCF_GOAL', (0, -1)),
                      ('PTR_PCF_ORDER', (0, -1)))),
 'PTR_PCF_PROBLEM_OBSERVATION': ('sequence',
                                 (('OBX', (1, 1)), ('NTE', (0, -1)))),
 'PTR_PCF_PROBLEM_ROLE': ('sequence', (('ROL', (1, 1)), ('VAR', (0, -1)))),
 'QBP_K13_ROW_DEFINITION': ('sequence', (('RDF', (1, 1)), ('RDT', (0, -1)))),
 'QBP_Q13_QBP': ('sequence', (('ANYZSEGMENT', (0, 1)),)),
 'QBP_QNN': ('sequence',
             (('MSH', (1, 1)),
              ('QPD', (1, 1)),
              ('RDF', (0, 1)),
              ('RCP', (1, 1)),
              ('DSC', (0, 1)))),
 'RAR_RAR_DEFINITION': ('sequence',
                        (('QRD', (1, 1)),
                         ('QRF', (0, 1)),
                         ('RAR_RAR_PATIENT', (0, 1)),
                         ('RAR_RAR_ORDER', (1, -1)))),
 'RAR_RAR_ENCODING': ('sequence',
                      (('RXE', (1, 1)), ('RXR', (1, -1)), ('RXC', (0, -1)))),
 'RAR_RAR_ORDER': ('sequence',
                   (('ORC', (1, 1)),
                    ('RAR_RAR_ENCODING', (0, 1)),
                    ('RXA', (1, -1)),
                    ('RXR', (1, 1)))),
 'RAR_RAR_PATIENT': ('sequence', (('PID', (1, 1)), ('NTE', (0, -1)))),
 'RAS_O17_COMPONENTS': ('sequence', (('RXC', (1, -1)), ('NTE', (0, -1)))),
 'RAS_O17_ENCODING': ('sequence',
                      (('RXE', (1, 1)), ('RXR', (1, -1)), ('RXC', (0, -1)))),
 'RAS_O17_OBSERVATION': ('sequence', (('OBX', (1, 1)), ('NTE', (0, -1)))),
 'RAS_O17_ORDER': ('sequence',
                   (('ORC', (1, 1)),
                    ('RAS_O17_ORDER_DETAIL', (0, 1)),
                    ('RAS_O17_ENCODING', (0, 1)),
                    ('RXA', (1, -1)),
                    ('RXR', (1, 1)),
                    ('RAS_O17_OBSERVATION', (0, -1)),
                    ('CTI', (0, -1)))),
 'RAS_O17_ORDER_DETAIL': ('sequence',
                          (('RXO', (1, 1)),
                           ('RAS_O17_ORDER_DETAIL_SUPPLEMENT', (0, 1)))),
 'RAS_O17_ORDER_DETAIL_SUPPLEMENT': ('sequence',
                                     (('NTE', (1, -1)),
                                      ('RXR', (1, -1)),
                                      ('RAS_O17_COMPONENTS', (0, 1)))),
 'RAS_O17_PATIENT': ('sequence',
                     (('PID', (1, 1)),
                      ('PD1', (0, 1)),
                      ('NTE', (0, -1)),
                      ('AL1', (0, -1)),
                      ('RAS_O17_PATIENT_VISIT', (0, 1)))),
 'RAS_O17_PATIENT_VISIT': ('sequence', (('PV1', (1, 1)), ('PV2', (0, 1)))),
 'RCI_I05_OBSERVATION': ('sequence',
                         (('OBR', (1, 1)),
                          ('NTE', (0, -1)),
                          ('RCI_I05_RESULTS', (0, -1)))),
 'RCI_I05_PROVIDER': ('sequence', (('PRD', (1, 1)), ('CTD', (0, -1)))),
 'RCI_I05_RESULTS': ('sequence', (('OBX', (1, 1)), ('NTE', (0, -1)))),
 'RCL_I06_PROVIDER': ('sequence', (('PRD', (1, 1)), ('CTD', (0, -1)))),
 'RDE_O11_COMPONENT': ('sequence', (('RXC', (1, -1)), ('NTE', (0, -1)))),
 'RDE_O11_INSURANCE': ('sequence',
                       (('IN1', (1, 1)), ('IN2', (0, 1)), ('IN3', (0, 1)))),
 'RDE_O11_OBSERVATION': ('sequence', (('OBX', (1, 1)), ('NTE', (0, -1)))),
 'RDE_O11_ORDER': ('sequence',
                   (('ORC', (1, 1)),
                    ('RDE_O11_ORDER_DETAIL', (0, 1)),
                    ('RXE', (1, 1)),
                    ('RXR', (1, -1)),
                    ('RXC', (0, -1)),
                    ('RDE_O11_OBSERVATION', (0, -1)),
                    ('CTI', (0, -1)))),
 'RDE_O11_ORDER_DETAIL': ('sequence',
                          (('RXO', (1, 1)),
                           ('NTE', (0, -1)),
                           ('RXR', (1, -1)),
                           ('RDE_O11_COMPONENT', (0, 1)))),
 'RDE_O11_PATIENT': ('sequence',
                     (('PID', (1, 1)),
                      ('PD1', (0, 1)),
                      ('NTE', (0, -1)),
                      ('RDE_O11_PATIENT_VISIT', (0, 1)),
                      ('RDE_O11_INSURANCE', (0, -1)),
                      ('GT1', (0, 1)),
                      ('AL1', (0, -1)))),
 'RDE_O11_PATIENT_VISIT': ('sequence', (('PV1', (1, 1)), ('PV2', (0, 1)))),
 'RDR_RDR_DEFINITION': ('sequence',
                        (('QRD', (1, 1)),
                         ('QRF', (0, 1)),
                         ('RDR_RDR_PATIENT', (0, 1)),
                         ('RDR_RDR_ORDER', (1, -1)))),
 'RDR_RDR_DISPENSE': ('sequence',
                      (('RXD', (1, 1)), ('RXR', (1, -1)), ('RXC', (0, -1)))),
 'RDR_RDR_ENCODING': ('sequence',
                      (('RXE', (1, 1)), ('RXR', (1, -1)), ('RXC', (0, -1)))),
 'RDR_RDR_ORDER': ('sequence',
                   (('ORC', (1, 1)),
                    ('RDR_RDR_ENCODING', (0, 1)),
                    ('RDR_RDR_DISPENSE', (1, -1)))),
 'RDR_RDR_PATIENT': ('sequence', (('PID', (1, 1)), ('NTE', (0, -1)))),
 'RDS_O13_COMPONENT': ('sequence', (('RXC', (1, -1)), ('NTE', (0, -1)))),
 'RDS_O13_ENCODING': ('sequence',
                      (('RXE', (1, 1)), ('RXR', (1, -1)), ('RXC', (0, -1)))),
 'RDS_O13_OBSERVATION': ('sequence', (('OBX', (1, 1)), ('NTE', (0, -1)))),
 'RDS_O13_ORDER': ('sequence',
                   (('ORC', (1, 1)),
                    ('RDS_O13_ORDER_DETAIL', (0, 1)),
                    ('RDS_O13_ENCODING', (0, 1)),
                    ('RXD', (1, 1)),
                    ('RXR', (1, -1)),
                    ('RXC', (0, -1)),
                    ('RDS_O13_OBSERVATION', (0, -1)),
                    ('FT1', (0, -1)))),
 'RDS_O13_ORDER_DETAIL': ('sequence',
                          (('RXO', (1, 1)),
                           ('RDS_O13_ORDER_DETAIL_SUPPLEMENT', (0, 1)))),
 'RDS_O13_ORDER_DETAIL_SUPPLEMENT': ('sequence',
                                     (('NTE', (1, -1)),
                                      ('RXR', (1, -1)),
                                      ('RDS_O13_COMPONENT', (0, 1)))),
 'RDS_O13_PATIENT': ('sequence',
                     (('PID', (1, 1)),
                      ('PD1', (0, 1)),
                      ('NTE', (0, -1)),
                      ('AL1', (0, -1)),
                      ('RDS_O13_PATIENT_VISIT', (0, 1)))),
 'RDS_O13_PATIENT_VISIT': ('sequence', (('PV1', (1, 1)), ('PV2', (0, 1)))),
 'REF_I12_AUTCTD_SUPPGRP2': ('sequence', (('AUT', (1, 1)), ('CTD', (0, 1)))),
 'REF_I12_AUTHORIZATION_CONTACT': ('sequence',
                                   (('AUT', (1, 1)), ('CTD', (0, 1)))),
 'REF_I12_INSURANCE': ('sequence',
                       (('IN1', (1, 1)), ('IN2', (0, 1)), ('IN3', (0, 1)))),
 'REF_I12_OBSERVATION': ('sequence',
                         (('OBR', (1, 1)),
                          ('NTE', (0, -1)),
                          ('REF_I12_RESULTS_NOTES', (0, -1)))),
 'REF_I12_PATIENT_VISIT': ('sequence', (('PV1', (1, 1)), ('PV2', (0, 1)))),
 'REF_I12_PROCEDURE': ('sequence',
                       (('PR1', (1, 1)), ('REF_I12_AUTCTD_SUPPGRP2', (0, 1)))),
 'REF_I12_PROVIDER_CONTACT': ('sequence', (('PRD', (1, 1)), ('CTD', (0, -1)))),
 'REF_I12_RESULTS_NOTES': ('sequence', (('OBX', (1, 1)), ('NTE', (0, -1)))),
 'RER_RER_DEFINITION': ('sequence',
                        (('QRD', (1, 1)),
                         ('QRF', (0, 1)),
                         ('RER_RER_PATIENT', (0, 1)),
                         ('RER_RER_ORDER', (1, -1)))),
 'RER_RER_ORDER': ('sequence',
                   (('ORC', (1, 1)),
                    ('RXE', (1, 1)),
                    ('RXR', (1, -1)),
                    ('RXC', (0, -1)))),
 'RER_RER_PATIENT': ('sequence', (('PID', (1, 1)), ('NTE', (0, -1)))),
 'RGR_RGR_DEFINTION': ('sequence',
                       (('QRD', (1, 1)),
                        ('QRF', (0, 1)),
                        ('RGR_RGR_PATIENT', (0, 1)),
                        ('RGR_RGR_ORDER', (1, -1)))),
 'RGR_RGR_ENCODING': ('sequence',
                      (('RXE', (1, 1)), ('RXR', (1, -1)), ('RXC', (0, -1)))),
 'RGR_RGR_ORDER': ('sequence',
                   (('ORC', (1, 1)),
                    ('RGR_RGR_ENCODING', (0, 1)),
                    ('RXG', (1, -1)),
                    ('RXR', (1, -1)),
                    ('RXC', (0, -1)))),
 'RGR_RGR_PATIENT': ('sequence', (('PID', (1, 1)), ('NTE', (0, -1)))),
 'RGV_O15_COMPONENTS': ('sequence', (('RXC', (1, -1)), ('NTE', (0, -1)))),
 'RGV_O15_ENCODING': ('sequence',
                      (('RXE', (1, 1)), ('RXR', (1, -1)), ('RXC', (0, -1)))),
 'RGV_O15_GIVE': ('sequence',
                  (('RXG', (1, 1)),
                   ('RXR', (1, -1)),
                   ('RXC', (0, -1)),
                   ('RGV_O15_OBSERVATION', (1, -1)))),
 'RGV_O15_OBSERVATION': ('sequence', (('OBX', (0, 1)), ('NTE', (0, -1)))),
 'RGV_O15_ORDER': ('sequence',
                   (('ORC', (1, 1)),
                    ('RGV_O15_ORDER_DETAIL', (0, 1)),
                    ('RGV_O15_ENCODING', (0, 1)),
                    ('RGV_O15_GIVE', (1, -1)))),
 'RGV_O15_ORDER_DETAIL': ('sequence',
                          (('RXO', (1, 1)),
                           ('RGV_O15_ORDER_DETAIL_SUPPLEMENT', (0, 1)))),
 'RGV_O15_ORDER_DETAIL_SUPPLEMENT': ('sequence',
                                     (('NTE', (1, -1)),
                                      ('RXR', (1, -1)),
                                      ('RGV_O15_COMPONENTS', (0, 1)))),
 'RGV_O15_PATIENT': ('sequence',
                     (('PID', (1, 1)),
                      ('NTE', (0, -1)),
                      ('AL1', (0, -1)),
                      ('RGV_O15_PATIENT_VISIT', (0, 1)))),
 'RGV_O15_PATIENT_VISIT': ('sequence', (('PV1', (1, 1)), ('PV2', (0, 1)))),
 'ROR_ROR_DEFINITION': ('sequence',
                        (('QRD', (1, 1)),
                         ('QRF', (0, 1)),
                         ('ROR_ROR_PATIENT', (0, 1)),
                         ('ROR_ROR_ORDER', (1, -1)))),
 'ROR_ROR_ORDER': ('sequence',
                   (('ORC', (1, 1)),
                    ('RXO', (1, 1)),
                    ('RXR', (1, -1)),
                    ('RXC', (0, -1)))),
 'ROR_ROR_PATIENT': ('sequence', (('PID', (1, 1)), ('NTE', (0, -1)))),
 'RPA_I08_AUTCTD_SUPPGRP2': ('sequence', (('AUT', (1, 1)), ('CTD', (0, 1)))),
 'RPA_I08_AUTHORIZATION': ('sequence', (('AUT', (1, 1)), ('CTD', (0, 1)))),
 'RPA_I08_INSURANCE': ('sequence',
                       (('IN1', (1, 1)), ('IN2', (0, 1)), ('IN3', (0, 1)))),
 'RPA_I08_OBSERVATION': ('sequence',
                         (('OBR', (1, 1)),
                          ('NTE', (0, -1)),
                          ('RPA_I08_RESULTS', (0, -1)))),
 'RPA_I08_PROCEDURE': ('sequence',
                       (('PR1', (1, 1)), ('RPA_I08_AUTCTD_SUPPGRP2', (0, 1)))),
 'RPA_I08_PROVIDER': ('sequence', (('PRD', (1, 1)), ('CTD', (0, -1)))),
 'RPA_I08_RESULTS': ('sequence', (('OBX', (1, 1)), ('NTE', (0, -1)))),
 'RPA_I08_VISIT': ('sequence', (('PV1', (1, 1)), ('PV2', (0, 1)))),
 'RPI_I01_GUARANTOR_INSURANCE': ('sequence',
                                 (('GT1', (0, -1)),
                                  ('RPI_I01_INSURANCE', (1, -1)))),
 'RPI_I01_INSURANCE': ('sequence',
                       (('IN1', (1, 1)), ('IN2', (0, 1)), ('IN3', (0, 1)))),
 'RPI_I01_PROVIDER': ('sequence', (('PRD', (1, 1)), ('CTD', (0, -1)))),
 'RPI_I04_GUARANTOR_INSURANCE': ('sequence',
                                 (('GT1', (0, -1)),
                                  ('RPI_I04_INSURANCE', (1, -1)))),
 'RPI_I04_INSURANCE': ('sequence',
                       (('IN1', (1, 1)), ('IN2', (0, 1)), ('IN3', (0, 1)))),
 'RPI_I04_PROVIDER': ('sequence', (('PRD', (1, 1)), ('CTD', (0, -1)))),
 'RPL_I02_PROVIDER': ('sequence', (('PRD', (1, 1)), ('CTD', (0, -1)))),
 'RPR_I03_PROVIDER': ('sequence', (('PRD', (1, 1)), ('CTD', (0, -1)))),
 'RQA_I08_AUTCTD_SUPPGRP2': ('sequence', (('AUT', (1, 1)), ('CTD', (0, 1)))),
 'RQA_I08_AUTHORIZATION': ('sequence', (('AUT', (1, 1)), ('CTD', (0, 1)))),
 'RQA_I08_GUARANTOR_INSURANCE': ('sequence',
                                 (('GT1', (0, -1)),
                                  ('RQA_I08_INSURANCE', (1, -1)))),
 'RQA_I08_INSURANCE': ('sequence',
                       (('IN1', (1, 1)), ('IN2', (0, 1)), ('IN3', (0, 1)))),
 'RQA_I08_OBSERVATION': ('sequence',
                         (('OBR', (1, 1)),
                          ('NTE', (0, -1)),
                          ('RQA_I08_RESULTS', (0, -1)))),
 'RQA_I08_PROCEDURE': ('sequence',
                       (('PR1', (1, 1)), ('RQA_I08_AUTCTD_SUPPGRP2', (0, 1)))),
 'RQA_I08_PROVIDER': ('sequence', (('PRD', (1, 1)), ('CTD', (0, -1)))),
 'RQA_I08_RESULTS': ('sequence', (('OBX', (1, 1)), ('NTE', (0, -1)))),
 'RQA_I08_VISIT': ('sequence', (('PV1', (1, 1)), ('PV2', (0, 1)))),
 'RQC_I05_PROVIDER': ('sequence', (('PRD', (1, 1)), ('CTD', (0, -1)))),
 'RQI_I01_GUARANTOR_INSURANCE': ('sequence',
                                 (('GT1', (0, -1)),
                                  ('RQI_I01_INSURANCE', (1, -1)))),
 'RQI_I01_INSURANCE': ('sequence',
                       (('IN1', (1, 1)), ('IN2', (0, 1)), ('IN3', (0, 1)))),
 'RQI_I01_PROVIDER': ('sequence', (('PRD', (1, 1)), ('CTD', (0, -1)))),
 'RQP_I04_PROVIDER': ('sequence', (('PRD', (1, 1)), ('CTD', (0, -1)))),
 'RRA_O18_ADMINISTRATION': ('sequence', (('RXA', (1, -1)), ('RXR', (1, 1)))),
 'RRA_O18_ORDER': ('sequence',
                   (('ORC', (1, 1)), ('RRA_O18_ADMINISTRATION', (0, 1)))),
 'RRA_O18_PATIENT': ('sequence', (('PID', (1, 1)), ('NTE', (0, -1)))),
 'RRA_O18_RESPONSE': ('sequence',
                      (('RRA_O18_PATIENT', (0, 1)),
                       ('RRA_O18_ORDER', (1, -1)))),
 'RRD_O14_DISPENSE': ('sequence',
                      (('RXD', (1, 1)), ('RXR', (1, -1)), ('RXC', (0, -1)))),
 'RRD_O14_ORDER': ('sequence',
                   (('ORC', (1, 1)), ('RRD_O14_DISPENSE', (0, 1)))),
 'RRD_O14_PATIENT': ('sequence', (('PID', (1, 1)), ('NTE', (0, -1)))),
 'RRD_O14_RESPONSE': ('sequence',
                      (('RRD_O14_PATIENT', (0, 1)),
                       ('RRD_O14_ORDER', (1, -1)))),
 'RRE_O12_ENCODING': ('sequence',
                      (('RXE', (1, 1)), ('RXR', (1, -1)), ('RXC', (0, -1)))),
 'RRE_O12_ORDER': ('sequence',
                   (('ORC', (1, 1)), ('RRE_O12_ENCODING', (0, 1)))),
 'RRE_O12_PATIENT': ('sequence', (('PID', (1, 1)), ('NTE', (0, -1)))),
 'RRE_O12_RESPONSE': ('sequence',
                      (('RRE_O12_PATIENT', (0, 1)),
                       ('RRE_O12_ORDER', (1, -1)))),
 'RRG_O16_GIVE': ('sequence',
                  (('RXG', (1, 1)), ('RXR', (1, -1)), ('RXC', (0, -1)))),
 'RRG_O16_ORDER': ('sequence', (('ORC', (1, 1)), ('RRG_O16_GIVE', (0, 1)))),
 'RRG_O16_PATIENT': ('sequence', (('PID', (1, 1)), ('NTE', (0, -1)))),
 'RRG_O16_RESPONSE': ('sequence',
                      (('RRG_O16_PATIENT', (0, 1)),
                       ('RRG_O16_ORDER', (1, -1)))),
 'RRI_I12_AUTCTD_SUPPGRP2': ('sequence', (('AUT', (1, 1)), ('CTD', (0, 1)))),
 'RRI_I12_AUTHORIZATION_CONTACT': ('sequence',
                                   (('AUT', (1, 1)), ('CTD', (0, 1)))),
 'RRI_I12_OBSERVATION': ('sequence',
                         (('OBR', (1, 1)),
                          ('NTE', (0, -1)),
                          ('RRI_I12_RESULTS_NOTES', (0, -1)))),
 'RRI_I12_PATIENT_VISIT': ('sequence', (('PV1', (1, 1)), ('PV2', (0, 1)))),
 'RRI_I12_PROCEDURE': ('sequence',
                       (('PR1', (1, 1)), ('RRI_I12_AUTCTD_SUPPGRP2', (0, 1)))),
 'RRI_I12_PROVIDER_CONTACT': ('sequence', (('PRD', (1, 1)), ('CTD', (0, -1)))),
 'RRI_I12_RESULTS_NOTES': ('sequence', (('OBX', (1, 1)), ('NTE', (0, -1)))),
 'RSP_K13_ROW_DEFINITION': ('sequence', (('RDF', (1, 1)), ('RDT', (0, -1)))),
 'RSP_K21_QUERY_RESPONSE': ('sequence', (('PID', (1, 1)), ('PD1', (0, 1)))),
 'RSP_K22_QUERY_RESPONSE': ('sequence',
                            (('PID', (1, 1)),
                             ('PD1', (0, 1)),
                             ('QRI', (0, 1)))),
 'RSP_K25_STAFF': ('sequence',
                   (('STF', (1, 1)),
                    ('PRA', (0, 1)),
                    ('ORG', (0, -1)),
                    ('AFF', (0, -1)),
                    ('LAN', (0, -1)),
                    ('EDU', (0, -1)))),
 'RSP_Z82_COMMON_ORDER': ('sequence',
                          (('ORC', (1, 1)),
                           ('RSP_Z82_ORDER_DETAIL', (0, 1)),
                           ('RSP_Z82_ENCODED_ORDER', (0, 1)),
                           ('RXD', (1, 1)),
                           ('RXR', (1, -1)),
                           ('RXC', (0, -1)),
                           ('RSP_Z82_OBSERVATION', (1, -1)))),
 'RSP_Z82_ENCODED_ORDER': ('sequence',
                           (('RXE', (1, 1)),
                            ('RXR', (1, -1)),
                            ('RXC', (0, -1)))),
 'RSP_Z82_OBSERVATION': ('sequence', (('OBX', (0, 1)), ('NTE', (0, -1)))),
 'RSP_Z82_ORDER_DETAIL': ('sequence',
                          (('RXO', (1, 1)),
                           ('NTE', (0, -1)),
                           ('RXR', (1, -1)),
                           ('RSP_Z82_TREATMENT', (0, 1)))),
 'RSP_Z82_PATIENT': ('sequence',
                     (('PID', (1, 1)),
                      ('PD1', (0, 1)),
                      ('NTE', (0, -1)),
                      ('RSP_Z82_VISIT', (0, 1)),
                      ('RSP_Z82_COMMON_ORDER', (1, -1)))),
 'RSP_Z82_PATIENT_VISIT': ('sequence', (('PV1', (1, 1)), ('PV2', (0, 1)))),
 'RSP_Z82_QUERY_RESPONSE': ('sequence', (('RSP_Z82_PATIENT', (0, 1)),)),
 'RSP_Z82_TREATMENT': ('sequence', (('RXC', (1, -1)), ('NTE', (0, -1)))),
 'RSP_Z82_VISIT': ('sequence',
                   (('AL1', (1, -1)), ('RSP_Z82_PATIENT_VISIT', (0, 1)))),
 'RSP_Z86_ADMINISTRATION': ('sequence',
                            (('RXA', (1, 1)),
                             ('RXR', (1, -1)),
                             ('RXC', (0, -1)))),
 'RSP_Z86_COMMON_ORDER': ('sequence',
                          (('ORC', (1, 1)),
                           ('RSP_Z86_ORDER_DETAIL', (0, 1)),
                           ('RSP_Z86_ENCODED_ORDER', (0, 1)),
                           ('RSP_Z86_DISPENSE', (0, 1)),
                           ('RSP_Z86_GIVE', (0, 1)),
                           ('RSP_Z86_ADMINISTRATION', (0, 1)),
                           ('RSP_Z86_OBSERVATION', (1, -1)))),
 'RSP_Z86_DISPENSE': ('sequence',
                      (('RXD', (1, 1)), ('RXR', (1, -1)), ('RXC', (0, -1)))),
 'RSP_Z86_ENCODED_ORDER': ('sequence',
                           (('RXE', (1, 1)),
                            ('RXR', (1, -1)),
                            ('RXC', (0, -1)))),
 'RSP_Z86_GIVE': ('sequence',
                  (('RXG', (1, 1)), ('RXR', (1, -1)), ('RXC', (0, -1)))),
 'RSP_Z86_OBSERVATION': ('sequence', (('OBX', (0, 1)), ('NTE', (0, -1)))),
 'RSP_Z86_ORDER_DETAIL': ('sequence',
                          (('RXO', (1, 1)),
                           ('RXR', (1, -1)),
                           ('RXC', (0, -1)))),
 'RSP_Z86_PATIENT': ('sequence',
                     (('PID', (1, 1)),
                      ('PD1', (0, 1)),
                      ('NTE', (0, -1)),
                      ('AL1', (0, -1)),
                      ('RSP_Z86_COMMON_ORDER', (1, -1)))),
 'RSP_Z86_QUERY_RESPONSE': ('sequence', (('RSP_Z86_PATIENT', (0, 1)),)),
 'RSP_Z88_ALLERGY': ('sequence',
                     (('AL1', (1, -1)), ('RSP_Z88_VISIT', (0, 1)))),
 'RSP_Z88_COMMON_ORDER': ('sequence',
                          (('ORC', (1, 1)),
                           ('RSP_Z88_ORDER_DETAIL', (0, 1)),
                           ('RSP_Z88_ORDER_ENCODED', (0, 1)),
                           ('RXD', (1, 1)),
                           ('RXR', (1, -1)),
                           ('RXC', (0, -1)),
                           ('RSP_Z88_OBSERVATION', (1, -1)))),
 'RSP_Z88_COMPONENT': ('sequence', (('RXC', (1, -1)), ('NTE', (0, -1)))),
 'RSP_Z88_OBSERVATION': ('sequence', (('OBX', (0, 1)), ('NTE', (0, -1)))),
 'RSP_Z88_ORDER_DETAIL': ('sequence',
                          (('RXO', (1, 1)),
                           ('NTE', (0, -1)),
                           ('RXR', (1, -1)),
                           ('RSP_Z88_COMPONENT', (0, 1)))),
 'RSP_Z88_ORDER_ENCODED': ('sequence',
                           (('RXE', (1, 1)),
                            ('RXR', (1, -1)),
                            ('RXC', (0, -1)))),
 'RSP_Z88_PATIENT': ('sequence',
                     (('PID', (1, 1)),
                      ('PD1', (0, 1)),
                      ('NTE', (0, -1)),
                      ('RSP_Z88_ALLERGY', (0, 1)),
                      ('RSP_Z88_COMMON_ORDER', (1, -1)))),
 'RSP_Z88_QUERY_RESPONSE': ('sequence', (('RSP_Z88_PATIENT', (0, 1)),)),
 'RSP_Z88_VISIT': ('sequence', (('PV1', (1, 1)), ('PV2', (0, 1)))),
 'RSP_Z90_COMMON_ORDER': ('sequence',
                          (('ORC', (1, 1)),
                           ('OBR', (1, 1)),
                           ('NTE', (0, -1)),
                           ('CTD', (0, 1)),
                           ('RSP_Z90_OBSERVATION', (1, -1)))),
 'RSP_Z90_OBSERVATION': ('sequence', (('OBX', (0, 1)), ('NTE', (0, -1)))),
 'RSP_Z90_PATIENT': ('sequence',
                     (('PID', (1, 1)),
                      ('PD1', (0, 1)),
                      ('NK1', (0, -1)),
                      ('NTE', (0, -1)),
                      ('RSP_Z90_VISIT', (0, 1)))),
 'RSP_Z90_QUERY_RESPONSE': ('sequence',
                            (('RSP_Z90_PATIENT', (0, 1)),
                             ('RSP_Z90_COMMON_ORDER', (1, -1)))),
 'RSP_Z90_VISIT': ('sequence', (('PV1', (1, 1)), ('PV2', (0, 1)))),
 'RTB_K13_ROW_DEFINITION': ('sequence', (('RDF', (1, 1)), ('RDT', (0, -1)))),
 'RTB_KNN': ('sequence',
             (('MSH', (1, 1)),
              ('MSA', (1, 1)),
              ('ERR', (0, 1)),
              ('QAK', (1, 1)),
              ('QPD', (1, 1)),
              ('DSC', (0, 1)))),
 'RTB_Q13_ROW_DEFINITION': ('sequence', (('RDF', (1, 1)), ('RDT', (0, -1)))),
 'RTB_Z74_ROW_DEFINITION': ('sequence', (('RDF', (1, 1)), ('RDT', (0, -1)))),
 'SIU_S12_GENERAL_RESOURCE': ('sequence', (('AIG', (1, 1)), ('NTE', (0, -1)))),
 'SIU_S12_LOCATION_RESOURCE': ('sequence',
                               (('AIL', (1, 1)), ('NTE', (0, -1)))),
 'SIU_S12_PATIENT': ('sequence',
                     (('PID', (1, 1)),
                      ('PD1', (0, 1)),
                      ('PV1', (0, 1)),
                      ('PV2', (0, 1)),
                      ('OBX', (0, -1)),
                      ('DG1', (0, -1)))),
 'SIU_S12_PERSONNEL_RESOURCE': ('sequence',
                                (('AIP', (1, 1)), ('NTE', (0, -1)))),
 'SIU_S12_RESOURCES': ('sequence',
                       (('RGS', (1, 1)),
                        ('SIU_S12_SERVICE', (0, -1)),
                        ('SIU_S12_GENERAL_RESOURCE', (0, -1)),
                        ('SIU_S12_LOCATION_RESOURCE', (0, -1)),
                        ('SIU_S12_PERSONNEL_RESOURCE', (0, -1)))),
 'SIU_S12_SERVICE': ('sequence', (('AIS', (1, 1)), ('NTE', (0, -1)))),
 'SQM_S25_GENERAL_RESOURCE': ('sequence', (('AIG', (1, 1)), ('APR', (0, 1)))),
 'SQM_S25_LOCATION_RESOURCE': ('sequence', (('AIL', (1, 1)), ('APR', (0, 1)))),
 'SQM_S25_PERSONNEL_RESOURCE': ('sequence',
                                (('AIP', (1, 1)), ('APR', (0, 1)))),
 'SQM_S25_REQUEST': ('sequence',
                     (('ARQ', (1, 1)),
                      ('APR', (0, 1)),
                      ('PID', (0, 1)),
                      ('SQM_S25_RESOURCES', (1, -1)))),
 'SQM_S25_RESOURCES': ('sequence',
                       (('RGS', (1, 1)),
                        ('SQM_S25_SERVICE', (0, -1)),
                        ('SQM_S25_GENERAL_RESOURCE', (0, -1)),
                        ('SQM_S25_PERSONNEL_RESOURCE', (0, -1)),
                        ('SQM_S25_LOCATION_RESOURCE', (0, -1)))),
 'SQM_S25_SERVICE': ('sequence', (('AIS', (1, 1)), ('APR', (0, 1)))),
 'SQR_S25_GENERAL_RESOURCE': ('sequence', (('AIG', (1, 1)), ('NTE', (0, -1)))),
 'SQR_S25_LOCATION_RESOURCE': ('sequence',
                               (('AIL', (1, 1)), ('NTE', (0, -1)))),
 'SQR_S25_PATIENT': ('sequence',
                     (('PID', (1, 1)),
                      ('PV1', (0, 1)),
                      ('PV2', (0, 1)),
                      ('DG1', (0, 1)))),
 'SQR_S25_PERSONNEL_RESOURCE': ('sequence',
                                (('AIP', (1, 1)), ('NTE', (0, -1)))),
 'SQR_S25_RESOURCES': ('sequence',
                       (('RGS', (1, 1)),
                        ('SQR_S25_SERVICE', (0, -1)),
                        ('SQR_S25_GENERAL_RESOURCE', (0, -1)),
                        ('SQR_S25_PERSONNEL_RESOURCE', (0, -1)),
                        ('SQR_S25_LOCATION_RESOURCE', (0, -1)))),
 'SQR_S25_SCHEDULE': ('sequence',
                      (('SCH', (1, 1)),
                       ('NTE', (0, -1)),
                       ('SQR_S25_PATIENT', (0, 1)),
                       ('SQR_S25_RESOURCES', (1, -1)))),
 'SQR_S25_SERVICE': ('sequence', (('AIS', (1, 1)), ('NTE', (0, -1)))),
 'SRM_S01_GENERAL_RESOURCE': ('sequence',
                              (('AIG', (1, 1)),
                               ('APR', (0, 1)),
                               ('NTE', (0, -1)))),
 'SRM_S01_LOCATION_RESOURCE': ('sequence',
                               (('AIL', (1, 1)),
                                ('APR', (0, 1)),
                                ('NTE', (0, -1)))),
 'SRM_S01_PATIENT': ('sequence',
                     (('PID', (1, 1)),
                      ('PV1', (0, 1)),
                      ('PV2', (0, 1)),
                      ('OBX', (0, -1)),
                      ('DG1', (0, -1)))),
 'SRM_S01_PERSONNEL_RESOURCE': ('sequence',
                                (('AIP', (1, 1)),
                                 ('APR', (0, 1)),
                                 ('NTE', (0, -1)))),
 'SRM_S01_RESOURCES': ('sequence',
                       (('RGS', (1, 1)),
                        ('SRM_S01_SERVICE', (0, -1)),
                        ('SRM_S01_GENERAL_RESOURCE', (0, -1)),
                        ('SRM_S01_LOCATION_RESOURCE', (0, -1)),
                        ('SRM_S01_PERSONNEL_RESOURCE', (0, -1)))),
 'SRM_S01_SERVICE': ('sequence',
                     (('AIS', (1, 1)), ('APR', (0, 1)), ('NTE', (0, -1)))),
 'SRR_S01_GENERAL_RESOURCE': ('sequence', (('AIG', (1, 1)), ('NTE', (0, -1)))),
 'SRR_S01_LOCATION_RESOURCE': ('sequence',
                               (('AIL', (1, 1)), ('NTE', (0, -1)))),
 'SRR_S01_PATIENT': ('sequence',
                     (('PID', (1, 1)),
                      ('PV1', (0, 1)),
                      ('PV2', (0, 1)),
                      ('DG1', (0, -1)))),
 'SRR_S01_PERSONNEL_RESOURCE': ('sequence',
                                (('AIP', (1, 1)), ('NTE', (0, -1)))),
 'SRR_S01_RESOURCES': ('sequence',
                       (('RGS', (1, 1)),
                        ('SRR_S01_SERVICE', (0, -1)),
                        ('SRR_S01_GENERAL_RESOURCE', (0, -1)),
                        ('SRR_S01_LOCATION_RESOURCE', (0, -1)),
                        ('SRR_S01_PERSONNEL_RESOURCE', (0, -1)))),
 'SRR_S01_SCHEDULE': ('sequence',
                      (('SCH', (1, 1)),
                       ('NTE', (0, -1)),
                       ('SRR_S01_PATIENT', (0, -1)),
                       ('SRR_S01_RESOURCES', (1, -1)))),
 'SRR_S01_SERVICE': ('sequence', (('AIS', (1, 1)), ('NTE', (0, -1)))),
 'SSU_U03_SPECIMEN_CONTAINER': ('sequence',
                                (('SAC', (1, 1)), ('OBX', (0, 1)))),
 'SUR_P09_FACILITY': ('sequence',
                      (('FAC', (1, 1)),
                       ('SUR_P09_PRODUCT', (1, -1)),
                       ('PSH', (1, 1)),
                       ('SUR_P09_FACILITY_DETAIL', (1, -1)))),
 'SUR_P09_FACILITY_DETAIL': ('sequence',
                             (('FAC', (1, 1)),
                              ('PDC', (1, 1)),
                              ('NTE', (1, 1)))),
 'SUR_P09_PRODUCT': ('sequence', (('PSH', (1, 1)), ('PDC', (1, 1)))),
 'VXR_V03_INSURANCE': ('sequence',
                       (('IN1', (1, 1)), ('IN2', (0, 1)), ('IN3', (0, 1)))),
 'VXR_V03_OBSERVATION': ('sequence', (('OBX', (1, 1)), ('NTE', (0, -1)))),
 'VXR_V03_ORDER': ('sequence',
                   (('ORC', (0, 1)),
                    ('RXA', (1, 1)),
                    ('RXR', (0, 1)),
                    ('VXR_V03_OBSERVATION', (0, -1)))),
 'VXR_V03_PATIENT_VISIT': ('sequence', (('PV1', (1, 1)), ('PV2', (0, 1)))),
 'VXU_V04_INSURANCE': ('sequence',
                       (('IN1', (1, 1)), ('IN2', (0, 1)), ('IN3', (0, 1)))),
 'VXU_V04_OBSERVATION': ('sequence', (('OBX', (1, 1)), ('NTE', (0, -1)))),
 'VXU_V04_ORDER': ('sequence',
                   (('ORC', (0, 1)),
                    ('RXA', (1, 1)),
                    ('RXR', (0, 1)),
                    ('VXU_V04_OBSERVATION', (0, -1)))),
 'VXU_V04_PATIENT': ('sequence', (('PV1', (1, 1)), ('PV2', (0, 1)))),
 'VXX_V02_PATIENT': ('sequence', (('PID', (1, 1)), ('NK1', (0, -1))))}
