# -*- coding: utf-8 -*-
#
# Copyright (c) 2012-2013, CRS4
#
# Permission is hereby granted, free of charge, to any person obtaining a copy of
# this software and associated documentation files (the "Software"), to deal in
# the Software without restriction, including without limitation the rights to
# use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
# the Software, and to permit persons to whom the Software is furnished to do so,
# subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
# FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
# COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
# IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
# CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

MESSAGES = {'ACK': ('sequence', (('MSH', (1, 1)), ('MSA', (1, 1)), ('ERR', (0, 1)))),
 'ACK_N02': ('sequence', (('MSH', (1, 1)), ('MSA', (1, 1)))),
 'ADR_A19': ('sequence',
             (('MSH', (1, 1)),
              ('MSA', (1, 1)),
              ('ERR', (0, 1)),
              ('QAK', (0, 1)),
              ('QRD', (1, 1)),
              ('QRF', (0, 1)),
              ('ADR_A19_QUERY_RESPONSE', (1, -1)),
              ('DSC', (0, 1)))),
 'ADT_A01': ('sequence',
             (('MSH', (1, 1)),
              ('EVN', (1, 1)),
              ('PID', (1, 1)),
              ('PD1', (0, 1)),
              ('ROL', (0, -1)),
              ('NK1', (0, -1)),
              ('PV1', (1, 1)),
              ('PV2', (0, 1)),
              ('ROL', (0, -1)),
              ('DB1', (0, -1)),
              ('OBX', (0, -1)),
              ('AL1', (0, -1)),
              ('DG1', (0, -1)),
              ('DRG', (0, 1)),
              ('ADT_A01_PROCEDURE', (0, -1)),
              ('GT1', (0, -1)),
              ('ADT_A01_INSURANCE', (0, -1)),
              ('ACC', (0, 1)),
              ('UB1', (0, 1)),
              ('UB2', (0, 1)),
              ('PDA', (0, 1)))),
 'ADT_A02': ('sequence',
             (('MSH', (1, 1)),
              ('EVN', (1, 1)),
              ('PID', (1, 1)),
              ('PD1', (0, 1)),
              ('ROL', (0, -1)),
              ('PV1', (1, 1)),
              ('PV2', (0, 1)),
              ('ROL', (0, -1)),
              ('DB1', (0, -1)),
              ('OBX', (0, -1)),
              ('PDA', (0, 1)))),
 'ADT_A03': ('sequence',
             (('MSH', (1, 1)),
              ('EVN', (1, 1)),
              ('PID', (1, 1)),
              ('PD1', (0, 1)),
              ('ROL', (0, -1)),
              ('PV1', (1, 1)),
              ('PV2', (0, 1)),
              ('ROL', (0, -1)),
              ('DB1', (0, -1)),
              ('DG1', (0, -1)),
              ('DRG', (0, 1)),
              ('ADT_A03_PROCEDURE', (0, -1)),
              ('OBX', (0, -1)),
              ('PDA', (0, 1)))),
 'ADT_A05': ('sequence',
             (('MSH', (1, 1)),
              ('EVN', (1, 1)),
              ('PID', (1, 1)),
              ('PD1', (0, 1)),
              ('ROL', (0, -1)),
              ('NK1', (0, -1)),
              ('PV1', (1, 1)),
              ('PV2', (0, 1)),
              ('ROL', (0, -1)),
              ('DB1', (0, -1)),
              ('OBX', (0, -1)),
              ('AL1', (0, -1)),
              ('DG1', (0, -1)),
              ('DRG', (0, 1)),
              ('ADT_A05_PROCEDURE', (0, -1)),
              ('GT1', (0, -1)),
              ('ADT_A05_INSURANCE', (0, -1)),
              ('ACC', (0, 1)),
              ('UB1', (0, 1)),
              ('UB2', (0, 1)))),
 'ADT_A06': ('sequence',
             (('MSH', (1, 1)),
              ('EVN', (1, 1)),
              ('PID', (1, 1)),
              ('PD1', (0, 1)),
              ('ROL', (0, -1)),
              ('MRG', (0, 1)),
              ('NK1', (0, -1)),
              ('PV1', (1, 1)),
              ('PV2', (0, 1)),
              ('ROL', (0, -1)),
              ('DB1', (0, -1)),
              ('OBX', (0, -1)),
              ('AL1', (0, -1)),
              ('DG1', (0, -1)),
              ('DRG', (0, 1)),
              ('ADT_A06_PROCEDURE', (0, -1)),
              ('GT1', (0, -1)),
              ('ADT_A06_INSURANCE', (0, -1)),
              ('ACC', (0, 1)),
              ('UB1', (0, 1)),
              ('UB2', (0, 1)))),
 'ADT_A09': ('sequence',
             (('MSH', (1, 1)),
              ('EVN', (1, 1)),
              ('PID', (1, 1)),
              ('PD1', (0, 1)),
              ('PV1', (1, 1)),
              ('PV2', (0, 1)),
              ('DB1', (0, -1)),
              ('OBX', (0, -1)),
              ('DG1', (0, -1)))),
 'ADT_A15': ('sequence',
             (('MSH', (1, 1)),
              ('EVN', (1, 1)),
              ('PID', (1, 1)),
              ('PD1', (0, 1)),
              ('ROL', (0, -1)),
              ('PV1', (1, 1)),
              ('PV2', (0, 1)),
              ('ROL', (0, -1)),
              ('DB1', (0, -1)),
              ('OBX', (0, -1)),
              ('DG1', (0, -1)))),
 'ADT_A16': ('sequence',
             (('MSH', (1, 1)),
              ('EVN', (1, 1)),
              ('PID', (1, 1)),
              ('PD1', (0, 1)),
              ('ROL', (0, -1)),
              ('PV1', (1, 1)),
              ('PV2', (0, 1)),
              ('ROL', (0, -1)),
              ('DB1', (0, -1)),
              ('OBX', (0, -1)),
              ('DG1', (0, -1)),
              ('DRG', (0, 1)))),
 'ADT_A17': ('sequence',
             (('MSH', (1, 1)),
              ('EVN', (1, 1)),
              ('PID', (1, 1)),
              ('PD1', (0, 1)),
              ('PV1', (1, 1)),
              ('PV2', (0, 1)),
              ('DB1', (0, -1)),
              ('OBX', (0, -1)),
              ('PID', (1, 1)),
              ('PD1', (0, 1)),
              ('PV1', (1, 1)),
              ('PV2', (0, 1)),
              ('DB1', (0, -1)),
              ('OBX', (0, -1)))),
 'ADT_A18': ('sequence',
             (('MSH', (1, 1)),
              ('EVN', (1, 1)),
              ('PID', (1, 1)),
              ('PD1', (0, 1)),
              ('MRG', (1, 1)),
              ('PV1', (1, 1)))),
 'ADT_A20': ('sequence', (('MSH', (1, 1)), ('EVN', (1, 1)), ('NPU', (1, 1)))),
 'ADT_A21': ('sequence',
             (('MSH', (1, 1)),
              ('EVN', (1, 1)),
              ('PID', (1, 1)),
              ('PD1', (0, 1)),
              ('PV1', (1, 1)),
              ('PV2', (0, 1)),
              ('DB1', (0, -1)),
              ('OBX', (0, -1)))),
 'ADT_A24': ('sequence',
             (('MSH', (1, 1)),
              ('EVN', (1, 1)),
              ('PID', (1, 1)),
              ('PD1', (0, 1)),
              ('PV1', (0, 1)),
              ('DB1', (0, -1)),
              ('PID', (1, 1)),
              ('PD1', (0, 1)),
              ('PV1', (0, 1)),
              ('DB1', (0, -1)))),
 'ADT_A30': ('sequence',
             (('MSH', (1, 1)),
              ('EVN', (1, 1)),
              ('PID', (1, 1)),
              ('PD1', (0, 1)),
              ('MRG', (1, 1)))),
 'ADT_A37': ('sequence',
             (('MSH', (1, 1)),
              ('EVN', (1, 1)),
              ('PID', (1, 1)),
              ('PD1', (0, 1)),
              ('PV1', (0, 1)),
              ('DB1', (0, -1)),
              ('PID', (1, 1)),
              ('PD1', (0, 1)),
              ('PV1', (0, 1)),
              ('DB1', (0, -1)))),
 'ADT_A38': ('sequence',
             (('MSH', (1, 1)),
              ('EVN', (1, 1)),
              ('PID', (1, 1)),
              ('PD1', (0, 1)),
              ('PV1', (1, 1)),
              ('PV2', (0, 1)),
              ('DB1', (0, -1)),
              ('OBX', (0, -1)),
              ('DG1', (0, -1)),
              ('DRG', (0, 1)))),
 'ADT_A39': ('sequence',
             (('MSH', (1, 1)), ('EVN', (1, 1)), ('ADT_A39_PATIENT', (1, -1)))),
 'ADT_A43': ('sequence',
             (('MSH', (1, 1)), ('EVN', (1, 1)), ('ADT_A43_PATIENT', (1, -1)))),
 'ADT_A45': ('sequence',
             (('MSH', (1, 1)),
              ('EVN', (1, 1)),
              ('PID', (1, 1)),
              ('PD1', (0, 1)),
              ('ADT_A45_MERGE_INFO', (1, -1)))),
 'ADT_A50': ('sequence',
             (('MSH', (1, 1)),
              ('EVN', (1, 1)),
              ('PID', (1, 1)),
              ('PD1', (0, 1)),
              ('MRG', (1, 1)),
              ('PV1', (1, 1)))),
 'ADT_A52': ('sequence',
             (('MSH', (1, 1)),
              ('EVN', (1, 1)),
              ('PID', (1, 1)),
              ('PD1', (0, 1)),
              ('PV1', (1, 1)),
              ('PV2', (0, 1)))),
 'ADT_A54': ('sequence',
             (('MSH', (1, 1)),
              ('EVN', (1, 1)),
              ('PID', (1, 1)),
              ('PD1', (0, 1)),
              ('ROL', (0, -1)),
              ('PV1', (1, 1)),
              ('PV2', (0, 1)),
              ('ROL', (0, -1)))),
 'ADT_A60': ('sequence',
             (('MSH', (1, 1)),
              ('EVN', (1, 1)),
              ('PID', (1, 1)),
              ('PV1', (0, 1)),
              ('PV2', (0, 1)),
              ('IAM', (0, -1)))),
 'ADT_A61': ('sequence',
             (('MSH', (1, 1)),
              ('EVN', (1, 1)),
              ('PID', (1, 1)),
              ('PD1', (0, 1)),
              ('PV1', (1, 1)),
              ('ROL', (0, -1)),
              ('PV2', (0, 1)))),
 'BAR_P01': ('sequence',
             (('MSH', (1, 1)),
              ('EVN', (1, 1)),
              ('PID', (1, 1)),
              ('PD1', (0, 1)),
              ('ROL', (0, -1)),
              ('BAR_P01_VISIT', (1, -1)))),
 'BAR_P02': ('sequence',
             (('MSH', (1, 1)), ('EVN', (1, 1)), ('BAR_P02_PATIENT', (1, -1)))),
 'BAR_P05': ('sequence',
             (('MSH', (1, 1)),
              ('EVN', (1, 1)),
              ('PID', (1, 1)),
              ('PD1', (0, 1)),
              ('ROL', (0, -1)),
              ('BAR_P05_VISIT', (1, -1)))),
 'BAR_P06': ('sequence',
             (('MSH', (1, 1)), ('EVN', (1, 1)), ('BAR_P06_PATIENT', (1, -1)))),
 'BAR_P10': ('sequence',
             (('MSH', (1, 1)),
              ('EVN', (1, 1)),
              ('PID', (1, 1)),
              ('PV1', (1, 1)),
              ('DG1', (0, -1)),
              ('GP1', (1, 1)),
              ('BAR_P10_PROCEDURE', (0, -1)))),
 'CRM_C01': ('sequence', (('MSH', (1, 1)), ('CRM_C01_PATIENT', (1, -1)))),
 'CSU_C09': ('sequence', (('MSH', (1, 1)), ('CSU_C09_PATIENT', (1, -1)))),
 'DFT_P03': ('sequence',
             (('MSH', (1, 1)),
              ('EVN', (1, 1)),
              ('PID', (1, 1)),
              ('PD1', (0, 1)),
              ('ROL', (0, -1)),
              ('PV1', (0, 1)),
              ('PV2', (0, 1)),
              ('ROL', (0, -1)),
              ('DB1', (0, -1)),
              ('DFT_P03_COMMON_ORDER', (0, -1)),
              ('DFT_P03_FINANCIAL', (1, -1)),
              ('DG1', (0, -1)),
              ('DRG', (0, 1)),
              ('GT1', (0, -1)),
              ('DFT_P03_INSURANCE', (0, -1)),
              ('ACC', (0, 1)))),
 'DFT_P11': ('sequence',
             (('MSH', (1, 1)),
              ('EVN', (1, 1)),
              ('PID', (1, 1)),
              ('PD1', (0, 1)),
              ('ROL', (0, -1)),
              ('PV1', (0, 1)),
              ('PV2', (0, 1)),
              ('ROL', (0, -1)),
              ('DB1', (0, -1)),
              ('DFT_P11_COMMON_ORDER', (0, -1)),
              ('DG1', (0, -1)),
              ('DRG', (0, 1)),
              ('GT1', (0, -1)),
              ('DFT_P11_INSURANCE', (0, -1)),
              ('ACC', (0, 1)),
              ('DFT_P11_FINANCIAL', (1, -1)))),
 'DOC_T12': ('sequence',
             (('MSH', (1, 1)),
              ('MSA', (1, 1)),
              ('ERR', (0, 1)),
              ('QAK', (0, 1)),
              ('QRD', (1, 1)),
              ('DOC_T12_RESULT', (1, -1)),
              ('DSC', (0, 1)))),
 'DSR_Q01': ('sequence',
             (('MSH', (1, 1)),
              ('MSA', (1, 1)),
              ('ERR', (0, 1)),
              ('QAK', (0, 1)),
              ('QRD', (1, 1)),
              ('QRF', (0, 1)),
              ('DSP', (1, -1)),
              ('DSC', (0, 1)))),
 'DSR_Q03': ('sequence',
             (('MSH', (1, 1)),
              ('MSA', (0, 1)),
              ('ERR', (0, 1)),
              ('QAK', (0, 1)),
              ('QRD', (1, 1)),
              ('QRF', (0, 1)),
              ('DSP', (1, -1)),
              ('DSC', (0, 1)))),
 'EAC_U07': ('sequence',
             (('MSH', (1, 1)),
              ('EQU', (1, 1)),
              ('ECD', (1, -1)),
              ('SAC', (0, 1)),
              ('CNS', (0, 1)),
              ('ROL', (0, 1)))),
 'EAN_U09': ('sequence',
             (('MSH', (1, 1)),
              ('EQU', (1, 1)),
              ('EAN_U09_NOTIFICATION', (1, -1)),
              ('ROL', (0, 1)))),
 'EAR_U08': ('sequence',
             (('MSH', (1, 1)),
              ('EQU', (1, 1)),
              ('EAR_U08_COMMAND_RESPONSE', (1, -1)),
              ('ROL', (0, 1)))),
 'EDR_R07': ('sequence',
             (('MSH', (1, 1)),
              ('MSA', (1, 1)),
              ('ERR', (0, 1)),
              ('QAK', (1, 1)),
              ('DSP', (1, -1)),
              ('DSC', (0, 1)))),
 'EQQ_Q04': ('sequence', (('MSH', (1, 1)), ('EQL', (1, 1)), ('DSC', (0, 1)))),
 'ERP_R09': ('sequence',
             (('MSH', (1, 1)),
              ('MSA', (1, 1)),
              ('ERR', (0, 1)),
              ('QAK', (1, 1)),
              ('ERQ', (1, 1)),
              ('DSC', (0, 1)))),
 'ESR_U02': ('sequence', (('MSH', (1, 1)), ('EQU', (1, 1)), ('ROL', (0, 1)))),
 'ESU_U01': ('sequence',
             (('MSH', (1, 1)),
              ('EQU', (1, 1)),
              ('ISD', (0, -1)),
              ('ROL', (0, 1)))),
 'INR_U06': ('sequence',
             (('MSH', (1, 1)),
              ('EQU', (1, 1)),
              ('INV', (1, -1)),
              ('ROL', (0, 1)))),
 'INU_U05': ('sequence',
             (('MSH', (1, 1)),
              ('EQU', (1, 1)),
              ('INV', (1, -1)),
              ('ROL', (0, 1)))),
 'LSU_U12': ('sequence',
             (('MSH', (1, 1)),
              ('EQU', (1, 1)),
              ('EQP', (1, -1)),
              ('ROL', (0, 1)))),
 'MDM_T01': ('sequence',
             (('MSH', (1, 1)),
              ('EVN', (1, 1)),
              ('PID', (1, 1)),
              ('PV1', (1, 1)),
              ('TXA', (1, 1)))),
 'MDM_T02': ('sequence',
             (('MSH', (1, 1)),
              ('EVN', (1, 1)),
              ('PID', (1, 1)),
              ('PV1', (1, 1)),
              ('TXA', (1, 1)),
              ('OBX', (1, -1)))),
 'MFK_M01': ('sequence',
             (('MSH', (1, 1)),
              ('MSA', (1, 1)),
              ('ERR', (0, 1)),
              ('MFI', (1, 1)),
              ('MFA', (0, -1)))),
 'MFN_M01': ('sequence',
             (('MSH', (1, 1)), ('MFI', (1, 1)), ('MFN_M01_MF', (1, -1)))),
 'MFN_M02': ('sequence',
             (('MSH', (1, 1)),
              ('MFI', (1, 1)),
              ('MFN_M02_MF_STAFF', (1, -1)))),
 'MFN_M03': ('sequence',
             (('MSH', (1, 1)), ('MFI', (1, 1)), ('MFN_M03_MF_TEST', (1, -1)))),
 'MFN_M04': ('sequence',
             (('MSH', (1, 1)), ('MFI', (1, 1)), ('MFN_M04_MF_CDM', (1, -1)))),
 'MFN_M05': ('sequence',
             (('MSH', (1, 1)),
              ('MFI', (1, 1)),
              ('MFN_M05_MF_LOCATION', (1, -1)))),
 'MFN_M06': ('sequence',
             (('MSH', (1, 1)),
              ('MFI', (1, 1)),
              ('MFN_M06_MF_CLIN_STUDY', (1, -1)))),
 'MFN_M07': ('sequence',
             (('MSH', (1, 1)),
              ('MFI', (1, 1)),
              ('MFN_M07_MF_CLIN_STUDY_SCHED', (1, -1)))),
 'MFN_M08': ('sequence',
             (('MSH', (1, 1)),
              ('MFI', (1, 1)),
              ('MFN_M08_MF_TEST_NUMERIC', (1, -1)))),
 'MFN_M09': ('sequence',
             (('MSH', (1, 1)),
              ('MFI', (1, 1)),
              ('MFN_M09_MF_TEST_CATEGORICAL', (1, -1)))),
 'MFN_M10': ('sequence',
             (('MSH', (1, 1)),
              ('MFI', (1, 1)),
              ('MFN_M10_MF_TEST_BATTERIES', (1, -1)))),
 'MFN_M11': ('sequence',
             (('MSH', (1, 1)),
              ('MFI', (1, 1)),
              ('MFN_M11_MF_TEST_CALCULATED', (1, -1)))),
 'MFN_M12': ('sequence',
             (('MSH', (1, 1)),
              ('MFI', (1, 1)),
              ('MFN_M12_MF_OBS_ATTRIBUTES', (1, -1)))),
 'MFQ_M01': ('sequence',
             (('MSH', (1, 1)),
              ('QRD', (1, 1)),
              ('QRF', (0, 1)),
              ('DSC', (0, 1)))),
 'MFR_M01': ('sequence',
             (('MSH', (1, 1)),
              ('MSA', (1, 1)),
              ('ERR', (0, 1)),
              ('QAK', (0, 1)),
              ('QRD', (1, 1)),
              ('QRF', (0, 1)),
              ('MFI', (1, 1)),
              ('MFR_M01_MF_QUERY', (1, -1)),
              ('DSC', (0, 1)))),
 'NMD_N02': ('sequence',
             (('MSH', (1, 1)),
              ('NMD_N02_CLOCK_AND_STATS_WITH_NOTES', (1, -1)))),
 'NMQ_N01': ('sequence',
             (('MSH', (1, 1)),
              ('NMQ_N01_QRY_WITH_DETAIL', (0, 1)),
              ('NMQ_N01_CLOCK_AND_STATISTICS', (1, -1)))),
 'NMR_N01': ('sequence',
             (('MSH', (1, 1)),
              ('MSA', (1, 1)),
              ('ERR', (0, 1)),
              ('QRD', (0, 1)),
              ('NMR_N01_CLOCK_AND_STATS_WITH_NOTES_ALT', (1, -1)))),
 'OMD_O03': ('sequence',
             (('MSH', (1, 1)),
              ('NTE', (0, -1)),
              ('OMD_O03_PATIENT', (0, 1)),
              ('OMD_O03_ORDER_DIET', (1, -1)),
              ('OMD_O03_ORDER_TRAY', (0, -1)))),
 'OMG_O19': ('sequence',
             (('MSH', (1, 1)),
              ('NTE', (0, -1)),
              ('OMG_O19_PATIENT', (0, 1)),
              ('OMG_O19_ORDER', (1, -1)))),
 'OML_O21': ('sequence',
             (('MSH', (1, 1)),
              ('NTE', (0, -1)),
              ('OML_O21_PATIENT', (0, 1)),
              ('OML_O21_ORDER_GENERAL', (1, -1)))),
 'OMN_O07': ('sequence',
             (('MSH', (1, 1)),
              ('NTE', (0, -1)),
              ('OMN_O07_PATIENT', (0, 1)),
              ('OMN_O07_ORDER', (1, -1)))),
 'OMP_O09': ('sequence',
             (('MSH', (1, 1)),
              ('NTE', (0, -1)),
              ('OMP_O09_PATIENT', (0, 1)),
              ('OMP_O09_ORDER', (1, -1)))),
 'OMS_O05': ('sequence',
             (('MSH', (1, 1)),
              ('NTE', (0, -1)),
              ('OMS_O05_PATIENT', (0, 1)),
              ('OMS_O05_ORDER', (1, -1)))),
 'ORD_O04': ('sequence',
             (('MSH', (1, 1)),
              ('MSA', (1, 1)),
              ('ERR', (0, 1)),
              ('NTE', (0, -1)),
              ('ORD_O04_RESPONSE', (0, 1)))),
 'ORF_R04': ('sequence',
             (('MSH', (1, 1)),
              ('MSA', (1, 1)),
              ('QRD', (1, 1)),
              ('QRF', (0, 1)),
              ('ORF_R04_RESPONSE', (1, -1)),
              ('ERR', (0, 1)),
              ('QAK', (0, 1)),
              ('DSC', (0, 1)))),
 'ORG_O20': ('sequence',
             (('MSH', (1, 1)),
              ('MSA', (1, 1)),
              ('ERR', (0, 1)),
              ('NTE', (0, -1)),
              ('ORG_O20_RESPONSE', (0, 1)))),
 'ORL_O22': ('sequence',
             (('MSH', (1, 1)),
              ('MSA', (1, 1)),
              ('ERR', (0, 1)),
              ('NTE', (0, -1)),
              ('ORL_O22_RESPONSE', (0, 1)))),
 'ORM_O01': ('sequence',
             (('MSH', (1, 1)),
              ('NTE', (0, -1)),
              ('ORM_O01_PATIENT', (0, 1)),
              ('ORM_O01_ORDER', (1, -1)))),
 'ORN_O08': ('sequence',
             (('MSH', (1, 1)),
              ('MSA', (1, 1)),
              ('ERR', (0, 1)),
              ('NTE', (0, -1)),
              ('ORN_O08_RESPONSE', (0, 1)))),
 'ORP_O10': ('sequence',
             (('MSH', (1, 1)),
              ('MSA', (1, 1)),
              ('ERR', (0, 1)),
              ('NTE', (0, -1)),
              ('ORP_O10_RESPONSE', (0, 1)))),
 'ORR_O02': ('sequence',
             (('MSH', (1, 1)),
              ('MSA', (1, 1)),
              ('ERR', (0, 1)),
              ('NTE', (0, -1)),
              ('ORR_O02_RESPONSE', (0, 1)))),
 'ORS_O06': ('sequence',
             (('MSH', (1, 1)),
              ('MSA', (1, 1)),
              ('ERR', (0, 1)),
              ('NTE', (0, -1)),
              ('ORS_O06_RSPONSE', (0, 1)))),
 'ORU_R01': ('sequence',
             (('MSH', (1, 1)),
              ('ORU_R01_PATIENT_RESULT', (1, -1)),
              ('DSC', (0, 1)))),
 'OSQ_Q06': ('sequence',
             (('MSH', (1, 1)),
              ('QRD', (1, 1)),
              ('QRF', (0, 1)),
              ('DSC', (0, 1)))),
 'OSR_Q06': ('sequence',
             (('MSH', (1, 1)),
              ('MSA', (1, 1)),
              ('ERR', (0, 1)),
              ('NTE', (0, -1)),
              ('QRD', (1, 1)),
              ('QRF', (0, 1)),
              ('OSR_Q06_RESPONSE', (0, 1)),
              ('DSC', (0, 1)))),
 'OUL_R21': ('sequence',
             (('MSH', (1, 1)),
              ('NTE', (0, 1)),
              ('OUL_R21_PATIENT', (0, 1)),
              ('OUL_R21_VISIT', (0, 1)),
              ('OUL_R21_ORDER_OBSERVATION', (1, -1)),
              ('DSC', (0, 1)))),
 'PEX_P07': ('sequence',
             (('MSH', (1, 1)),
              ('EVN', (1, 1)),
              ('PID', (1, 1)),
              ('PD1', (0, 1)),
              ('NTE', (0, -1)),
              ('PEX_P07_VISIT', (0, 1)),
              ('PEX_P07_EXPERIENCE', (1, -1)))),
 'PGL_PC6': ('sequence',
             (('MSH', (1, 1)),
              ('PID', (1, 1)),
              ('PGL_PC6_PATIENT_VISIT', (0, 1)),
              ('PGL_PC6_GOAL', (1, -1)))),
 'PMU_B01': ('sequence',
             (('MSH', (1, 1)),
              ('EVN', (1, 1)),
              ('STF', (1, 1)),
              ('PRA', (0, -1)),
              ('ORG', (0, -1)),
              ('AFF', (0, -1)),
              ('LAN', (0, -1)),
              ('EDU', (0, -1)))),
 'PMU_B03': ('sequence', (('MSH', (1, 1)), ('EVN', (1, 1)), ('STF', (1, 1)))),
 'PMU_B04': ('sequence',
             (('MSH', (1, 1)),
              ('EVN', (1, 1)),
              ('STF', (1, 1)),
              ('PRA', (0, -1)),
              ('ORG', (0, 1)))),
 'PPG_PCG': ('sequence',
             (('MSH', (1, 1)),
              ('PID', (1, 1)),
              ('PPG_PCG_PATIENT_VISIT', (0, 1)),
              ('PPG_PCG_PATHWAY', (1, -1)))),
 'PPP_PCB': ('sequence',
             (('MSH', (1, 1)),
              ('PID', (1, 1)),
              ('PPP_PCB_PATIENT_VISIT', (0, 1)),
              ('PPP_PCB_PATHWAY', (1, -1)))),
 'PPR_PC1': ('sequence',
             (('MSH', (1, 1)),
              ('PID', (1, 1)),
              ('PPR_PC1_PATIENT_VISIT', (0, 1)),
              ('PPR_PC1_PROBLEM', (1, -1)))),
 'PPT_PCL': ('sequence',
             (('MSH', (1, 1)),
              ('MSA', (1, 1)),
              ('ERR', (0, 1)),
              ('QAK', (0, 1)),
              ('QRD', (1, 1)),
              ('PPT_PCL_PATIENT', (1, -1)))),
 'PPV_PCA': ('sequence',
             (('MSH', (1, 1)),
              ('MSA', (1, 1)),
              ('ERR', (0, 1)),
              ('QAK', (0, 1)),
              ('QRD', (1, 1)),
              ('PPV_PCA_PATIENT', (1, -1)))),
 'PRR_PC5': ('sequence',
             (('MSH', (1, 1)),
              ('MSA', (1, 1)),
              ('ERR', (0, 1)),
              ('QAK', (0, 1)),
              ('QRD', (1, 1)),
              ('PRR_PC5_PATIENT', (1, -1)))),
 'PTR_PCF': ('sequence',
             (('MSH', (1, 1)),
              ('MSA', (1, 1)),
              ('ERR', (0, 1)),
              ('QAK', (0, 1)),
              ('QRD', (1, 1)),
              ('PTR_PCF_PATIENT', (1, -1)))),
 'QBP_K13': ('sequence',
             (('MSH', (1, 1)),
              ('MSA', (1, 1)),
              ('ERR', (0, 1)),
              ('QAK', (1, 1)),
              ('QPD', (1, 1)),
              ('QBP_K13_ROW_DEFINITION', (0, 1)),
              ('DSC', (0, 1)))),
 'QBP_Q11': ('sequence',
             (('MSH', (1, 1)),
              ('QPD', (1, 1)),
              ('RCP', (1, 1)),
              ('DSC', (0, 1)))),
 'QBP_Q13': ('sequence',
             (('MSH', (1, 1)),
              ('QPD', (1, 1)),
              ('QBP_Q13_QBP', (0, 1)),
              ('RDF', (0, 1)),
              ('RCP', (1, 1)),
              ('DSC', (0, 1)))),
 'QBP_Q15': ('sequence',
             (('MSH', (1, 1)),
              ('QPD', (1, 1)),
              ('ANYZSEGMENT', (0, 1)),
              ('RCP', (1, 1)),
              ('DSC', (0, 1)))),
 'QBP_Q21': ('sequence',
             (('MSH', (1, 1)),
              ('QPD', (1, 1)),
              ('RCP', (1, 1)),
              ('DSC', (0, 1)))),
 'QBP_Qnn': ('sequence',
             (('MSH', (1, 1)),
              ('QPD', (1, 1)),
              ('RDF', (0, 1)),
              ('RCP', (1, 1)),
              ('DSC', (0, 1)))),
 'QBP_Z73': ('sequence', (('MSH', (1, 1)), ('QPD', (1, 1)), ('RCP', (1, 1)))),
 'QCK_Q02': ('sequence',
             (('MSH', (1, 1)),
              ('MSA', (1, 1)),
              ('ERR', (0, 1)),
              ('QAK', (0, 1)))),
 'QCN_J01': ('sequence', (('MSH', (1, 1)), ('QID', (1, 1)))),
 'QRY_A19': ('sequence', (('MSH', (1, 1)), ('QRD', (1, 1)), ('QRF', (0, 1)))),
 'QRY_PC4': ('sequence', (('MSH', (1, 1)), ('QRD', (1, 1)), ('QRF', (0, 1)))),
 'QRY_Q01': ('sequence',
             (('MSH', (1, 1)),
              ('QRD', (1, 1)),
              ('QRF', (0, 1)),
              ('DSC', (0, 1)))),
 'QRY_Q02': ('sequence',
             (('MSH', (1, 1)),
              ('QRD', (1, 1)),
              ('QRF', (0, 1)),
              ('DSC', (0, 1)))),
 'QRY_R02': ('sequence', (('MSH', (1, 1)), ('QRD', (1, 1)), ('QRF', (1, 1)))),
 'QRY_T12': ('sequence', (('MSH', (1, 1)), ('QRD', (1, 1)), ('QRF', (0, 1)))),
 'QSB_Q16': ('sequence',
             (('MSH', (1, 1)),
              ('QPD', (1, 1)),
              ('RCP', (1, 1)),
              ('DSC', (0, 1)))),
 'QVR_Q17': ('sequence',
             (('MSH', (1, 1)),
              ('QPD', (1, 1)),
              ('ANYZSEGMENT', (0, 1)),
              ('RCP', (1, 1)),
              ('DSC', (0, 1)))),
 'RAR_RAR': ('sequence',
             (('MSH', (1, 1)),
              ('MSA', (1, 1)),
              ('ERR', (0, 1)),
              ('RAR_RAR_DEFINITION', (1, -1)),
              ('DSC', (0, 1)))),
 'RAS_O17': ('sequence',
             (('MSH', (1, 1)),
              ('NTE', (0, -1)),
              ('RAS_O17_PATIENT', (0, 1)),
              ('RAS_O17_ORDER', (1, -1)))),
 'RCI_I05': ('sequence',
             (('MSH', (1, 1)),
              ('MSA', (1, 1)),
              ('QRD', (1, 1)),
              ('QRF', (0, 1)),
              ('RCI_I05_PROVIDER', (1, -1)),
              ('PID', (1, 1)),
              ('DG1', (0, -1)),
              ('DRG', (0, -1)),
              ('AL1', (0, -1)),
              ('RCI_I05_OBSERVATION', (0, -1)),
              ('NTE', (0, -1)))),
 'RCL_I06': ('sequence',
             (('MSH', (1, 1)),
              ('MSA', (1, 1)),
              ('QRD', (1, 1)),
              ('QRF', (0, 1)),
              ('RCL_I06_PROVIDER', (1, -1)),
              ('PID', (1, 1)),
              ('DG1', (0, -1)),
              ('DRG', (0, -1)),
              ('AL1', (0, -1)),
              ('NTE', (0, -1)),
              ('DSP', (0, -1)),
              ('DSC', (0, 1)))),
 'RDE_O11': ('sequence',
             (('MSH', (1, 1)),
              ('NTE', (0, -1)),
              ('RDE_O11_PATIENT', (0, 1)),
              ('RDE_O11_ORDER', (1, -1)))),
 'RDR_RDR': ('sequence',
             (('MSH', (1, 1)),
              ('MSA', (1, 1)),
              ('ERR', (0, 1)),
              ('RDR_RDR_DEFINITION', (1, -1)),
              ('DSC', (0, 1)))),
 'RDS_O13': ('sequence',
             (('MSH', (1, 1)),
              ('NTE', (0, -1)),
              ('RDS_O13_PATIENT', (0, 1)),
              ('RDS_O13_ORDER', (1, -1)))),
 'RDY_K15': ('sequence',
             (('MSH', (1, 1)),
              ('MSA', (1, 1)),
              ('ERR', (0, 1)),
              ('QAK', (1, 1)),
              ('QPD', (1, 1)),
              ('DSP', (0, -1)),
              ('DSC', (0, 1)))),
 'REF_I12': ('sequence',
             (('MSH', (1, 1)),
              ('RF1', (0, 1)),
              ('REF_I12_AUTHORIZATION_CONTACT', (0, 1)),
              ('REF_I12_PROVIDER_CONTACT', (1, -1)),
              ('PID', (1, 1)),
              ('NK1', (0, -1)),
              ('GT1', (0, -1)),
              ('REF_I12_INSURANCE', (0, -1)),
              ('ACC', (0, 1)),
              ('DG1', (0, -1)),
              ('DRG', (0, -1)),
              ('AL1', (0, -1)),
              ('REF_I12_PROCEDURE', (0, -1)),
              ('REF_I12_OBSERVATION', (0, -1)),
              ('REF_I12_PATIENT_VISIT', (0, 1)),
              ('NTE', (0, -1)))),
 'RER_RER': ('sequence',
             (('MSH', (1, 1)),
              ('MSA', (1, 1)),
              ('ERR', (0, 1)),
              ('RER_RER_DEFINITION', (1, -1)),
              ('DSC', (0, 1)))),
 'RGR_RGR': ('sequence',
             (('MSH', (1, 1)),
              ('MSA', (1, 1)),
              ('ERR', (0, 1)),
              ('RGR_RGR_DEFINTION', (1, -1)),
              ('DSC', (0, 1)))),
 'RGV_O15': ('sequence',
             (('MSH', (1, 1)),
              ('NTE', (0, -1)),
              ('RGV_O15_PATIENT', (0, 1)),
              ('RGV_O15_ORDER', (1, -1)))),
 'ROR_ROR': ('sequence',
             (('MSH', (1, 1)),
              ('MSA', (1, 1)),
              ('ERR', (0, 1)),
              ('ROR_ROR_DEFINITION', (1, -1)),
              ('DSC', (0, 1)))),
 'RPA_I08': ('sequence',
             (('MSH', (1, 1)),
              ('MSA', (1, 1)),
              ('RF1', (0, 1)),
              ('RPA_I08_AUTHORIZATION', (0, 1)),
              ('RPA_I08_PROVIDER', (1, -1)),
              ('PID', (1, 1)),
              ('NK1', (0, -1)),
              ('GT1', (0, -1)),
              ('RPA_I08_INSURANCE', (0, -1)),
              ('ACC', (0, 1)),
              ('DG1', (0, -1)),
              ('DRG', (0, -1)),
              ('AL1', (0, -1)),
              ('RPA_I08_PROCEDURE', (1, -1)),
              ('RPA_I08_OBSERVATION', (0, -1)),
              ('RPA_I08_VISIT', (0, 1)),
              ('NTE', (0, -1)))),
 'RPI_I01': ('sequence',
             (('MSH', (1, 1)),
              ('MSA', (1, 1)),
              ('RPI_I01_PROVIDER', (1, -1)),
              ('PID', (1, 1)),
              ('NK1', (0, -1)),
              ('RPI_I01_GUARANTOR_INSURANCE', (0, 1)),
              ('NTE', (0, -1)))),
 'RPI_I04': ('sequence',
             (('MSH', (1, 1)),
              ('MSA', (1, 1)),
              ('RPI_I04_PROVIDER', (1, -1)),
              ('PID', (1, 1)),
              ('NK1', (0, -1)),
              ('RPI_I04_GUARANTOR_INSURANCE', (0, 1)),
              ('NTE', (0, -1)))),
 'RPL_I02': ('sequence',
             (('MSH', (1, 1)),
              ('MSA', (1, 1)),
              ('RPL_I02_PROVIDER', (1, -1)),
              ('NTE', (0, -1)),
              ('DSP', (0, -1)),
              ('DSC', (0, 1)))),
 'RPR_I03': ('sequence',
             (('MSH', (1, 1)),
              ('MSA', (1, 1)),
              ('RPR_I03_PROVIDER', (1, -1)),
              ('PID', (0, -1)),
              ('NTE', (0, -1)))),
 'RQA_I08': ('sequence',
             (('MSH', (1, 1)),
              ('RF1', (0, 1)),
              ('RQA_I08_AUTHORIZATION', (0, 1)),
              ('RQA_I08_PROVIDER', (1, -1)),
              ('PID', (1, 1)),
              ('NK1', (0, -1)),
              ('RQA_I08_GUARANTOR_INSURANCE', (0, 1)),
              ('ACC', (0, 1)),
              ('DG1', (0, -1)),
              ('DRG', (0, -1)),
              ('AL1', (0, -1)),
              ('RQA_I08_PROCEDURE', (0, -1)),
              ('RQA_I08_OBSERVATION', (0, -1)),
              ('RQA_I08_VISIT', (0, 1)),
              ('NTE', (0, -1)))),
 'RQC_I05': ('sequence',
             (('MSH', (1, 1)),
              ('QRD', (1, 1)),
              ('QRF', (0, 1)),
              ('RQC_I05_PROVIDER', (1, -1)),
              ('PID', (1, 1)),
              ('NK1', (0, -1)),
              ('GT1', (0, -1)),
              ('NTE', (0, -1)))),
 'RQI_I01': ('sequence',
             (('MSH', (1, 1)),
              ('RQI_I01_PROVIDER', (1, -1)),
              ('PID', (1, 1)),
              ('NK1', (0, -1)),
              ('RQI_I01_GUARANTOR_INSURANCE', (0, 1)),
              ('NTE', (0, -1)))),
 'RQP_I04': ('sequence',
             (('MSH', (1, 1)),
              ('RQP_I04_PROVIDER', (1, -1)),
              ('PID', (1, 1)),
              ('NK1', (0, -1)),
              ('GT1', (0, -1)),
              ('NTE', (0, -1)))),
 'RQQ_Q09': ('sequence', (('MSH', (1, 1)), ('ERQ', (1, 1)), ('DSC', (0, 1)))),
 'RRA_O18': ('sequence',
             (('MSH', (1, 1)),
              ('MSA', (1, 1)),
              ('ERR', (0, 1)),
              ('NTE', (0, -1)),
              ('RRA_O18_RESPONSE', (0, 1)))),
 'RRD_O14': ('sequence',
             (('MSH', (1, 1)),
              ('MSA', (1, 1)),
              ('ERR', (0, 1)),
              ('NTE', (0, -1)),
              ('RRD_O14_RESPONSE', (0, 1)))),
 'RRE_O12': ('sequence',
             (('MSH', (1, 1)),
              ('MSA', (1, 1)),
              ('ERR', (0, 1)),
              ('NTE', (0, -1)),
              ('RRE_O12_RESPONSE', (0, 1)))),
 'RRG_O16': ('sequence',
             (('MSH', (1, 1)),
              ('MSA', (1, 1)),
              ('ERR', (0, 1)),
              ('NTE', (0, -1)),
              ('RRG_O16_RESPONSE', (0, 1)))),
 'RRI_I12': ('sequence',
             (('MSH', (1, 1)),
              ('MSA', (0, 1)),
              ('RF1', (0, 1)),
              ('RRI_I12_AUTHORIZATION_CONTACT', (0, 1)),
              ('RRI_I12_PROVIDER_CONTACT', (1, -1)),
              ('PID', (1, 1)),
              ('ACC', (0, 1)),
              ('DG1', (0, -1)),
              ('DRG', (0, -1)),
              ('AL1', (0, -1)),
              ('RRI_I12_PROCEDURE', (0, -1)),
              ('RRI_I12_OBSERVATION', (0, -1)),
              ('RRI_I12_PATIENT_VISIT', (0, 1)),
              ('NTE', (0, -1)))),
 'RSP_K11': ('sequence',
             (('MSH', (1, 1)),
              ('MSA', (1, 1)),
              ('ERR', (0, 1)),
              ('QAK', (1, 1)),
              ('QPD', (1, 1)),
              ('ANYZSEGMENT', (0, 1)),
              ('DSC', (0, 1)))),
 'RSP_K13': ('sequence',
             (('MSH', (1, 1)),
              ('MSA', (1, 1)),
              ('ERR', (0, 1)),
              ('QAK', (1, 1)),
              ('QPD', (1, 1)),
              ('RSP_K13_ROW_DEFINITION', (0, 1)),
              ('DSC', (0, 1)))),
 'RSP_K15': ('sequence',
             (('MSH', (1, 1)),
              ('MSA', (1, 1)),
              ('ERR', (0, 1)),
              ('QAK', (1, 1)),
              ('QPD', (1, 1)),
              ('DSP', (0, -1)),
              ('DSC', (0, 1)))),
 'RSP_K21': ('sequence',
             (('MSH', (1, 1)),
              ('MSA', (1, 1)),
              ('ERR', (0, 1)),
              ('QAK', (1, 1)),
              ('QPD', (1, 1)),
              ('RSP_K21_QUERY_RESPONSE', (0, 1)),
              ('DSC', (0, 1)))),
 'RSP_K22': ('sequence',
             (('MSH', (1, 1)),
              ('MSA', (1, 1)),
              ('ERR', (0, 1)),
              ('QAK', (1, 1)),
              ('QPD', (1, 1)),
              ('RSP_K22_QUERY_RESPONSE', (0, -1)),
              ('DSC', (0, 1)))),
 'RSP_K23': ('sequence',
             (('MSH', (1, 1)),
              ('MSA', (1, 1)),
              ('ERR', (0, 1)),
              ('QAK', (1, 1)),
              ('QPD', (1, 1)),
              ('PID', (0, 1)),
              ('DSC', (0, 1)))),
 'RSP_K24': ('sequence',
             (('MSH', (1, 1)),
              ('MSA', (1, 1)),
              ('ERR', (0, 1)),
              ('QAK', (1, 1)),
              ('QPD', (1, 1)),
              ('PID', (0, 1)),
              ('DSC', (0, 1)))),
 'RSP_K25': ('sequence',
             (('MSH', (1, 1)),
              ('MSA', (1, 1)),
              ('ERR', (0, 1)),
              ('QAK', (1, 1)),
              ('QPD', (1, 1)),
              ('RCP', (1, 1)),
              ('RSP_K25_STAFF', (1, -1)),
              ('DSC', (0, 1)))),
 'RSP_Z82': ('sequence',
             (('MSH', (1, 1)),
              ('MSA', (1, 1)),
              ('ERR', (0, 1)),
              ('QAK', (1, 1)),
              ('QPD', (1, 1)),
              ('RCP', (1, 1)),
              ('RSP_Z82_QUERY_RESPONSE', (1, -1)),
              ('DSC', (0, 1)))),
 'RSP_Z86': ('sequence',
             (('MSH', (1, 1)),
              ('MSA', (1, 1)),
              ('ERR', (0, 1)),
              ('QAK', (1, 1)),
              ('QPD', (1, 1)),
              ('RSP_Z86_QUERY_RESPONSE', (1, -1)),
              ('DSC', (0, 1)))),
 'RSP_Z88': ('sequence',
             (('MSH', (1, 1)),
              ('MSA', (1, 1)),
              ('ERR', (0, 1)),
              ('QAK', (1, 1)),
              ('QPD', (1, 1)),
              ('RCP', (1, 1)),
              ('RSP_Z88_QUERY_RESPONSE', (1, -1)),
              ('DSC', (1, 1)))),
 'RSP_Z90': ('sequence',
             (('MSH', (1, 1)),
              ('MSA', (1, 1)),
              ('ERR', (0, 1)),
              ('QAK', (1, 1)),
              ('QPD', (1, 1)),
              ('RCP', (1, 1)),
              ('RSP_Z90_QUERY_RESPONSE', (1, -1)),
              ('DSC', (1, 1)))),
 'RTB_K13': ('sequence',
             (('MSH', (1, 1)),
              ('MSA', (1, 1)),
              ('ERR', (0, 1)),
              ('QAK', (1, 1)),
              ('QPD', (1, 1)),
              ('RTB_K13_ROW_DEFINITION', (0, 1)),
              ('DSC', (0, 1)))),
 'RTB_Knn': ('sequence',
             (('MSH', (1, 1)),
              ('MSA', (1, 1)),
              ('ERR', (0, 1)),
              ('QAK', (1, 1)),
              ('QPD', (1, 1)),
              ('DSC', (0, 1)))),
 'RTB_Q13': ('sequence',
             (('MSH', (1, 1)),
              ('MSA', (1, 1)),
              ('ERR', (0, 1)),
              ('QAK', (1, 1)),
              ('QPD', (1, 1)),
              ('RTB_Q13_ROW_DEFINITION', (0, 1)),
              ('DSC', (0, 1)))),
 'RTB_Z74': ('sequence',
             (('MSH', (1, 1)),
              ('MSA', (1, 1)),
              ('ERR', (0, 1)),
              ('QAK', (1, 1)),
              ('QPD', (1, 1)),
              ('RTB_Z74_ROW_DEFINITION', (0, 1)),
              ('DSC', (0, 1)))),
 'SIU_S12': ('sequence',
             (('MSH', (1, 1)),
              ('SCH', (1, 1)),
              ('NTE', (0, -1)),
              ('SIU_S12_PATIENT', (0, -1)),
              ('SIU_S12_RESOURCES', (1, -1)))),
 'SPQ_Q08': ('sequence',
             (('MSH', (1, 1)),
              ('SPR', (1, 1)),
              ('RDF', (0, 1)),
              ('DSC', (0, 1)))),
 'SQM_S25': ('sequence',
             (('MSH', (1, 1)),
              ('QRD', (1, 1)),
              ('QRF', (0, 1)),
              ('SQM_S25_REQUEST', (0, 1)),
              ('DSC', (0, 1)))),
 'SQR_S25': ('sequence',
             (('MSH', (1, 1)),
              ('MSA', (1, 1)),
              ('ERR', (0, 1)),
              ('QAK', (1, 1)),
              ('SQR_S25_SCHEDULE', (0, -1)),
              ('DSC', (0, 1)))),
 'SRM_S01': ('sequence',
             (('MSH', (1, 1)),
              ('ARQ', (1, 1)),
              ('APR', (0, 1)),
              ('NTE', (0, -1)),
              ('SRM_S01_PATIENT', (0, -1)),
              ('SRM_S01_RESOURCES', (1, -1)))),
 'SRR_S01': ('sequence',
             (('MSH', (1, 1)),
              ('MSA', (1, 1)),
              ('ERR', (0, 1)),
              ('SRR_S01_SCHEDULE', (0, 1)))),
 'SSR_U04': ('sequence',
             (('MSH', (1, 1)),
              ('EQU', (1, 1)),
              ('SAC', (1, -1)),
              ('ROL', (0, 1)))),
 'SSU_U03': ('sequence',
             (('MSH', (1, 1)),
              ('EQU', (1, 1)),
              ('SSU_U03_SPECIMEN_CONTAINER', (1, -1)),
              ('ROL', (0, 1)))),
 'SUR_P09': ('sequence', (('MSH', (1, 1)), ('SUR_P09_FACILITY', (1, -1)))),
 'TBR_R08': ('sequence',
             (('MSH', (1, 1)),
              ('MSA', (1, 1)),
              ('ERR', (0, 1)),
              ('QAK', (1, 1)),
              ('RDF', (1, 1)),
              ('RDT', (1, -1)),
              ('DSC', (0, 1)))),
 'TCU_U10': ('sequence',
             (('MSH', (1, 1)),
              ('EQU', (1, 1)),
              ('TCC', (1, -1)),
              ('ROL', (0, 1)))),
 'UDM_Q05': ('sequence',
             (('MSH', (1, 1)),
              ('URD', (1, 1)),
              ('URS', (0, 1)),
              ('DSP', (1, -1)),
              ('DSC', (0, 1)))),
 'VQQ_Q07': ('sequence',
             (('MSH', (1, 1)),
              ('VTQ', (1, 1)),
              ('RDF', (0, 1)),
              ('DSC', (0, 1)))),
 'VXQ_V01': ('sequence', (('MSH', (1, 1)), ('QRD', (1, 1)), ('QRF', (0, 1)))),
 'VXR_V03': ('sequence',
             (('MSH', (1, 1)),
              ('MSA', (1, 1)),
              ('QRD', (1, 1)),
              ('QRF', (0, 1)),
              ('PID', (1, 1)),
              ('PD1', (0, 1)),
              ('NK1', (0, -1)),
              ('VXR_V03_PATIENT_VISIT', (0, 1)),
              ('GT1', (0, -1)),
              ('VXR_V03_INSURANCE', (0, -1)),
              ('VXR_V03_ORDER', (0, -1)))),
 'VXU_V04': ('sequence',
             (('MSH', (1, 1)),
              ('PID', (1, 1)),
              ('PD1', (0, 1)),
              ('NK1', (0, -1)),
              ('VXU_V04_PATIENT', (0, 1)),
              ('GT1', (0, -1)),
              ('VXU_V04_INSURANCE', (0, -1)),
              ('VXU_V04_ORDER', (0, -1)))),
 'VXX_V02': ('sequence',
             (('MSH', (1, 1)),
              ('MSA', (1, 1)),
              ('QRD', (1, 1)),
              ('QRF', (0, 1)),
              ('VXX_V02_PATIENT', (1, -1))))}
