# -*- coding: utf-8 -*-
#
# Copyright (c) 2012-2014, CRS4
#
# Permission is hereby granted, free of charge, to any person obtaining a copy of
# this software and associated documentation files (the "Software"), to deal in
# the Software without restriction, including without limitation the rights to
# use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
# the Software, and to permit persons to whom the Software is furnished to do so,
# subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
# FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
# COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
# IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
# CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

DATATYPES = {'ABSRANGE': ('sequence',
              (('ABSRANGE_1', (0, 1)),
               ('ABSRANGE_2', (0, 1)),
               ('ABSRANGE_3', (0, 1)),
               ('ABSRANGE_4', (0, 1)))),
 'ABSRANGE_1': ('leaf', 'RANGE', 'RANGE', None),
 'ABSRANGE_2': ('leaf', 'NM', 'NUMERIC_CHANGE', None),
 'ABSRANGE_3': ('leaf', 'NM', 'PERCENT_PER_CHANGE', None),
 'ABSRANGE_4': ('leaf', 'NM', 'DAYS', None),
 'ACCOUNTNO': ('sequence',
               (('ACCOUNTNO_1', (0, 1)),
                ('ACCOUNTNO_2', (0, 1)),
                ('ACCOUNTNO_3', (0, 1)),
                ('ACCOUNTNO_4', (0, 1)))),
 'ACCOUNTNO_1': ('leaf', 'NM', 'ACCOUNT_NUMBER', None),
 'ACCOUNTNO_2': ('leaf', 'NM', 'CHECK_DIGIT', None),
 'ACCOUNTNO_3': ('leaf', 'ID', 'CHECK_DIGIT_SCHEME', None),
 'ACCOUNTNO_4': ('leaf', 'ID', 'FACILITY_ID', None),
 'AD': ('sequence',
        (('AD_1', (0, 1)),
         ('AD_2', (0, 1)),
         ('AD_3', (0, 1)),
         ('AD_4', (0, 1)),
         ('AD_5', (0, 1)),
         ('AD_6', (0, 1)),
         ('AD_7', (0, 1)),
         ('AD_8', (0, 1)))),
 'AD_1': ('leaf', 'ST', 'STREET_ADDRESS', None),
 'AD_2': ('leaf', 'ST', 'OTHER_DESIGNATION', None),
 'AD_3': ('leaf', 'ST', 'CITY', None),
 'AD_4': ('leaf', 'ST', 'STATE_OR_PROVINCE', None),
 'AD_5': ('leaf', 'ID', 'ZIP_OR_POSTAL_CODE', None),
 'AD_6': ('leaf', 'ID', 'COUNTRY', None),
 'AD_7': ('leaf', 'ID', 'TYPE', None),
 'AD_8': ('leaf', 'ST', 'OTHER_GEOGRAPHIC_DESIGNATION', None),
 'AUI': ('sequence',
         (('AUI_1', (0, 1)), ('AUI_2', (0, 1)), ('AUI_3', (0, 1)))),
 'AUI_1': ('leaf', 'ST', 'AUTHORIZATION_NUMBER', None),
 'AUI_2': ('leaf', 'DT', 'DATE', None),
 'AUI_3': ('leaf', 'ST', 'SOURCE', None),
 'BATCHTOTAL': ('sequence',
                (('BATCHTOTAL_1', (0, 1)), ('BATCHTOTAL_2', (0, 1)))),
 'BATCHTOTAL_1': ('leaf', 'NM', 'BATCH_TOTAL_1', None),
 'BATCHTOTAL_2': ('leaf', 'NM', 'BATCH_TOTAL_2', None),
 'CCD': ('sequence', (('CCD_1', (0, 1)), ('CCD_2', (0, 1)))),
 'CCD_1': ('leaf', 'ID', 'WHEN_TO_CHARGE', None),
 'CCD_2': ('leaf', 'TS', 'DATE_TIME', None),
 'CE': ('sequence',
        (('CE_1', (0, 1)),
         ('CE_2', (0, 1)),
         ('CE_3', (0, 1)),
         ('CE_4', (0, 1)),
         ('CE_5', (0, 1)),
         ('CE_6', (0, 1)))),
 'CE_1': ('leaf', 'ID', 'IDENTIFIER', None),
 'CE_2': ('leaf', 'ST', 'TEXT', None),
 'CE_3': ('leaf', 'ST', 'NAME_OF_CODING_SYSTEM', None),
 'CE_4': ('leaf', 'ST', 'ALTERNATE_IDENTIFIER', None),
 'CE_5': ('leaf', 'ST', 'ALTERNATE_TEXT', None),
 'CE_6': ('leaf', 'ST', 'NAME_OF_ALTERNATE_CODING_SYSTEM', None),
 'DDI': ('sequence',
         (('DDI_1', (0, 1)), ('DDI_2', (0, 1)), ('DDI_3', (0, 1)))),
 'DDI_1': ('leaf', 'ST', 'DELAY_DAYS', None),
 'DDI_2': ('leaf', 'NM', 'AMOUNT', None),
 'DDI_3': ('leaf', 'NM', 'NUMBER_OF_DAYS', None),
 'DIN': ('sequence', (('DIN_1', (0, 1)), ('DIN_2', (0, 1)))),
 'DIN_1': ('leaf', 'TS', 'DATE', None),
 'DIN_2': ('leaf', 'CE', 'INSTITUTION_NAME', None),
 'DLD': ('sequence', (('DLD_1', (0, 1)), ('DLD_2', (0, 1)))),
 'DLD_1': ('leaf', 'ID', 'DISCHARGE_LOCATION', None),
 'DLD_2': ('leaf', 'TS', 'EFFECTIVE_DATE', None),
 'DLT': ('sequence',
         (('DLT_1', (0, 1)),
          ('DLT_2', (0, 1)),
          ('DLT_3', (0, 1)),
          ('DLT_4', (0, 1)))),
 'DLT_1': ('leaf', 'RANGE', 'RANGE', None),
 'DLT_2': ('leaf', 'NM', 'NUMERIC_THRESHOLD', None),
 'DLT_3': ('leaf', 'ST', 'CHANGE', None),
 'DLT_4': ('leaf', 'NM', 'LENGTH_OF_TIME_DAYS', None),
 'DTN': ('sequence', (('DTN_1', (0, 1)), ('DTN_2', (0, 1)))),
 'DTN_1': ('leaf', 'ID', 'DAY_TYPE', None),
 'DTN_2': ('leaf', 'NM', 'NUMBER_OF_DAYS', None),
 'EIP': ('sequence', (('EIP_1', (0, 1)), ('EIP_2', (0, 1)))),
 'EIP_1': ('leaf', 'ST', u'PARENT_S_PLACER_ORDER_NUMBER', None),
 'EIP_2': ('leaf', 'ST', u'PARENT_S_FILLER_ORDER_NUMBER', None),
 'ELD': ('sequence',
         (('ELD_1', (0, 1)),
          ('ELD_2', (0, 1)),
          ('ELD_3', (0, 1)),
          ('ELD_4', (0, 1)))),
 'ELD_1': ('leaf', 'ST', 'SEGMENT_ID', None),
 'ELD_2': ('leaf', 'NM', 'SEQUENCE', None),
 'ELD_3': ('leaf', 'NM', 'FIELD_POSITION', None),
 'ELD_4': ('leaf', 'CE', 'CODE_IDENTIFYING_ERROR', None),
 'ESCAPETYPE': None,
 'FILLER': ('sequence', (('FILLER_1', (0, 1)), ('FILLER_2', (0, 1)))),
 'FILLER_1': ('leaf', 'ID', 'UNIQUE_FILLER_ID', None),
 'FILLER_2': ('leaf', 'ID', 'FILLER_APPLICATION_ID', None),
 'FINANCE': ('sequence', (('FINANCE_1', (0, 1)), ('FINANCE_2', (0, 1)))),
 'FINANCE_1': ('leaf', 'ID', 'FINANCIAL_CLASS_ID', None),
 'FINANCE_2': ('leaf', 'TS', 'EFFECTIVE_DATE', None),
 'GROUPID': ('sequence', (('GROUPID_1', (0, 1)), ('GROUPID_2', (0, 1)))),
 'GROUPID_1': ('leaf', 'ID', 'UNIQUE_GROUP_ID', None),
 'GROUPID_2': ('leaf', 'ID', 'PLACER_APPLICATION_ID', None),
 'INTERNALLOCATION': ('sequence',
                      (('INTERNALLOCATION_1', (0, 1)),
                       ('INTERNALLOCATION_2', (0, 1)),
                       ('INTERNALLOCATION_3', (0, 1)),
                       ('INTERNALLOCATION_4', (0, 1)),
                       ('INTERNALLOCATION_5', (0, 1)),
                       ('INTERNALLOCATION_6', (0, 1)),
                       ('INTERNALLOCATION_7', (0, 1)),
                       ('INTERNALLOCATION_8', (0, 1)))),
 'INTERNALLOCATION_1': ('leaf', 'ID', 'NURSE_UNIT_STATION_', None),
 'INTERNALLOCATION_2': ('leaf', 'ID', 'ROOM', None),
 'INTERNALLOCATION_3': ('leaf', 'ID', 'BED', None),
 'INTERNALLOCATION_4': ('leaf', 'ID', 'FACILITY_ID', None),
 'INTERNALLOCATION_5': ('leaf', 'ID', 'BED_STATUS', None),
 'INTERNALLOCATION_6': ('leaf', 'ID', 'ETAGE', None),
 'INTERNALLOCATION_7': ('leaf', 'ID', 'KLINIK', None),
 'INTERNALLOCATION_8': ('leaf', 'ID', 'ZENTRUM', None),
 'JOBCODE': ('sequence', (('JOBCODE_1', (0, 1)), ('JOBCODE_2', (0, 1)))),
 'JOBCODE_1': ('leaf', 'ID', 'JOB_CODE', None),
 'JOBCODE_2': ('leaf', 'ID', 'EMPLOYEE_CLASSIFICATION', None),
 'LA1': ('sequence', (('LA1_1', (0, 1)), ('LA1_2', (0, 1)))),
 'LA1_1': ('leaf', 'INTERNALLOCATION', 'DISPENSE_DELIVER_TO_LOCATION', None),
 'LA1_2': ('leaf', 'AD', 'LOCATION', None),
 'LICENSENO': ('sequence', (('LICENSENO_1', (0, 1)), ('LICENSENO_2', (0, 1)))),
 'LICENSENO_1': ('leaf', 'ST', 'LICENSE_NUMBER', None),
 'LICENSENO_2': ('leaf', 'ST', 'ISSUING_STATE_PROVINCE_COUNTRY', None),
 'MOC': ('sequence', (('MOC_1', (0, 1)), ('MOC_2', (0, 1)))),
 'MOC_1': ('leaf', 'ST', 'DOLLAR_AMOUNT', None),
 'MOC_2': ('leaf', 'ST', 'CHARGE_CODE', None),
 'MSG': ('sequence', (('MSG_1', (0, 1)), ('MSG_2', (0, 1)))),
 'MSG_1': ('leaf', 'ID', 'MESSAGE_TYPE', None),
 'MSG_2': ('leaf', 'ID', 'TRIGGER_EVENT', None),
 'NDL': ('sequence',
         (('NDL_1', (0, 1)),
          ('NDL_2', (0, 1)),
          ('NDL_3', (0, 1)),
          ('NDL_4', (0, 1)))),
 'NDL_1': ('leaf', 'PERSON', 'INTERPRETER_TECHNICIAN', None),
 'NDL_2': ('leaf', 'TS', 'START_DATE_TIME', None),
 'NDL_3': ('leaf', 'TS', 'END_DATE_TIME', None),
 'NDL_4': ('leaf', 'INTERNALLOCATION', 'LOCATION', None),
 'OCD': ('sequence', (('OCD_1', (0, 1)), ('OCD_2', (0, 1)))),
 'OCD_1': ('leaf', 'ID', 'OCCURRENCE_CODE', None),
 'OCD_2': ('leaf', 'DT', 'OCCURRENCE_DATE', None),
 'OSP': ('sequence',
         (('OSP_1', (0, 1)), ('OSP_2', (0, 1)), ('OSP_3', (0, 1)))),
 'OSP_1': ('leaf', 'ID', 'OCCURRENCE_SPAN_CODE', None),
 'OSP_2': ('leaf', 'DT', 'OCCURRENCE_SPAN_START_DATE', None),
 'OSP_3': ('leaf', 'DT', 'OCCURRENCE_SPAN_STOP_DATE', None),
 'PATID': ('sequence',
           (('PATID_1', (0, 1)),
            ('PATID_2', (0, 1)),
            ('PATID_3', (0, 1)),
            ('PATID_4', (0, 1)),
            ('PATID_5', (0, 1)))),
 'PATID0192_1': ('leaf', 'ST', 'PATIENT_ID', None),
 'PATID0192_2': ('leaf', 'NM', 'CHECK_DIGIT', None),
 'PATID0192_3': ('leaf', 'ID', 'CHECK_DIGIT_SCHEME', None),
 'PATID0192_4': ('leaf', 'ID', 'FACILITY_ID', None),
 'PATID0192_5': ('leaf', 'ID', 'TYPE', None),
 'PATID_0192': ('sequence',
                (('PATID0192_1', (0, 1)),
                 ('PATID0192_2', (0, 1)),
                 ('PATID0192_3', (0, 1)),
                 ('PATID0192_4', (0, 1)),
                 ('PATID0192_5', (0, 1)))),
 'PATID_1': ('leaf', 'ST', 'PATIENT_ID', None),
 'PATID_2': ('leaf', 'NM', 'CHECK_DIGIT', None),
 'PATID_3': ('leaf', 'ID', 'CHECK_DIGIT_SCHEME', None),
 'PATID_4': ('leaf', 'ID', 'FACILITY_ID', None),
 'PATID_5': ('leaf', 'ID', 'TYPE', None),
 'PCF': ('sequence',
         (('PCF_1', (0, 1)), ('PCF_2', (0, 1)), ('PCF_3', (0, 1)))),
 'PCF_1': ('leaf', 'ID', 'PRE_CERTIFICATION_PATIENT_TYPE', None),
 'PCF_2': ('leaf', 'ID', 'PRE_CERTICATION_REQUIRED', None),
 'PCF_3': ('leaf', 'TS', 'PRE_CERTIFICATION_WINDOW', None),
 'PEN': ('sequence', (('PEN_1', (0, 1)), ('PEN_2', (0, 1)))),
 'PEN_1': ('leaf', 'ID', 'PENALTY_ID', None),
 'PEN_2': ('leaf', 'NM', 'PENALTY_AMOUNT', None),
 'PERSON': ('sequence',
            (('PERSON_1', (0, 1)),
             ('PERSON_2', (0, 1)),
             ('PERSON_3', (0, 1)),
             ('PERSON_4', (0, 1)),
             ('PERSON_5', (0, 1)),
             ('PERSON_6', (0, 1)),
             ('PERSON_7', (0, 1)),
             ('PERSON_8', (0, 1)))),
 'PERSON_1': ('leaf', 'ID', 'ID_NUMBER', None),
 'PERSON_2': ('leaf', 'ST', 'FAMILIY_NAME', None),
 'PERSON_3': ('leaf', 'ST', 'GIVEN_NAME', None),
 'PERSON_4': ('leaf', 'ST', 'MIDDLE_INITIAL_OR_NAME', None),
 'PERSON_5': ('leaf', 'ST', 'SUFFIX_E_G_JR_OR_III_', None),
 'PERSON_6': ('leaf', 'ST', 'PREFIX_E_G_DR_', None),
 'PERSON_7': ('leaf', 'ST', 'DEGREE_E_G_MD_', None),
 'PERSON_8': ('leaf', 'ID', 'SOURCE_TABLE_ID', None),
 'PHYSICIAN': ('sequence',
               (('PHYSICIAN_1', (0, 1)),
                ('PHYSICIAN_2', (0, 1)),
                ('PHYSICIAN_3', (0, 1)),
                ('PHYSICIAN_4', (0, 1)),
                ('PHYSICIAN_5', (0, 1)),
                ('PHYSICIAN_6', (0, 1)),
                ('PHYSICIAN_7', (0, 1)),
                ('PHYSICIAN_8', (0, 1)),
                ('PHYSICIAN_9', (0, 1)),
                ('PHYSICIAN_10', (0, 1)),
                ('PHYSICIAN_11', (0, 1)),
                ('PHYSICIAN_12', (0, 1)),
                ('PHYSICIAN_13', (0, 1)))),
 'PHYSICIAN_1': ('leaf', 'ID', 'PHYSICIAN_ID', None),
 'PHYSICIAN_10': ('leaf', 'TN', 'TELEFON', None),
 'PHYSICIAN_11': ('leaf', 'TN', 'FAXNUMMER', None),
 'PHYSICIAN_12': ('leaf', 'TN', 'ONLINE_NUMMER', None),
 'PHYSICIAN_13': ('leaf', 'ST', 'E_MAIL', None),
 'PHYSICIAN_2': ('leaf', 'ST', 'FAMILIY_NAME', None),
 'PHYSICIAN_3': ('leaf', 'ST', 'GIVEN_NAME', None),
 'PHYSICIAN_4': ('leaf', 'ST', 'MIDDLE_INITIAL_OR_NAME', None),
 'PHYSICIAN_5': ('leaf', 'ST', 'SUFFIX_E_G_JR_OR_III_', None),
 'PHYSICIAN_6': ('leaf', 'ST', 'PREFIX_E_G_DR_', None),
 'PHYSICIAN_7': ('leaf', 'ST', 'DEGREE_E_G_MD_', None),
 'PHYSICIAN_8': ('leaf', 'ID', 'SOURCE_TABLE_ID', None),
 'PHYSICIAN_9': ('leaf', 'AD', 'ADRESSE', None),
 'PIP': ('sequence',
         (('PIP_1', (0, 1)),
          ('PIP_2', (0, 1)),
          ('PIP_3', (0, 1)),
          ('PIP_4', (0, 1)))),
 'PIP_1': ('leaf', 'CE', 'PRIVILEGE', None),
 'PIP_2': ('leaf', 'CE', 'PRIVILEGE_CLASS', None),
 'PIP_3': ('leaf', 'DT', 'EXPIRATION_DATE', None),
 'PIP_4': ('leaf', 'DT', 'ACTIVATION_DATE', None),
 'PLACER': ('sequence', (('PLACER_1', (0, 1)), ('PLACER_2', (0, 1)))),
 'PLACER_1': ('leaf', 'ID', 'UNIQUE_PLACER_ID', None),
 'PLACER_2': ('leaf', 'ID', 'PLACER_APPLICATION', None),
 'PLN': ('sequence',
         (('PLN_1', (0, 1)), ('PLN_2', (0, 1)), ('PLN_3', (0, 1)))),
 'PLN_1': ('leaf', 'ST', 'ID_NUMBER', None),
 'PLN_2': ('leaf', 'ID', 'TYPE_OF_ID_NUMBER_ID_', None),
 'PLN_3': ('leaf', 'ST', 'STATE_OTHER_QUALIFIYING_INFO', None),
 'PN': ('sequence',
        (('PN_1', (0, 1)),
         ('PN_2', (0, 1)),
         ('PN_3', (0, 1)),
         ('PN_4', (0, 1)),
         ('PN_5', (0, 1)),
         ('PN_6', (0, 1)))),
 'PN_1': ('leaf', 'ST', 'FAMILIY_NAME', None),
 'PN_2': ('leaf', 'ST', 'GIVEN_NAME', None),
 'PN_3': ('leaf', 'ST', 'MIDDLE_INITIAL_OR_NAME', None),
 'PN_4': ('leaf', 'ST', 'SUFFIX_E_G_JR_OR_III_', None),
 'PN_5': ('leaf', 'ST', 'PREFIX_E_G_DR_', None),
 'PN_6': ('leaf', 'ST', 'DEGREE_E_G_MD_', None),
 'POSITION': ('sequence',
              (('POSITION_1', (0, 1)),
               ('POSITION_2', (0, 1)),
               ('POSITION_3', (0, 1)))),
 'POSITION_1': ('leaf', 'ST', 'SAAL', None),
 'POSITION_2': ('leaf', 'ST', 'TISCH', None),
 'POSITION_3': ('leaf', 'ST', 'STUHL', None),
 'PRACTITIONER': ('sequence',
                  (('PRACTITIONER_1', (0, 1)), ('PRACTITIONER_2', (0, 1)))),
 'PRACTITIONER_1': ('leaf', 'PERSON', 'PROCEDURE_PRACTITIONER_ID', None),
 'PRACTITIONER_2': ('leaf', 'ID', 'PROCEDURE_PRACTITIONER_TYPE', None),
 'PTA': ('sequence',
         (('PTA_1', (0, 1)), ('PTA_2', (0, 1)), ('PTA_3', (0, 1)))),
 'PTA_1': ('leaf', 'ID', 'POLICY_TYPE', None),
 'PTA_2': ('leaf', 'ID', 'AMOUNT_CLASS', None),
 'PTA_3': ('leaf', 'NM', 'AMOUNT', None),
 'QUANTITY': ('sequence', (('QUANTITY_1', (0, 1)), ('QUANTITY_2', (0, 1)))),
 'QUANTITY_1': ('leaf', 'ST', 'QUANTITY', None),
 'QUANTITY_2': ('leaf', 'ST', 'UNITS', None),
 'RANGE': ('sequence', (('RANGE_1', (0, 1)), ('RANGE_2', (0, 1)))),
 'RANGE_1': ('leaf', 'CE', 'LOW_VALUE', None),
 'RANGE_2': ('leaf', 'CE', 'HIGH_VALUE', None),
 'RFR': ('sequence',
         (('RFR_1', (0, 1)),
          ('RFR_2', (0, 1)),
          ('RFR_3', (0, 1)),
          ('RFR_4', (0, 1)),
          ('RFR_5', (0, 1)),
          ('RFR_6', (0, 1)),
          ('RFR_7', (0, 1)))),
 'RFR_1': ('leaf', 'CE', 'REFERENCE_RANGE', None),
 'RFR_2': ('leaf', 'ID', 'SEX', None),
 'RFR_3': ('leaf', 'CE', 'AGE_RANGE', None),
 'RFR_4': ('leaf', 'CE', 'GESTATIONAL_AGE_RANGE', None),
 'RFR_5': ('leaf', 'ST', 'SPECIES', None),
 'RFR_6': ('leaf', 'ID', 'RACE_SUBSPECIES', None),
 'RFR_7': ('leaf', 'ST', 'TEXT_CONDITION', None),
 'RI': ('sequence', (('RI_1', (0, 1)), ('RI_2', (0, 1)))),
 'RI_1': ('leaf', 'ST', 'REPEAT_PATTERN', None),
 'RI_2': ('leaf', 'ST', 'EXPLICIT_TIME_INTEVALL', None),
 'RMC': ('sequence',
         (('RMC_1', (0, 1)), ('RMC_2', (0, 1)), ('RMC_3', (0, 1)))),
 'RMC_1': ('leaf', 'ID', 'ROOM_TYPE', None),
 'RMC_2': ('leaf', 'ID', 'AMOUNT_TYPE', None),
 'RMC_3': ('leaf', 'NM', 'COVERAGE_AMOUNT', None),
 'SPD': ('sequence',
         (('SPD_1', (0, 1)),
          ('SPD_2', (0, 1)),
          ('SPD_3', (0, 1)),
          ('SPD_4', (0, 1)))),
 'SPD_1': ('leaf', 'ST', 'SPECIALTY_NAME', None),
 'SPD_2': ('leaf', 'ST', 'GOVERNING_BOARD', None),
 'SPD_3': ('leaf', 'ID', 'ELIGIBLE_OR_CERTIFIED', None),
 'SPD_4': ('leaf', 'DT', 'DATE_OF_CERTIFICATION', None),
 'SPS': ('sequence',
         (('SPS_1', (0, 1)),
          ('SPS_2', (0, 1)),
          ('SPS_3', (0, 1)),
          ('SPS_4', (0, 1)),
          ('SPS_5', (0, 1)))),
 'SPS_1': ('leaf', 'CE', 'SPECIMEN_SOURCE_NAME_OR_CODE', None),
 'SPS_2': ('leaf', 'TX', 'ADDITIVES', None),
 'SPS_3': ('leaf', 'TX', 'FREETEXT', None),
 'SPS_4': ('leaf', 'CE', 'BODY_SITE', None),
 'SPS_5': ('leaf', 'CE', 'SITE_MODIFIER', None),
 'TQ': ('sequence',
        (('TQ_1', (0, 1)),
         ('TQ_2', (0, 1)),
         ('TQ_3', (0, 1)),
         ('TQ_4', (0, 1)),
         ('TQ_5', (0, 1)),
         ('TQ_6', (0, 1)),
         ('TQ_7', (0, 1)),
         ('TQ_8', (0, 1)),
         ('TQ_9', (0, 1)),
         ('TQ_10', (0, 1)))),
 'TQ_1': ('leaf', 'QUANTITY', 'QUANTITY', None),
 'TQ_10': ('leaf', 'ST', 'ORDER_SEQUENCING', None),
 'TQ_2': ('leaf', 'RI', 'INTERVAL', None),
 'TQ_3': ('leaf', 'ST', 'DURATION', None),
 'TQ_4': ('leaf', 'TS', 'START_DATE_TIME', None),
 'TQ_5': ('leaf', 'TS', 'END_DATE_TIME', None),
 'TQ_6': ('leaf', 'ID', 'PRIORITY', None),
 'TQ_7': ('leaf', 'ST', 'CONDITION', None),
 'TQ_8': ('leaf', 'TX', 'TEXT_TX_', None),
 'TQ_9': ('leaf', 'ID', 'CONJUNCTION', None),
 'TS': ('sequence', (('TS_1', (0, 1)), ('TS_2', (0, 1)))),
 'TS_1': ('leaf', 'ST', 'TIME_OF_AN_EVENT', None),
 'TS_2': ('leaf', 'ST', 'DEGREE_OF_PRECISION', None),
 'UVC': ('sequence', (('UVC_1', (0, 1)), ('UVC_2', (0, 1)))),
 'UVC_1': ('leaf', 'ID', 'VALUE_CODE', None),
 'UVC_2': ('leaf', 'NM', 'VALUE_AMOUNT', None),
 'VARIES': None,
 'VR': ('sequence', (('VR_1', (0, 1)), ('VR_2', (0, 1)))),
 'VR_1': ('leaf', 'ST', 'FIRST_DATA_CODE_VALUE', None),
 'VR_2': ('leaf', 'ST', 'LAST_DATA_CODE_CALUE', None)}
