# -*- coding: utf-8 -*-
#
# Copyright (c) 2012-2014, CRS4
#
# Permission is hereby granted, free of charge, to any person obtaining a copy of
# this software and associated documentation files (the "Software"), to deal in
# the Software without restriction, including without limitation the rights to
# use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
# the Software, and to permit persons to whom the Software is furnished to do so,
# subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
# FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
# COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
# IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
# CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

FIELDS = {'ABS_1': ('leaf', 'XCN', 'DISCHARGE_CARE_PROVIDER', 'HL70010'),
 'ABS_10': ('leaf', 'ID', 'CAESARIAN_SECTION_INDICATOR', 'HL70136'),
 'ABS_11': ('leaf', 'CE', 'GESTATION_CATEGORY_CODE', 'HL70424'),
 'ABS_12': ('leaf', 'NM', 'GESTATION_PERIOD_WEEKS', 'HL70000'),
 'ABS_13': ('leaf', 'CE', 'NEWBORN_CODE', 'HL70425'),
 'ABS_14': ('leaf', 'ID', 'STILLBORN_INDICATOR', 'HL70136'),
 'ABS_2': ('leaf', 'CE', 'TRANSFER_MEDICAL_SERVICE_CODE', 'HL70069'),
 'ABS_3': ('leaf', 'CE', 'SEVERITY_OF_ILLNESS_CODE', 'HL70421'),
 'ABS_4': ('leaf', 'TS', 'DATE_TIME_OF_ATTESTATION', 'HL70000'),
 'ABS_5': ('leaf', 'XCN', 'ATTESTED_BY', 'HL70000'),
 'ABS_6': ('leaf', 'CE', 'TRIAGE_CODE', 'HL70422'),
 'ABS_7': ('leaf', 'TS', 'ABSTRACT_COMPLETION_DATE_TIME', 'HL70000'),
 'ABS_8': ('leaf', 'XCN', 'ABSTRACTED_BY', 'HL70000'),
 'ABS_9': ('leaf', 'CE', 'CASE_CATEGORY_CODE', 'HL70423'),
 'ACC_1': ('leaf', 'TS', 'ACCIDENT_DATE_TIME', 'HL70000'),
 'ACC_10': ('leaf', 'ID', 'POLICE_NOTIFIED_INDICATOR', 'HL70136'),
 'ACC_11': ('leaf', 'XAD', 'ACCIDENT_ADDRESS', 'HL70000'),
 'ACC_2': ('leaf', 'CE', 'ACCIDENT_CODE', 'HL70050'),
 'ACC_3': ('leaf', 'ST', 'ACCIDENT_LOCATION', 'HL70000'),
 'ACC_4': ('leaf', 'CE', 'AUTO_ACCIDENT_STATE', 'HL70347'),
 'ACC_5': ('leaf', 'ID', 'ACCIDENT_JOB_RELATED_INDICATOR', 'HL70136'),
 'ACC_6': ('leaf', 'ID', 'ACCIDENT_DEATH_INDICATOR', 'HL70136'),
 'ACC_7': ('leaf', 'XCN', 'ENTERED_BY', 'HL70000'),
 'ACC_8': ('leaf', 'ST', 'ACCIDENT_DESCRIPTION', 'HL70000'),
 'ACC_9': ('leaf', 'ST', 'BROUGHT_IN_BY', 'HL70000'),
 'ADD_1': ('leaf', 'ST', 'ADDENDUM_CONTINUATION_POINTER', 'HL70000'),
 'AFF_1': ('leaf', 'SI', 'SET_ID_AFF', 'HL70000'),
 'AFF_2': ('leaf', 'XON', 'PROFESSIONAL_ORGANIZATION', 'HL70000'),
 'AFF_3': ('leaf', 'XAD', 'PROFESSIONAL_ORGANIZATION_ADDRESS', 'HL70000'),
 'AFF_4': ('leaf',
           'DR',
           'PROFESSIONAL_ORGANIZATION_AFFILIATION_DATE_RANGE',
           'HL70000'),
 'AFF_5': ('leaf',
           'ST',
           'PROFESSIONAL_AFFILIATION_ADDITIONAL_INFORMATION',
           'HL70000'),
 'AIG_1': ('leaf', 'SI', 'SET_ID_AIG', 'HL70000'),
 'AIG_10': ('leaf', 'CE', 'START_DATE_TIME_OFFSET_UNITS', 'HL70000'),
 'AIG_11': ('leaf', 'NM', 'DURATION', 'HL70000'),
 'AIG_12': ('leaf', 'CE', 'DURATION_UNITS', 'HL70000'),
 'AIG_13': ('leaf', 'IS', 'ALLOW_SUBSTITUTION_CODE', 'HL70279'),
 'AIG_14': ('leaf', 'CE', 'FILLER_STATUS_CODE', 'HL70278'),
 'AIG_2': ('leaf', 'ID', 'SEGMENT_ACTION_CODE', 'HL70206'),
 'AIG_3': ('leaf', 'CE', 'RESOURCE_ID', 'HL70000'),
 'AIG_4': ('leaf', 'CE', 'RESOURCE_TYPE', 'HL70000'),
 'AIG_5': ('leaf', 'CE', 'RESOURCE_GROUP', 'HL70000'),
 'AIG_6': ('leaf', 'NM', 'RESOURCE_QUANTITY', 'HL70000'),
 'AIG_7': ('leaf', 'CE', 'RESOURCE_QUANTITY_UNITS', 'HL70000'),
 'AIG_8': ('leaf', 'TS', 'START_DATE_TIME', 'HL70000'),
 'AIG_9': ('leaf', 'NM', 'START_DATE_TIME_OFFSET', 'HL70000'),
 'AIL_1': ('leaf', 'SI', 'SET_ID_AIL', 'HL70000'),
 'AIL_10': ('leaf', 'CE', 'DURATION_UNITS', 'HL70000'),
 'AIL_11': ('leaf', 'IS', 'ALLOW_SUBSTITUTION_CODE', 'HL70279'),
 'AIL_12': ('leaf', 'CE', 'FILLER_STATUS_CODE', 'HL70278'),
 'AIL_2': ('leaf', 'ID', 'SEGMENT_ACTION_CODE', 'HL70206'),
 'AIL_3': ('leaf', 'PL', 'LOCATION_RESOURCE_ID', 'HL70000'),
 'AIL_4': ('leaf', 'CE', 'LOCATION_TYPE_AIL', 'HL70305'),
 'AIL_5': ('leaf', 'CE', 'LOCATION_GROUP', 'HL70000'),
 'AIL_6': ('leaf', 'TS', 'START_DATE_TIME', 'HL70000'),
 'AIL_7': ('leaf', 'NM', 'START_DATE_TIME_OFFSET', 'HL70000'),
 'AIL_8': ('leaf', 'CE', 'START_DATE_TIME_OFFSET_UNITS', 'HL70000'),
 'AIL_9': ('leaf', 'NM', 'DURATION', 'HL70000'),
 'AIP_1': ('leaf', 'SI', 'SET_ID_AIP', 'HL70000'),
 'AIP_10': ('leaf', 'CE', 'DURATION_UNITS', 'HL70000'),
 'AIP_11': ('leaf', 'IS', 'ALLOW_SUBSTITUTION_CODE', 'HL70279'),
 'AIP_12': ('leaf', 'CE', 'FILLER_STATUS_CODE', 'HL70278'),
 'AIP_2': ('leaf', 'ID', 'SEGMENT_ACTION_CODE', 'HL70206'),
 'AIP_3': ('leaf', 'XCN', 'PERSONNEL_RESOURCE_ID', 'HL70000'),
 'AIP_4': ('leaf', 'CE', 'RESOURCE_TYPE', 'HL70182'),
 'AIP_5': ('leaf', 'CE', 'RESOURCE_GROUP', 'HL70000'),
 'AIP_6': ('leaf', 'TS', 'START_DATE_TIME', 'HL70000'),
 'AIP_7': ('leaf', 'NM', 'START_DATE_TIME_OFFSET', 'HL70000'),
 'AIP_8': ('leaf', 'CE', 'START_DATE_TIME_OFFSET_UNITS', 'HL70000'),
 'AIP_9': ('leaf', 'NM', 'DURATION', 'HL70000'),
 'AIS_1': ('leaf', 'SI', 'SET_ID_AIS', 'HL70000'),
 'AIS_10': ('leaf', 'CE', 'FILLER_STATUS_CODE', 'HL70278'),
 'AIS_11': ('leaf',
            'CE',
            'PLACER_SUPPLEMENTAL_SERVICE_INFORMATION',
            'HL70411'),
 'AIS_12': ('leaf',
            'CE',
            'FILLER_SUPPLEMENTAL_SERVICE_INFORMATION',
            'HL70411'),
 'AIS_2': ('leaf', 'ID', 'SEGMENT_ACTION_CODE', 'HL70206'),
 'AIS_3': ('leaf', 'CE', 'UNIVERSAL_SERVICE_IDENTIFIER', 'HL70000'),
 'AIS_4': ('leaf', 'TS', 'START_DATE_TIME', 'HL70000'),
 'AIS_5': ('leaf', 'NM', 'START_DATE_TIME_OFFSET', 'HL70000'),
 'AIS_6': ('leaf', 'CE', 'START_DATE_TIME_OFFSET_UNITS', 'HL70000'),
 'AIS_7': ('leaf', 'NM', 'DURATION', 'HL70000'),
 'AIS_8': ('leaf', 'CE', 'DURATION_UNITS', 'HL70000'),
 'AIS_9': ('leaf', 'IS', 'ALLOW_SUBSTITUTION_CODE', 'HL70279'),
 'AL1_1': ('leaf', 'SI', 'SET_ID_AL1', 'HL70000'),
 'AL1_2': ('leaf', 'CE', 'ALLERGEN_TYPE_CODE', 'HL70127'),
 'AL1_3': ('leaf', 'CE', 'ALLERGEN_CODE_MNEMONIC_DESCRIPTION', 'HL70000'),
 'AL1_4': ('leaf', 'CE', 'ALLERGY_SEVERITY_CODE', 'HL70128'),
 'AL1_5': ('leaf', 'ST', 'ALLERGY_REACTION_CODE', 'HL70000'),
 'AL1_6': ('leaf', 'DT', 'IDENTIFICATION_DATE', 'HL70000'),
 'APR_1': ('leaf', 'SCV', 'TIME_SELECTION_CRITERIA', 'HL70294'),
 'APR_2': ('leaf', 'SCV', 'RESOURCE_SELECTION_CRITERIA', 'HL70294'),
 'APR_3': ('leaf', 'SCV', 'LOCATION_SELECTION_CRITERIA', 'HL70294'),
 'APR_4': ('leaf', 'NM', 'SLOT_SPACING_CRITERIA', 'HL70000'),
 'APR_5': ('leaf', 'SCV', 'FILLER_OVERRIDE_CRITERIA', 'HL70000'),
 'ARQ_1': ('leaf', 'EI', 'PLACER_APPOINTMENT_ID', 'HL70000'),
 'ARQ_10': ('leaf', 'CE', 'APPOINTMENT_DURATION_UNITS', 'HL70000'),
 'ARQ_11': ('leaf', 'DR', 'REQUESTED_START_DATE_TIME_RANGE', 'HL70000'),
 'ARQ_12': ('leaf', 'ST', 'PRIORITY_ARQ', 'HL70000'),
 'ARQ_13': ('leaf', 'RI', 'REPEATING_INTERVAL', 'HL70000'),
 'ARQ_14': ('leaf', 'ST', 'REPEATING_INTERVAL_DURATION', 'HL70000'),
 'ARQ_15': ('leaf', 'XCN', 'PLACER_CONTACT_PERSON', 'HL70000'),
 'ARQ_16': ('leaf', 'XTN', 'PLACER_CONTACT_PHONE_NUMBER', 'HL70000'),
 'ARQ_17': ('leaf', 'XAD', 'PLACER_CONTACT_ADDRESS', 'HL70000'),
 'ARQ_18': ('leaf', 'PL', 'PLACER_CONTACT_LOCATION', 'HL70000'),
 'ARQ_19': ('leaf', 'XCN', 'ENTERED_BY_PERSON', 'HL70000'),
 'ARQ_2': ('leaf', 'EI', 'FILLER_APPOINTMENT_ID', 'HL70000'),
 'ARQ_20': ('leaf', 'XTN', 'ENTERED_BY_PHONE_NUMBER', 'HL70000'),
 'ARQ_21': ('leaf', 'PL', 'ENTERED_BY_LOCATION', 'HL70000'),
 'ARQ_22': ('leaf', 'EI', 'PARENT_PLACER_APPOINTMENT_ID', 'HL70000'),
 'ARQ_23': ('leaf', 'EI', 'PARENT_FILLER_APPOINTMENT_ID', 'HL70000'),
 'ARQ_24': ('leaf', 'EI', 'PLACER_ORDER_NUMBER', 'HL70000'),
 'ARQ_25': ('leaf', 'EI', 'FILLER_ORDER_NUMBER', 'HL70000'),
 'ARQ_3': ('leaf', 'NM', 'OCCURRENCE_NUMBER', 'HL70000'),
 'ARQ_4': ('leaf', 'EI', 'PLACER_GROUP_NUMBER', 'HL70000'),
 'ARQ_5': ('leaf', 'CE', 'SCHEDULE_ID', 'HL70000'),
 'ARQ_6': ('leaf', 'CE', 'REQUEST_EVENT_REASON', 'HL70000'),
 'ARQ_7': ('leaf', 'CE', 'APPOINTMENT_REASON', 'HL70276'),
 'ARQ_8': ('leaf', 'CE', 'APPOINTMENT_TYPE', 'HL70277'),
 'ARQ_9': ('leaf', 'NM', 'APPOINTMENT_DURATION', 'HL70000'),
 'AUT_1': ('leaf', 'CE', 'AUTHORIZING_PAYOR_PLAN_ID', 'HL70072'),
 'AUT_10': ('leaf', 'TS', 'PROCESS_DATE', 'HL70000'),
 'AUT_2': ('leaf', 'CE', 'AUTHORIZING_PAYOR_COMPANY_ID', 'HL70285'),
 'AUT_3': ('leaf', 'ST', 'AUTHORIZING_PAYOR_COMPANY_NAME', 'HL70000'),
 'AUT_4': ('leaf', 'TS', 'AUTHORIZATION_EFFECTIVE_DATE', 'HL70000'),
 'AUT_5': ('leaf', 'TS', 'AUTHORIZATION_EXPIRATION_DATE', 'HL70000'),
 'AUT_6': ('leaf', 'EI', 'AUTHORIZATION_IDENTIFIER', 'HL70000'),
 'AUT_7': ('leaf', 'CP', 'REIMBURSEMENT_LIMIT', 'HL70000'),
 'AUT_8': ('leaf', 'NM', 'REQUESTED_NUMBER_OF_TREATMENTS', 'HL70000'),
 'AUT_9': ('leaf', 'NM', 'AUTHORIZED_NUMBER_OF_TREATMENTS', 'HL70000'),
 'BHS_1': ('leaf', 'ST', 'BATCH_FIELD_SEPARATOR', 'HL70000'),
 'BHS_10': ('leaf', 'ST', 'BATCH_COMMENT', 'HL70000'),
 'BHS_11': ('leaf', 'ST', 'BATCH_CONTROL_ID', 'HL70000'),
 'BHS_12': ('leaf', 'ST', 'REFERENCE_BATCH_CONTROL_ID', 'HL70000'),
 'BHS_2': ('leaf', 'ST', 'BATCH_ENCODING_CHARACTERS', 'HL70000'),
 'BHS_3': ('leaf', 'HD', 'BATCH_SENDING_APPLICATION', 'HL70000'),
 'BHS_4': ('leaf', 'HD', 'BATCH_SENDING_FACILITY', 'HL70000'),
 'BHS_5': ('leaf', 'HD', 'BATCH_RECEIVING_APPLICATION', 'HL70000'),
 'BHS_6': ('leaf', 'HD', 'BATCH_RECEIVING_FACILITY', 'HL70000'),
 'BHS_7': ('leaf', 'TS', 'BATCH_CREATION_DATE_TIME', 'HL70000'),
 'BHS_8': ('leaf', 'ST', 'BATCH_SECURITY', 'HL70000'),
 'BHS_9': ('leaf', 'ST', 'BATCH_NAME_ID_TYPE', 'HL70000'),
 'BLC_1': ('leaf', 'CE', 'BLOOD_PRODUCT_CODE', 'HL70426'),
 'BLC_2': ('leaf', 'CQ', 'BLOOD_AMOUNT', 'HL70000'),
 'BLG_1': ('leaf', 'CCD', 'WHEN_TO_CHARGE', 'HL70100'),
 'BLG_2': ('leaf', 'ID', 'CHARGE_TYPE', 'HL70122'),
 'BLG_3': ('leaf', 'CX', 'ACCOUNT_ID', 'HL70000'),
 'BLG_4': ('leaf', 'CWE', 'CHARGE_TYPE_REASON', 'HL70475'),
 'BPO_1': ('leaf', 'SI', 'SET_ID_BPO', 'HL70000'),
 'BPO_10': ('leaf', 'TS', 'BP_REQUESTED_DISPENSE_DATE_TIME', 'HL70000'),
 'BPO_11': ('leaf', 'PL', 'BP_REQUESTED_DISPENSE_TO_LOCATION', 'HL70000'),
 'BPO_12': ('leaf', 'XAD', 'BP_REQUESTED_DISPENSE_TO_ADDRESS', 'HL70000'),
 'BPO_13': ('leaf', 'CWE', 'BP_INDICATION_FOR_USE', 'HL70509'),
 'BPO_14': ('leaf', 'ID', 'BP_INFORMED_CONSENT_INDICATOR', 'HL70136'),
 'BPO_2': ('leaf', 'CWE', 'BP_UNIVERSAL_SERVICE_ID', 'HL70000'),
 'BPO_3': ('leaf', 'CWE', 'BP_PROCESSING_REQUIREMENTS', 'HL70508'),
 'BPO_4': ('leaf', 'NM', 'BP_QUANTITY', 'HL70000'),
 'BPO_5': ('leaf', 'NM', 'BP_AMOUNT', 'HL70000'),
 'BPO_6': ('leaf', 'CE', 'BP_UNITS', 'HL70000'),
 'BPO_7': ('leaf', 'TS', 'BP_INTENDED_USE_DATE_TIME', 'HL70000'),
 'BPO_8': ('leaf', 'PL', 'BP_INTENDED_DISPENSE_FROM_LOCATION', 'HL70000'),
 'BPO_9': ('leaf', 'XAD', 'BP_INTENDED_DISPENSE_FROM_ADDRESS', 'HL70000'),
 'BPX_1': ('leaf', 'SI', 'SET_ID_BPX', 'HL70000'),
 'BPX_10': ('leaf', 'EI', 'CP_LOT_NUMBER', 'HL70000'),
 'BPX_11': ('leaf', 'CNE', 'BP_BLOOD_GROUP', 'HL70000'),
 'BPX_12': ('leaf', 'CNE', 'BC_SPECIAL_TESTING', 'HL70000'),
 'BPX_13': ('leaf', 'TS', 'BP_EXPIRATION_DATE_TIME', 'HL70000'),
 'BPX_14': ('leaf', 'NM', 'BP_QUANTITY', 'HL70000'),
 'BPX_15': ('leaf', 'NM', 'BP_AMOUNT', 'HL70000'),
 'BPX_16': ('leaf', 'CE', 'BP_UNITS', 'HL70000'),
 'BPX_17': ('leaf', 'EI', 'BP_UNIQUE_ID', 'HL70000'),
 'BPX_18': ('leaf', 'PL', 'BP_ACTUAL_DISPENSED_TO_LOCATION', 'HL70000'),
 'BPX_19': ('leaf', 'XAD', 'BP_ACTUAL_DISPENSED_TO_ADDRESS', 'HL70000'),
 'BPX_2': ('leaf', 'CWE', 'BP_DISPENSE_STATUS', 'HL70510'),
 'BPX_20': ('leaf', 'XCN', 'BP_DISPENSED_TO_RECEIVER', 'HL70000'),
 'BPX_21': ('leaf', 'XCN', 'BP_DISPENSING_INDIVIDUAL', 'HL70000'),
 'BPX_3': ('leaf', 'ID', 'BP_STATUS', 'HL70511'),
 'BPX_4': ('leaf', 'TS', 'BP_DATE_TIME_OF_STATUS', 'HL70000'),
 'BPX_5': ('leaf', 'EI', 'BC_DONATION_ID', 'HL70000'),
 'BPX_6': ('leaf', 'CNE', 'BC_COMPONENT', 'HL70000'),
 'BPX_7': ('leaf', 'CNE', 'BC_DONATION_TYPE_INTENDED_USE', 'HL70000'),
 'BPX_8': ('leaf', 'CWE', 'CP_COMMERCIAL_PRODUCT', 'HL70512'),
 'BPX_9': ('leaf', 'XON', 'CP_MANUFACTURER', 'HL70000'),
 'BTS_1': ('leaf', 'ST', 'BATCH_MESSAGE_COUNT', 'HL70000'),
 'BTS_2': ('leaf', 'ST', 'BATCH_COMMENT', 'HL70000'),
 'BTS_3': ('leaf', 'NM', 'BATCH_TOTALS', 'HL70000'),
 'BTX_1': ('leaf', 'SI', 'SET_ID_BTX', 'HL70000'),
 'BTX_10': ('leaf', 'CE', 'BP_UNITS', 'HL70000'),
 'BTX_11': ('leaf', 'CWE', 'BP_TRANSFUSION_DISPOSITION_STATUS', 'HL70513'),
 'BTX_12': ('leaf', 'ID', 'BP_MESSAGE_STATUS', 'HL70511'),
 'BTX_13': ('leaf', 'TS', 'BP_DATE_TIME_OF_STATUS', 'HL70000'),
 'BTX_14': ('leaf', 'XCN', 'BP_ADMINISTRATOR', 'HL70000'),
 'BTX_15': ('leaf', 'XCN', 'BP_VERIFIER', 'HL70000'),
 'BTX_16': ('leaf',
            'TS',
            'BP_TRANSFUSION_START_DATE_TIME_OF_STATUS',
            'HL70000'),
 'BTX_17': ('leaf', 'TS', 'BP_TRANSFUSION_END_DATE_TIME_OF_STATUS', 'HL70000'),
 'BTX_18': ('leaf', 'CWE', 'BP_ADVERSE_REACTION_TYPE', 'HL70514'),
 'BTX_19': ('leaf', 'CWE', 'BP_TRANSFUSION_INTERRUPTED_REASON', 'HL70515'),
 'BTX_2': ('leaf', 'EI', 'BC_DONATION_ID', 'HL70000'),
 'BTX_3': ('leaf', 'CNE', 'BC_COMPONENT', 'HL70000'),
 'BTX_4': ('leaf', 'CNE', 'BC_BLOOD_GROUP', 'HL70000'),
 'BTX_5': ('leaf', 'CWE', 'CP_COMMERCIAL_PRODUCT', 'HL70512'),
 'BTX_6': ('leaf', 'XON', 'CP_MANUFACTURER', 'HL70000'),
 'BTX_7': ('leaf', 'EI', 'CP_LOT_NUMBER', 'HL70000'),
 'BTX_8': ('leaf', 'NM', 'BP_QUANTITY', 'HL70000'),
 'BTX_9': ('leaf', 'NM', 'BP_AMOUNT', 'HL70000'),
 'CDM_1': ('leaf', 'CE', 'PRIMARY_KEY_VALUE_CDM', 'HL70132'),
 'CDM_10': ('leaf', 'NM', 'RESOURCE_LOAD', 'HL70000'),
 'CDM_11': ('leaf', 'CX', 'CONTRACT_NUMBER', 'HL70000'),
 'CDM_12': ('leaf', 'XON', 'CONTRACT_ORGANIZATION', 'HL70000'),
 'CDM_13': ('leaf', 'ID', 'ROOM_FEE_INDICATOR', 'HL70136'),
 'CDM_2': ('leaf', 'CE', 'CHARGE_CODE_ALIAS', 'HL70000'),
 'CDM_3': ('leaf', 'ST', 'CHARGE_DESCRIPTION_SHORT', 'HL70000'),
 'CDM_4': ('leaf', 'ST', 'CHARGE_DESCRIPTION_LONG', 'HL70000'),
 'CDM_5': ('leaf', 'IS', 'DESCRIPTION_OVERRIDE_INDICATOR', 'HL70268'),
 'CDM_6': ('leaf', 'CE', 'EXPLODING_CHARGES', 'HL70000'),
 'CDM_7': ('leaf', 'CE', 'PROCEDURE_CODE', 'HL70088'),
 'CDM_8': ('leaf', 'ID', 'ACTIVE_INACTIVE_FLAG', 'HL70183'),
 'CDM_9': ('leaf', 'CE', 'INVENTORY_NUMBER', 'HL70463'),
 'CER_1': ('leaf', 'SI', 'SET_ID_CER', 'HL70000'),
 'CER_10': ('leaf', 'CWE', 'CERTIFICATE_TYPE', 'HL70000'),
 'CER_11': ('leaf', 'CWE', 'CERTIFICATE_DOMAIN', 'HL70000'),
 'CER_12': ('leaf', 'ID', 'SUBJECT_ID', 'HL70000'),
 'CER_13': ('leaf', 'ST', 'SUBJECT_NAME', 'HL70000'),
 'CER_14': ('leaf',
            'CWE',
            'SUBJECT_DIRECTORY_ATTRIBUTE_EXTENSION_HEALTH_PROFESSIONAL_DATA_',
            'HL70000'),
 'CER_15': ('leaf', 'CWE', 'SUBJECT_PUBLIC_KEY_INFO', 'HL70000'),
 'CER_16': ('leaf', 'CWE', 'AUTHORITY_KEY_IDENTIFIER', 'HL70000'),
 'CER_17': ('leaf', 'ID', 'BASIC_CONSTRAINT', 'HL70136'),
 'CER_18': ('leaf', 'CWE', 'CRL_DISTRIBUTION_POINT', 'HL70000'),
 'CER_19': ('leaf', 'ID', 'JURISDICTION_COUNTRY', 'HL70399'),
 'CER_2': ('leaf', 'ST', 'SERIAL_NUMBER', 'HL70000'),
 'CER_20': ('leaf', 'CWE', 'JURISDICTION_STATE_PROVINCE', 'HL70347'),
 'CER_21': ('leaf', 'CWE', 'JURISDICTION_COUNTY_PARISH', 'HL70289'),
 'CER_22': ('leaf', 'CWE', 'JURISDICTION_BREADTH', 'HL70547'),
 'CER_23': ('leaf', 'TS', 'GRANTING_DATE', 'HL70000'),
 'CER_24': ('leaf', 'TS', 'ISSUING_DATE', 'HL70000'),
 'CER_25': ('leaf', 'TS', 'ACTIVATION_DATE', 'HL70000'),
 'CER_26': ('leaf', 'TS', 'INACTIVATION_DATE', 'HL70000'),
 'CER_27': ('leaf', 'TS', 'EXPIRATION_DATE', 'HL70000'),
 'CER_28': ('leaf', 'TS', 'RENEWAL_DATE', 'HL70000'),
 'CER_29': ('leaf', 'TS', 'REVOCATION_DATE', 'HL70000'),
 'CER_3': ('leaf', 'ST', 'VERSION', 'HL70000'),
 'CER_30': ('leaf', 'CE', 'REVOCATION_REASON_CODE', 'HL70000'),
 'CER_31': ('leaf', 'CWE', 'CERTIFICATE_STATUS', 'HL70536'),
 'CER_4': ('leaf', 'XON', 'GRANTING_AUTHORITY', 'HL70000'),
 'CER_5': ('leaf', 'XCN', 'ISSUING_AUTHORITY', 'HL70000'),
 'CER_6': ('leaf', 'ED', 'SIGNATURE_OF_ISSUING_AUTHORITY', 'HL70000'),
 'CER_7': ('leaf', 'ID', 'GRANTING_COUNTRY', 'HL70399'),
 'CER_8': ('leaf', 'CWE', 'GRANTING_STATE_PROVINCE', 'HL70347'),
 'CER_9': ('leaf', 'CWE', 'GRANTING_COUNTY_PARISH', 'HL70289'),
 'CM0_1': ('leaf', 'SI', 'SET_ID_CM0', 'HL70000'),
 'CM0_10': ('leaf', 'XTN', 'CONTACT_S_TELEPHONE_NUMBER', 'HL70000'),
 'CM0_11': ('leaf', 'XAD', 'CONTACT_S_ADDRESS', 'HL70000'),
 'CM0_2': ('leaf', 'EI', 'SPONSOR_STUDY_ID', 'HL70000'),
 'CM0_3': ('leaf', 'EI', 'ALTERNATE_STUDY_ID', 'HL70000'),
 'CM0_4': ('leaf', 'ST', 'TITLE_OF_STUDY', 'HL70000'),
 'CM0_5': ('leaf', 'XCN', 'CHAIRMAN_OF_STUDY', 'HL70000'),
 'CM0_6': ('leaf', 'DT', 'LAST_IRB_APPROVAL_DATE', 'HL70000'),
 'CM0_7': ('leaf', 'NM', 'TOTAL_ACCRUAL_TO_DATE', 'HL70000'),
 'CM0_8': ('leaf', 'DT', 'LAST_ACCRUAL_DATE', 'HL70000'),
 'CM0_9': ('leaf', 'XCN', 'CONTACT_FOR_STUDY', 'HL70000'),
 'CM1_1': ('leaf', 'SI', 'SET_ID_CM1', 'HL70000'),
 'CM1_2': ('leaf', 'CE', 'STUDY_PHASE_IDENTIFIER', 'HL70000'),
 'CM1_3': ('leaf', 'ST', 'DESCRIPTION_OF_STUDY_PHASE', 'HL70000'),
 'CM2_1': ('leaf', 'SI', 'SET_ID_CM2', 'HL70000'),
 'CM2_2': ('leaf', 'CE', 'SCHEDULED_TIME_POINT', 'HL70000'),
 'CM2_3': ('leaf', 'ST', 'DESCRIPTION_OF_TIME_POINT', 'HL70000'),
 'CM2_4': ('leaf', 'CE', 'EVENTS_SCHEDULED_THIS_TIME_POINT', 'HL70000'),
 'CNS_1': ('leaf', 'NM', 'STARTING_NOTIFICATION_REFERENCE_NUMBER', 'HL70000'),
 'CNS_2': ('leaf', 'NM', 'ENDING_NOTIFICATION_REFERENCE_NUMBER', 'HL70000'),
 'CNS_3': ('leaf', 'TS', 'STARTING_NOTIFICATION_DATE_TIME', 'HL70000'),
 'CNS_4': ('leaf', 'TS', 'ENDING_NOTIFICATION_DATE_TIME', 'HL70000'),
 'CNS_5': ('leaf', 'CE', 'STARTING_NOTIFICATION_CODE', 'HL70000'),
 'CNS_6': ('leaf', 'CE', 'ENDING_NOTIFICATION_CODE', 'HL70000'),
 'CON_1': ('leaf', 'SI', 'SET_ID_CON', 'HL70000'),
 'CON_10': ('leaf', 'CNE', 'CONSENT_MODE', 'HL70497'),
 'CON_11': ('leaf', 'CNE', 'CONSENT_STATUS', 'HL70498'),
 'CON_12': ('leaf', 'TS', 'CONSENT_DISCUSSION_DATE_TIME', 'HL70000'),
 'CON_13': ('leaf', 'TS', 'CONSENT_DECISION_DATE_TIME', 'HL70000'),
 'CON_14': ('leaf', 'TS', 'CONSENT_EFFECTIVE_DATE_TIME', 'HL70000'),
 'CON_15': ('leaf', 'TS', 'CONSENT_END_DATE_TIME', 'HL70000'),
 'CON_16': ('leaf', 'ID', 'SUBJECT_COMPETENCE_INDICATOR', 'HL70136'),
 'CON_17': ('leaf', 'ID', 'TRANSLATOR_ASSISTANCE_INDICATOR', 'HL70136'),
 'CON_18': ('leaf', 'ID', 'LANGUAGE_TRANSLATED_TO', 'HL70296'),
 'CON_19': ('leaf',
            'ID',
            'INFORMATIONAL_MATERIAL_SUPPLIED_INDICATOR',
            'HL70136'),
 'CON_2': ('leaf', 'CWE', 'CONSENT_TYPE', 'HL70496'),
 'CON_20': ('leaf', 'CWE', 'CONSENT_BYPASS_REASON', 'HL70499'),
 'CON_21': ('leaf', 'ID', 'CONSENT_DISCLOSURE_LEVEL', 'HL70500'),
 'CON_22': ('leaf', 'CWE', 'CONSENT_NON_DISCLOSURE_REASON', 'HL70501'),
 'CON_23': ('leaf', 'CWE', 'NON_SUBJECT_CONSENTER_REASON', 'HL70502'),
 'CON_24': ('leaf', 'XPN', 'CONSENTER_ID', 'HL70000'),
 'CON_25': ('leaf', 'IS', 'RELATIONSHIP_TO_SUBJECT_TABLE', 'HL70548'),
 'CON_3': ('leaf', 'ST', 'CONSENT_FORM_ID', 'HL70000'),
 'CON_4': ('leaf', 'EI', 'CONSENT_FORM_NUMBER', 'HL70000'),
 'CON_5': ('leaf', 'FT', 'CONSENT_TEXT', 'HL70000'),
 'CON_6': ('leaf', 'FT', 'SUBJECT_SPECIFIC_CONSENT_TEXT', 'HL70000'),
 'CON_7': ('leaf', 'FT', 'CONSENT_BACKGROUND', 'HL70000'),
 'CON_8': ('leaf', 'FT', 'SUBJECT_SPECIFIC_CONSENT_BACKGROUND', 'HL70000'),
 'CON_9': ('leaf', 'FT', 'CONSENTER_IMPOSED_LIMITATIONS', 'HL70000'),
 'CSP_1': ('leaf', 'CE', 'STUDY_PHASE_IDENTIFIER', 'HL70000'),
 'CSP_2': ('leaf', 'TS', 'DATE_TIME_STUDY_PHASE_BEGAN', 'HL70000'),
 'CSP_3': ('leaf', 'TS', 'DATE_TIME_STUDY_PHASE_ENDED', 'HL70000'),
 'CSP_4': ('leaf', 'CE', 'STUDY_PHASE_EVALUABILITY', 'HL70000'),
 'CSR_1': ('leaf', 'EI', 'SPONSOR_STUDY_ID', 'HL70000'),
 'CSR_10': ('leaf', 'CE', 'PATIENT_STUDY_ELIGIBILITY_STATUS', 'HL70000'),
 'CSR_11': ('leaf', 'TS', 'STUDY_RANDOMIZATION_DATE_TIME', 'HL70000'),
 'CSR_12': ('leaf', 'CE', 'RANDOMIZED_STUDY_ARM', 'HL70000'),
 'CSR_13': ('leaf', 'CE', 'STRATUM_FOR_STUDY_RANDOMIZATION', 'HL70000'),
 'CSR_14': ('leaf', 'CE', 'PATIENT_EVALUABILITY_STATUS', 'HL70000'),
 'CSR_15': ('leaf', 'TS', 'DATE_TIME_ENDED_STUDY', 'HL70000'),
 'CSR_16': ('leaf', 'CE', 'REASON_ENDED_STUDY', 'HL70000'),
 'CSR_2': ('leaf', 'EI', 'ALTERNATE_STUDY_ID', 'HL70000'),
 'CSR_3': ('leaf', 'CE', 'INSTITUTION_REGISTERING_THE_PATIENT', 'HL70000'),
 'CSR_4': ('leaf', 'CX', 'SPONSOR_PATIENT_ID', 'HL70000'),
 'CSR_5': ('leaf', 'CX', 'ALTERNATE_PATIENT_ID_CSR', 'HL70000'),
 'CSR_6': ('leaf', 'TS', 'DATE_TIME_OF_PATIENT_STUDY_REGISTRATION', 'HL70000'),
 'CSR_7': ('leaf', 'XCN', 'PERSON_PERFORMING_STUDY_REGISTRATION', 'HL70000'),
 'CSR_8': ('leaf', 'XCN', 'STUDY_AUTHORIZING_PROVIDER', 'HL70000'),
 'CSR_9': ('leaf', 'TS', 'DATE_TIME_PATIENT_STUDY_CONSENT_SIGNED', 'HL70000'),
 'CSS_1': ('leaf', 'CE', 'STUDY_SCHEDULED_TIME_POINT', 'HL70000'),
 'CSS_2': ('leaf', 'TS', 'STUDY_SCHEDULED_PATIENT_TIME_POINT', 'HL70000'),
 'CSS_3': ('leaf', 'CE', 'STUDY_QUALITY_CONTROL_CODES', 'HL70000'),
 'CTD_1': ('leaf', 'CE', 'CONTACT_ROLE', 'HL70131'),
 'CTD_2': ('leaf', 'XPN', 'CONTACT_NAME', 'HL70000'),
 'CTD_3': ('leaf', 'XAD', 'CONTACT_ADDRESS', 'HL70000'),
 'CTD_4': ('leaf', 'PL', 'CONTACT_LOCATION', 'HL70000'),
 'CTD_5': ('leaf', 'XTN', 'CONTACT_COMMUNICATION_INFORMATION', 'HL70000'),
 'CTD_6': ('leaf', 'CE', 'PREFERRED_METHOD_OF_CONTACT', 'HL70185'),
 'CTD_7': ('leaf', 'PLN', 'CONTACT_IDENTIFIERS', 'HL70000'),
 'CTI_1': ('leaf', 'EI', 'SPONSOR_STUDY_ID', 'HL70000'),
 'CTI_2': ('leaf', 'CE', 'STUDY_PHASE_IDENTIFIER', 'HL70000'),
 'CTI_3': ('leaf', 'CE', 'STUDY_SCHEDULED_TIME_POINT', 'HL70000'),
 'DB1_1': ('leaf', 'SI', 'SET_ID_DB1', 'HL70000'),
 'DB1_2': ('leaf', 'IS', 'DISABLED_PERSON_CODE', 'HL70334'),
 'DB1_3': ('leaf', 'CX', 'DISABLED_PERSON_IDENTIFIER', 'HL70000'),
 'DB1_4': ('leaf', 'ID', 'DISABLED_INDICATOR', 'HL70136'),
 'DB1_5': ('leaf', 'DT', 'DISABILITY_START_DATE', 'HL70000'),
 'DB1_6': ('leaf', 'DT', 'DISABILITY_END_DATE', 'HL70000'),
 'DB1_7': ('leaf', 'DT', 'DISABILITY_RETURN_TO_WORK_DATE', 'HL70000'),
 'DB1_8': ('leaf', 'DT', 'DISABILITY_UNABLE_TO_WORK_DATE', 'HL70000'),
 'DG1_1': ('leaf', 'SI', 'SET_ID_DG1', 'HL70000'),
 'DG1_10': ('leaf', 'IS', 'DRG_GROUPER_REVIEW_CODE', 'HL70056'),
 'DG1_11': ('leaf', 'CE', 'OUTLIER_TYPE', 'HL70083'),
 'DG1_12': ('leaf', 'NM', 'OUTLIER_DAYS', 'HL70000'),
 'DG1_13': ('leaf', 'CP', 'OUTLIER_COST', 'HL70000'),
 'DG1_14': ('leaf', 'ST', 'GROUPER_VERSION_AND_TYPE', 'HL70000'),
 'DG1_15': ('leaf', 'ID', 'DIAGNOSIS_PRIORITY', 'HL70359'),
 'DG1_16': ('leaf', 'XCN', 'DIAGNOSING_CLINICIAN', 'HL70000'),
 'DG1_17': ('leaf', 'IS', 'DIAGNOSIS_CLASSIFICATION', 'HL70228'),
 'DG1_18': ('leaf', 'ID', 'CONFIDENTIAL_INDICATOR', 'HL70136'),
 'DG1_19': ('leaf', 'TS', 'ATTESTATION_DATE_TIME', 'HL70000'),
 'DG1_2': ('leaf', 'ID', 'DIAGNOSIS_CODING_METHOD', 'HL70053'),
 'DG1_20': ('leaf', 'EI', 'DIAGNOSIS_IDENTIFIER', 'HL70000'),
 'DG1_21': ('leaf', 'ID', 'DIAGNOSIS_ACTION_CODE', 'HL70206'),
 'DG1_3': ('leaf', 'CE', 'DIAGNOSIS_CODE_DG1', 'HL70051'),
 'DG1_4': ('leaf', 'ST', 'DIAGNOSIS_DESCRIPTION', 'HL70000'),
 'DG1_5': ('leaf', 'TS', 'DIAGNOSIS_DATE_TIME', 'HL70000'),
 'DG1_6': ('leaf', 'IS', 'DIAGNOSIS_TYPE', 'HL70052'),
 'DG1_7': ('leaf', 'CE', 'MAJOR_DIAGNOSTIC_CATEGORY', 'HL70118'),
 'DG1_8': ('leaf', 'CE', 'DIAGNOSTIC_RELATED_GROUP', 'HL70055'),
 'DG1_9': ('leaf', 'ID', 'DRG_APPROVAL_INDICATOR', 'HL70136'),
 'DRG_1': ('leaf', 'CE', 'DIAGNOSTIC_RELATED_GROUP', 'HL70055'),
 'DRG_10': ('leaf', 'ID', 'CONFIDENTIAL_INDICATOR', 'HL70136'),
 'DRG_11': ('leaf', 'IS', 'DRG_TRANSFER_TYPE', 'HL70415'),
 'DRG_2': ('leaf', 'TS', 'DRG_ASSIGNED_DATE_TIME', 'HL70000'),
 'DRG_3': ('leaf', 'ID', 'DRG_APPROVAL_INDICATOR', 'HL70136'),
 'DRG_4': ('leaf', 'IS', 'DRG_GROUPER_REVIEW_CODE', 'HL70056'),
 'DRG_5': ('leaf', 'CE', 'OUTLIER_TYPE', 'HL70083'),
 'DRG_6': ('leaf', 'NM', 'OUTLIER_DAYS', 'HL70000'),
 'DRG_7': ('leaf', 'CP', 'OUTLIER_COST', 'HL70000'),
 'DRG_8': ('leaf', 'IS', 'DRG_PAYOR', 'HL70229'),
 'DRG_9': ('leaf', 'CP', 'OUTLIER_REIMBURSEMENT', 'HL70000'),
 'DSC_1': ('leaf', 'ST', 'CONTINUATION_POINTER', 'HL70000'),
 'DSC_2': ('leaf', 'ID', 'CONTINUATION_STYLE', 'HL70398'),
 'DSP_1': ('leaf', 'SI', 'SET_ID_DSP', 'HL70000'),
 'DSP_2': ('leaf', 'SI', 'DISPLAY_LEVEL', 'HL70000'),
 'DSP_3': ('leaf', 'TX', 'DATA_LINE', 'HL70000'),
 'DSP_4': ('leaf', 'ST', 'LOGICAL_BREAK_POINT', 'HL70000'),
 'DSP_5': ('leaf', 'TX', 'RESULT_ID', 'HL70000'),
 'ECD_1': ('leaf', 'NM', 'REFERENCE_COMMAND_NUMBER', 'HL70000'),
 'ECD_2': ('leaf', 'CE', 'REMOTE_CONTROL_COMMAND', 'HL70368'),
 'ECD_3': ('leaf', 'ID', 'RESPONSE_REQUIRED', 'HL70136'),
 'ECD_4': ('leaf', 'TQ', 'REQUESTED_COMPLETION_TIME', 'HL70000'),
 'ECD_5': ('leaf', 'TX', 'PARAMETERS', 'HL70000'),
 'ECR_1': ('leaf', 'CE', 'COMMAND_RESPONSE', 'HL70387'),
 'ECR_2': ('leaf', 'TS', 'DATE_TIME_COMPLETED', 'HL70000'),
 'ECR_3': ('leaf', 'TX', 'COMMAND_RESPONSE_PARAMETERS', 'HL70000'),
 'EDU_1': ('leaf', 'SI', 'SET_ID_EDU', 'HL70000'),
 'EDU_2': ('leaf', 'IS', 'ACADEMIC_DEGREE', 'HL70360'),
 'EDU_3': ('leaf', 'DR', 'ACADEMIC_DEGREE_PROGRAM_DATE_RANGE', 'HL70000'),
 'EDU_4': ('leaf',
           'DR',
           'ACADEMIC_DEGREE_PROGRAM_PARTICIPATION_DATE_RANGE',
           'HL70000'),
 'EDU_5': ('leaf', 'DT', 'ACADEMIC_DEGREE_GRANTED_DATE', 'HL70000'),
 'EDU_6': ('leaf', 'XON', 'SCHOOL', 'HL70000'),
 'EDU_7': ('leaf', 'CE', 'SCHOOL_TYPE_CODE', 'HL70402'),
 'EDU_8': ('leaf', 'XAD', 'SCHOOL_ADDRESS', 'HL70000'),
 'EDU_9': ('leaf', 'CWE', 'MAJOR_FIELD_OF_STUDY', 'HL70000'),
 'EQL_1': ('leaf', 'ST', 'QUERY_TAG', 'HL70000'),
 'EQL_2': ('leaf', 'ID', 'QUERY_RESPONSE_FORMAT_CODE', 'HL70106'),
 'EQL_3': ('leaf', 'CE', 'EQL_QUERY_NAME', 'HL70000'),
 'EQL_4': ('leaf', 'ST', 'EQL_QUERY_STATEMENT', 'HL70000'),
 'EQP_1': ('leaf', 'CE', 'EVENT_TYPE', 'HL70450'),
 'EQP_2': ('leaf', 'ST', 'FILE_NAME', 'HL70000'),
 'EQP_3': ('leaf', 'TS', 'START_DATE_TIME', 'HL70000'),
 'EQP_4': ('leaf', 'TS', 'END_DATE_TIME', 'HL70000'),
 'EQP_5': ('leaf', 'FT', 'TRANSACTION_DATA', 'HL70000'),
 'EQU_1': ('leaf', 'EI', 'EQUIPMENT_INSTANCE_IDENTIFIER', 'HL70000'),
 'EQU_2': ('leaf', 'TS', 'EVENT_DATE_TIME', 'HL70000'),
 'EQU_3': ('leaf', 'CE', 'EQUIPMENT_STATE', 'HL70365'),
 'EQU_4': ('leaf', 'CE', 'LOCAL_REMOTE_CONTROL_STATE', 'HL70366'),
 'EQU_5': ('leaf', 'CE', 'ALERT_LEVEL', 'HL70367'),
 'ERQ_1': ('leaf', 'ST', 'QUERY_TAG', 'HL70000'),
 'ERQ_2': ('leaf', 'CE', 'EVENT_IDENTIFIER', 'HL70000'),
 'ERQ_3': ('leaf', 'QIP', 'INPUT_PARAMETER_LIST', 'HL70000'),
 'ERR_1': ('leaf', 'ELD', 'ERROR_CODE_AND_LOCATION', 'HL70000'),
 'ERR_10': ('leaf', 'CWE', 'OVERRIDE_TYPE', 'HL70518'),
 'ERR_11': ('leaf', 'CWE', 'OVERRIDE_REASON_CODE', 'HL70519'),
 'ERR_12': ('leaf', 'XTN', 'HELP_DESK_CONTACT_POINT', 'HL70000'),
 'ERR_2': ('leaf', 'ERL', 'ERROR_LOCATION', 'HL70000'),
 'ERR_3': ('leaf', 'CWE', 'HL7_ERROR_CODE', 'HL70357'),
 'ERR_4': ('leaf', 'ID', 'SEVERITY', 'HL70516'),
 'ERR_5': ('leaf', 'CWE', 'APPLICATION_ERROR_CODE', 'HL70533'),
 'ERR_6': ('leaf', 'ST', 'APPLICATION_ERROR_PARAMETER', 'HL70000'),
 'ERR_7': ('leaf', 'TX', 'DIAGNOSTIC_INFORMATION', 'HL70000'),
 'ERR_8': ('leaf', 'TX', 'USER_MESSAGE', 'HL70000'),
 'ERR_9': ('leaf', 'IS', 'INFORM_PERSON_INDICATOR', 'HL70517'),
 'EVN_1': ('leaf', 'ID', 'EVENT_TYPE_CODE', 'HL70003'),
 'EVN_2': ('leaf', 'TS', 'RECORDED_DATE_TIME', 'HL70000'),
 'EVN_3': ('leaf', 'TS', 'DATE_TIME_PLANNED_EVENT', 'HL70000'),
 'EVN_4': ('leaf', 'IS', 'EVENT_REASON_CODE', 'HL70062'),
 'EVN_5': ('leaf', 'XCN', 'OPERATOR_ID', 'HL70188'),
 'EVN_6': ('leaf', 'TS', 'EVENT_OCCURRED', 'HL70000'),
 'EVN_7': ('leaf', 'HD', 'EVENT_FACILITY', 'HL70000'),
 'FAC_1': ('leaf', 'EI', 'FACILITY_ID_FAC', 'HL70000'),
 'FAC_10': ('leaf', 'ST', 'SIGNATURE_AUTHORITY_TITLE', 'HL70000'),
 'FAC_11': ('leaf', 'XAD', 'SIGNATURE_AUTHORITY_ADDRESS', 'HL70000'),
 'FAC_12': ('leaf', 'XTN', 'SIGNATURE_AUTHORITY_TELECOMMUNICATION', 'HL70000'),
 'FAC_2': ('leaf', 'ID', 'FACILITY_TYPE', 'HL70331'),
 'FAC_3': ('leaf', 'XAD', 'FACILITY_ADDRESS', 'HL70000'),
 'FAC_4': ('leaf', 'XTN', 'FACILITY_TELECOMMUNICATION', 'HL70000'),
 'FAC_5': ('leaf', 'XCN', 'CONTACT_PERSON', 'HL70000'),
 'FAC_6': ('leaf', 'ST', 'CONTACT_TITLE', 'HL70000'),
 'FAC_7': ('leaf', 'XAD', 'CONTACT_ADDRESS', 'HL70000'),
 'FAC_8': ('leaf', 'XTN', 'CONTACT_TELECOMMUNICATION', 'HL70000'),
 'FAC_9': ('leaf', 'XCN', 'SIGNATURE_AUTHORITY', 'HL70000'),
 'FHS_1': ('leaf', 'ST', 'FILE_FIELD_SEPARATOR', 'HL70000'),
 'FHS_10': ('leaf', 'ST', 'FILE_HEADER_COMMENT', 'HL70000'),
 'FHS_11': ('leaf', 'ST', 'FILE_CONTROL_ID', 'HL70000'),
 'FHS_12': ('leaf', 'ST', 'REFERENCE_FILE_CONTROL_ID', 'HL70000'),
 'FHS_2': ('leaf', 'ST', 'FILE_ENCODING_CHARACTERS', 'HL70000'),
 'FHS_3': ('leaf', 'HD', 'FILE_SENDING_APPLICATION', 'HL70000'),
 'FHS_4': ('leaf', 'HD', 'FILE_SENDING_FACILITY', 'HL70000'),
 'FHS_5': ('leaf', 'HD', 'FILE_RECEIVING_APPLICATION', 'HL70000'),
 'FHS_6': ('leaf', 'HD', 'FILE_RECEIVING_FACILITY', 'HL70000'),
 'FHS_7': ('leaf', 'TS', 'FILE_CREATION_DATE_TIME', 'HL70000'),
 'FHS_8': ('leaf', 'ST', 'FILE_SECURITY', 'HL70000'),
 'FHS_9': ('leaf', 'ST', 'FILE_NAME_ID', 'HL70000'),
 'FT1_1': ('leaf', 'SI', 'SET_ID_FT1', 'HL70000'),
 'FT1_10': ('leaf', 'NM', 'TRANSACTION_QUANTITY', 'HL70000'),
 'FT1_11': ('leaf', 'CP', 'TRANSACTION_AMOUNT_EXTENDED', 'HL70000'),
 'FT1_12': ('leaf', 'CP', 'TRANSACTION_AMOUNT_UNIT', 'HL70000'),
 'FT1_13': ('leaf', 'CE', 'DEPARTMENT_CODE', 'HL70049'),
 'FT1_14': ('leaf', 'CE', 'INSURANCE_PLAN_ID', 'HL70072'),
 'FT1_15': ('leaf', 'CP', 'INSURANCE_AMOUNT', 'HL70000'),
 'FT1_16': ('leaf', 'PL', 'ASSIGNED_PATIENT_LOCATION', 'HL70000'),
 'FT1_17': ('leaf', 'IS', 'FEE_SCHEDULE', 'HL70024'),
 'FT1_18': ('leaf', 'IS', 'PATIENT_TYPE', 'HL70018'),
 'FT1_19': ('leaf', 'CE', 'DIAGNOSIS_CODE_FT1', 'HL70051'),
 'FT1_2': ('leaf', 'ST', 'TRANSACTION_ID', 'HL70000'),
 'FT1_20': ('leaf', 'XCN', 'PERFORMED_BY_CODE', 'HL70084'),
 'FT1_21': ('leaf', 'XCN', 'ORDERED_BY_CODE', 'HL70000'),
 'FT1_22': ('leaf', 'CP', 'UNIT_COST', 'HL70000'),
 'FT1_23': ('leaf', 'EI', 'FILLER_ORDER_NUMBER', 'HL70000'),
 'FT1_24': ('leaf', 'XCN', 'ENTERED_BY_CODE', 'HL70000'),
 'FT1_25': ('leaf', 'CE', 'PROCEDURE_CODE', 'HL70088'),
 'FT1_26': ('leaf', 'CE', 'PROCEDURE_CODE_MODIFIER', 'HL70340'),
 'FT1_27': ('leaf', 'CE', 'ADVANCED_BENEFICIARY_NOTICE_CODE', 'HL70339'),
 'FT1_28': ('leaf',
            'CWE',
            'MEDICALLY_NECESSARY_DUPLICATE_PROCEDURE_REASON_',
            'HL70476'),
 'FT1_29': ('leaf', 'CNE', 'NDC_CODE', 'HL70549'),
 'FT1_3': ('leaf', 'ST', 'TRANSACTION_BATCH_ID', 'HL70000'),
 'FT1_30': ('leaf', 'CX', 'PAYMENT_REFERENCE_ID', 'HL70000'),
 'FT1_31': ('leaf', 'SI', 'TRANSACTION_REFERENCE_KEY', 'HL70000'),
 'FT1_4': ('leaf', 'DR', 'TRANSACTION_DATE', 'HL70000'),
 'FT1_5': ('leaf', 'TS', 'TRANSACTION_POSTING_DATE', 'HL70000'),
 'FT1_6': ('leaf', 'IS', 'TRANSACTION_TYPE', 'HL70017'),
 'FT1_7': ('leaf', 'CE', 'TRANSACTION_CODE', 'HL70132'),
 'FT1_8': ('leaf', 'ST', 'TRANSACTION_DESCRIPTION', 'HL70000'),
 'FT1_9': ('leaf', 'ST', 'TRANSACTION_DESCRIPTION_ALT', 'HL70000'),
 'FTS_1': ('leaf', 'NM', 'FILE_BATCH_COUNT', 'HL70000'),
 'FTS_2': ('leaf', 'ST', 'FILE_TRAILER_COMMENT', 'HL70000'),
 'GOL_1': ('leaf', 'ID', 'ACTION_CODE', 'HL70287'),
 'GOL_10': ('leaf', 'CE', 'GOAL_MANAGEMENT_DISCIPLINE', 'HL70000'),
 'GOL_11': ('leaf', 'CE', 'CURRENT_GOAL_REVIEW_STATUS', 'HL70000'),
 'GOL_12': ('leaf', 'TS', 'CURRENT_GOAL_REVIEW_DATE_TIME', 'HL70000'),
 'GOL_13': ('leaf', 'TS', 'NEXT_GOAL_REVIEW_DATE_TIME', 'HL70000'),
 'GOL_14': ('leaf', 'TS', 'PREVIOUS_GOAL_REVIEW_DATE_TIME', 'HL70000'),
 'GOL_15': ('leaf', 'TQ', 'GOAL_REVIEW_INTERVAL', 'HL70000'),
 'GOL_16': ('leaf', 'CE', 'GOAL_EVALUATION', 'HL70000'),
 'GOL_17': ('leaf', 'ST', 'GOAL_EVALUATION_COMMENT', 'HL70000'),
 'GOL_18': ('leaf', 'CE', 'GOAL_LIFE_CYCLE_STATUS', 'HL70000'),
 'GOL_19': ('leaf', 'TS', 'GOAL_LIFE_CYCLE_STATUS_DATE_TIME', 'HL70000'),
 'GOL_2': ('leaf', 'TS', 'ACTION_DATE_TIME', 'HL70000'),
 'GOL_20': ('leaf', 'CE', 'GOAL_TARGET_TYPE', 'HL70000'),
 'GOL_21': ('leaf', 'XPN', 'GOAL_TARGET_NAME', 'HL70000'),
 'GOL_3': ('leaf', 'CE', 'GOAL_ID', 'HL70000'),
 'GOL_4': ('leaf', 'EI', 'GOAL_INSTANCE_ID', 'HL70000'),
 'GOL_5': ('leaf', 'EI', 'EPISODE_OF_CARE_ID', 'HL70000'),
 'GOL_6': ('leaf', 'NM', 'GOAL_LIST_PRIORITY', 'HL70000'),
 'GOL_7': ('leaf', 'TS', 'GOAL_ESTABLISHED_DATE_TIME', 'HL70000'),
 'GOL_8': ('leaf', 'TS', 'EXPECTED_GOAL_ACHIEVE_DATE_TIME', 'HL70000'),
 'GOL_9': ('leaf', 'CE', 'GOAL_CLASSIFICATION', 'HL70000'),
 'GP1_1': ('leaf', 'IS', 'TYPE_OF_BILL_CODE', 'HL70455'),
 'GP1_2': ('leaf', 'IS', 'REVENUE_CODE', 'HL70456'),
 'GP1_3': ('leaf', 'IS', 'OVERALL_CLAIM_DISPOSITION_CODE', 'HL70457'),
 'GP1_4': ('leaf', 'IS', 'OCE_EDITS_PER_VISIT_CODE', 'HL70458'),
 'GP1_5': ('leaf', 'CP', 'OUTLIER_COST', 'HL70000'),
 'GP2_1': ('leaf', 'IS', 'REVENUE_CODE', 'HL70456'),
 'GP2_10': ('leaf', 'IS', 'PACKAGING_STATUS_CODE', 'HL70469'),
 'GP2_11': ('leaf', 'CP', 'EXPECTED_CMS_PAYMENT_AMOUNT', 'HL70000'),
 'GP2_12': ('leaf', 'IS', 'REIMBURSEMENT_TYPE_CODE', 'HL70470'),
 'GP2_13': ('leaf', 'CP', 'CO_PAY_AMOUNT', 'HL70000'),
 'GP2_14': ('leaf', 'NM', 'PAY_RATE_PER_SERVICE_UNIT', 'HL70000'),
 'GP2_2': ('leaf', 'NM', 'NUMBER_OF_SERVICE_UNITS', 'HL70000'),
 'GP2_3': ('leaf', 'CP', 'CHARGE', 'HL70000'),
 'GP2_4': ('leaf', 'IS', 'REIMBURSEMENT_ACTION_CODE', 'HL70459'),
 'GP2_5': ('leaf', 'IS', 'DENIAL_OR_REJECTION_CODE', 'HL70460'),
 'GP2_6': ('leaf', 'IS', 'OCE_EDIT_CODE', 'HL70458'),
 'GP2_7': ('leaf', 'CE', 'AMBULATORY_PAYMENT_CLASSIFICATION_CODE', 'HL70466'),
 'GP2_8': ('leaf', 'IS', 'MODIFIER_EDIT_CODE', 'HL70467'),
 'GP2_9': ('leaf', 'IS', 'PAYMENT_ADJUSTMENT_CODE', 'HL70468'),
 'GT1_1': ('leaf', 'SI', 'SET_ID_GT1', 'HL70000'),
 'GT1_10': ('leaf', 'IS', 'GUARANTOR_TYPE', 'HL70068'),
 'GT1_11': ('leaf', 'CE', 'GUARANTOR_RELATIONSHIP', 'HL70063'),
 'GT1_12': ('leaf', 'ST', 'GUARANTOR_SSN', 'HL70000'),
 'GT1_13': ('leaf', 'DT', 'GUARANTOR_DATE_BEGIN', 'HL70000'),
 'GT1_14': ('leaf', 'DT', 'GUARANTOR_DATE_END', 'HL70000'),
 'GT1_15': ('leaf', 'NM', 'GUARANTOR_PRIORITY', 'HL70000'),
 'GT1_16': ('leaf', 'XPN', 'GUARANTOR_EMPLOYER_NAME', 'HL70000'),
 'GT1_17': ('leaf', 'XAD', 'GUARANTOR_EMPLOYER_ADDRESS', 'HL70000'),
 'GT1_18': ('leaf', 'XTN', 'GUARANTOR_EMPLOYER_PHONE_NUMBER', 'HL70000'),
 'GT1_19': ('leaf', 'CX', 'GUARANTOR_EMPLOYEE_ID_NUMBER', 'HL70000'),
 'GT1_2': ('leaf', 'CX', 'GUARANTOR_NUMBER', 'HL70000'),
 'GT1_20': ('leaf', 'IS', 'GUARANTOR_EMPLOYMENT_STATUS', 'HL70066'),
 'GT1_21': ('leaf', 'XON', 'GUARANTOR_ORGANIZATION_NAME', 'HL70000'),
 'GT1_22': ('leaf', 'ID', 'GUARANTOR_BILLING_HOLD_FLAG', 'HL70136'),
 'GT1_23': ('leaf', 'CE', 'GUARANTOR_CREDIT_RATING_CODE', 'HL70341'),
 'GT1_24': ('leaf', 'TS', 'GUARANTOR_DEATH_DATE_AND_TIME', 'HL70000'),
 'GT1_25': ('leaf', 'ID', 'GUARANTOR_DEATH_FLAG', 'HL70136'),
 'GT1_26': ('leaf', 'CE', 'GUARANTOR_CHARGE_ADJUSTMENT_CODE', 'HL70218'),
 'GT1_27': ('leaf', 'CP', 'GUARANTOR_HOUSEHOLD_ANNUAL_INCOME', 'HL70000'),
 'GT1_28': ('leaf', 'NM', 'GUARANTOR_HOUSEHOLD_SIZE', 'HL70000'),
 'GT1_29': ('leaf', 'CX', 'GUARANTOR_EMPLOYER_ID_NUMBER', 'HL70000'),
 'GT1_3': ('leaf', 'XPN', 'GUARANTOR_NAME', 'HL70000'),
 'GT1_30': ('leaf', 'CE', 'GUARANTOR_MARITAL_STATUS_CODE', 'HL70002'),
 'GT1_31': ('leaf', 'DT', 'GUARANTOR_HIRE_EFFECTIVE_DATE', 'HL70000'),
 'GT1_32': ('leaf', 'DT', 'EMPLOYMENT_STOP_DATE', 'HL70000'),
 'GT1_33': ('leaf', 'IS', 'LIVING_DEPENDENCY', 'HL70223'),
 'GT1_34': ('leaf', 'IS', 'AMBULATORY_STATUS', 'HL70009'),
 'GT1_35': ('leaf', 'CE', 'CITIZENSHIP', 'HL70171'),
 'GT1_36': ('leaf', 'CE', 'PRIMARY_LANGUAGE', 'HL70296'),
 'GT1_37': ('leaf', 'IS', 'LIVING_ARRANGEMENT', 'HL70220'),
 'GT1_38': ('leaf', 'CE', 'PUBLICITY_CODE', 'HL70215'),
 'GT1_39': ('leaf', 'ID', 'PROTECTION_INDICATOR', 'HL70136'),
 'GT1_4': ('leaf', 'XPN', 'GUARANTOR_SPOUSE_NAME', 'HL70000'),
 'GT1_40': ('leaf', 'IS', 'STUDENT_INDICATOR', 'HL70231'),
 'GT1_41': ('leaf', 'CE', 'RELIGION', 'HL70006'),
 'GT1_42': ('leaf', 'XPN', 'MOTHER_S_MAIDEN_NAME', 'HL70000'),
 'GT1_43': ('leaf', 'CE', 'NATIONALITY', 'HL70212'),
 'GT1_44': ('leaf', 'CE', 'ETHNIC_GROUP', 'HL70189'),
 'GT1_45': ('leaf', 'XPN', 'CONTACT_PERSON_S_NAME', 'HL70000'),
 'GT1_46': ('leaf', 'XTN', 'CONTACT_PERSON_S_TELEPHONE_NUMBER', 'HL70000'),
 'GT1_47': ('leaf', 'CE', 'CONTACT_REASON', 'HL70222'),
 'GT1_48': ('leaf', 'IS', 'CONTACT_RELATIONSHIP', 'HL70063'),
 'GT1_49': ('leaf', 'ST', 'JOB_TITLE', 'HL70000'),
 'GT1_5': ('leaf', 'XAD', 'GUARANTOR_ADDRESS', 'HL70000'),
 'GT1_50': ('leaf', 'JCC', 'JOB_CODE_CLASS', 'HL70000'),
 'GT1_51': ('leaf',
            'XON',
            'GUARANTOR_EMPLOYER_S_ORGANIZATION_NAME',
            'HL70000'),
 'GT1_52': ('leaf', 'IS', 'HANDICAP', 'HL70295'),
 'GT1_53': ('leaf', 'IS', 'JOB_STATUS', 'HL70311'),
 'GT1_54': ('leaf', 'FC', 'GUARANTOR_FINANCIAL_CLASS', 'HL70000'),
 'GT1_55': ('leaf', 'CE', 'GUARANTOR_RACE', 'HL70005'),
 'GT1_56': ('leaf', 'ST', 'GUARANTOR_BIRTH_PLACE', 'HL70000'),
 'GT1_57': ('leaf', 'IS', 'VIP_INDICATOR', 'HL70099'),
 'GT1_6': ('leaf', 'XTN', 'GUARANTOR_PH_NUM_HOME', 'HL70000'),
 'GT1_7': ('leaf', 'XTN', 'GUARANTOR_PH_NUM_BUSINESS', 'HL70000'),
 'GT1_8': ('leaf', 'TS', 'GUARANTOR_DATE_TIME_OF_BIRTH', 'HL70000'),
 'GT1_9': ('leaf', 'IS', 'GUARANTOR_ADMINISTRATIVE_SEX', 'HL70001'),
 'IAM_1': ('leaf', 'SI', 'SET_ID_IAM', 'HL70000'),
 'IAM_10': ('leaf',
            'CE',
            'ALLERGEN_GROUP_CODE_MNEMONIC_DESCRIPTION',
            'HL70000'),
 'IAM_11': ('leaf', 'DT', 'ONSET_DATE', 'HL70000'),
 'IAM_12': ('leaf', 'ST', 'ONSET_DATE_TEXT', 'HL70000'),
 'IAM_13': ('leaf', 'TS', 'REPORTED_DATE_TIME', 'HL70000'),
 'IAM_14': ('leaf', 'XPN', 'REPORTED_BY', 'HL70000'),
 'IAM_15': ('leaf', 'CE', 'RELATIONSHIP_TO_PATIENT_CODE', 'HL70063'),
 'IAM_16': ('leaf', 'CE', 'ALERT_DEVICE_CODE', 'HL70437'),
 'IAM_17': ('leaf', 'CE', 'ALLERGY_CLINICAL_STATUS_CODE', 'HL70438'),
 'IAM_18': ('leaf', 'XCN', 'STATUSED_BY_PERSON', 'HL70000'),
 'IAM_19': ('leaf', 'XON', 'STATUSED_BY_ORGANIZATION', 'HL70000'),
 'IAM_2': ('leaf', 'CE', 'ALLERGEN_TYPE_CODE', 'HL70127'),
 'IAM_20': ('leaf', 'TS', 'STATUSED_AT_DATE_TIME', 'HL70000'),
 'IAM_3': ('leaf', 'CE', 'ALLERGEN_CODE_MNEMONIC_DESCRIPTION', 'HL70000'),
 'IAM_4': ('leaf', 'CE', 'ALLERGY_SEVERITY_CODE', 'HL70128'),
 'IAM_5': ('leaf', 'ST', 'ALLERGY_REACTION_CODE', 'HL70000'),
 'IAM_6': ('leaf', 'CNE', 'ALLERGY_ACTION_CODE', 'HL70323'),
 'IAM_7': ('leaf', 'EI', 'ALLERGY_UNIQUE_IDENTIFIER', 'HL70000'),
 'IAM_8': ('leaf', 'ST', 'ACTION_REASON', 'HL70000'),
 'IAM_9': ('leaf', 'CE', 'SENSITIVITY_TO_CAUSATIVE_AGENT_CODE', 'HL70436'),
 'IIM_1': ('leaf', 'CWE', 'PRIMARY_KEY_VALUE_IIM', 'HL70000'),
 'IIM_10': ('leaf', 'MO', 'INVENTORY_RECEIVED_ITEM_COST', 'HL70000'),
 'IIM_11': ('leaf', 'TS', 'INVENTORY_ON_HAND_DATE', 'HL70000'),
 'IIM_12': ('leaf', 'NM', 'INVENTORY_ON_HAND_QUANTITY', 'HL70000'),
 'IIM_13': ('leaf', 'CWE', 'INVENTORY_ON_HAND_QUANTITY_UNIT', 'HL70000'),
 'IIM_14': ('leaf', 'CE', 'PROCEDURE_CODE', 'HL70088'),
 'IIM_15': ('leaf', 'CE', 'PROCEDURE_CODE_MODIFIER', 'HL70340'),
 'IIM_2': ('leaf', 'CWE', 'SERVICE_ITEM_CODE', 'HL70000'),
 'IIM_3': ('leaf', 'ST', 'INVENTORY_LOT_NUMBER', 'HL70000'),
 'IIM_4': ('leaf', 'TS', 'INVENTORY_EXPIRATION_DATE', 'HL70000'),
 'IIM_5': ('leaf', 'CWE', 'INVENTORY_MANUFACTURER_NAME', 'HL70000'),
 'IIM_6': ('leaf', 'CWE', 'INVENTORY_LOCATION', 'HL70000'),
 'IIM_7': ('leaf', 'TS', 'INVENTORY_RECEIVED_DATE', 'HL70000'),
 'IIM_8': ('leaf', 'NM', 'INVENTORY_RECEIVED_QUANTITY', 'HL70000'),
 'IIM_9': ('leaf', 'CWE', 'INVENTORY_RECEIVED_QUANTITY_UNIT', 'HL70000'),
 'IN1_1': ('leaf', 'SI', 'SET_ID_IN1', 'HL70000'),
 'IN1_10': ('leaf', 'CX', 'INSURED_S_GROUP_EMP_ID', 'HL70000'),
 'IN1_11': ('leaf', 'XON', 'INSURED_S_GROUP_EMP_NAME', 'HL70000'),
 'IN1_12': ('leaf', 'DT', 'PLAN_EFFECTIVE_DATE', 'HL70000'),
 'IN1_13': ('leaf', 'DT', 'PLAN_EXPIRATION_DATE', 'HL70000'),
 'IN1_14': ('leaf', 'AUI', 'AUTHORIZATION_INFORMATION', 'HL70000'),
 'IN1_15': ('leaf', 'IS', 'PLAN_TYPE', 'HL70086'),
 'IN1_16': ('leaf', 'XPN', 'NAME_OF_INSURED', 'HL70000'),
 'IN1_17': ('leaf', 'CE', 'INSURED_S_RELATIONSHIP_TO_PATIENT', 'HL70063'),
 'IN1_18': ('leaf', 'TS', 'INSURED_S_DATE_OF_BIRTH', 'HL70000'),
 'IN1_19': ('leaf', 'XAD', 'INSURED_S_ADDRESS', 'HL70000'),
 'IN1_2': ('leaf', 'CE', 'INSURANCE_PLAN_ID', 'HL70072'),
 'IN1_20': ('leaf', 'IS', 'ASSIGNMENT_OF_BENEFITS', 'HL70135'),
 'IN1_21': ('leaf', 'IS', 'COORDINATION_OF_BENEFITS', 'HL70173'),
 'IN1_22': ('leaf', 'ST', 'COORD_OF_BEN_PRIORITY', 'HL70000'),
 'IN1_23': ('leaf', 'ID', 'NOTICE_OF_ADMISSION_FLAG', 'HL70136'),
 'IN1_24': ('leaf', 'DT', 'NOTICE_OF_ADMISSION_DATE', 'HL70000'),
 'IN1_25': ('leaf', 'ID', 'REPORT_OF_ELIGIBILITY_FLAG', 'HL70136'),
 'IN1_26': ('leaf', 'DT', 'REPORT_OF_ELIGIBILITY_DATE', 'HL70000'),
 'IN1_27': ('leaf', 'IS', 'RELEASE_INFORMATION_CODE', 'HL70093'),
 'IN1_28': ('leaf', 'ST', 'PRE_ADMIT_CERT_PAC_', 'HL70000'),
 'IN1_29': ('leaf', 'TS', 'VERIFICATION_DATE_TIME', 'HL70000'),
 'IN1_3': ('leaf', 'CX', 'INSURANCE_COMPANY_ID', 'HL70000'),
 'IN1_30': ('leaf', 'XCN', 'VERIFICATION_BY', 'HL70000'),
 'IN1_31': ('leaf', 'IS', 'TYPE_OF_AGREEMENT_CODE', 'HL70098'),
 'IN1_32': ('leaf', 'IS', 'BILLING_STATUS', 'HL70022'),
 'IN1_33': ('leaf', 'NM', 'LIFETIME_RESERVE_DAYS', 'HL70000'),
 'IN1_34': ('leaf', 'NM', 'DELAY_BEFORE_L_R_DAY', 'HL70000'),
 'IN1_35': ('leaf', 'IS', 'COMPANY_PLAN_CODE', 'HL70042'),
 'IN1_36': ('leaf', 'ST', 'POLICY_NUMBER', 'HL70000'),
 'IN1_37': ('leaf', 'CP', 'POLICY_DEDUCTIBLE', 'HL70000'),
 'IN1_38': ('leaf', 'CP', 'POLICY_LIMIT_AMOUNT', 'HL70000'),
 'IN1_39': ('leaf', 'NM', 'POLICY_LIMIT_DAYS', 'HL70000'),
 'IN1_4': ('leaf', 'XON', 'INSURANCE_COMPANY_NAME', 'HL70000'),
 'IN1_40': ('leaf', 'CP', 'ROOM_RATE_SEMI_PRIVATE', 'HL70000'),
 'IN1_41': ('leaf', 'CP', 'ROOM_RATE_PRIVATE', 'HL70000'),
 'IN1_42': ('leaf', 'CE', 'INSURED_S_EMPLOYMENT_STATUS', 'HL70066'),
 'IN1_43': ('leaf', 'IS', 'INSURED_S_ADMINISTRATIVE_SEX', 'HL70001'),
 'IN1_44': ('leaf', 'XAD', 'INSURED_S_EMPLOYER_S_ADDRESS', 'HL70000'),
 'IN1_45': ('leaf', 'ST', 'VERIFICATION_STATUS', 'HL70000'),
 'IN1_46': ('leaf', 'IS', 'PRIOR_INSURANCE_PLAN_ID', 'HL70072'),
 'IN1_47': ('leaf', 'IS', 'COVERAGE_TYPE', 'HL70309'),
 'IN1_48': ('leaf', 'IS', 'HANDICAP', 'HL70295'),
 'IN1_49': ('leaf', 'CX', 'INSURED_S_ID_NUMBER', 'HL70000'),
 'IN1_5': ('leaf', 'XAD', 'INSURANCE_COMPANY_ADDRESS', 'HL70000'),
 'IN1_50': ('leaf', 'IS', 'SIGNATURE_CODE', 'HL70535'),
 'IN1_51': ('leaf', 'DT', 'SIGNATURE_CODE_DATE', 'HL70000'),
 'IN1_52': ('leaf', 'ST', 'INSURED_S_BIRTH_PLACE', 'HL70000'),
 'IN1_53': ('leaf', 'IS', 'VIP_INDICATOR', 'HL70099'),
 'IN1_6': ('leaf', 'XPN', 'INSURANCE_CO_CONTACT_PERSON', 'HL70000'),
 'IN1_7': ('leaf', 'XTN', 'INSURANCE_CO_PHONE_NUMBER', 'HL70000'),
 'IN1_8': ('leaf', 'ST', 'GROUP_NUMBER', 'HL70000'),
 'IN1_9': ('leaf', 'XON', 'GROUP_NAME', 'HL70000'),
 'IN2_1': ('leaf', 'CX', 'INSURED_S_EMPLOYEE_ID', 'HL70000'),
 'IN2_10': ('leaf', 'ST', 'MILITARY_ID_NUMBER', 'HL70000'),
 'IN2_11': ('leaf', 'CE', 'DEPENDENT_OF_MILITARY_RECIPIENT', 'HL70342'),
 'IN2_12': ('leaf', 'ST', 'MILITARY_ORGANIZATION', 'HL70000'),
 'IN2_13': ('leaf', 'ST', 'MILITARY_STATION', 'HL70000'),
 'IN2_14': ('leaf', 'IS', 'MILITARY_SERVICE', 'HL70140'),
 'IN2_15': ('leaf', 'IS', 'MILITARY_RANK_GRADE', 'HL70141'),
 'IN2_16': ('leaf', 'IS', 'MILITARY_STATUS', 'HL70142'),
 'IN2_17': ('leaf', 'DT', 'MILITARY_RETIRE_DATE', 'HL70000'),
 'IN2_18': ('leaf', 'ID', 'MILITARY_NON_AVAIL_CERT_ON_FILE', 'HL70136'),
 'IN2_19': ('leaf', 'ID', 'BABY_COVERAGE', 'HL70136'),
 'IN2_2': ('leaf', 'ST', 'INSURED_S_SOCIAL_SECURITY_NUMBER', 'HL70000'),
 'IN2_20': ('leaf', 'ID', 'COMBINE_BABY_BILL', 'HL70136'),
 'IN2_21': ('leaf', 'ST', 'BLOOD_DEDUCTIBLE', 'HL70000'),
 'IN2_22': ('leaf', 'XPN', 'SPECIAL_COVERAGE_APPROVAL_NAME', 'HL70000'),
 'IN2_23': ('leaf', 'ST', 'SPECIAL_COVERAGE_APPROVAL_TITLE', 'HL70000'),
 'IN2_24': ('leaf', 'IS', 'NON_COVERED_INSURANCE_CODE', 'HL70143'),
 'IN2_25': ('leaf', 'CX', 'PAYOR_ID', 'HL70000'),
 'IN2_26': ('leaf', 'CX', 'PAYOR_SUBSCRIBER_ID', 'HL70000'),
 'IN2_27': ('leaf', 'IS', 'ELIGIBILITY_SOURCE', 'HL70144'),
 'IN2_28': ('leaf', 'RMC', 'ROOM_COVERAGE_TYPE_AMOUNT', 'HL70000'),
 'IN2_29': ('leaf', 'PTA', 'POLICY_TYPE_AMOUNT', 'HL70000'),
 'IN2_3': ('leaf', 'XCN', 'INSURED_S_EMPLOYER_S_NAME_AND_ID', 'HL70000'),
 'IN2_30': ('leaf', 'DDI', 'DAILY_DEDUCTIBLE', 'HL70000'),
 'IN2_31': ('leaf', 'IS', 'LIVING_DEPENDENCY', 'HL70223'),
 'IN2_32': ('leaf', 'IS', 'AMBULATORY_STATUS', 'HL70009'),
 'IN2_33': ('leaf', 'CE', 'CITIZENSHIP', 'HL70171'),
 'IN2_34': ('leaf', 'CE', 'PRIMARY_LANGUAGE', 'HL70296'),
 'IN2_35': ('leaf', 'IS', 'LIVING_ARRANGEMENT', 'HL70220'),
 'IN2_36': ('leaf', 'CE', 'PUBLICITY_CODE', 'HL70215'),
 'IN2_37': ('leaf', 'ID', 'PROTECTION_INDICATOR', 'HL70136'),
 'IN2_38': ('leaf', 'IS', 'STUDENT_INDICATOR', 'HL70231'),
 'IN2_39': ('leaf', 'CE', 'RELIGION', 'HL70006'),
 'IN2_4': ('leaf', 'IS', 'EMPLOYER_INFORMATION_DATA', 'HL70139'),
 'IN2_40': ('leaf', 'XPN', 'MOTHER_S_MAIDEN_NAME', 'HL70000'),
 'IN2_41': ('leaf', 'CE', 'NATIONALITY', 'HL70212'),
 'IN2_42': ('leaf', 'CE', 'ETHNIC_GROUP', 'HL70189'),
 'IN2_43': ('leaf', 'CE', 'MARITAL_STATUS', 'HL70002'),
 'IN2_44': ('leaf', 'DT', 'INSURED_S_EMPLOYMENT_START_DATE', 'HL70000'),
 'IN2_45': ('leaf', 'DT', 'EMPLOYMENT_STOP_DATE', 'HL70000'),
 'IN2_46': ('leaf', 'ST', 'JOB_TITLE', 'HL70000'),
 'IN2_47': ('leaf', 'JCC', 'JOB_CODE_CLASS', 'HL70000'),
 'IN2_48': ('leaf', 'IS', 'JOB_STATUS', 'HL70311'),
 'IN2_49': ('leaf', 'XPN', 'EMPLOYER_CONTACT_PERSON_NAME', 'HL70000'),
 'IN2_5': ('leaf', 'IS', 'MAIL_CLAIM_PARTY', 'HL70137'),
 'IN2_50': ('leaf', 'XTN', 'EMPLOYER_CONTACT_PERSON_PHONE_NUMBER', 'HL70000'),
 'IN2_51': ('leaf', 'IS', 'EMPLOYER_CONTACT_REASON', 'HL70222'),
 'IN2_52': ('leaf', 'XPN', 'INSURED_S_CONTACT_PERSON_S_NAME', 'HL70000'),
 'IN2_53': ('leaf', 'XTN', 'INSURED_S_CONTACT_PERSON_PHONE_NUMBER', 'HL70000'),
 'IN2_54': ('leaf', 'IS', 'INSURED_S_CONTACT_PERSON_REASON', 'HL70222'),
 'IN2_55': ('leaf', 'DT', 'RELATIONSHIP_TO_THE_PATIENT_START_DATE', 'HL70000'),
 'IN2_56': ('leaf', 'DT', 'RELATIONSHIP_TO_THE_PATIENT_STOP_DATE', 'HL70000'),
 'IN2_57': ('leaf', 'IS', 'INSURANCE_CO_CONTACT_REASON', 'HL70232'),
 'IN2_58': ('leaf', 'XTN', 'INSURANCE_CO_CONTACT_PHONE_NUMBER', 'HL70000'),
 'IN2_59': ('leaf', 'IS', 'POLICY_SCOPE', 'HL70312'),
 'IN2_6': ('leaf', 'ST', 'MEDICARE_HEALTH_INS_CARD_NUMBER', 'HL70000'),
 'IN2_60': ('leaf', 'IS', 'POLICY_SOURCE', 'HL70313'),
 'IN2_61': ('leaf', 'CX', 'PATIENT_MEMBER_NUMBER', 'HL70000'),
 'IN2_62': ('leaf', 'CE', 'GUARANTOR_S_RELATIONSHIP_TO_INSURED', 'HL70063'),
 'IN2_63': ('leaf', 'XTN', 'INSURED_S_PHONE_NUMBER_HOME', 'HL70000'),
 'IN2_64': ('leaf', 'XTN', 'INSURED_S_EMPLOYER_PHONE_NUMBER', 'HL70000'),
 'IN2_65': ('leaf', 'CE', 'MILITARY_HANDICAPPED_PROGRAM', 'HL70343'),
 'IN2_66': ('leaf', 'ID', 'SUSPEND_FLAG', 'HL70136'),
 'IN2_67': ('leaf', 'ID', 'COPAY_LIMIT_FLAG', 'HL70136'),
 'IN2_68': ('leaf', 'ID', 'STOPLOSS_LIMIT_FLAG', 'HL70136'),
 'IN2_69': ('leaf', 'XON', 'INSURED_ORGANIZATION_NAME_AND_ID', 'HL70000'),
 'IN2_7': ('leaf', 'XPN', 'MEDICAID_CASE_NAME', 'HL70000'),
 'IN2_70': ('leaf',
            'XON',
            'INSURED_EMPLOYER_ORGANIZATION_NAME_AND_ID',
            'HL70000'),
 'IN2_71': ('leaf', 'CE', 'RACE', 'HL70005'),
 'IN2_72': ('leaf', 'CE', 'CMS_PATIENT_S_RELATIONSHIP_TO_INSURED', 'HL70344'),
 'IN2_8': ('leaf', 'ST', 'MEDICAID_CASE_NUMBER', 'HL70000'),
 'IN2_9': ('leaf', 'XPN', 'MILITARY_SPONSOR_NAME', 'HL70000'),
 'IN3_1': ('leaf', 'SI', 'SET_ID_IN3', 'HL70000'),
 'IN3_10': ('leaf', 'DT', 'CERTIFICATION_END_DATE', 'HL70000'),
 'IN3_11': ('leaf', 'DTN', 'DAYS', 'HL70000'),
 'IN3_12': ('leaf', 'CE', 'NON_CONCUR_CODE_DESCRIPTION', 'HL70233'),
 'IN3_13': ('leaf', 'TS', 'NON_CONCUR_EFFECTIVE_DATE_TIME', 'HL70000'),
 'IN3_14': ('leaf', 'XCN', 'PHYSICIAN_REVIEWER', 'HL70010'),
 'IN3_15': ('leaf', 'ST', 'CERTIFICATION_CONTACT', 'HL70000'),
 'IN3_16': ('leaf', 'XTN', 'CERTIFICATION_CONTACT_PHONE_NUMBER', 'HL70000'),
 'IN3_17': ('leaf', 'CE', 'APPEAL_REASON', 'HL70345'),
 'IN3_18': ('leaf', 'CE', 'CERTIFICATION_AGENCY', 'HL70346'),
 'IN3_19': ('leaf', 'XTN', 'CERTIFICATION_AGENCY_PHONE_NUMBER', 'HL70000'),
 'IN3_2': ('leaf', 'CX', 'CERTIFICATION_NUMBER', 'HL70000'),
 'IN3_20': ('leaf', 'ICD', 'PRE_CERTIFICATION_REQUIREMENT', 'HL70000'),
 'IN3_21': ('leaf', 'ST', 'CASE_MANAGER', 'HL70000'),
 'IN3_22': ('leaf', 'DT', 'SECOND_OPINION_DATE', 'HL70000'),
 'IN3_23': ('leaf', 'IS', 'SECOND_OPINION_STATUS', 'HL70151'),
 'IN3_24': ('leaf', 'IS', 'SECOND_OPINION_DOCUMENTATION_RECEIVED', 'HL70152'),
 'IN3_25': ('leaf', 'XCN', 'SECOND_OPINION_PHYSICIAN', 'HL70010'),
 'IN3_3': ('leaf', 'XCN', 'CERTIFIED_BY', 'HL70000'),
 'IN3_4': ('leaf', 'ID', 'CERTIFICATION_REQUIRED', 'HL70136'),
 'IN3_5': ('leaf', 'MOP', 'PENALTY', 'HL70000'),
 'IN3_6': ('leaf', 'TS', 'CERTIFICATION_DATE_TIME', 'HL70000'),
 'IN3_7': ('leaf', 'TS', 'CERTIFICATION_MODIFY_DATE_TIME', 'HL70000'),
 'IN3_8': ('leaf', 'XCN', 'OPERATOR', 'HL70000'),
 'IN3_9': ('leaf', 'DT', 'CERTIFICATION_BEGIN_DATE', 'HL70000'),
 'INV_1': ('leaf', 'CE', 'SUBSTANCE_IDENTIFIER', 'HL70451'),
 'INV_10': ('leaf', 'NM', 'CONSUMPTION_QUANTITY', 'HL70000'),
 'INV_11': ('leaf', 'CE', 'QUANTITY_UNITS', 'HL70000'),
 'INV_12': ('leaf', 'TS', 'EXPIRATION_DATE_TIME', 'HL70000'),
 'INV_13': ('leaf', 'TS', 'FIRST_USED_DATE_TIME', 'HL70000'),
 'INV_14': ('leaf', 'TQ', 'ON_BOARD_STABILITY_DURATION', 'HL70000'),
 'INV_15': ('leaf', 'CE', 'TEST_FLUID_IDENTIFIER_S_', 'HL70000'),
 'INV_16': ('leaf', 'ST', 'MANUFACTURER_LOT_NUMBER', 'HL70000'),
 'INV_17': ('leaf', 'CE', 'MANUFACTURER_IDENTIFIER', 'HL70385'),
 'INV_18': ('leaf', 'CE', 'SUPPLIER_IDENTIFIER', 'HL70386'),
 'INV_19': ('leaf', 'CQ', 'ON_BOARD_STABILITY_TIME', 'HL70000'),
 'INV_2': ('leaf', 'CE', 'SUBSTANCE_STATUS', 'HL70383'),
 'INV_20': ('leaf', 'CQ', 'TARGET_VALUE', 'HL70000'),
 'INV_3': ('leaf', 'CE', 'SUBSTANCE_TYPE', 'HL70384'),
 'INV_4': ('leaf', 'CE', 'INVENTORY_CONTAINER_IDENTIFIER', 'HL70000'),
 'INV_5': ('leaf', 'CE', 'CONTAINER_CARRIER_IDENTIFIER', 'HL70000'),
 'INV_6': ('leaf', 'CE', 'POSITION_ON_CARRIER', 'HL70000'),
 'INV_7': ('leaf', 'NM', 'INITIAL_QUANTITY', 'HL70000'),
 'INV_8': ('leaf', 'NM', 'CURRENT_QUANTITY', 'HL70000'),
 'INV_9': ('leaf', 'NM', 'AVAILABLE_QUANTITY', 'HL70000'),
 'IPC_1': ('leaf', 'EI', 'ACCESSION_IDENTIFIER', 'HL70000'),
 'IPC_2': ('leaf', 'EI', 'REQUESTED_PROCEDURE_ID', 'HL70000'),
 'IPC_3': ('leaf', 'EI', 'STUDY_INSTANCE_UID', 'HL70000'),
 'IPC_4': ('leaf', 'EI', 'SCHEDULED_PROCEDURE_STEP_ID', 'HL70000'),
 'IPC_5': ('leaf', 'CE', 'MODALITY', 'HL70000'),
 'IPC_6': ('leaf', 'CE', 'PROTOCOL_CODE', 'HL70000'),
 'IPC_7': ('leaf', 'EI', 'SCHEDULED_STATION_NAME', 'HL70000'),
 'IPC_8': ('leaf', 'CE', 'SCHEDULED_PROCEDURE_STEP_LOCATION', 'HL70000'),
 'IPC_9': ('leaf', 'ST', 'SCHEDULED_AE_TITLE', 'HL70000'),
 'ISD_1': ('leaf',
           'NM',
           'REFERENCE_INTERACTION_NUMBER_UNIQUE_IDENTIFIER_',
           'HL70000'),
 'ISD_2': ('leaf', 'CE', 'INTERACTION_TYPE_IDENTIFIER', 'HL70368'),
 'ISD_3': ('leaf', 'CE', 'INTERACTION_ACTIVE_STATE', 'HL70387'),
 'LAN_1': ('leaf', 'SI', 'SET_ID_LAN', 'HL70000'),
 'LAN_2': ('leaf', 'CE', 'LANGUAGE_CODE', 'HL70296'),
 'LAN_3': ('leaf', 'CE', 'LANGUAGE_ABILITY_CODE', 'HL70403'),
 'LAN_4': ('leaf', 'CE', 'LANGUAGE_PROFICIENCY_CODE', 'HL70404'),
 'LCC_1': ('leaf', 'PL', 'PRIMARY_KEY_VALUE_LCC', 'HL70000'),
 'LCC_2': ('leaf', 'CE', 'LOCATION_DEPARTMENT', 'HL70264'),
 'LCC_3': ('leaf', 'CE', 'ACCOMMODATION_TYPE', 'HL70129'),
 'LCC_4': ('leaf', 'CE', 'CHARGE_CODE', 'HL70132'),
 'LCH_1': ('leaf', 'PL', 'PRIMARY_KEY_VALUE_LCH', 'HL70000'),
 'LCH_2': ('leaf', 'ID', 'SEGMENT_ACTION_CODE', 'HL70206'),
 'LCH_3': ('leaf', 'EI', 'SEGMENT_UNIQUE_KEY', 'HL70000'),
 'LCH_4': ('leaf', 'CE', 'LOCATION_CHARACTERISTIC_ID', 'HL70324'),
 'LCH_5': ('leaf', 'CE', 'LOCATION_CHARACTERISTIC_VALUE_LCH', 'HL70000'),
 'LDP_1': ('leaf', 'PL', 'PRIMARY_KEY_VALUE_LDP', 'HL70000'),
 'LDP_10': ('leaf', 'VH', 'VISITING_HOURS', 'HL70267'),
 'LDP_11': ('leaf', 'XTN', 'CONTACT_PHONE', 'HL70000'),
 'LDP_12': ('leaf', 'CE', 'LOCATION_COST_CENTER', 'HL70462'),
 'LDP_2': ('leaf', 'CE', 'LOCATION_DEPARTMENT', 'HL70264'),
 'LDP_3': ('leaf', 'IS', 'LOCATION_SERVICE', 'HL70069'),
 'LDP_4': ('leaf', 'CE', 'SPECIALTY_TYPE', 'HL70265'),
 'LDP_5': ('leaf', 'IS', 'VALID_PATIENT_CLASSES', 'HL70004'),
 'LDP_6': ('leaf', 'ID', 'ACTIVE_INACTIVE_FLAG', 'HL70183'),
 'LDP_7': ('leaf', 'TS', 'ACTIVATION_DATE_LDP', 'HL70000'),
 'LDP_8': ('leaf', 'TS', 'INACTIVATION_DATE_LDP', 'HL70000'),
 'LDP_9': ('leaf', 'ST', 'INACTIVATED_REASON', 'HL70000'),
 'LOC_1': ('leaf', 'PL', 'PRIMARY_KEY_VALUE_LOC', 'HL70000'),
 'LOC_2': ('leaf', 'ST', 'LOCATION_DESCRIPTION', 'HL70000'),
 'LOC_3': ('leaf', 'IS', 'LOCATION_TYPE_LOC', 'HL70260'),
 'LOC_4': ('leaf', 'XON', 'ORGANIZATION_NAME_LOC', 'HL70000'),
 'LOC_5': ('leaf', 'XAD', 'LOCATION_ADDRESS', 'HL70000'),
 'LOC_6': ('leaf', 'XTN', 'LOCATION_PHONE', 'HL70000'),
 'LOC_7': ('leaf', 'CE', 'LICENSE_NUMBER', 'HL70461'),
 'LOC_8': ('leaf', 'IS', 'LOCATION_EQUIPMENT', 'HL70261'),
 'LOC_9': ('leaf', 'IS', 'LOCATION_SERVICE_CODE', 'HL70442'),
 'LRL_1': ('leaf', 'PL', 'PRIMARY_KEY_VALUE_LRL', 'HL70000'),
 'LRL_2': ('leaf', 'ID', 'SEGMENT_ACTION_CODE', 'HL70206'),
 'LRL_3': ('leaf', 'EI', 'SEGMENT_UNIQUE_KEY', 'HL70000'),
 'LRL_4': ('leaf', 'CE', 'LOCATION_RELATIONSHIP_ID', 'HL70325'),
 'LRL_5': ('leaf',
           'XON',
           'ORGANIZATIONAL_LOCATION_RELATIONSHIP_VALUE',
           'HL70000'),
 'LRL_6': ('leaf', 'PL', 'PATIENT_LOCATION_RELATIONSHIP_VALUE', 'HL70000'),
 'MFA_1': ('leaf', 'ID', 'RECORD_LEVEL_EVENT_CODE', 'HL70180'),
 'MFA_2': ('leaf', 'ST', 'MFN_CONTROL_ID', 'HL70000'),
 'MFA_3': ('leaf', 'TS', 'EVENT_COMPLETION_DATE_TIME', 'HL70000'),
 'MFA_4': ('leaf', 'CE', 'MFN_RECORD_LEVEL_ERROR_RETURN', 'HL70181'),
 'MFA_5': ('leaf', 'varies', 'PRIMARY_KEY_VALUE_MFA', 'HL79999'),
 'MFA_6': ('leaf', 'ID', 'PRIMARY_KEY_VALUE_TYPE_MFA', 'HL70355'),
 'MFE_1': ('leaf', 'ID', 'RECORD_LEVEL_EVENT_CODE', 'HL70180'),
 'MFE_2': ('leaf', 'ST', 'MFN_CONTROL_ID', 'HL70000'),
 'MFE_3': ('leaf', 'TS', 'EFFECTIVE_DATE_TIME', 'HL70000'),
 'MFE_4': ('leaf', 'varies', 'PRIMARY_KEY_VALUE_MFE', 'HL79999'),
 'MFE_5': ('leaf', 'ID', 'PRIMARY_KEY_VALUE_TYPE', 'HL70355'),
 'MFI_1': ('leaf', 'CE', 'MASTER_FILE_IDENTIFIER', 'HL70175'),
 'MFI_2': ('leaf', 'HD', 'MASTER_FILE_APPLICATION_IDENTIFIER', 'HL70361'),
 'MFI_3': ('leaf', 'ID', 'FILE_LEVEL_EVENT_CODE', 'HL70178'),
 'MFI_4': ('leaf', 'TS', 'ENTERED_DATE_TIME', 'HL70000'),
 'MFI_5': ('leaf', 'TS', 'EFFECTIVE_DATE_TIME', 'HL70000'),
 'MFI_6': ('leaf', 'ID', 'RESPONSE_LEVEL_CODE', 'HL70179'),
 'MRG_1': ('leaf', 'CX', 'PRIOR_PATIENT_IDENTIFIER_LIST', 'HL70000'),
 'MRG_2': ('leaf', 'CX', 'PRIOR_ALTERNATE_PATIENT_ID', 'HL70000'),
 'MRG_3': ('leaf', 'CX', 'PRIOR_PATIENT_ACCOUNT_NUMBER', 'HL70000'),
 'MRG_4': ('leaf', 'CX', 'PRIOR_PATIENT_ID', 'HL70000'),
 'MRG_5': ('leaf', 'CX', 'PRIOR_VISIT_NUMBER', 'HL70000'),
 'MRG_6': ('leaf', 'CX', 'PRIOR_ALTERNATE_VISIT_ID', 'HL70000'),
 'MRG_7': ('leaf', 'XPN', 'PRIOR_PATIENT_NAME', 'HL70000'),
 'MSA_1': ('leaf', 'ID', 'ACKNOWLEDGMENT_CODE', 'HL70008'),
 'MSA_2': ('leaf', 'ST', 'MESSAGE_CONTROL_ID', 'HL70000'),
 'MSA_3': ('leaf', 'ST', 'TEXT_MESSAGE', 'HL70000'),
 'MSA_4': ('leaf', 'NM', 'EXPECTED_SEQUENCE_NUMBER', 'HL70000'),
 'MSA_6': ('leaf', 'CE', 'ERROR_CONDITION', 'HL70357'),
 'MSH_1': ('leaf', 'ST', 'FIELD_SEPARATOR', 'HL70000'),
 'MSH_10': ('leaf', 'ST', 'MESSAGE_CONTROL_ID', 'HL70000'),
 'MSH_11': ('leaf', 'PT', 'PROCESSING_ID', 'HL70000'),
 'MSH_12': ('leaf', 'VID', 'VERSION_ID', 'HL70000'),
 'MSH_13': ('leaf', 'NM', 'SEQUENCE_NUMBER', 'HL70000'),
 'MSH_14': ('leaf', 'ST', 'CONTINUATION_POINTER', 'HL70000'),
 'MSH_15': ('leaf', 'ID', 'ACCEPT_ACKNOWLEDGMENT_TYPE', 'HL70155'),
 'MSH_16': ('leaf', 'ID', 'APPLICATION_ACKNOWLEDGMENT_TYPE', 'HL70155'),
 'MSH_17': ('leaf', 'ID', 'COUNTRY_CODE', 'HL70399'),
 'MSH_18': ('leaf', 'ID', 'CHARACTER_SET', 'HL70211'),
 'MSH_19': ('leaf', 'CE', 'PRINCIPAL_LANGUAGE_OF_MESSAGE', 'HL70000'),
 'MSH_2': ('leaf', 'ST', 'ENCODING_CHARACTERS', 'HL70000'),
 'MSH_20': ('leaf',
            'ID',
            'ALTERNATE_CHARACTER_SET_HANDLING_SCHEME',
            'HL70356'),
 'MSH_21': ('leaf', 'EI', 'MESSAGE_PROFILE_IDENTIFIER', 'HL70000'),
 'MSH_3': ('leaf', 'HD', 'SENDING_APPLICATION', 'HL70361'),
 'MSH_4': ('leaf', 'HD', 'SENDING_FACILITY', 'HL70362'),
 'MSH_5': ('leaf', 'HD', 'RECEIVING_APPLICATION', 'HL70361'),
 'MSH_6': ('leaf', 'HD', 'RECEIVING_FACILITY', 'HL70362'),
 'MSH_7': ('leaf', 'TS', 'DATE_TIME_OF_MESSAGE', 'HL70000'),
 'MSH_8': ('leaf', 'ST', 'SECURITY', 'HL70000'),
 'MSH_9': ('leaf', 'MSG', 'MESSAGE_TYPE', 'HL70000'),
 'NCK_1': ('leaf', 'TS', 'SYSTEM_DATE_TIME', 'HL70000'),
 'NDS_1': ('leaf', 'NM', 'NOTIFICATION_REFERENCE_NUMBER', 'HL70000'),
 'NDS_2': ('leaf', 'TS', 'NOTIFICATION_DATE_TIME', 'HL70000'),
 'NDS_3': ('leaf', 'CE', 'NOTIFICATION_ALERT_SEVERITY', 'HL70367'),
 'NDS_4': ('leaf', 'CE', 'NOTIFICATION_CODE', 'HL70000'),
 'NK1_1': ('leaf', 'SI', 'SET_ID_NK1', 'HL70000'),
 'NK1_10': ('leaf',
            'ST',
            'NEXT_OF_KIN_ASSOCIATED_PARTIES_JOB_TITLE',
            'HL70000'),
 'NK1_11': ('leaf',
            'JCC',
            'NEXT_OF_KIN_ASSOCIATED_PARTIES_JOB_CODE_CLASS',
            'HL70000'),
 'NK1_12': ('leaf',
            'CX',
            'NEXT_OF_KIN_ASSOCIATED_PARTIES_EMPLOYEE_NUMBER',
            'HL70000'),
 'NK1_13': ('leaf', 'XON', 'ORGANIZATION_NAME_NK1', 'HL70000'),
 'NK1_14': ('leaf', 'CE', 'MARITAL_STATUS', 'HL70002'),
 'NK1_15': ('leaf', 'IS', 'ADMINISTRATIVE_SEX', 'HL70001'),
 'NK1_16': ('leaf', 'TS', 'DATE_TIME_OF_BIRTH', 'HL70000'),
 'NK1_17': ('leaf', 'IS', 'LIVING_DEPENDENCY', 'HL70223'),
 'NK1_18': ('leaf', 'IS', 'AMBULATORY_STATUS', 'HL70009'),
 'NK1_19': ('leaf', 'CE', 'CITIZENSHIP', 'HL70171'),
 'NK1_2': ('leaf', 'XPN', 'NAME', 'HL70000'),
 'NK1_20': ('leaf', 'CE', 'PRIMARY_LANGUAGE', 'HL70296'),
 'NK1_21': ('leaf', 'IS', 'LIVING_ARRANGEMENT', 'HL70220'),
 'NK1_22': ('leaf', 'CE', 'PUBLICITY_CODE', 'HL70215'),
 'NK1_23': ('leaf', 'ID', 'PROTECTION_INDICATOR', 'HL70136'),
 'NK1_24': ('leaf', 'IS', 'STUDENT_INDICATOR', 'HL70231'),
 'NK1_25': ('leaf', 'CE', 'RELIGION', 'HL70006'),
 'NK1_26': ('leaf', 'XPN', 'MOTHER_S_MAIDEN_NAME', 'HL70000'),
 'NK1_27': ('leaf', 'CE', 'NATIONALITY', 'HL70212'),
 'NK1_28': ('leaf', 'CE', 'ETHNIC_GROUP', 'HL70189'),
 'NK1_29': ('leaf', 'CE', 'CONTACT_REASON', 'HL70222'),
 'NK1_3': ('leaf', 'CE', 'RELATIONSHIP', 'HL70063'),
 'NK1_30': ('leaf', 'XPN', 'CONTACT_PERSON_S_NAME', 'HL70000'),
 'NK1_31': ('leaf', 'XTN', 'CONTACT_PERSON_S_TELEPHONE_NUMBER', 'HL70000'),
 'NK1_32': ('leaf', 'XAD', 'CONTACT_PERSON_S_ADDRESS', 'HL70000'),
 'NK1_33': ('leaf',
            'CX',
            'NEXT_OF_KIN_ASSOCIATED_PARTY_S_IDENTIFIERS',
            'HL70000'),
 'NK1_34': ('leaf', 'IS', 'JOB_STATUS', 'HL70311'),
 'NK1_35': ('leaf', 'CE', 'RACE', 'HL70005'),
 'NK1_36': ('leaf', 'IS', 'HANDICAP', 'HL70295'),
 'NK1_37': ('leaf', 'ST', 'CONTACT_PERSON_SOCIAL_SECURITY_NUMBER', 'HL70000'),
 'NK1_38': ('leaf', 'ST', 'NEXT_OF_KIN_BIRTH_PLACE', 'HL70000'),
 'NK1_39': ('leaf', 'IS', 'VIP_INDICATOR', 'HL70099'),
 'NK1_4': ('leaf', 'XAD', 'ADDRESS', 'HL70000'),
 'NK1_5': ('leaf', 'XTN', 'PHONE_NUMBER', 'HL70000'),
 'NK1_6': ('leaf', 'XTN', 'BUSINESS_PHONE_NUMBER', 'HL70000'),
 'NK1_7': ('leaf', 'CE', 'CONTACT_ROLE', 'HL70131'),
 'NK1_8': ('leaf', 'DT', 'START_DATE', 'HL70000'),
 'NK1_9': ('leaf', 'DT', 'END_DATE', 'HL70000'),
 'NPU_1': ('leaf', 'PL', 'BED_LOCATION', 'HL70000'),
 'NPU_2': ('leaf', 'IS', 'BED_STATUS', 'HL70116'),
 'NSC_1': ('leaf', 'IS', 'APPLICATION_CHANGE_TYPE', 'HL70409'),
 'NSC_2': ('leaf', 'ST', 'CURRENT_CPU', 'HL70000'),
 'NSC_3': ('leaf', 'ST', 'CURRENT_FILESERVER', 'HL70000'),
 'NSC_4': ('leaf', 'HD', 'CURRENT_APPLICATION', 'HL70000'),
 'NSC_5': ('leaf', 'HD', 'CURRENT_FACILITY', 'HL70000'),
 'NSC_6': ('leaf', 'ST', 'NEW_CPU', 'HL70000'),
 'NSC_7': ('leaf', 'ST', 'NEW_FILESERVER', 'HL70000'),
 'NSC_8': ('leaf', 'HD', 'NEW_APPLICATION', 'HL70000'),
 'NSC_9': ('leaf', 'HD', 'NEW_FACILITY', 'HL70000'),
 'NST_1': ('leaf', 'ID', 'STATISTICS_AVAILABLE', 'HL70136'),
 'NST_10': ('leaf', 'NM', 'CHECKSUM_ERRORS_RECEIVED', 'HL70000'),
 'NST_11': ('leaf', 'NM', 'LENGTH_ERRORS_RECEIVED', 'HL70000'),
 'NST_12': ('leaf', 'NM', 'OTHER_ERRORS_RECEIVED', 'HL70000'),
 'NST_13': ('leaf', 'NM', 'CONNECT_TIMEOUTS', 'HL70000'),
 'NST_14': ('leaf', 'NM', 'RECEIVE_TIMEOUTS', 'HL70000'),
 'NST_15': ('leaf', 'NM', 'APPLICATION_CONTROL_LEVEL_ERRORS', 'HL70000'),
 'NST_2': ('leaf', 'ST', 'SOURCE_IDENTIFIER', 'HL70000'),
 'NST_3': ('leaf', 'ID', 'SOURCE_TYPE', 'HL70332'),
 'NST_4': ('leaf', 'TS', 'STATISTICS_START', 'HL70000'),
 'NST_5': ('leaf', 'TS', 'STATISTICS_END', 'HL70000'),
 'NST_6': ('leaf', 'NM', 'RECEIVE_CHARACTER_COUNT', 'HL70000'),
 'NST_7': ('leaf', 'NM', 'SEND_CHARACTER_COUNT', 'HL70000'),
 'NST_8': ('leaf', 'NM', 'MESSAGES_RECEIVED', 'HL70000'),
 'NST_9': ('leaf', 'NM', 'MESSAGES_SENT', 'HL70000'),
 'NTE_1': ('leaf', 'SI', 'SET_ID_NTE', 'HL70000'),
 'NTE_2': ('leaf', 'ID', 'SOURCE_OF_COMMENT', 'HL70105'),
 'NTE_3': ('leaf', 'FT', 'COMMENT', 'HL70000'),
 'NTE_4': ('leaf', 'CE', 'COMMENT_TYPE', 'HL70364'),
 'OBR_1': ('leaf', 'SI', 'SET_ID_OBR', 'HL70000'),
 'OBR_10': ('leaf', 'XCN', 'COLLECTOR_IDENTIFIER', 'HL70000'),
 'OBR_11': ('leaf', 'ID', 'SPECIMEN_ACTION_CODE', 'HL70065'),
 'OBR_12': ('leaf', 'CE', 'DANGER_CODE', 'HL70000'),
 'OBR_13': ('leaf', 'ST', 'RELEVANT_CLINICAL_INFORMATION', 'HL70000'),
 'OBR_14': ('leaf', 'TS', 'SPECIMEN_RECEIVED_DATE_TIME', 'HL70000'),
 'OBR_15': ('leaf', 'SPS', 'SPECIMEN_SOURCE', 'HL70000'),
 'OBR_16': ('leaf', 'XCN', 'ORDERING_PROVIDER', 'HL70000'),
 'OBR_17': ('leaf', 'XTN', 'ORDER_CALLBACK_PHONE_NUMBER', 'HL70000'),
 'OBR_18': ('leaf', 'ST', 'PLACER_FIELD_1', 'HL70000'),
 'OBR_19': ('leaf', 'ST', 'PLACER_FIELD_2', 'HL70000'),
 'OBR_2': ('leaf', 'EI', 'PLACER_ORDER_NUMBER', 'HL70000'),
 'OBR_20': ('leaf', 'ST', 'FILLER_FIELD_1', 'HL70000'),
 'OBR_21': ('leaf', 'ST', 'FILLER_FIELD_2', 'HL70000'),
 'OBR_22': ('leaf', 'TS', 'RESULTS_RPT_STATUS_CHNG_DATE_TIME', 'HL70000'),
 'OBR_23': ('leaf', 'MOC', 'CHARGE_TO_PRACTICE', 'HL70000'),
 'OBR_24': ('leaf', 'ID', 'DIAGNOSTIC_SERV_SECT_ID', 'HL70074'),
 'OBR_25': ('leaf', 'ID', 'RESULT_STATUS', 'HL70123'),
 'OBR_26': ('leaf', 'PRL', 'PARENT_RESULT', 'HL70000'),
 'OBR_27': ('leaf', 'TQ', 'QUANTITY_TIMING', 'HL70000'),
 'OBR_28': ('leaf', 'XCN', 'RESULT_COPIES_TO', 'HL70000'),
 'OBR_29': ('leaf', 'EIP', 'PARENT', 'HL70000'),
 'OBR_3': ('leaf', 'EI', 'FILLER_ORDER_NUMBER', 'HL70000'),
 'OBR_30': ('leaf', 'ID', 'TRANSPORTATION_MODE', 'HL70124'),
 'OBR_31': ('leaf', 'CE', 'REASON_FOR_STUDY', 'HL70000'),
 'OBR_32': ('leaf', 'NDL', 'PRINCIPAL_RESULT_INTERPRETER', 'HL70000'),
 'OBR_33': ('leaf', 'NDL', 'ASSISTANT_RESULT_INTERPRETER', 'HL70000'),
 'OBR_34': ('leaf', 'NDL', 'TECHNICIAN', 'HL70000'),
 'OBR_35': ('leaf', 'NDL', 'TRANSCRIPTIONIST', 'HL70000'),
 'OBR_36': ('leaf', 'TS', 'SCHEDULED_DATE_TIME', 'HL70000'),
 'OBR_37': ('leaf', 'NM', 'NUMBER_OF_SAMPLE_CONTAINERS_', 'HL70000'),
 'OBR_38': ('leaf',
            'CE',
            'TRANSPORT_LOGISTICS_OF_COLLECTED_SAMPLE',
            'HL70000'),
 'OBR_39': ('leaf', 'CE', 'COLLECTOR_S_COMMENT_', 'HL70000'),
 'OBR_4': ('leaf', 'CE', 'UNIVERSAL_SERVICE_IDENTIFIER', 'HL70000'),
 'OBR_40': ('leaf', 'CE', 'TRANSPORT_ARRANGEMENT_RESPONSIBILITY', 'HL70000'),
 'OBR_41': ('leaf', 'ID', 'TRANSPORT_ARRANGED', 'HL70224'),
 'OBR_42': ('leaf', 'ID', 'ESCORT_REQUIRED', 'HL70225'),
 'OBR_43': ('leaf', 'CE', 'PLANNED_PATIENT_TRANSPORT_COMMENT', 'HL70000'),
 'OBR_44': ('leaf', 'CE', 'PROCEDURE_CODE', 'HL70088'),
 'OBR_45': ('leaf', 'CE', 'PROCEDURE_CODE_MODIFIER', 'HL70340'),
 'OBR_46': ('leaf',
            'CE',
            'PLACER_SUPPLEMENTAL_SERVICE_INFORMATION',
            'HL70411'),
 'OBR_47': ('leaf',
            'CE',
            'FILLER_SUPPLEMENTAL_SERVICE_INFORMATION',
            'HL70411'),
 'OBR_48': ('leaf',
            'CWE',
            'MEDICALLY_NECESSARY_DUPLICATE_PROCEDURE_REASON_',
            'HL70476'),
 'OBR_49': ('leaf', 'IS', 'RESULT_HANDLING', 'HL70507'),
 'OBR_5': ('leaf', 'ID', 'PRIORITY_OBR', 'HL70000'),
 'OBR_6': ('leaf', 'TS', 'REQUESTED_DATE_TIME', 'HL70000'),
 'OBR_7': ('leaf', 'TS', 'OBSERVATION_DATE_TIME', 'HL70000'),
 'OBR_8': ('leaf', 'TS', 'OBSERVATION_END_DATE_TIME', 'HL70000'),
 'OBR_9': ('leaf', 'CQ', 'COLLECTION_VOLUME', 'HL70000'),
 'OBX_1': ('leaf', 'SI', 'SET_ID_OBX', 'HL70000'),
 'OBX_10': ('leaf', 'ID', 'NATURE_OF_ABNORMAL_TEST', 'HL70080'),
 'OBX_11': ('leaf', 'ID', 'OBSERVATION_RESULT_STATUS', 'HL70085'),
 'OBX_12': ('leaf', 'TS', 'EFFECTIVE_DATE_OF_REFERENCE_RANGE', 'HL70000'),
 'OBX_13': ('leaf', 'ST', 'USER_DEFINED_ACCESS_CHECKS', 'HL70000'),
 'OBX_14': ('leaf', 'TS', 'DATE_TIME_OF_THE_OBSERVATION', 'HL70000'),
 'OBX_15': ('leaf', 'CE', 'PRODUCER_S_ID', 'HL70000'),
 'OBX_16': ('leaf', 'XCN', 'RESPONSIBLE_OBSERVER', 'HL70000'),
 'OBX_17': ('leaf', 'CE', 'OBSERVATION_METHOD', 'HL70000'),
 'OBX_18': ('leaf', 'EI', 'EQUIPMENT_INSTANCE_IDENTIFIER', 'HL70000'),
 'OBX_19': ('leaf', 'TS', 'DATE_TIME_OF_THE_ANALYSIS', 'HL70000'),
 'OBX_2': ('leaf', 'ID', 'VALUE_TYPE', 'HL70125'),
 'OBX_3': ('leaf', 'CE', 'OBSERVATION_IDENTIFIER', 'HL70000'),
 'OBX_4': ('leaf', 'ST', 'OBSERVATION_SUB_ID', 'HL70000'),
 'OBX_5': ('leaf', 'varies', 'OBSERVATION_VALUE', 'HL70000'),
 'OBX_6': ('leaf', 'CE', 'UNITS', 'HL70000'),
 'OBX_7': ('leaf', 'ST', 'REFERENCES_RANGE', 'HL70000'),
 'OBX_8': ('leaf', 'IS', 'ABNORMAL_FLAGS', 'HL70078'),
 'OBX_9': ('leaf', 'NM', 'PROBABILITY', 'HL70000'),
 'ODS_1': ('leaf', 'ID', 'TYPE', 'HL70159'),
 'ODS_2': ('leaf', 'CE', 'SERVICE_PERIOD', 'HL70000'),
 'ODS_3': ('leaf', 'CE', 'DIET_SUPPLEMENT_OR_PREFERENCE_CODE', 'HL70000'),
 'ODS_4': ('leaf', 'ST', 'TEXT_INSTRUCTION', 'HL70000'),
 'ODT_1': ('leaf', 'CE', 'TRAY_TYPE', 'HL70160'),
 'ODT_2': ('leaf', 'CE', 'SERVICE_PERIOD', 'HL70000'),
 'ODT_3': ('leaf', 'ST', 'TEXT_INSTRUCTION', 'HL70000'),
 'OM1_1': ('leaf',
           'NM',
           'SEQUENCE_NUMBER_TEST_OBSERVATION_MASTER_FILE',
           'HL70000'),
 'OM1_10': ('leaf',
            'ST',
            'PREFERRED_SHORT_NAME_OR_MNEMONIC_FOR_OBSERVATION',
            'HL70000'),
 'OM1_11': ('leaf',
            'ST',
            'PREFERRED_LONG_NAME_FOR_THE_OBSERVATION',
            'HL70000'),
 'OM1_12': ('leaf', 'ID', 'ORDERABILITY', 'HL70136'),
 'OM1_13': ('leaf',
            'CE',
            'IDENTITY_OF_INSTRUMENT_USED_TO_PERFORM_THIS_STUDY',
            'HL79999'),
 'OM1_14': ('leaf', 'CE', 'CODED_REPRESENTATION_OF_METHOD', 'HL79999'),
 'OM1_15': ('leaf', 'ID', 'PORTABLE_DEVICE_INDICATOR', 'HL70136'),
 'OM1_16': ('leaf',
            'CE',
            'OBSERVATION_PRODUCING_DEPARTMENT_SECTION',
            'HL79999'),
 'OM1_17': ('leaf', 'XTN', 'TELEPHONE_NUMBER_OF_SECTION', 'HL70000'),
 'OM1_18': ('leaf', 'IS', 'NATURE_OF_SERVICE_TEST_OBSERVATION', 'HL70174'),
 'OM1_19': ('leaf', 'CE', 'REPORT_SUBHEADER', 'HL79999'),
 'OM1_2': ('leaf', 'CE', 'PRODUCER_S_SERVICE_TEST_OBSERVATION_ID', 'HL79999'),
 'OM1_20': ('leaf', 'ST', 'REPORT_DISPLAY_ORDER', 'HL70000'),
 'OM1_21': ('leaf',
            'TS',
            'DATE_TIME_STAMP_FOR_ANY_CHANGE_IN_DEFINITION_FOR_THE_OBSERVATION',
            'HL70000'),
 'OM1_22': ('leaf', 'TS', 'EFFECTIVE_DATE_TIME_OF_CHANGE', 'HL70000'),
 'OM1_23': ('leaf', 'NM', 'TYPICAL_TURN_AROUND_TIME', 'HL70000'),
 'OM1_24': ('leaf', 'NM', 'PROCESSING_TIME', 'HL70000'),
 'OM1_25': ('leaf', 'ID', 'PROCESSING_PRIORITY', 'HL70168'),
 'OM1_26': ('leaf', 'ID', 'REPORTING_PRIORITY', 'HL70169'),
 'OM1_27': ('leaf',
            'CE',
            'OUTSIDE_SITE_S_WHERE_OBSERVATION_MAY_BE_PERFORMED',
            'HL79999'),
 'OM1_28': ('leaf', 'XAD', 'ADDRESS_OF_OUTSIDE_SITE_S_', 'HL70000'),
 'OM1_29': ('leaf', 'XTN', 'PHONE_NUMBER_OF_OUTSIDE_SITE', 'HL70000'),
 'OM1_3': ('leaf', 'ID', 'PERMITTED_DATA_TYPES', 'HL70125'),
 'OM1_30': ('leaf', 'CWE', 'CONFIDENTIALITY_CODE', 'HL70177'),
 'OM1_31': ('leaf',
            'CE',
            'OBSERVATIONS_REQUIRED_TO_INTERPRET_THE_OBSERVATION',
            'HL79999'),
 'OM1_32': ('leaf', 'TX', 'INTERPRETATION_OF_OBSERVATIONS', 'HL70000'),
 'OM1_33': ('leaf', 'CE', 'CONTRAINDICATIONS_TO_OBSERVATIONS', 'HL79999'),
 'OM1_34': ('leaf', 'CE', 'REFLEX_TESTS_OBSERVATIONS', 'HL79999'),
 'OM1_35': ('leaf', 'TX', 'RULES_THAT_TRIGGER_REFLEX_TESTING', 'HL70000'),
 'OM1_36': ('leaf', 'CE', 'FIXED_CANNED_MESSAGE', 'HL79999'),
 'OM1_37': ('leaf', 'TX', 'PATIENT_PREPARATION', 'HL70000'),
 'OM1_38': ('leaf', 'CE', 'PROCEDURE_MEDICATION', 'HL79999'),
 'OM1_39': ('leaf',
            'TX',
            'FACTORS_THAT_MAY_AFFECT_THE_OBSERVATION',
            'HL70000'),
 'OM1_4': ('leaf', 'ID', 'SPECIMEN_REQUIRED', 'HL70136'),
 'OM1_40': ('leaf',
            'ST',
            'SERVICE_TEST_OBSERVATION_PERFORMANCE_SCHEDULE',
            'HL70000'),
 'OM1_41': ('leaf', 'TX', 'DESCRIPTION_OF_TEST_METHODS', 'HL70000'),
 'OM1_42': ('leaf', 'CE', 'KIND_OF_QUANTITY_OBSERVED', 'HL70254'),
 'OM1_43': ('leaf', 'CE', 'POINT_VERSUS_INTERVAL', 'HL70255'),
 'OM1_44': ('leaf', 'TX', 'CHALLENGE_INFORMATION', 'HL70000'),
 'OM1_45': ('leaf', 'CE', 'RELATIONSHIP_MODIFIER', 'HL70258'),
 'OM1_46': ('leaf', 'CE', 'TARGET_ANATOMIC_SITE_OF_TEST', 'HL79999'),
 'OM1_47': ('leaf', 'CE', 'MODALITY_OF_IMAGING_MEASUREMENT', 'HL70259'),
 'OM1_5': ('leaf', 'CE', 'PRODUCER_ID', 'HL79999'),
 'OM1_6': ('leaf', 'TX', 'OBSERVATION_DESCRIPTION', 'HL70000'),
 'OM1_7': ('leaf',
           'CE',
           'OTHER_SERVICE_TEST_OBSERVATION_IDS_FOR_THE_OBSERVATION',
           'HL79999'),
 'OM1_8': ('leaf', 'ST', 'OTHER_NAMES', 'HL70000'),
 'OM1_9': ('leaf',
           'ST',
           'PREFERRED_REPORT_NAME_FOR_THE_OBSERVATION',
           'HL70000'),
 'OM2_1': ('leaf',
           'NM',
           'SEQUENCE_NUMBER_TEST_OBSERVATION_MASTER_FILE',
           'HL70000'),
 'OM2_10': ('leaf', 'NM', 'MINIMUM_MEANINGFUL_INCREMENTS', 'HL70000'),
 'OM2_2': ('leaf', 'CE', 'UNITS_OF_MEASURE', 'HL79999'),
 'OM2_3': ('leaf', 'NM', 'RANGE_OF_DECIMAL_PRECISION', 'HL70000'),
 'OM2_4': ('leaf', 'CE', 'CORRESPONDING_SI_UNITS_OF_MEASURE', 'HL79999'),
 'OM2_5': ('leaf', 'TX', 'SI_CONVERSION_FACTOR', 'HL70000'),
 'OM2_6': ('leaf',
           'RFR',
           'REFERENCE_NORMAL_RANGE_ORDINAL_AND_CONTINUOUS_OBSERVATIONS',
           'HL70000'),
 'OM2_7': ('leaf',
           'RFR',
           'CRITICAL_RANGE_FOR_ORDINAL_AND_CONTINUOUS_OBSERVATIONS',
           'HL70000'),
 'OM2_8': ('leaf',
           'RFR',
           'ABSOLUTE_RANGE_FOR_ORDINAL_AND_CONTINUOUS_OBSERVATIONS',
           'HL70000'),
 'OM2_9': ('leaf', 'DLT', 'DELTA_CHECK_CRITERIA', 'HL70000'),
 'OM3_1': ('leaf',
           'NM',
           'SEQUENCE_NUMBER_TEST_OBSERVATION_MASTER_FILE',
           'HL70000'),
 'OM3_2': ('leaf', 'CE', 'PREFERRED_CODING_SYSTEM', 'HL79999'),
 'OM3_3': ('leaf', 'CE', 'VALID_CODED_ANSWERS_', 'HL79999'),
 'OM3_4': ('leaf',
           'CE',
           'NORMAL_TEXT_CODES_FOR_CATEGORICAL_OBSERVATIONS',
           'HL79999'),
 'OM3_5': ('leaf',
           'CE',
           'ABNORMAL_TEXT_CODES_FOR_CATEGORICAL_OBSERVATIONS',
           'HL79999'),
 'OM3_6': ('leaf',
           'CE',
           'CRITICAL_TEXT_CODES_FOR_CATEGORICAL_OBSERVATIONS',
           'HL79999'),
 'OM3_7': ('leaf', 'ID', 'VALUE_TYPE', 'HL70125'),
 'OM4_1': ('leaf',
           'NM',
           'SEQUENCE_NUMBER_TEST_OBSERVATION_MASTER_FILE',
           'HL70000'),
 'OM4_10': ('leaf', 'CQ', 'NORMAL_COLLECTION_VOLUME', 'HL70000'),
 'OM4_11': ('leaf', 'CQ', 'MINIMUM_COLLECTION_VOLUME', 'HL70000'),
 'OM4_12': ('leaf', 'TX', 'SPECIMEN_REQUIREMENTS', 'HL70000'),
 'OM4_13': ('leaf', 'ID', 'SPECIMEN_PRIORITIES', 'HL70027'),
 'OM4_14': ('leaf', 'CQ', 'SPECIMEN_RETENTION_TIME', 'HL70000'),
 'OM4_2': ('leaf', 'ID', 'DERIVED_SPECIMEN', 'HL70170'),
 'OM4_3': ('leaf', 'TX', 'CONTAINER_DESCRIPTION', 'HL70000'),
 'OM4_4': ('leaf', 'NM', 'CONTAINER_VOLUME', 'HL70000'),
 'OM4_5': ('leaf', 'CE', 'CONTAINER_UNITS', 'HL79999'),
 'OM4_6': ('leaf', 'CE', 'SPECIMEN', 'HL79999'),
 'OM4_7': ('leaf', 'CWE', 'ADDITIVE', 'HL70371'),
 'OM4_8': ('leaf', 'TX', 'PREPARATION', 'HL70000'),
 'OM4_9': ('leaf', 'TX', 'SPECIAL_HANDLING_REQUIREMENTS', 'HL70000'),
 'OM5_1': ('leaf',
           'NM',
           'SEQUENCE_NUMBER_TEST_OBSERVATION_MASTER_FILE',
           'HL70000'),
 'OM5_2': ('leaf',
           'CE',
           'TEST_OBSERVATIONS_INCLUDED_WITHIN_AN_ORDERED_TEST_BATTERY',
           'HL79999'),
 'OM5_3': ('leaf', 'ST', 'OBSERVATION_ID_SUFFIXES', 'HL70000'),
 'OM6_1': ('leaf',
           'NM',
           'SEQUENCE_NUMBER_TEST_OBSERVATION_MASTER_FILE',
           'HL70000'),
 'OM6_2': ('leaf', 'TX', 'DERIVATION_RULE', 'HL70000'),
 'OM7_1': ('leaf',
           'NM',
           'SEQUENCE_NUMBER_TEST_OBSERVATION_MASTER_FILE',
           'HL70000'),
 'OM7_10': ('leaf', 'IS', 'TEST_SERVICE_DEFAULT_FREQUENCY', 'HL70335'),
 'OM7_11': ('leaf', 'ID', 'CONSENT_INDICATOR', 'HL70136'),
 'OM7_12': ('leaf', 'CE', 'CONSENT_IDENTIFIER', 'HL70413'),
 'OM7_13': ('leaf', 'TS', 'CONSENT_EFFECTIVE_START_DATE_TIME', 'HL70000'),
 'OM7_14': ('leaf', 'TS', 'CONSENT_EFFECTIVE_END_DATE_TIME', 'HL70000'),
 'OM7_15': ('leaf', 'NM', 'CONSENT_INTERVAL_QUANTITY', 'HL70000'),
 'OM7_16': ('leaf', 'CE', 'CONSENT_INTERVAL_UNITS', 'HL70414'),
 'OM7_17': ('leaf', 'NM', 'CONSENT_WAITING_PERIOD_QUANTITY', 'HL70000'),
 'OM7_18': ('leaf', 'CE', 'CONSENT_WAITING_PERIOD_UNITS', 'HL70414'),
 'OM7_19': ('leaf', 'TS', 'EFFECTIVE_DATE_TIME_OF_CHANGE', 'HL70000'),
 'OM7_2': ('leaf', 'CE', 'UNIVERSAL_SERVICE_IDENTIFIER', 'HL70000'),
 'OM7_20': ('leaf', 'XCN', 'ENTERED_BY', 'HL70000'),
 'OM7_21': ('leaf', 'PL', 'ORDERABLE_AT_LOCATION', 'HL70000'),
 'OM7_22': ('leaf', 'IS', 'FORMULARY_STATUS', 'HL70473'),
 'OM7_23': ('leaf', 'ID', 'SPECIAL_ORDER_INDICATOR', 'HL70136'),
 'OM7_24': ('leaf', 'CE', 'PRIMARY_KEY_VALUE_CDM', 'HL70132'),
 'OM7_3': ('leaf', 'CE', 'CATEGORY_IDENTIFIER', 'HL70412'),
 'OM7_4': ('leaf', 'TX', 'CATEGORY_DESCRIPTION', 'HL70000'),
 'OM7_5': ('leaf', 'ST', 'CATEGORY_SYNONYM', 'HL70000'),
 'OM7_6': ('leaf', 'TS', 'EFFECTIVE_TEST_SERVICE_START_DATE_TIME', 'HL70000'),
 'OM7_7': ('leaf', 'TS', 'EFFECTIVE_TEST_SERVICE_END_DATE_TIME', 'HL70000'),
 'OM7_8': ('leaf', 'NM', 'TEST_SERVICE_DEFAULT_DURATION_QUANTITY', 'HL70000'),
 'OM7_9': ('leaf', 'CE', 'TEST_SERVICE_DEFAULT_DURATION_UNITS', 'HL79999'),
 'ORC_1': ('leaf', 'ID', 'ORDER_CONTROL', 'HL70119'),
 'ORC_10': ('leaf', 'XCN', 'ENTERED_BY', 'HL70000'),
 'ORC_11': ('leaf', 'XCN', 'VERIFIED_BY', 'HL70000'),
 'ORC_12': ('leaf', 'XCN', 'ORDERING_PROVIDER', 'HL70000'),
 'ORC_13': ('leaf', 'PL', 'ENTERER_S_LOCATION', 'HL70000'),
 'ORC_14': ('leaf', 'XTN', 'CALL_BACK_PHONE_NUMBER', 'HL70000'),
 'ORC_15': ('leaf', 'TS', 'ORDER_EFFECTIVE_DATE_TIME', 'HL70000'),
 'ORC_16': ('leaf', 'CE', 'ORDER_CONTROL_CODE_REASON', 'HL70000'),
 'ORC_17': ('leaf', 'CE', 'ENTERING_ORGANIZATION', 'HL70000'),
 'ORC_18': ('leaf', 'CE', 'ENTERING_DEVICE', 'HL70000'),
 'ORC_19': ('leaf', 'XCN', 'ACTION_BY', 'HL70000'),
 'ORC_2': ('leaf', 'EI', 'PLACER_ORDER_NUMBER', 'HL70000'),
 'ORC_20': ('leaf', 'CE', 'ADVANCED_BENEFICIARY_NOTICE_CODE', 'HL70339'),
 'ORC_21': ('leaf', 'XON', 'ORDERING_FACILITY_NAME', 'HL70000'),
 'ORC_22': ('leaf', 'XAD', 'ORDERING_FACILITY_ADDRESS', 'HL70000'),
 'ORC_23': ('leaf', 'XTN', 'ORDERING_FACILITY_PHONE_NUMBER', 'HL70000'),
 'ORC_24': ('leaf', 'XAD', 'ORDERING_PROVIDER_ADDRESS', 'HL70000'),
 'ORC_25': ('leaf', 'CWE', 'ORDER_STATUS_MODIFIER', 'HL70000'),
 'ORC_26': ('leaf',
            'CWE',
            'ADVANCED_BENEFICIARY_NOTICE_OVERRIDE_REASON',
            'HL70552'),
 'ORC_27': ('leaf',
            'TS',
            'FILLER_S_EXPECTED_AVAILABILITY_DATE_TIME',
            'HL70000'),
 'ORC_28': ('leaf', 'CWE', 'CONFIDENTIALITY_CODE', 'HL70177'),
 'ORC_29': ('leaf', 'CWE', 'ORDER_TYPE', 'HL70482'),
 'ORC_3': ('leaf', 'EI', 'FILLER_ORDER_NUMBER', 'HL70000'),
 'ORC_30': ('leaf', 'CNE', 'ENTERER_AUTHORIZATION_MODE', 'HL70483'),
 'ORC_4': ('leaf', 'EI', 'PLACER_GROUP_NUMBER', 'HL70000'),
 'ORC_5': ('leaf', 'ID', 'ORDER_STATUS', 'HL70038'),
 'ORC_6': ('leaf', 'ID', 'RESPONSE_FLAG', 'HL70121'),
 'ORC_7': ('leaf', 'TQ', 'QUANTITY_TIMING', 'HL70000'),
 'ORC_8': ('leaf', 'EIP', 'PARENT', 'HL70000'),
 'ORC_9': ('leaf', 'TS', 'DATE_TIME_OF_TRANSACTION', 'HL70000'),
 'ORG_1': ('leaf', 'SI', 'SET_ID_ORG', 'HL70000'),
 'ORG_10': ('leaf', 'CE', 'EMPLOYMENT_STATUS_CODE', 'HL70066'),
 'ORG_11': ('leaf', 'ID', 'BOARD_APPROVAL_INDICATOR', 'HL70136'),
 'ORG_12': ('leaf', 'ID', 'PRIMARY_CARE_PHYSICIAN_INDICATOR', 'HL70136'),
 'ORG_2': ('leaf', 'CE', 'ORGANIZATION_UNIT_CODE', 'HL70405'),
 'ORG_3': ('leaf', 'CE', 'ORGANIZATION_UNIT_TYPE_CODE', 'HL70474'),
 'ORG_4': ('leaf', 'ID', 'PRIMARY_ORG_UNIT_INDICATOR', 'HL70136'),
 'ORG_5': ('leaf', 'CX', 'PRACTITIONER_ORG_UNIT_IDENTIFIER', 'HL70000'),
 'ORG_6': ('leaf', 'CE', 'HEALTH_CARE_PROVIDER_TYPE_CODE', 'HL70452'),
 'ORG_7': ('leaf',
           'CE',
           'HEALTH_CARE_PROVIDER_CLASSIFICATION_CODE',
           'HL70453'),
 'ORG_8': ('leaf',
           'CE',
           'HEALTH_CARE_PROVIDER_AREA_OF_SPECIALIZATION_CODE',
           'HL70454'),
 'ORG_9': ('leaf', 'DR', 'EFFECTIVE_DATE_RANGE', 'HL70000'),
 'OVR_1': ('leaf', 'CWE', 'BUSINESS_RULE_OVERRIDE_TYPE', 'HL70518'),
 'OVR_2': ('leaf', 'CWE', 'BUSINESS_RULE_OVERRIDE_CODE', 'HL70521'),
 'OVR_3': ('leaf', 'TX', 'OVERRIDE_COMMENTS', 'HL70000'),
 'OVR_4': ('leaf', 'XCN', 'OVERRIDE_ENTERED_BY', 'HL70000'),
 'OVR_5': ('leaf', 'XCN', 'OVERRIDE_AUTHORIZED_BY', 'HL70000'),
 'PCR_1': ('leaf', 'CE', 'IMPLICATED_PRODUCT', 'HL70000'),
 'PCR_10': ('leaf', 'CE', 'INDICATION_FOR_PRODUCT_USE', 'HL70000'),
 'PCR_11': ('leaf', 'IS', 'PRODUCT_PROBLEM', 'HL70245'),
 'PCR_12': ('leaf', 'ST', 'PRODUCT_SERIAL_LOT_NUMBER', 'HL70000'),
 'PCR_13': ('leaf', 'IS', 'PRODUCT_AVAILABLE_FOR_INSPECTION', 'HL70246'),
 'PCR_14': ('leaf', 'CE', 'PRODUCT_EVALUATION_PERFORMED', 'HL70000'),
 'PCR_15': ('leaf', 'CE', 'PRODUCT_EVALUATION_STATUS', 'HL70247'),
 'PCR_16': ('leaf', 'CE', 'PRODUCT_EVALUATION_RESULTS', 'HL70000'),
 'PCR_17': ('leaf', 'ID', 'EVALUATED_PRODUCT_SOURCE', 'HL70248'),
 'PCR_18': ('leaf', 'TS', 'DATE_PRODUCT_RETURNED_TO_MANUFACTURER', 'HL70000'),
 'PCR_19': ('leaf', 'ID', 'DEVICE_OPERATOR_QUALIFICATIONS', 'HL70242'),
 'PCR_2': ('leaf', 'IS', 'GENERIC_PRODUCT', 'HL70249'),
 'PCR_20': ('leaf', 'ID', 'RELATEDNESS_ASSESSMENT', 'HL70250'),
 'PCR_21': ('leaf', 'ID', 'ACTION_TAKEN_IN_RESPONSE_TO_THE_EVENT', 'HL70251'),
 'PCR_22': ('leaf', 'ID', 'EVENT_CAUSALITY_OBSERVATIONS', 'HL70252'),
 'PCR_23': ('leaf', 'ID', 'INDIRECT_EXPOSURE_MECHANISM', 'HL70253'),
 'PCR_3': ('leaf', 'CE', 'PRODUCT_CLASS', 'HL70000'),
 'PCR_4': ('leaf', 'CQ', 'TOTAL_DURATION_OF_THERAPY', 'HL70000'),
 'PCR_5': ('leaf', 'TS', 'PRODUCT_MANUFACTURE_DATE', 'HL70000'),
 'PCR_6': ('leaf', 'TS', 'PRODUCT_EXPIRATION_DATE', 'HL70000'),
 'PCR_7': ('leaf', 'TS', 'PRODUCT_IMPLANTATION_DATE', 'HL70000'),
 'PCR_8': ('leaf', 'TS', 'PRODUCT_EXPLANTATION_DATE', 'HL70000'),
 'PCR_9': ('leaf', 'IS', 'SINGLE_USE_DEVICE', 'HL70244'),
 'PD1_1': ('leaf', 'IS', 'LIVING_DEPENDENCY', 'HL70223'),
 'PD1_10': ('leaf', 'CX', 'DUPLICATE_PATIENT', 'HL70000'),
 'PD1_11': ('leaf', 'CE', 'PUBLICITY_CODE', 'HL70215'),
 'PD1_12': ('leaf', 'ID', 'PROTECTION_INDICATOR', 'HL70136'),
 'PD1_13': ('leaf', 'DT', 'PROTECTION_INDICATOR_EFFECTIVE_DATE', 'HL70000'),
 'PD1_14': ('leaf', 'XON', 'PLACE_OF_WORSHIP', 'HL70000'),
 'PD1_15': ('leaf', 'CE', 'ADVANCE_DIRECTIVE_CODE', 'HL70435'),
 'PD1_16': ('leaf', 'IS', 'IMMUNIZATION_REGISTRY_STATUS', 'HL70441'),
 'PD1_17': ('leaf',
            'DT',
            'IMMUNIZATION_REGISTRY_STATUS_EFFECTIVE_DATE',
            'HL70000'),
 'PD1_18': ('leaf', 'DT', 'PUBLICITY_CODE_EFFECTIVE_DATE', 'HL70000'),
 'PD1_19': ('leaf', 'IS', 'MILITARY_BRANCH', 'HL70140'),
 'PD1_2': ('leaf', 'IS', 'LIVING_ARRANGEMENT', 'HL70220'),
 'PD1_20': ('leaf', 'IS', 'MILITARY_RANK_GRADE', 'HL70141'),
 'PD1_21': ('leaf', 'IS', 'MILITARY_STATUS', 'HL70142'),
 'PD1_3': ('leaf', 'XON', 'PATIENT_PRIMARY_FACILITY', 'HL70000'),
 'PD1_4': ('leaf',
           'XCN',
           'PATIENT_PRIMARY_CARE_PROVIDER_NAME_ID_NO_',
           'HL70000'),
 'PD1_5': ('leaf', 'IS', 'STUDENT_INDICATOR', 'HL70231'),
 'PD1_6': ('leaf', 'IS', 'HANDICAP', 'HL70295'),
 'PD1_7': ('leaf', 'IS', 'LIVING_WILL_CODE', 'HL70315'),
 'PD1_8': ('leaf', 'IS', 'ORGAN_DONOR_CODE', 'HL70316'),
 'PD1_9': ('leaf', 'ID', 'SEPARATE_BILL', 'HL70136'),
 'PDA_1': ('leaf', 'CE', 'DEATH_CAUSE_CODE', 'HL70000'),
 'PDA_2': ('leaf', 'PL', 'DEATH_LOCATION', 'HL70000'),
 'PDA_3': ('leaf', 'ID', 'DEATH_CERTIFIED_INDICATOR', 'HL70136'),
 'PDA_4': ('leaf', 'TS', 'DEATH_CERTIFICATE_SIGNED_DATE_TIME', 'HL70000'),
 'PDA_5': ('leaf', 'XCN', 'DEATH_CERTIFIED_BY', 'HL70000'),
 'PDA_6': ('leaf', 'ID', 'AUTOPSY_INDICATOR', 'HL70136'),
 'PDA_7': ('leaf', 'DR', 'AUTOPSY_START_AND_END_DATE_TIME', 'HL70000'),
 'PDA_8': ('leaf', 'XCN', 'AUTOPSY_PERFORMED_BY', 'HL70000'),
 'PDA_9': ('leaf', 'ID', 'CORONER_INDICATOR', 'HL70136'),
 'PDC_1': ('leaf', 'XON', 'MANUFACTURER_DISTRIBUTOR', 'HL70000'),
 'PDC_10': ('leaf', 'ID', 'MARKETING_BASIS', 'HL70330'),
 'PDC_11': ('leaf', 'ST', 'MARKETING_APPROVAL_ID', 'HL70000'),
 'PDC_12': ('leaf', 'CQ', 'LABELED_SHELF_LIFE', 'HL70000'),
 'PDC_13': ('leaf', 'CQ', 'EXPECTED_SHELF_LIFE', 'HL70000'),
 'PDC_14': ('leaf', 'TS', 'DATE_FIRST_MARKETED', 'HL70000'),
 'PDC_15': ('leaf', 'TS', 'DATE_LAST_MARKETED', 'HL70000'),
 'PDC_2': ('leaf', 'CE', 'COUNTRY', 'HL70000'),
 'PDC_3': ('leaf', 'ST', 'BRAND_NAME', 'HL70000'),
 'PDC_4': ('leaf', 'ST', 'DEVICE_FAMILY_NAME', 'HL70000'),
 'PDC_5': ('leaf', 'CE', 'GENERIC_NAME', 'HL70000'),
 'PDC_6': ('leaf', 'ST', 'MODEL_IDENTIFIER', 'HL70000'),
 'PDC_7': ('leaf', 'ST', 'CATALOGUE_IDENTIFIER', 'HL70000'),
 'PDC_8': ('leaf', 'ST', 'OTHER_IDENTIFIER', 'HL70000'),
 'PDC_9': ('leaf', 'CE', 'PRODUCT_CODE', 'HL70000'),
 'PEO_1': ('leaf', 'CE', 'EVENT_IDENTIFIERS_USED', 'HL70000'),
 'PEO_10': ('leaf', 'ID', 'EVENT_EXPECTED', 'HL70239'),
 'PEO_11': ('leaf', 'ID', 'EVENT_OUTCOME', 'HL70240'),
 'PEO_12': ('leaf', 'ID', 'PATIENT_OUTCOME', 'HL70241'),
 'PEO_13': ('leaf', 'FT', 'EVENT_DESCRIPTION_FROM_OTHERS', 'HL70000'),
 'PEO_14': ('leaf', 'FT', 'EVENT_FROM_ORIGINAL_REPORTER', 'HL70000'),
 'PEO_15': ('leaf', 'FT', 'EVENT_DESCRIPTION_FROM_PATIENT', 'HL70000'),
 'PEO_16': ('leaf', 'FT', 'EVENT_DESCRIPTION_FROM_PRACTITIONER', 'HL70000'),
 'PEO_17': ('leaf', 'FT', 'EVENT_DESCRIPTION_FROM_AUTOPSY', 'HL70000'),
 'PEO_18': ('leaf', 'CE', 'CAUSE_OF_DEATH', 'HL70000'),
 'PEO_19': ('leaf', 'XPN', 'PRIMARY_OBSERVER_NAME', 'HL70000'),
 'PEO_2': ('leaf', 'CE', 'EVENT_SYMPTOM_DIAGNOSIS_CODE', 'HL70000'),
 'PEO_20': ('leaf', 'XAD', 'PRIMARY_OBSERVER_ADDRESS', 'HL70000'),
 'PEO_21': ('leaf', 'XTN', 'PRIMARY_OBSERVER_TELEPHONE', 'HL70000'),
 'PEO_22': ('leaf', 'ID', 'PRIMARY_OBSERVER_S_QUALIFICATION', 'HL70242'),
 'PEO_23': ('leaf', 'ID', 'CONFIRMATION_PROVIDED_BY', 'HL70242'),
 'PEO_24': ('leaf', 'TS', 'PRIMARY_OBSERVER_AWARE_DATE_TIME', 'HL70000'),
 'PEO_25': ('leaf',
            'ID',
            'PRIMARY_OBSERVER_S_IDENTITY_MAY_BE_DIVULGED',
            'HL70243'),
 'PEO_3': ('leaf', 'TS', 'EVENT_ONSET_DATE_TIME', 'HL70000'),
 'PEO_4': ('leaf', 'TS', 'EVENT_EXACERBATION_DATE_TIME', 'HL70000'),
 'PEO_5': ('leaf', 'TS', 'EVENT_IMPROVED_DATE_TIME', 'HL70000'),
 'PEO_6': ('leaf', 'TS', 'EVENT_ENDED_DATA_TIME', 'HL70000'),
 'PEO_7': ('leaf', 'XAD', 'EVENT_LOCATION_OCCURRED_ADDRESS', 'HL70000'),
 'PEO_8': ('leaf', 'ID', 'EVENT_QUALIFICATION', 'HL70237'),
 'PEO_9': ('leaf', 'ID', 'EVENT_SERIOUS', 'HL70238'),
 'PES_1': ('leaf', 'XON', 'SENDER_ORGANIZATION_NAME', 'HL70000'),
 'PES_10': ('leaf', 'TS', 'EVENT_REPORT_DATE', 'HL70000'),
 'PES_11': ('leaf', 'ID', 'EVENT_REPORT_TIMING_TYPE', 'HL70234'),
 'PES_12': ('leaf', 'ID', 'EVENT_REPORT_SOURCE', 'HL70235'),
 'PES_13': ('leaf', 'ID', 'EVENT_REPORTED_TO', 'HL70236'),
 'PES_2': ('leaf', 'XCN', 'SENDER_INDIVIDUAL_NAME', 'HL70000'),
 'PES_3': ('leaf', 'XAD', 'SENDER_ADDRESS', 'HL70000'),
 'PES_4': ('leaf', 'XTN', 'SENDER_TELEPHONE', 'HL70000'),
 'PES_5': ('leaf', 'EI', 'SENDER_EVENT_IDENTIFIER', 'HL70000'),
 'PES_6': ('leaf', 'NM', 'SENDER_SEQUENCE_NUMBER', 'HL70000'),
 'PES_7': ('leaf', 'FT', 'SENDER_EVENT_DESCRIPTION', 'HL70000'),
 'PES_8': ('leaf', 'FT', 'SENDER_COMMENT', 'HL70000'),
 'PES_9': ('leaf', 'TS', 'SENDER_AWARE_DATE_TIME', 'HL70000'),
 'PID_1': ('leaf', 'SI', 'SET_ID_PID', 'HL70000'),
 'PID_10': ('leaf', 'CE', 'RACE', 'HL70005'),
 'PID_11': ('leaf', 'XAD', 'PATIENT_ADDRESS', 'HL70000'),
 'PID_12': ('leaf', 'IS', 'COUNTY_CODE', 'HL70289'),
 'PID_13': ('leaf', 'XTN', 'PHONE_NUMBER_HOME', 'HL70000'),
 'PID_14': ('leaf', 'XTN', 'PHONE_NUMBER_BUSINESS', 'HL70000'),
 'PID_15': ('leaf', 'CE', 'PRIMARY_LANGUAGE', 'HL70296'),
 'PID_16': ('leaf', 'CE', 'MARITAL_STATUS', 'HL70002'),
 'PID_17': ('leaf', 'CE', 'RELIGION', 'HL70006'),
 'PID_18': ('leaf', 'CX', 'PATIENT_ACCOUNT_NUMBER', 'HL70000'),
 'PID_19': ('leaf', 'ST', 'SSN_NUMBER_PATIENT', 'HL70000'),
 'PID_2': ('leaf', 'CX', 'PATIENT_ID', 'HL70000'),
 'PID_20': ('leaf', 'DLN', 'DRIVER_S_LICENSE_NUMBER_PATIENT', 'HL70000'),
 'PID_21': ('leaf', 'CX', 'MOTHER_S_IDENTIFIER', 'HL70000'),
 'PID_22': ('leaf', 'CE', 'ETHNIC_GROUP', 'HL70189'),
 'PID_23': ('leaf', 'ST', 'BIRTH_PLACE', 'HL70000'),
 'PID_24': ('leaf', 'ID', 'MULTIPLE_BIRTH_INDICATOR', 'HL70136'),
 'PID_25': ('leaf', 'NM', 'BIRTH_ORDER', 'HL70000'),
 'PID_26': ('leaf', 'CE', 'CITIZENSHIP', 'HL70171'),
 'PID_27': ('leaf', 'CE', 'VETERANS_MILITARY_STATUS', 'HL70172'),
 'PID_28': ('leaf', 'CE', 'NATIONALITY', 'HL70212'),
 'PID_29': ('leaf', 'TS', 'PATIENT_DEATH_DATE_AND_TIME', 'HL70000'),
 'PID_3': ('leaf', 'CX', 'PATIENT_IDENTIFIER_LIST', 'HL70000'),
 'PID_30': ('leaf', 'ID', 'PATIENT_DEATH_INDICATOR', 'HL70136'),
 'PID_31': ('leaf', 'ID', 'IDENTITY_UNKNOWN_INDICATOR', 'HL70136'),
 'PID_32': ('leaf', 'IS', 'IDENTITY_RELIABILITY_CODE', 'HL70445'),
 'PID_33': ('leaf', 'TS', 'LAST_UPDATE_DATE_TIME', 'HL70000'),
 'PID_34': ('leaf', 'HD', 'LAST_UPDATE_FACILITY', 'HL70000'),
 'PID_35': ('leaf', 'CE', 'SPECIES_CODE', 'HL70446'),
 'PID_36': ('leaf', 'CE', 'BREED_CODE', 'HL70447'),
 'PID_37': ('leaf', 'ST', 'STRAIN', 'HL70000'),
 'PID_38': ('leaf', 'CE', 'PRODUCTION_CLASS_CODE', 'HL70429'),
 'PID_39': ('leaf', 'CWE', 'TRIBAL_CITIZENSHIP', 'HL70171'),
 'PID_4': ('leaf', 'CX', 'ALTERNATE_PATIENT_ID_PID', 'HL70000'),
 'PID_5': ('leaf', 'XPN', 'PATIENT_NAME', 'HL70000'),
 'PID_6': ('leaf', 'XPN', 'MOTHER_S_MAIDEN_NAME', 'HL70000'),
 'PID_7': ('leaf', 'TS', 'DATE_TIME_OF_BIRTH', 'HL70000'),
 'PID_8': ('leaf', 'IS', 'ADMINISTRATIVE_SEX', 'HL70001'),
 'PID_9': ('leaf', 'XPN', 'PATIENT_ALIAS', 'HL70000'),
 'PR1_1': ('leaf', 'SI', 'SET_ID_PR1', 'HL70000'),
 'PR1_10': ('leaf', 'NM', 'ANESTHESIA_MINUTES', 'HL70000'),
 'PR1_11': ('leaf', 'XCN', 'SURGEON', 'HL70010'),
 'PR1_12': ('leaf', 'XCN', 'PROCEDURE_PRACTITIONER', 'HL70010'),
 'PR1_13': ('leaf', 'CE', 'CONSENT_CODE', 'HL70059'),
 'PR1_14': ('leaf', 'ID', 'PROCEDURE_PRIORITY', 'HL70418'),
 'PR1_15': ('leaf', 'CE', 'ASSOCIATED_DIAGNOSIS_CODE', 'HL70051'),
 'PR1_16': ('leaf', 'CE', 'PROCEDURE_CODE_MODIFIER', 'HL70340'),
 'PR1_17': ('leaf', 'IS', 'PROCEDURE_DRG_TYPE', 'HL70416'),
 'PR1_18': ('leaf', 'CE', 'TISSUE_TYPE_CODE', 'HL70417'),
 'PR1_19': ('leaf', 'EI', 'PROCEDURE_IDENTIFIER', 'HL70000'),
 'PR1_2': ('leaf', 'IS', 'PROCEDURE_CODING_METHOD', 'HL70089'),
 'PR1_20': ('leaf', 'ID', 'PROCEDURE_ACTION_CODE', 'HL70206'),
 'PR1_3': ('leaf', 'CE', 'PROCEDURE_CODE', 'HL70088'),
 'PR1_4': ('leaf', 'ST', 'PROCEDURE_DESCRIPTION', 'HL70000'),
 'PR1_5': ('leaf', 'TS', 'PROCEDURE_DATE_TIME', 'HL70000'),
 'PR1_6': ('leaf', 'IS', 'PROCEDURE_FUNCTIONAL_TYPE', 'HL70230'),
 'PR1_7': ('leaf', 'NM', 'PROCEDURE_MINUTES', 'HL70000'),
 'PR1_8': ('leaf', 'XCN', 'ANESTHESIOLOGIST', 'HL70010'),
 'PR1_9': ('leaf', 'IS', 'ANESTHESIA_CODE', 'HL70019'),
 'PRA_1': ('leaf', 'CE', 'PRIMARY_KEY_VALUE_PRA', 'HL79999'),
 'PRA_10': ('leaf', 'DT', 'DATE_LEFT_PRACTICE', 'HL70000'),
 'PRA_11': ('leaf',
            'CE',
            'GOVERNMENT_REIMBURSEMENT_BILLING_ELIGIBILITY',
            'HL70401'),
 'PRA_12': ('leaf', 'SI', 'SET_ID_PRA', 'HL70000'),
 'PRA_2': ('leaf', 'CE', 'PRACTITIONER_GROUP', 'HL70358'),
 'PRA_3': ('leaf', 'IS', 'PRACTITIONER_CATEGORY', 'HL70186'),
 'PRA_4': ('leaf', 'ID', 'PROVIDER_BILLING', 'HL70187'),
 'PRA_5': ('leaf', 'SPD', 'SPECIALTY', 'HL70337'),
 'PRA_6': ('leaf', 'PLN', 'PRACTITIONER_ID_NUMBERS', 'HL70338'),
 'PRA_7': ('leaf', 'PIP', 'PRIVILEGES', 'HL70000'),
 'PRA_8': ('leaf', 'DT', 'DATE_ENTERED_PRACTICE', 'HL70000'),
 'PRA_9': ('leaf', 'CE', 'INSTITUTION', 'HL70537'),
 'PRB_1': ('leaf', 'ID', 'ACTION_CODE', 'HL70287'),
 'PRB_10': ('leaf', 'CE', 'PROBLEM_CLASSIFICATION', 'HL70000'),
 'PRB_11': ('leaf', 'CE', 'PROBLEM_MANAGEMENT_DISCIPLINE', 'HL70000'),
 'PRB_12': ('leaf', 'CE', 'PROBLEM_PERSISTENCE', 'HL70000'),
 'PRB_13': ('leaf', 'CE', 'PROBLEM_CONFIRMATION_STATUS', 'HL70000'),
 'PRB_14': ('leaf', 'CE', 'PROBLEM_LIFE_CYCLE_STATUS', 'HL70000'),
 'PRB_15': ('leaf', 'TS', 'PROBLEM_LIFE_CYCLE_STATUS_DATE_TIME', 'HL70000'),
 'PRB_16': ('leaf', 'TS', 'PROBLEM_DATE_OF_ONSET', 'HL70000'),
 'PRB_17': ('leaf', 'ST', 'PROBLEM_ONSET_TEXT', 'HL70000'),
 'PRB_18': ('leaf', 'CE', 'PROBLEM_RANKING', 'HL70000'),
 'PRB_19': ('leaf', 'CE', 'CERTAINTY_OF_PROBLEM', 'HL70000'),
 'PRB_2': ('leaf', 'TS', 'ACTION_DATE_TIME', 'HL70000'),
 'PRB_20': ('leaf', 'NM', 'PROBABILITY_OF_PROBLEM_0_1_', 'HL70000'),
 'PRB_21': ('leaf', 'CE', 'INDIVIDUAL_AWARENESS_OF_PROBLEM', 'HL70000'),
 'PRB_22': ('leaf', 'CE', 'PROBLEM_PROGNOSIS', 'HL70000'),
 'PRB_23': ('leaf', 'CE', 'INDIVIDUAL_AWARENESS_OF_PROGNOSIS', 'HL70000'),
 'PRB_24': ('leaf',
            'ST',
            'FAMILY_SIGNIFICANT_OTHER_AWARENESS_OF_PROBLEM_PROGNOSIS',
            'HL70000'),
 'PRB_25': ('leaf', 'CE', 'SECURITY_SENSITIVITY', 'HL70000'),
 'PRB_3': ('leaf', 'CE', 'PROBLEM_ID', 'HL70000'),
 'PRB_4': ('leaf', 'EI', 'PROBLEM_INSTANCE_ID', 'HL70000'),
 'PRB_5': ('leaf', 'EI', 'EPISODE_OF_CARE_ID', 'HL70000'),
 'PRB_6': ('leaf', 'NM', 'PROBLEM_LIST_PRIORITY', 'HL70000'),
 'PRB_7': ('leaf', 'TS', 'PROBLEM_ESTABLISHED_DATE_TIME', 'HL70000'),
 'PRB_8': ('leaf',
           'TS',
           'ANTICIPATED_PROBLEM_RESOLUTION_DATE_TIME',
           'HL70000'),
 'PRB_9': ('leaf', 'TS', 'ACTUAL_PROBLEM_RESOLUTION_DATE_TIME', 'HL70000'),
 'PRC_1': ('leaf', 'CE', 'PRIMARY_KEY_VALUE_PRC', 'HL70132'),
 'PRC_10': ('leaf', 'MO', 'MAXIMUM_PRICE', 'HL70000'),
 'PRC_11': ('leaf', 'TS', 'EFFECTIVE_START_DATE', 'HL70000'),
 'PRC_12': ('leaf', 'TS', 'EFFECTIVE_END_DATE', 'HL70000'),
 'PRC_13': ('leaf', 'IS', 'PRICE_OVERRIDE_FLAG', 'HL70268'),
 'PRC_14': ('leaf', 'CE', 'BILLING_CATEGORY', 'HL70293'),
 'PRC_15': ('leaf', 'ID', 'CHARGEABLE_FLAG', 'HL70136'),
 'PRC_16': ('leaf', 'ID', 'ACTIVE_INACTIVE_FLAG', 'HL70183'),
 'PRC_17': ('leaf', 'MO', 'COST', 'HL70000'),
 'PRC_18': ('leaf', 'IS', 'CHARGE_ON_INDICATOR', 'HL70269'),
 'PRC_2': ('leaf', 'CE', 'FACILITY_ID_PRC', 'HL70464'),
 'PRC_3': ('leaf', 'CE', 'DEPARTMENT', 'HL70184'),
 'PRC_4': ('leaf', 'IS', 'VALID_PATIENT_CLASSES', 'HL70004'),
 'PRC_5': ('leaf', 'CP', 'PRICE', 'HL70000'),
 'PRC_6': ('leaf', 'ST', 'FORMULA', 'HL70000'),
 'PRC_7': ('leaf', 'NM', 'MINIMUM_QUANTITY', 'HL70000'),
 'PRC_8': ('leaf', 'NM', 'MAXIMUM_QUANTITY', 'HL70000'),
 'PRC_9': ('leaf', 'MO', 'MINIMUM_PRICE', 'HL70000'),
 'PRD_1': ('leaf', 'CE', 'PROVIDER_ROLE', 'HL70286'),
 'PRD_2': ('leaf', 'XPN', 'PROVIDER_NAME', 'HL70000'),
 'PRD_3': ('leaf', 'XAD', 'PROVIDER_ADDRESS', 'HL70000'),
 'PRD_4': ('leaf', 'PL', 'PROVIDER_LOCATION', 'HL70000'),
 'PRD_5': ('leaf', 'XTN', 'PROVIDER_COMMUNICATION_INFORMATION', 'HL70000'),
 'PRD_6': ('leaf', 'CE', 'PREFERRED_METHOD_OF_CONTACT', 'HL70185'),
 'PRD_7': ('leaf', 'PLN', 'PROVIDER_IDENTIFIERS', 'HL70000'),
 'PRD_8': ('leaf', 'TS', 'EFFECTIVE_START_DATE_OF_PROVIDER_ROLE', 'HL70000'),
 'PRD_9': ('leaf', 'TS', 'EFFECTIVE_END_DATE_OF_PROVIDER_ROLE', 'HL70000'),
 'PSH_1': ('leaf', 'ST', 'REPORT_TYPE', 'HL70000'),
 'PSH_10': ('leaf', 'CQ', 'QUANTITY_IN_USE', 'HL70000'),
 'PSH_11': ('leaf', 'ID', 'QUANTITY_IN_USE_METHOD', 'HL70329'),
 'PSH_12': ('leaf', 'FT', 'QUANTITY_IN_USE_COMMENT', 'HL70000'),
 'PSH_13': ('leaf',
            'NM',
            'NUMBER_OF_PRODUCT_EXPERIENCE_REPORTS_FILED_BY_FACILITY',
            'HL70000'),
 'PSH_14': ('leaf',
            'NM',
            'NUMBER_OF_PRODUCT_EXPERIENCE_REPORTS_FILED_BY_DISTRIBUTOR',
            'HL70000'),
 'PSH_2': ('leaf', 'ST', 'REPORT_FORM_IDENTIFIER', 'HL70000'),
 'PSH_3': ('leaf', 'TS', 'REPORT_DATE', 'HL70000'),
 'PSH_4': ('leaf', 'TS', 'REPORT_INTERVAL_START_DATE', 'HL70000'),
 'PSH_5': ('leaf', 'TS', 'REPORT_INTERVAL_END_DATE', 'HL70000'),
 'PSH_6': ('leaf', 'CQ', 'QUANTITY_MANUFACTURED', 'HL70000'),
 'PSH_7': ('leaf', 'CQ', 'QUANTITY_DISTRIBUTED', 'HL70000'),
 'PSH_8': ('leaf', 'ID', 'QUANTITY_DISTRIBUTED_METHOD', 'HL70329'),
 'PSH_9': ('leaf', 'FT', 'QUANTITY_DISTRIBUTED_COMMENT', 'HL70000'),
 'PTH_1': ('leaf', 'ID', 'ACTION_CODE', 'HL70287'),
 'PTH_2': ('leaf', 'CE', 'PATHWAY_ID', 'HL70000'),
 'PTH_3': ('leaf', 'EI', 'PATHWAY_INSTANCE_ID', 'HL70000'),
 'PTH_4': ('leaf', 'TS', 'PATHWAY_ESTABLISHED_DATE_TIME', 'HL70000'),
 'PTH_5': ('leaf', 'CE', 'PATHWAY_LIFE_CYCLE_STATUS', 'HL70000'),
 'PTH_6': ('leaf',
           'TS',
           'CHANGE_PATHWAY_LIFE_CYCLE_STATUS_DATE_TIME',
           'HL70000'),
 'PV1_1': ('leaf', 'SI', 'SET_ID_PV1', 'HL70000'),
 'PV1_10': ('leaf', 'IS', 'HOSPITAL_SERVICE', 'HL70069'),
 'PV1_11': ('leaf', 'PL', 'TEMPORARY_LOCATION', 'HL70000'),
 'PV1_12': ('leaf', 'IS', 'PREADMIT_TEST_INDICATOR', 'HL70087'),
 'PV1_13': ('leaf', 'IS', 'RE_ADMISSION_INDICATOR', 'HL70092'),
 'PV1_14': ('leaf', 'IS', 'ADMIT_SOURCE', 'HL70023'),
 'PV1_15': ('leaf', 'IS', 'AMBULATORY_STATUS', 'HL70009'),
 'PV1_16': ('leaf', 'IS', 'VIP_INDICATOR', 'HL70099'),
 'PV1_17': ('leaf', 'XCN', 'ADMITTING_DOCTOR', 'HL70010'),
 'PV1_18': ('leaf', 'IS', 'PATIENT_TYPE', 'HL70018'),
 'PV1_19': ('leaf', 'CX', 'VISIT_NUMBER', 'HL70000'),
 'PV1_2': ('leaf', 'IS', 'PATIENT_CLASS', 'HL70004'),
 'PV1_20': ('leaf', 'FC', 'FINANCIAL_CLASS', 'HL70064'),
 'PV1_21': ('leaf', 'IS', 'CHARGE_PRICE_INDICATOR', 'HL70032'),
 'PV1_22': ('leaf', 'IS', 'COURTESY_CODE', 'HL70045'),
 'PV1_23': ('leaf', 'IS', 'CREDIT_RATING', 'HL70046'),
 'PV1_24': ('leaf', 'IS', 'CONTRACT_CODE', 'HL70044'),
 'PV1_25': ('leaf', 'DT', 'CONTRACT_EFFECTIVE_DATE', 'HL70000'),
 'PV1_26': ('leaf', 'NM', 'CONTRACT_AMOUNT', 'HL70000'),
 'PV1_27': ('leaf', 'NM', 'CONTRACT_PERIOD', 'HL70000'),
 'PV1_28': ('leaf', 'IS', 'INTEREST_CODE', 'HL70073'),
 'PV1_29': ('leaf', 'IS', 'TRANSFER_TO_BAD_DEBT_CODE', 'HL70110'),
 'PV1_3': ('leaf', 'PL', 'ASSIGNED_PATIENT_LOCATION', 'HL70000'),
 'PV1_30': ('leaf', 'DT', 'TRANSFER_TO_BAD_DEBT_DATE', 'HL70000'),
 'PV1_31': ('leaf', 'IS', 'BAD_DEBT_AGENCY_CODE', 'HL70021'),
 'PV1_32': ('leaf', 'NM', 'BAD_DEBT_TRANSFER_AMOUNT', 'HL70000'),
 'PV1_33': ('leaf', 'NM', 'BAD_DEBT_RECOVERY_AMOUNT', 'HL70000'),
 'PV1_34': ('leaf', 'IS', 'DELETE_ACCOUNT_INDICATOR', 'HL70111'),
 'PV1_35': ('leaf', 'DT', 'DELETE_ACCOUNT_DATE', 'HL70000'),
 'PV1_36': ('leaf', 'IS', 'DISCHARGE_DISPOSITION', 'HL70112'),
 'PV1_37': ('leaf', 'DLD', 'DISCHARGED_TO_LOCATION', 'HL70113'),
 'PV1_38': ('leaf', 'CE', 'DIET_TYPE', 'HL70114'),
 'PV1_39': ('leaf', 'IS', 'SERVICING_FACILITY', 'HL70115'),
 'PV1_4': ('leaf', 'IS', 'ADMISSION_TYPE', 'HL70007'),
 'PV1_40': ('leaf', 'IS', 'BED_STATUS', 'HL70116'),
 'PV1_41': ('leaf', 'IS', 'ACCOUNT_STATUS', 'HL70117'),
 'PV1_42': ('leaf', 'PL', 'PENDING_LOCATION', 'HL70000'),
 'PV1_43': ('leaf', 'PL', 'PRIOR_TEMPORARY_LOCATION', 'HL70000'),
 'PV1_44': ('leaf', 'TS', 'ADMIT_DATE_TIME', 'HL70000'),
 'PV1_45': ('leaf', 'TS', 'DISCHARGE_DATE_TIME', 'HL70000'),
 'PV1_46': ('leaf', 'NM', 'CURRENT_PATIENT_BALANCE', 'HL70000'),
 'PV1_47': ('leaf', 'NM', 'TOTAL_CHARGES', 'HL70000'),
 'PV1_48': ('leaf', 'NM', 'TOTAL_ADJUSTMENTS', 'HL70000'),
 'PV1_49': ('leaf', 'NM', 'TOTAL_PAYMENTS', 'HL70000'),
 'PV1_5': ('leaf', 'CX', 'PREADMIT_NUMBER', 'HL70000'),
 'PV1_50': ('leaf', 'CX', 'ALTERNATE_VISIT_ID', 'HL70203'),
 'PV1_51': ('leaf', 'IS', 'VISIT_INDICATOR', 'HL70326'),
 'PV1_52': ('leaf', 'XCN', 'OTHER_HEALTHCARE_PROVIDER', 'HL70010'),
 'PV1_6': ('leaf', 'PL', 'PRIOR_PATIENT_LOCATION', 'HL70000'),
 'PV1_7': ('leaf', 'XCN', 'ATTENDING_DOCTOR', 'HL70010'),
 'PV1_8': ('leaf', 'XCN', 'REFERRING_DOCTOR', 'HL70010'),
 'PV1_9': ('leaf', 'XCN', 'CONSULTING_DOCTOR', 'HL70010'),
 'PV2_1': ('leaf', 'PL', 'PRIOR_PENDING_LOCATION', 'HL70000'),
 'PV2_10': ('leaf', 'NM', 'ESTIMATED_LENGTH_OF_INPATIENT_STAY', 'HL70000'),
 'PV2_11': ('leaf', 'NM', 'ACTUAL_LENGTH_OF_INPATIENT_STAY', 'HL70000'),
 'PV2_12': ('leaf', 'ST', 'VISIT_DESCRIPTION', 'HL70000'),
 'PV2_13': ('leaf', 'XCN', 'REFERRAL_SOURCE_CODE', 'HL70000'),
 'PV2_14': ('leaf', 'DT', 'PREVIOUS_SERVICE_DATE', 'HL70000'),
 'PV2_15': ('leaf', 'ID', 'EMPLOYMENT_ILLNESS_RELATED_INDICATOR', 'HL70136'),
 'PV2_16': ('leaf', 'IS', 'PURGE_STATUS_CODE', 'HL70213'),
 'PV2_17': ('leaf', 'DT', 'PURGE_STATUS_DATE', 'HL70000'),
 'PV2_18': ('leaf', 'IS', 'SPECIAL_PROGRAM_CODE', 'HL70214'),
 'PV2_19': ('leaf', 'ID', 'RETENTION_INDICATOR', 'HL70136'),
 'PV2_2': ('leaf', 'CE', 'ACCOMMODATION_CODE', 'HL70129'),
 'PV2_20': ('leaf', 'NM', 'EXPECTED_NUMBER_OF_INSURANCE_PLANS', 'HL70000'),
 'PV2_21': ('leaf', 'IS', 'VISIT_PUBLICITY_CODE', 'HL70215'),
 'PV2_22': ('leaf', 'ID', 'VISIT_PROTECTION_INDICATOR', 'HL70136'),
 'PV2_23': ('leaf', 'XON', 'CLINIC_ORGANIZATION_NAME', 'HL70000'),
 'PV2_24': ('leaf', 'IS', 'PATIENT_STATUS_CODE', 'HL70216'),
 'PV2_25': ('leaf', 'IS', 'VISIT_PRIORITY_CODE', 'HL70217'),
 'PV2_26': ('leaf', 'DT', 'PREVIOUS_TREATMENT_DATE', 'HL70000'),
 'PV2_27': ('leaf', 'IS', 'EXPECTED_DISCHARGE_DISPOSITION', 'HL70112'),
 'PV2_28': ('leaf', 'DT', 'SIGNATURE_ON_FILE_DATE', 'HL70000'),
 'PV2_29': ('leaf', 'DT', 'FIRST_SIMILAR_ILLNESS_DATE', 'HL70000'),
 'PV2_3': ('leaf', 'CE', 'ADMIT_REASON', 'HL70000'),
 'PV2_30': ('leaf', 'CE', 'PATIENT_CHARGE_ADJUSTMENT_CODE', 'HL70218'),
 'PV2_31': ('leaf', 'IS', 'RECURRING_SERVICE_CODE', 'HL70219'),
 'PV2_32': ('leaf', 'ID', 'BILLING_MEDIA_CODE', 'HL70136'),
 'PV2_33': ('leaf', 'TS', 'EXPECTED_SURGERY_DATE_AND_TIME', 'HL70000'),
 'PV2_34': ('leaf', 'ID', 'MILITARY_PARTNERSHIP_CODE', 'HL70136'),
 'PV2_35': ('leaf', 'ID', 'MILITARY_NON_AVAILABILITY_CODE', 'HL70136'),
 'PV2_36': ('leaf', 'ID', 'NEWBORN_BABY_INDICATOR', 'HL70136'),
 'PV2_37': ('leaf', 'ID', 'BABY_DETAINED_INDICATOR', 'HL70136'),
 'PV2_38': ('leaf', 'CE', 'MODE_OF_ARRIVAL_CODE', 'HL70430'),
 'PV2_39': ('leaf', 'CE', 'RECREATIONAL_DRUG_USE_CODE', 'HL70431'),
 'PV2_4': ('leaf', 'CE', 'TRANSFER_REASON', 'HL70000'),
 'PV2_40': ('leaf', 'CE', 'ADMISSION_LEVEL_OF_CARE_CODE', 'HL70432'),
 'PV2_41': ('leaf', 'CE', 'PRECAUTION_CODE', 'HL70433'),
 'PV2_42': ('leaf', 'CE', 'PATIENT_CONDITION_CODE', 'HL70434'),
 'PV2_43': ('leaf', 'IS', 'LIVING_WILL_CODE', 'HL70315'),
 'PV2_44': ('leaf', 'IS', 'ORGAN_DONOR_CODE', 'HL70316'),
 'PV2_45': ('leaf', 'CE', 'ADVANCE_DIRECTIVE_CODE', 'HL70435'),
 'PV2_46': ('leaf', 'DT', 'PATIENT_STATUS_EFFECTIVE_DATE', 'HL70000'),
 'PV2_47': ('leaf', 'TS', 'EXPECTED_LOA_RETURN_DATE_TIME', 'HL70000'),
 'PV2_48': ('leaf',
            'TS',
            'EXPECTED_PRE_ADMISSION_TESTING_DATE_TIME',
            'HL70000'),
 'PV2_49': ('leaf', 'IS', 'NOTIFY_CLERGY_CODE', 'HL70534'),
 'PV2_5': ('leaf', 'ST', 'PATIENT_VALUABLES', 'HL70000'),
 'PV2_6': ('leaf', 'ST', 'PATIENT_VALUABLES_LOCATION', 'HL70000'),
 'PV2_7': ('leaf', 'IS', 'VISIT_USER_CODE', 'HL70130'),
 'PV2_8': ('leaf', 'TS', 'EXPECTED_ADMIT_DATE_TIME', 'HL70000'),
 'PV2_9': ('leaf', 'TS', 'EXPECTED_DISCHARGE_DATE_TIME', 'HL70000'),
 'QAK_1': ('leaf', 'ST', 'QUERY_TAG', 'HL70000'),
 'QAK_2': ('leaf', 'ID', 'QUERY_RESPONSE_STATUS', 'HL70208'),
 'QAK_3': ('leaf', 'CE', 'MESSAGE_QUERY_NAME', 'HL70471'),
 'QAK_4': ('leaf', 'NM', 'HIT_COUNT', 'HL70000'),
 'QAK_5': ('leaf', 'NM', 'THIS_PAYLOAD', 'HL70000'),
 'QAK_6': ('leaf', 'NM', 'HITS_REMAINING', 'HL70000'),
 'QID_1': ('leaf', 'ST', 'QUERY_TAG', 'HL70000'),
 'QID_2': ('leaf', 'CE', 'MESSAGE_QUERY_NAME', 'HL70471'),
 'QPD_1': ('leaf', 'CE', 'MESSAGE_QUERY_NAME', 'HL70471'),
 'QPD_2': ('leaf', 'ST', 'QUERY_TAG', 'HL70000'),
 'QPD_3': ('leaf',
           'varies',
           'USER_PARAMETERS_IN_SUCCESSIVE_FIELDS_',
           'HL70000'),
 'QRD_1': ('leaf', 'TS', 'QUERY_DATE_TIME', 'HL70000'),
 'QRD_10': ('leaf', 'CE', 'WHAT_DEPARTMENT_DATA_CODE', 'HL70000'),
 'QRD_11': ('leaf', 'VR', 'WHAT_DATA_CODE_VALUE_QUAL_', 'HL70000'),
 'QRD_12': ('leaf', 'ID', 'QUERY_RESULTS_LEVEL', 'HL70108'),
 'QRD_2': ('leaf', 'ID', 'QUERY_FORMAT_CODE', 'HL70106'),
 'QRD_3': ('leaf', 'ID', 'QUERY_PRIORITY', 'HL70091'),
 'QRD_4': ('leaf', 'ST', 'QUERY_ID', 'HL70000'),
 'QRD_5': ('leaf', 'ID', 'DEFERRED_RESPONSE_TYPE', 'HL70107'),
 'QRD_6': ('leaf', 'TS', 'DEFERRED_RESPONSE_DATE_TIME', 'HL70000'),
 'QRD_7': ('leaf', 'CQ', 'QUANTITY_LIMITED_REQUEST', 'HL70126'),
 'QRD_8': ('leaf', 'XCN', 'WHO_SUBJECT_FILTER', 'HL70000'),
 'QRD_9': ('leaf', 'CE', 'WHAT_SUBJECT_FILTER', 'HL70048'),
 'QRF_1': ('leaf', 'ST', 'WHERE_SUBJECT_FILTER', 'HL70000'),
 'QRF_10': ('leaf', 'NM', 'SEARCH_CONFIDENCE_THRESHOLD', 'HL70000'),
 'QRF_2': ('leaf', 'TS', 'WHEN_DATA_START_DATE_TIME', 'HL70000'),
 'QRF_3': ('leaf', 'TS', 'WHEN_DATA_END_DATE_TIME', 'HL70000'),
 'QRF_4': ('leaf', 'ST', 'WHAT_USER_QUALIFIER', 'HL70000'),
 'QRF_5': ('leaf', 'ST', 'OTHER_QRY_SUBJECT_FILTER', 'HL70000'),
 'QRF_6': ('leaf', 'ID', 'WHICH_DATE_TIME_QUALIFIER', 'HL70156'),
 'QRF_7': ('leaf', 'ID', 'WHICH_DATE_TIME_STATUS_QUALIFIER', 'HL70157'),
 'QRF_8': ('leaf', 'ID', 'DATE_TIME_SELECTION_QUALIFIER', 'HL70158'),
 'QRF_9': ('leaf', 'TQ', 'WHEN_QUANTITY_TIMING_QUALIFIER', 'HL70000'),
 'QRI_1': ('leaf', 'NM', 'CANDIDATE_CONFIDENCE', 'HL70000'),
 'QRI_2': ('leaf', 'IS', 'MATCH_REASON_CODE', 'HL70392'),
 'QRI_3': ('leaf', 'CE', 'ALGORITHM_DESCRIPTOR', 'HL70393'),
 'RCP_1': ('leaf', 'ID', 'QUERY_PRIORITY', 'HL70091'),
 'RCP_2': ('leaf', 'CQ', 'QUANTITY_LIMITED_REQUEST', 'HL70126'),
 'RCP_3': ('leaf', 'CE', 'RESPONSE_MODALITY', 'HL70394'),
 'RCP_4': ('leaf', 'TS', 'EXECUTION_AND_DELIVERY_TIME', 'HL70000'),
 'RCP_5': ('leaf', 'ID', 'MODIFY_INDICATOR', 'HL70395'),
 'RCP_6': ('leaf', 'SRT', 'SORT_BY_FIELD', 'HL70000'),
 'RCP_7': ('leaf', 'ID', 'SEGMENT_GROUP_INCLUSION', 'HL70000'),
 'RDF_1': ('leaf', 'NM', 'NUMBER_OF_COLUMNS_PER_ROW', 'HL70000'),
 'RDF_2': ('leaf', 'RCD', 'COLUMN_DESCRIPTION', 'HL70440'),
 'RDT_1': ('leaf', 'varies', 'COLUMN_VALUE', 'HL70000'),
 'RF1_1': ('leaf', 'CE', 'REFERRAL_STATUS', 'HL70283'),
 'RF1_10': ('leaf', 'CE', 'REFERRAL_REASON', 'HL70336'),
 'RF1_11': ('leaf', 'EI', 'EXTERNAL_REFERRAL_IDENTIFIER', 'HL70000'),
 'RF1_2': ('leaf', 'CE', 'REFERRAL_PRIORITY', 'HL70280'),
 'RF1_3': ('leaf', 'CE', 'REFERRAL_TYPE', 'HL70281'),
 'RF1_4': ('leaf', 'CE', 'REFERRAL_DISPOSITION', 'HL70282'),
 'RF1_5': ('leaf', 'CE', 'REFERRAL_CATEGORY', 'HL70284'),
 'RF1_6': ('leaf', 'EI', 'ORIGINATING_REFERRAL_IDENTIFIER', 'HL70000'),
 'RF1_7': ('leaf', 'TS', 'EFFECTIVE_DATE', 'HL70000'),
 'RF1_8': ('leaf', 'TS', 'EXPIRATION_DATE', 'HL70000'),
 'RF1_9': ('leaf', 'TS', 'PROCESS_DATE', 'HL70000'),
 'RGS_1': ('leaf', 'SI', 'SET_ID_RGS', 'HL70000'),
 'RGS_2': ('leaf', 'ID', 'SEGMENT_ACTION_CODE', 'HL70206'),
 'RGS_3': ('leaf', 'CE', 'RESOURCE_GROUP_ID', 'HL70000'),
 'RMI_1': ('leaf', 'CE', 'RISK_MANAGEMENT_INCIDENT_CODE', 'HL70427'),
 'RMI_2': ('leaf', 'TS', 'DATE_TIME_INCIDENT', 'HL70000'),
 'RMI_3': ('leaf', 'CE', 'INCIDENT_TYPE_CODE', 'HL70428'),
 'ROL_1': ('leaf', 'EI', 'ROLE_INSTANCE_ID', 'HL70000'),
 'ROL_10': ('leaf', 'CE', 'ORGANIZATION_UNIT_TYPE', 'HL70406'),
 'ROL_11': ('leaf', 'XAD', 'OFFICE_HOME_ADDRESS_BIRTHPLACE', 'HL70000'),
 'ROL_12': ('leaf', 'XTN', 'PHONE', 'HL70000'),
 'ROL_2': ('leaf', 'ID', 'ACTION_CODE', 'HL70287'),
 'ROL_3': ('leaf', 'CE', 'ROLE_ROL', 'HL70443'),
 'ROL_4': ('leaf', 'XCN', 'ROLE_PERSON', 'HL70000'),
 'ROL_5': ('leaf', 'TS', 'ROLE_BEGIN_DATE_TIME', 'HL70000'),
 'ROL_6': ('leaf', 'TS', 'ROLE_END_DATE_TIME', 'HL70000'),
 'ROL_7': ('leaf', 'CE', 'ROLE_DURATION', 'HL70000'),
 'ROL_8': ('leaf', 'CE', 'ROLE_ACTION_REASON', 'HL70000'),
 'ROL_9': ('leaf', 'CE', 'PROVIDER_TYPE', 'HL70000'),
 'RQ1_1': ('leaf', 'ST', 'ANTICIPATED_PRICE', 'HL70000'),
 'RQ1_2': ('leaf', 'CE', 'MANUFACTURER_IDENTIFIER', 'HL70385'),
 'RQ1_3': ('leaf', 'ST', 'MANUFACTURER_S_CATALOG', 'HL70000'),
 'RQ1_4': ('leaf', 'CE', 'VENDOR_ID', 'HL70000'),
 'RQ1_5': ('leaf', 'ST', 'VENDOR_CATALOG', 'HL70000'),
 'RQ1_6': ('leaf', 'ID', 'TAXABLE', 'HL70136'),
 'RQ1_7': ('leaf', 'ID', 'SUBSTITUTE_ALLOWED', 'HL70136'),
 'RQD_1': ('leaf', 'SI', 'REQUISITION_LINE_NUMBER', 'HL70000'),
 'RQD_10': ('leaf', 'DT', 'DATE_NEEDED', 'HL70000'),
 'RQD_2': ('leaf', 'CE', 'ITEM_CODE_INTERNAL', 'HL70000'),
 'RQD_3': ('leaf', 'CE', 'ITEM_CODE_EXTERNAL', 'HL70000'),
 'RQD_4': ('leaf', 'CE', 'HOSPITAL_ITEM_CODE', 'HL70000'),
 'RQD_5': ('leaf', 'NM', 'REQUISITION_QUANTITY', 'HL70000'),
 'RQD_6': ('leaf', 'CE', 'REQUISITION_UNIT_OF_MEASURE', 'HL70000'),
 'RQD_7': ('leaf', 'IS', 'DEPT_COST_CENTER', 'HL70319'),
 'RQD_8': ('leaf', 'IS', 'ITEM_NATURAL_ACCOUNT_CODE', 'HL70320'),
 'RQD_9': ('leaf', 'CE', 'DELIVER_TO_ID', 'HL70000'),
 'RXA_1': ('leaf', 'NM', 'GIVE_SUB_ID_COUNTER', 'HL70000'),
 'RXA_10': ('leaf', 'XCN', 'ADMINISTERING_PROVIDER', 'HL70000'),
 'RXA_11': ('leaf', 'LA2', 'ADMINISTERED_AT_LOCATION', 'HL70000'),
 'RXA_12': ('leaf', 'ST', 'ADMINISTERED_PER_TIME_UNIT_', 'HL70000'),
 'RXA_13': ('leaf', 'NM', 'ADMINISTERED_STRENGTH', 'HL70000'),
 'RXA_14': ('leaf', 'CE', 'ADMINISTERED_STRENGTH_UNITS', 'HL70000'),
 'RXA_15': ('leaf', 'ST', 'SUBSTANCE_LOT_NUMBER', 'HL70000'),
 'RXA_16': ('leaf', 'TS', 'SUBSTANCE_EXPIRATION_DATE', 'HL70000'),
 'RXA_17': ('leaf', 'CE', 'SUBSTANCE_MANUFACTURER_NAME', 'HL70227'),
 'RXA_18': ('leaf', 'CE', 'SUBSTANCE_TREATMENT_REFUSAL_REASON', 'HL70000'),
 'RXA_19': ('leaf', 'CE', 'INDICATION', 'HL70000'),
 'RXA_2': ('leaf', 'NM', 'ADMINISTRATION_SUB_ID_COUNTER', 'HL70000'),
 'RXA_20': ('leaf', 'ID', 'COMPLETION_STATUS', 'HL70322'),
 'RXA_21': ('leaf', 'ID', 'ACTION_CODE_RXA', 'HL70323'),
 'RXA_22': ('leaf', 'TS', 'SYSTEM_ENTRY_DATE_TIME', 'HL70000'),
 'RXA_23': ('leaf', 'NM', 'ADMINISTERED_DRUG_STRENGTH_VOLUME', 'HL70000'),
 'RXA_24': ('leaf',
            'CWE',
            'ADMINISTERED_DRUG_STRENGTH_VOLUME_UNITS',
            'HL70000'),
 'RXA_25': ('leaf', 'CWE', 'ADMINISTERED_BARCODE_IDENTIFIER', 'HL70000'),
 'RXA_26': ('leaf', 'ID', 'PHARMACY_ORDER_TYPE', 'HL70480'),
 'RXA_3': ('leaf', 'TS', 'DATE_TIME_START_OF_ADMINISTRATION', 'HL70000'),
 'RXA_4': ('leaf', 'TS', 'DATE_TIME_END_OF_ADMINISTRATION', 'HL70000'),
 'RXA_5': ('leaf', 'CE', 'ADMINISTERED_CODE', 'HL70292'),
 'RXA_6': ('leaf', 'NM', 'ADMINISTERED_AMOUNT', 'HL70000'),
 'RXA_7': ('leaf', 'CE', 'ADMINISTERED_UNITS', 'HL70000'),
 'RXA_8': ('leaf', 'CE', 'ADMINISTERED_DOSAGE_FORM', 'HL70000'),
 'RXA_9': ('leaf', 'CE', 'ADMINISTRATION_NOTES', 'HL70000'),
 'RXC_1': ('leaf', 'ID', 'RX_COMPONENT_TYPE', 'HL70166'),
 'RXC_2': ('leaf', 'CE', 'COMPONENT_CODE', 'HL70000'),
 'RXC_3': ('leaf', 'NM', 'COMPONENT_AMOUNT', 'HL70000'),
 'RXC_4': ('leaf', 'CE', 'COMPONENT_UNITS', 'HL70000'),
 'RXC_5': ('leaf', 'NM', 'COMPONENT_STRENGTH', 'HL70000'),
 'RXC_6': ('leaf', 'CE', 'COMPONENT_STRENGTH_UNITS', 'HL70000'),
 'RXC_7': ('leaf', 'CE', 'SUPPLEMENTARY_CODE', 'HL70000'),
 'RXC_8': ('leaf', 'NM', 'COMPONENT_DRUG_STRENGTH_VOLUME', 'HL70000'),
 'RXC_9': ('leaf', 'CWE', 'COMPONENT_DRUG_STRENGTH_VOLUME_UNITS', 'HL70000'),
 'RXD_1': ('leaf', 'NM', 'DISPENSE_SUB_ID_COUNTER', 'HL70000'),
 'RXD_10': ('leaf', 'XCN', 'DISPENSING_PROVIDER', 'HL70000'),
 'RXD_11': ('leaf', 'ID', 'SUBSTITUTION_STATUS', 'HL70167'),
 'RXD_12': ('leaf', 'CQ', 'TOTAL_DAILY_DOSE', 'HL70000'),
 'RXD_13': ('leaf', 'LA2', 'DISPENSE_TO_LOCATION', 'HL70000'),
 'RXD_14': ('leaf', 'ID', 'NEEDS_HUMAN_REVIEW', 'HL70136'),
 'RXD_15': ('leaf',
            'CE',
            'PHARMACY_TREATMENT_SUPPLIER_S_SPECIAL_DISPENSING_INSTRUCTIONS',
            'HL70000'),
 'RXD_16': ('leaf', 'NM', 'ACTUAL_STRENGTH', 'HL70000'),
 'RXD_17': ('leaf', 'CE', 'ACTUAL_STRENGTH_UNIT', 'HL70000'),
 'RXD_18': ('leaf', 'ST', 'SUBSTANCE_LOT_NUMBER', 'HL70000'),
 'RXD_19': ('leaf', 'TS', 'SUBSTANCE_EXPIRATION_DATE', 'HL70000'),
 'RXD_2': ('leaf', 'CE', 'DISPENSE_GIVE_CODE', 'HL70292'),
 'RXD_20': ('leaf', 'CE', 'SUBSTANCE_MANUFACTURER_NAME', 'HL70227'),
 'RXD_21': ('leaf', 'CE', 'INDICATION', 'HL70000'),
 'RXD_22': ('leaf', 'NM', 'DISPENSE_PACKAGE_SIZE', 'HL70000'),
 'RXD_23': ('leaf', 'CE', 'DISPENSE_PACKAGE_SIZE_UNIT', 'HL70000'),
 'RXD_24': ('leaf', 'ID', 'DISPENSE_PACKAGE_METHOD', 'HL70321'),
 'RXD_25': ('leaf', 'CE', 'SUPPLEMENTARY_CODE', 'HL70000'),
 'RXD_26': ('leaf', 'CE', 'INITIATING_LOCATION', 'HL70000'),
 'RXD_27': ('leaf', 'CE', 'PACKAGING_ASSEMBLY_LOCATION', 'HL70000'),
 'RXD_28': ('leaf', 'NM', 'ACTUAL_DRUG_STRENGTH_VOLUME', 'HL70000'),
 'RXD_29': ('leaf', 'CWE', 'ACTUAL_DRUG_STRENGTH_VOLUME_UNITS', 'HL70000'),
 'RXD_3': ('leaf', 'TS', 'DATE_TIME_DISPENSED', 'HL70000'),
 'RXD_30': ('leaf', 'CWE', 'DISPENSE_TO_PHARMACY', 'HL70000'),
 'RXD_31': ('leaf', 'XAD', 'DISPENSE_TO_PHARMACY_ADDRESS', 'HL70000'),
 'RXD_32': ('leaf', 'ID', 'PHARMACY_ORDER_TYPE', 'HL70480'),
 'RXD_33': ('leaf', 'CWE', 'DISPENSE_TYPE', 'HL70484'),
 'RXD_4': ('leaf', 'NM', 'ACTUAL_DISPENSE_AMOUNT', 'HL70000'),
 'RXD_5': ('leaf', 'CE', 'ACTUAL_DISPENSE_UNITS', 'HL70000'),
 'RXD_6': ('leaf', 'CE', 'ACTUAL_DOSAGE_FORM', 'HL70000'),
 'RXD_7': ('leaf', 'ST', 'PRESCRIPTION_NUMBER', 'HL70000'),
 'RXD_8': ('leaf', 'NM', 'NUMBER_OF_REFILLS_REMAINING', 'HL70000'),
 'RXD_9': ('leaf', 'ST', 'DISPENSE_NOTES', 'HL70000'),
 'RXE_1': ('leaf', 'TQ', 'QUANTITY_TIMING', 'HL70000'),
 'RXE_10': ('leaf', 'NM', 'DISPENSE_AMOUNT', 'HL70000'),
 'RXE_11': ('leaf', 'CE', 'DISPENSE_UNITS', 'HL70000'),
 'RXE_12': ('leaf', 'NM', 'NUMBER_OF_REFILLS', 'HL70000'),
 'RXE_13': ('leaf', 'XCN', 'ORDERING_PROVIDER_S_DEA_NUMBER', 'HL70000'),
 'RXE_14': ('leaf',
            'XCN',
            'PHARMACIST_TREATMENT_SUPPLIER_S_VERIFIER_ID',
            'HL70000'),
 'RXE_15': ('leaf', 'ST', 'PRESCRIPTION_NUMBER', 'HL70000'),
 'RXE_16': ('leaf', 'NM', 'NUMBER_OF_REFILLS_REMAINING', 'HL70000'),
 'RXE_17': ('leaf', 'NM', 'NUMBER_OF_REFILLS_DOSES_DISPENSED', 'HL70000'),
 'RXE_18': ('leaf',
            'TS',
            'D_T_OF_MOST_RECENT_REFILL_OR_DOSE_DISPENSED',
            'HL70000'),
 'RXE_19': ('leaf', 'CQ', 'TOTAL_DAILY_DOSE', 'HL70000'),
 'RXE_2': ('leaf', 'CE', 'GIVE_CODE', 'HL70292'),
 'RXE_20': ('leaf', 'ID', 'NEEDS_HUMAN_REVIEW', 'HL70136'),
 'RXE_21': ('leaf',
            'CE',
            'PHARMACY_TREATMENT_SUPPLIER_S_SPECIAL_DISPENSING_INSTRUCTIONS',
            'HL70000'),
 'RXE_22': ('leaf', 'ST', 'GIVE_PER_TIME_UNIT_', 'HL70000'),
 'RXE_23': ('leaf', 'ST', 'GIVE_RATE_AMOUNT', 'HL70000'),
 'RXE_24': ('leaf', 'CE', 'GIVE_RATE_UNITS', 'HL70000'),
 'RXE_25': ('leaf', 'NM', 'GIVE_STRENGTH', 'HL70000'),
 'RXE_26': ('leaf', 'CE', 'GIVE_STRENGTH_UNITS', 'HL70000'),
 'RXE_27': ('leaf', 'CE', 'GIVE_INDICATION', 'HL70000'),
 'RXE_28': ('leaf', 'NM', 'DISPENSE_PACKAGE_SIZE', 'HL70000'),
 'RXE_29': ('leaf', 'CE', 'DISPENSE_PACKAGE_SIZE_UNIT', 'HL70000'),
 'RXE_3': ('leaf', 'NM', 'GIVE_AMOUNT_MINIMUM', 'HL70000'),
 'RXE_30': ('leaf', 'ID', 'DISPENSE_PACKAGE_METHOD', 'HL70321'),
 'RXE_31': ('leaf', 'CE', 'SUPPLEMENTARY_CODE', 'HL70000'),
 'RXE_32': ('leaf', 'TS', 'ORIGINAL_ORDER_DATE_TIME', 'HL70000'),
 'RXE_33': ('leaf', 'NM', 'GIVE_DRUG_STRENGTH_VOLUME', 'HL70000'),
 'RXE_34': ('leaf', 'CWE', 'GIVE_DRUG_STRENGTH_VOLUME_UNITS', 'HL70000'),
 'RXE_35': ('leaf', 'CWE', 'CONTROLLED_SUBSTANCE_SCHEDULE', 'HL70477'),
 'RXE_36': ('leaf', 'ID', 'FORMULARY_STATUS', 'HL70478'),
 'RXE_37': ('leaf', 'CWE', 'PHARMACEUTICAL_SUBSTANCE_ALTERNATIVE', 'HL70000'),
 'RXE_38': ('leaf', 'CWE', 'PHARMACY_OF_MOST_RECENT_FILL', 'HL70000'),
 'RXE_39': ('leaf', 'NM', 'INITIAL_DISPENSE_AMOUNT', 'HL70000'),
 'RXE_4': ('leaf', 'NM', 'GIVE_AMOUNT_MAXIMUM', 'HL70000'),
 'RXE_40': ('leaf', 'CWE', 'DISPENSING_PHARMACY', 'HL70000'),
 'RXE_41': ('leaf', 'XAD', 'DISPENSING_PHARMACY_ADDRESS', 'HL70000'),
 'RXE_42': ('leaf', 'PL', 'DELIVER_TO_PATIENT_LOCATION', 'HL70000'),
 'RXE_43': ('leaf', 'XAD', 'DELIVER_TO_ADDRESS', 'HL70000'),
 'RXE_44': ('leaf', 'ID', 'PHARMACY_ORDER_TYPE', 'HL70480'),
 'RXE_5': ('leaf', 'CE', 'GIVE_UNITS', 'HL70000'),
 'RXE_6': ('leaf', 'CE', 'GIVE_DOSAGE_FORM', 'HL70000'),
 'RXE_7': ('leaf', 'CE', 'PROVIDER_S_ADMINISTRATION_INSTRUCTIONS', 'HL70000'),
 'RXE_8': ('leaf', 'LA1', 'DELIVER_TO_LOCATION', 'HL70000'),
 'RXE_9': ('leaf', 'ID', 'SUBSTITUTION_STATUS', 'HL70167'),
 'RXG_1': ('leaf', 'NM', 'GIVE_SUB_ID_COUNTER', 'HL70000'),
 'RXG_10': ('leaf', 'ID', 'SUBSTITUTION_STATUS', 'HL70167'),
 'RXG_11': ('leaf', 'LA2', 'DISPENSE_TO_LOCATION', 'HL70000'),
 'RXG_12': ('leaf', 'ID', 'NEEDS_HUMAN_REVIEW', 'HL70136'),
 'RXG_13': ('leaf',
            'CE',
            'PHARMACY_TREATMENT_SUPPLIER_S_SPECIAL_ADMINISTRATION_INSTRUCTIONS',
            'HL70000'),
 'RXG_14': ('leaf', 'ST', 'GIVE_PER_TIME_UNIT_', 'HL70000'),
 'RXG_15': ('leaf', 'ST', 'GIVE_RATE_AMOUNT', 'HL70000'),
 'RXG_16': ('leaf', 'CE', 'GIVE_RATE_UNITS', 'HL70000'),
 'RXG_17': ('leaf', 'NM', 'GIVE_STRENGTH', 'HL70000'),
 'RXG_18': ('leaf', 'CE', 'GIVE_STRENGTH_UNITS', 'HL70000'),
 'RXG_19': ('leaf', 'ST', 'SUBSTANCE_LOT_NUMBER', 'HL70000'),
 'RXG_2': ('leaf', 'NM', 'DISPENSE_SUB_ID_COUNTER', 'HL70000'),
 'RXG_20': ('leaf', 'TS', 'SUBSTANCE_EXPIRATION_DATE', 'HL70000'),
 'RXG_21': ('leaf', 'CE', 'SUBSTANCE_MANUFACTURER_NAME', 'HL70227'),
 'RXG_22': ('leaf', 'CE', 'INDICATION', 'HL70000'),
 'RXG_23': ('leaf', 'NM', 'GIVE_DRUG_STRENGTH_VOLUME', 'HL70000'),
 'RXG_24': ('leaf', 'CWE', 'GIVE_DRUG_STRENGTH_VOLUME_UNITS', 'HL70000'),
 'RXG_25': ('leaf', 'CWE', 'GIVE_BARCODE_IDENTIFIER', 'HL70000'),
 'RXG_26': ('leaf', 'ID', 'PHARMACY_ORDER_TYPE', 'HL70480'),
 'RXG_3': ('leaf', 'TQ', 'QUANTITY_TIMING', 'HL70000'),
 'RXG_4': ('leaf', 'CE', 'GIVE_CODE', 'HL70292'),
 'RXG_5': ('leaf', 'NM', 'GIVE_AMOUNT_MINIMUM', 'HL70000'),
 'RXG_6': ('leaf', 'NM', 'GIVE_AMOUNT_MAXIMUM', 'HL70000'),
 'RXG_7': ('leaf', 'CE', 'GIVE_UNITS', 'HL70000'),
 'RXG_8': ('leaf', 'CE', 'GIVE_DOSAGE_FORM', 'HL70000'),
 'RXG_9': ('leaf', 'CE', 'ADMINISTRATION_NOTES', 'HL70000'),
 'RXO_1': ('leaf', 'CE', 'REQUESTED_GIVE_CODE', 'HL70000'),
 'RXO_10': ('leaf', 'CE', 'REQUESTED_DISPENSE_CODE', 'HL70000'),
 'RXO_11': ('leaf', 'NM', 'REQUESTED_DISPENSE_AMOUNT', 'HL70000'),
 'RXO_12': ('leaf', 'CE', 'REQUESTED_DISPENSE_UNITS', 'HL70000'),
 'RXO_13': ('leaf', 'NM', 'NUMBER_OF_REFILLS', 'HL70000'),
 'RXO_14': ('leaf', 'XCN', 'ORDERING_PROVIDER_S_DEA_NUMBER', 'HL70000'),
 'RXO_15': ('leaf',
            'XCN',
            'PHARMACIST_TREATMENT_SUPPLIER_S_VERIFIER_ID',
            'HL70000'),
 'RXO_16': ('leaf', 'ID', 'NEEDS_HUMAN_REVIEW', 'HL70136'),
 'RXO_17': ('leaf', 'ST', 'REQUESTED_GIVE_PER_TIME_UNIT_', 'HL70000'),
 'RXO_18': ('leaf', 'NM', 'REQUESTED_GIVE_STRENGTH', 'HL70000'),
 'RXO_19': ('leaf', 'CE', 'REQUESTED_GIVE_STRENGTH_UNITS', 'HL70000'),
 'RXO_2': ('leaf', 'NM', 'REQUESTED_GIVE_AMOUNT_MINIMUM', 'HL70000'),
 'RXO_20': ('leaf', 'CE', 'INDICATION', 'HL70000'),
 'RXO_21': ('leaf', 'ST', 'REQUESTED_GIVE_RATE_AMOUNT', 'HL70000'),
 'RXO_22': ('leaf', 'CE', 'REQUESTED_GIVE_RATE_UNITS', 'HL70000'),
 'RXO_23': ('leaf', 'CQ', 'TOTAL_DAILY_DOSE', 'HL70000'),
 'RXO_24': ('leaf', 'CE', 'SUPPLEMENTARY_CODE', 'HL70000'),
 'RXO_25': ('leaf', 'NM', 'REQUESTED_DRUG_STRENGTH_VOLUME', 'HL70000'),
 'RXO_26': ('leaf', 'CWE', 'REQUESTED_DRUG_STRENGTH_VOLUME_UNITS', 'HL70000'),
 'RXO_27': ('leaf', 'ID', 'PHARMACY_ORDER_TYPE', 'HL70480'),
 'RXO_28': ('leaf', 'NM', 'DISPENSING_INTERVAL', 'HL70000'),
 'RXO_3': ('leaf', 'NM', 'REQUESTED_GIVE_AMOUNT_MAXIMUM', 'HL70000'),
 'RXO_4': ('leaf', 'CE', 'REQUESTED_GIVE_UNITS', 'HL70000'),
 'RXO_5': ('leaf', 'CE', 'REQUESTED_DOSAGE_FORM', 'HL70000'),
 'RXO_6': ('leaf',
           'CE',
           'PROVIDER_S_PHARMACY_TREATMENT_INSTRUCTIONS',
           'HL70000'),
 'RXO_7': ('leaf', 'CE', 'PROVIDER_S_ADMINISTRATION_INSTRUCTIONS', 'HL70000'),
 'RXO_8': ('leaf', 'LA1', 'DELIVER_TO_LOCATION', 'HL70000'),
 'RXO_9': ('leaf', 'ID', 'ALLOW_SUBSTITUTIONS', 'HL70161'),
 'RXR_1': ('leaf', 'CE', 'ROUTE', 'HL70162'),
 'RXR_2': ('leaf', 'CWE', 'ADMINISTRATION_SITE', 'HL70163'),
 'RXR_3': ('leaf', 'CE', 'ADMINISTRATION_DEVICE', 'HL70164'),
 'RXR_4': ('leaf', 'CWE', 'ADMINISTRATION_METHOD', 'HL70165'),
 'RXR_5': ('leaf', 'CE', 'ROUTING_INSTRUCTION', 'HL70000'),
 'RXR_6': ('leaf', 'CWE', 'ADMINISTRATION_SITE_MODIFIER', 'HL70495'),
 'SAC_1': ('leaf', 'EI', 'EXTERNAL_ACCESSION_IDENTIFIER', 'HL70000'),
 'SAC_10': ('leaf', 'EI', 'CARRIER_IDENTIFIER', 'HL70000'),
 'SAC_11': ('leaf', 'NA', 'POSITION_IN_CARRIER', 'HL70000'),
 'SAC_12': ('leaf', 'CE', 'TRAY_TYPE_SAC', 'HL70379'),
 'SAC_13': ('leaf', 'EI', 'TRAY_IDENTIFIER', 'HL70000'),
 'SAC_14': ('leaf', 'NA', 'POSITION_IN_TRAY', 'HL70000'),
 'SAC_15': ('leaf', 'CE', 'LOCATION', 'HL70000'),
 'SAC_16': ('leaf', 'NM', 'CONTAINER_HEIGHT', 'HL70000'),
 'SAC_17': ('leaf', 'NM', 'CONTAINER_DIAMETER', 'HL70000'),
 'SAC_18': ('leaf', 'NM', 'BARRIER_DELTA', 'HL70000'),
 'SAC_19': ('leaf', 'NM', 'BOTTOM_DELTA', 'HL70000'),
 'SAC_2': ('leaf', 'EI', 'ACCESSION_IDENTIFIER', 'HL70000'),
 'SAC_20': ('leaf', 'CE', 'CONTAINER_HEIGHT_DIAMETER_DELTA_UNITS', 'HL70000'),
 'SAC_21': ('leaf', 'NM', 'CONTAINER_VOLUME', 'HL70000'),
 'SAC_22': ('leaf', 'NM', 'AVAILABLE_SPECIMEN_VOLUME', 'HL70000'),
 'SAC_23': ('leaf', 'NM', 'INITIAL_SPECIMEN_VOLUME', 'HL70000'),
 'SAC_24': ('leaf', 'CE', 'VOLUME_UNITS', 'HL70000'),
 'SAC_25': ('leaf', 'CE', 'SEPARATOR_TYPE', 'HL70380'),
 'SAC_26': ('leaf', 'CE', 'CAP_TYPE', 'HL70381'),
 'SAC_27': ('leaf', 'CWE', 'ADDITIVE', 'HL70371'),
 'SAC_28': ('leaf', 'CE', 'SPECIMEN_COMPONENT', 'HL70000'),
 'SAC_29': ('leaf', 'SN', 'DILUTION_FACTOR', 'HL70000'),
 'SAC_3': ('leaf', 'EI', 'CONTAINER_IDENTIFIER', 'HL70000'),
 'SAC_30': ('leaf', 'CE', 'TREATMENT', 'HL70373'),
 'SAC_31': ('leaf', 'SN', 'TEMPERATURE', 'HL70000'),
 'SAC_32': ('leaf', 'NM', 'HEMOLYSIS_INDEX', 'HL70000'),
 'SAC_33': ('leaf', 'CE', 'HEMOLYSIS_INDEX_UNITS', 'HL70000'),
 'SAC_34': ('leaf', 'NM', 'LIPEMIA_INDEX', 'HL70000'),
 'SAC_35': ('leaf', 'CE', 'LIPEMIA_INDEX_UNITS', 'HL70000'),
 'SAC_36': ('leaf', 'NM', 'ICTERUS_INDEX', 'HL70000'),
 'SAC_37': ('leaf', 'CE', 'ICTERUS_INDEX_UNITS', 'HL70000'),
 'SAC_38': ('leaf', 'NM', 'FIBRIN_INDEX', 'HL70000'),
 'SAC_39': ('leaf', 'CE', 'FIBRIN_INDEX_UNITS', 'HL70000'),
 'SAC_4': ('leaf', 'EI', 'PRIMARY_PARENT_CONTAINER_IDENTIFIER', 'HL70000'),
 'SAC_40': ('leaf', 'CE', 'SYSTEM_INDUCED_CONTAMINANTS', 'HL70374'),
 'SAC_41': ('leaf', 'CE', 'DRUG_INTERFERENCE', 'HL70382'),
 'SAC_42': ('leaf', 'CE', 'ARTIFICIAL_BLOOD', 'HL70375'),
 'SAC_43': ('leaf', 'CWE', 'SPECIAL_HANDLING_CODE', 'HL70376'),
 'SAC_44': ('leaf', 'CE', 'OTHER_ENVIRONMENTAL_FACTORS', 'HL70377'),
 'SAC_5': ('leaf', 'EI', 'EQUIPMENT_CONTAINER_IDENTIFIER', 'HL70000'),
 'SAC_6': ('leaf', 'SPS', 'SPECIMEN_SOURCE', 'HL70000'),
 'SAC_7': ('leaf', 'TS', 'REGISTRATION_DATE_TIME', 'HL70000'),
 'SAC_8': ('leaf', 'CE', 'CONTAINER_STATUS', 'HL70370'),
 'SAC_9': ('leaf', 'CE', 'CARRIER_TYPE', 'HL70378'),
 'SCH_1': ('leaf', 'EI', 'PLACER_APPOINTMENT_ID', 'HL70000'),
 'SCH_10': ('leaf', 'CE', 'APPOINTMENT_DURATION_UNITS', 'HL70000'),
 'SCH_11': ('leaf', 'TQ', 'APPOINTMENT_TIMING_QUANTITY', 'HL70000'),
 'SCH_12': ('leaf', 'XCN', 'PLACER_CONTACT_PERSON', 'HL70000'),
 'SCH_13': ('leaf', 'XTN', 'PLACER_CONTACT_PHONE_NUMBER', 'HL70000'),
 'SCH_14': ('leaf', 'XAD', 'PLACER_CONTACT_ADDRESS', 'HL70000'),
 'SCH_15': ('leaf', 'PL', 'PLACER_CONTACT_LOCATION', 'HL70000'),
 'SCH_16': ('leaf', 'XCN', 'FILLER_CONTACT_PERSON', 'HL70000'),
 'SCH_17': ('leaf', 'XTN', 'FILLER_CONTACT_PHONE_NUMBER', 'HL70000'),
 'SCH_18': ('leaf', 'XAD', 'FILLER_CONTACT_ADDRESS', 'HL70000'),
 'SCH_19': ('leaf', 'PL', 'FILLER_CONTACT_LOCATION', 'HL70000'),
 'SCH_2': ('leaf', 'EI', 'FILLER_APPOINTMENT_ID', 'HL70000'),
 'SCH_20': ('leaf', 'XCN', 'ENTERED_BY_PERSON', 'HL70000'),
 'SCH_21': ('leaf', 'XTN', 'ENTERED_BY_PHONE_NUMBER', 'HL70000'),
 'SCH_22': ('leaf', 'PL', 'ENTERED_BY_LOCATION', 'HL70000'),
 'SCH_23': ('leaf', 'EI', 'PARENT_PLACER_APPOINTMENT_ID', 'HL70000'),
 'SCH_24': ('leaf', 'EI', 'PARENT_FILLER_APPOINTMENT_ID', 'HL70000'),
 'SCH_25': ('leaf', 'CE', 'FILLER_STATUS_CODE', 'HL70278'),
 'SCH_26': ('leaf', 'EI', 'PLACER_ORDER_NUMBER', 'HL70000'),
 'SCH_27': ('leaf', 'EI', 'FILLER_ORDER_NUMBER', 'HL70000'),
 'SCH_3': ('leaf', 'NM', 'OCCURRENCE_NUMBER', 'HL70000'),
 'SCH_4': ('leaf', 'EI', 'PLACER_GROUP_NUMBER', 'HL70000'),
 'SCH_5': ('leaf', 'CE', 'SCHEDULE_ID', 'HL70000'),
 'SCH_6': ('leaf', 'CE', 'EVENT_REASON', 'HL70000'),
 'SCH_7': ('leaf', 'CE', 'APPOINTMENT_REASON', 'HL70276'),
 'SCH_8': ('leaf', 'CE', 'APPOINTMENT_TYPE', 'HL70277'),
 'SCH_9': ('leaf', 'NM', 'APPOINTMENT_DURATION', 'HL70000'),
 'SFT_1': ('leaf', 'XON', 'SOFTWARE_VENDOR_ORGANIZATION', 'HL70000'),
 'SFT_2': ('leaf',
           'ST',
           'SOFTWARE_CERTIFIED_VERSION_OR_RELEASE_NUMBER',
           'HL70000'),
 'SFT_3': ('leaf', 'ST', 'SOFTWARE_PRODUCT_NAME', 'HL70000'),
 'SFT_4': ('leaf', 'ST', 'SOFTWARE_BINARY_ID', 'HL70000'),
 'SFT_5': ('leaf', 'TX', 'SOFTWARE_PRODUCT_INFORMATION', 'HL70000'),
 'SFT_6': ('leaf', 'TS', 'SOFTWARE_INSTALL_DATE', 'HL70000'),
 'SID_1': ('leaf', 'CE', 'APPLICATION_METHOD_IDENTIFIER', 'HL70000'),
 'SID_2': ('leaf', 'ST', 'SUBSTANCE_LOT_NUMBER', 'HL70000'),
 'SID_3': ('leaf', 'ST', 'SUBSTANCE_CONTAINER_IDENTIFIER', 'HL70000'),
 'SID_4': ('leaf', 'CE', 'SUBSTANCE_MANUFACTURER_IDENTIFIER', 'HL70385'),
 'SPM_1': ('leaf', 'SI', 'SET_ID_SPM', 'HL70000'),
 'SPM_10': ('leaf', 'CWE', 'SPECIMEN_COLLECTION_SITE', 'HL70543'),
 'SPM_11': ('leaf', 'CWE', 'SPECIMEN_ROLE', 'HL70369'),
 'SPM_12': ('leaf', 'CQ', 'SPECIMEN_COLLECTION_AMOUNT', 'HL70000'),
 'SPM_13': ('leaf', 'NM', 'GROUPED_SPECIMEN_COUNT', 'HL70000'),
 'SPM_14': ('leaf', 'ST', 'SPECIMEN_DESCRIPTION', 'HL70000'),
 'SPM_15': ('leaf', 'CWE', 'SPECIMEN_HANDLING_CODE', 'HL70376'),
 'SPM_16': ('leaf', 'CWE', 'SPECIMEN_RISK_CODE', 'HL70489'),
 'SPM_17': ('leaf', 'DR', 'SPECIMEN_COLLECTION_DATE_TIME', 'HL70000'),
 'SPM_18': ('leaf', 'TS', 'SPECIMEN_RECEIVED_DATE_TIME', 'HL70000'),
 'SPM_19': ('leaf', 'TS', 'SPECIMEN_EXPIRATION_DATE_TIME', 'HL70000'),
 'SPM_2': ('leaf', 'EIP', 'SPECIMEN_ID', 'HL70000'),
 'SPM_20': ('leaf', 'ID', 'SPECIMEN_AVAILABILITY', 'HL70136'),
 'SPM_21': ('leaf', 'CWE', 'SPECIMEN_REJECT_REASON', 'HL70490'),
 'SPM_22': ('leaf', 'CWE', 'SPECIMEN_QUALITY', 'HL70491'),
 'SPM_23': ('leaf', 'CWE', 'SPECIMEN_APPROPRIATENESS', 'HL70492'),
 'SPM_24': ('leaf', 'CWE', 'SPECIMEN_CONDITION', 'HL70493'),
 'SPM_25': ('leaf', 'CQ', 'SPECIMEN_CURRENT_QUANTITY', 'HL70000'),
 'SPM_26': ('leaf', 'NM', 'NUMBER_OF_SPECIMEN_CONTAINERS', 'HL70000'),
 'SPM_27': ('leaf', 'CWE', 'CONTAINER_TYPE', 'HL70000'),
 'SPM_28': ('leaf', 'CWE', 'CONTAINER_CONDITION', 'HL70544'),
 'SPM_29': ('leaf', 'CWE', 'SPECIMEN_CHILD_ROLE', 'HL70494'),
 'SPM_3': ('leaf', 'EIP', 'SPECIMEN_PARENT_IDS', 'HL70000'),
 'SPM_4': ('leaf', 'CWE', 'SPECIMEN_TYPE', 'HL70487'),
 'SPM_5': ('leaf', 'CWE', 'SPECIMEN_TYPE_MODIFIER', 'HL70541'),
 'SPM_6': ('leaf', 'CWE', 'SPECIMEN_ADDITIVES', 'HL70371'),
 'SPM_7': ('leaf', 'CWE', 'SPECIMEN_COLLECTION_METHOD', 'HL70488'),
 'SPM_8': ('leaf', 'CWE', 'SPECIMEN_SOURCE_SITE', 'HL70000'),
 'SPM_9': ('leaf', 'CWE', 'SPECIMEN_SOURCE_SITE_MODIFIER', 'HL70542'),
 'SPR_1': ('leaf', 'ST', 'QUERY_TAG', 'HL70000'),
 'SPR_2': ('leaf', 'ID', 'QUERY_RESPONSE_FORMAT_CODE', 'HL70106'),
 'SPR_3': ('leaf', 'CE', 'STORED_PROCEDURE_NAME', 'HL70000'),
 'SPR_4': ('leaf', 'QIP', 'INPUT_PARAMETER_LIST', 'HL70000'),
 'STF_1': ('leaf', 'CE', 'PRIMARY_KEY_VALUE_STF', 'HL79999'),
 'STF_10': ('leaf', 'XTN', 'PHONE', 'HL70000'),
 'STF_11': ('leaf', 'XAD', 'OFFICE_HOME_ADDRESS_BIRTHPLACE', 'HL70000'),
 'STF_12': ('leaf', 'DIN', 'INSTITUTION_ACTIVATION_DATE', 'HL70537'),
 'STF_13': ('leaf', 'DIN', 'INSTITUTION_INACTIVATION_DATE', 'HL70537'),
 'STF_14': ('leaf', 'CE', 'BACKUP_PERSON_ID', 'HL70000'),
 'STF_15': ('leaf', 'ST', 'E_MAIL_ADDRESS', 'HL70000'),
 'STF_16': ('leaf', 'CE', 'PREFERRED_METHOD_OF_CONTACT', 'HL70185'),
 'STF_17': ('leaf', 'CE', 'MARITAL_STATUS', 'HL70002'),
 'STF_18': ('leaf', 'ST', 'JOB_TITLE', 'HL70000'),
 'STF_19': ('leaf', 'JCC', 'JOB_CODE_CLASS', 'HL70000'),
 'STF_2': ('leaf', 'CX', 'STAFF_IDENTIFIER_LIST', 'HL70000'),
 'STF_20': ('leaf', 'CE', 'EMPLOYMENT_STATUS_CODE', 'HL70066'),
 'STF_21': ('leaf', 'ID', 'ADDITIONAL_INSURED_ON_AUTO', 'HL70136'),
 'STF_22': ('leaf', 'DLN', 'DRIVER_S_LICENSE_NUMBER_STAFF', 'HL70000'),
 'STF_23': ('leaf', 'ID', 'COPY_AUTO_INS', 'HL70136'),
 'STF_24': ('leaf', 'DT', 'AUTO_INS_EXPIRES', 'HL70000'),
 'STF_25': ('leaf', 'DT', 'DATE_LAST_DMV_REVIEW', 'HL70000'),
 'STF_26': ('leaf', 'DT', 'DATE_NEXT_DMV_REVIEW', 'HL70000'),
 'STF_27': ('leaf', 'CE', 'RACE', 'HL70005'),
 'STF_28': ('leaf', 'CE', 'ETHNIC_GROUP', 'HL70189'),
 'STF_29': ('leaf', 'ID', 'RE_ACTIVATION_APPROVAL_INDICATOR', 'HL70136'),
 'STF_3': ('leaf', 'XPN', 'STAFF_NAME', 'HL70000'),
 'STF_30': ('leaf', 'CE', 'CITIZENSHIP', 'HL70171'),
 'STF_31': ('leaf', 'TS', 'DEATH_DATE_AND_TIME', 'HL70000'),
 'STF_32': ('leaf', 'ID', 'DEATH_INDICATOR', 'HL70136'),
 'STF_33': ('leaf', 'CWE', 'INSTITUTION_RELATIONSHIP_TYPE_CODE', 'HL70538'),
 'STF_34': ('leaf', 'DR', 'INSTITUTION_RELATIONSHIP_PERIOD', 'HL70000'),
 'STF_35': ('leaf', 'DT', 'EXPECTED_RETURN_DATE', 'HL70000'),
 'STF_36': ('leaf', 'CWE', 'COST_CENTER_CODE', 'HL70539'),
 'STF_37': ('leaf', 'ID', 'GENERIC_CLASSIFICATION_INDICATOR', 'HL70136'),
 'STF_38': ('leaf', 'CWE', 'INACTIVE_REASON_CODE', 'HL70540'),
 'STF_4': ('leaf', 'IS', 'STAFF_TYPE', 'HL70182'),
 'STF_5': ('leaf', 'IS', 'ADMINISTRATIVE_SEX', 'HL70001'),
 'STF_6': ('leaf', 'TS', 'DATE_TIME_OF_BIRTH', 'HL70000'),
 'STF_7': ('leaf', 'ID', 'ACTIVE_INACTIVE_FLAG', 'HL70183'),
 'STF_8': ('leaf', 'CE', 'DEPARTMENT', 'HL70184'),
 'STF_9': ('leaf', 'CE', 'HOSPITAL_SERVICE_STF', 'HL70069'),
 'TCC_1': ('leaf', 'CE', 'UNIVERSAL_SERVICE_IDENTIFIER', 'HL70000'),
 'TCC_10': ('leaf', 'ID', 'AUTOMATIC_REPEAT_ALLOWED', 'HL70136'),
 'TCC_11': ('leaf', 'ID', 'AUTOMATIC_REFLEX_ALLOWED', 'HL70136'),
 'TCC_12': ('leaf', 'SN', 'EQUIPMENT_DYNAMIC_RANGE', 'HL70000'),
 'TCC_13': ('leaf', 'CE', 'UNITS', 'HL70000'),
 'TCC_14': ('leaf', 'CE', 'PROCESSING_TYPE', 'HL70388'),
 'TCC_2': ('leaf', 'EI', 'TEST_APPLICATION_IDENTIFIER', 'HL70000'),
 'TCC_3': ('leaf', 'SPS', 'SPECIMEN_SOURCE', 'HL70000'),
 'TCC_4': ('leaf', 'SN', 'AUTO_DILUTION_FACTOR_DEFAULT', 'HL70000'),
 'TCC_5': ('leaf', 'SN', 'RERUN_DILUTION_FACTOR_DEFAULT', 'HL70000'),
 'TCC_6': ('leaf', 'SN', 'PRE_DILUTION_FACTOR_DEFAULT', 'HL70000'),
 'TCC_7': ('leaf',
           'SN',
           'ENDOGENOUS_CONTENT_OF_PRE_DILUTION_DILUENT',
           'HL70000'),
 'TCC_8': ('leaf', 'NM', 'INVENTORY_LIMITS_WARNING_LEVEL', 'HL70000'),
 'TCC_9': ('leaf', 'ID', 'AUTOMATIC_RERUN_ALLOWED', 'HL70136'),
 'TCD_1': ('leaf', 'CE', 'UNIVERSAL_SERVICE_IDENTIFIER', 'HL70000'),
 'TCD_2': ('leaf', 'SN', 'AUTO_DILUTION_FACTOR', 'HL70000'),
 'TCD_3': ('leaf', 'SN', 'RERUN_DILUTION_FACTOR', 'HL70000'),
 'TCD_4': ('leaf', 'SN', 'PRE_DILUTION_FACTOR', 'HL70000'),
 'TCD_5': ('leaf',
           'SN',
           'ENDOGENOUS_CONTENT_OF_PRE_DILUTION_DILUENT',
           'HL70000'),
 'TCD_6': ('leaf', 'ID', 'AUTOMATIC_REPEAT_ALLOWED', 'HL70136'),
 'TCD_7': ('leaf', 'ID', 'REFLEX_ALLOWED', 'HL70136'),
 'TCD_8': ('leaf', 'CE', 'ANALYTE_REPEAT_STATUS', 'HL70389'),
 'TQ1_1': ('leaf', 'SI', 'SET_ID_TQ1', 'HL70000'),
 'TQ1_10': ('leaf', 'TX', 'CONDITION_TEXT', 'HL70000'),
 'TQ1_11': ('leaf', 'TX', 'TEXT_INSTRUCTION', 'HL70000'),
 'TQ1_12': ('leaf', 'ID', 'CONJUNCTION', 'HL70427'),
 'TQ1_13': ('leaf', 'CQ', 'OCCURRENCE_DURATION', 'HL70000'),
 'TQ1_14': ('leaf', 'NM', 'TOTAL_OCCURRENCE_S', 'HL70000'),
 'TQ1_2': ('leaf', 'CQ', 'QUANTITY', 'HL70000'),
 'TQ1_3': ('leaf', 'RPT', 'REPEAT_PATTERN', 'HL70335'),
 'TQ1_4': ('leaf', 'TM', 'EXPLICIT_TIME', 'HL70000'),
 'TQ1_5': ('leaf', 'CQ', 'RELATIVE_TIME_AND_UNITS', 'HL70000'),
 'TQ1_6': ('leaf', 'CQ', 'SERVICE_DURATION', 'HL70000'),
 'TQ1_7': ('leaf', 'TS', 'START_DATE_TIME', 'HL70000'),
 'TQ1_8': ('leaf', 'TS', 'END_DATE_TIME', 'HL70000'),
 'TQ1_9': ('leaf', 'CWE', 'PRIORITY', 'HL70485'),
 'TQ2_1': ('leaf', 'SI', 'SET_ID_TQ2', 'HL70000'),
 'TQ2_10': ('leaf', 'ID', 'SPECIAL_SERVICE_REQUEST_RELATIONSHIP', 'HL70506'),
 'TQ2_2': ('leaf', 'ID', 'SEQUENCE_RESULTS_FLAG', 'HL70503'),
 'TQ2_3': ('leaf', 'EI', 'RELATED_PLACER_NUMBER', 'HL70000'),
 'TQ2_4': ('leaf', 'EI', 'RELATED_FILLER_NUMBER', 'HL70000'),
 'TQ2_5': ('leaf', 'EI', 'RELATED_PLACER_GROUP_NUMBER', 'HL70000'),
 'TQ2_6': ('leaf', 'ID', 'SEQUENCE_CONDITION_CODE', 'HL70504'),
 'TQ2_7': ('leaf', 'ID', 'CYCLIC_ENTRY_EXIT_INDICATOR', 'HL70505'),
 'TQ2_8': ('leaf', 'CQ', 'SEQUENCE_CONDITION_TIME_INTERVAL', 'HL70000'),
 'TQ2_9': ('leaf', 'NM', 'CYCLIC_GROUP_MAXIMUM_NUMBER_OF_REPEATS', 'HL70000'),
 'TXA_1': ('leaf', 'SI', 'SET_ID_TXA', 'HL70000'),
 'TXA_10': ('leaf', 'XCN', 'ASSIGNED_DOCUMENT_AUTHENTICATOR', 'HL70000'),
 'TXA_11': ('leaf', 'XCN', 'TRANSCRIPTIONIST_CODE_NAME', 'HL70000'),
 'TXA_12': ('leaf', 'EI', 'UNIQUE_DOCUMENT_NUMBER', 'HL70000'),
 'TXA_13': ('leaf', 'EI', 'PARENT_DOCUMENT_NUMBER', 'HL70000'),
 'TXA_14': ('leaf', 'EI', 'PLACER_ORDER_NUMBER', 'HL70000'),
 'TXA_15': ('leaf', 'EI', 'FILLER_ORDER_NUMBER', 'HL70000'),
 'TXA_16': ('leaf', 'ST', 'UNIQUE_DOCUMENT_FILE_NAME', 'HL70000'),
 'TXA_17': ('leaf', 'ID', 'DOCUMENT_COMPLETION_STATUS', 'HL70271'),
 'TXA_18': ('leaf', 'ID', 'DOCUMENT_CONFIDENTIALITY_STATUS', 'HL70272'),
 'TXA_19': ('leaf', 'ID', 'DOCUMENT_AVAILABILITY_STATUS', 'HL70273'),
 'TXA_2': ('leaf', 'IS', 'DOCUMENT_TYPE', 'HL70270'),
 'TXA_20': ('leaf', 'ID', 'DOCUMENT_STORAGE_STATUS', 'HL70275'),
 'TXA_21': ('leaf', 'ST', 'DOCUMENT_CHANGE_REASON', 'HL70000'),
 'TXA_22': ('leaf', 'PPN', 'AUTHENTICATION_PERSON_TIME_STAMP', 'HL70000'),
 'TXA_23': ('leaf',
            'XCN',
            'DISTRIBUTED_COPIES_CODE_AND_NAME_OF_RECIPIENTS_',
            'HL70000'),
 'TXA_3': ('leaf', 'ID', 'DOCUMENT_CONTENT_PRESENTATION', 'HL70191'),
 'TXA_4': ('leaf', 'TS', 'ACTIVITY_DATE_TIME', 'HL70000'),
 'TXA_5': ('leaf', 'XCN', 'PRIMARY_ACTIVITY_PROVIDER_CODE_NAME', 'HL70000'),
 'TXA_6': ('leaf', 'TS', 'ORIGINATION_DATE_TIME', 'HL70000'),
 'TXA_7': ('leaf', 'TS', 'TRANSCRIPTION_DATE_TIME', 'HL70000'),
 'TXA_8': ('leaf', 'TS', 'EDIT_DATE_TIME', 'HL70000'),
 'TXA_9': ('leaf', 'XCN', 'ORIGINATOR_CODE_NAME', 'HL70000'),
 'UB1_1': ('leaf', 'SI', 'SET_ID_UB1', 'HL70000'),
 'UB1_10': ('leaf', 'UVC', 'VALUE_AMOUNT_CODE_46_49_', 'HL70000'),
 'UB1_11': ('leaf', 'NM', 'NUMBER_OF_GRACE_DAYS_90_', 'HL70000'),
 'UB1_12': ('leaf', 'CE', 'SPECIAL_PROGRAM_INDICATOR_44_', 'HL70348'),
 'UB1_13': ('leaf', 'CE', 'PSRO_UR_APPROVAL_INDICATOR_87_', 'HL70349'),
 'UB1_14': ('leaf', 'DT', 'PSRO_UR_APPROVED_STAY_FM_88_', 'HL70000'),
 'UB1_15': ('leaf', 'DT', 'PSRO_UR_APPROVED_STAY_TO_89_', 'HL70000'),
 'UB1_16': ('leaf', 'OCD', 'OCCURRENCE_28_32_', 'HL70000'),
 'UB1_17': ('leaf', 'CE', 'OCCURRENCE_SPAN_33_', 'HL70351'),
 'UB1_18': ('leaf', 'DT', 'OCCUR_SPAN_START_DATE_33_', 'HL70000'),
 'UB1_19': ('leaf', 'DT', 'OCCUR_SPAN_END_DATE_33_', 'HL70000'),
 'UB1_2': ('leaf', 'NM', 'BLOOD_DEDUCTIBLE_43_', 'HL70000'),
 'UB1_20': ('leaf', 'ST', 'UB_82_LOCATOR_2', 'HL70000'),
 'UB1_21': ('leaf', 'ST', 'UB_82_LOCATOR_9', 'HL70000'),
 'UB1_22': ('leaf', 'ST', 'UB_82_LOCATOR_27', 'HL70000'),
 'UB1_23': ('leaf', 'ST', 'UB_82_LOCATOR_45', 'HL70000'),
 'UB1_3': ('leaf', 'NM', 'BLOOD_FURNISHED_PINTS_OF_40_', 'HL70000'),
 'UB1_4': ('leaf', 'NM', 'BLOOD_REPLACED_PINTS_41_', 'HL70000'),
 'UB1_5': ('leaf', 'NM', 'BLOOD_NOT_REPLACED_PINTS_42_', 'HL70000'),
 'UB1_6': ('leaf', 'NM', 'CO_INSURANCE_DAYS_25_', 'HL70000'),
 'UB1_7': ('leaf', 'IS', 'CONDITION_CODE_35_39_', 'HL70043'),
 'UB1_8': ('leaf', 'NM', 'COVERED_DAYS_23_', 'HL70000'),
 'UB1_9': ('leaf', 'NM', 'NON_COVERED_DAYS_24_', 'HL70000'),
 'UB2_1': ('leaf', 'SI', 'SET_ID_UB2', 'HL70000'),
 'UB2_10': ('leaf', 'ST', 'UB92_LOCATOR_11_STATE_', 'HL70000'),
 'UB2_11': ('leaf', 'ST', 'UB92_LOCATOR_31_NATIONAL_', 'HL70000'),
 'UB2_12': ('leaf', 'ST', 'DOCUMENT_CONTROL_NUMBER', 'HL70000'),
 'UB2_13': ('leaf', 'ST', 'UB92_LOCATOR_49_NATIONAL_', 'HL70000'),
 'UB2_14': ('leaf', 'ST', 'UB92_LOCATOR_56_STATE_', 'HL70000'),
 'UB2_15': ('leaf', 'ST', 'UB92_LOCATOR_57_NATIONAL_', 'HL70000'),
 'UB2_16': ('leaf', 'ST', 'UB92_LOCATOR_78_STATE_', 'HL70000'),
 'UB2_17': ('leaf', 'NM', 'SPECIAL_VISIT_COUNT', 'HL70000'),
 'UB2_2': ('leaf', 'ST', 'CO_INSURANCE_DAYS_9_', 'HL70000'),
 'UB2_3': ('leaf', 'IS', 'CONDITION_CODE_24_30_', 'HL70043'),
 'UB2_4': ('leaf', 'ST', 'COVERED_DAYS_7_', 'HL70000'),
 'UB2_5': ('leaf', 'ST', 'NON_COVERED_DAYS_8_', 'HL70000'),
 'UB2_6': ('leaf', 'UVC', 'VALUE_AMOUNT_CODE', 'HL70000'),
 'UB2_7': ('leaf', 'OCD', 'OCCURRENCE_CODE_DATE_32_35_', 'HL70000'),
 'UB2_8': ('leaf', 'OSP', 'OCCURRENCE_SPAN_CODE_DATES_36_', 'HL70000'),
 'UB2_9': ('leaf', 'ST', 'UB92_LOCATOR_2_STATE_', 'HL70000'),
 'URD_1': ('leaf', 'TS', 'R_U_DATE_TIME', 'HL70000'),
 'URD_2': ('leaf', 'ID', 'REPORT_PRIORITY', 'HL70109'),
 'URD_3': ('leaf', 'XCN', 'R_U_WHO_SUBJECT_DEFINITION', 'HL70000'),
 'URD_4': ('leaf', 'CE', 'R_U_WHAT_SUBJECT_DEFINITION', 'HL70048'),
 'URD_5': ('leaf', 'CE', 'R_U_WHAT_DEPARTMENT_CODE', 'HL70000'),
 'URD_6': ('leaf', 'ST', 'R_U_DISPLAY_PRINT_LOCATIONS', 'HL70000'),
 'URD_7': ('leaf', 'ID', 'R_U_RESULTS_LEVEL', 'HL70108'),
 'URS_1': ('leaf', 'ST', 'R_U_WHERE_SUBJECT_DEFINITION', 'HL70000'),
 'URS_2': ('leaf', 'TS', 'R_U_WHEN_DATA_START_DATE_TIME', 'HL70000'),
 'URS_3': ('leaf', 'TS', 'R_U_WHEN_DATA_END_DATE_TIME', 'HL70000'),
 'URS_4': ('leaf', 'ST', 'R_U_WHAT_USER_QUALIFIER', 'HL70000'),
 'URS_5': ('leaf', 'ST', 'R_U_OTHER_RESULTS_SUBJECT_DEFINITION', 'HL70000'),
 'URS_6': ('leaf', 'ID', 'R_U_WHICH_DATE_TIME_QUALIFIER', 'HL70156'),
 'URS_7': ('leaf', 'ID', 'R_U_WHICH_DATE_TIME_STATUS_QUALIFIER', 'HL70157'),
 'URS_8': ('leaf', 'ID', 'R_U_DATE_TIME_SELECTION_QUALIFIER', 'HL70158'),
 'URS_9': ('leaf', 'TQ', 'R_U_QUANTITY_TIMING_QUALIFIER', 'HL70000'),
 'VAR_1': ('leaf', 'EI', 'VARIANCE_INSTANCE_ID', 'HL70000'),
 'VAR_2': ('leaf', 'TS', 'DOCUMENTED_DATE_TIME', 'HL70000'),
 'VAR_3': ('leaf', 'TS', 'STATED_VARIANCE_DATE_TIME', 'HL70000'),
 'VAR_4': ('leaf', 'XCN', 'VARIANCE_ORIGINATOR', 'HL70000'),
 'VAR_5': ('leaf', 'CE', 'VARIANCE_CLASSIFICATION', 'HL70000'),
 'VAR_6': ('leaf', 'ST', 'VARIANCE_DESCRIPTION', 'HL70000'),
 'VTQ_1': ('leaf', 'ST', 'QUERY_TAG', 'HL70000'),
 'VTQ_2': ('leaf', 'ID', 'QUERY_RESPONSE_FORMAT_CODE', 'HL70106'),
 'VTQ_3': ('leaf', 'CE', 'VT_QUERY_NAME', 'HL70000'),
 'VTQ_4': ('leaf', 'CE', 'VIRTUAL_TABLE_NAME', 'HL70000'),
 'VTQ_5': ('leaf', 'QSC', 'SELECTION_CRITERIA', 'HL70000')}
