# -*- coding: utf-8 -*-
#
# Copyright (c) 2012-2014, CRS4
#
# Permission is hereby granted, free of charge, to any person obtaining a copy of
# this software and associated documentation files (the "Software"), to deal in
# the Software without restriction, including without limitation the rights to
# use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
# the Software, and to permit persons to whom the Software is furnished to do so,
# subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
# FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
# COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
# IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
# CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

GROUPS = {'ADT_A01_INSURANCE': ('sequence',
                       (('IN1', (1, 1)), ('IN2', (0, 1)), ('IN3', (0, 1)))),
 'ADT_A01_PROCEDURE': ('sequence', (('PR1', (1, 1)), ('ROL', (0, -1)))),
 'ADT_A03_PROCEDURE': ('sequence', (('PR1', (1, 1)), ('ROL', (0, -1)))),
 'ADT_A06_INSURANCE': ('sequence',
                       (('IN1', (1, 1)), ('IN2', (0, 1)), ('IN3', (0, 1)))),
 'ADT_A06_PROCEDURE': ('sequence', (('PR1', (1, 1)), ('ROL', (0, -1)))),
 'ADT_A39_PATIENT': ('sequence',
                     (('PID', (1, 1)),
                      ('PD1', (0, 1)),
                      ('MRG', (1, 1)),
                      ('PV1', (0, 1)))),
 'ADT_A43_PATIENT': ('sequence',
                     (('PID', (1, 1)), ('PD1', (0, 1)), ('MRG', (1, 1)))),
 'ADT_A45_MERGE_INFO': ('sequence', (('MRG', (1, 1)), ('PV1', (1, 1)))),
 'ARD_A19_INSURANCE': ('sequence',
                       (('IN1', (1, 1)), ('IN2', (0, 1)), ('IN3', (0, 1)))),
 'ARD_A19_PROCEDURE': ('sequence', (('PR1', (1, 1)), ('ROL', (0, -1)))),
 'ARD_A19_QUERY_RESPONSE': ('sequence',
                            (('EVN', (0, 1)),
                             ('PID', (1, 1)),
                             ('PD1', (0, 1)),
                             ('NK1', (0, -1)),
                             ('PV1', (1, 1)),
                             ('PV2', (0, 1)),
                             ('DB1', (0, -1)),
                             ('OBX', (0, -1)),
                             ('AL1', (0, -1)),
                             ('DG1', (0, -1)),
                             ('DRG', (0, 1)),
                             ('ARD_A19_PROCEDURE', (0, -1)),
                             ('GT1', (0, -1)),
                             ('ARD_A19_INSURANCE', (0, -1)),
                             ('ACC', (0, 1)),
                             ('UB1', (0, 1)),
                             ('UB2', (0, 1)))),
 'BAR_P01_INSURANCE': ('sequence',
                       (('IN1', (1, 1)), ('IN2', (0, 1)), ('IN3', (0, 1)))),
 'BAR_P01_PROCEDURE': ('sequence', (('PR1', (1, 1)), ('ROL', (0, -1)))),
 'BAR_P01_VISIT': ('sequence',
                   (('PV1', (0, 1)),
                    ('PV2', (0, 1)),
                    ('DB1', (0, -1)),
                    ('OBX', (0, -1)),
                    ('AL1', (0, -1)),
                    ('DG1', (0, -1)),
                    ('DRG', (0, 1)),
                    ('BAR_P01_PROCEDURE', (0, -1)),
                    ('GT1', (0, -1)),
                    ('NK1', (0, -1)),
                    ('BAR_P01_INSURANCE', (0, -1)),
                    ('ACC', (0, 1)),
                    ('UB1', (0, 1)),
                    ('UB2', (0, 1)))),
 'BAR_P02_PATIENT': ('sequence',
                     (('PID', (1, 1)),
                      ('PD1', (0, 1)),
                      ('PV1', (0, 1)),
                      ('DB1', (0, -1)))),
 'BAR_P06_PATIENT': ('sequence', (('PID', (1, 1)), ('PV1', (0, 1)))),
 'CRM_C01_PATIENT': ('sequence',
                     (('PID', (1, 1)),
                      ('PV1', (0, 1)),
                      ('CSR', (1, 1)),
                      ('CSP', (0, -1)))),
 'CSU_C09_PATIENT': ('sequence',
                     (('PID', (1, 1)),
                      ('PD1', (0, 1)),
                      ('NTE', (0, -1)),
                      ('CSU_C09_VISIT', (0, 1)),
                      ('CSR', (1, 1)),
                      ('CSU_C09_STUDY_PHASE', (1, -1)))),
 'CSU_C09_RX_ADMIN': ('sequence', (('RXA', (1, 1)), ('RXR', (1, 1)))),
 'CSU_C09_STUDY_OBSERVATION': ('sequence',
                               (('ORC', (0, 1)),
                                ('OBR', (1, 1)),
                                ('OBX', (1, -1)))),
 'CSU_C09_STUDY_PHARM': ('sequence',
                         (('ORC', (0, 1)), ('CSU_C09_RX_ADMIN', (1, -1)))),
 'CSU_C09_STUDY_PHASE': ('sequence',
                         (('CSP', (0, 1)),
                          ('CSU_C09_STUDY_SCHEDULE', (1, -1)))),
 'CSU_C09_STUDY_SCHEDULE': ('sequence',
                            (('CSS', (0, 1)),
                             ('CSU_C09_STUDY_OBSERVATION', (0, -1)),
                             ('CSU_C09_STUDY_PHARM', (1, -1)))),
 'CSU_C09_VISIT': ('sequence', (('PV1', (1, 1)), ('PV2', (0, 1)))),
 'DFT_P03_FINANCIAL': ('sequence',
                       (('FT1', (1, 1)),
                        ('DFT_P03_FINANCIAL_PROCEDURE', (0, -1)))),
 'DFT_P03_FINANCIAL_PROCEDURE': ('sequence',
                                 (('PR1', (1, 1)), ('ROL', (0, -1)))),
 'DFT_P03_INSURANCE': ('sequence',
                       (('IN1', (1, 1)), ('IN2', (0, 1)), ('IN3', (0, 1)))),
 'DOC_T12_RESULT': ('sequence',
                    (('EVN', (0, 1)),
                     ('PID', (1, 1)),
                     ('PV1', (1, 1)),
                     ('TXA', (1, 1)),
                     ('OBX', (0, -1)))),
 'MFN_M01_MF': ('sequence', (('MFE', (1, 1)),)),
 'MFN_M02_MF_STAFF': ('sequence',
                      (('MFE', (1, 1)), ('STF', (1, 1)), ('PRA', (0, 1)))),
 'MFN_M03_MF_TEST': ('sequence',
                     (('MFE', (1, 1)),
                      ('OM1', (1, 1)),
                      ('ANYHL7SEGMENT', (1, 1)))),
 'MFN_M05_MF_LOCATION': ('sequence',
                         (('MFE', (1, 1)),
                          ('LOC', (1, 1)),
                          ('LCH', (0, -1)),
                          ('LRL', (0, -1)),
                          ('MFN_M05_MF_LOC_DEPT', (1, -1)))),
 'MFN_M05_MF_LOC_DEPT': ('sequence',
                         (('LDP', (1, 1)),
                          ('LCH', (0, -1)),
                          ('LCC', (0, -1)))),
 'MFN_M06_MF_CDM': ('sequence',
                    (('MFE', (1, 1)), ('CDM', (1, 1)), ('PRC', (0, -1)))),
 'MFN_M07_MF_CLIN_STUDY': ('sequence',
                           (('MFE', (1, 1)),
                            ('CM0', (1, 1)),
                            ('MFN_M07_MF_PHASE_SCHED_DETAIL', (0, -1)))),
 'MFN_M07_MF_PHASE_SCHED_DETAIL': ('sequence',
                                   (('CM1', (1, 1)), ('CM2', (0, -1)))),
 'MFN_M08_MF_NUMERIC_OBSERVATION': ('sequence',
                                    (('OM2', (0, 1)),
                                     ('OM3', (0, 1)),
                                     ('OM4', (0, 1)))),
 'MFN_M08_MF_TEST_NUMERIC': ('sequence',
                             (('MFE', (1, 1)),
                              ('OM1', (1, 1)),
                              ('MFN_M08_MF_NUMERIC_OBSERVATION', (0, 1)))),
 'MFN_M09_MF_TEST_CATEGORICAL': ('sequence',
                                 (('MFE', (1, 1)),
                                  ('MFN_M09_MF_TEST_CAT_DETAIL', (0, 1)))),
 'MFN_M09_MF_TEST_CAT_DETAIL': ('sequence',
                                (('OM3', (1, 1)), ('OM4', (0, -1)))),
 'MFN_M10_MF_TEST_BATTERIES': ('sequence',
                               (('MFN_M10_MF_TEST_BATT_DETAIL', (0, 1)),)),
 'MFN_M10_MF_TEST_BATT_DETAIL': ('sequence',
                                 (('OM5', (1, 1)), ('OM4', (0, -1)))),
 'MFN_M11_MF_TEST_CALCULATED': ('sequence',
                                (('MFE', (1, 1)),
                                 ('OM1', (1, 1)),
                                 ('MFN_M11_MF_TEST_CALC_DETAIL', (0, 1)))),
 'MFN_M11_MF_TEST_CALC_DETAIL': ('sequence',
                                 (('OM6', (1, 1)), ('OM2', (1, 1)))),
 'OMD_O01_DIET': ('sequence',
                  (('ODS', (1, -1)),
                   ('NTE', (0, -1)),
                   ('OMD_O01_OBSERVATION', (1, -1)))),
 'OMD_O01_INSURANCE': ('sequence',
                       (('IN1', (1, 1)), ('IN2', (0, 1)), ('IN3', (0, 1)))),
 'OMD_O01_OBSERVATION': ('sequence', (('OBX', (1, 1)), ('NTE', (0, -1)))),
 'OMD_O01_ORDER_DIET': ('sequence',
                        (('ORC', (1, 1)), ('OMD_O01_DIET', (0, 1)))),
 'OMD_O01_ORDER_TRAY': ('sequence',
                        (('ORC', (1, 1)), ('ODT', (1, -1)), ('NTE', (0, -1)))),
 'OMD_O01_PATIENT': ('sequence',
                     (('PID', (1, 1)),
                      ('PD1', (0, 1)),
                      ('NTE', (0, -1)),
                      ('OMD_O01_PATIENT_VISIT', (0, 1)),
                      ('OMD_O01_INSURANCE', (0, -1)),
                      ('GT1', (0, 1)),
                      ('AL1', (0, -1)))),
 'OMD_O01_PATIENT_VISIT': ('sequence', (('PV1', (1, 1)), ('PV2', (0, 1)))),
 'OMN_O01_INSURANCE': ('sequence',
                       (('IN1', (1, 1)), ('IN2', (0, 1)), ('IN3', (0, 1)))),
 'OMN_O01_OBSERVATION': ('sequence', (('OBX', (1, 1)), ('NTE', (0, -1)))),
 'OMN_O01_ORDER': ('sequence',
                   (('ORC', (1, 1)),
                    ('OMN_O01_ORDER_DETAIL', (0, 1)),
                    ('BLG', (0, 1)))),
 'OMN_O01_ORDER_DETAIL': ('sequence',
                          (('RQD', (1, 1)),
                           ('RQ1', (0, 1)),
                           ('NTE', (0, -1)),
                           ('OMN_O01_OBSERVATION', (0, -1)))),
 'OMN_O01_PATIENT': ('sequence',
                     (('PID', (1, 1)),
                      ('PD1', (0, 1)),
                      ('NTE', (0, -1)),
                      ('OMN_O01_PATIENT_VISIT', (0, 1)),
                      ('OMN_O01_INSURANCE', (0, -1)),
                      ('GT1', (0, 1)),
                      ('AL1', (0, -1)))),
 'OMN_O01_PATIENT_VISIT': ('sequence', (('PV1', (1, 1)), ('PV2', (0, 1)))),
 'OMS_O01_INSURANCE': ('sequence',
                       (('IN1', (1, 1)), ('IN2', (0, 1)), ('IN3', (0, 1)))),
 'OMS_O01_OBSERVATION': ('sequence', (('OBX', (1, 1)), ('NTE', (0, -1)))),
 'OMS_O01_ORDER': ('sequence',
                   (('ORC', (1, 1)),
                    ('OMS_O01_ORDER_DETAIL', (0, 1)),
                    ('BLG', (0, 1)))),
 'OMS_O01_ORDER_DETAIL': ('sequence',
                          (('RQD', (1, 1)),
                           ('NTE', (0, -1)),
                           ('OMS_O01_OBSERVATION', (0, -1)))),
 'OMS_O01_PATIENT': ('sequence',
                     (('PID', (1, 1)),
                      ('PD1', (0, 1)),
                      ('NTE', (0, -1)),
                      ('OMS_O01_PATIENT_VISIT', (0, 1)),
                      ('OMS_O01_INSURANCE', (0, -1)),
                      ('GT1', (0, 1)),
                      ('AL1', (0, -1)))),
 'OMS_O01_PATIENT_VISIT': ('sequence', (('PV1', (1, 1)), ('PV2', (0, 1)))),
 'ORD_O02_ORDER_DIET': ('sequence',
                        (('ORC', (1, 1)), ('ODS', (0, -1)), ('NTE', (0, -1)))),
 'ORD_O02_ORDER_TRAY': ('sequence',
                        (('ORC', (1, 1)), ('ODT', (0, -1)), ('NTE', (0, -1)))),
 'ORD_O02_PATIENT': ('sequence', (('PID', (1, 1)), ('NTE', (0, -1)))),
 'ORD_O02_RESPONSE': ('sequence',
                      (('ORD_O02_PATIENT', (0, 1)),
                       ('ORD_O02_ORDER_DIET', (1, -1)),
                       ('ORD_O02_ORDER_TRAY', (0, -1)))),
 'ORF_R04_OBSERVATION': ('sequence', (('OBX', (0, 1)), ('NTE', (0, -1)))),
 'ORF_R04_ORDER': ('sequence',
                   (('ORC', (0, 1)),
                    ('OBR', (1, 1)),
                    ('NTE', (0, -1)),
                    ('ORF_R04_OBSERVATION', (1, -1)),
                    ('CTI', (0, -1)))),
 'ORF_R04_PATIENT': ('sequence', (('PID', (1, 1)), ('NTE', (0, -1)))),
 'ORF_R04_QUERY_RESPONSE': ('sequence',
                            (('ORF_R04_PATIENT', (0, 1)),
                             ('ORF_R04_ORDER', (1, -1)))),
 'ORM_O01_CHOICE': ('choice',
                    (('OBR', (1, 1)),
                     ('RQD', (1, 1)),
                     ('RQ1', (1, 1)),
                     ('RXO', (1, 1)),
                     ('ODS', (1, 1)),
                     ('ODT', (1, 1)))),
 'ORM_O01_INSURANCE': ('sequence',
                       (('IN1', (1, 1)), ('IN2', (0, 1)), ('IN3', (0, 1)))),
 'ORM_O01_OBSERVATION': ('sequence', (('OBX', (1, 1)), ('NTE', (0, -1)))),
 'ORM_O01_ORDER': ('sequence',
                   (('ORC', (1, 1)),
                    ('ORM_O01_ORDER_DETAIL', (0, 1)),
                    ('CTI', (0, 1)),
                    ('BLG', (0, 1)))),
 'ORM_O01_ORDER_DETAIL': ('sequence',
                          (('ORM_O01_CHOICE', (1, 1)),
                           ('NTE', (0, -1)),
                           ('DG1', (0, -1)),
                           ('ORM_O01_OBSERVATION', (0, -1)))),
 'ORM_O01_PATIENT': ('sequence',
                     (('PID', (1, 1)),
                      ('PD1', (0, 1)),
                      ('NTE', (0, -1)),
                      ('ORM_O01_PATIENT_VISIT', (0, 1)),
                      ('ORM_O01_INSURANCE', (0, -1)),
                      ('GT1', (0, 1)),
                      ('AL1', (0, -1)))),
 'ORM_O01_PATIENT_VISIT': ('sequence', (('PV1', (1, 1)), ('PV2', (0, 1)))),
 'ORN_O02_ORDER': ('sequence',
                   (('ORC', (1, 1)),
                    ('RQD', (1, 1)),
                    ('RQ1', (0, 1)),
                    ('NTE', (0, -1)))),
 'ORN_O02_PATIENT': ('sequence', (('PID', (1, 1)), ('NTE', (0, -1)))),
 'ORN_O02_RESPONSE': ('sequence',
                      (('ORN_O02_PATIENT', (0, 1)),
                       ('ORN_O02_ORDER', (1, -1)))),
 'ORR_O02_CHOICE': ('choice',
                    (('OBR', (1, 1)),
                     ('RQD', (1, 1)),
                     ('RQ1', (1, 1)),
                     ('RXO', (1, 1)),
                     ('ODS', (1, 1)),
                     ('ODT', (1, 1)))),
 'ORR_O02_ORDER': ('sequence',
                   (('ORC', (1, 1)),
                    ('ORR_O02_CHOICE', (1, 1)),
                    ('NTE', (0, -1)),
                    ('CTI', (0, -1)))),
 'ORR_O02_PATIENT': ('sequence', (('PID', (1, 1)), ('NTE', (0, -1)))),
 'ORR_O02_RESPONSE': ('sequence',
                      (('ORR_O02_PATIENT', (0, 1)),
                       ('ORR_O02_ORDER', (1, -1)))),
 'ORU_R01_OBSERVATION': ('sequence', (('OBX', (0, 1)), ('NTE', (0, -1)))),
 'ORU_R01_ORDER_OBSERVATION': ('sequence',
                               (('ORC', (0, 1)),
                                ('OBR', (1, 1)),
                                ('NTE', (0, -1)),
                                ('ORU_R01_OBSERVATION', (1, -1)),
                                ('CTI', (0, -1)))),
 'ORU_R01_PATIENT': ('sequence',
                     (('PID', (1, 1)),
                      ('PD1', (0, 1)),
                      ('NTE', (0, -1)),
                      ('ORU_R01_VISIT', (0, 1)))),
 'ORU_R01_RESPONSE': ('sequence',
                      (('ORU_R01_PATIENT', (0, 1)),
                       ('ORU_R01_ORDER_OBSERVATION', (1, -1)))),
 'ORU_R01_VISIT': ('sequence', (('PV1', (1, 1)), ('PV2', (0, 1)))),
 'OSR_Q06_ORDER': ('sequence',
                   (('ORC', (1, 1)),
                    ('OBR', (0, 1)),
                    ('NTE', (0, -1)),
                    ('CTI', (0, -1)))),
 'OSR_Q06_PATIENT': ('sequence', (('PID', (1, 1)), ('NTE', (0, -1)))),
 'OSR_Q06_RESPONSE': ('sequence',
                      (('OSR_Q06_PATIENT', (0, 1)),
                       ('OSR_Q06_ORDER', (1, -1)))),
 'PEX_P07_ASSOCIATED_PERSON': ('sequence',
                               (('NK1', (1, 1)),
                                ('PEX_P07_ASSOCIATED_RX_ORDER', (0, 1)),
                                ('PEX_P07_ASSOCIATED_RX_ADMIN', (0, -1)),
                                ('PRB', (0, -1)),
                                ('OBX', (0, -1)))),
 'PEX_P07_ASSOCIATED_RX_ADMIN': ('sequence',
                                 (('RXA', (1, 1)), ('RXR', (0, 1)))),
 'PEX_P07_ASSOCIATED_RX_ORDER': ('sequence',
                                 (('RXE', (1, 1)), ('RXR', (0, -1)))),
 'PEX_P07_EXPERIENCE': ('sequence',
                        (('PES', (1, 1)),
                         ('PEX_P07_PEX_OBSERVATION', (1, -1)))),
 'PEX_P07_PEX_CAUSE': ('sequence',
                       (('PCR', (1, 1)),
                        ('PEX_P07_RX_ORDER', (0, 1)),
                        ('PEX_P07_RX_ADMINISTRATION', (0, -1)),
                        ('PRB', (0, -1)),
                        ('OBX', (0, -1)),
                        ('NTE', (0, -1)),
                        ('PEX_P07_ASSOCIATED_PERSON', (0, 1)),
                        ('PEX_P07_STUDY', (0, -1)))),
 'PEX_P07_PEX_OBSERVATION': ('sequence',
                             (('PEO', (1, 1)),
                              ('PEX_P07_PEX_CAUSE', (1, -1)))),
 'PEX_P07_RX_ADMINISTRATION': ('sequence', (('RXA', (1, 1)), ('RXR', (0, 1)))),
 'PEX_P07_RX_ORDER': ('sequence', (('RXE', (1, 1)), ('RXR', (0, -1)))),
 'PEX_P07_STUDY': ('sequence', (('CSR', (1, 1)), ('CSP', (0, -1)))),
 'PEX_P07_VISIT': ('sequence', (('PV1', (1, 1)), ('PV2', (0, 1)))),
 'PGL_PC6_GOAL': ('sequence',
                  (('GOL', (1, 1)),
                   ('NTE', (0, -1)),
                   ('VAR', (0, -1)),
                   ('PGL_PC6_GOAL_ROLE', (0, -1)),
                   ('PGL_PC6_PATHWAY', (0, -1)),
                   ('PGL_PC6_OBSERVATION', (0, -1)),
                   ('PGL_PC6_PROBLEM', (0, -1)),
                   ('PGL_PC6_ORDER', (0, -1)))),
 'PGL_PC6_GOAL_ROLE': ('sequence', (('ROL', (1, 1)), ('VAR', (0, -1)))),
 'PGL_PC6_OBSERVATION': ('sequence', (('OBX', (1, 1)), ('NTE', (0, -1)))),
 'PGL_PC6_ORDER': ('sequence',
                   (('ORC', (1, 1)), ('PGL_PC6_ORDER_DETAIL', (0, 1)))),
 'PGL_PC6_ORDER_DETAIL': ('sequence',
                          (('OBR', (1, 1)),
                           ('NTE', (0, -1)),
                           ('VAR', (0, -1)),
                           ('PGL_PC6_ORDER_OBSERVATION', (0, -1)))),
 'PGL_PC6_ORDER_OBSERVATION': ('sequence',
                               (('OBX', (1, 1)),
                                ('NTE', (0, -1)),
                                ('VAR', (0, -1)))),
 'PGL_PC6_PATHWAY': ('sequence', (('PTH', (1, 1)), ('VAR', (0, -1)))),
 'PGL_PC6_PATIENT_VISIT': ('sequence', (('PV1', (1, 1)), ('PV2', (0, 1)))),
 'PGL_PC6_PROBLEM': ('sequence',
                     (('PRB', (1, 1)),
                      ('NTE', (0, -1)),
                      ('VAR', (0, -1)),
                      ('PGL_PC6_PROBLEM_ROLE', (0, -1)),
                      ('PGL_PC6_PROBLEM_OBSERVATION', (0, -1)))),
 'PGL_PC6_PROBLEM_OBSERVATION': ('sequence',
                                 (('OBX', (1, 1)), ('NTE', (0, -1)))),
 'PGL_PC6_PROBLEM_ROLE': ('sequence', (('ROL', (1, 1)), ('VAR', (0, -1)))),
 'PIN_I07_GUARANTOR_INSURANCE': ('sequence',
                                 (('GT1', (0, -1)),
                                  ('PIN_I07_INSURANCE', (1, -1)))),
 'PIN_I07_INSURANCE': ('sequence',
                       (('IN1', (1, 1)), ('IN2', (0, 1)), ('IN3', (0, 1)))),
 'PIN_I07_PROVIDER': ('sequence', (('PRD', (1, 1)), ('CTD', (0, -1)))),
 'PPG_PCG_GOAL': ('sequence',
                  (('GOL', (1, 1)),
                   ('NTE', (0, -1)),
                   ('VAR', (0, -1)),
                   ('PPG_PCG_GOAL_ROLE', (0, -1)),
                   ('PPG_PCG_GOAL_OBSERVATION', (0, -1)),
                   ('PPG_PCG_PROBLEM', (0, -1)),
                   ('PPG_PCG_ORDER', (0, -1)))),
 'PPG_PCG_GOAL_OBSERVATION': ('sequence', (('OBX', (1, 1)), ('NTE', (0, -1)))),
 'PPG_PCG_GOAL_ROLE': ('sequence', (('ROL', (1, 1)), ('VAR', (0, -1)))),
 'PPG_PCG_ORDER': ('sequence',
                   (('ORC', (1, 1)), ('PPG_PCG_ORDER_DETAIL', (0, 1)))),
 'PPG_PCG_ORDER_DETAIL': ('sequence',
                          (('OBR', (1, 1)),
                           ('NTE', (0, -1)),
                           ('VAR', (0, -1)),
                           ('PPG_PCG_ORDER_OBSERVATION', (0, -1)))),
 'PPG_PCG_ORDER_OBSERVATION': ('sequence',
                               (('OBX', (1, 1)),
                                ('NTE', (0, -1)),
                                ('VAR', (0, -1)))),
 'PPG_PCG_PATHWAY': ('sequence',
                     (('PTH', (1, 1)),
                      ('NTE', (0, -1)),
                      ('VAR', (0, -1)),
                      ('PPG_PCG_PATHWAY_ROLE', (0, -1)),
                      ('PPG_PCG_GOAL', (0, -1)))),
 'PPG_PCG_PATHWAY_ROLE': ('sequence', (('ROL', (1, 1)), ('VAR', (0, -1)))),
 'PPG_PCG_PATIENT_VISIT': ('sequence', (('PV1', (1, 1)), ('PV2', (0, 1)))),
 'PPG_PCG_PROBLEM': ('sequence',
                     (('PRB', (1, 1)),
                      ('NTE', (0, -1)),
                      ('VAR', (0, -1)),
                      ('PPG_PCG_PROBLEM_ROLE', (0, -1)),
                      ('PPG_PCG_PROBLEM_OBSERVATION', (0, -1)))),
 'PPG_PCG_PROBLEM_OBSERVATION': ('sequence',
                                 (('OBX', (1, 1)), ('NTE', (0, -1)))),
 'PPG_PCG_PROBLEM_ROLE': ('sequence', (('ROL', (1, 1)), ('VAR', (0, -1)))),
 'PPP_PCB_GOAL': ('sequence',
                  (('GOL', (1, 1)),
                   ('NTE', (0, -1)),
                   ('VAR', (0, -1)),
                   ('PPP_PCB_GOAL_ROLE', (0, -1)),
                   ('PPP_PCB_GOAL_OBSERVATION', (0, -1)))),
 'PPP_PCB_GOAL_OBSERVATION': ('sequence', (('OBX', (1, 1)), ('NTE', (0, -1)))),
 'PPP_PCB_GOAL_ROLE': ('sequence', (('ROL', (1, 1)), ('VAR', (0, -1)))),
 'PPP_PCB_ORDER': ('sequence',
                   (('ORC', (1, 1)), ('PPP_PCB_ORDER_DETAIL', (0, 1)))),
 'PPP_PCB_ORDER_DETAIL': ('sequence',
                          (('OBR', (1, 1)),
                           ('NTE', (0, -1)),
                           ('VAR', (0, -1)),
                           ('PPP_PCB_ORDER_OBSERVATION', (0, -1)))),
 'PPP_PCB_ORDER_OBSERVATION': ('sequence',
                               (('OBX', (1, 1)),
                                ('NTE', (0, -1)),
                                ('VAR', (0, -1)))),
 'PPP_PCB_PATHWAY': ('sequence',
                     (('PTH', (1, 1)),
                      ('NTE', (0, -1)),
                      ('VAR', (0, -1)),
                      ('PPP_PCB_PATHWAY_ROLE', (0, -1)),
                      ('PPP_PCB_PROBLEM', (0, -1)))),
 'PPP_PCB_PATHWAY_ROLE': ('sequence', (('ROL', (1, 1)), ('VAR', (0, -1)))),
 'PPP_PCB_PATIENT_VISIT': ('sequence', (('PV1', (1, 1)), ('PV2', (0, 1)))),
 'PPP_PCB_PROBLEM': ('sequence',
                     (('PRB', (1, 1)),
                      ('NTE', (0, -1)),
                      ('VAR', (0, -1)),
                      ('PPP_PCB_PROBLEM_ROLE', (0, -1)),
                      ('PPP_PCB_PROBLEM_OBSERVATION', (0, -1)),
                      ('PPP_PCB_GOAL', (0, -1)),
                      ('PPP_PCB_ORDER', (0, -1)))),
 'PPP_PCB_PROBLEM_OBSERVATION': ('sequence',
                                 (('OBX', (1, 1)), ('NTE', (0, -1)))),
 'PPP_PCB_PROBLEM_ROLE': ('sequence', (('ROL', (1, 1)), ('VAR', (0, -1)))),
 'PPR_PC1_GOAL': ('sequence',
                  (('GOL', (1, 1)),
                   ('NTE', (0, -1)),
                   ('VAR', (0, -1)),
                   ('PPR_PC1_GOAL_ROLE', (0, -1)),
                   ('PPR_PC1_GOAL_OBSERVATION', (0, -1)))),
 'PPR_PC1_GOAL_OBSERVATION': ('sequence', (('OBX', (1, 1)), ('NTE', (0, -1)))),
 'PPR_PC1_GOAL_ROLE': ('sequence', (('ROL', (1, 1)), ('VAR', (0, -1)))),
 'PPR_PC1_ORDER': ('sequence',
                   (('ORC', (1, 1)), ('PPR_PC1_ORDER_DETAIL', (0, 1)))),
 'PPR_PC1_ORDER_DETAIL': ('sequence',
                          (('OBR', (1, 1)),
                           ('NTE', (0, -1)),
                           ('VAR', (0, -1)),
                           ('PPR_PC1_ORDER_OBSERVATION', (0, -1)))),
 'PPR_PC1_ORDER_OBSERVATION': ('sequence',
                               (('OBX', (1, 1)),
                                ('NTE', (0, -1)),
                                ('VAR', (0, -1)))),
 'PPR_PC1_PATHWAY': ('sequence', (('PTH', (1, 1)), ('VAR', (0, -1)))),
 'PPR_PC1_PATIENT_VISIT': ('sequence', (('PV1', (1, 1)), ('PV2', (0, 1)))),
 'PPR_PC1_PROBLEM': ('sequence',
                     (('PRB', (1, 1)),
                      ('NTE', (0, -1)),
                      ('VAR', (0, -1)),
                      ('PPR_PC1_PROBLEM_ROLE', (0, -1)),
                      ('PPR_PC1_PATHWAY', (0, -1)),
                      ('PPR_PC1_PROBLEM_OBSERVATION', (0, -1)),
                      ('PPR_PC1_GOAL', (0, -1)),
                      ('PPR_PC1_ORDER', (0, -1)))),
 'PPR_PC1_PROBLEM_OBSERVATION': ('sequence',
                                 (('OBX', (1, 1)), ('NTE', (0, -1)))),
 'PPR_PC1_PROBLEM_ROLE': ('sequence', (('ROL', (1, 1)), ('VAR', (0, -1)))),
 'PPT_PCL_GOAL': ('sequence',
                  (('GOL', (1, 1)),
                   ('NTE', (0, -1)),
                   ('VAR', (0, -1)),
                   ('PPT_PCL_GOAL_ROLE', (0, -1)),
                   ('PPT_PCL_GOAL_OBSERVATION', (0, -1)),
                   ('PPT_PCL_PROBLEM', (0, -1)),
                   ('PPT_PCL_ORDER', (0, -1)))),
 'PPT_PCL_GOAL_OBSERVATION': ('sequence', (('OBX', (1, 1)), ('NTE', (0, -1)))),
 'PPT_PCL_GOAL_ROLE': ('sequence', (('ROL', (1, 1)), ('VAR', (0, -1)))),
 'PPT_PCL_ORDER': ('sequence',
                   (('ORC', (1, 1)), ('PPT_PCL_ORDER_DETAIL', (0, 1)))),
 'PPT_PCL_ORDER_DETAIL': ('sequence',
                          (('OBR', (1, 1)),
                           ('NTE', (0, -1)),
                           ('VAR', (0, -1)),
                           ('PPT_PCL_ORDER_OBSERVATION', (0, -1)))),
 'PPT_PCL_ORDER_OBSERVATION': ('sequence',
                               (('OBX', (1, 1)),
                                ('NTE', (0, -1)),
                                ('VAR', (0, -1)))),
 'PPT_PCL_PATHWAY': ('sequence',
                     (('PTH', (1, 1)),
                      ('NTE', (0, -1)),
                      ('VAR', (0, -1)),
                      ('PPT_PCL_PATHWAY_ROLE', (0, -1)),
                      ('PPT_PCL_GOAL', (0, -1)))),
 'PPT_PCL_PATHWAY_ROLE': ('sequence', (('ROL', (1, 1)), ('VAR', (0, -1)))),
 'PPT_PCL_PATIENT': ('sequence',
                     (('PID', (1, 1)),
                      ('PPT_PCL_PATIENT_VISIT', (0, 1)),
                      ('PPT_PCL_PATHWAY', (1, -1)))),
 'PPT_PCL_PATIENT_VISIT': ('sequence', (('PV1', (1, 1)), ('PV2', (0, 1)))),
 'PPT_PCL_PROBLEM': ('sequence',
                     (('PRB', (1, 1)),
                      ('NTE', (0, -1)),
                      ('VAR', (0, -1)),
                      ('PPT_PCL_PROBLEM_ROLE', (0, -1)),
                      ('PPT_PCL_PROBLEM_OBSERVATION', (0, -1)))),
 'PPT_PCL_PROBLEM_OBSERVATION': ('sequence',
                                 (('OBX', (1, 1)), ('NTE', (0, -1)))),
 'PPT_PCL_PROBLEM_ROLE': ('sequence', (('ROL', (1, 1)), ('VAR', (0, -1)))),
 'PPV_PCA_GOAL': ('sequence',
                  (('GOL', (1, 1)),
                   ('NTE', (0, -1)),
                   ('VAR', (0, -1)),
                   ('PPV_PCA_GOAL_ROLE', (0, -1)),
                   ('PPV_PCA_GOAL_PATHWAY', (0, -1)),
                   ('PPV_PCA_GOAL_OBSERVATION', (0, -1)),
                   ('PPV_PCA_PROBLEM', (0, -1)),
                   ('PPV_PCA_ORDER', (0, -1)))),
 'PPV_PCA_GOAL_OBSERVATION': ('sequence', (('OBX', (1, 1)), ('NTE', (0, -1)))),
 'PPV_PCA_GOAL_PATHWAY': ('sequence', (('PTH', (1, 1)), ('VAR', (0, -1)))),
 'PPV_PCA_GOAL_ROLE': ('sequence', (('ROL', (1, 1)), ('VAR', (0, -1)))),
 'PPV_PCA_ORDER': ('sequence',
                   (('ORC', (1, 1)), ('PPV_PCA_ORDER_DETAIL', (0, 1)))),
 'PPV_PCA_ORDER_DETAIL': ('sequence',
                          (('OBR', (1, 1)),
                           ('NTE', (0, -1)),
                           ('VAR', (0, -1)),
                           ('PPV_PCA_ORDER_OBSERVATION', (0, -1)))),
 'PPV_PCA_ORDER_OBSERVATION': ('sequence',
                               (('OBX', (1, 1)),
                                ('NTE', (0, -1)),
                                ('VAR', (0, -1)))),
 'PPV_PCA_PATIENT': ('sequence',
                     (('PID', (1, 1)),
                      ('PPV_PCA_PATIENT_VISIT', (0, 1)),
                      ('PPV_PCA_GOAL', (1, -1)))),
 'PPV_PCA_PATIENT_VISIT': ('sequence', (('PV1', (1, 1)), ('PV2', (0, 1)))),
 'PPV_PCA_PROBLEM': ('sequence',
                     (('PRB', (1, 1)),
                      ('NTE', (0, -1)),
                      ('VAR', (0, -1)),
                      ('PPV_PCA_PROBLEM_ROLE', (0, -1)),
                      ('PPV_PCA_PROBLEM_OBSERVATION', (0, -1)))),
 'PPV_PCA_PROBLEM_OBSERVATION': ('sequence',
                                 (('OBX', (1, 1)), ('NTE', (0, -1)))),
 'PPV_PCA_PROBLEM_ROLE': ('sequence', (('ROL', (1, 1)), ('VAR', (0, -1)))),
 'PRR_PC5_GOAL': ('sequence',
                  (('GOL', (1, 1)),
                   ('NTE', (0, -1)),
                   ('VAR', (0, -1)),
                   ('PRR_PC5_GOAL_ROLE', (0, -1)),
                   ('PRR_PC5_GOAL_OBSERVATION', (0, -1)))),
 'PRR_PC5_GOAL_OBSERVATION': ('sequence', (('OBX', (1, 1)), ('NTE', (0, -1)))),
 'PRR_PC5_GOAL_ROLE': ('sequence', (('ROL', (1, 1)), ('VAR', (0, -1)))),
 'PRR_PC5_ORDER': ('sequence',
                   (('ORC', (1, 1)), ('PRR_PC5_ORDER_DETAIL', (0, 1)))),
 'PRR_PC5_ORDER_DETAIL': ('sequence',
                          (('OBR', (1, 1)),
                           ('NTE', (0, -1)),
                           ('VAR', (0, -1)),
                           ('PRR_PC5_ORDER_OBSERVATION', (0, -1)))),
 'PRR_PC5_ORDER_OBSERVATION': ('sequence',
                               (('OBX', (1, 1)),
                                ('NTE', (0, -1)),
                                ('VAR', (0, -1)))),
 'PRR_PC5_PATIENT': ('sequence',
                     (('PID', (1, 1)),
                      ('PRR_PC5_PATIENT_VISIT', (0, 1)),
                      ('PRR_PC5_PROBLEM', (1, -1)))),
 'PRR_PC5_PATIENT_VISIT': ('sequence', (('PV1', (1, 1)), ('PV2', (0, 1)))),
 'PRR_PC5_PROBLEM': ('sequence',
                     (('PRB', (1, 1)),
                      ('NTE', (0, -1)),
                      ('VAR', (0, -1)),
                      ('PRR_PC5_PROBLEM_ROLE', (0, -1)),
                      ('PRR_PC5_PROBLEM_PATHWAY', (0, -1)),
                      ('PRR_PC5_PROBLEM_OBSERVATION', (0, -1)),
                      ('PRR_PC5_GOAL', (0, -1)),
                      ('PRR_PC5_ORDER', (0, -1)))),
 'PRR_PC5_PROBLEM_OBSERVATION': ('sequence',
                                 (('OBX', (1, 1)), ('NTE', (0, -1)))),
 'PRR_PC5_PROBLEM_PATHWAY': ('sequence', (('PTH', (1, 1)), ('VAR', (0, -1)))),
 'PRR_PC5_PROBLEM_ROLE': ('sequence', (('ROL', (1, 1)), ('VAR', (0, -1)))),
 'PTR_PCF_GOAL': ('sequence',
                  (('GOL', (1, 1)),
                   ('NTE', (0, -1)),
                   ('VAR', (0, -1)),
                   ('PTR_PCF_GOAL_ROLE', (0, -1)),
                   ('PTR_PCF_GOAL_OBSERVATION', (0, -1)))),
 'PTR_PCF_GOAL_OBSERVATION': ('sequence', (('OBX', (1, 1)), ('NTE', (0, -1)))),
 'PTR_PCF_GOAL_ROLE': ('sequence', (('ROL', (1, 1)), ('VAR', (0, -1)))),
 'PTR_PCF_ORDER': ('sequence',
                   (('ORC', (1, 1)), ('PTR_PCF_ORDER_DETAIL', (0, 1)))),
 'PTR_PCF_ORDER_DETAIL': ('sequence',
                          (('OBR', (1, 1)),
                           ('NTE', (0, -1)),
                           ('VAR', (0, -1)),
                           ('PTR_PCF_ORDER_OBSERVATION', (0, -1)))),
 'PTR_PCF_ORDER_OBSERVATION': ('sequence',
                               (('OBX', (1, 1)),
                                ('NTE', (0, -1)),
                                ('VAR', (0, -1)))),
 'PTR_PCF_PATHWAY': ('sequence',
                     (('PTH', (1, 1)),
                      ('NTE', (0, -1)),
                      ('VAR', (0, -1)),
                      ('PTR_PCF_PATHWAY_ROLE', (0, -1)),
                      ('PTR_PCF_PROBLEM', (0, -1)))),
 'PTR_PCF_PATHWAY_ROLE': ('sequence', (('ROL', (1, 1)), ('VAR', (0, -1)))),
 'PTR_PCF_PATIENT': ('sequence',
                     (('PID', (1, 1)),
                      ('PTR_PCF_PATIENT_VISIT', (0, 1)),
                      ('PTR_PCF_PATHWAY', (1, -1)))),
 'PTR_PCF_PATIENT_VISIT': ('sequence', (('PV1', (1, 1)), ('PV2', (0, 1)))),
 'PTR_PCF_PROBLEM': ('sequence',
                     (('PRB', (1, 1)),
                      ('NTE', (0, -1)),
                      ('VAR', (0, -1)),
                      ('PTR_PCF_PROBLEM_ROLE', (0, -1)),
                      ('PTR_PCF_PROBLEM_OBSERVATION', (0, -1)),
                      ('PTR_PCF_GOAL', (0, -1)),
                      ('PTR_PCF_ORDER', (0, -1)))),
 'PTR_PCF_PROBLEM_OBSERVATION': ('sequence',
                                 (('OBX', (1, 1)), ('NTE', (0, -1)))),
 'PTR_PCF_PROBLEM_ROLE': ('sequence', (('ROL', (1, 1)), ('VAR', (0, -1)))),
 'RAR_RAR_DEFINITION': ('sequence',
                        (('QRD', (1, 1)),
                         ('QRF', (0, 1)),
                         ('RAR_RAR_PATIENT', (0, 1)),
                         ('RAR_RAR_ORDER', (1, -1)))),
 'RAR_RAR_ENCODING': ('sequence',
                      (('RXE', (1, 1)), ('RXR', (1, -1)), ('RXC', (0, -1)))),
 'RAR_RAR_ORDER': ('sequence',
                   (('ORC', (1, 1)),
                    ('RAR_RAR_ENCODING', (0, 1)),
                    ('RXA', (1, -1)))),
 'RAR_RAR_PATIENT': ('sequence', (('PID', (1, 1)), ('NTE', (0, -1)))),
 'RAS_O01_COMPONENTS': ('sequence', (('RXC', (1, -1)), ('NTE', (0, -1)))),
 'RAS_O01_ENCODING': ('sequence',
                      (('RXE', (1, 1)), ('RXR', (1, -1)), ('RXC', (0, -1)))),
 'RAS_O01_OBSERVATION': ('sequence', (('OBX', (1, 1)), ('NTE', (0, -1)))),
 'RAS_O01_ORDER': ('sequence',
                   (('ORC', (1, 1)),
                    ('RAS_O01_ORDER_DETAIL', (0, 1)),
                    ('RAS_O01_ENCODING', (0, 1)),
                    ('RXA', (1, -1)),
                    ('RXR', (1, 1)),
                    ('RAS_O01_OBSERVATION', (0, -1)),
                    ('CTI', (0, -1)))),
 'RAS_O01_ORDER_DETAIL': ('sequence',
                          (('RXO', (1, 1)),
                           ('RAS_O01_ORDER_DETAIL_SUPPLEMENT', (0, 1)))),
 'RAS_O01_ORDER_DETAIL_SUPPLEMENT': ('sequence',
                                     (('NTE', (1, -1)),
                                      ('RXR', (1, -1)),
                                      ('RAS_O01_COMPONENTS', (0, 1)))),
 'RAS_O01_PATIENT': ('sequence',
                     (('PID', (1, 1)),
                      ('PD1', (0, 1)),
                      ('NTE', (0, -1)),
                      ('AL1', (0, -1)),
                      ('RAS_O01_PATIENT_VISIT', (0, 1)))),
 'RAS_O01_PATIENT_VISIT': ('sequence', (('PV1', (1, 1)), ('PV2', (0, 1)))),
 'RCI_I05_OBSERVATION': ('sequence',
                         (('OBR', (1, 1)),
                          ('NTE', (0, -1)),
                          ('RCI_I05_RESULTS', (0, -1)))),
 'RCI_I05_PROVIDER': ('sequence', (('PRD', (1, 1)), ('CTD', (0, -1)))),
 'RCI_I05_RESULTS': ('sequence', (('OBX', (1, 1)), ('NTE', (0, -1)))),
 'RCL_I06_PROVIDER': ('sequence', (('PRD', (1, 1)), ('CTD', (0, -1)))),
 'RDE_O01_COMPONENT': ('sequence', (('RXC', (1, -1)), ('NTE', (0, -1)))),
 'RDE_O01_INSURANCE': ('sequence',
                       (('IN1', (1, 1)), ('IN2', (0, 1)), ('IN3', (0, 1)))),
 'RDE_O01_OBSERVATION': ('sequence', (('OBX', (0, 1)), ('NTE', (0, -1)))),
 'RDE_O01_ORDER': ('sequence',
                   (('ORC', (1, 1)),
                    ('RDE_O01_ORDER_DETAIL', (0, 1)),
                    ('RXE', (1, 1)),
                    ('RXR', (1, -1)),
                    ('RXC', (0, -1)),
                    ('RDE_O01_OBSERVATION', (1, -1)),
                    ('CTI', (0, 1)))),
 'RDE_O01_ORDER_DETAIL': ('sequence',
                          (('RXO', (1, 1)),
                           ('NTE', (0, -1)),
                           ('RXR', (1, -1)),
                           ('RDE_O01_COMPONENT', (0, 1)))),
 'RDE_O01_PATIENT': ('sequence',
                     (('PID', (1, 1)),
                      ('PD1', (0, 1)),
                      ('NTE', (0, -1)),
                      ('RDE_O01_PATIENT_VISIT', (0, 1)),
                      ('RDE_O01_INSURANCE', (0, -1)),
                      ('GT1', (0, 1)),
                      ('AL1', (0, -1)))),
 'RDE_O01_PATIENT_VISIT': ('sequence', (('PV1', (1, 1)), ('PV2', (0, 1)))),
 'RDO_O01_COMPONENT': ('sequence', (('RXC', (1, -1)), ('NTE', (0, -1)))),
 'RDO_O01_INSURANCE': ('sequence',
                       (('IN1', (1, 1)), ('IN2', (0, 1)), ('IN3', (0, 1)))),
 'RDO_O01_OBSERVATION': ('sequence', (('OBX', (1, 1)), ('NTE', (0, -1)))),
 'RDO_O01_ORDER': ('sequence',
                   (('ORC', (1, 1)),
                    ('RDO_O01_ORDER_DETAIL', (0, 1)),
                    ('BLG', (0, 1)))),
 'RDO_O01_ORDER_DETAIL': ('sequence',
                          (('RXO', (1, 1)),
                           ('NTE', (0, -1)),
                           ('RXR', (1, -1)),
                           ('RDO_O01_COMPONENT', (0, 1)),
                           ('RDO_O01_OBSERVATION', (0, -1)))),
 'RDO_O01_PATIENT': ('sequence',
                     (('PID', (1, 1)),
                      ('PD1', (0, 1)),
                      ('NTE', (0, -1)),
                      ('RDO_O01_PATIENT_VISIT', (0, 1)),
                      ('RDO_O01_INSURANCE', (0, -1)),
                      ('GT1', (0, 1)),
                      ('AL1', (0, -1)))),
 'RDO_O01_PATIENT_VISIT': ('sequence', (('PV1', (1, 1)), ('PV2', (0, 1)))),
 'RDR_RDR_DEFINITION': ('sequence',
                        (('QRD', (1, 1)),
                         ('QRF', (0, 1)),
                         ('RDR_RDR_PATIENT', (0, 1)),
                         ('RDR_RDR_ORDER', (1, -1)))),
 'RDR_RDR_DISPENSE': ('sequence',
                      (('RXD', (1, 1)), ('RXR', (1, -1)), ('RXC', (0, -1)))),
 'RDR_RDR_ENCODING': ('sequence',
                      (('RXE', (1, 1)), ('RXR', (1, 1)), ('RXC', (0, -1)))),
 'RDR_RDR_ORDER': ('sequence',
                   (('ORC', (1, 1)),
                    ('RDR_RDR_ENCODING', (0, 1)),
                    ('RDR_RDR_DISPENSE', (1, -1)))),
 'RDR_RDR_PATIENT': ('sequence', (('PID', (1, 1)), ('NTE', (0, -1)))),
 'RDS_O01_COMPONENT': ('sequence', (('RXC', (1, -1)), ('NTE', (0, -1)))),
 'RDS_O01_ENCODING': ('sequence',
                      (('RXE', (1, 1)), ('RXR', (1, -1)), ('RXC', (0, -1)))),
 'RDS_O01_OBSERVATION': ('sequence', (('OBX', (1, 1)), ('NTE', (0, -1)))),
 'RDS_O01_ORDER': ('sequence',
                   (('ORC', (1, 1)),
                    ('RDS_O01_ORDER_DETAIL', (0, 1)),
                    ('RDS_O01_ENCODING', (0, 1)),
                    ('RXD', (1, 1)),
                    ('RXR', (1, -1)),
                    ('RXC', (0, -1)),
                    ('RDS_O01_OBSERVATION', (1, -1)))),
 'RDS_O01_ORDER_DETAIL': ('sequence',
                          (('RXO', (1, 1)),
                           ('RDS_O01_ORDER_DETAIL_SUPPLEMENT', (0, 1)))),
 'RDS_O01_ORDER_DETAIL_SUPPLEMENT': ('sequence',
                                     (('NTE', (1, -1)),
                                      ('RXR', (1, -1)),
                                      ('RDS_O01_COMPONENT', (0, 1)))),
 'RDS_O01_PATIENT': ('sequence',
                     (('PID', (1, 1)),
                      ('PD1', (0, 1)),
                      ('NTE', (0, -1)),
                      ('AL1', (0, -1)),
                      ('RDS_O01_PATIENT_VISIT', (0, 1)))),
 'RDS_O01_PATIENT_VISIT': ('sequence', (('PV1', (1, 1)), ('PV2', (0, 1)))),
 'REF_I12_AUTCTD_SUPPGRP2': ('sequence', (('AUT', (1, 1)), ('CTD', (0, 1)))),
 'REF_I12_AUTHORIZATION': ('sequence', (('AUT', (1, 1)), ('CTD', (0, 1)))),
 'REF_I12_INSURANCE': ('sequence',
                       (('IN1', (1, 1)), ('IN2', (0, 1)), ('IN3', (0, 1)))),
 'REF_I12_OBSERVATION': ('sequence', (('OBX', (1, 1)), ('NTE', (0, -1)))),
 'REF_I12_PROCEDURE': ('sequence',
                       (('PR1', (1, 1)), ('REF_I12_AUTCTD_SUPPGRP2', (0, 1)))),
 'REF_I12_PROVIDER': ('sequence', (('PRD', (1, 1)), ('CTD', (0, -1)))),
 'REF_I12_RESULTS': ('sequence',
                     (('OBR', (1, 1)),
                      ('NTE', (0, -1)),
                      ('REF_I12_OBSERVATION', (0, -1)))),
 'REF_I12_VISIT': ('sequence', (('PV1', (1, 1)), ('PV2', (0, 1)))),
 'RER_RER_DEFINITION': ('sequence',
                        (('QRD', (1, 1)),
                         ('QRF', (0, 1)),
                         ('RER_RER_PATIENT', (0, 1)),
                         ('RER_RER_ORDER', (1, -1)))),
 'RER_RER_ORDER': ('sequence',
                   (('ORC', (1, 1)),
                    ('RXE', (1, 1)),
                    ('RXR', (1, -1)),
                    ('RXC', (0, -1)))),
 'RER_RER_PATIENT': ('sequence', (('PID', (1, 1)), ('NTE', (0, -1)))),
 'RGR_RGR_DEFINITION': ('sequence',
                        (('QRD', (1, 1)),
                         ('QRF', (0, 1)),
                         ('RGR_RGR_PATIENT', (0, 1)),
                         ('RGR_RGR_ORDER', (1, -1)))),
 'RGR_RGR_ENCODING': ('sequence',
                      (('RXE', (1, 1)), ('RXR', (1, -1)), ('RXC', (0, -1)))),
 'RGR_RGR_ORDER': ('sequence',
                   (('ORC', (1, 1)),
                    ('RGR_RGR_ENCODING', (0, 1)),
                    ('RXG', (1, -1)),
                    ('RXR', (1, -1)),
                    ('RXC', (0, -1)))),
 'RGR_RGR_PATIENT': ('sequence', (('PID', (1, 1)), ('NTE', (0, -1)))),
 'RGV_O01_COMPONENTS': ('sequence', (('RXC', (1, -1)), ('NTE', (0, -1)))),
 'RGV_O01_ENCODING': ('sequence',
                      (('RXE', (1, 1)), ('RXR', (1, -1)), ('RXC', (0, -1)))),
 'RGV_O01_GIVE': ('sequence',
                  (('RXG', (1, 1)),
                   ('RXR', (1, -1)),
                   ('RXC', (0, -1)),
                   ('RGV_O01_OBSERVATION', (0, -1)))),
 'RGV_O01_OBSERVATION': ('sequence', (('OBX', (1, 1)), ('NTE', (0, -1)))),
 'RGV_O01_ORDER': ('sequence',
                   (('ORC', (1, 1)),
                    ('RGV_O01_ORDER_DETAIL', (0, 1)),
                    ('RGV_O01_ENCODING', (0, 1)),
                    ('RGV_O01_GIVE', (1, -1)))),
 'RGV_O01_ORDER_DETAIL': ('sequence',
                          (('RXO', (1, 1)),
                           ('RGV_O01_ORDER_DETAIL_SUPPLEMENT', (0, 1)))),
 'RGV_O01_ORDER_DETAIL_SUPPLEMENT': ('sequence',
                                     (('NTE', (1, -1)),
                                      ('RXR', (1, -1)),
                                      ('RGV_O01_COMPONENTS', (0, 1)))),
 'RGV_O01_PATIENT': ('sequence',
                     (('PID', (1, 1)),
                      ('NTE', (0, -1)),
                      ('AL1', (0, -1)),
                      ('RGV_O01_PATIENT_VISIT', (0, 1)))),
 'RGV_O01_PATIENT_VISIT': ('sequence', (('PV1', (1, 1)), ('PV2', (0, 1)))),
 'ROR_ROR_DEFINITION': ('sequence',
                        (('QRD', (1, 1)),
                         ('QRF', (0, 1)),
                         ('ROR_ROR_PATIENT', (0, 1)),
                         ('ROR_ROR_ORDER', (1, -1)))),
 'ROR_ROR_ORDER': ('sequence',
                   (('ORC', (1, 1)),
                    ('RXO', (1, 1)),
                    ('RXR', (1, -1)),
                    ('RXC', (0, -1)))),
 'ROR_ROR_PATIENT': ('sequence', (('PID', (1, 1)), ('NTE', (0, -1)))),
 'RPA_I08_AUTCTD_SUPPGRP2': ('sequence', (('AUT', (1, 1)), ('CTD', (0, 1)))),
 'RPA_I08_AUTHORIZATION': ('sequence', (('AUT', (1, 1)), ('CTD', (0, 1)))),
 'RPA_I08_INSURANCE': ('sequence',
                       (('IN1', (1, 1)), ('IN2', (0, 1)), ('IN3', (0, 1)))),
 'RPA_I08_OBSERVATION': ('sequence',
                         (('OBR', (1, 1)),
                          ('NTE', (0, -1)),
                          ('RPA_I08_RESULTS', (0, -1)))),
 'RPA_I08_PROCEDURE': ('sequence',
                       (('PR1', (1, 1)), ('RPA_I08_AUTCTD_SUPPGRP2', (0, 1)))),
 'RPA_I08_PROVIDER': ('sequence', (('PRD', (1, 1)), ('CTD', (0, -1)))),
 'RPA_I08_RESULTS': ('sequence', (('OBX', (1, 1)), ('NTE', (0, -1)))),
 'RPA_I08_VISIT': ('sequence',
                   (('PV1', (1, 1)), ('PV2', (0, 1)), ('NTE', (0, -1)))),
 'RPI_I01_GUARANTOR_INSURANCE': ('sequence',
                                 (('GT1', (0, -1)),
                                  ('RPI_I01_INSURANCE', (1, -1)))),
 'RPI_I01_INSURANCE': ('sequence',
                       (('IN1', (1, 1)), ('IN2', (0, 1)), ('IN3', (0, 1)))),
 'RPI_I01_PROVIDER': ('sequence', (('PRD', (1, 1)), ('CTD', (0, -1)))),
 'RPL_I02_PROVIDER': ('sequence', (('PRD', (1, 1)), ('CTD', (0, -1)))),
 'RQA_I08_AUTCTD_SUPPGRP2': ('sequence', (('AUT', (1, 1)), ('CTD', (0, 1)))),
 'RQA_I08_AUTHORIZATION': ('sequence', (('AUT', (1, 1)), ('CTD', (0, 1)))),
 'RQA_I08_GUARANTOR_INSURANCE': ('sequence',
                                 (('GT1', (0, -1)),
                                  ('RQA_I08_INSURANCE', (1, -1)))),
 'RQA_I08_INSURANCE': ('sequence',
                       (('IN1', (1, 1)), ('IN2', (0, 1)), ('IN3', (0, 1)))),
 'RQA_I08_OBSERVATION': ('sequence',
                         (('OBR', (1, 1)),
                          ('NTE', (0, -1)),
                          ('RQA_I08_RESULTS', (0, -1)))),
 'RQA_I08_PROCEDURE': ('sequence',
                       (('PR1', (1, 1)), ('RQA_I08_AUTCTD_SUPPGRP2', (0, 1)))),
 'RQA_I08_PROVIDER': ('sequence', (('PRD', (1, 1)), ('CTD', (0, -1)))),
 'RQA_I08_RESULTS': ('sequence', (('OBX', (1, 1)), ('NTE', (0, -1)))),
 'RQA_I08_VISIT': ('sequence', (('PV1', (1, 1)), ('PV2', (0, 1)))),
 'RQC_I05_PROVIDER': ('sequence', (('PRD', (1, 1)), ('CTD', (0, -1)))),
 'RQC_I06_PROVIDER': ('sequence', (('PRD', (1, 1)), ('CTD', (0, -1)))),
 'RQI_I01_GUARANTOR_INSURANCE': ('sequence',
                                 (('GT1', (0, -1)),
                                  ('RQI_I01_INSURANCE', (1, -1)))),
 'RQI_I01_INSURANCE': ('sequence',
                       (('IN1', (1, 1)), ('IN2', (0, 1)), ('IN3', (0, 1)))),
 'RQI_I01_PROVIDER': ('sequence', (('PRD', (1, 1)), ('CTD', (0, -1)))),
 'RQP_I04_PROVIDER': ('sequence', (('PRD', (1, 1)), ('CTD', (0, -1)))),
 'RRA_O02_ADMINISTRATION': ('sequence', (('RXA', (1, 1)), ('RXR', (1, 1)))),
 'RRA_O02_ORDER': ('sequence',
                   (('ORC', (1, 1)), ('RRA_O02_ADMINISTRATION', (0, -1)))),
 'RRA_O02_PATIENT': ('sequence', (('PID', (1, 1)), ('NTE', (0, -1)))),
 'RRA_O02_RESPONSE': ('sequence',
                      (('RRA_O02_PATIENT', (0, 1)),
                       ('RRA_O02_ORDER', (1, -1)))),
 'RRD_O02_DISPENSE': ('sequence',
                      (('RXD', (1, 1)), ('RXR', (1, -1)), ('RXC', (0, -1)))),
 'RRD_O02_ORDER': ('sequence',
                   (('ORC', (1, 1)), ('RRD_O02_DISPENSE', (0, 1)))),
 'RRD_O02_PATIENT': ('sequence',
                     (('RRD_O02_RESPONSE', (0, 1)),
                      ('RRD_O02_ORDER', (1, -1)))),
 'RRD_O02_RESPONSE': ('sequence', (('PID', (1, 1)), ('NTE', (0, -1)))),
 'RRG_O02_GIVE': ('sequence',
                  (('RXG', (1, 1)), ('RXR', (1, -1)), ('RXC', (0, -1)))),
 'RRG_O02_ORDER': ('sequence', (('ORC', (1, 1)), ('RRG_O02_GIVE', (0, 1)))),
 'RRG_O02_PATIENT': ('sequence', (('PID', (1, 1)), ('NTE', (0, -1)))),
 'RRG_O02_RESPONSE': ('sequence',
                      (('RRG_O02_PATIENT', (0, 1)),
                       ('RRG_O02_ORDER', (1, -1)))),
 'RRI_I12_AUTCTD_SUPPGRP2': ('sequence', (('AUT', (1, 1)), ('CTD', (0, 1)))),
 'RRI_I12_AUTHORIZATION': ('sequence', (('AUT', (1, 1)), ('CTD', (0, 1)))),
 'RRI_I12_OBSERVATION': ('sequence', (('OBX', (1, 1)), ('NTE', (0, -1)))),
 'RRI_I12_PROCEDURE': ('sequence',
                       (('PR1', (1, 1)), ('RRI_I12_AUTCTD_SUPPGRP2', (0, 1)))),
 'RRI_I12_PROVIDER': ('sequence', (('PRD', (1, 1)), ('CTD', (0, -1)))),
 'RRI_I12_RESULTS': ('sequence',
                     (('OBR', (1, 1)),
                      ('NTE', (0, -1)),
                      ('RRI_I12_OBSERVATION', (0, -1)))),
 'RRI_I12_VISIT': ('sequence', (('PV1', (1, 1)), ('PV2', (0, 1)))),
 'RRO_O02_ORDER': ('sequence',
                   (('ORC', (1, 1)), ('RRO_O02_ORDER_DETAIL', (0, 1)))),
 'RRO_O02_ORDER_DETAIL': ('sequence',
                          (('RXO', (1, 1)),
                           ('NTE', (0, -1)),
                           ('RXR', (1, -1)),
                           ('RXC', (0, -1)),
                           ('NTE', (0, -1)))),
 'RRO_O02_PATIENT': ('sequence', (('PID', (1, 1)), ('NTE', (0, -1)))),
 'RRO_O02_RESPONSE': ('sequence',
                      (('RRO_O02_PATIENT', (0, 1)),
                       ('RRO_O02_ORDER', (1, -1)))),
 'SIU_S12_GENERAL_RESOURCE': ('sequence', (('AIG', (1, 1)), ('NTE', (0, -1)))),
 'SIU_S12_LOCATION_RESOURCE': ('sequence',
                               (('AIL', (1, 1)), ('NTE', (0, -1)))),
 'SIU_S12_PATIENT': ('sequence',
                     (('PID', (1, 1)),
                      ('PV1', (0, 1)),
                      ('PV2', (0, 1)),
                      ('OBX', (0, -1)),
                      ('DG1', (0, -1)))),
 'SIU_S12_PERSONNEL_RESOURCE': ('sequence',
                                (('AIP', (1, 1)), ('NTE', (0, -1)))),
 'SIU_S12_RESOURCES': ('sequence',
                       (('RGS', (1, 1)),
                        ('SIU_S12_SERVICE', (0, -1)),
                        ('SIU_S12_GENERAL_RESOURCE', (0, -1)),
                        ('SIU_S12_LOCATION_RESOURCE', (0, -1)),
                        ('SIU_S12_PERSONNEL_RESOURCE', (0, -1)))),
 'SIU_S12_SERVICE': ('sequence', (('AIS', (1, 1)), ('NTE', (0, -1)))),
 'SQM_S25_GENERAL_RESOURCE': ('sequence', (('AIG', (1, 1)), ('APR', (0, 1)))),
 'SQM_S25_LOCATION_RESOURCE': ('sequence', (('AIL', (1, 1)), ('APR', (0, 1)))),
 'SQM_S25_PERSONNEL_RESOURCE': ('sequence',
                                (('AIP', (1, 1)), ('APR', (0, 1)))),
 'SQM_S25_REQUEST': ('sequence',
                     (('ARQ', (1, 1)),
                      ('APR', (0, 1)),
                      ('PID', (0, 1)),
                      ('SQM_S25_RESOURCES', (1, -1)))),
 'SQM_S25_RESOURCES': ('sequence',
                       (('RGS', (1, 1)),
                        ('SQM_S25_SERVICE', (0, -1)),
                        ('SQM_S25_GENERAL_RESOURCE', (0, -1)),
                        ('SQM_S25_PERSONNEL_RESOURCE', (0, -1)),
                        ('SQM_S25_LOCATION_RESOURCE', (0, -1)))),
 'SQM_S25_SERVICE': ('sequence', (('AIS', (1, 1)), ('APR', (0, 1)))),
 'SQR_S25_GENERAL_RESOURCE': ('sequence', (('AIG', (1, 1)), ('NTE', (0, -1)))),
 'SQR_S25_LOCATION_RESOURCE': ('sequence',
                               (('AIL', (1, 1)), ('NTE', (0, -1)))),
 'SQR_S25_PATIENT': ('sequence',
                     (('PID', (1, 1)),
                      ('PV1', (0, 1)),
                      ('PV2', (0, 1)),
                      ('DG1', (0, 1)))),
 'SQR_S25_PERSONNEL_RESOURCE': ('sequence',
                                (('AIP', (1, 1)), ('NTE', (0, -1)))),
 'SQR_S25_RESOURCES': ('sequence',
                       (('RGS', (1, 1)),
                        ('SQR_S25_SERVICE', (0, -1)),
                        ('SQR_S25_GENERAL_RESOURCE', (0, -1)),
                        ('SQR_S25_PERSONNEL_RESOURCE', (0, -1)),
                        ('SQR_S25_LOCATION_RESOURCE', (0, -1)))),
 'SQR_S25_SCHEDULE': ('sequence',
                      (('SCH', (1, 1)),
                       ('NTE', (0, -1)),
                       ('SQR_S25_PATIENT', (0, 1)),
                       ('SQR_S25_RESOURCES', (1, -1)))),
 'SQR_S25_SERVICE': ('sequence', (('AIS', (1, 1)), ('NTE', (0, -1)))),
 'SRM_S01_GENERAL_RESOURCE': ('sequence',
                              (('AIG', (1, 1)),
                               ('APR', (0, 1)),
                               ('NTE', (0, -1)))),
 'SRM_S01_LOCATION_RESOURCE': ('sequence',
                               (('AIL', (1, 1)),
                                ('APR', (0, 1)),
                                ('NTE', (0, -1)))),
 'SRM_S01_PATIENT': ('sequence',
                     (('PID', (1, 1)),
                      ('PV1', (0, 1)),
                      ('PV2', (0, 1)),
                      ('OBX', (0, -1)),
                      ('DG1', (0, -1)))),
 'SRM_S01_PERSONNEL_RESOURCE': ('sequence',
                                (('AIP', (1, 1)),
                                 ('APR', (0, 1)),
                                 ('NTE', (0, -1)))),
 'SRM_S01_RESOURCES': ('sequence',
                       (('RGS', (1, 1)),
                        ('SRM_S01_SERVICE', (0, -1)),
                        ('SRM_S01_GENERAL_RESOURCE', (0, -1)),
                        ('SRM_S01_LOCATION_RESOURCE', (0, -1)),
                        ('SRM_S01_PERSONNEL_RESOURCE', (0, -1)))),
 'SRM_S01_SERVICE': ('sequence',
                     (('AIS', (1, 1)), ('APR', (0, 1)), ('NTE', (0, -1)))),
 'SRR_S01_GENERAL_RESOURCE': ('sequence', (('AIG', (1, 1)), ('NTE', (0, -1)))),
 'SRR_S01_LOCATION_RESOURCE': ('sequence',
                               (('AIL', (1, 1)), ('NTE', (0, -1)))),
 'SRR_S01_PATIENT': ('sequence',
                     (('PID', (1, 1)),
                      ('PV1', (0, 1)),
                      ('PV2', (0, 1)),
                      ('DG1', (0, -1)))),
 'SRR_S01_PERSONNEL_RESOURCE': ('sequence',
                                (('AIP', (1, 1)), ('NTE', (0, -1)))),
 'SRR_S01_RESOURCES': ('sequence',
                       (('RGS', (1, 1)),
                        ('SRR_S01_SERVICE', (0, -1)),
                        ('SRR_S01_GENERAL_RESOURCE', (0, -1)),
                        ('SRR_S01_LOCATION_RESOURCE', (0, -1)),
                        ('SRR_S01_PERSONNEL_RESOURCE', (0, -1)))),
 'SRR_S01_SCHEDULE': ('sequence',
                      (('SCH', (1, 1)),
                       ('NTE', (0, -1)),
                       ('SRR_S01_PATIENT', (0, -1)),
                       ('SRR_S01_RESOURCES', (1, -1)))),
 'SRR_S01_SERVICE': ('sequence', (('AIS', (1, 1)), ('NTE', (0, -1)))),
 'SUR_P09_FACILITY': ('sequence',
                      (('FAC', (1, 1)),
                       ('SUR_P09_PRODUCT', (1, -1)),
                       ('PSH', (1, 1)),
                       ('SUR_P09_FACILITY_DETAIL', (1, -1)))),
 'SUR_P09_FACILITY_DETAIL': ('sequence',
                             (('FAC', (1, 1)),
                              ('PDC', (1, 1)),
                              ('NTE', (1, 1)))),
 'SUR_P09_PRODUCT': ('sequence', (('PSH', (1, 1)), ('PDC', (1, 1)))),
 'VXR_V03_INSURANCE': ('sequence',
                       (('IN1', (1, 1)), ('IN2', (0, 1)), ('IN3', (0, 1)))),
 'VXR_V03_OBSERVATION': ('sequence', (('OBX', (1, 1)), ('NTE', (0, -1)))),
 'VXR_V03_ORDER': ('sequence',
                   (('ORC', (0, 1)),
                    ('RXA', (1, 1)),
                    ('RXR', (0, 1)),
                    ('VXR_V03_OBSERVATION', (0, -1)))),
 'VXR_V03_PATIENT_VISIT': ('sequence', (('PV1', (1, 1)), ('PV2', (0, 1)))),
 'VXU_V04_INSURANCE': ('sequence',
                       (('IN1', (1, 1)), ('IN2', (0, 1)), ('IN3', (0, 1)))),
 'VXU_V04_OBSERVATION': ('sequence', (('OBX', (1, 1)), ('NTE', (0, -1)))),
 'VXU_V04_ORDER': ('sequence',
                   (('ORC', (0, 1)),
                    ('RXA', (1, 1)),
                    ('RXR', (0, 1)),
                    ('VXU_V04_OBSERVATION', (0, -1)))),
 'VXU_V04_PATIENT': ('sequence', (('PV1', (1, 1)), ('PV2', (0, 1)))),
 'VXX_V02_PATIENT': ('sequence', (('PID', (1, 1)), ('NK1', (0, -1))))}
