# -*- coding: utf-8 -*-
#
# Copyright (c) 2012-2015, CRS4
#
# Permission is hereby granted, free of charge, to any person obtaining a copy of
# this software and associated documentation files (the "Software"), to deal in
# the Software without restriction, including without limitation the rights to
# use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
# the Software, and to permit persons to whom the Software is furnished to do so,
# subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
# FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
# COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
# IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
# CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

GROUPS = {'ADR_A19_INSURANCE': ('sequence',
                       (('IN1', (1, 1)), ('IN2', (0, 1)), ('IN3', (0, 1)))),
 'ADR_A19_QUERY_RESPONSE': ('sequence',
                            (('EVN', (0, 1)),
                             ('PID', (1, 1)),
                             ('NK1', (0, -1)),
                             ('PV1', (1, 1)),
                             ('PV2', (0, 1)),
                             ('OBX', (0, -1)),
                             ('AL1', (0, -1)),
                             ('DG1', (0, -1)),
                             ('PR1', (0, -1)),
                             ('GT1', (0, -1)),
                             ('ADR_A19_INSURANCE', (0, -1)),
                             ('ACC', (0, 1)),
                             ('UB1', (0, 1)),
                             ('UB2', (0, 1)))),
 'ADT_A01_INSURANCE': ('sequence',
                       (('IN1', (1, 1)), ('IN2', (0, 1)), ('IN3', (0, 1)))),
 'ADT_A04_INSURANCE': ('sequence',
                       (('IN1', (1, 1)), ('IN2', (0, 1)), ('IN3', (0, 1)))),
 'ADT_A05_INSURANCE': ('sequence',
                       (('IN1', (1, 1)), ('IN2', (0, 1)), ('IN3', (0, 1)))),
 'ADT_A06_INSURANCE': ('sequence',
                       (('IN1', (1, 1)), ('IN2', (0, 1)), ('IN3', (0, 1)))),
 'ADT_A07_INSURANCE': ('sequence',
                       (('IN1', (1, 1)), ('IN2', (0, 1)), ('IN3', (0, 1)))),
 'ADT_A08_INSURANCE': ('sequence',
                       (('IN1', (1, 1)), ('IN2', (0, 1)), ('IN3', (0, 1)))),
 'ADT_A13_INSURANCE': ('sequence',
                       (('IN1', (1, 1)), ('IN2', (0, 1)), ('IN3', (0, 1)))),
 'ADT_A14_INSURANCE': ('sequence',
                       (('IN1', (1, 1)), ('IN2', (0, 1)), ('IN3', (0, 1)))),
 'ADT_A28_INSURANCE': ('sequence',
                       (('IN1', (1, 1)), ('IN2', (0, 1)), ('IN3', (0, 1)))),
 'ADT_A31_INSURANCE': ('sequence',
                       (('IN1', (1, 1)), ('IN2', (0, 1)), ('IN3', (0, 1)))),
 'BAR_P01_INSURANCE': ('sequence',
                       (('IN1', (1, 1)), ('IN2', (0, 1)), ('IN3', (0, 1)))),
 'BAR_P01_VISIT': ('sequence',
                   (('PV1', (0, 1)),
                    ('PV2', (0, 1)),
                    ('OBX', (0, -1)),
                    ('AL1', (0, -1)),
                    ('DG1', (0, -1)),
                    ('PR1', (0, -1)),
                    ('GT1', (0, -1)),
                    ('NK1', (0, -1)),
                    ('BAR_P01_INSURANCE', (0, -1)),
                    ('ACC', (0, 1)),
                    ('UB1', (0, 1)),
                    ('UB2', (0, 1)))),
 'BAR_P02_PATIENT': ('sequence', (('PID', (1, 1)), ('PV1', (0, 1)))),
 'MFN_M01_MF': ('sequence', (('MFE', (1, 1)), ('ANYZSEGMENT', (0, 1)))),
 'MFN_M02_MF_STAFF': ('sequence', (('MFE', (1, 1)), ('ANYZSEGMENT', (0, 1)))),
 'MFN_M03_MF_TEST': ('sequence', (('MFE', (1, 1)), ('ANYZSEGMENT', (0, 1)))),
 'MFR_M01_MF': ('sequence', (('MFE', (1, 1)), ('ANYZSEGMENT', (0, 1)))),
 'MFR_M02_MF_STAFF': ('sequence', (('MFE', (1, 1)), ('ANYZSEGMENT', (0, 1)))),
 'MFR_M03_MF_TEST': ('sequence', (('MFE', (1, 1)), ('ANYZSEGMENT', (0, 1)))),
 'NMD_N01_APP_STATS': ('sequence', (('NST', (1, 1)), ('NTE', (0, -1)))),
 'NMD_N01_APP_STATUS': ('sequence', (('NSC', (1, 1)), ('NTE', (0, -1)))),
 'NMD_N01_CLOCK': ('sequence', (('NCK', (1, 1)), ('NTE', (0, -1)))),
 'NMD_N01_CLOCK_AND_STATS_WITH_NOTES': ('sequence',
                                        (('NMD_N01_CLOCK', (0, 1)),
                                         ('NMD_N01_APP_STATS', (0, 1)),
                                         ('NMD_N01_APP_STATUS', (0, 1)))),
 'NMQ_N02_CLOCK_AND_STATISTICS': ('sequence',
                                  (('NCK', (0, 1)),
                                   ('NST', (0, 1)),
                                   ('NSC', (0, 1)))),
 'NMQ_N02_QRY_WITH_DETAIL': ('sequence', (('QRD', (1, 1)), ('QRF', (0, 1)))),
 'NMR_N02_CLOCK_AND_STATS_WITH_NOTES_ALT': ('sequence',
                                            (('NCK', (0, 1)),
                                             ('NTE', (0, -1)),
                                             ('NST', (0, 1)),
                                             ('NTE', (0, -1)),
                                             ('NSC', (0, 1)),
                                             ('NTE', (0, -1)))),
 'ORF_R04_OBSERVATION': ('sequence', (('OBX', (0, 1)), ('NTE', (0, -1)))),
 'ORF_R04_ORDER': ('sequence',
                   (('ORC', (0, 1)),
                    ('OBR', (1, 1)),
                    ('NTE', (0, -1)),
                    ('ORF_R04_OBSERVATION', (1, -1)))),
 'ORF_R04_QUERY_RESPONSE': ('sequence',
                            (('QRD', (1, 1)),
                             ('QRF', (0, 1)),
                             ('PID', (0, 1)),
                             ('NTE', (0, -1)))),
 'ORM_O01_CHOICE': ('choice',
                    (('OBR', (1, 1)),
                     ('RQD', (1, 1)),
                     ('RQ1', (1, 1)),
                     ('RXO', (1, 1)),
                     ('ODS', (1, 1)),
                     ('ODT', (1, 1)))),
 'ORM_O01_ORDER': ('sequence',
                   (('ORC', (1, 1)),
                    ('ORM_O01_ORDER_DETAIL', (0, 1)),
                    ('BLG', (0, 1)))),
 'ORM_O01_ORDER_DETAIL': ('sequence',
                          (('ORM_O01_CHOICE', (1, 1)),
                           ('NTE', (0, -1)),
                           ('OBX', (0, -1)),
                           ('NTE', (1, -1)))),
 'ORM_O01_PATIENT': ('sequence',
                     (('PID', (1, 1)), ('NTE', (0, -1)), ('PV1', (0, 1)))),
 'ORR_O02_CHOICE': ('choice',
                    (('OBR', (1, 1)),
                     ('RQD', (1, 1)),
                     ('RQ1', (1, 1)),
                     ('RXO', (1, 1)),
                     ('ODS', (1, 1)),
                     ('ODT', (1, 1)))),
 'ORR_O02_ORDER': ('sequence',
                   (('ORC', (1, 1)),
                    ('ORR_O02_ORDER_DETAIL', (0, 1)),
                    ('NTE', (0, -1)))),
 'ORR_O02_ORDER_DETAIL': ('sequence', (('ORR_O02_CHOICE', (1, 1)),)),
 'ORR_O02_PATIENT': ('sequence',
                     (('PID', (0, 1)),
                      ('NTE', (0, -1)),
                      ('ORR_O02_ORDER', (1, -1)))),
 'ORU_R01_OBSERVATION': ('sequence', (('OBX', (0, 1)), ('NTE', (0, -1)))),
 'ORU_R01_ORDER_OBSERVATION': ('sequence',
                               (('ORC', (0, 1)),
                                ('OBR', (1, 1)),
                                ('NTE', (0, -1)),
                                ('ORU_R01_OBSERVATION', (1, -1)))),
 'ORU_R01_PATIENT': ('sequence',
                     (('PID', (1, 1)), ('NTE', (0, -1)), ('PV1', (0, 1)))),
 'ORU_R01_PATIENT_RESULT': ('sequence',
                            (('ORU_R01_PATIENT', (0, 1)),
                             ('ORU_R01_ORDER_OBSERVATION', (1, -1))))}
