# -*- coding: utf-8 -*-
#
# Copyright (c) 2012-2015, CRS4
#
# Permission is hereby granted, free of charge, to any person obtaining a copy of
# this software and associated documentation files (the "Software"), to deal in
# the Software without restriction, including without limitation the rights to
# use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
# the Software, and to permit persons to whom the Software is furnished to do so,
# subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
# FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
# COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
# IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
# CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

TABLES = {'HL70001': ('Sex',
             (('F', 'Female'),
              ('M', 'Male'),
              ('O', 'Other'),
              ('U', 'Unknown'))),
 'HL70002': ('Marital status',
             (('A', 'Separated'),
              ('D', 'Divorced'),
              ('M', 'Married'),
              ('S', 'Single'),
              ('W', 'Widowed'))),
 'HL70003': ('Event type',
             (('A01', 'ADT/ACK - Admit/visit notification'),
              ('A02', 'ADT/ACK - Transfer a patient'),
              ('A03', 'ADT/ACK -  Discharge/end visit'),
              ('A04', 'ADT/ACK -  Register a patient'),
              ('A05', 'ADT/ACK -  Pre-admit a patient'),
              ('A06', 'ADT/ACK -  Change an outpatient to an inpatient'),
              ('A07', 'ADT/ACK -  Change an inpatient to an outpatient'),
              ('A08', 'ADT/ACK -  Update patient information'),
              ('A09', 'ADT/ACK -  Patient departing - tracking'),
              ('A10', 'ADT/ACK -  Patient arriving - tracking'),
              ('A11', 'ADT/ACK -  Cancel admit/visit notification'),
              ('A12', 'ADT/ACK -  Cancel transfer'),
              ('A13', 'ADT/ACK -  Cancel discharge/end visit'),
              ('A14', 'ADT/ACK -  Pending admit'),
              ('A15', 'ADT/ACK -  Pending transfer'),
              ('A16', 'ADT/ACK -  Pending discharge'),
              ('A17', 'ADT/ACK -  Swap patients'),
              ('A18', 'ADT/ACK -  Merge patient information'),
              ('A19', 'QRY/ADR -  Patient query'),
              ('A20', 'ADT/ACK -  Bed status update'),
              ('A21', "ADT/ACK -  Patient goes on a 'leave of absence'"),
              ('A22',
               "ADT/ACK -  Patient returns from a 'leave of absence'"),
              ('A23', 'ADT/ACK -  Delete a patient record'),
              ('A24', 'ADT/ACK -  Link patient information'),
              ('A25', 'ADT/ACK -  Cancel pending discharge'),
              ('A26', 'ADT/ACK -  Cancel pending transfer'),
              ('A27', 'ADT/ACK -  Cancel pending admit'),
              ('A28', 'ADT/ACK -  Add person information'),
              ('A29', 'ADT/ACK -  Delete person information'),
              ('A30', 'ADT/ACK -  Merge person information'),
              ('A31', 'ADT/ACK -  Update person information'),
              ('A32', 'ADT/ACK -  Cancel patient arriving - tracking'),
              ('A33', 'ADT/ACK -  Cancel patient departing - tracking'),
              ('A34',
               'ADT/ACK -  Merge patient information - patient ID only'),
              ('A35',
               'ADT/ACK -  Merge patient information - account number only'),
              ('A36',
               'ADT/ACK -  Merge patient information - patient ID and account number'),
              ('A37', 'ADT/ACK -  Unlink patient information'),
              ('A38', 'ADT/ACK - Cancel pre-admit'),
              ('A39', 'ADT/ACK - Merge person and patient ID'),
              ('A40', 'ADT/ACK - Merge patient and patient identifier list'),
              ('A41', 'ADT/ACK - Merge account - patient account number'),
              ('A42', 'ADT/ACK - Merge visit - visit number'),
              ('A43',
               'ADT/ACK - Move patient information and patient identifier list'),
              ('A44',
               'ADT/ACK - Move account information - patient account number'),
              ('A45', 'ADT/ACK - Move visit information - visit number'),
              ('A46', 'ADT/ACK - Change patient ID'),
              ('A47', 'ADT/ACK - Change patient identifier list'),
              ('A48', 'ADT/ACK - Change alternate patient ID'),
              ('A49', 'ADT/ACK - Change patient account number'),
              ('A50', 'ADT/ACK - Change visit number'),
              ('A51', 'ADT/ACK - Change alternate visit ID'),
              ('C01', 'CRM - Register a patient on a clinical trial'),
              ('C02',
               'CRM - Cancel a patient registration on clinical trial (for clerical mistakes only)'),
              ('C03', 'CRM - Correct/update registration information'),
              ('C04', 'CRM - Patient has gone off a clinical trial'),
              ('C05', 'CRM - Patient enters phase of clinical trial'),
              ('C06',
               'CRM - Cancel patient entering a phase (clerical mistake)'),
              ('C07', 'CRM - Correct/update phase information'),
              ('C08', 'CRM - Patient has gone off phase of clinical trial'),
              ('C09',
               'CSU - Automated time intervals for reporting, like monthly'),
              ('C10', 'CSU - Patient completes the clinical trial'),
              ('C11',
               'CSU - Patient completes a phase of the clinical trial'),
              ('C12',
               'CSU - Update/correction of patient order/result information'),
              ('CNQ', 'QRY/EQQ/SPQ/VQQ/RQQ - Cancel query'),
              ('I01', 'RQI/RPI - Request for insurance information'),
              ('I02',
               'RQI/RPL - Request/receipt of patient selection display list'),
              ('I03', 'RQI/RPR - Request/receipt of patient selection list'),
              ('I04', 'RQD/RPI - Request for patient demographic data'),
              ('I05', 'RQC/RCI - Request for patient clinical information'),
              ('I06', 'RQC/RCL - Request/receipt of clinical data listing'),
              ('I07', 'PIN/ACK - Unsolicited insurance information'),
              ('I08',
               'RQA/RPA - Request for treatment authorization information'),
              ('I09',
               'RQA/RPA - Request for modification to an authorization'),
              ('I10',
               'RQA/RPA - Request for resubmission of an authorization'),
              ('I11',
               'RQA/RPA - Request for cancellation of an authorization'),
              ('I12', 'REF/RRI -  Patient referral'),
              ('I13', 'REF/RRI - Modify patient referral'),
              ('I14', 'REF/RRI - Cancel patient referral'),
              ('I15', 'REF/RRI - Request patient referral status'),
              ('M01',
               'MFN/MFK - Master file not otherwise specified (for backward compatibility only)'),
              ('M02', 'MFN/MFK - Master file and staff practitioner'),
              ('M03',
               'MFN/MFK - Master file - test/observation (for backward compatibility only)'),
              ('M04', 'MFN/MFK - Master files charge description'),
              ('M05', 'MFN/MFK - Patient location master file'),
              ('M06',
               'MFN/MFK - Clinical study with phases and schedules master file'),
              ('M07',
               'MFN/MFK - Clinical study without phases but with schedules master file'),
              ('M08', 'MFN/MFK - Test/observation (numeric) master file'),
              ('M09',
               'MFN/MFK - Test/observation (categorical) master file'),
              ('M10', 'MFN/MFK - Test /observation batteries master file'),
              ('M11', 'MFN/MFK - Test/calculated observations master file'),
              ('O01', 'ORM - Order message (also RDE, RDS, RGV, RAS)'),
              ('O02', 'ORR - Order response (also RRE, RRD, RRG, RRA)'),
              ('P01', 'BAR/ACK - Add patient accounts'),
              ('P02', 'BAR/ACK - Purge patient accounts'),
              ('P03', 'DFT/ACK - Post detail financial transaction'),
              ('P04', 'QRY/DSP - Generate bill and A/R statements'),
              ('P05', 'BAR/ACK - Update account'),
              ('P06', 'BAR/ACK - End account'),
              ('P07',
               'PEX - Unsolicited initial individual product experience report'),
              ('P08',
               'PEX - Unsolicited update individual product experience report'),
              ('P09', 'SUR - Summary product experience report'),
              ('PC1', 'PPR - PC/ Problem Add'),
              ('PC2', 'PPR - PC/ Problem Update'),
              ('PC3', 'PPR - PC/ Problem Delete'),
              ('PC4', 'QRY - PC/ Problem Query'),
              ('PC5', 'PRR - PC/ Problem Response'),
              ('PC6', 'PGL - PC/ Goal Add'),
              ('PC7', 'PGL - PC/ Goal Update'),
              ('PC8', 'PGL - PC/ Goal Delete'),
              ('PC9', 'QRY - PC/ Goal Query'),
              ('PCA', 'PPV - PC/ Goal Response'),
              ('PCB', 'PPP - PC/ Pathway (Problem-Oriented) Add'),
              ('PCC', 'PPP - PC/ Pathway (Problem-Oriented) Update'),
              ('PCD', 'PPP - PC/ Pathway (Problem-Oriented) Delete'),
              ('PCE', 'QRY - PC/ Pathway (Problem-Oriented) Query'),
              ('PCF', 'PTR - PC/ Pathway (Problem-Oriented) Query Response'),
              ('PCG', 'PPG - PC/ Pathway (Goal-Oriented) Add'),
              ('PCH', 'PPG - PC/ Pathway (Goal-Oriented) Update'),
              ('PCJ', 'PPG - PC/ Pathway (Goal-Oriented) Delete'),
              ('PCK', 'QRY - PC/ Pathway (Goal-Oriented) Query'),
              ('PCL', 'PPT - PC/ Pathway (Goal-Oriented) Query Response'),
              ('Q01', 'QRY/DSR - Query sent for immediate response'),
              ('Q02', 'QRY/QCK - Query sent for deferred response'),
              ('Q03', 'DSR/ACK - Deferred response to a query'),
              ('Q04', 'EQQ - Embedded query language query'),
              ('Q05', 'UDM/ACK - Unsolicited display update message'),
              ('Q06', 'OSQ/OSR - Query for order status'),
              ('Q07', 'VQQ - Virtual table query'),
              ('Q08', 'SPQ - Stored procedure request'),
              ('Q09', 'RQQ - event replay query'),
              ('R01',
               'ORU/ACK - Unsolicited transmission of an observation message'),
              ('R02', 'QRY - Query for results of observation'),
              ('R03',
               'QRY/DSR Display-oriented results, query/unsol. update (for backward compatibility only)'),
              ('R04',
               'ORF - Response to query; transmission of requested observation'),
              ('R05', 'QRY/DSR - query for display results'),
              ('R06', 'UDM - unsolicited update/display results'),
              ('R07', 'EDR - enhanced display response'),
              ('R08', 'TBR - tabular data response'),
              ('R09', 'ERP - event replay response'),
              ('R0R', 'R0R - Pharmacy prescription order query response'),
              ('RAR',
               'RAR - Pharmacy administration information query response'),
              ('RDR', 'RDR - Pharmacy dispense information query response'),
              ('RER',
               'RER - Pharmacy encoded order information query response'),
              ('RGR', 'RGR - Pharmacy dose information query response'),
              ('S01', 'SRM/SRR - Request new appointment booking'),
              ('S02', 'SRM/SRR - Request appointment rescheduling'),
              ('S03', 'SRM/SRR - Request appointment modification'),
              ('S04', 'SRM/SRR - Request appointment cancellation'),
              ('S05', 'SRM/SRR - Request appointment discontinuation'),
              ('S06', 'SRM/SRR - Request appointment deletion'),
              ('S07',
               'SRM/SRR - Request addition of service/resource on appointment'),
              ('S08',
               'SRM/SRR - Request modification of service/resource on appointment'),
              ('S09',
               'SRM/SRR - Request cancellation of service/resource on appointment'),
              ('S10',
               'SRM/SRR - Request discontinuation of service/resource on appointment'),
              ('S11',
               'SRM/SRR - Request deletion of service/resource on appointment'),
              ('S12', 'SIU/ACK - Notification of new appointment booking'),
              ('S13', 'SIU/ACK - Notification of appointment rescheduling'),
              ('S14', 'SIU/ACK - Notification of appointment modification'),
              ('S15', 'SIU/ACK - Notification of appointment cancellation'),
              ('S16',
               'SIU/ACK - Notification of appointment discontinuation'),
              ('S17', 'SIU/ACK - Notification of appointment deletion'),
              ('S18',
               'SIU/ACK - Notification of addition of service/resource on appointment'),
              ('S19',
               'SIU/ACK - Notification of modification of service/resource on appointment'),
              ('S20',
               'SIU/ACK - Notification of cancellation of service/resource on appointment'),
              ('S21',
               'SIU/ACK - Notification of discontinuation of service/resource on appointment'),
              ('S22',
               'SIU/ACK - Notification of deletion of service/resource on appointment'),
              ('S23',
               'SIU/ACK - Notification of blocked schedule time slot(s)'),
              ('S24',
               "SIU/ACK - Notification of opened ('unblocked') schedule time slot(s)"),
              ('S25', 'SQM/SQR - Schedule query message and response'),
              ('S26',
               'SIU/ACK Notification that patient did not show up for schedule appointment'),
              ('T01', 'MDM/ACK - Original document notification'),
              ('T02',
               'MDM/ACK - Original document notification and content'),
              ('T03', 'MDM/ACK - Document status change notification'),
              ('T04',
               'MDM/ACK - Document status change notification and content'),
              ('T05', 'MDM/ACK - Document addendum notification'),
              ('T06',
               'MDM/ACK - Document addendum notification and content'),
              ('T07', 'MDM/ACK - Document edit notification'),
              ('T08', 'MDM/ACK - Document edit notification and content'),
              ('T09', 'MDM/ACK - Document replacement notification'),
              ('T10',
               'MDM/ACK - Document replacement notification and content'),
              ('T11', 'MDM/ACK - Document cancel notification'),
              ('T12', 'QRY/DOC - Document query'),
              ('V01', 'VXQ - Query for vaccination record'),
              ('V02',
               'VXX - Response to vaccination query returning multiple PID matches'),
              ('V03', 'VXR - Vaccination record response'),
              ('V04', 'VXU - Unsolicited vaccination record update'),
              ('varies',
               'MFQ/MFR - Master files query (use event same as asking for e.g., M05 - location)'),
              ('W01',
               'ORU - Waveform result, unsolicited transmission of requested information'),
              ('W02', 'QRF - Waveform result, response to query'))),
 'HL70004': ('Patient class',
             (('B', 'Obstetrics'),
              ('E', 'Emergency'),
              ('I', 'Inpatient'),
              ('O', 'Outpatient'),
              ('P', 'Preadmit'),
              ('R', 'Recurring patient'))),
 'HL70007': ('Admission type',
             (('A', 'Accident'),
              ('E', 'Emergency'),
              ('L', 'Labor and Delivery'),
              ('R', 'Routine'))),
 'HL70008': ('Acknowledgment code',
             (('AA',
               'Original mode: Application Accept - Enhanced mode: Application acknowledgment: Accept'),
              ('AE',
               'Original mode: Application Error - Enhanced mode: Application acknowledgment: Error'),
              ('AR',
               'Original mode: Application Reject - Enhanced mode: Application acknowledgment: Reject'),
              ('CA', 'Enhanced mode: Accept acknowledgment: Commit Accept'),
              ('CE', 'Enhanced mode: Accept acknowledgment: Commit Error'),
              ('CR', 'Enhanced mode: Accept acknowledgment: Commit Reject'))),
 'HL70009': ('Ambulatory status',
             (('A0', 'No functional limitations'),
              ('A1', 'Ambulates with assistive device'),
              ('A2', 'Wheelchair/stretcher bound'),
              ('A3', 'Comatose; non-responsive'),
              ('A4', 'Disoriented'),
              ('A5', 'Vision impaired'),
              ('A6', 'Hearing impaired'),
              ('A7', 'Speech impaired'),
              ('A8', 'Non-English speaking'),
              ('A9', 'Functional level unknown'),
              ('B1', 'Oxygen therapy'),
              ('B2', 'Special equipment (tubes, IVs, catheters)'),
              ('B3', 'Amputee'),
              ('B4', 'Mastectomy'),
              ('B5', 'Paraplegic'),
              ('B6', 'Pregnant'))),
 'HL70017': ('Transaction Type',
             (('AJ', 'Adjustment'),
              ('CD', 'Credit'),
              ('CG', 'Charge'),
              ('PY', 'Payment'))),
 'HL70023': ('Admit source',
             (('1', 'Physician referral'),
              ('2', 'Clinic referral'),
              ('3', 'HMO referral'),
              ('4', 'Transfer from a hospital'),
              ('5', 'Transfer from a skilled nursing facility'),
              ('6', 'Transfer from another health care facility'),
              ('7', 'Emergency room'),
              ('8', 'Court/law enforcement'),
              ('9', 'Information not available'))),
 'HL70027': ('Priority',
             (('A', 'As soon as possible (a priority lower than stat)'),
              ('P', 'Preoperative (to be done prior to surgery)'),
              ('R', 'Routine'),
              ('S', 'Stat (do immediately)'),
              ('T',
               'Timing critical (do as near as possible to requested time)'))),
 'HL70038': ('Order status',
             (('A', 'Some, but not all, results available'),
              ('CA', 'Order was canceled'),
              ('CM', 'Order is completed'),
              ('DC', 'Order was discontinued'),
              ('ER', 'Error, order not found'),
              ('HD', 'Order is on hold'),
              ('IP', 'In process, unspecified'),
              ('RP', 'Order has been replaced'),
              ('SC', 'In process, scheduled'))),
 'HL70043': ('Condition code',
             (('01', 'Military service related'),
              ('02', 'Condition is employment related'),
              ('03', 'Patient covered by insurance not reflected here'),
              ('04', 'HMO enrollee'),
              ('05', 'Lien has been filed'),
              ('06',
               'ESRD patient in first 18 months of entitlement covered by employer group health insurance'),
              ('07',
               'Treatment of non-terminal condition for hospice patient'),
              ('08',
               'Beneficiary would not provide information concerning other insurance coverage'),
              ('09', 'Neither patient nor spouse is employed'),
              ('10', 'Patient and/or spouse is employed but no EGHP exists'),
              ('11', 'Disabled beneficiary but no LGHP'),
              ('12 ... 16', 'Payer codes.'),
              ('18', 'Maiden name retained'),
              ('19', "Child retains mother's name"),
              ('20', 'Beneficiary requested billing'),
              ('21', 'Billing for Denial Notice'),
              ('26',
               'VA eligible patient chooses to receive services in a medicare certified facility'),
              ('27',
               'Patient referred to a sole community hospital for a diagnostic laboratory test'),
              ('28',
               "Patient and/or spouse's EGHP is secondary to Medicare"),
              ('29',
               "Disabled beneficiary and/or family member's LGHP is secondary to Medicare"),
              ('31', 'Patient is student (full time-day)'),
              ('32', 'Patient is student (cooperative/work study program)'),
              ('33', 'Patient is student (full time-night)'),
              ('34', 'Patient is student (Part time)'),
              ('36', 'General care patient in a special unit'),
              ('37', 'Ward accommodation as patient request'),
              ('38', 'Semi-private room not available'),
              ('39', 'Private room medically necessary'),
              ('40', 'Same day transfer'),
              ('41', 'Partial hospitalization'),
              ('46', 'Non-availability statement on file'),
              ('48',
               'Psychiatric residential treatment centers for children and adolescents'),
              ('55', 'SNF bed not available'),
              ('56', 'Medical appropriateness'),
              ('57', 'SNF readmission'),
              ('60', 'Day outlier'),
              ('61', 'Cost outlier'),
              ('62', 'Payer code'),
              ('66', 'Provider does not wish cost outlier payment'),
              ('67',
               'Beneficiary elects not to use life time reserve (LTR) days'),
              ('68',
               'Beneficiary elects to use life time reserve (LTR) days'),
              ('70', 'Self-administered EPO'),
              ('71', 'Full care in unit'),
              ('72', 'Self-care in unit'),
              ('73', 'Self-care training'),
              ('74', 'Home'),
              ('75', 'Home - 100% reimbursement'),
              ('76', 'Back-up in facility dialysis'),
              ('77',
               'Provider accepts or is obligated/required due to a contractual arrangement or law to accept payment by a primary payer as payment in full'),
              ('78', 'New coverage not implemented by HMO'),
              ('79', 'Corf services provided off-site'),
              ('80', 'Pregnant'))),
 'HL70048': ('What subject filter',
             (('ADV', 'Advice/diagnosis'),
              ('ANU',
               'Nursing unit lookup (returns patients in beds, excluding empty beds)'),
              ('APA', 'Account number query, return matching visit'),
              ('APM',
               'Medical record number query, returns visits for a medical record number'),
              ('APN', 'Patient name lookup'),
              ('APP', 'Physician lookup'),
              ('ARN',
               'Nursing unit lookup (returns patients in beds, including empty beds)'),
              ('CAN', 'Cancel.  Used to cancel a query'),
              ('DEM', 'Demographics'),
              ('FIN', 'Financial'),
              ('GOL', 'Goals'),
              ('MRI', 'Most recent inpatient'),
              ('MRO', 'Most recent outpatient'),
              ('NCK', 'Network clock'),
              ('NSC', 'Network status change'),
              ('NST', 'Network statistic'),
              ('ORD', 'Order'),
              ('OTH', 'Other'),
              ('PRB', 'Problems'),
              ('PRO', 'Procedure'),
              ('RAR', 'Pharmacy administration information'),
              ('RDR', 'Pharmacy dispense information'),
              ('RER', 'Pharmacy encoded order information'),
              ('RES', 'Result'),
              ('RGR', 'Pharmacy give information'),
              ('ROR', 'Pharmacy prescription information'),
              ('SAL',
               'All schedule related information, including open slots, booked slots, blocked slots'),
              ('SBK', 'Booked slots on the identified schedule'),
              ('SBL', 'Blocked slots on the identified schedule'),
              ('SOP', 'Open slots on the identified schedule'),
              ('SSA', 'Time slots available for a single appointment'),
              ('SSR', 'Time slots available for a recurring appointment'),
              ('STA', 'Status'),
              ('VXI', 'Vaccine Information'))),
 'HL70052': ('Diagnosis Type',
             (('A', 'Admitting'), ('F', 'Final'), ('W', 'Working'))),
 'HL70061': ('Check digit scheme',
             (('ISO', 'ISO 7064: 1983'),
              ('M10', 'Mod 10 algorithm'),
              ('M11', 'Mod 11 algorithm'),
              ('NPI',
               'Check digit algorithm in the US National Provider Identifier'))),
 'HL70062': ('Event reason',
             (('01', 'Patient request'),
              ('02', 'Physician order'),
              ('03', 'Census management'))),
 'HL70065': ('Specimen action code',
             (('A', 'Add ordered tests to the existing specimen'),
              ('G', 'Generated order; reflex order'),
              ('L', 'Lab to obtain specimen from patient'),
              ('O', 'Specimen obtained by service other than Lab'),
              ('P', 'Pending specimen; Order sent prior to delivery'),
              ('R', 'Revised order'),
              ('S', 'Schedule the tests specified below'))),
 'HL70070': ('Specimen source codes',
             (('ABS', 'Abscess'),
              ('AMN', 'Amniotic fluid'),
              ('ASP', 'Aspirate'),
              ('BBL', 'Blood bag'),
              ('BDY', 'Whole body'),
              ('BIFL', 'Bile fluid'),
              ('BLD', 'Whole blood'),
              ('BLDA', 'Blood  arterial'),
              ('BLDC', 'Blood  capillary'),
              ('BLDV', 'Blood  venous'),
              ('BON', 'Bone'),
              ('BPH', 'Basophils'),
              ('BPU', 'Blood product unit'),
              ('BRN', 'Burn'),
              ('BRO', 'Bronchial'),
              ('BRTH', 'Breath (use EXHLD)'),
              ('CALC', 'Calculus (=Stone)'),
              ('CBLD', 'Cord blood'),
              ('CDM', 'Cardiac muscle'),
              ('CNJT', 'Conjunctiva'),
              ('CNL', 'Cannula'),
              ('COL', 'Colostrum'),
              ('CSF', 'Cerebral spinal fluid'),
              ('CTP', 'Catheter tip'),
              ('CUR', 'Curettage'),
              ('CVM', 'Cervical mucus'),
              ('CVX', 'Cervix'),
              ('CYST', 'Cyst'),
              ('DIAF', 'Dialysis fluid'),
              ('DOSE', 'Dose med or substance'),
              ('DRN', 'Drain'),
              ('DUFL', 'Duodenal fluid'),
              ('EAR', 'Ear'),
              ('EARW', 'Ear wax (cerumen)'),
              ('ELT', 'Electrode'),
              ('ENDC', 'Endocardium'),
              ('ENDM', 'Endometrium'),
              ('EOS', 'Eosinophils'),
              ('EXHLD', 'Exhaled gas (=breath)'),
              ('EYE', 'Eye'),
              ('FIB', 'Fibroblasts'),
              ('FIST', 'Fistula'),
              ('FLT', 'Filter'),
              ('FLU', 'Body fluid, unsp'),
              ('GAS', 'Gas'),
              ('GAST', 'Gastric fluid/contents'),
              ('GEN', 'Genital'),
              ('GENC', 'Genital cervix'),
              ('GENL', 'Genital lochia'),
              ('GENV', 'Genital vaginal'),
              ('HAR', 'Hair'),
              ('IHG', 'Inhaled Gas'),
              ('ISLT', 'Isolate'),
              ('IT', 'Intubation tube'),
              ('LAM', 'Lamella'),
              ('LIQ', 'Liquid NOS'),
              ('LN', 'Line'),
              ('LNA', 'Line arterial'),
              ('LNV', 'Line venous'),
              ('LYM', 'Lymphocytes'),
              ('MAC', 'Macrophages'),
              ('MAR', 'Marrow'),
              ('MBLD', 'Menstrual blood'),
              ('MEC', 'Meconium'),
              ('MILK', 'Breast milk'),
              ('MLK', 'Milk'),
              ('NAIL', 'Nail'),
              ('NOS', 'Nose (nasal passage)'),
              ('ORH', 'Other'),
              ('PAFL', 'Pancreatic fluid'),
              ('PAT', 'Patient'),
              ('PLAS', 'Plasma'),
              ('PLB', 'Plasma bag'),
              ('PLC', 'Placenta'),
              ('PLR', 'Pleural fluid (thoracentesis fld)'),
              ('PMN', 'Polymorphonuclear neutrophils'),
              ('PPP', 'Patelet poor plasma'),
              ('PRP', 'Platelet rich plasma'),
              ('PRT', 'Peritoneal fluid /ascites'),
              ('PUS', 'Pus'),
              ('RBC', 'Erythrocytes'),
              ('RT', 'Route of medicine'),
              ('SAL', 'Saliva'),
              ('SEM', 'Seminal fluid'),
              ('SER', 'Serum'),
              ('SKM', 'Skeletal muscle'),
              ('SKN', 'Skin'),
              ('SNV', 'Synovial fluid (Joint fluid)'),
              ('SPRM', 'Spermatozoa'),
              ('SPT', 'Sputum'),
              ('SPTC', 'Sputum - coughed'),
              ('SPTT', 'Sputum - tracheal aspirate'),
              ('STL', 'Stool = Fecal'),
              ('STON', 'Stone (use CALC)'),
              ('SWT', 'Sweat'),
              ('TEAR', 'Tears'),
              ('THRB', 'Thrombocyte (platelet)'),
              ('THRT', 'Throat'),
              ('TISG', 'Tissue gall bladder'),
              ('TISPL', 'Tissue placenta'),
              ('TISS', 'Tissue'),
              ('TISU', 'Tissue ulcer'),
              ('TLGI', 'Tissue large intestine'),
              ('TLNG', 'Tissue lung'),
              ('TSMI', 'Tissue small intestine'),
              ('TUB', 'Tube NOS'),
              ('ULC', 'Ulcer'),
              ('UMB', 'Umbilical blood'),
              ('UMED', 'Unknown medicine'),
              ('UR', 'Urine'),
              ('URC', 'Urine clean catch'),
              ('URNS', 'Urine sediment'),
              ('URT', 'Urine catheter'),
              ('URTH', 'Urethra'),
              ('USUB', 'Unknown substance'),
              ('VOM', 'Vomitus'),
              ('WAT', 'Water'),
              ('WBC', 'Leukocytes'),
              ('WICK', 'Wick'),
              ('WND', 'Wound'),
              ('WNDA', 'Wound abscess'),
              ('WNDD', 'Wound drainage'),
              ('WNDE', 'Wound exudate'),
              ('XXX',
               'To be specified in another part of the 422.3.10070message'))),
 'HL70074': ('Diagnostic service section ID',
             (('AU', 'Audiology'),
              ('BG', 'Blood Gases'),
              ('BLB', 'Blood Bank'),
              ('CH', 'Chemistry'),
              ('CP', 'Cytopathology'),
              ('CT', 'CAT Scan'),
              ('CTH', 'Cardiac Catheterization'),
              ('CUS', 'Cardiac Ultrasound'),
              ('EC', 'Electrocardiac (e.g., EKG,  EEC, Holter)'),
              ('EN', 'Electroneuro (EEG, EMG,EP,PSG)'),
              ('HM', 'Hematology'),
              ('ICU', 'Bedside ICU Monitoring'),
              ('IMM', 'Immunology'),
              ('LAB', 'Laboratory'),
              ('MB', 'Microbiology'),
              ('MCB', 'Mycobacteriology'),
              ('MYC', 'Mycology'),
              ('NMR', 'Nuclear Magnetic Resonance'),
              ('NMS', 'Nuclear Medicine Scan'),
              ('NRS', 'Nursing Service Measures'),
              ('OSL', 'Outside Lab'),
              ('OT', 'Occupational Therapy'),
              ('OTH', 'Other'),
              ('OUS', 'OB Ultrasound'),
              ('PF', 'Pulmonary Function'),
              ('PHR', 'Pharmacy'),
              ('PHY', 'Physician (Hx. Dx, admission note, etc.l)'),
              ('PT', 'Physical Therapy'),
              ('RAD', 'Radiology'),
              ('RC', 'Respiratory Care (therapy)'),
              ('RT', 'Radiation Therapy'),
              ('RUS', 'Radiology Ultrasound'),
              ('RX', 'Radiograph'),
              ('SP', 'Surgical Pathology'),
              ('SR', 'Serology'),
              ('TX', 'Toxicology'),
              ('VR', 'Virology'),
              ('VUS', 'Vascular Ultrasound'),
              ('XRC', 'Cineradiograph'))),
 'HL70076': ('Message type',
             (('ACK', 'General acknowledgment message'),
              ('ADR', 'ADT response'),
              ('ADT', 'ADT message'),
              ('ARD',
               'Ancillary RPT (display) (for backward compatibility only)'),
              ('BAR', 'Add/change billing account'),
              ('CRM', 'Clinical study registration'),
              ('CSU', 'Unsolicited clinical study data'),
              ('DFT', 'Detail financial transaction'),
              ('DOC', 'Document query'),
              ('DSR', 'Display response'),
              ('EDR', 'Enhanced display response'),
              ('EQQ', 'Embedded query language query'),
              ('ERP', 'Event replay response'),
              ('MCF', 'Delayed acknowledgment'),
              ('MDM', 'Documentation message'),
              ('MFD', 'Master files delayed application acknowledgment'),
              ('MFK', 'Master files application acknowledgment'),
              ('MFN', 'Master files notification'),
              ('MFQ', 'Master files query'),
              ('MFR', 'Master files query response'),
              ('NMD', 'Network management data'),
              ('NMQ', 'Network management query'),
              ('NMR', 'Network management response'),
              ('ORF', 'Observ. result/record response'),
              ('ORM', 'Order message'),
              ('ORR', 'Order acknowledgment message'),
              ('ORU', 'Observ result/unsolicited'),
              ('OSQ', 'Order status query'),
              ('OSR', 'Order status response'),
              ('PEX', 'Product experience'),
              ('PGL', 'Patient goal'),
              ('PIN', 'Patient insurance information'),
              ('PPG', 'Patient pathway (goal-oriented) message'),
              ('PPP', 'Patient pathway (problem-oriented) message'),
              ('PPR', 'Patient problem'),
              ('PPT', 'Patient pathway (goal oriented) response'),
              ('PPV', 'Patient goal response'),
              ('PRR', 'Patient problem response'),
              ('PTR', 'Patient pathway (problem-oriented) response'),
              ('QCK', 'Query general acknowledgment'),
              ('QRY', 'Query, original mode'),
              ('RAR', 'Pharmacy administration information'),
              ('RAS', 'Pharmacy administration message'),
              ('RCI', 'Return clinical information'),
              ('RCL', 'Return clinical list'),
              ('RDE', 'Pharmacy encoded order message'),
              ('RDR', 'Pharmacy dispense information'),
              ('RDS', 'Pharmacy dispense message'),
              ('REF', 'Patient referral'),
              ('RER', 'Pharmacy encoded order information'),
              ('RGR', 'Pharmacy dose information'),
              ('RGV', 'Pharmacy give message'),
              ('ROR', 'Pharmacy prescription order response'),
              ('RPA', 'Return patient authorization'),
              ('RPI', 'Return patient information'),
              ('RPL', 'Return patient display list'),
              ('RPR', 'Return patient list'),
              ('RQA', 'Request patient authorization'),
              ('RQC', 'Request clinical information'),
              ('RQI', 'Request patient information'),
              ('RQP', 'Request patient demographics'),
              ('RQQ', 'Event replay query'),
              ('RRA', 'Pharmacy administration acknowledgment'),
              ('RRD', 'Pharmacy dispense acknowledgment'),
              ('RRE', 'Pharmacy encoded order acknowledgment'),
              ('RRG', 'Pharmacy give acknowledgment'),
              ('RRI', 'Return patient referral'),
              ('SIU', 'Schedule information unsolicited'),
              ('SPQ', 'Stored procedure request'),
              ('SQM', 'Schedule query'),
              ('SQR', 'Schedule query response'),
              ('SRM', 'Schedule request'),
              ('SRR', 'Scheduled request response'),
              ('SUR', 'Summary product experience report'),
              ('TBR', 'Tabular data response'),
              ('UDM', 'Unsolicited display message'),
              ('VQQ', 'Virtual table query'),
              ('VXQ', 'Query for vaccination record'),
              ('VXR', 'Vaccination query record response'),
              ('VXU', 'Unsolicited vaccination record update'),
              ('VXX',
               'Vaccination query response with multiple PID matches'))),
 'HL70078': ('Abnormal flags',
             (('<', 'Below absolute low-off instrument scale'),
              ('>', 'Above absolute high-off instrument scale'),
              ('A', 'Abnormal (applies to non-numeric results)'),
              ('AA',
               'Very abnormal (applies to non-numeric units, analogous to panic limits for numeric units)'),
              ('B', 'Better--use when direction not relevant'),
              ('D', 'Significant change down'),
              ('For micriobo', ''),
              ('H', 'Above high normal'),
              ('HH', 'Above upper panic limits'),
              ('I', 'Intermediate*'),
              ('L', 'Below low normal'),
              ('LL', 'Below lower panic limits'),
              ('MS', 'Moderately susceptible*'),
              ('N', 'Normal (applies to non-numeric results)'),
              ('null', "No range defined, or normal ranges don't apply"),
              ('R', 'Resistant*'),
              ('S', 'Susceptible*'),
              ('U', 'Significant change up'),
              ('VS', 'Very susceptible*'),
              ('W', 'Worse--use when direction not relevant'))),
 'HL70080': ('Nature of abnormal testing',
             (('A', 'An age-based population'),
              ('N', 'None - generic normal range'),
              ('R', 'A race-based population'),
              ('S', 'A sex-based population'))),
 'HL70083': ('Outlier Type', (('C', 'Outlier cost'), ('D', 'Outlier days'))),
 'HL70085': ('Observation result status codes interpretation',
             (('C',
               'Record coming over is a correction and thus replaces a final result'),
              ('D', 'Deletes the OBX record'),
              ('F',
               'Final results; Can only be changed with a corrected result.'),
              ('I', 'Specimen in lab; results pending'),
              ('N',
               'Not asked; used to affirmatively document that the observation identified in the OBX was not sought when the universal service ID in OBR-4 implies that it would be sought.'),
              ('O', 'Order detail description only (no result)'),
              ('P', 'Preliminary results'),
              ('R', 'Results entered -- not verified'),
              ('S', 'Partial results'),
              ('U',
               "Results status change to final without retransmitting results already sent as 'preliminary.'  E.g., radiology changes status from preliminary to final"),
              ('W',
               'Post original as wrong, e.g., transmitted for wrong patient'),
              ('X', 'Results cannot be obtained for this observation'))),
 'HL70091': ('Query priority', (('D', 'Deferred'), ('I', 'Immediate'))),
 'HL70093': ('Release information', (('N', 'No'), ('Y', 'Yes'))),
 'HL70098': ('Type of agreement',
             (('M', 'Maternity'), ('S', 'Standard'), ('U', 'Unified'))),
 'HL70100': ('When to charge',
             (('D', 'On discharge'),
              ('O', 'On receipt of order'),
              ('R', 'At time service is completed'),
              ('S', 'At time service is started'),
              ('T', 'At a designated date/time'))),
 'HL70102': ('Delayed acknowledgment type',
             (('D', 'Message received, stored for later processing'),
              ('F', 'Acknowledgment after processing'))),
 'HL70103': ('Processing ID',
             (('D', 'Debugging'), ('P', 'Production'), ('T', 'Training'))),
 'HL70104': ('Version ID',
             (('2.0', 'Release 2.0'),
              ('2.0D', 'Demo 2.0'),
              ('2.1', 'Release 2. 1'),
              ('2.2', 'Release 2.2'),
              ('2.3', 'Release 2.3'),
              ('2.3.1', 'Release 2.3.1'),
              ('2.3.2', 'Release 2.3.2'))),
 'HL70105': ('Source of comment',
             (('L', 'Ancillary (filler) department is source of comment'),
              ('O', 'Other system is source of comment'),
              ('P', 'Orderer (placer) is source of comment'))),
 'HL70106': ('Query/response format code',
             (('D', 'Response is in display format'),
              ('R', 'Response is in record-oriented format'),
              ('T', 'Response is in tabular format'))),
 'HL70107': ('Deferred response type',
             (('B', 'Before the Date/Time specified'),
              ('L', 'Later than the Date/Time specified'))),
 'HL70108': ('Query results level',
             (('O', 'Order plus order status'),
              ('R', 'Results without bulk text'),
              ('S', 'Status only'),
              ('T', 'Full results'))),
 'HL70109': ('Report priority', (('R', 'Routine'), ('S', 'Stat'))),
 'HL70112': ('Discharge disposition',
             (('01', 'Discharged to home or self care (routine discharge)'),
              ('02',
               'Discharged/transferred to another short term general hospital for inpatient care'),
              ('03',
               'Discharged/transferred to skilled nursing facility (SNF)'),
              ('04',
               'Discharged/transferred to an intermediate care facility (ICF)'),
              ('05',
               'Discharged/transferred to another type of institution for inpatient care or referred for outpatient services to another institution'),
              ('06',
               'Discharged/transferred to home under care of organized home health service organization'),
              ('07', 'Left against medical advice or discontinued care'),
              ('08',
               'Discharged/transferred to home under care of Home IV provider'),
              ('09', 'Admitted as an inpatient to this hospital'),
              ('10', 'Discharge to be defined at state level, if necessary'),
              ('11', 'Discharge to be defined at state level, if necessary'),
              ('12', 'Discharge to be defined at state level, if necessary'),
              ('13', 'Discharge to be defined at state level, if necessary'),
              ('14', 'Discharge to be defined at state level, if necessary'),
              ('15', 'Discharge to be defined at state level, if necessary'),
              ('16', 'Discharge to be defined at state level, if necessary'),
              ('17', 'Discharge to be defined at state level, if necessary'),
              ('18', 'Discharge to be defined at state level, if necessary'),
              ('19', 'Discharge to be defined at state level, if necessary'),
              ('20', 'Expired'),
              ('21', 'Expired to be defined at state level, if necessary'),
              ('22', 'Expired to be defined at state level, if necessary'),
              ('23', 'Expired to be defined at state level, if necessary'),
              ('24', 'Expired to be defined at state level, if necessary'),
              ('25', 'Expired to be defined at state level, if necessary'),
              ('26', 'Expired to be defined at state level, if necessary'),
              ('27', 'Expired to be defined at state level, if necessary'),
              ('28', 'Expired to be defined at state level, if necessary'),
              ('29', 'Expired to be defined at state level, if necessary'),
              ('30',
               'Still patient or expected to return for outpatient services'),
              ('31',
               'Still patient to be defined at state level, if necessary'),
              ('32',
               'Still patient to be defined at state level, if necessary'),
              ('33',
               'Still patient to be defined at state level, if necessary'),
              ('34',
               'Still patient to be defined at state level, if necessary'),
              ('35',
               'Still patient to be defined at state level, if necessary'),
              ('36',
               'Still patient to be defined at state level, if necessary'),
              ('37',
               'Still patient to be defined at state level, if necessary'),
              ('38',
               'Still patient to be defined at state level, if necessary'),
              ('39',
               'Still patient to be defined at state level, if necessary'),
              ('40', 'Expired at home'),
              ('41',
               'Expired in a medical facility; e.g., hospital, SNF, ICF, or free standing hospice'),
              ('42', 'Expired - place unknown'))),
 'HL70116': ('Bed status',
             (('C', 'Closed'),
              ('H', 'Housekeeping'),
              ('I', 'Isolated'),
              ('K', 'Contaminated'),
              ('O', 'Occupied'),
              ('U', 'Unoccupied'))),
 'HL70119': ('Order control codes and their meaning',
             (('AF', 'Order refill request approval (O02)'),
              ('CA', 'Cancel order request (O01)'),
              ('CH', 'Child order (O01/ORU)'),
              ('CN', 'Combined result (R01)'),
              ('CR', 'Canceled as requested (O02)'),
              ('DC', 'Discontinue order request (O01)'),
              ('DE', 'Data errors (O01/O02)'),
              ('DF', 'Order refill request denied (O02)'),
              ('DR', 'Discontinued as requested (O02)'),
              ('FU', 'Order refilled, unsolicited (O01)'),
              ('HD', 'Hold order request (O01)'),
              ('HR', 'On hold as requested (O02)'),
              ('LI', 'Link order to patient care problem or goal'),
              ('NA', 'Number assigned (O02)'),
              ('NW', 'New order (O01)'),
              ('OC', 'Order canceled (O01)'),
              ('OD', 'Order discontinued (O01)'),
              ('OE', 'Order released (O01)'),
              ('OF', 'Order refilled as requested (O02)'),
              ('OH', 'Order held (O01)'),
              ('OK', 'Order accepted & OK (O02)'),
              ('OR', 'Released as requested'),
              ('PA', 'Parent order (O01/ORU)'),
              ('RE', 'Observations to follow (O01/R01)'),
              ('RF', 'Refill order request (O01)'),
              ('RL', 'Release previous hold (O01)'),
              ('RO', 'Replacement order (O01)'),
              ('RP', 'Order replace request (O01)'),
              ('RQ', 'Replaced as requested (O02)'),
              ('RR', 'Request received (O02)'),
              ('RU', 'Replaced unsolicited (O01)'),
              ('SC', 'Status changed (O01)'),
              ('SN', 'Send order number (O01)'),
              ('SR', 'Response to send order status request (O02(Q06)'),
              ('SS', 'Send order status request (O01)'),
              ('UA', 'Unable to accept order (O02/ORR)'),
              ('UC', 'Unable to cancel (O02)'),
              ('UD', 'Unable to discontinue (O02)'),
              ('UF', 'Unable to refill (O02)'),
              ('UH', 'Unable to put on hold (O02)'),
              ('UM', 'Unable to replace (O02)'),
              ('UN', 'Unlink order from patient care problem or goal'),
              ('UR', 'Unable to release (O02)'),
              ('UX', 'Unable to change (O02)'),
              ('XO', 'Change order request (O01)'),
              ('XR', 'Changed as requested (O02)'),
              ('XX', 'Order changed, unsol. (O01)'))),
 'HL70121': ('Response flag',
             (('D', 'Same as R, also other associated segments'),
              ('E', 'Report exceptions only'),
              ('F', 'Same as D, plus confirmations explicitly'),
              ('N', 'Only the MSA segment is returned'),
              ('R', 'Same as E, also Replacement and Parent-Child'))),
 'HL70122': ('Charge type',
             (('CH', 'Charge'),
              ('CO', 'Contract'),
              ('CR', 'Credit'),
              ('DP', 'Department'),
              ('GR', 'Grant'),
              ('NC', 'No Charge'),
              ('PC', 'Professional'),
              ('RS', 'Research'))),
 'HL70123': ('Result status',
             (('A', 'Some, but not all, results available'),
              ('C', 'Correction to results'),
              ('F',
               'Final results; results stored and verified.  Can only be changed with a corrected result.'),
              ('I',
               'No results available; specimen received, procedure incomplete'),
              ('O', 'Order received; specimen not yet received'),
              ('P',
               'Preliminary: A verified early result is available, final results not yet obtained'),
              ('R', 'Results stored; not yet verified'),
              ('S',
               'No results available; procedure scheduled, but not done'),
              ('X', 'No results available; Order canceled.'),
              ('Y',
               'No order on record for this test.  (Used only on queries)'),
              ('Z', 'No record of this patient. (Used only on queries)'))),
 'HL70124': ('Transportation mode',
             (('CART', 'Cart - patient travels on cart or gurney'),
              ('PORT', "The examining device goes to patient's location"),
              ('WALK', 'Patient walks to diagnostic service'),
              ('WHLC', 'Wheelchair'))),
 'HL70125': ('Value type',
             (('AD', 'Address'),
              ('CE', 'Coded Entry'),
              ('CF', 'Coded Element With Formatted Values'),
              ('CK', 'Composite ID With Check Digit'),
              ('CN', 'Composite ID And Name'),
              ('CP', 'Composite Price'),
              ('CX', 'Extended Composite ID With Check Digit'),
              ('DT', 'Date'),
              ('ED', 'Encapsulated Data'),
              ('FT', 'Formatted Text (Display)'),
              ('MO', 'Money'),
              ('NM', 'Numeric'),
              ('PN', 'Person Name'),
              ('RP', 'Reference Pointer'),
              ('SN', 'Structured Numeric'),
              ('ST', 'String Data.'),
              ('TM', 'Time'),
              ('TN', 'Telephone Number'),
              ('TS', 'Time Stamp (Date & Time)'),
              ('TX', 'Text Data (Display)'),
              ('XAD', 'Extended Address'),
              ('XCN', 'Extended Composite Name And Number For Persons'),
              ('XON',
               'Extended Composite Name And Number For Organizations'),
              ('XPN', 'Extended Person Name'),
              ('XTN', 'Extended Telecommunications Number'))),
 'HL70126': ('Quantity limited request',
             (('CH', 'Characters'),
              ('LI', 'Lines'),
              ('PG', 'Pages'),
              ('RD', 'Records'),
              ('ZO', 'Locally defined'))),
 'HL70127': ('Allergy type',
             (('DA', 'Drug allergy'),
              ('FA', 'Food allergy'),
              ('MA', 'Miscellaneous allergy'),
              ('MC', 'Miscellaneous contraindication'))),
 'HL70128': ('Allergy severity',
             (('MI', 'Mild'), ('MO', 'Moderate'), ('SV', 'Severe'))),
 'HL70133': ('Procedure practitioner identifier code type',
             (('AN', 'Anesthesiologist'),
              ('AS', 'Assistant Surgeon'),
              ('CM', 'Certified Nurse Midwife'),
              ('NP', 'Nurse Practitioner'),
              ('PR', 'Procedure MD (surgeon)'),
              ('PS', 'Primary Surgeon'),
              ('RD', 'Radiologist'),
              ('RS', 'Resident'),
              ('SN', 'Scrub Nurse'))),
 'HL70135': ('Assignment of benefits',
             (('M', 'Modified assignment'), ('N', 'No'), ('Y', 'Yes'))),
 'HL70136': ('Yes/no indicator', (('N', 'No'), ('Y', 'Yes'))),
 'HL70137': ('Mail claim party',
             (('E', 'Employer'),
              ('G', 'Guarantor'),
              ('I', 'Insurance company'),
              ('O', 'Other'),
              ('P', 'Patient'))),
 'HL70140': ('Military service',
             (('NATO', 'North Atlantic Treaty Organization'),
              ('NOAA', 'National Oceanic and Atmospheric Administration'),
              ('USA', 'U.S. Army'),
              ('USAF', 'U.S. Air Force'),
              ('USCG', 'U.S. Coast Guard'),
              ('USMC', 'U.S. Marines'),
              ('USN', 'U.S. Navy'),
              ('USPHS', 'U.S. Public Health Service'))),
 'HL70141': ('Military rank/grade',
             (('E1 ... E9', 'Enlisted'),
              ('O1 ... O10', 'Officers'),
              ('W1 ... W4', 'Warrant Officers'))),
 'HL70142': ('Military status',
             (('ACT', 'Active duty'),
              ('DEC', 'Deceased'),
              ('RET', 'Retired'))),
 'HL70144': ('Eligibility source',
             (('1', 'Insurance company'),
              ('2', 'Employer'),
              ('3', 'Insured presented policy'),
              ('4', 'Insured presented card'),
              ('5', 'Signed statement on file'),
              ('6', 'Verbal information'),
              ('7', 'None'))),
 'HL70145': ('Room type',
             (('2ICU', 'Second intensive care unit'),
              ('2PRI', 'Second private room'),
              ('2SPR', 'Second semi-private room'),
              ('ICU', 'Intensive care unit'),
              ('PRI', 'Private room'),
              ('SPR', 'Semi-private room'))),
 'HL70146': ('Amount type',
             (('DF', 'Differential'),
              ('LM', 'Limit'),
              ('PC', 'Percentage'),
              ('RT', 'Rate'),
              ('UL', 'Unlimited'))),
 'HL70147': ('Policy type',
             (('2ANC', 'Second ancillary'),
              ('2MMD', 'Second major medical'),
              ('3MMD', 'Third major medical'),
              ('ANC', 'Ancillary'),
              ('MMD', 'Major medical'))),
 'HL70148': ('Penalty type',
             (('AT', 'Currency amount'), ('PC', 'Percentage'))),
 'HL70149': ('Day type',
             (('AP', 'Approved'), ('DE', 'Denied'), ('PE', 'Pending'))),
 'HL70150': ('Pre-certification patient type',
             (('ER', 'Emergency'),
              ('IPE', 'Inpatient elective'),
              ('OPE', 'Outpatient elective'),
              ('UR', 'Urgent'))),
 'HL70153': ('Value code',
             (('01', 'Most common semi-private rate'),
              ('02', 'Hospital has no semi-private rooms'),
              ('04',
               'Inpatient professional component charges which are combined billed'),
              ('05',
               'Professional component included in charges and also billed separate to carrier'),
              ('06', 'Medicare blood deductible'),
              ('08',
               'Medicare life time reserve amount in the first calendar year'),
              ('09',
               'Medicare co-insurance amount in the first calendar year'),
              ('10', 'Lifetime reserve amount in the second calendar year'),
              ('11', 'Co-insurance amount in the second calendar year'),
              ('12',
               'Working aged beneficiary/spouse with employer group health plan'),
              ('13',
               'ESRD beneficiary in a Medicare coordination period with an employer group health plan'),
              ('14', 'No Fault including auto/other'),
              ('15', "Worker's Compensation"),
              ('16', 'PHS, or other federal agency'),
              ('17', 'Payer code'),
              ('21', 'Catastrophic'),
              ('22', 'Surplus'),
              ('23', 'Recurring monthly incode'),
              ('24', 'Medicaid rate code'),
              ('30', 'Pre-admission testing'),
              ('31', 'Patient liability amount'),
              ('37', 'Pints of blood furnished'),
              ('38', 'Blood deductible pints'),
              ('39', 'Pints of blood replaced'),
              ('40',
               'New coverage not implemented by HMO (for inpatient service only)'),
              ('41', 'Black lung'),
              ('42', 'VA'),
              ('43', 'Disabled beneficiary under age 64 with LGHP'),
              ('44',
               'Amount provider agreed to accept from primary payer when this amount is less than charges but higher than payment received,, then a Medicare secondary payment is due'),
              ('45', 'Accident hour'),
              ('46', 'Number of grace days'),
              ('47', 'Any liability insurance'),
              ('48', 'Hemoglobin reading'),
              ('49', 'Hematocrit reading'),
              ('50', 'Physical therapy visits'),
              ('51', 'Occupational therapy visits'),
              ('52', 'Speech therapy visits'),
              ('53', 'Cardiac rehab visits'),
              ('56', 'Skilled nurse - home visit hours'),
              ('57', 'Home health aide - home visit hours'),
              ('58', 'Arterial blood gas'),
              ('59', 'Oxygen saturation'),
              ('60', 'HHA branch MSA'),
              ('67', 'Peritoneal dialysis'),
              ('68', 'EPO-drug'),
              ('70 ... 72', 'Payer codes'),
              ('75 ... 79', 'Payer codes'),
              ('80', 'Psychiatric visits'),
              ('81', 'Visits subject to co-payment'),
              ('A1', 'Deductible payer A'),
              ('A2', 'Coinsurance payer A'),
              ('A3', 'Estimated responsibility payer A'),
              ('X0', 'Service excluded on primary policy'),
              ('X4', 'Supplemental coverage'))),
 'HL70155': ('Accept/application acknowledgment conditions',
             (('AL', 'Always'),
              ('ER', 'Error/reject conditions only'),
              ('NE', 'Never'),
              ('SU', 'Successful completion only'))),
 'HL70156': ('Which date/time qualifier',
             (('ANY', 'Any date/time within a range'),
              ('COL',
               'Collection date/time, equivalent to film or sample collection date/time'),
              ('ORD', 'Order date/time'),
              ('RCT',
               'Specimen receipt date/time, receipt of specimen in filling ancillary (Lab)'),
              ('REP',
               'Report date/time, report date/time at filing ancillary (i.e., Lab)'),
              ('SCHED', 'Schedule date/time'))),
 'HL70157': ('Which date/time status qualifier',
             (('ANY', 'Any status'),
              ('CFN', 'Current final value, whether final or corrected'),
              ('COR', 'Corrected only (no final with corrections)'),
              ('FIN', 'Final only (no corrections)'),
              ('PRE', 'Preliminary'),
              ('REP', 'Report completion date/time'))),
 'HL70158': ('Date/time selection qualifier',
             (('1ST', 'First value within range'),
              ('ALL', 'All values within the range'),
              ('LST', 'Last value within the range'),
              ('REV',
               'All values within the range returned in reverse chronological order (This is the default if not otherwise specified.)'))),
 'HL70159': ('Diet code specification type',
             (('D', 'Diet'), ('P', 'Preference'), ('S', 'Supplement'))),
 'HL70160': ('Tray type',
             (('EARLY', 'Early tray'),
              ('GUEST', 'Guest tray'),
              ('LATE', 'Late tray'),
              ('MSG', 'Tray message only'),
              ('NO', 'No tray'))),
 'HL70161': ('Allow substitution',
             (('G', 'Allow generic substitutions.'),
              ('N',
               'Substitutions are NOT authorized.  (This is the default - null.)'),
              ('T', 'Allow therapeutic substitutions'))),
 'HL70162': ('Route of administration',
             (('AP', 'Apply Externally'),
              ('B', 'Buccal'),
              ('DT', 'Dental'),
              ('EP', 'Epidural'),
              ('ET', 'Endotrachial Tube*'),
              ('GTT', 'Gastrostomy Tube'),
              ('GU', 'GU Irrigant'),
              ('IA', 'Intra-arterial'),
              ('IB', 'Intrabursal'),
              ('IC', 'Intracardiac'),
              ('ICV', 'Intracervical (uterus)'),
              ('ID', 'Intradermal'),
              ('IH', 'Inhalation'),
              ('IHA', 'Intrahepatic Artery'),
              ('IM', 'Intramuscular'),
              ('IMR', 'Immerse (Soak) Body Part'),
              ('IN', 'Intranasal'),
              ('IO', 'Intraocular'),
              ('IP', 'Intraperitoneal'),
              ('IS', 'Intrasynovial'),
              ('IT', 'Intrathecal'),
              ('IU', 'Intrauterine'),
              ('IV', 'Intravenous'),
              ('MM', 'Mucous Membrane'),
              ('MTH', 'Mouth/Throat'),
              ('NG', 'Nasogastric'),
              ('NP', 'Nasal Prongs*'),
              ('NS', 'Nasal'),
              ('NT', 'Nasotrachial Tube'),
              ('OP', 'Ophthalmic'),
              ('OT', 'Otic'),
              ('OTH', 'Other/Miscellaneous'),
              ('PF', 'Perfusion'),
              ('PO', 'Oral'),
              ('PR', 'Rectal'),
              ('RM', 'Rebreather Mask*'),
              ('SC', 'Subcutaneous'),
              ('SD', 'Soaked Dressing'),
              ('SL', 'Sublingual'),
              ('TD', 'Transdermal'),
              ('TL', 'Translingual'),
              ('TP', 'Topical'),
              ('TRA', 'Tracheostomy*'),
              ('UR', 'Urethral'),
              ('VG', 'Vaginal'),
              ('VM', 'Ventimask'),
              ('WND', 'Wound'))),
 'HL70163': ('Administrative site',
             (('BE', 'Bilateral Ears'),
              ('BN', 'Bilateral Nares'),
              ('BU', 'Buttock'),
              ('CT', 'Chest Tube'),
              ('LA', 'Left Arm'),
              ('LAC', 'Left Anterior Chest'),
              ('LACF', 'Left Antecubital Fossa'),
              ('LD', 'Left Deltoid'),
              ('LE', 'Left Ear'),
              ('LEJ', 'Left External Jugular'),
              ('LF', 'Left Foot'),
              ('LG', 'Left Gluteus Medius'),
              ('LH', 'Left Hand'),
              ('LIJ', 'Left Internal Jugular'),
              ('LLAQ', 'Left Lower Abd Quadrant'),
              ('LLFA', 'Left Lower Forearm'),
              ('LMFA', 'Left Mid Forearm'),
              ('LN', 'Left Naris'),
              ('LPC', 'Left Posterior Chest'),
              ('LSC', 'Left Subclavian'),
              ('LT', 'Left Thigh'),
              ('LUA', 'Left Upper Arm'),
              ('LUAQ', 'Left Upper Abd Quadrant'),
              ('LUFA', 'Left Upper Forearm'),
              ('LVG', 'Left Ventragluteal'),
              ('LVL', 'Left Vastus Lateralis'),
              ('NB', 'Nebulized'),
              ('OD', 'Right Eye'),
              ('OS', 'Left Eye'),
              ('OU', 'Bilateral Eyes'),
              ('PA', 'Perianal'),
              ('PERIN', 'Perineal'),
              ('RA', 'Right Arm'),
              ('RAC', 'Right Anterior Chest'),
              ('RACF', 'Right Antecubital Fossa'),
              ('RD', 'Right Deltoid'),
              ('RE', 'Right Ear'),
              ('REJ', 'Right External Jugular'),
              ('RF', 'Right Foot'),
              ('RG', 'Right Gluteus Medius'),
              ('RH', 'Right Hand'),
              ('RIJ', 'Right Internal Jugular'),
              ('RLAQ', 'Rt Lower Abd Quadrant'),
              ('RLFA', 'Right Lower Forearm'),
              ('RMFA', 'Right Mid Forearm'),
              ('RN', 'Right Naris'),
              ('RPC', 'Right Posterior Chest'),
              ('RSC', 'Right Subclavian'),
              ('RT', 'Right Thigh'),
              ('RUA', 'Right Upper Arm'),
              ('RUAQ', 'Right Upper Abd Quadrant'),
              ('RUFA', 'Right Upper Forearm'),
              ('RVG', 'Right Ventragluteal'),
              ('RVL', 'Right Vastus Lateralis'))),
 'HL70164': ('Administration device',
             (('AP', 'Applicator'),
              ('BT', 'Buretrol'),
              ('HL', 'Heparin Lock'),
              ('IPPB', 'IPPB'),
              ('IVP', 'IV Pump'),
              ('IVS', 'IV Soluset'),
              ('MI', 'Metered Inhaler'),
              ('NEB', 'Nebulizer'),
              ('PCA', 'PCA Pump'))),
 'HL70165': ('Administration method',
             (('CH', 'Chew'),
              ('DI', 'Dissolve'),
              ('DU', 'Dust'),
              ('IF', 'Infiltrate'),
              ('IR', 'Irrigate'),
              ('IS', 'Insert'),
              ('IVP', 'IV Push'),
              ('IVPB', 'IV Piggyback'),
              ('NB', 'Nebulized'),
              ('PF', 'Perfuse'),
              ('PT', 'Pain'),
              ('SH', 'Shampoo'),
              ('SO', 'Soak'),
              ('WA', 'Wash'),
              ('WI', 'Wipe'))),
 'HL70166': ('RX component type', (('A', 'Additive'), ('B', 'Base'))),
 'HL70167': ('Substitution status',
             (('0', 'No product selection indicated'),
              ('1', 'Substitution not allowed by prescriber'),
              ('2',
               'Substitution allowed - patient requested product dispensed'),
              ('3',
               'Substitution allowed - pharmacist selected product dispensed'),
              ('4', 'Substitution allowed - generic drug not in stock'),
              ('5',
               'Substitution allowed - brand drug dispensed as a generic'),
              ('7', 'Substitution not allowed - brand drug mandated by law'),
              ('8',
               'Substitution allowed - generic drug not available in marketplace'),
              ('G', 'A generic substitution was dispensed.'),
              ('N',
               'No substitute was dispensed.  This is equivalent to the default (null) value.'),
              ('T', 'A therapeutic substitution was dispensed.'))),
 'HL70168': ('Processing priority',
             (('A', 'As soon as possible (a priority lower than stat)'),
              ('B',
               'Do at bedside or portable (may be used with other codes)'),
              ('C',
               'Measure continuously (e.g., arterial line blood pressure)'),
              ('P', 'Preoperative (to be done prior to surgery)'),
              ('R', 'Routine'),
              ('S', 'Stat (do immediately)'),
              ('T',
               'Timing critical (do as near as possible to requested time)'))),
 'HL70169': ('Reporting priority',
             (('C', 'Call back results'), ('R', 'Rush reporting'))),
 'HL70170': ('Derived specimen',
             (('C', 'Child Observation'),
              ('N', 'Not Applicable'),
              ('P', 'Parent Observation'))),
 'HL70173': ('Coordination of benefits',
             (('CO', 'Coordination'), ('IN', 'Independent'))),
 'HL70174': ('Nature of test/observation',
             (('A', 'Atomic test/observation (test code or treatment code)'),
              ('C',
               'Single observation calculated via a rule or formula from other independent observations (e.g., Alveolar--arterial ratio, cardiac output)'),
              ('F',
               'Functional procedure that may consist of one or more interrelated measures (e.g., glucose tolerance test, creatine clearance), usually done at different times and/or on different specimens'),
              ('P',
               'Profile or battery consisting of many independent atomic observations (e.g., SMA12, electrolytes), usually done at one instrument on one specimen'),
              ('S',
               'Superset--a set of batteries or procedures ordered under a single code unit but processed as separate batteries (e.g., routines = CBC, UA, electrolytes)'))),
 'HL70175': ('Master file identifier code',
             (('CDM', 'Charge description master file'),
              ('CMA',
               'Clinical study with phases and scheduled master file'),
              ('CMB',
               'Clinical study without phases but with scheduled master file'),
              ('LOC', 'Location master file'),
              ('OMA', 'Numerical observation master file'),
              ('OMB', 'Categorical observation master file'),
              ('OMC', 'Observation batteries master file'),
              ('OMD', 'Calculated observations master file'),
              ('PRA', 'Practitioner master file'),
              ('STF', 'Staff master file'))),
 'HL70177': ('Confidentiality code',
             (('AID', 'AIDS patient'),
              ('EMP', 'Employee'),
              ('ETH', 'Alcohol/drug treatment patient'),
              ('HIV', 'HIV(+) patient'),
              ('PSY', 'Psychiatric patient'),
              ('R', 'Restricted'),
              ('U', 'Usual control'),
              ('UWM', 'Unwed mother'),
              ('V', 'Very restricted'),
              ('VIP', 'Very important person or celebrity'))),
 'HL70178': ('File level event code',
             (('REP',
               'Replace current version of this master file with the version contained in this message'),
              ('UPD',
               'Change file records as defined in the record-level event codes for each record that follows'))),
 'HL70179': ('Response level',
             (('AL',
               'Always.  All MFA segments (whether denoting errors or not) must be returned via the application-level  acknowledgment message'),
              ('ER',
               'Error/Reject conditions only.  Only MFA segments denoting errors must be returned via the application-level acknowledgment for this message'),
              ('NE', 'Never.  No application-level response needed'),
              ('SU',
               'Success.  Only MFA segments denoting success must be returned via the application-level acknowledgment for this message'))),
 'HL70180': ('Record-level event code',
             (('MAC', 'Reactivate deactivated record'),
              ('MAD', 'Add record to master file'),
              ('MDC',
               'Deactivate: discontinue using record in master file, but do not delete from database'),
              ('MDL', 'Delete record from master file'),
              ('MUP', 'Update record for master file'))),
 'HL70181': ('MFN record-level error return',
             (('S',
               'Successful posting of the record defined by the MFE segment'),
              ('U',
               'Unsuccessful posting of the record defined by the MFE segment'))),
 'HL70183': ('Active/inactive',
             (('A', 'Active Staff'), ('I', 'Inactive Staff'))),
 'HL70185': ('Preferred method of contact',
             (('B', 'Beeper Number'),
              ('C', 'Cellular Phone Number'),
              ('E', 'E-Mail Address (for backward compatibility)'),
              ('F', 'FAX Number'),
              ('H', 'Home Phone Number'),
              ('O', 'Office Phone Number'))),
 'HL70187': ('Provider billing',
             (('I', 'Institution bills for provider'),
              ('P', 'Provider does own billing'))),
 'HL70190': ('Address type',
             (('B', 'Firm/Business'),
              ('BA', 'Bad address'),
              ('BDL',
               'Birth delivery location (address where birth occurred)'),
              ('BR', 'Residence  at birth (home address at time of birth)'),
              ('C', 'Current Or Temporary'),
              ('F', 'Country Of Origin'),
              ('H', 'Home'),
              ('L', 'Legal Address'),
              ('M', 'Mailing'),
              ('N', 'Birth (nee) (birth address, not otherwise specified)'),
              ('O', 'Office'),
              ('P', 'Permanent'),
              ('RH',
               'Registry home.  Refers to the information system, typically managed by a public health agency, that  stores patient information such as immunization histories or cancer data, regardless of where the patient obtains services.'))),
 'HL70191': ('Type of referenced data',
             (('AP',
               'Other application data, typically uninterpreted binary data  (new with HL7 v 2.3)'),
              ('Application',
               'Other application data, typically uninterpreted binary data  (HL7 V2.3 and later)'),
              ('AU', 'Audio data  (new with HL7 v 2.3)'),
              ('Audio', 'Audio data  (HL7 V2.3 and later)'),
              ('FT', 'Formatted text (HL7 V2.2 only)'),
              ('IM', 'Image data  (new  with HL7 v 2.3)'),
              ('Image', 'Image data  (HL7 V2.3 and later)'),
              ('NS', 'Non-scanned image (HL7 V2.2 only)'),
              ('SD', 'Scanned document (HL7 V2.2 only)'),
              ('SGML',
               'Structured Generalized Markup Language (HL7 V2.3 and later)'),
              ('SI', 'Scanned image (HL7 V2.2 only)'),
              ('TEXT',
               'Machine readable text document (HL7 V2.3.1 and later)'),
              ('TX', 'Machine readable text document (HL7 V2.2 only)'))),
 'HL70193': ('Amount class',
             (('AT', 'Amount'),
              ('LM', 'Limit'),
              ('PC', 'Percentage'),
              ('UL', 'Unlimited'))),
 'HL70200': ('Name type',
             (('A', 'Alias Name'),
              ('B', 'Name at Birth'),
              ('C', 'Adopted Name'),
              ('D', 'Display Name'),
              ('L', 'Legal Name'),
              ('M', 'Maiden Name'),
              ('P', 'Name of Partner/Spouse'),
              ('S', 'Coded Pseudo-Name to ensure anonymity'),
              ('T', 'Tribal/Community Name'),
              ('U', 'Unspecified'))),
 'HL70201': ('Telecommunication use code',
             (('ASN', 'Answering Service Number'),
              ('BPN', 'Beeper Number'),
              ('EMR', 'Emergency Number'),
              ('NET', 'Network (email) Address'),
              ('ORN', 'Other Residence Number'),
              ('PRN', 'Primary Residence Number'),
              ('VHN', 'Vacation Home Number'),
              ('WPN', 'Work Number'))),
 'HL70202': ('Telecommunication equipment type',
             (('BP', 'Beeper'),
              ('CP', 'Cellular Phone'),
              ('FX', 'Fax'),
              ('Internet',
               'Internet Address: Use Only If Telecommunication Use Code Is NET'),
              ('MD', 'Modem'),
              ('PH', 'Telephone'),
              ('X.400',
               'X.400 email address: Use Only If Telecommunication Use Code Is NET'))),
 'HL70203': ('Identifier type',
             (('AM', 'American Express'),
              ('AN', 'Account number'),
              ('BR', 'Birth registry number'),
              ('DI', "Diner's Club card"),
              ('DL', "Driver's license number"),
              ('DN', 'Doctor number'),
              ('DS', 'Discover Card'),
              ('EI', 'Employee number'),
              ('EN', 'Employer number'),
              ('FI', 'Facility ID'),
              ('GI', 'Guarantor internal identifier'),
              ('GN', 'Guarantor external  identifier'),
              ('LN', 'License number'),
              ('LR', 'Local Registry ID'),
              ('MA', 'Medicaid number'),
              ('MC', 'Medicare number'),
              ('MR', 'Medical record number'),
              ('MS', 'MasterCard'),
              ('NE', 'National employer identifier'),
              ('NH', 'National Health Plan Identifier'),
              ('NI', 'National unique individual identifier'),
              ('NNxxx',
               'National Person Identifier where the xxx is the ISO table 3166  3-character (alphabetic) country  code'),
              ('NPI', 'National provider identifier'),
              ('PI', 'Patient internal identifier'),
              ('PN', 'Person number'),
              ('PRN', 'Provider number'),
              ('PT', 'Patient external identifier'),
              ('RR', 'Railroad Retirement number'),
              ('RRI', 'Regional registry ID'),
              ('SL', 'State license'),
              ('SR', 'State registry ID'),
              ('SS', 'Social Security number'),
              ('U', 'Unspecified'),
              ('UPIN',
               "Medicare/HCFA's Universal Physician Identification numbers"),
              ('VN', 'Visit number'),
              ('VS', 'VISA'),
              ('WC', 'WIC identifier'),
              ('XX', 'Organization identifier'))),
 'HL70204': ('Organizational name type',
             (('A', 'Alias name'),
              ('D', 'Display name'),
              ('L', 'Legal name'),
              ('SL', 'Stock exchange listing name'))),
 'HL70205': ('Price type',
             (('AP', 'administrative price or handling fee'),
              ('DC', 'direct unit cost'),
              ('IC', 'indirect unit cost'),
              ('PF', 'professional fee for performing provider'),
              ('TF', 'technology fee for use of equipment'),
              ('TP', 'total price'),
              ('UP',
               'unit price, may be based on length of procedure or service'))),
 'HL70206': ('Segment action code',
             (('A', 'Add/Insert'), ('D', 'Delete'), ('U', 'Update'))),
 'HL70207': ('Processing mode',
             (('A', 'Archive'),
              ('I', 'Initial load'),
              ('not present',
               'Not present (the default, meaning current  processing)'),
              ('R', 'Restore from archive'),
              ('T',
               'Current processing, transmitted at intervals (scheduled or on demand)'))),
 'HL70208': ('Query response status',
             (('AE', 'Application error'),
              ('AR', 'Application reject'),
              ('NF', 'No data found, no errors'),
              ('OK', 'Data found, no errors (this is the default)'))),
 'HL70209': ('Relational Operator',
             (('CT', 'Contains'),
              ('EQ', 'Equal'),
              ('GE', 'Greater than or equal'),
              ('GN', 'Generic'),
              ('GT', 'Greater than'),
              ('LE', 'Less than or equal'),
              ('LT', 'Less than'),
              ('NE', 'Not Equal'))),
 'HL70210': ('Relational Conjunction', (('AND', 'Default'), ('OR', ''))),
 'HL70211': ('Alternate character sets',
             (('8859/1',
               'The printable characters from the ISO 8859/1 Character set'),
              ('8859/2',
               'The printable characters from the ISO 8859/2 Character set'),
              ('8859/3',
               'The printable characters from the ISO 8859/3 Character set'),
              ('8859/4',
               'The printable characters from the ISO 8859/4 Character set'),
              ('8859/5',
               'The printable characters from the ISO 8859/5 Character set'),
              ('8859/6',
               'The printable characters from the ISO 8859/6 Character set'),
              ('8859/7',
               'The printable characters from the ISO 8859/7 Character set'),
              ('8859/8',
               'The printable characters from the ISO 8859/8 Character set'),
              ('8859/9',
               'The printable characters from the ISO 8859/9 Character set'),
              ('ASCII',
               'The printable 7-bit ASCII character set . (This is the default if this field is omitted)'),
              ('ISO IR14',
               'Code for Information Exchange (one byte)(JIS X 0201-1976),  Note that the code contains a  space, i.e. "ISO IR14".'),
              ('ISO IR159',
               'Code of the supplementary Japanese Graphic Character set for information interchange (JIS X  0212-1990), Note that the code contains a space, i.e. "ISO IR159".'),
              ('ISO IR87',
               'Code for the Japanese Graphic Character set for information interchange (JIS X 0208-1990), Note that the code contains a space, i.e. "ISO IR87".'),
              ('UNICODE',
               'The world wide character standard from ISO/IEC 10646-1-1993'))),
 'HL70213': ('Purge status',
             (('D',
               'The visit is marked for deletion and the user cannot enter new data against it.'),
              ('I',
               'The visit is marked inactive and the user cannot enter new data against it.'),
              ('P',
               'Marked for purge.  User is no longer able to update the visit.'))),
 'HL70220': ('Living arrangement',
             (('A', 'Alone'),
              ('F', 'Family'),
              ('I', 'Institution'),
              ('R', 'Relative'),
              ('S', 'Spouse Only'),
              ('U', 'Unknown'))),
 'HL70223': ('Living dependency',
             (('CB', 'Common Bath'),
              ('D', 'Spouse dependent'),
              ('M', 'Medical Supervision Required'),
              ('S', 'Small children'),
              ('WU', 'Walk up'))),
 'HL70224': ('Transport arranged',
             (('A', 'Arranged'), ('N', 'Not Arranged'), ('U', 'Unknown'))),
 'HL70225': ('Escort required',
             (('N', 'Not Required'), ('R', 'Required'), ('U', 'Unknown'))),
 'HL70227': ('Manufacturers of vaccines (code=MVX)',
             (('AB', 'Abbott Laboratories'),
              ('AD', 'Adams Laboratories'),
              ('ALP', 'Alpha Therapeutic Corporation'),
              ('AR', 'Armour (Inactive - use CEN)'),
              ('AVI', 'Aviron'),
              ('BA', 'Baxter Healthcare Corporation'),
              ('BAY',
               'Bayer Corporation (includes Miles, Inc. and Cutter Laboratories)'),
              ('BP', 'Berna Products (Inactive - use BPC)'),
              ('BPC',
               'Berna Products Corporation (includes Swiss Serum and Vaccine Institute Berna)'),
              ('CEN',
               'Centeon L.L.C. (includes Armour Pharmaceutical Company)'),
              ('CHI', 'Chiron Corporation'),
              ('CON', 'Connaught (inactive - use PMC)'),
              ('EVN', 'Evans Medical Limited'),
              ('GRE', 'Greer Laboratories, Inc.'),
              ('IAG', 'Immuno International AG'),
              ('IM', 'Merieux (inactive - Use PMC)'),
              ('IUS', 'Immuno-US, Inc.'),
              ('JPN',
               'The Research Foundation for Microbial Diseases of Osaka University (BIKEN)'),
              ('KGC', 'Korea Green Cross Corporation'),
              ('LED', 'Lederle (inactive - use WAL)'),
              ('MA', 'Massachusetts Public Health Biologic Laboratories)'),
              ('MED', 'Medimmune, Inc.'),
              ('MIL', 'Miles (inactive - use BAY)'),
              ('MIP', 'Michigan Biologic Products Institute'),
              ('MSD', 'Merck & Co., Inc.'),
              ('NAB', 'NABI (formerly North American Biologicals, Inc.)'),
              ('NAV', 'North American Vaccine, Inc.'),
              ('NOV', 'Novartis Pharmaceutical Corporation'),
              ('NYB', 'New York Blood Center'),
              ('ORT', 'Ortho Diagnostic Systems, Inc.'),
              ('OTC', 'Organon Teknika Corporation'),
              ('OTH', 'Other'),
              ('PD', 'Parkdale Pharmaceuticals (formerly Parke-Davis)'),
              ('PMC',
               'Pasteur Merieux Connaught (includes Connaught Laboratories and Pasteur Merieux)'),
              ('PRX', 'Praxis Biologics (inactive - use WAL)'),
              ('SCL', 'Sclavo, Inc.'),
              ('SI', 'Swiss Serum and Vaccine Inst. (inactive - use BPC)'),
              ('SKB', 'SmithKline Beecham'),
              ('UNK', 'Unknown manufacturer'),
              ('USA',
               'United States Army Medical Research and Materiel Command'),
              ('WA', 'Wyeth-Ayerst (inactive - use WAL)'),
              ('WAL',
               'Wyeth-Ayerst (includes Wyeth-Lederle Vaccines and Pediatrics, Wyeth Laboratories, Lederle Laboratories, and Praxis Biologics)'))),
 'HL70228': ('Diagnosis classification',
             (('C', 'Consultation'),
              ('D', 'Diagnosis'),
              ('I',
               'Invasive procedure not classified elsewhere (I.V., catheter, etc.)'),
              ('M', 'Medication (antibiotic)'),
              ('O', 'Other'),
              ('R', 'Radiological scheduling (not using ICDA codes)'),
              ('S', 'Sign and symptom'),
              ('T', 'Tissue diagnosis'))),
 'HL70229': ('DRG payor',
             (('C', 'Champus'),
              ('G', 'Managed Care Organization'),
              ('M', 'Medicare'))),
 'HL70230': ('Procedure functional type',
             (('A', 'Anesthesia'),
              ('D', 'Diagnostic procedure'),
              ('I',
               'Invasive procedure not classified elsewhere (e.g., IV, catheter, etc.)'),
              ('P',
               'Procedure for treatment (therapeutic, including operations)'))),
 'HL70231': ('Student status',
             (('F', 'Full-time student'),
              ('N', 'Not a student'),
              ('P', 'Part-time student'))),
 'HL70232': ('Insurance company contact reason',
             (('01', 'Medicare claim status'),
              ('02', 'Medicaid claim status'),
              ('03', 'Name/address change'))),
 'HL70234': ('Report timing',
             (('10D', '10 day report'),
              ('15D', '15 day report'),
              ('30D', '30 day report'),
              ('3D', '3 day report'),
              ('7D', '7 day report'),
              ('AD', 'Additional information'),
              ('CO', 'Correction'),
              ('DE', 'Device evaluation'),
              ('PD', 'Periodic'),
              ('RQ', 'Requested information'))),
 'HL70235': ('Report source',
             (('C', 'Clinical trial'),
              ('D', 'Database/registry/poison control center'),
              ('E', 'Distributor'),
              ('H', 'Health professional'),
              ('L', 'Literature'),
              ('M', 'Manufacturer/marketing authority holder'),
              ('N', 'Non-healthcare professional'),
              ('O', 'Other'),
              ('P', 'Patient'),
              ('R', 'Regulatory agency'))),
 'HL70236': ('Event reported to',
             (('D', 'Distributor'),
              ('L', 'Local facility/user facility'),
              ('M', 'Manufacturer'),
              ('R', 'Regulatory agency'))),
 'HL70237': ('Event qualification',
             (('A', 'Abuse'),
              ('B', 'Unexpected beneficial effect'),
              ('D', 'Dependency'),
              ('I', 'Interaction'),
              ('L', 'Lack of expect therapeutic effect'),
              ('M', 'Misuse'),
              ('O', 'Overdose'),
              ('W', 'Drug withdrawal'))),
 'HL70238': ('Event seriousness',
             (('N', 'No'), ('S', 'Significant'), ('Y', 'Yes'))),
 'HL70239': ('Event expected', (('N', 'No'), ('U', 'Unknown'), ('Y', 'Yes'))),
 'HL70240': ('Event consequence',
             (('C', 'Congenital anomaly/birth defect'),
              ('D', 'Death'),
              ('H', 'Caused hospitalized'),
              ('I',
               'Incapacity which is significant, persistent or permanent'),
              ('J',
               'Disability which is significant, persistent or permanent'),
              ('L', 'Life threatening'),
              ('O', 'Other'),
              ('P', 'Prolonged hospitalization'),
              ('R',
               'Required intervention to prevent permanent impairment/damage'))),
 'HL70241': ('Patient outcome',
             (('D', 'Died'),
              ('F', 'Fully recovered'),
              ('N', 'Not recovering/unchanged'),
              ('R', 'Recovering'),
              ('S', 'Sequelae'),
              ('U', 'Unknown'),
              ('W', 'Worsening'))),
 'HL70242': ("Primary observer's qualification",
             (('C', 'Health care consumer/patient'),
              ('H', 'Other health professional'),
              ('L', 'Lawyer/attorney'),
              ('M',
               "Mid-level professional (nurse, nurse practitioner, physician's assistant)"),
              ('O', 'Other non-health professional'),
              ('P', 'Physician (osteopath, homeopath)'),
              ('R', 'Pharmacist'))),
 'HL70243': ('Identity may be divulged',
             (('N', 'No'), ('NA', 'Not applicable'), ('Y', 'Yes'))),
 'HL70247': ('Status of evaluation',
             (('A', 'Evaluation anticipated, but not yet begun'),
              ('C',
               'Product received in condition which made analysis impossible'),
              ('D', 'Product discarded -- unable to follow up'),
              ('I', 'Product remains implanted -- unable to follow up'),
              ('K', 'Problem already known, no evaluation necessary'),
              ('O', 'Other'),
              ('P', 'Evaluation in progress'),
              ('Q', 'Product under quarantine -- unable to follow up'),
              ('R', 'Product under recall/corrective action'),
              ('U', 'Product unavailable for follow up investigation'),
              ('X', 'Product not made by company'),
              ('Y', 'Evaluation completed'))),
 'HL70248': ('Product source',
             (('A', 'Actual product involved in incident was evaluated'),
              ('L',
               'A product from the same lot as the actual product involved was evaluated'),
              ('N',
               'A product from a controlled/non-related inventory was evaluated'),
              ('R', 'A product from a reserve sample was evaluated'))),
 'HL70250': ('Relatedness assessment',
             (('H', 'Highly probable'),
              ('I', 'Improbable'),
              ('M', 'Moderately probable'),
              ('N', 'Not related'),
              ('S', 'Somewhat probable'))),
 'HL70251': ('Action taken in response to the event',
             (('DI', 'Product dose or frequency of use increased'),
              ('DR', 'Product dose or frequency of use reduced'),
              ('N', 'None'),
              ('OT', 'Other'),
              ('WP', 'Product withdrawn permanently'),
              ('WT', 'Product withdrawn temporarily'))),
 'HL70252': ('Causality observations',
             (('AW', 'Abatement of event after product withdrawn'),
              ('BE', 'Event recurred after product reintroduced'),
              ('DR', 'Dose response observed'),
              ('EX', 'Alternative explanations for the event available'),
              ('IN', 'Event occurred after product introduced'),
              ('LI', 'Literature reports association of product with event'),
              ('OE',
               'Occurrence of event was confirmed by objective evidence'),
              ('OT', 'Other'),
              ('PL', 'Effect observed when patient receives placebo'),
              ('SE', 'Similar events in past for this patient'),
              ('TC',
               'Toxic levels of product documented in blood or body fluids'))),
 'HL70253': ('Indirect exposure mechanism',
             (('B', 'Breast milk'),
              ('F', 'Father'),
              ('O', 'Other'),
              ('P', 'Transplacental'),
              ('X', 'Blood product'))),
 'HL70254': ('Kind of quantity',
             (('ABS', 'Absorbance'),
              ('ACNC', 'Concentration, Arbitrary Substance'),
              ('ACT', '*Activity'),
              ('APER', 'Appearance'),
              ('ARB', '*Arbitrary'),
              ('AREA', 'Area'),
              ('ASPECT', 'Aspect'),
              ('CACT', '*Catalytic Activity'),
              ('CCNT', '*Catalytic Content'),
              ('CCRTO', 'Catalytic Concentration Ratio'),
              ('CFR', '*Catalytic Fraction'),
              ('CLAS', 'Class'),
              ('CNC', '*Catalytic Concentration'),
              ('CNST', '*Constant'),
              ('COEF', '*Coefficient'),
              ('COLOR', 'Color'),
              ('CONS', 'Consistency'),
              ('CRAT', '*Catalytic Rate'),
              ('CRTO', 'Catalytic Ratio'),
              ('DEN', 'Density'),
              ('DEV', 'Device'),
              ('DIFF', '*Difference'),
              ('ELAS', 'Elasticity'),
              ('ELPOT', 'Electrical Potential (Voltage)'),
              ('ELRAT', 'Electrical current (amperage)'),
              ('ELRES', 'Electrical Resistance'),
              ('ENGR', 'Energy'),
              ('ENT', '*Entitic'),
              ('ENTCAT', '*Entitic Catalytic Activity'),
              ('ENTNUM', '*Entitic Number'),
              ('ENTSUB', '*Entitic Substance of Amount'),
              ('ENTVOL', '*Entitic Volume'),
              ('EQL', 'Equilibrium'),
              ('FORCE', 'Mechanical force'),
              ('FREQ', 'Frequency'),
              ('IMP', 'Impression/ interpretation of study'),
              ('KINV', '*Kinematic Viscosity'),
              ('LEN', 'Length'),
              ('LINC', '*Length Increment'),
              ('LIQ', '*Liquifaction'),
              ('MASS', '*Mass'),
              ('MCNC', '*Mass Concentration'),
              ('MCNT', 'Mass Content'),
              ('MCRTO', '*Mass Concentration Ratio'),
              ('MFR', '*Mass Fraction'),
              ('MGFLUX', 'Magnetic flux'),
              ('MINC', '*Mass Increment'),
              ('MORPH', 'Morphology'),
              ('MOTIL', 'Motility'),
              ('MRAT', '*Mass Rate'),
              ('MRTO', '*Mass Ratio'),
              ('NCNC', '*Number Concentration'),
              ('NCNT', '*Number Content'),
              ('NFR', '*Number Fraction'),
              ('NRTO', '*Number Ratio'),
              ('NUM', '*Number'),
              ('OD', 'Optical density'),
              ('OSMOL', '*Osmolality'),
              ('PRES', '*Pressure (Partial)'),
              ('PRID', 'Presence/Identity/Existence'),
              ('PWR', 'Power (wattage)'),
              ('RANGE', '*Ranges'),
              ('RATIO', '*Ratios'),
              ('RCRLTM', '*Reciprocal Relative Time'),
              ('RDEN', '*Relative Density'),
              ('REL', '*Relative'),
              ('RLMCNC', '*Relative Mass Concentration'),
              ('RLSCNC', '*Relative Substance Concentration'),
              ('RLTM', '*Relative Time'),
              ('SATFR', '*Saturation Fraction'),
              ('SCNC', '*Substance Concentration'),
              ('SCNCIN', '*Substance Concentration Increment'),
              ('SCNT', '*Substance Content'),
              ('SCNTR', '*Substance Content Rate'),
              ('SCRTO', '*Substance Concentration Ratio'),
              ('SFR', '*Substance Fraction'),
              ('SHAPE', 'Shape'),
              ('SMELL', 'Smell'),
              ('SRAT', '*Substance Rate'),
              ('SRTO', '*Substance Ratio'),
              ('SUB', '*Substance Amount'),
              ('SUSC', '*Susceptibility'),
              ('TASTE', 'Taste'),
              ('TEMP', '*Temperature'),
              ('TEMPDF', '*Temperature Difference'),
              ('TEMPIN', '*Temperature Increment'),
              ('THRMCNC', '*Threshold Mass Concentration'),
              ('THRSCNC', '*Threshold Substance Concentration'),
              ('TIME', '*Time (e.g. seconds)'),
              ('TITR', '*Dilution Factor (Titer)'),
              ('TMDF', '*Time Difference'),
              ('TMSTP', '*Time Stamp -- Date and Time'),
              ('TRTO', '*Time Ratio'),
              ('TYPE', '*Type'),
              ('VCNT', '*Volume Content'),
              ('VEL', '*Velocity'),
              ('VELRT', '*Velocity Ratio'),
              ('VFR', '*Volume Fraction'),
              ('VISC', '*Viscosity'),
              ('VOL', '*Volume'),
              ('VRAT', '*Volume Rate'),
              ('VRTO', '*Volume Ratio'))),
 'HL70255': ('Duration categories',
             (('12H', '12 hours'),
              ('1H', '1 hour'),
              ('1L', '1 months (30 days)'),
              ('1W', '1 week'),
              ('24H', '24 hours'),
              ('2.5H', '2,5 hours'),
              ('2D', '2 days'),
              ('2H', '2 hours'),
              ('2L', '2 months'),
              ('2W', '2 weeks'),
              ('30M', '30 minutes'),
              ('3D', '3 days'),
              ('3H', '3 hours'),
              ('3L', '3 months'),
              ('3W', '3 weeks'),
              ('4D', '4 days'),
              ('4H', '4 hours'),
              ('4W', '4 weeks'),
              ('5D', '5 days'),
              ('5H', '5 hours'),
              ('6D', '6 days'),
              ('6H', '6 hours'),
              ('7H', '7 hours'),
              ('8H', '8 hours'),
              ('PT',
               'To identify measures at a point in time.  This is a synonym for "spot" or "random" as applied to urine measurements.'),
              ('* (star)', 'Life of the "unit."  Used for blood products.'))),
 'HL70256': ('Time delay post challenge',
             (('10D', '10 days'),
              ('10M', '10 minutes post challenge'),
              ('12H', '12 hours post challenge'),
              ('15M', '15 minutes post challenge'),
              ('1H', '1 hour post challenge'),
              ('1L', '1 month (30 days) post challenge'),
              ('1M', '1 minute post challenge'),
              ('1W', '1 week'),
              ('20M', '20 minutes post challenge'),
              ('24H', '24 hours post challenge'),
              ('2.5H', '2 1/2 hours post challenge'),
              ('25M', '25 minutes post challenge'),
              ('2D', '2 days'),
              ('2H', '2 hours post challenge'),
              ('2L', '2 months (60 days) post challenge'),
              ('2M', '2 minutes post challenge'),
              ('2W', '2 weeks'),
              ('30M', '30 minutes post challenge'),
              ('3D', '3 days'),
              ('3H', '3 hours post challenge'),
              ('3L', '3 months (90 days) post challenge'),
              ('3M', '3 minutes post challenge'),
              ('3W', '3 weeks'),
              ('4D', '4 days'),
              ('4H', '4 hours post challenge'),
              ('4M', '4 minutes post challenge'),
              ('4W', '4 weeks'),
              ('5D', '5 days'),
              ('5H', '5  hours post challenge'),
              ('5M', '5 minutes post challenge'),
              ('6D', '6 days'),
              ('6H', '6 hours post challenge'),
              ('6M', '6 minutes post challenge'),
              ('7D', '7 days'),
              ('7H', '7 hours post challenge'),
              ('7M', '7 minutes post challenge'),
              ('8H', '8 hours post challenge'),
              ('8H SHIFT', '8 hours aligned on nursing shifts'),
              ('8M', '8 minutes post challenge'),
              ('9M', '9 minutes post challenge'),
              ('BS', 'Baseline (time just before the challenge)'),
              ('PEAK',
               'The time post drug dose at which the highest drug level is reached (differs by drug)'),
              ('RANDOM',
               'Time from the challenge, or dose not specified. (random)'),
              ('TROUGH',
               'The time post drug dose at which the lowest drug level is reached (varies with drug)'))),
 'HL70257': ('Nature of challenge',
             (('CFST',
               'Fasting (no calorie intake) for the period specified in the time component of the term, e.g., 1H POST  CFST'),
              ('EXCZ',
               'Exercise undertaken as challenge (can be quantified)'),
              ('FFST',
               'No fluid intake for the period specified in the time component of the term'))),
 'HL70258': ('Relationship modifier',
             (('BPU', 'Blood product unit'),
              ('CONTROL', 'Control'),
              ('DONOR', 'Donor'),
              ('PATIENT', 'Patient'))),
 'HL70259': ('Modality',
             (('AS', 'Angioscopy'),
              ('BS', 'Biomagnetic imaging'),
              ('CD', 'Color flow doppler'),
              ('CP', 'Colposcopy'),
              ('CR', 'Computed radiography'),
              ('CS', 'Cystoscopy'),
              ('CT', 'Computed tomography'),
              ('DD', 'Duplex doppler'),
              ('DG', 'Diapanography'),
              ('DM', 'Digital microscopy'),
              ('EC', 'Echocardiography'),
              ('ES', 'Endoscopy'),
              ('FA', 'Fluorescein angiography'),
              ('FS', 'Fundoscopy'),
              ('LP', 'Laparoscopy'),
              ('LS', 'Laser surface scan'),
              ('MA', 'Magnetic resonance angiography'),
              ('MS', 'Magnetic resonance spectroscopy'),
              ('NM', 'Nuclear Medicine (radioisotope study)'),
              ('OT', 'Other'),
              ('PT', 'Positron emission tomography (PET)'),
              ('RF', 'Radio fluoroscopy'),
              ('ST', 'Single photon emission computed tomography (SPECT)'),
              ('TG', 'Thermography'),
              ('US', 'Ultrasound'),
              ('XA', 'X-ray Angiography'))),
 'HL70260': ('Patient location type',
             (('B', 'Bed'),
              ('C', 'Clinic'),
              ('D', 'Department'),
              ('E', 'Exam Room'),
              ('L', 'Other Location'),
              ('N', 'Nursing Unit'),
              ('O', 'Operating Room'),
              ('R', 'Room'))),
 'HL70261': ('Location equipment',
             (('EEG', 'Electro-Encephalogram'),
              ('EKG', 'Electro-Cardiogram'),
              ('INF', 'Infusion pump'),
              ('IVP', 'IV pump'),
              ('OXY', 'Oxygen'),
              ('SUC', 'Suction'),
              ('VEN', 'Ventilator'),
              ('VIT', 'Vital signs monitor'))),
 'HL70262': ('Privacy level',
             (('F', 'Isolation'),
              ('J', 'Private room - medically justified'),
              ('P', 'Private room'),
              ('Q', 'Private room - due to overflow'),
              ('S', 'Semi-private room'),
              ('W', 'Ward'))),
 'HL70263': ('Level of care',
             (('A', 'Ambulatory'),
              ('C', 'Critical care'),
              ('E', 'Emergency'),
              ('F', 'Isolation'),
              ('N', 'Intensive care'),
              ('R', 'Routine'),
              ('S', 'Surgery'))),
 'HL70265': ('Specialty type',
             (('ALC', 'Allergy'),
              ('AMB', 'Ambulatory'),
              ('CAN', 'Cancer'),
              ('CAR', 'Coronary/cardiac care'),
              ('CCR', 'Critical care'),
              ('CHI', 'Chiropractic'),
              ('EDI', 'Education'),
              ('EMR', 'Emergency'),
              ('FPC', 'Family planning'),
              ('INT', 'Intensive care'),
              ('ISO', 'Isolation'),
              ('NAT', 'Naturopathic'),
              ('NBI', 'Newborn, nursery, infants'),
              ('OBG', 'Obstetrics, gynecology'),
              ('OBS', 'Observation'),
              ('OTH', 'Other specialty'),
              ('PED', 'Pediatrics'),
              ('PHY', 'General/family practice'),
              ('PIN', 'Pediatric/neonatal intensive care'),
              ('PPS', 'Pediatric psychiatric'),
              ('PRE', 'Pediatric rehabilitation'),
              ('PSI', 'Psychiatric intensive care'),
              ('PSY', 'Psychiatric'),
              ('REH', 'Rehabilitation'),
              ('SUR', 'Surgery'),
              ('WIC', 'Walk-in clinic'))),
 'HL70267': ('Days of the Week',
             (('FRI', 'Friday'),
              ('MON', 'Monday'),
              ('SAT', 'Saturday'),
              ('SUN', 'Sunday'),
              ('THU', 'Thursday'),
              ('TUE', 'Tuesday'),
              ('WED', 'Wednesday'))),
 'HL70268': ('Override',
             (('A', 'Override allowed'),
              ('R', 'Override required'),
              ('X', 'Override not allowed'))),
 'HL70269': ('Charge on indicator',
             (('O', 'Charge on Order'), ('R', 'Charge on Result'))),
 'HL70270': ('Document type',
             (('AR', 'Autopsy report'),
              ('CD', 'Cardiodiagnostics'),
              ('CN', 'Consultation'),
              ('DI', 'Diagnostic imaging'),
              ('DS', 'Discharge summary'),
              ('ED', 'Emergency department report'),
              ('HP', 'History and physical examination'),
              ('OP', 'Operative report'),
              ('PC', 'Psychiatric consultation'),
              ('PH', 'Psychiatric history and physical examination'),
              ('PN', 'Procedure note'),
              ('PR', 'Progress note'),
              ('SP', 'Surgical pathology'),
              ('TS', 'Transfer summary'))),
 'HL70271': ('Document completion status',
             (('AU', 'Authenticated'),
              ('DI', 'Dictated'),
              ('DO', 'Documented'),
              ('IN', 'Incomplete'),
              ('IP', 'In Progress'),
              ('LA', 'Legally authenticated'),
              ('PA', 'Pre-authenticated'))),
 'HL70272': ('Document confidentiality status',
             (('R', 'Restricted'),
              ('U', 'Usual control'),
              ('V', 'Very restricted'))),
 'HL70273': ('Document availability status',
             (('AV', 'Available for patient care'),
              ('CA', 'Deleted'),
              ('OB', 'Obsolete'),
              ('UN', 'Unavailable for patient care'))),
 'HL70275': ('Document storage status',
             (('AA', 'Active and archived'),
              ('AC', 'Active'),
              ('AR', 'Archived (not active)'),
              ('PU', 'Purged'))),
 'HL70276': ('Appointment reason codes',
             (('CHECKUP', 'A routine check-up, such as an annual physical'),
              ('EMERGENCY', 'Emergency appointment'),
              ('FOLLOWUP', 'A follow up visit from a previous appointment'),
              ('ROUTINE', 'Routine appointment - default if not valued'),
              ('WALKIN', 'A previously unscheduled walk-in visit'))),
 'HL70277': ('Appointment type codes',
             (('Complete',
               'A request to add a completed appointment, used to maintain records of completed appointments'),
              ('Normal',
               'Routine schedule request type - default if not valued'),
              ('Tentative',
               "A request for a tentative (e.g., 'penciled in') appointment"))),
 'HL70278': ('Filler status codes',
             (('Blocked', 'The indicated time slot(s) is(are) blocked'),
              ('Booked', 'The indicated appointment is booked'),
              ('Cancelled',
               'T7he indicated appointment was stopped from occurring (canceled prior to starting)'),
              ('Complete',
               'The indicated appointment has completed normally (was not discontinued, canceled, or deleted)'),
              ('Dc',
               'The indicated appointment was discontinued (DC while in progress, discontinued parent appointment, or discontinued child appointment)'),
              ('Deleted',
               'The indicated appointment was deleted from the filler application'),
              ('Overbook',
               'The appointment has been confirmed; however it is confirmed in an overbooked state'),
              ('Pending', 'Appointment has not yet been confirmed'),
              ('Started',
               'The indicated appointment has begun and is currently in progress'),
              ('Waitlist',
               'Appointment has been placed on a waiting list for a particular slot, or set of slots'))),
 'HL70279': ('Allow substitution codes',
             (('Confirm',
               'Contact the Placer Contact Person prior to making any substitutions of this resource'),
              ('No', 'Substitution of this resource is not allowed'),
              ('Notify',
               'Notify the Placer Contact Person, through normal institutional procedures, that a substitution of this resource has been made'),
              ('Yes', 'Substitution of this resource is allowed'))),
 'HL70280': ('Referral priority',
             (('A', 'ASAP'), ('R', 'Routine'), ('S', 'STAT'))),
 'HL70281': ('Referral type',
             (('Hom', 'Home Care'),
              ('Lab', 'Laboratory'),
              ('Med', 'Medical'),
              ('Psy', 'Psychiatric'),
              ('Rad', 'Radiology'),
              ('Skn', 'Skilled Nursing'))),
 'HL70282': ('Referral disposition',
             (('AM', 'Assume Management'),
              ('RP', 'Return Patient After Evaluation'),
              ('SO', 'Second Opinion'),
              ('WR', 'Send Written Report'))),
 'HL70283': ('Referral Status',
             (('A', 'Accepted'),
              ('E', 'Expired'),
              ('P', 'Pending'),
              ('R', 'Rejected'))),
 'HL70284': ('Referral category',
             (('A', 'Ambulatory'),
              ('E', 'Emergency'),
              ('I', 'Inpatient'),
              ('O', 'Outpatient'))),
 'HL70286': ('Provider role',
             (('CP', 'Consulting Provider'),
              ('PP', 'Primary Care Provider'),
              ('RP', 'Referring Provider'),
              ('RT', 'Referred to Provider'))),
 'HL70287': ('Problem/Goal Action code',
             (('AD', 'ADD'),
              ('CO', 'CORRECT'),
              ('DE', 'DELETE'),
              ('LI', 'LINK'),
              ('UC', 'UNCHANGED *'),
              ('UN', 'UNLINK'),
              ('UP', 'UPDATE'))),
 'HL70291': ('Subtype of referenced data',
             (('BASIC', 'ISDN PCM audio data'),
              ('DICOM', 'Digital Imaging and Communications in Medicine'),
              ('FAX', 'Facsimile data'),
              ('GIF', 'Graphics Interchange Format'),
              ('HTML', 'Hypertext Markup Language'),
              ('JOT', 'Electronic ink data (Jot 1.0 standard)'),
              ('JPEG', 'Joint Photographic Experts Group'),
              ('Octet-stream', 'Uninterpreted binary data'),
              ('PICT', 'PICT format image data'),
              ('PostScript', 'PostScript program'),
              ('RTF', 'Rich Text Format'),
              ('SGML',
               'Structured General Markup Language (HL7 V2.3.1 and later)'),
              ('TIFF', 'TIFF image data'),
              ('XML', 'Extensible Markup Language (HL7 V2.3.1 and later)'))),
 'HL70292': ('Vaccines administered (code = CVX)(parenteral, unless oral is noted)',
             (('01', 'DTP'),
              ('02', 'OPV'),
              ('03', 'MMR'),
              ('04', 'M/R'),
              ('05', 'Measles'),
              ('06', 'Rubella'),
              ('07', 'Mumps'),
              ('08', 'Hep B, adolescent or pediatric'),
              ('09', 'Td (Adult)'),
              ('10', 'IPV'),
              ('11', 'Pertussis'),
              ('12', 'Diphtheria antitoxin'),
              ('13', 'TIG'),
              ('14', 'IG, NOS'),
              ('15', "Influenza'split (incl. purified surface antigen)"),
              ('16', "Influenza'whole"),
              ('17', 'Hib,  NOS'),
              ('18', 'Rabies, intramuscular injection'),
              ('19', 'BCG'),
              ('20', 'DTaP'),
              ('21', 'Varicella'),
              ('22', 'DTP-Hib'),
              ('23', 'Plague'),
              ('24', 'Anthrax'),
              ('25', "Typhoid'oral"),
              ('26', 'Cholera'),
              ('27', 'Botulinum antitoxin'),
              ('28', 'DT(pediatric)'),
              ('29', 'CMVIG'),
              ('30', 'HBIG'),
              ('31', 'Hep A, pediatric, NOS'),
              ('32', 'Meningococcal'),
              ('33', 'Pneumococcal'),
              ('34', 'RIG'),
              ('35', 'Tetanus toxoid'),
              ('36', 'VZIG'),
              ('37', 'Yellow fever'),
              ('38', 'Rubella/Mumps'),
              ('39', 'Japanese encephalitis'),
              ('40', 'Rabies, intradermal injection'),
              ('41', "Typhoid'parenteral"),
              ('42', 'Hep B, adolescent/high risk infant'),
              ('43', 'Hep B, adult'),
              ('44', 'Hep B, dialysis'),
              ('45', 'Hep B,  NOS'),
              ('46', 'Hib (PRP-D)'),
              ('47', 'Hib (HbOC)'),
              ('48', 'Hib (PRP-T)'),
              ('49', 'Hib (PRP-OMP)'),
              ('50', 'DtaP-Hib'),
              ('51', 'Hib-Hep B'),
              ('52', 'Hep A - adult'),
              ('53', 'Typhoid, parenteral, AKD (U.S. military)'),
              ('54', 'Adenovirus, type 4'),
              ('55', 'Adenovirus, type 7'),
              ('56', 'Dengue fever'),
              ('57', 'Hantavirus'),
              ('58', 'Hep C'),
              ('59', 'Hep E'),
              ('60', 'Herpes simplex 2'),
              ('61', 'HIV'),
              ('62', 'HPV'),
              ('63', 'Junin virus'),
              ('64', 'Leishmaniasis'),
              ('65', 'Leprosy'),
              ('66', 'Lyme disease'),
              ('67', 'Malaria'),
              ('68', 'Melanoma'),
              ('69', 'Parainfluenza-3'),
              ('70', 'Q fever'),
              ('71', 'RSV-IGIV'),
              ('72', 'Rheumatic fever'),
              ('73', 'Rift Valley fever'),
              ('74', 'Rotavirus'),
              ('75', 'Smallpox'),
              ('76', 'Staphylococcus bacterio lysate'),
              ('77', 'Tick-borne encephalitis'),
              ('78', 'Tularemia vaccine'),
              ('79', 'Vaccinia immune globulin'),
              ('80', 'VEE, live'),
              ('81', 'VEE, inactivated'),
              ('82', 'Adenovirus, NOS'),
              ('83', 'Hep A, ped/adol, 2 dose'),
              ('84', 'Hep A, ped/adol, 3 dose'),
              ('85', 'Hep A, NOS'),
              ('86', 'IG'),
              ('87', 'IGIV'),
              ('88', 'Influenza, NOS'),
              ('89', 'Polio, NOS'),
              ('90', 'Rabies, NOS'),
              ('91', 'Typhoid, NOS'),
              ('92', 'VEE, NOS'))),
 'HL70294': ('Time selection criteria parameter class codes',
             (('FRI',
               'An indicator that Friday is or is not preferred for the day on which the appointment will occur.  OK =  Preferred appointment day NO = Day is not preferred'),
              ('MON',
               'An indicator that Monday is or is not preferred for the day on which the appointment will occur.  OK = Preferred appointment day NO = Day is not preferred'),
              ('PREFEND',
               'The preferred end time for the appointment request, service or resource.  Any legal time specification in the format HHMM, using 24-hour clock notation'),
              ('PREFSTART',
               'The preferred start time for the appointment request, service or resource.   Any legal time specification in the format HHMM, using 24-hour clock notation'),
              ('SAT',
               'An indicator that Saturday is or is not preferred for the day on which the appointment will occur.  OK =  Preferred appointment day NO = Day is not preferred'),
              ('SUN',
               'An indicator that Sunday is or is not preferred for the day on which the appointment will occur.  OK = Preferred appointment day NO = Day is not preferred'),
              ('THU',
               'An indicator that Thursday is or is not preferred for the day on which the appointment will occur.  OK = Preferred appointment day NO = Day is not preferred'),
              ('TUE',
               'An indicator that Tuesday is or is not preferred for the day on which the appointment will occur.  OK = Preferred appointment day NO = Day is not preferred'),
              ('WED',
               'An indicator that Wednesday is or is not preferred for the day on which the appointment will occur. OK = Preferred appointment day NO = Day is not preferred'))),
 'HL70298': ('CP range type',
             (('F',
               'Flat-rate.  Apply the entire price to this interval, do not pro-rate the price if the full interval has not occurred/been consumed'),
              ('P',
               'Pro-rate.  Apply this price to this interval, pro-rated by whatever portion of the interval has occurred/been consumed'))),
 'HL70299': ('Encoding',
             (('A', 'no encoding - data are displayable ASCII characters.'),
              ('Base64',
               'encoding as defined by MIME (Multipurpose Internet Mail Extensions) standard RFC 1521.  Four consecutive ASCII characters represent three consecutive octets of binary data.  Base64 utilizes a 65-character subset of US-ASCII, consisting of both the upper a'),
              ('Hex',
               'hexadecimal encoding - consecutive pairs of hexadecimal digits represent consecutive single octets.'))),
 'HL70301': ('Universal ID type',
             (('DNS',
               'An Internet dotted name. Either in ASCII or as integers'),
              ('GUID', 'Same as UUID.'),
              ('HCD',
               'The CEN Healthcare Coding Scheme Designator. (Identifiers used in DICOM follow this assignment scheme.)'),
              ('HL7', 'Reserved for future HL7 registration schemes'),
              ('ISO',
               'An International Standards Organization Object Identifier'),
              ('L,M,N',
               'These are reserved for locally defined coding schemes.'),
              ('Random',
               'Usually a base64 encoded string of random bits.  The uniqueness depends on the length of the bits.  Mail systems often generate ASCII string  "unique names," from a  combination of random bits and system names.  Obviously, such identifiers will not be con'),
              ('UUID', 'The DCE Universal Unique Identifier'),
              ('x400', 'An X.400 MHS format identifier'),
              ('x500', 'An X.500 directory name'))),
 'HL70309': ('Coverage type',
             (('B', 'Both hospital and physician'),
              ('H', 'Hospital/institutional'),
              ('P', 'Physician/professional'))),
 'HL70315': ('Living will',
             (('F', 'Yes, patient has a living will but it is not on file'),
              ('I',
               'No, patient does not have a living will but information was provided'),
              ('N',
               'No, patient does not have a living will and no information was provided'),
              ('U', 'Unknown'),
              ('Y', 'Yes, patient has a living will'))),
 'HL70316': ('Organ donor',
             (('F', 'Yes, patient is a donor, but card is not on file'),
              ('I',
               'No, patient does not have a living will but information was provided'),
              ('U', 'Unknown'),
              ('Y', 'Yes, patient is a donor and card is on file'))),
 'HL70317': ('Annotations',
             (('9900', 'Pace spike'),
              ('9901', 'SAS marker'),
              ('9902', 'Sense marker'),
              ('9903', 'Beat marker'),
              ('9904', 'etc.'))),
 'HL70321': ('Dispense method',
             (('AD', 'Automatic Dispensing'),
              ('F', 'Floor Stock'),
              ('TR', 'Traditional'),
              ('UD', 'Unit Dose'))),
 'HL70322': ('Completion status',
             (('CP', 'Complete'),
              ('NA', 'Not Administered'),
              ('PA', 'Partially Administered'),
              ('RE', 'Refused'))),
 'HL70323': ('Action code', (('A', 'Add'), ('D', 'Delete'), ('U', 'Update'))),
 'HL70324': ('Location characteristic ID',
             (('GEN', 'Gender of patient(s)'),
              ('IMP', 'Implant: can be used for radiation implant patients'),
              ('INF',
               'Infectious disease: this location can be used for isolation'),
              ('LCR', 'Level of care'),
              ('LIC', 'Licensed'),
              ('OVR', 'Overflow'),
              ('PRL',
               'Privacy level: indicating the level of private versus non-private room'),
              ('SET', 'Bed is set up'),
              ('SHA',
               'Shadow: a temporary holding location that does not physically exist'),
              ('SMK', 'Smoking'),
              ('STF', 'Bed is staffed'),
              ('TEA', 'Teaching location'))),
 'HL70325': ('Location relationship ID',
             (('ALI', 'Location Alias(es)'),
              ('DTY', 'Nearest  dietary'),
              ('LAB', 'Nearest  lab'),
              ('LB2', 'Second lab'),
              ('PAR', 'Parent location'),
              ('RX', 'Nearest  pharmacy'),
              ('RX2', 'Second pharmacy'))),
 'HL70326': ('Visit indicator',
             (('A', 'Account level (default)'), ('V', 'Visit level'))),
 'HL70329': ('Quantity method',
             (('A', 'Actual count'), ('E', 'Estimated (see comment)'))),
 'HL70330': ('Marketing basis',
             (('510E', '510 (K) exempt'),
              ('510K', '510 (K)'),
              ('522S', 'Post marketing study (522)'),
              ('PMA', 'Premarketing authorization'),
              ('PRE', 'Preamendment'),
              ('TXN', 'Transitional'))),
 'HL70331': ('Facility type',
             (('A', 'Agent for a foreign manufacturer'),
              ('D', 'Distributor'),
              ('M', 'Manufacturer'),
              ('U', 'User'))),
 'HL70333': ('Network change type',
             (('M', 'Migrates to different CPU'),
              ('SD', 'Shut down'),
              ('SU', 'Start up'))),
 'HL70334': ('Disabled person',
             (('AP', 'Associated party'),
              ('GT', 'Guarantor'),
              ('IN', 'Insured'),
              ('PT', 'Patient'))),
 'HL70336': ('Referral reason',
             (('O', 'Provider Ordered'),
              ('P', 'Patient Preference'),
              ('S', 'Second Opinion'),
              ('W', 'Work Load'))),
 'HL70337': ('Certification Status', (('C', 'Certified'), ('E', 'Eligible'))),
 'HL70338': ('Practitioner ID number type',
             (('CY', 'County number'),
              ('DEA', 'Drug Enforcement Agency no.'),
              ('GL', 'General ledger number'),
              ('L&I', 'Labor and industries number'),
              ('MCD', 'Medicaid number'),
              ('MCR', 'Medicare number'),
              ('QA', 'QA number'),
              ('SL', 'State license number'),
              ('TAX', 'Tax ID number'),
              ('TRL', 'Training license number'),
              ('UPIN', 'Unique physician ID no.'))),
 'HL70339': ('Advanced Beneficiary Notice Code',
             (('1', 'Service is subject to medical necessity procedures'),
              ('2',
               'Patient has been informed of responsibility, and agrees to pay for service'),
              ('3',
               'Patient has been informed of responsibility, and asks that the payer be billed'),
              ('4', 'Advanced Beneficiary Notice has not been signed'))),
 'HL70344': ("Patient's relationship to insured",
             (('01', 'Patient is insured'),
              ('02', 'Spouse'),
              ('03', 'Natural child/insured financial responsibility'),
              ('04',
               'Natural child/Insured does not have financial responsibility'),
              ('05', 'Step child'),
              ('06', 'Foster child'),
              ('07', 'Ward of the court'),
              ('08', 'Employee'),
              ('09', 'Unknown'),
              ('10', 'Handicapped dependent'),
              ('11', 'Organ donor'),
              ('12', 'Cadaver donor'),
              ('13', 'Grandchild'),
              ('14', 'Niece/nephew'),
              ('15', 'Injured plaintiff'),
              ('16', 'Sponsored dependent'),
              ('17', 'Minor dependent of a minor dependent'),
              ('18', 'Parent'),
              ('19', 'Grandparent'))),
 'HL70348': ('Special program indicator',
             (('01', 'EPSDT-CHAP'),
              ('02', "Physically handicapped children's program"),
              ('03', 'Special federal funding'),
              ('04', 'Family planning'),
              ('05', 'Disability'),
              ('06', 'PPV/Medicare 100% payment'),
              ('07', 'Induced abortion-danger to life'),
              ('08', 'Induced abortion victim rape/incest'))),
 'HL70349': ('PSRO/UR approval indicator',
             (('1', 'Approved by the PSRO/UR as billed'),
              ('2', 'Automatic approval as billed based on focused review'),
              ('3', 'Partial approval'),
              ('4', 'Admission denied'),
              ('5', 'Postpayment review applicable'))),
 'HL70350': ('Occurrence code',
             (('01', 'Auto accident'),
              ('02',
               'No fault insurance involved-including auto accident/other'),
              ('03', 'Accident/tort liability'),
              ('04', 'Accident/employment related'),
              ('05', 'Other accident'),
              ('06', 'Crime victim'),
              ('09', 'Start of infertility treatment cycle'),
              ('10', 'Last menstrual period'),
              ('11', 'Onset of symptoms/illness'),
              ('12', 'Date of onset for a chronically dependent individual'),
              ('17',
               'Date outpatient occupational therapy plan established or last reviewed'),
              ('18', 'Date of retirement patient/beneficiary'),
              ('19', 'Date of retirement spouse'),
              ('20', 'Guarantee of payment began'),
              ('21', 'UR notice received'),
              ('22', 'Date active care ended'),
              ('24', 'Date insurance denied'),
              ('25', 'Date benefits terminated by primary payor'),
              ('26', 'Date SNF bed available'),
              ('27', 'Date home health plan established'),
              ('28', "Spouse's date of birth"),
              ('29',
               'Date outpatient physical therapy plan established or last reviewed'),
              ('30',
               'Date outpatient speech pathology plan established or last reviewed'),
              ('31',
               'Date beneficiary notified of intent to bill (accommodations)'),
              ('32',
               'Date beneficiary notified of intent to bill (procedures or treatments)'),
              ('33',
               'First day of the Medicare coordination period for ESRD beneficiaries covered by EGHP'),
              ('34', 'Date of election of extended care facilities'),
              ('35', 'Date treatment started for P.T.'),
              ('36',
               'Date of inpatient hospital discharge for covered transplant patients'),
              ('37',
               'Date of inpatient hospital discharge for non-covered transplant patient'),
              ('40', 'Scheduled date of admission'),
              ('41', 'Date of first test for pre-admission testing'),
              ('42', 'Date of discharge'),
              ('43', 'Scheduled date of canceled surgery'),
              ('44', 'Date treatment started for O.T.'),
              ('45', 'Date treatment started for S.T.'),
              ('46', 'Date treatment started for cardiac rehab.'),
              ('47 ... 49', 'Payer codes'),
              ('50', 'Date lien released'),
              ('51', 'Date treatment started for psychiatric care'),
              ('70 ... 99', 'Occurrence span codes and dates'),
              ('A1', 'Birthdate - insured A'),
              ('A2', 'Effective date - insured A policy'),
              ('A3', 'Benefits exhausted payer A'))),
 'HL70351': ('Occurrence span',
             (('70', 'Qualifying stay dates for SNF'),
              ('71', 'Prior stay dates'),
              ('72', 'First/last visit'),
              ('73', 'Benefit eligibility period'),
              ('74', 'Non-covered level of care'),
              ('75', 'SNF level of care'),
              ('76', 'Patient liability'),
              ('77', 'Provider liability period'),
              ('78', 'SNF prior stay dates'),
              ('79', 'Payer code'),
              ('M0', 'PRO/UR approved stay dates'))),
 'HL70353': ('CWE statuses',
             (('NA', 'Not applicable'),
              ('NASK', 'Not asked'),
              ('NAV', 'Not available'),
              ('U', 'Unknown'),
              ('UASK', 'Asked but Unknown'))),
 'HL70354': ('Message structure',
             (('ACK', ''),
              ('ADT_A01', 'A01, A04, A05, A08, A13, A14, A28, A31'),
              ('ADT_A02',
               'A02, A21, A22, A23, A25, A26, A27, A29, A32, A33'),
              ('ADT_A03', 'A03'),
              ('ADT_A06', 'A06, A07'),
              ('ADT_A09', 'A09, A10, A11, A15'),
              ('ADT_A12', 'A12'),
              ('ADT_A16', 'A16'),
              ('ADT_A17', 'A17'),
              ('ADT_A18', 'A18'),
              ('ADT_A20', 'A20'),
              ('ADT_A24', 'A24'),
              ('ADT_A28', 'A28, A31'),
              ('ADT_A30', 'A30, A34, A35, 136, A46, A47, A48, A49'),
              ('ADT_A37', 'A37'),
              ('ADT_A38', 'A38'),
              ('ADT_A39', 'A39, A40, A41, A42'),
              ('ADT_A43', 'A43, A44'),
              ('ADT_A45', 'A45'),
              ('ADT_A50', 'A50, A51'),
              ('ARD_A19', 'A19'),
              ('BAR_P01', 'P01, P05'),
              ('BAR_P02', 'P02'),
              ('BAR_P06', 'P06'),
              ('CRM_C01', 'C01, C02, C03, C04, C05, C06, C07, C08'),
              ('CSU_C09', 'C09, C10, C11, C12'),
              ('DFT_P03', 'P03'),
              ('DOC_T12', 'T12'),
              ('DSR_Q01', 'Q01'),
              ('DSR_Q03', 'Q03'),
              ('EDR_R07', 'R07'),
              ('EQQ_Q04', 'Q04'),
              ('ERP_R09', 'R09'),
              ('MDM_T01', 'T01, T03, T05, T07, T09, T11'),
              ('MDM_T02', 'T02, T04, T06, T08, T10'),
              ('MFD_P09', 'P09'),
              ('MFK_M01', 'M01, M03, M05, M06, M07, M08, M09, M10, M11'),
              ('MFN_M01', 'M01'),
              ('MFN_M02', 'M02'),
              ('MFN_M03', 'M03'),
              ('MFN_M05', 'M05'),
              ('MFN_M06', 'M06'),
              ('MFN_M07', 'M07'),
              ('MFN_M08', 'M08'),
              ('MFN_M09', 'M09'),
              ('MFN_M10', 'M10'),
              ('MFN_M11', 'M11'),
              ('NUL', 'Null'),
              ('OMD_O01', ''),
              ('OMN_O01', ''),
              ('OMS_O01', ''),
              ('ORD_O02', ''),
              ('ORF_R02', 'R02, R04'),
              ('ORM_O01', 'O01'),
              ('ORM_Q06', 'Q06'),
              ('ORN_O02', ''),
              ('ORR_O02', 'O02'),
              ('ORR_Q06', 'Q06'),
              ('ORS_O02', ''),
              ('ORU_R01', 'R01'),
              ('ORU_W01', 'W01'),
              ('OSQ_Q06', 'Q06'),
              ('OSR_Q06', 'Q06'),
              ('PEX_P07', 'P07, P08'),
              ('PGL_PC6', 'PC6, PC7, PC8'),
              ('PIN_I07', 'I07'),
              ('PPG_PCG', 'PCC, PCH, PCJ'),
              ('PPP_PCB', 'PCB, PCD'),
              ('PPR_PC1', 'PC1, PC2, PC3'),
              ('PPT_PCL', 'PCL'),
              ('PPV_PCA', 'PCA'),
              ('PRR_PC5', 'PC5'),
              ('PTR_PCF', 'PCF'),
              ('QCK_Q02', 'Q02'),
              ('QRY_A19', 'A19'),
              ('QRY_PC4', 'PC4, PC9, PCE, PCK'),
              ('QRY_Q01', 'Q01'),
              ('QRY_Q02', 'Q02'),
              ('QRY_R02', 'R02, R04'),
              ('QRY_T12', 'T12'),
              ('RAR_RAR', 'RAR'),
              ('RAS_O01', 'O01'),
              ('RAS_O02', 'O022'),
              ('RCI_I05', 'I05'),
              ('RCL_I06', 'I06'),
              ('RDE_O01', 'O01'),
              ('RDO_O01', ''),
              ('RDR_RDR', 'RDR'),
              ('RDS_O01', 'O01'),
              ('REF_I12', 'I12, I13, I14, I15'),
              ('RER_RER', 'RER'),
              ('RGR_RGR', 'RGR'),
              ('RGV_O01', 'O01'),
              ('ROR_ROR', 'ROR'),
              ('RPA_I08', 'I08, I09. I10, 1II'),
              ('RPI_I0I', 'I01, I04'),
              ('RPL_I02', 'I02'),
              ('RPR_I03', 'I03'),
              ('RQA_I08', 'I08, I09, I10, I11'),
              ('RQC_I05', 'I05'),
              ('RQC_I06', 'I06'),
              ('RQI_I0I', 'I01, I02, I03'),
              ('RQP_I04', 'I04'),
              ('RQQ_Q09', 'Q09'),
              ('RRA_O02', 'O02'),
              ('RRD_O02', 'O02'),
              ('RRE_O02', 'O02'),
              ('RRG_O02', 'O02'),
              ('RRI_I12', 'I12, I13, I14, I15'),
              ('RRO_O02', ''),
              ('SIU_S12',
               'S12, S13, S14, S15, S16, S17, S18, S19, S20, S21, S22, S23, S24, S26'),
              ('SPQ_Q08', 'Q08'),
              ('SQM_S25', 'S25'),
              ('SQR_S25', 'S25'),
              ('SRM_S01',
               'S01, S02, S03, S04, S05, S06, S07, S08, S09, S10, S11'),
              ('SRM_T12', 'T12'),
              ('SRR_S01',
               'S01, S02, S03, S04, S05, S06, S07, S08, S09, S10, S11'),
              ('SRR_T12', 'T12'),
              ('SUR_P09', 'P09'),
              ('TBR_R09', 'R09'),
              ('UDM_Q05', 'Q05'),
              ('VQQ_Q07', 'Q07'),
              ('VXQ_V01', 'V01'),
              ('VXR_V03', 'V03'),
              ('VXU_V04', 'V04'),
              ('VXX_V02', 'V02'))),
 'HL70355': ('Primary key value type',
             (('CE', 'Coded element'), ('PL', 'Person location'))),
 'HL70356': ('Alternate character set handling scheme',
             (('ISO 2022-199',
               'This standard is titled "Information Technology - Character Code Structure  and Extension Technique". This standard specifies an escape sequence from basic one byte character set to specified other character set, and  vice versa.  The escape sequence expl'),
              ('<null>',
               'This is the default, indicating that there is no character set switching occurring in this message.'))),
 'HL70357': ('Message error condition  codes',
             (('0', 'Message accepted'),
              ('100', 'Segment sequence error'),
              ('101', 'Required field missing'),
              ('102', 'Data type error'),
              ('103', 'Table value not found'),
              ('200', 'Unsupported message type'),
              ('201', 'Unsupported event code'),
              ('202', 'Unsupported processing id'),
              ('203', 'Unsupported version id'),
              ('204', 'Unknown key identifier'),
              ('205', 'Duplicate key identifier'),
              ('206', 'Application record locked'),
              ('207', 'Application internal error'))),
 'HL70359': ('Diagnosis priority',
             (('0', 'not included in diagnosis ranking'),
              ('1', 'the primary diagnosis'),
              ('2 and higher', 'for ranked secondary diagnoses'))),
 'HL70360': ('Degree',
             (('AA', 'Associate of Arts'),
              ('AAS', 'Associate of Applied Science'),
              ('ABA', 'Associate of Business Administration'),
              ('AE', 'Associate of Engineering'),
              ('AS', 'Associate of Science'),
              ('BA', 'Bachelor of Arts'),
              ('BBA', 'Bachelor of Business Administration'),
              ('BE', 'Bachelor or Engineering'),
              ('BFA', 'Bachelor of Fine Arts'),
              ('BN', 'Bachelor of Nursing'),
              ('BS', 'Bachelor of Science'),
              ('BSL', 'Bachelor of Science and Law'),
              ('BT', 'Bachelor of Theology'),
              ('CER', 'Certificate'),
              ('DBA', 'Doctor of Business Administration'),
              ('DED', 'Doctor of Education'),
              ('DIP', 'Diploma'),
              ('DO', 'Doctor of Osteopathy'),
              ('HS', 'High School Graduate'),
              ('JD', 'Juris Doctor'),
              ('MA', 'Master of Arts'),
              ('MBA', 'Master of Business Administration'),
              ('MCE', 'Master of Civil Engineering'),
              ('MD', 'Doctor of Medicine'),
              ('MDI', 'Master of Divinity'),
              ('ME', 'Master of Engineering'),
              ('MED', 'Master of Education'),
              ('MEE', 'Master of Electrical Engineering'),
              ('MFA', 'Master of Fine Arts'),
              ('MME', 'Master of Mechanical Engineering'),
              ('MS', 'Master of Science'),
              ('MSL', 'Master of Science and Law'),
              ('MT', 'Master of Theology'),
              ('NG', 'Non-Graduate'),
              ('PHD', 'Doctor of Philosophy'),
              ('PHE', 'Doctor of Engineering'),
              ('PHS', 'Doctor of Science'),
              ('SEC', 'Secretarial Certificate'),
              ('TS', 'Trade School Graduate'))),
 'HL70364': ('Comment type',
             (('1R', 'Primary Reason'),
              ('2R', 'Secondary Reason'),
              ('AI', 'Ancillary Instructions,'),
              ('DR', 'Duplicate/Interaction Reason'),
              ('GI', 'General Instructions'),
              ('GR', 'General Reason'),
              ('PI', 'Patient Instructions'),
              ('RE', 'Remark'))),
 'HL74000': ('Name/address representation',
             (('A', 'Alphabetic (i.e., Default or some single-byte)'),
              ('I', 'Ideographic (i.e., Kanji)'),
              ('P', 'Phonetic (i.e., ASCII, Katakana, Hiragana, etc.)')))}
