/**
 * @fileoverview
 * (This file was autogenerated by hob)
 */

window.cls || ( window.cls = {} );

/**
  * @constructor 
  */

window.cls.ServiceBase = function ()
{
  // singleton
  if(cls.ServiceBase.instance)
  {
    return cls.ServiceBase.instance;
  }
  cls.ServiceBase.instance = this;

  window.cls.MessageMixin.apply(this); // mix in message handler behaviour.

  this.on_enable_success = function(){};
  this.on_window_filter_change = function(filter){};
  this.on_quit = function(){};
  this.is_implemented = false;

  this.create_and_expose_interface = function(version, map)
  {
    if (map)
    {
      this.version = version;
      for (var cmd_id in map)
      {
        this._expose_method(parseInt(cmd_id), map[cmd_id].name);
      };
      this.is_implemented = true;
      return true;
    }
    return false;
  };

  this._expose_method = function(id, name)
  {
    if (name.slice(0, 2) == 'On')
    {
      this['on' + name.slice(2)] = function(status, message){};
    }
    else
    {
      this['handle' + name] = function(status, message){};
      this['request' + name] = function(tag, message)
      {
        opera.scopeTransmit(this.name, message || [], id, tag || 0);
      };
    }
  };

  var _services = null;
  var _event_map = {};
  
% for service in services:
  % if service.name == "Scope":
  _event_map['${dashed_name(service.name)}'] = [];
    % for command in service.itercommands():
  _event_map['${dashed_name(service.name)}'][${command.id}] = 'handle${command.name}';
    % endfor
    % for event in service.iterevents():
  _event_map['${dashed_name(service.name)}'][${event.id}] = '${event.name.replace('On', 'on')}';
    % endfor
  % endif
% endfor


  var _status_map = [];
  _status_map[0] = "OK";
  _status_map[1] = "Conflict";
  _status_map[2] = "Unsupported Type";
  _status_map[3] = "Bad Request";
  _status_map[4] = "Internal Error";
  _status_map[5] = "Command Not Found";
  _status_map[6] = "Service Not Found";
  _status_map[7] = "Out Of Memory";
  _status_map[8] = "Service Not Enabled";
  _status_map[9] = "Service Already Enabled";

  var _type_map = [];
  _type_map[1] = "command"; 
  _type_map[2] = "response"; 
  _type_map[3] = "event"; 
  _type_map[4] = "error";

  var _handle_scope_message = function(service, message, command, status, tag)
  {
    var msg_name = _event_map[service][command], service_obj = _services[service];
    if (msg_name.indexOf('on') == 0)
    {
      service_obj[msg_name](status, message);
      service_obj.post_message(msg_name.slice(2).toLowerCase(), message);
    }
    else if (!tagManager.handle_message(tag, status, message))
    {
      service_obj[msg_name](status, message);
    }
  };

  var _handle_scope_message_debug = function(service, message, command, status, tag)
  {
    window.debug.log_message(service, message, command, status, tag);
    _handle_scope_message(service, message, command, status, tag);
  };

  // static methods

  (function()
  {

    this.get_event_map = function()
    {
      return _event_map;
    };

    this.get_status_map = function()
    {
      return _status_map;
    };

    this.get_type_map = function()
    {
      return _type_map;
    };

    this.get_generic_message_handler = function()
    {
      return window.ini && window.ini.debug && _handle_scope_message_debug || _handle_scope_message;
    };

    this.register_services = function(namespace)
    {
      _services = namespace;
    };

    this.populate_map = function(map)
    {
      for (var service in map)
      {
        if (service == "scope")
          continue;
        var cmd_map = _event_map[service] = [];
        for (var cmd_id in map[service])
        {
          if (map[service][cmd_id].name.slice(0, 2) == "On")
            cmd_map[cmd_id] = "on" + map[service][cmd_id].name.slice(2);
          else
            cmd_map[cmd_id] = "handle" + map[service][cmd_id].name;
        }
      }
    };

  }).apply(cls.ServiceBase);

};
